/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaAlterLogDirsThread$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Accepted$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Effective$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$None$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Queued$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011-a\u0001\u00028p\u0001QD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0003\u001f\u0001!\u0011!Q\u0001\n\u0005E\u0001BCA\f\u0001\t\u0005\t\u0015!\u0003\u0002\u001a!Q\u0011q\u0004\u0001\u0003\u0002\u0003\u0006I!!\t\t\u0015\u0005\u001d\u0002A!A!\u0002\u0013\tI\u0003\u0003\u0006\u0002D\u0001\u0011\t\u0011)A\u0005\u0003\u000bB!\"a\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA'\u0011)\t\u0019\u0006\u0001B\u0001B\u0003%\u0011Q\u000b\u0005\u000b\u0003S\u0002!\u0011!Q\u0001\n\u0005-\u0004bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\u000b\u0003\u001f\u0003!\u0019!C\u0001_\u0006E\u0005\u0002CB$\u0001\u0001\u0006I!a%\t\u000f\r%\u0003\u0001\"\u0015\u0004L!911\u000b\u0001\u0005R\rU\u0003bBB0\u0001\u0011E3\u0011\r\u0005\b\u0007K\u0002A\u0011KB4\u0011\u001d\u00199\b\u0001C!\u0007sBqa!)\u0001\t\u0003\u001a\u0019\u000bC\u0004\u0002h\u0002!Iaa/\t\u0011\r\u0005\u0007\u0001\"\u0001p\u0007\u0007Dqaa3\u0001\t\u0013\u0019i\rC\u0004\u0004b\u0002!\tea9\t\u000f\rE\b\u0001\"\u0011\u0004t\"9A\u0011\u0001\u0001\u0005R\u0011\rqaBA^_\"\u0005\u0011Q\u0018\u0004\u0007]>D\t!a0\t\u000f\u0005]$\u0004\"\u0001\u0002J\u001a1\u00111\u001a\u000eA\u0003\u001bD!\"a:\u001d\u0005+\u0007I\u0011AAu\u0011)\u0011y\n\bB\tB\u0003%\u00111\u001e\u0005\u000b\u0005Cc\"Q3A\u0005\u0002\t\r\u0006B\u0003BY9\tE\t\u0015!\u0003\u0003&\"Q!1\u0017\u000f\u0003\u0016\u0004%\tAa)\t\u0015\tUFD!E!\u0002\u0013\u0011)\u000bC\u0004\u0002xq!\tAa.\t\u000f\t\u0005G\u0004\"\u0001\u0003D\"I!\u0011\u001a\u000f\u0002\u0002\u0013\u0005!1\u001a\u0005\n\u0005'd\u0012\u0013!C\u0001\u0005+D\u0011Ba;\u001d#\u0003%\tA!<\t\u0013\tEH$%A\u0005\u0002\t5\b\"\u0003B\u000f9\u0005\u0005I\u0011\tB\u0010\u0011%\u0011Y\u0003HA\u0001\n\u0003\u0011i\u0003C\u0005\u00036q\t\t\u0011\"\u0001\u0003t\"I!1\t\u000f\u0002\u0002\u0013\u0005#Q\t\u0005\n\u0005'b\u0012\u0011!C\u0001\u0005oD\u0011Ba?\u001d\u0003\u0003%\tE!@\t\u0013\teC$!A\u0005B\tm\u0003\"\u0003B/9\u0005\u0005I\u0011\tB0\u0011%\u0019\t\u0001HA\u0001\n\u0003\u001a\u0019aB\u0005\u0004\bi\t\t\u0011#\u0001\u0004\n\u0019I\u00111\u001a\u000e\u0002\u0002#\u000511\u0002\u0005\b\u0003o\u001aD\u0011AB\u0012\u0011%\u0011ifMA\u0001\n\u000b\u0012y\u0006C\u0005\u0004&M\n\t\u0011\"!\u0004(!I1qF\u001a\u0002\u0002\u0013\u00055\u0011\u0007\u0005\n\u0005C\u001a\u0014\u0011!C\u0005\u0005G2\u0011\"a<\u001b!\u0003\r\t#!=\t\u000f\u0005M\u0018\b\"\u0001\u0002v\"9\u0011Q`\u001d\u0005\u0002\u0005}xaBB 5!\u0005!q\u0002\u0004\b\u0003_T\u0002\u0012\u0001B\u0006\u0011\u001d\t9(\u0010C\u0001\u0005\u001b9qA!\u0005>\u0011\u0003\u0013\u0019BB\u0004\u0003\u0018uB\tI!\u0007\t\u000f\u0005]\u0004\t\"\u0001\u0003\u001c!I!Q\u0004!\u0002\u0002\u0013\u0005#q\u0004\u0005\n\u0005W\u0001\u0015\u0011!C\u0001\u0005[A\u0011B!\u000eA\u0003\u0003%\tAa\u000e\t\u0013\t\r\u0003)!A\u0005B\t\u0015\u0003\"\u0003B*\u0001\u0006\u0005I\u0011\u0001B+\u0011%\u0011I\u0006QA\u0001\n\u0003\u0012Y\u0006C\u0005\u0003^\u0001\u000b\t\u0011\"\u0011\u0003`!I!\u0011\r!\u0002\u0002\u0013%!1M\u0004\b\u0005Wj\u0004\u0012\u0011B7\r\u001d\u0011y'\u0010EA\u0005cBq!a\u001eL\t\u0003\u0011\u0019\bC\u0004\u0002~.#\t%a@\t\u0013\tu1*!A\u0005B\t}\u0001\"\u0003B\u0016\u0017\u0006\u0005I\u0011\u0001B\u0017\u0011%\u0011)dSA\u0001\n\u0003\u0011)\bC\u0005\u0003D-\u000b\t\u0011\"\u0011\u0003F!I!1K&\u0002\u0002\u0013\u0005!\u0011\u0010\u0005\n\u00053Z\u0015\u0011!C!\u00057B\u0011B!\u0018L\u0003\u0003%\tEa\u0018\t\u0013\t\u00054*!A\u0005\n\t\rta\u0002B?{!\u0005%q\u0010\u0004\b\u0005\u0013i\u0004\u0012\u0011BJ\u0011\u001d\t9h\u0016C\u0001\u0005+Cq!!@X\t\u0003\ny\u0010C\u0005\u0003\u001e]\u000b\t\u0011\"\u0011\u0003 !I!1F,\u0002\u0002\u0013\u0005!Q\u0006\u0005\n\u0005k9\u0016\u0011!C\u0001\u0005/C\u0011Ba\u0011X\u0003\u0003%\tE!\u0012\t\u0013\tMs+!A\u0005\u0002\tm\u0005\"\u0003B-/\u0006\u0005I\u0011\tB.\u0011%\u0011ifVA\u0001\n\u0003\u0012y\u0006C\u0005\u0003b]\u000b\t\u0011\"\u0003\u0003d\u001d9!\u0011Q\u001f\t\u0002\n\rea\u0002BC{!\u0005%q\u0011\u0005\b\u0003o\u001aG\u0011\u0001BE\u0011%\u0011ibYA\u0001\n\u0003\u0012y\u0002C\u0005\u0003,\r\f\t\u0011\"\u0001\u0003.!I!QG2\u0002\u0002\u0013\u0005!1\u0012\u0005\n\u0005\u0007\u001a\u0017\u0011!C!\u0005\u000bB\u0011Ba\u0015d\u0003\u0003%\tAa$\t\u0013\te3-!A\u0005B\tm\u0003\"\u0003B/G\u0006\u0005I\u0011\tB0\u0011%\u0011\tgYA\u0001\n\u0013\u0011\u0019\u0007C\u0005\u0004Bi\t\n\u0011\"\u0001\u0004D\tI\"+\u001a9mS\u000e\f\u0017\t\u001c;fe2{w\rR5sgRC'/Z1e\u0015\t\u0001\u0018/\u0001\u0004tKJ4XM\u001d\u0006\u0002e\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001v!\t1x/D\u0001p\u0013\tAxNA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\t9\fW.\u001a\t\u0004w\u0006%ab\u0001?\u0002\u0006A\u0019Q0!\u0001\u000e\u0003yT!a`:\u0002\rq\u0012xn\u001c;?\u0015\t\t\u0019!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\b\u0005\u0005\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!AB*ue&twM\u0003\u0003\u0002\b\u0005\u0005\u0011A\u00027fC\u0012,'\u000fE\u0002w\u0003'I1!!\u0006p\u00059aU-\u00193fe\u0016sG\rU8j]R\f\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0007Y\fY\"C\u0002\u0002\u001e=\u0014\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002!A\fWo]3e!\u0006\u0014H/\u001b;j_:\u001c\bc\u0001<\u0002$%\u0019\u0011QE8\u0003!A\u000bWo]3e!\u0006\u0014H/\u001b;j_:\u001c\u0018AE3ya>tWM\u001c;jC2\u0014\u0015mY6pM\u001a\u0004B!a\u000b\u0002@5\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0003vi&d7O\u0003\u0003\u00024\u0005U\u0012AB2p[6|gNC\u0002s\u0003oQA!!\u000f\u0002<\u00051\u0011\r]1dQ\u0016T!!!\u0010\u0002\u0007=\u0014x-\u0003\u0003\u0002B\u00055\"AE#ya>tWM\u001c;jC2\u0014\u0015mY6pM\u001a\f!B]3qY&\u001c\u0017-T4s!\r1\u0018qI\u0005\u0004\u0003\u0013z'A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0006cV|G/\u0019\t\u0004m\u0006=\u0013bAA)_\n9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM]\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN\u0004B!a\u0016\u0002f5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&A\u0004nKR\u0014\u0018nY:\u000b\t\u0005}\u0013\u0011M\u0001\u0004Y><'\u0002BA2\u0003k\tqa\u001d;pe\u0006<W-\u0003\u0003\u0002h\u0005e#\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003U!\u0017N]3di>\u0014\u00180\u0012<f]RD\u0015M\u001c3mKJ\u0004B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0005\u0003g\t\tHC\u0002q\u0003kIA!!\u001e\u0002p\t)B)\u001b:fGR|'/_#wK:$\b*\u00198eY\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u000b\u0002|\u0005u\u0014qPAA\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0015Q\u0012\t\u0003m\u0002AQ!\u001f\u0006A\u0002iDq!a\u0004\u000b\u0001\u0004\t\t\u0002C\u0004\u0002\u0018)\u0001\r!!\u0007\t\u000f\u0005}!\u00021\u0001\u0002\"!9\u0011q\u0005\u0006A\u0002\u0005%\u0002bBA\"\u0015\u0001\u0007\u0011Q\t\u0005\b\u0003\u0017R\u0001\u0019AA'\u0011\u001d\t\u0019F\u0003a\u0001\u0003+B\u0011\"!\u001b\u000b!\u0003\u0005\r!a\u001b\u0002\u001fA\u0014x.\\8uS>t7\u000b^1uKN,\"!a%\u0011\u0011\u0005U\u00151UAT\u0003_k!!a&\u000b\t\u0005e\u00151T\u0001\u000bG>t7-\u001e:sK:$(\u0002BAO\u0003?\u000bA!\u001e;jY*\u0011\u0011\u0011U\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002&\u0006]%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u0011\u0011VAV\u001b\t\t\t$\u0003\u0003\u0002.\u0006E\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004\u0003ccbbAAZ39!\u0011QWA]\u001d\ri\u0018qW\u0005\u0002e&\u0011\u0001/]\u0001\u001a%\u0016\u0004H.[2b\u00032$XM\u001d'pO\u0012K'o\u001d+ie\u0016\fG\r\u0005\u0002w5M\u0019!$!1\u0011\t\u0005\r\u0017QY\u0007\u0003\u0003\u0003IA!a2\u0002\u0002\t1\u0011I\\=SK\u001a$\"!!0\u0003\u001dA\u0013x.\\8uS>t7\u000b^1uKN9A$!1\u0002P\u0006U\u0007\u0003BAb\u0003#LA!a5\u0002\u0002\t9\u0001K]8ek\u000e$\b\u0003BAl\u0003CtA!!7\u0002^:\u0019Q0a7\n\u0005\u0005\r\u0011\u0002BAp\u0003\u0003\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002d\u0006\u0015(\u0001D*fe&\fG.\u001b>bE2,'\u0002BAp\u0003\u0003\t\u0011C]3bgNLwM\\7f]R\u001cF/\u0019;f+\t\tY\u000fE\u0002\u0002nfj\u0011A\u0007\u0002\u0012%\u0016\f7o]5h]6,g\u000e^*uCR,7cA\u001d\u0002B\u00061A%\u001b8ji\u0012\"\"!a>\u0011\t\u0005\r\u0017\u0011`\u0005\u0005\u0003w\f\tA\u0001\u0003V]&$\u0018!G7bs\n,\u0017J\\2p]NL7\u000f^3oi6+G/\u00193bi\u0006,\"A!\u0001\u0011\t\u0005\r'1A\u0005\u0005\u0005\u000b\t\tAA\u0004C_>dW-\u00198*\u000be:6\rQ&\u0003\u0011\u0005\u001b7-\u001a9uK\u0012\u001c2!PAa)\t\u0011y\u0001E\u0002\u0002nv\nAAT8oKB\u0019!Q\u0003!\u000e\u0003u\u0012AAT8oKNI\u0001)!1\u0002l\u0006=\u0017Q\u001b\u000b\u0003\u0005'\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0011!\u0011\u0011\u0019C!\u000b\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0003?\u000bA\u0001\\1oO&!\u00111\u0002B\u0013\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011y\u0003\u0005\u0003\u0002D\nE\u0012\u0002\u0002B\u001a\u0003\u0003\u00111!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u000f\u0003@A!\u00111\u0019B\u001e\u0013\u0011\u0011i$!\u0001\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003B\u0011\u000b\t\u00111\u0001\u00030\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0012\u0011\r\t%#q\nB\u001d\u001b\t\u0011YE\u0003\u0003\u0003N\u0005\u0005\u0011AC2pY2,7\r^5p]&!!\u0011\u000bB&\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\u0005!q\u000b\u0005\n\u0005\u00032\u0015\u0011!a\u0001\u0005s\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005_\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005C\tAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u001a\u0011\t\t\r\"qM\u0005\u0005\u0005S\u0012)C\u0001\u0004PE*,7\r^\u0001\u0007#V,W/\u001a3\u0011\u0007\tU1J\u0001\u0004Rk\u0016,X\rZ\n\n\u0017\u0006\u0005\u00171^Ah\u0003+$\"A!\u001c\u0015\t\te\"q\u000f\u0005\n\u0005\u0003\u0002\u0016\u0011!a\u0001\u0005_!BA!\u0001\u0003|!I!\u0011\t*\u0002\u0002\u0003\u0007!\u0011H\u0001\t\u0003\u000e\u001cW\r\u001d;fIB\u0019!QC,\u0002\u0013\u00153g-Z2uSZ,\u0007c\u0001B\u000bG\nIQI\u001a4fGRLg/Z\n\nG\u0006\u0005\u00171^Ah\u0003+$\"Aa!\u0015\t\te\"Q\u0012\u0005\n\u0005\u0003:\u0017\u0011!a\u0001\u0005_!BA!\u0001\u0003\u0012\"I!\u0011I5\u0002\u0002\u0003\u0007!\u0011H\n\n/\u0006\u0005\u00171^Ah\u0003+$\"Aa \u0015\t\te\"\u0011\u0014\u0005\n\u0005\u0003b\u0016\u0011!a\u0001\u0005_!BA!\u0001\u0003\u001e\"I!\u0011\t0\u0002\u0002\u0003\u0007!\u0011H\u0001\u0013e\u0016\f7o]5h]6,g\u000e^*uCR,\u0007%A\u0004u_BL7-\u00133\u0016\u0005\t\u0015\u0006CBAb\u0005O\u0013Y+\u0003\u0003\u0003*\u0006\u0005!AB(qi&|g\u000e\u0005\u0003\u0002*\n5\u0016\u0002\u0002BX\u0003c\u0011A!V;jI\u0006AAo\u001c9jG&#\u0007%\u0001\u0006dkJ\u0014XM\u001c;ESJ\f1bY;se\u0016tG\u000fR5sAQA!\u0011\u0018B^\u0005{\u0013y\fE\u0002\u0002nrAq!a:$\u0001\u0004\tY\u000fC\u0004\u0003\"\u000e\u0002\rA!*\t\u000f\tM6\u00051\u0001\u0003&\u0006qq/\u001b;i\u0003N\u001c\u0018n\u001a8nK:$H\u0003\u0002B]\u0005\u000bDqAa2%\u0001\u0004\tY/A\foK^$\u0015N\u001d*fCN\u001c\u0018n\u001a8nK:$8\u000b^1uK\u0006!1m\u001c9z)!\u0011IL!4\u0003P\nE\u0007\"CAtKA\u0005\t\u0019AAv\u0011%\u0011\t+\nI\u0001\u0002\u0004\u0011)\u000bC\u0005\u00034\u0016\u0002\n\u00111\u0001\u0003&\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BlU\u0011\tYO!7,\u0005\tm\u0007\u0003\u0002Bo\u0005Ol!Aa8\u000b\t\t\u0005(1]\u0001\nk:\u001c\u0007.Z2lK\u0012TAA!:\u0002\u0002\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%(q\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005_TCA!*\u0003Z\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aD\u0003\u0002B\u001d\u0005kD\u0011B!\u0011,\u0003\u0003\u0005\rAa\f\u0015\t\t\u0005!\u0011 \u0005\n\u0005\u0003j\u0013\u0011!a\u0001\u0005s\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!\u0011\u0005B\u0000\u0011%\u0011\tELA\u0001\u0002\u0004\u0011y#\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u0003\u0019)\u0001C\u0005\u0003BE\n\t\u00111\u0001\u0003:\u0005q\u0001K]8n_RLwN\\*uCR,\u0007cAAwgM)1g!\u0004\u0004\u001aAa1qBB\u000b\u0003W\u0014)K!*\u0003:6\u00111\u0011\u0003\u0006\u0005\u0007'\t\t!A\u0004sk:$\u0018.\\3\n\t\r]1\u0011\u0003\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003BB\u000e\u0007Ci!a!\b\u000b\t\r}\u0011qT\u0001\u0003S>LA!a9\u0004\u001eQ\u00111\u0011B\u0001\u0006CB\u0004H.\u001f\u000b\t\u0005s\u001bIca\u000b\u0004.!9\u0011q\u001d\u001cA\u0002\u0005-\bb\u0002BQm\u0001\u0007!Q\u0015\u0005\b\u0005g3\u0004\u0019\u0001BS\u0003\u001d)h.\u00199qYf$Baa\r\u0004<A1\u00111\u0019BT\u0007k\u0001\"\"a1\u00048\u0005-(Q\u0015BS\u0013\u0011\u0019I$!\u0001\u0003\rQ+\b\u000f\\34\u0011%\u0019idNA\u0001\u0002\u0004\u0011I,A\u0002yIA\n\u0011CU3bgNLwM\\7f]R\u001cF/\u0019;f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u00111Q\t\u0016\u0005\u0003W\u0012I.\u0001\tqe>lw\u000e^5p]N#\u0018\r^3tA\u0005YA.\u0019;fgR,\u0005o\\2i)\u0011\u0019iea\u0014\u0011\r\u0005\r'q\u0015B\u0018\u0011\u001d\u0019\t&\u0004a\u0001\u0003O\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\t\r]3Q\f\t\u0005\u0003\u0007\u001cI&\u0003\u0003\u0004\\\u0005\u0005!\u0001\u0002'p]\u001eDqa!\u0015\u000f\u0001\u0004\t9+\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0006\u0003\u0004X\r\r\u0004bBB)\u001f\u0001\u0007\u0011qU\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGCBB5\u0007c\u001a\u0019\b\u0005\u0004\u0002D\n\u001d61\u000e\t\u0005\u0003[\u001ai'\u0003\u0003\u0004p\u0005=$AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\b\u0007#\u0002\u0002\u0019AAT\u0011\u001d\u0019)\b\u0005a\u0001\u0005_\tQ!\u001a9pG\"\fA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fGCCB>\u0007\u0017\u001bii!%\u0004\u0016B1\u00111\u0019BT\u0007{\u0002Baa \u0004\b6\u00111\u0011\u0011\u0006\u0005\u0003?\u001a\u0019I\u0003\u0003\u0004\u0006\u0006\u0005\u0014!C5oi\u0016\u0014h.\u00197t\u0013\u0011\u0019Ii!!\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\u0019\t&\u0005a\u0001\u0003OCqaa$\u0012\u0001\u0004\u00199&A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bbBBJ#\u0001\u0007!qF\u0001\u0015a\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016\u0003xn\u00195\t\u000f\r]\u0015\u00031\u0001\u0004\u001a\u0006i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004Baa'\u0004\u001e6\t\u0001!C\u0002\u0004 ^\u0014\u0011BR3uG\"$\u0015\r^1\u0002!I,Wn\u001c<f!\u0006\u0014H/\u001b;j_:\u001cH\u0003BBS\u0007c\u0003\u0002B!\u0013\u0004(\u0006\u001d61V\u0005\u0005\u0007S\u0013YEA\u0002NCB\u00042A^BW\u0013\r\u0019yk\u001c\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/\u001a\u0005\b\u0007g\u0013\u0002\u0019AB[\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bC\u0002B%\u0007o\u000b9+\u0003\u0003\u0004:\n-#aA*fiR!1QXB`!\r\t\t,\u000f\u0005\b\u0007#\u001a\u0002\u0019AAT\u0003])\b\u000fZ1uKJ+\u0017m]:jO:lWM\u001c;Ti\u0006$X\r\u0006\u0004\u0002x\u000e\u00157q\u0019\u0005\b\u0007#\"\u0002\u0019AAT\u0011\u001d\u0019I\r\u0006a\u0001\u0007{\u000bQa\u001d;bi\u0016\f\u0011$\\1zE\u0016\u0004&o\\7pi\u00164U\u000f^;sKJ+\u0007\u000f\\5dCR1!\u0011HBh\u0007#Dqa!\u0015\u0016\u0001\u0004\t9\u000bC\u0004\u0004TV\u0001\ra!6\u0002\u0013A\f'\u000f^5uS>t\u0007\u0003BBl\u0007;l!a!7\u000b\u0007\rm\u0017/A\u0004dYV\u001cH/\u001a:\n\t\r}7\u0011\u001c\u0002\n!\u0006\u0014H/\u001b;j_:\fQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0003BB[\u0007KDqaa:\u0017\u0001\u0004\u0019I/\u0001\nj]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\u001c\b\u0003\u0003B%\u0007O\u000b9ka;\u0011\u0007Y\u001ci/C\u0002\u0004p>\u0014\u0011#\u00138ji&\fGNR3uG\"\u001cF/\u0019;f\u0003!!(/\u001e8dCR,GC\u0002B\u0001\u0007k\u001c9\u0010C\u0004\u0004R]\u0001\r!a*\t\u000f\rex\u00031\u0001\u0004|\u0006yAO];oG\u0006$\u0018n\u001c8Ti\u0006$X\rE\u0002w\u0007{L1aa@p\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fq\u0003\u001e:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;\u0015\r\u0005]HQ\u0001C\u0004\u0011\u001d\u0019\t\u0006\u0007a\u0001\u0003OCq\u0001\"\u0003\u0019\u0001\u0004\u00199&\u0001\u0004pM\u001a\u001cX\r\u001e")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final DirectoryEventHandler directoryEventHandler;
    private final ConcurrentHashMap<TopicPartition, PromotionState> promotionStates;

    public static DirectoryEventHandler $lessinit$greater$default$9() {
        return ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$9();
    }

    public ConcurrentHashMap<TopicPartition, PromotionState> promotionStates() {
        return this.promotionStates;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        AbstractLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{topicPartition, BoxesRunTime.boxToLong(fetchOffset), BoxesRunTime.boxToLong(futureLog.logEndOffset())})));
        }
        None$ logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true, partitionLeaderEpoch) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        DirectoryEventHandler directoryEventHandler = this.directoryEventHandler;
        DirectoryEventHandler directoryEventHandler2 = DirectoryEventHandler.NOOP;
        DirectoryEventHandler directoryEventHandler3 = directoryEventHandler;
        if (!(directoryEventHandler2 != null ? !directoryEventHandler2.equals(directoryEventHandler3) : directoryEventHandler3 != null)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.removePartitions((Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
            }
        } else {
            this.maybePromoteFutureReplica(topicPartition, partition);
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        topicPartitions.foreach((Function1<TopicPartition, Object> & Serializable)topicPartition -> {
            if (this.promotionStates().containsKey(topicPartition)) {
                PromotionState promotionState = this.promotionStates().get(topicPartition);
                if (promotionState == null) {
                    throw new MatchError(promotionState);
                }
                ReassignmentState reassignmentState = promotionState.reassignmentState();
                Option<Uuid> topicId = promotionState.topicId();
                Option<Uuid> originalDir = promotionState.currentDir();
                Tuple3<ReassignmentState, Option<Uuid>, Option<Uuid>> tuple3 = new Tuple3<ReassignmentState, Option<Uuid>, Option<Uuid>>(reassignmentState, topicId, originalDir);
                ReassignmentState reassignmentState2 = tuple3._1();
                Option<Uuid> topicId2 = tuple3._2();
                Option<Uuid> originalDir2 = tuple3._3();
                if (originalDir2.isDefined() && topicId2.isDefined() && reassignmentState2.maybeInconsistentMetadata()) {
                    $this.directoryEventHandler.handleAssignment(new TopicIdPartition(topicId2.get(), topicPartition.partition()), originalDir2.get(), "Reverting reassignment for canceled future replica", () -> {});
                }
                return this.promotionStates().remove(topicPartition);
            }
            return BoxedUnit.UNIT;
        });
        return super.removePartitions(topicPartitions);
    }

    private ReassignmentState reassignmentState(TopicPartition topicPartition) {
        return this.promotionStates().get(topicPartition).reassignmentState();
    }

    public void updateReassignmentState(TopicPartition topicPartition, ReassignmentState state) {
        this.debug((Function0<String> & Serializable)() -> "Updating future replica " + topicPartition + " reassignment state to " + state);
        this.promotionStates().put(topicPartition, this.promotionStates().get(topicPartition).withAssignment(state));
    }

    private Object maybePromoteFutureReplica(TopicPartition topicPartition, Partition partition) {
        Option<Uuid> topicId = partition.topicId();
        if (topicId.isEmpty()) {
            throw new IllegalStateException("Topic " + topicPartition.topic() + " does not have an ID.");
        }
        ReassignmentState reassignmentState = this.reassignmentState(topicPartition);
        if (ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$.equals(reassignmentState)) {
            return BoxesRunTime.boxToBoolean(partition.runCallbackIfFutureReplicaCaughtUp((Function1<AbstractLog, BoxedUnit>)(Function1<AbstractLog, Object> & Serializable)x$2 -> {
                ReplicaAlterLogDirsThread.$anonfun$maybePromoteFutureReplica$1(this, partition, topicId, topicPartition, x$2);
                return BoxedUnit.UNIT;
            }));
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$.equals(reassignmentState)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.updateReassignmentState(topicPartition, ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$);
                return this.removePartitions((Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
            }
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$.equals(reassignmentState)) {
            this.trace((Function0<String> & Serializable)() -> "Waiting for AssignReplicasToDirsRequest to succeed before promoting the future replica.");
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$.equals(reassignmentState)) {
            throw new IllegalStateException("BUG: trying to promote a future replica twice");
        }
        throw new MatchError(reassignmentState);
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            filteredFetchStates.foreach((Function1<Tuple2, PromotionState> & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    InitialFetchState state = (InitialFetchState)tuple2._2();
                    Option<Uuid> topicId = state.topicId();
                    Option<Uuid> currentDirectoryId = $this.replicaMgr.getPartitionOrException(topicPartition).logDirectoryId();
                    PromotionState promotionState = new PromotionState(ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$, topicId, currentDirectoryId);
                    return this.promotionStates().put(topicPartition, promotionState);
                }
                throw new MatchError(tuple2);
            });
            set = super.addPartitions(filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateTo(truncationState.offset(), true);
        return true;
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, true, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$maybePromoteFutureReplica$1(ReplicaAlterLogDirsThread $this, Partition partition$1, Option topicId$1, TopicPartition topicPartition$2, AbstractLog x$2) {
        Uuid targetDir = partition$1.futureReplicaDirectoryId().get();
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)topicId$1.get(), topicPartition$2.partition());
        $this.directoryEventHandler.handleAssignment(topicIdPartition, targetDir, "Future replica promotion", () -> $this.updateReassignmentState(topicPartition$2, ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$));
        $this.updateReassignmentState(topicPartition$2, ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            return $this.replicaMgr.futureLogExists(tp);
        }
        throw new MatchError(tuple2);
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats, DirectoryEventHandler directoryEventHandler) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.directoryEventHandler = directoryEventHandler;
        String x$1 = name;
        String x$2 = name;
        LeaderEndPoint x$3 = leader;
        TierStateMachine x$4 = new TierStateMachine(leader, replicaMgr, false);
        FailedPartitions x$5 = failedPartitions;
        PausedPartitions x$6 = pausedPartitions;
        ExponentialBackoff x$7 = exponentialBackoff;
        boolean x$8 = false;
        BrokerTopicStats x$9 = brokerTopicStats;
        Map<String, String> x$10 = AbstractFetcherThread$.MODULE$.$lessinit$greater$default$10();
        super(x$1, x$2, x$3, x$5, x$6, x$7, x$4, false, x$9, x$10);
        this.promotionStates = new ConcurrentHashMap();
    }

    public static class PromotionState
    implements Product,
    Serializable {
        private final ReassignmentState reassignmentState;
        private final Option<Uuid> topicId;
        private final Option<Uuid> currentDir;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public ReassignmentState reassignmentState() {
            return this.reassignmentState;
        }

        public Option<Uuid> topicId() {
            return this.topicId;
        }

        public Option<Uuid> currentDir() {
            return this.currentDir;
        }

        public PromotionState withAssignment(ReassignmentState newDirReassignmentState) {
            return new PromotionState(newDirReassignmentState, this.topicId(), this.currentDir());
        }

        public PromotionState copy(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            return new PromotionState(reassignmentState, topicId, currentDir);
        }

        public ReassignmentState copy$default$1() {
            return this.reassignmentState();
        }

        public Option<Uuid> copy$default$2() {
            return this.topicId();
        }

        public Option<Uuid> copy$default$3() {
            return this.currentDir();
        }

        @Override
        public String productPrefix() {
            return "PromotionState";
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.reassignmentState();
                }
                case 1: {
                    return this.topicId();
                }
                case 2: {
                    return this.currentDir();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof PromotionState;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "reassignmentState";
                }
                case 1: {
                    return "topicId";
                }
                case 2: {
                    return "currentDir";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PromotionState)) return false;
            boolean bl = true;
            if (!bl) return false;
            PromotionState promotionState = (PromotionState)x$1;
            ReassignmentState reassignmentState = this.reassignmentState();
            ReassignmentState reassignmentState2 = promotionState.reassignmentState();
            if (reassignmentState == null) {
                if (reassignmentState2 != null) {
                    return false;
                }
            } else if (!reassignmentState.equals(reassignmentState2)) return false;
            Option<Uuid> option = this.topicId();
            Option<Uuid> option2 = promotionState.topicId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Uuid> option3 = this.currentDir();
            Option<Uuid> option4 = promotionState.currentDir();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!promotionState.canEqual(this)) return false;
            return true;
        }

        public PromotionState(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            this.reassignmentState = reassignmentState;
            this.topicId = topicId;
            this.currentDir = currentDir;
            Product.$init$(this);
        }
    }

    public static interface ReassignmentState {
        public static /* synthetic */ boolean maybeInconsistentMetadata$(ReassignmentState $this) {
            return $this.maybeInconsistentMetadata();
        }

        default public boolean maybeInconsistentMetadata() {
            return false;
        }

        public static void $init$(ReassignmentState $this) {
        }
    }
}

