/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.ConfluentReplicaFetcherTierStateMachine;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LeaderHwChange;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t-c\u0001\u0002\u0016,\u0001AB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"I\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0014\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!I\u0006A!A!\u0002\u0013Q\u0006\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011-\u0004!\u0011!Q\u0001\n1D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\tm\u0002\u0011\t\u0011)A\u0005o\"AQ\u0010\u0001B\u0001B\u0003%a\u0010C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0002bBA\u0019\u0001\u0001\u0006I\u0001\u0012\u0005\n\u0003g\u0001!\u0019!C\u0005\u0003kAq!a\u000e\u0001A\u0003%1\u000f\u0003\u0006\u0002:\u0001\u0011\r\u0011\"\u0001,\u0003wA\u0001\"!\u0015\u0001A\u0003%\u0011Q\b\u0005\n\u0003'\u0002!\u0019!C)\u0003+B\u0001\"!\u0018\u0001A\u0003%\u0011q\u000b\u0005\b\u0003?\u0002A\u0011KA1\u0011\u001d\tI\u0007\u0001C)\u0003WBq!!\u001e\u0001\t#\n9\bC\u0004\u0002|\u0001!\t&! \t\u000f\u00055\u0005\u0001\"\u0015\u0002\u0010\"9\u0011\u0011\u0015\u0001\u0005B\u0005\r\u0006bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\b\u0003S\u0003A\u0011IAT\u0011\u001d\tY\u000b\u0001C!\u0003[C\u0001\"a7\u0001\t\u0003Y\u0013q\u0015\u0005\b\u0003;\u0004A\u0011AAp\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDqA!\u0002\u0001\t#\u00119\u0001C\u0004\u0003\u0012\u0001!\tFa\u0005\t\u001b\tm\u0001\u0001%A\u0002\u0002\u0003%IA!\bM\u000f%\u0011ybKA\u0001\u0012\u0003\u0011\tC\u0002\u0005+W\u0005\u0005\t\u0012\u0001B\u0012\u0011\u001d\tyA\nC\u0001\u0005WA\u0011B!\f'#\u0003%\tAa\f\t\u0013\t\u0015c%%A\u0005\u0002\t\u001d#\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002-[\u000511/\u001a:wKJT\u0011AL\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0007\u0005\u00023g5\t1&\u0003\u00025W\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0001\u00028b[\u0016\u0004\"a\u000e!\u000f\u0005ar\u0004CA\u001d=\u001b\u0005Q$BA\u001e0\u0003\u0019a$o\\8u})\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\tyD(A\u0005gKR\u001c\u0007.\u001a:JIB\u0011QIR\u0007\u0002y%\u0011q\t\u0010\u0002\u0004\u0013:$\u0018A\u00027fC\u0012,'\u000f\u0005\u00023\u0015&\u00111j\u000b\u0002\u000f\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u\u0013\tA5'\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u00023\u001f&\u0011\u0001k\u000b\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\tgC&dW\r\u001a)beRLG/[8ogB\u0011!gU\u0005\u0003).\u0012\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002!A\fWo]3e!\u0006\u0014H/\u001b;j_:\u001c\bC\u0001\u001aX\u0013\tA6F\u0001\tQCV\u001cX\r\u001a)beRLG/[8og\u0006\u0011R\r\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4g!\tYV-D\u0001]\u0015\tif,A\u0003vi&d7O\u0003\u0002`A\u000611m\\7n_:T!AL1\u000b\u0005\t\u001c\u0017AB1qC\u000eDWMC\u0001e\u0003\ry'oZ\u0005\u0003Mr\u0013!#\u0012=q_:,g\u000e^5bY\n\u000b7m[8gM\u0006Q!/\u001a9mS\u000e\fWj\u001a:\u0011\u0005IJ\u0017B\u00016,\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fQ!];pi\u0006\u0004\"AM7\n\u00059\\#\u0001\u0004*fa2L7-Y)v_R\f\u0017!\u00047pO\u000e{g\u000e^3yi>\u0003H\u000fE\u0002FcNL!A\u001d\u001f\u0003\r=\u0003H/[8o!\tYF/\u0003\u0002v9\nQAj\\4D_:$X\r\u001f;\u0002\u001f\u0015DHO]1NKR\u0014\u0018n\u0019+bON\u0004B\u0001_>7m5\t\u0011P\u0003\u0002{y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005qL(aA'ba\u00069R.\u001a;bI\u0006$\u0018MV3sg&|gnU;qa2LWM\u001d\t\u0005\u000b~\f\u0019!C\u0002\u0002\u0002q\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1aXA\u0005\u0015\ta\u0003-\u0003\u0003\u0002\u000e\u0005\u001d!aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002\rqJg.\u001b;?)i\t\u0019\"!\u0006\u0002\u0018\u0005e\u00111DA\u000f\u0003?\t\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016!\t\u0011\u0004\u0001C\u00036\u001b\u0001\u0007a\u0007C\u0003D\u001b\u0001\u0007A\tC\u0003I\u001b\u0001\u0007\u0011\nC\u0003N\u001b\u0001\u0007a\nC\u0003R\u001b\u0001\u0007!\u000bC\u0003V\u001b\u0001\u0007a\u000bC\u0003Z\u001b\u0001\u0007!\fC\u0003h\u001b\u0001\u0007\u0001\u000eC\u0003l\u001b\u0001\u0007A\u000eC\u0004p\u001bA\u0005\t\u0019\u00019\t\u000fYl\u0001\u0013!a\u0001o\")Q0\u0004a\u0001}\u0006I!/\u001a9mS\u000e\f\u0017\nZ\u000b\u0002\t\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u00151|wmQ8oi\u0016DH/F\u0001t\u0003-awnZ\"p]R,\u0007\u0010\u001e\u0011\u0002=A\f'\u000f^5uS>t7oV5uQ:+w\u000fS5hQ^\u000bG/\u001a:nCJ\\WCAA\u001f!\u0019\ty$!\u0012\u0002J5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007J\u0018aB7vi\u0006\u0014G.Z\u0005\u0005\u0003\u000f\n\tE\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0003\u0017\ni%D\u0001_\u0013\r\tyE\u0018\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003}\u0001\u0018M\u001d;ji&|gn],ji\"tUm\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000eI\u0001\u001aiJ\fgn]5uS>tGk\u001c)vg\"\u001cV\u000f\u001d9peR,G-\u0006\u0002\u0002XA\u0019Q)!\u0017\n\u0007\u0005mCHA\u0004C_>dW-\u00198\u00025Q\u0014\u0018M\\:ji&|g\u000eV8QkND7+\u001e9q_J$X\r\u001a\u0011\u0002\u00171\fG/Z:u\u000bB|7\r\u001b\u000b\u0005\u0003G\n)\u0007E\u0002Fc\u0012Cq!a\u001a\u0017\u0001\u0004\tI%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002\u001d1|wm\u0015;beR|eMZ:fiR!\u0011QNA:!\r)\u0015qN\u0005\u0004\u0003cb$\u0001\u0002'p]\u001eDq!a\u001a\u0018\u0001\u0004\tI%\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0006\u0003\u0002n\u0005e\u0004bBA41\u0001\u0007\u0011\u0011J\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGCBA@\u0003\u000f\u000bI\t\u0005\u0003Fc\u0006\u0005\u0005\u0003BA\u0003\u0003\u0007KA!!\"\u0002\b\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007bBA43\u0001\u0007\u0011\u0011\n\u0005\u0007\u0003\u0017K\u0002\u0019\u0001#\u0002\u000b\u0015\u0004xn\u00195\u00023\rDWmY6q_&tGOU3d_Z,'/_(gMN,Go\u001d\u000b\u0005\u0003#\u000b9\nE\u0002F\u0003'K1!!&=\u0005\u0011)f.\u001b;\t\u000f\u0005e%\u00041\u0001\u0002\u001c\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000fE\u0003y\u0003;\u000bI%C\u0002\u0002 f\u00141aU3r\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000e\u0006\u0002\u0002X\u0005i\u0011m^1jiNCW\u000f\u001e3po:$\"!!%\u0002\r\u0011|wk\u001c:l\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRQ\u0011qVAc\u0003\u000f\fY-a4\u0011\t\u0015\u000b\u0018\u0011\u0017\t\u0005\u0003g\u000b\t-\u0004\u0002\u00026*!\u0011qWA]\u0003\rawn\u001a\u0006\u0005\u0003w\u000bi,A\u0005j]R,'O\\1mg*\u0019\u0011q\u00181\u0002\u000fM$xN]1hK&!\u00111YA[\u00055aunZ!qa\u0016tG-\u00138g_\"9\u0011q\r\u0010A\u0002\u0005%\u0003bBAe=\u0001\u0007\u0011QN\u0001\fM\u0016$8\r[(gMN,G\u000f\u0003\u0004\u0002Nz\u0001\r\u0001R\u0001\u0015a\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016\u0003xn\u00195\t\u000f\u0005Eg\u00041\u0001\u0002T\u0006i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004B!!6\u0002X6\t\u0001!C\u0002\u0002ZN\u0012\u0011BR3uG\"$\u0015\r^1\u00029\r|W\u000e\u001d7fi\u0016$U\r\\1zK\u00124U\r^2i%\u0016\fX/Z:ug\u0006YR.Y=cK^\u000b'O\\%g\u001fZ,'o]5{K\u0012\u0014VmY8sIN$b!!%\u0002b\u0006E\bbBArA\u0001\u0007\u0011Q]\u0001\be\u0016\u001cwN\u001d3t!\u0011\t9/!<\u000e\u0005\u0005%(bAAv=\u00061!/Z2pe\u0012LA!a<\u0002j\niQ*Z7pef\u0014VmY8sINDq!a\u001a!\u0001\u0004\tI%\u0001\u0005ueVt7-\u0019;f)\u0019\t9&a>\u0002|\"9\u0011\u0011`\u0011A\u0002\u0005%\u0013A\u0001;q\u0011\u001d\ti0\ta\u0001\u0003\u007f\fQc\u001c4gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X\rE\u00023\u0005\u0003I1Aa\u0001,\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fA\u0002Z8UeVt7-\u0019;j_:$\u0002\"a\u0016\u0003\n\t-!Q\u0002\u0005\b\u0003s\u0014\u0003\u0019AA%\u0011\u001d\tiP\ta\u0001\u0003\u007fDqAa\u0004#\u0001\u0004\t9&\u0001\u0005jg6K'O]8s\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000f\u0006\u0004\u0002\u0012\nU!q\u0003\u0005\b\u0003O\u001a\u0003\u0019AA%\u0011\u001d\u0011Ib\ta\u0001\u0003[\naa\u001c4gg\u0016$\u0018\u0001D:va\u0016\u0014H\u0005\\3bI\u0016\u0014X#A%\u0002)I+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e!\t\u0011deE\u0002'\u0005K\u00012!\u0012B\u0014\u0013\r\u0011I\u0003\u0010\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u0005\u0012\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005cQ3\u0001\u001dB\u001aW\t\u0011)\u0004\u0005\u0003\u00038\t\u0005SB\u0001B\u001d\u0015\u0011\u0011YD!\u0010\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r#\u0011\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'M\u000b\u0003\u0005\u0013R3a\u001eB\u001a\u0001")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final int replicaId;
    private final LogContext logContext;
    private final Buffer<TopicPartition> partitionsWithNewHighWatermark;
    private final boolean transitionToPushSupported;

    public static Map<String, String> $lessinit$greater$default$11() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$11();
    }

    public static Option<LogContext> $lessinit$greater$default$10() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
    }

    private /* synthetic */ LeaderEndPoint super$leader() {
        return super.leader();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public Buffer<TopicPartition> partitionsWithNewHighWatermark() {
        return this.partitionsWithNewHighWatermark;
    }

    @Override
    public boolean transitionToPushSupported() {
        return this.transitionToPushSupported;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public void checkpointRecoveryOffsets(Seq<TopicPartition> topicPartitions) {
        if (topicPartitions.isEmpty()) {
            return;
        }
        Object affectedLogs = ArrayBuffer$.MODULE$.empty();
        topicPartitions.foreach(arg_0 -> ReplicaFetcherThread.$anonfun$checkpointRecoveryOffsets$1$adapted(this, (ArrayBuffer)affectedLogs, arg_0));
        ((IterableOnceOps)((SeqOps)((ArrayBuffer)affectedLogs).map((Function1<AbstractLog, File> & Serializable)x$1 -> x$1.parentDirFile())).distinct()).foreach((Function1<File, Object> & Serializable)dir -> {
            ReplicaFetcherThread.$anonfun$checkpointRecoveryOffsets$4(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean initiateShutdown() {
        boolean justShutdown;
        block2: {
            justShutdown = super.initiateShutdown();
            if (!justShutdown) break block2;
            try {
                super.leader().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String> & Serializable)() -> "Failed to initiate shutdown of leader endpoint " + this.super$leader() + " after initiating replica fetcher thread shutdown", (Function0<Throwable> & Serializable)() -> t);
            }
        }
        return justShutdown;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            super.leader().close();
        }
        catch (Throwable t) {
            this.error((Function0<String> & Serializable)() -> "Failed to close leader endpoint " + this.super$leader() + " after shutting down replica fetcher thread", (Function0<Throwable> & Serializable)() -> t);
        }
    }

    @Override
    public void doWork() {
        super.doWork();
        this.completeDelayedFetchRequests();
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
        Option<LogAppendInfo> logAppendInfo;
        block0: {
            MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
            this.maybeWarnIfOversizedRecords(records, topicPartition);
            logAppendInfo = this.replicaMgr.appendRecordsToFollowerReplica(topicPartition, fetchOffset, AppendOrigin.REPLICATION, -1L, Optional.of(Predef$.MODULE$.int2Integer(partitionLeaderEpoch)), records, partitionData.highWatermark(), Optional.of(BoxesRunTime.boxToLong(partitionData.logStartOffset())), this.quota);
            Object object = logAppendInfo.exists((Function1<LogAppendInfo, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(ReplicaFetcherThread.$anonfun$processPartitionData$1(x$2))) ? this.partitionsWithNewHighWatermark().$plus$eq(topicPartition) : BoxedUnit.UNIT;
            if (records.sizeInBytes() <= 0) break block0;
            this.brokerTopicStats().topicStats(topicPartition.topic()).totalFollowerFetchRequestRate().mark();
            this.brokerTopicStats().allTopicsStats().totalFollowerFetchRequestRate().mark();
        }
        return logAppendInfo;
    }

    public void completeDelayedFetchRequests() {
        if (this.partitionsWithNewHighWatermark().nonEmpty()) {
            this.replicaMgr.completeDelayedFetchRequests(this.partitionsWithNewHighWatermark().toSeq());
            this.partitionsWithNewHighWatermark().clear();
            return;
        }
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (this.metadataVersionSupplier.apply().fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String> & Serializable)() -> "Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition " + topicPartition + ". This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be equal or larger than your settings for max.message.bytes, both at a broker and topic level.");
            return;
        }
    }

    @Override
    public boolean truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        return this.doTruncation(tp, offsetTruncationState, false);
    }

    public boolean doTruncation(TopicPartition tp, OffsetTruncationState offsetTruncationState, boolean isMirror) {
        block6: {
            Partition partition = this.replicaMgr.getPartitionOrException(tp);
            AbstractLog log = partition.localLogOrException();
            if (offsetTruncationState.offset() < log.highWatermark()) {
                if (!partition.isUncleanLeader()) {
                    if (partition.isActiveLinkDestinationLeader()) {
                        this.replicaMgr.clusterLinkTruncationBelowHWM().mark();
                    } else {
                        this.replicaMgr.truncationBelowHWM().mark();
                    }
                }
                this.warn((Function0<String> & Serializable)() -> "Truncating " + tp + " to offset " + offsetTruncationState.offset() + " below high watermark " + log.highWatermark());
            }
            if (isMirror) {
                partition.truncateMirrorTo(offsetTruncationState.offset(), false, false, true);
            } else {
                partition.truncateTo(offsetTruncationState.offset(), false, false);
            }
            if (!offsetTruncationState.truncationCompleted()) break block6;
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
        return true;
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, false, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$checkpointRecoveryOffsets$1(ReplicaFetcherThread $this, ArrayBuffer affectedLogs$1, TopicPartition tp) {
        Option<AbstractLog> log = $this.replicaMgr.getLog(tp);
        if (log != null) {
            log.foreach((Function1<AbstractLog, ArrayBuffer> & Serializable)l -> (ArrayBuffer)affectedLogs$1.$plus$eq(l));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkpointRecoveryOffsets$4(ReplicaFetcherThread $this, File dir) {
        $this.replicaMgr.logManager().checkpointRecoveryOffsetsInDir(dir);
    }

    public static final /* synthetic */ boolean $anonfun$processPartitionData$1(LogAppendInfo x$2) {
        LeaderHwChange leaderHwChange = x$2.leaderHwChange();
        LeaderHwChange leaderHwChange2 = LeaderHwChange.INCREASED;
        return !(leaderHwChange != null ? !((Object)((Object)leaderHwChange)).equals((Object)leaderHwChange2) : leaderHwChange2 != null);
    }

    public ReplicaFetcherThread(String name, int fetcherId, LeaderEndPoint leader, KafkaConfig brokerConfig, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicaQuota quota, Option<LogContext> logContextOpt, Map<String, String> extraMetricTags, Function0<MetadataVersion> metadataVersionSupplier) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        super(name, name, leader, failedPartitions, pausedPartitions, exponentialBackoff, new ConfluentReplicaFetcherTierStateMachine(leader, replicaMgr, exponentialBackoff), false, replicaMgr.brokerTopicStats(), extraMetricTags);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = (LogContext)logContextOpt.getOrElse((Function0<LogContext> & Serializable)() -> new LogContext("[ReplicaFetcher replicaId=" + this.replicaId() + ", leaderId=" + this.super$leader().brokerEndPoint().id() + ", fetcherId=" + $this.fetcherId + "] "));
        this.logIdent_$eq(this.logContext().logPrefix());
        this.partitionsWithNewHighWatermark = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.transitionToPushSupported = true;
    }

    public static final /* synthetic */ Object $anonfun$checkpointRecoveryOffsets$1$adapted(ReplicaFetcherThread $this, ArrayBuffer affectedLogs$1, TopicPartition tp) {
        ReplicaFetcherThread.$anonfun$checkpointRecoveryOffsets$1($this, affectedLogs$1, tp);
        return BoxedUnit.UNIT;
    }
}

