/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ClusterlinkV1Api;
import io.confluent.flink.apiserver.client.CoreV1Api;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1LogicalKafkaCluster;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1LogicalKafkaClusterList;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1LogicalKafkaClusterSpec;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1Site;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kafka.server.DataFlowPolicy;
import kafka.server.KafkaConfig;
import kafka.server.RegionalLkcMetadata;
import kafka.server.RegionalLkcMetadataLookupKey;
import kafka.server.RegionalMetadataClient;
import kafka.server.RegionalNetworkMetadata;
import kafka.server.RmRegionalMetadataClient$;
import kafka.server.RmRegionalMetadataWatcher;
import kafka.server.Subscription;
import kafka.server.Watch;
import kafka.server.ssl.MtlsWithServerCertConfigs;
import kafka.utils.Logging;
import okhttp3.OkHttpClient;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001dq!\u0002+V\u0011\u0003Qf!\u0002/V\u0011\u0003i\u0006\"\u00026\u0002\t\u0003Y\u0007b\u00027\u0002\u0005\u0004%I!\u001c\u0005\u0007m\u0006\u0001\u000b\u0011\u00028\t\u000f]\f!\u0019!C\u0005[\"1\u00010\u0001Q\u0001\n9Dq!_\u0001C\u0002\u0013%Q\u000e\u0003\u0004{\u0003\u0001\u0006IA\u001c\u0005\bw\u0006\u0011\r\u0011\"\u0003}\u0011\u001d\t\t!\u0001Q\u0001\nuD!\"a\u0001\u0002\u0005\u0004%\t!VA\u0003\u0011!\tY#\u0001Q\u0001\n\u0005\u001d\u0001BCA\u0017\u0003\t\u0007I\u0011A+\u00020!A\u0011\u0011I\u0001!\u0002\u0013\t\t\u0004C\u0004\u0002D\u0005!I!!\u0012\t\u000f\u0005\u001d\u0014\u0001\"\u0001\u0002j!9\u0011\u0011R\u0001\u0005\u0002\u0005-e!\u0002/V\u0005\u0005=\u0005BCAO%\t\u0005\t\u0015!\u0003\u0002 \"Q\u0011Q\u0015\n\u0003\u0002\u0003\u0006I!a*\t\r)\u0014B\u0011AA`\u00111\t9M\u0005a\u0001\u0002\u0004%\t!VAe\u00111\tiN\u0005a\u0001\u0002\u0004%\t!VAp\u0011-\t)O\u0005a\u0001\u0002\u0003\u0006K!a3\t\u0013\u0005\u001d(C1A\u0005\n\u0005%\b\u0002CAy%\u0001\u0006I!a;\t\u0015\u0005M(C1A\u0005\u0002U\u000b)\u0010\u0003\u0005\u0002~J\u0001\u000b\u0011BA|\u0011)\tyP\u0005b\u0001\n\u0003)&\u0011\u0001\u0005\t\u0005\u0013\u0011\u0002\u0015!\u0003\u0003\u0004!Y!1\u0002\nA\u0002\u0003\u0007I\u0011\u0002B\u0007\u0011-\u0011yB\u0005a\u0001\u0002\u0004%IA!\t\t\u0017\t\u0015\"\u00031A\u0001B\u0003&!q\u0002\u0005\u000b\u0005O\u0011\u0002\u0019!C\u0001+\n%\u0002B\u0003B\u001b%\u0001\u0007I\u0011A+\u00038!A!1\b\n!B\u0013\u0011Y\u0003\u0003\u0007\u0003>I\u0001\r\u00111A\u0005\u0002U\u0013y\u0004\u0003\u0007\u0003HI\u0001\r\u00111A\u0005\u0002U\u0013I\u0005C\u0006\u0003NI\u0001\r\u0011!Q!\n\t\u0005\u0003\"\u0003B(%\t\u0007I\u0011\u0002B)\u0011!\u0011\u0019G\u0005Q\u0001\n\tM\u0003B\u0003B3%\t\u0007I\u0011A+\u0003h!A!\u0011\u0010\n!\u0002\u0013\u0011I\u0007C\u0005\u0003|I\u0001\r\u0011\"\u0001Vy\"Q!Q\u0010\nA\u0002\u0013\u0005QKa \t\u000f\t\r%\u0003)Q\u0005{\"Q!Q\u0011\nC\u0002\u0013\u0005QKa\"\t\u0011\tE%\u0003)A\u0005\u0005\u0013C!Ba%\u0013\u0005\u0004%\t!\u0016BD\u0011!\u0011)J\u0005Q\u0001\n\t%\u0005\"\u0003BL%\t\u0007I\u0011\u0002BD\u0011!\u0011IJ\u0005Q\u0001\n\t%\u0005b\u0003BN%\u0001\u0007\t\u0019!C\u0005\u0005;C1B!*\u0013\u0001\u0004\u0005\r\u0011\"\u0003\u0003(\"Y!1\u0016\nA\u0002\u0003\u0005\u000b\u0015\u0002BP\u0011)\u0011iK\u0005b\u0001\n\u0003)&q\u0011\u0005\t\u0005_\u0013\u0002\u0015!\u0003\u0003\n\"I!\u0011\u0017\nC\u0002\u0013%!q\u0011\u0005\t\u0005g\u0013\u0002\u0015!\u0003\u0003\n\"Y!Q\u0017\nA\u0002\u0003\u0007I\u0011\u0002BO\u0011-\u00119L\u0005a\u0001\u0002\u0004%IA!/\t\u0017\tu&\u00031A\u0001B\u0003&!q\u0014\u0005\t\u0005\u007f\u0013B\u0011A+\u0003B\"9!1\u001a\n\u0005B\t5\u0007\u0002\u0003Bq%\u0011\u0005QKa9\t\u000f\tU(\u0003\"\u0011\u0003x\"A1Q\u0002\n\u0005\u0002U\u001by\u0001C\u0004\u0004\u001cI!\te!\b\t\u000f\rE\"\u0003\"\u0011\u00044!91Q\u0007\n\u0005B\r]\u0002bBB.%\u0011%11\u0007\u0005\b\u0007;\u0012B\u0011BB0\u0011\u001d\u0019\tG\u0005C\u0005\u0007gAqaa\u0019\u0013\t\u0003\u001a)\u0007C\u0004\u0004hI!Ia!\u001b\t\u000f\r-$\u0003\"\u0001\u0004n!911\u000f\n\u0005\u0002\rU\u0004bBB=%\u0011%11\u0007\u0005\t\u0007w\u0012B\u0011A+\u0004~!911\u0012\n\u0005\n\r5\u0005\u0002CBF%\u0011\u0005Qk!,\t\u000f\r-%\u0003\"\u0003\u0004J\"91Q\u001d\n\u0005B\r\u001d\u0018\u0001\u0007*n%\u0016<\u0017n\u001c8bY6+G/\u00193bi\u0006\u001cE.[3oi*\u0011akV\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003a\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\\\u00035\tQK\u0001\rS[J+w-[8oC2lU\r^1eCR\f7\t\\5f]R\u001c2!\u00010e!\ty&-D\u0001a\u0015\u0005\t\u0017!B:dC2\f\u0017BA2a\u0005\u0019\te.\u001f*fMB\u0011Q\r[\u0007\u0002M*\u0011qmV\u0001\u0006kRLGn]\u0005\u0003S\u001a\u0014q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u00025\u0006iQ*\u0012+S\u0013\u000e\u001bvl\u0012*P+B+\u0012A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fA\u0001\\1oO*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005\u0019\u0019FO]5oO\u0006qQ*\u0012+S\u0013\u000e\u001bvl\u0012*P+B\u0003\u0013\u0001\u0006*N?\u000e\u000bE\nT0D\u001fVsEkX*F\u001dN{%+A\u000bS\u001b~\u001b\u0015\t\u0014'`\u0007>+f\nV0T\u000b:\u001bvJ\u0015\u0011\u0002+Iku,\u0012*S\u001fJ{6iT+O)~\u001bVIT*P%\u00061\"+T0F%J{%kX\"P+:#vlU#O'>\u0013\u0006%\u0001\u0006nCb\u0014V\r\u001e:jKN,\u0012! \t\u0003?zL!a 1\u0003\u0007%sG/A\u0006nCb\u0014V\r\u001e:jKN\u0004\u0013A\u0006:fiJLxJ\\\"p]:,7\r^5p]\u0016\u0013(o\u001c:\u0016\u0005\u0005\u001d\u0001cB0\u0002\n\u00055\u0011QE\u0005\u0004\u0003\u0017\u0001'!\u0003$v]\u000e$\u0018n\u001c82!\u0011\ty!a\b\u000f\t\u0005E\u00111\u0004\b\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC-\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0017bAA\u000fA\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0011\u0003G\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005u\u0001\rE\u0002`\u0003OI1!!\u000ba\u0005\u001d\u0011un\u001c7fC:\fqC]3uef|enQ8o]\u0016\u001cG/[8o\u000bJ\u0014xN\u001d\u0011\u0002\u00115$8k[;TKR,\"!!\r\u0011\u000b\u0005M\u0012Q\b8\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005m\u0002-\u0001\u0006d_2dWm\u0019;j_:LA!a\u0010\u00026\t\u00191+\u001a;\u0002\u00135$8k[;TKR\u0004\u0013!F5t\u0007>tg.Z2uS>tW\t_2faRLwN\u001c\u000b\u0005\u0003K\t9\u0005C\u0004\u0002J=\u0001\r!a\u0013\u0002\u0003\u0015\u0004B!!\u0014\u0002d5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&\u0001\u0004dY&,g\u000e\u001e\u0006\u0005\u0003+\n9&A\u0005ba&\u001cXM\u001d<fe*!\u0011\u0011LA.\u0003\u00151G.\u001b8l\u0015\u0011\ti&a\u0018\u0002\u0013\r|gN\u001a7vK:$(BAA1\u0003\tIw.\u0003\u0003\u0002f\u0005=#\u0001D!qS\u0016C8-\u001a9uS>t\u0017\u0001B7bS:$B!a\u001b\u0002rA\u0019q,!\u001c\n\u0007\u0005=\u0004M\u0001\u0003V]&$\bbBA:!\u0001\u0007\u0011QO\u0001\u0005CJ<7\u000fE\u0003`\u0003o\nY(C\u0002\u0002z\u0001\u0014Q!\u0011:sCf\u0004B!! \u0002\u0006:!\u0011qPAA!\r\t\u0019\u0002Y\u0005\u0004\u0003\u0007\u0003\u0017A\u0002)sK\u0012,g-C\u0002v\u0003\u000fS1!a!a\u0003\r\u0011XO\u001c\u000b\u0005\u0003W\ni\tC\u0004\u0002tE\u0001\r!!\u001e\u0014\rI\t\t*a&e!\ry\u00171S\u0005\u0004\u0003+\u0003(AB(cU\u0016\u001cG\u000fE\u0002\\\u00033K1!a'V\u0005Y\u0011VmZ5p]\u0006dW*\u001a;bI\u0006$\u0018m\u00117jK:$\u0018\u0001\u00042s_.,'oQ8oM&<\u0007cA.\u0002\"&\u0019\u00111U+\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\b[\u0016$(/[2t!\u0011\tI+a/\u000e\u0005\u0005-&\u0002BAS\u0003[SA!a,\u00022\u000611m\\7n_:T1\u0001WAZ\u0015\u0011\t),a.\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI,A\u0002pe\u001eLA!!0\u0002,\n9Q*\u001a;sS\u000e\u001cHCBAa\u0003\u0007\f)\r\u0005\u0002\\%!9\u0011QT\u000bA\u0002\u0005}\u0005bBAS+\u0001\u0007\u0011qU\u0001\u0017Y&\u001cH/\u001a8feJ+7m\u001c8gS\u001e,(/\u00192mKV\u0011\u00111\u001a\t\u0006?\u00065\u0017\u0011[\u0005\u0004\u0003\u001f\u0004'AB(qi&|g\u000e\u0005\u0003\u0002T\u0006eWBAAk\u0015\u0011\t9.!,\u0002\u000f9,Go^8sW&!\u00111\\Ak\u0005Ya\u0015n\u001d;f]\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0017A\u00077jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3`I\u0015\fH\u0003BA6\u0003CD\u0011\"a9\u0018\u0003\u0003\u0005\r!a3\u0002\u0007a$\u0013'A\fmSN$XM\\3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197fA\u0005I\u0011\r]5DY&,g\u000e^\u000b\u0003\u0003W\u0004B!!\u0014\u0002n&!\u0011q^A(\u0005%\t\u0005/[\"mS\u0016tG/\u0001\u0006ba&\u001cE.[3oi\u0002\n1b\u00197N_\u0012,Gn]!qSV\u0011\u0011q\u001f\t\u0005\u0003\u001b\nI0\u0003\u0003\u0002|\u0006=#\u0001E\"mkN$XM\u001d7j].4\u0016'\u00119j\u00031\u0019G.T8eK2\u001c\u0018\t]5!\u0003\u001d\u0019wN]3Ba&,\"Aa\u0001\u0011\t\u00055#QA\u0005\u0005\u0005\u000f\tyEA\u0005D_J,g+M!qS\u0006A1m\u001c:f\u0003BL\u0007%A\bfq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f+\t\u0011y\u0001\u0005\u0003\u0003\u0012\tmQB\u0001B\n\u0015\u0011\u0011)Ba\u0006\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0003\u001aI\fA!\u001e;jY&!!Q\u0004B\n\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u0014Kb,7-\u001e;peN+'O^5dK~#S-\u001d\u000b\u0005\u0003W\u0012\u0019\u0003C\u0005\u0002d\u0002\n\t\u00111\u0001\u0003\u0010\u0005\u0001R\r_3dkR|'oU3sm&\u001cW\rI\u0001\u0013Kb\u0004xN\\3oi&\fGNQ1dW>4g-\u0006\u0002\u0003,A!!Q\u0006B\u0019\u001b\t\u0011yCC\u0002h\u0003[KAAa\r\u00030\t\u0011R\t\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4g\u0003Y)\u0007\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4`I\u0015\fH\u0003BA6\u0005sA\u0011\"a9$\u0003\u0003\u0005\rAa\u000b\u0002'\u0015D\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\u0011\u0002\u000f]\fGo\u00195feV\u0011!\u0011\t\t\u00047\n\r\u0013b\u0001B#+\nI\"+\u001c*fO&|g.\u00197NKR\fG-\u0019;b/\u0006$8\r[3s\u0003-9\u0018\r^2iKJ|F%Z9\u0015\t\u0005-$1\n\u0005\n\u0003G4\u0013\u0011!a\u0001\u0005\u0003\n\u0001b^1uG\",'\u000fI\u0001\u000bgNdg)Y2u_JLXC\u0001B*!\u0011\u0011)Fa\u0018\u000e\u0005\t]#\u0002\u0002B-\u00057\n1a]:m\u0015\u0011\u0011i&!,\u0002\u0011M,7-\u001e:jifLAA!\u0019\u0003X\tQ1k\u001d7GC\u000e$xN]=\u0002\u0017M\u001cHNR1di>\u0014\u0018\u0010I\u0001\u000fY.\u001cGj\\8lkB\u001c\u0015m\u00195f+\t\u0011I\u0007\u0005\u0005\u0003l\t5\u00141\u0010B9\u001b\t\u00119\"\u0003\u0003\u0003p\t]!a\u0002%bg\"l\u0015\r\u001d\t\u0006?\u00065'1\u000f\t\u00047\nU\u0014b\u0001B<+\na\"+Z4j_:\fG\u000eT6d\u001b\u0016$\u0018\rZ1uC2{wn[;q\u0017\u0016L\u0018a\u00047lG2{wn[;q\u0007\u0006\u001c\u0007.\u001a\u0011\u0002!1L7\u000f^\"bY2\u0004\u0016mZ3TSj,\u0017\u0001\u00067jgR\u001c\u0015\r\u001c7QC\u001e,7+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002l\t\u0005\u0005\u0002CAr[\u0005\u0005\t\u0019A?\u0002#1L7\u000f^\"bY2\u0004\u0016mZ3TSj,\u0007%A\rd_:tWm\u0019;j_:\u001cu.\u001e8u\u001b\u0016$(/[2OC6,WC\u0001BE!\u0011\u0011YI!$\u000e\u0005\u00055\u0016\u0002\u0002BH\u0003[\u0013!\"T3ue&\u001cg*Y7f\u0003i\u0019wN\u001c8fGRLwN\\\"pk:$X*\u001a;sS\u000et\u0015-\\3!\u0003U\u0011XnQ1mY\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\faC]7DC2d7i\\;oi6+GO]5d\u001d\u0006lW\rI\u0001\u001ae6\u001c\u0015\r\u001c7D_VtGOU1uK6+GO]5d\u001d\u0006lW-\u0001\u000es[\u000e\u000bG\u000e\\\"pk:$(+\u0019;f\u001b\u0016$(/[2OC6,\u0007%A\ts[\u000e\u000bG\u000e\\\"pk:$8+\u001a8t_J,\"Aa(\u0011\t\u0005%&\u0011U\u0005\u0005\u0005G\u000bYK\u0001\u0004TK:\u001cxN]\u0001\u0016e6\u001c\u0015\r\u001c7D_VtGoU3og>\u0014x\fJ3r)\u0011\tYG!+\t\u0013\u0005\rh'!AA\u0002\t}\u0015A\u0005:n\u0007\u0006dGnQ8v]R\u001cVM\\:pe\u0002\naC]7FeJ|'oQ8v]RlU\r\u001e:jG:\u000bW.Z\u0001\u0018e6,%O]8s\u0007>,h\u000e^'fiJL7MT1nK\u0002\n!D]7FeJ|'oQ8v]R\u0014\u0016\r^3NKR\u0014\u0018n\u0019(b[\u0016\f1D]7FeJ|'oQ8v]R\u0014\u0016\r^3NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013A\u0005:n\u000bJ\u0014xN]\"pk:$8+\u001a8t_J\faC]7FeJ|'oQ8v]R\u001cVM\\:pe~#S-\u001d\u000b\u0005\u0003W\u0012Y\fC\u0005\u0002dv\n\t\u00111\u0001\u0003 \u0006\u0019\"/\\#se>\u00148i\\;oiN+gn]8sA\u0005yq-\u001a;MW\u000edun\\6va.+\u0017\u0010\u0006\u0004\u0003r\t\r'q\u0019\u0005\b\u0005\u000b|\u0004\u0019AA>\u0003\u0015y'oZ%e\u0011\u001d\u0011Im\u0010a\u0001\u0003w\n\u0011b\u00197vgR,'/\u00133\u0002\u001d\u001d,G\u000fT6d\u001b\u0016$\u0018\rZ1uCR1!q\u001aBo\u0005?\u0004bA!\u0005\u0003R\nU\u0017\u0002\u0002Bj\u0005'\u0011\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0015y\u0016Q\u001aBl!\rY&\u0011\\\u0005\u0004\u00057,&a\u0005*fO&|g.\u00197MW\u000elU\r^1eCR\f\u0007b\u0002Bc\u0001\u0002\u0007\u00111\u0010\u0005\b\u0005\u0013\u0004\u0005\u0019AA>\u0003AI7/T;mi&$VM\\1oiN[W\u000f\u0006\u0003\u0002&\t\u0015\bb\u0002Bt\u0003\u0002\u0007!\u0011^\u0001\bY.\u001c7\u000b]3d!\u0011\u0011YO!=\u000e\u0005\t5(\u0002\u0002Bx\u0003\u001f\nQ!\\8eK2LAAa=\u0003n\n!3\t\\;ti\u0016\u0014H.\u001b8l-FbunZ5dC2\\\u0015MZ6b\u00072,8\u000f^3s'B,7-\u0001\nhKRtU\r^<pe.lU\r^1eCR\fG\u0003\u0003B}\u0007\u0007\u0019)a!\u0003\u0011\r\tE!\u0011\u001bB~!\u0015y\u0016Q\u001aB\u007f!\rY&q`\u0005\u0004\u0007\u0003)&a\u0006*fO&|g.\u00197OKR<xN]6NKR\fG-\u0019;b\u0011\u001d\u0011)M\u0011a\u0001\u0003wBqaa\u0002C\u0001\u0004\tY(A\u0003f]ZLE\rC\u0004\u0004\f\t\u0003\r!a\u001f\u0002\u001d9,Go^8sW&#\u0007+\u0019:b[\u00069\u0012n]\"p]:,7\r^5p]RK\b/\u001a)sSZ\fG/\u001a\u000b\u0005\u0003K\u0019\t\u0002C\u0004\u0004\u0014\r\u0003\ra!\u0006\u0002\u001f\r|gN\\3di&|g\u000eV=qKN\u0004bAa\u001b\u0004\u0018\u0005m\u0014\u0002BB\r\u0005/\u0011A\u0001T5ti\u0006\tr-\u001a;ECR\fg\t\\8x!>d\u0017nY=\u0015\r\r}1\u0011FB\u0017!\u0019\u0011\tB!5\u0004\"A)q,!4\u0004$A\u00191l!\n\n\u0007\r\u001dRK\u0001\bECR\fg\t\\8x!>d\u0017nY=\t\u000f\r-B\t1\u0001\u0002|\u0005qqN]4b]&T\u0018\r^5p]&#\u0007bBB\u0018\t\u0002\u0007\u00111P\u0001\u000eK:4\u0018N]8o[\u0016tG/\u00133\u0002\u000b\rdwn]3\u0015\u0005\u0005-\u0014!C2p]\u001aLw-\u001e:f)\u0011\tYg!\u000f\t\u000f\rmb\t1\u0001\u0004>\u000591m\u001c8gS\u001e\u001c\b\u0007BB \u0007\u0013\u0002\u0002Ba\u001b\u0004B\u0005m4QI\u0005\u0005\u0007\u0007\u00129BA\u0002NCB\u0004Baa\u0012\u0004J1\u0001A\u0001DB&\u0007s\t\t\u0011!A\u0003\u0002\r5#aA0%cE!1qJB+!\ry6\u0011K\u0005\u0004\u0007'\u0002'a\u0002(pi\"Lgn\u001a\t\u0004?\u000e]\u0013bAB-A\n\u0019\u0011I\\=\u0002%\u001d,Go\u0014:De\u0016\fG/Z'fiJL7m]\u0001\u0010G>tg.Z2uS>t7i\\;oiR\tQ0A\rbI\u0012d\u0015n\u001d;f]\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0017!D:vaB|'\u000f^:XCR\u001c\u0007\u000e\u0006\u0002\u0002&\u0005i\u0011n]'uYN,e.\u00192mK\u0012,\"!!\n\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tG\u0003BA6\u0007_Bqa!\u001dM\u0001\u0004\ty*A\u0005oK^\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0011\tYga\u001e\t\u000f\rET\n1\u0001\u0002 \u0006y!/Z2p]\u001aLw-\u001e:f\u001bRd7/\u0001\nhKR\u001c6\u000f\\\"mS\u0016tGoQ8oM&<G\u0003BB@\u0007\u0013\u0003Da!!\u0004\u0006BA!1NB!\u0003w\u001a\u0019\t\u0005\u0003\u0004H\r\u0015EaCBD\u001f\u0006\u0005\t\u0011!B\u0001\u0007\u001b\u00121a\u0018\u00137\u0011\u001d\tij\u0014a\u0001\u0003?\u000b\u0001#\u001a=fGV$XmV5uQJ+GO]=\u0016\t\r=5Q\u0013\u000b\u0007\u0007#\u001bIj!+\u0011\r\tE!\u0011[BJ!\u0011\u00199e!&\u0005\u000f\r]\u0005K1\u0001\u0004N\t\tA\u000bC\u0004\u0004\u001cB\u0003\ra!(\u0002\u0011M,\b\u000f\u001d7jKJ\u0004baa(\u0004&\u000eMUBABQ\u0015\u0011\u0019\u0019Ka\u0006\u0002\u0011\u0019,hn\u0019;j_:LAaa*\u0004\"\nA1+\u001e9qY&,'\u000fC\u0004\u0004,B\u0003\r!a\u0002\u0002\u0017MDw.\u001e7e%\u0016$(/_\u000b\u0005\u0007_\u001b)\f\u0006\u0006\u00042\u000e]61XB_\u0007\u007f\u0003bA!\u0005\u0003R\u000eM\u0006\u0003BB$\u0007k#qaa&R\u0005\u0004\u0019i\u0005C\u0004\u0004\u001cF\u0003\ra!/\u0011\r\r}5QUBZ\u0011\u001d\u0019Y+\u0015a\u0001\u0003\u000fAQa_)A\u0002uDqa!1R\u0001\u0004\u0019\u0019-\u0001\u0003v]&$\b\u0003\u0002B\t\u0007\u000bLAaa2\u0003\u0014\tAA+[7f+:LG/\u0006\u0003\u0004L\u000eMGCDA6\u0007\u001b\u001c)na7\u0004^\u000e}7\u0011\u001d\u0005\b\u00077\u0013\u0006\u0019ABh!\u0019\u0019yj!*\u0004RB!1qIBj\t\u001d\u00199J\u0015b\u0001\u0007\u001bBqaa6S\u0001\u0004\u0019I.\u0001\u0004gkR,(/\u001a\t\u0007\u0005#\u0011\tn!5\t\u000f\r-&\u000b1\u0001\u0002\b!)1P\u0015a\u0001{\"91\u0011\u0019*A\u0002\r\r\u0007BBBr%\u0002\u0007Q0A\u0004biR,W\u000e\u001d;\u0002\u000b]\fGo\u00195\u0016\t\r%8Q \u000b\u0007\u0007W\u001c\tpa@\u0011\u0007=\u001ci/C\u0002\u0004pB\u0014Q\"Q;u_\u000ecwn]3bE2,\u0007bBBz'\u0002\u00071Q_\u0001\rgV\u00147o\u0019:jaRLwN\u001c\t\u00067\u000e]81`\u0005\u0004\u0007s,&\u0001D*vEN\u001c'/\u001b9uS>t\u0007\u0003BB$\u0007{$qaa&T\u0005\u0004\u0019i\u0005C\u0004\u0004fN\u0003\r\u0001\"\u0001\u0011\u000bm#\u0019aa?\n\u0007\u0011\u0015QKA\u0003XCR\u001c\u0007\u000e")
public final class RmRegionalMetadataClient
implements RegionalMetadataClient,
Logging {
    public final KafkaConfig kafka$server$RmRegionalMetadataClient$$brokerConfig;
    private final Metrics metrics;
    private Option<ListenerReconfigurable> listenerReconfigurable;
    private final ApiClient apiClient;
    private final ClusterlinkV1Api clModelsApi;
    private final CoreV1Api coreApi;
    private ScheduledExecutorService executorService;
    private ExponentialBackoff exponentialBackoff;
    private RmRegionalMetadataWatcher watcher;
    private final SslFactory sslFactory;
    private final HashMap<String, Option<RegionalLkcMetadataLookupKey>> lkcLookupCache;
    private int listCallPageSize;
    private final MetricName connectionCountMetricName;
    private final MetricName rmCallCountMetricName;
    private final MetricName rmCallCountRateMetricName;
    private Sensor rmCallCountSensor;
    private final MetricName rmErrorCountMetricName;
    private final MetricName rmErrorCountRateMetricName;
    private Sensor rmErrorCountSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void run(String[] args) {
        RmRegionalMetadataClient$.MODULE$.run(args);
    }

    public static void main(String[] args) {
        RmRegionalMetadataClient$.MODULE$.main(args);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        RmRegionalMetadataClient rmRegionalMetadataClient = this;
        synchronized (rmRegionalMetadataClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Option<ListenerReconfigurable> listenerReconfigurable() {
        return this.listenerReconfigurable;
    }

    public void listenerReconfigurable_$eq(Option<ListenerReconfigurable> x$1) {
        this.listenerReconfigurable = x$1;
    }

    private ApiClient apiClient() {
        return this.apiClient;
    }

    public ClusterlinkV1Api clModelsApi() {
        return this.clModelsApi;
    }

    public CoreV1Api coreApi() {
        return this.coreApi;
    }

    private ScheduledExecutorService executorService() {
        return this.executorService;
    }

    private void executorService_$eq(ScheduledExecutorService x$1) {
        this.executorService = x$1;
    }

    public ExponentialBackoff exponentialBackoff() {
        return this.exponentialBackoff;
    }

    public void exponentialBackoff_$eq(ExponentialBackoff x$1) {
        this.exponentialBackoff = x$1;
    }

    public RmRegionalMetadataWatcher watcher() {
        return this.watcher;
    }

    public void watcher_$eq(RmRegionalMetadataWatcher x$1) {
        this.watcher = x$1;
    }

    private SslFactory sslFactory() {
        return this.sslFactory;
    }

    public HashMap<String, Option<RegionalLkcMetadataLookupKey>> lkcLookupCache() {
        return this.lkcLookupCache;
    }

    public int listCallPageSize() {
        return this.listCallPageSize;
    }

    public void listCallPageSize_$eq(int x$1) {
        this.listCallPageSize = x$1;
    }

    public MetricName connectionCountMetricName() {
        return this.connectionCountMetricName;
    }

    public MetricName rmCallCountMetricName() {
        return this.rmCallCountMetricName;
    }

    private MetricName rmCallCountRateMetricName() {
        return this.rmCallCountRateMetricName;
    }

    private Sensor rmCallCountSensor() {
        return this.rmCallCountSensor;
    }

    private void rmCallCountSensor_$eq(Sensor x$1) {
        this.rmCallCountSensor = x$1;
    }

    public MetricName rmErrorCountMetricName() {
        return this.rmErrorCountMetricName;
    }

    private MetricName rmErrorCountRateMetricName() {
        return this.rmErrorCountRateMetricName;
    }

    private Sensor rmErrorCountSensor() {
        return this.rmErrorCountSensor;
    }

    private void rmErrorCountSensor_$eq(Sensor x$1) {
        this.rmErrorCountSensor = x$1;
    }

    public Option<RegionalLkcMetadataLookupKey> getLkcLookupKey(String orgId, String clusterId) {
        if (this.lkcLookupCache().containsKey(clusterId)) {
            return this.lkcLookupCache().get(clusterId);
        }
        String string = null;
        int i = 0;
        boolean fetchMore = true;
        while (fetchMore) {
            ClusterlinkV1LogicalKafkaClusterList response = this.clModelsApi().listClusterlinkV1LogicalKafkaClustersForAllEnvironments(orgId, string, null, null, null, Predef$.MODULE$.int2Integer(this.listCallPageSize()));
            this.rmCallCountSensor().record();
            this.debug((Function0<String> & Serializable)() -> "Got list response: " + response);
            response.getItems().forEach(item -> {
                String envId = item.getMetadata().getEnvironment();
                String lkcId = item.getMetadata().getName();
                RegionalLkcMetadataLookupKey lkcKey = new RegionalLkcMetadataLookupKey(orgId, envId);
                this.lkcLookupCache().put(lkcId, new Some<RegionalLkcMetadataLookupKey>(lkcKey));
            });
            string = response.getMetadata().getContinue();
            if (string == null) {
                fetchMore = false;
            } else if (i > 200) {
                throw new IllegalStateException("More than 100k LKCs found in the org:" + orgId + " or this is a bug, breaking out of loop");
            }
            ++i;
        }
        return this.lkcLookupCache().getOrDefault(clusterId, None$.MODULE$);
    }

    @Override
    public CompletableFuture<Option<RegionalLkcMetadata>> getLkcMetadata(String orgId, String clusterId) {
        Supplier<Option> metadataSupplier = () -> {
            Option option;
            try {
                if (orgId == null || clusterId == null) {
                    option = None$.MODULE$;
                    return option;
                }
                Option<RegionalLkcMetadataLookupKey> lkcKey = this.getLkcLookupKey(orgId, clusterId);
                if (lkcKey.isEmpty()) {
                    option = None$.MODULE$;
                    return option;
                }
                String envId = lkcKey.get().environmentId();
                ClusterlinkV1LogicalKafkaCluster lkcResponse = this.clModelsApi().readClusterlinkV1LogicalKafkaCluster(envId, clusterId, orgId, null);
                this.rmCallCountSensor().record();
                this.info((Function0<String> & Serializable)() -> "For " + clusterId + " got LKC response: " + lkcResponse);
                ClusterlinkV1LogicalKafkaClusterSpec lkcSpec = lkcResponse.getSpec();
                option = new Some<$anon$1>(new RegionalLkcMetadata(this, orgId, envId, lkcSpec){
                    private final /* synthetic */ RmRegionalMetadataClient $outer;
                    private final String orgId$2;
                    private final String envId$1;
                    private final ClusterlinkV1LogicalKafkaClusterSpec lkcSpec$1;

                    public String organizationId() {
                        return this.orgId$2;
                    }

                    public String environmentId() {
                        return this.envId$1;
                    }

                    public String networkId() {
                        return this.lkcSpec$1.getNetworkId();
                    }

                    public String intranetFqdn() {
                        return this.lkcSpec$1.getInternalUrl();
                    }

                    public boolean isMultiTenant() {
                        return this.$outer.isMultiTenantSku(this.lkcSpec$1);
                    }

                    public String toString() {
                        return "RegionalLkcMetadata{organizationId=" + this.organizationId() + ", environmentId=" + this.environmentId() + ", networkId=" + this.networkId() + ", intranetFqdn=" + this.intranetFqdn() + ", isMultiTenant=" + this.isMultiTenant() + "}";
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.orgId$2 = orgId$2;
                        this.envId$1 = envId$1;
                        this.lkcSpec$1 = lkcSpec$1;
                    }
                });
                return option;
            }
            catch (ApiException e) {
                int n = e.getCode();
                switch (n) {
                    case 404: {
                        this.warn((Function0<String> & Serializable)() -> "Cluster " + clusterId + " not found in org " + orgId + " , apiException: " + e);
                        option = None$.MODULE$;
                        return option;
                    }
                    default: {
                        throw e;
                    }
                }
            }
        };
        return this.executeWithRetry(metadataSupplier, RmRegionalMetadataClient$.MODULE$.retryOnConnectionError());
    }

    public boolean isMultiTenantSku(ClusterlinkV1LogicalKafkaClusterSpec lkcSpec) {
        return lkcSpec.getSku() != null && RmRegionalMetadataClient$.MODULE$.mtSkuSet().contains(lkcSpec.getSku().toUpperCase(Locale.ROOT));
    }

    @Override
    public CompletableFuture<Option<RegionalNetworkMetadata>> getNetworkMetadata(String orgId, String envId, String networkIdParam) {
        Supplier<Option> metadataSupplier = () -> {
            Option option;
            try {
                if (orgId == null || envId == null || networkIdParam == null) {
                    option = None$.MODULE$;
                    return option;
                }
                ClusterlinkV1Site networkResponse = this.clModelsApi().readClusterlinkV1Site(envId, networkIdParam, orgId, null);
                this.rmCallCountSensor().record();
                this.info((Function0<String> & Serializable)() -> "For " + networkIdParam + " got network response: " + networkResponse);
                option = new Some<$anon$2>(new RegionalNetworkMetadata(this, networkIdParam, networkResponse){
                    private final /* synthetic */ RmRegionalMetadataClient $outer;
                    private final String networkIdParam$1;
                    private final ClusterlinkV1Site networkResponse$1;

                    public String networkId() {
                        return this.networkIdParam$1;
                    }

                    public boolean isPrivate() {
                        List<String> connectionTypes = this.networkResponse$1.getSpec().getConnectionTypes();
                        return this.$outer.isConnectionTypePrivate(connectionTypes);
                    }

                    public String toString() {
                        return "RegionalNetworkMetadata{networkId=" + this.networkIdParam$1 + ", isPrivate=" + this.isPrivate() + "}, connectionTypes=" + this.networkResponse$1.getSpec().getConnectionTypes();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.networkIdParam$1 = networkIdParam$1;
                        this.networkResponse$1 = networkResponse$1;
                    }
                });
                return option;
            }
            catch (ApiException e) {
                int n = e.getCode();
                switch (n) {
                    case 404: {
                        this.warn((Function0<String> & Serializable)() -> "Network " + networkIdParam + " not found in org " + orgId + ", env " + envId + " , apiException: " + e);
                        option = None$.MODULE$;
                        return option;
                    }
                    default: {
                        throw e;
                    }
                }
            }
        };
        return this.executeWithRetry(metadataSupplier, RmRegionalMetadataClient$.MODULE$.retryOnConnectionError());
    }

    public boolean isConnectionTypePrivate(List<String> connectionTypes) {
        return connectionTypes != null && !connectionTypes.isEmpty() && !connectionTypes.contains("PUBLIC");
    }

    @Override
    public CompletableFuture<Option<DataFlowPolicy>> getDataFlowPolicy(String organizationId, String environmentId) {
        return CompletableFuture.completedFuture(None$.MODULE$);
    }

    @Override
    public void close() {
        OkHttpClient okClient;
        this.listenerReconfigurable().foreach((Function1<Reconfigurable, Object> & Serializable)reconfigurable -> {
            this.kafka$server$RmRegionalMetadataClient$$brokerConfig.removeReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        if (this.executorService() != null) {
            this.executorService().shutdownNow();
            this.executorService_$eq(null);
        }
        if ((okClient = this.apiClient().getHttpClient()) != null) {
            okClient.dispatcher().executorService().shutdownNow();
            okClient.connectionPool().evictAll();
        }
        if (this.watcher() != null) {
            this.watcher().close();
            this.watcher_$eq(null);
        }
        this.sslFactory().close();
        this.metrics.removeMetric(this.connectionCountMetricName());
        this.metrics.removeSensor(RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$RM_CALL_COUNT_SENSOR());
    }

    public void configure(Map<String, ?> configs) {
        if (this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerEndpointUrl() == null) {
            throw new ConfigException("confluent.regional.resource.manager.endpoint", null, "Endpoint URL is not configured");
        }
        this.addListenerReconfigurable();
        String endpointUrl = this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerEndpointUrl();
        this.apiClient().setBasePath(endpointUrl);
        Integer numSchedulerThreads = this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerClientSchedulerThreads();
        this.executorService_$eq(Executors.newScheduledThreadPool(Predef$.MODULE$.Integer2int(numSchedulerThreads), ThreadUtils.createThreadFactory((String)"rm-regional-metadata-client-thread-%d", (boolean)false)));
        if (this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerWatchEndpointUrl() != null) {
            this.watcher_$eq(new RmRegionalMetadataWatcher());
        }
        if (this.isMtlsEnabled()) {
            this.sslFactory().configure(this.getSslClientConfig(this.kafka$server$RmRegionalMetadataClient$$brokerConfig));
            this.reconfigureMtls();
        } else if (this.watcher() != null) {
            ManagedChannel channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forTarget(this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerWatchEndpointUrl()).defaultLoadBalancingPolicy("round_robin")).usePlaintext()).build();
            this.watcher().configure(channel);
        }
        this.getOrCreateMetrics();
    }

    private void getOrCreateMetrics() {
        this.rmCallCountSensor_$eq(this.metrics.getSensor(RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$RM_CALL_COUNT_SENSOR()));
        if (this.rmCallCountSensor() == null) {
            this.rmCallCountSensor_$eq(this.metrics.sensor(RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$RM_CALL_COUNT_SENSOR()));
            this.metrics.addMetric(this.connectionCountMetricName(), (config, now) -> this.connectionCount());
            this.rmCallCountSensor().add(this.rmCallCountMetricName(), (MeasurableStat)new CumulativeSum());
            this.rmCallCountSensor().add(this.rmCallCountRateMetricName(), (MeasurableStat)new Rate());
            this.rmErrorCountSensor_$eq(this.metrics.sensor(RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$RM_ERROR_COUNT_SENSOR()));
            this.rmErrorCountSensor().add(this.rmErrorCountMetricName(), (MeasurableStat)new CumulativeSum());
            this.rmErrorCountSensor().add(this.rmErrorCountRateMetricName(), (MeasurableStat)new Rate());
            return;
        }
    }

    private int connectionCount() {
        return this.apiClient().getHttpClient().connectionPool().connectionCount();
    }

    private void addListenerReconfigurable() {
        ListenerName listenerToWatchForReconfiguration = ListenerName.normalised((String)new MtlsWithServerCertConfigs(this.kafka$server$RmRegionalMetadataClient$$brokerConfig).mtListenerToWatchForReconfiguration());
        this.info((Function0<String> & Serializable)() -> "Listener to watch for reconfiguration: " + listenerToWatchForReconfiguration);
        this.listenerReconfigurable_$eq(new Some<ListenerReconfigurable>(new ListenerReconfigurable(this, listenerToWatchForReconfiguration){
            private final /* synthetic */ RmRegionalMetadataClient $outer;
            private final ListenerName listenerToWatchForReconfiguration$1;

            public ListenerName listenerName() {
                return this.listenerToWatchForReconfiguration$1;
            }

            public Set<String> reconfigurableConfigs() {
                return SslConfigs.RECONFIGURABLE_CONFIGS;
            }

            public void validateReconfiguration(Map<String, ?> configs) {
                this.$outer.validateReconfiguration(this.$outer.kafka$server$RmRegionalMetadataClient$$brokerConfig);
            }

            public void reconfigure(Map<String, ?> configs) {
                this.$outer.reconfigure(this.$outer.kafka$server$RmRegionalMetadataClient$$brokerConfig);
            }

            public void configure(Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.listenerToWatchForReconfiguration$1 = listenerToWatchForReconfiguration$1;
            }
        }));
        this.kafka$server$RmRegionalMetadataClient$$brokerConfig.addReconfigurable((Reconfigurable)this.listenerReconfigurable().get());
    }

    @Override
    public boolean supportsWatch() {
        return this.watcher() != null;
    }

    private boolean isMtlsEnabled() {
        return this.apiClient().getBasePath().toLowerCase(Locale.ROOT).contains("https");
    }

    public void validateReconfiguration(KafkaConfig newConfig) {
        if (this.isMtlsEnabled()) {
            this.sslFactory().validateReconfiguration(this.getSslClientConfig(newConfig));
            return;
        }
    }

    public void reconfigure(KafkaConfig newConfig) {
        if (this.isMtlsEnabled()) {
            this.info((Function0<String> & Serializable)() -> "Reconfiguring SSL for Regional Metadata Client");
            this.sslFactory().reconfigure(this.getSslClientConfig(newConfig));
            this.reconfigureMtls();
            return;
        }
    }

    private void reconfigureMtls() {
        DefaultSslEngineFactory defaultSslEngineFactory = DefaultSslEngineFactory.castOrThrow((SslEngineFactory)this.sslFactory().sslEngineFactory());
        SSLSocketFactory sslSocketFactory = defaultSslEngineFactory.sslContext().getSocketFactory();
        KeyManager[] keyManagers = DefaultSslEngineFactory.keyManagers((SslEngineFactory)defaultSslEngineFactory);
        TrustManager[] trustManagers = DefaultSslEngineFactory.trustManagers((SslEngineFactory)defaultSslEngineFactory);
        Option trustManager = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps(trustManagers), (Function1<TrustManager, Object> & Serializable)p -> BoxesRunTime.boxToBoolean(RmRegionalMetadataClient.$anonfun$reconfigureMtls$1(p)));
        if (trustManager.isEmpty()) {
            throw new IllegalStateException("Unexpected trust managers, expected to find a X509TrustManager, but saw none");
        }
        OkHttpClient httpClient = this.apiClient().getHttpClient().newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManager.get()).build();
        this.apiClient().setHttpClient(httpClient);
        if (this.watcher() != null) {
            ChannelCredentials creds = TlsChannelCredentials.newBuilder().keyManager(keyManagers).trustManager(trustManagers).build();
            String watchEndpointUrl = this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerWatchEndpointUrl();
            Object managedChannelBuilder = Grpc.newChannelBuilderForAddress(Utils.getHost((String)watchEndpointUrl), Predef$.MODULE$.Integer2int(Utils.getPort((String)watchEndpointUrl)), creds).defaultLoadBalancingPolicy("round_robin");
            ManagedChannel managedChannel = ((ManagedChannelBuilder)managedChannelBuilder).build();
            this.watcher().configure(managedChannel);
            return;
        }
    }

    public Map<String, ?> getSslClientConfig(KafkaConfig brokerConfig) {
        MtlsWithServerCertConfigs mtlsWithServerCertConfigs = new MtlsWithServerCertConfigs(brokerConfig);
        ConfigDef sslConfigDef = new ConfigDef();
        sslConfigDef.withClientSslSupport();
        Map<String, Object> mtlsConfigs = mtlsWithServerCertConfigs.mtlsConfigOverrides();
        this.info((Function0<String> & Serializable)() -> "mtlsConfigs= " + mtlsConfigs.keySet());
        AbstractConfig sslClientConfig = new AbstractConfig(sslConfigDef, mtlsConfigs);
        return sslClientConfig.values();
    }

    private <T> CompletableFuture<T> executeWithRetry(Supplier<T> supplier, Function1<Throwable, Object> shouldRetry) {
        return this.executeWithRetry(supplier, shouldRetry, RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$maxRetries(), TimeUnit.MILLISECONDS);
    }

    public <T> CompletableFuture<T> executeWithRetry(Supplier<T> supplier, Function1<Throwable, Object> shouldRetry, int maxRetries, TimeUnit unit) {
        CompletableFuture future = new CompletableFuture();
        Runnable runnable = () -> this.executeWithRetry(supplier, future, shouldRetry, maxRetries, unit, 1);
        this.executorService().schedule(runnable, 0L, unit);
        return future;
    }

    private <T> void executeWithRetry(Supplier<T> supplier, CompletableFuture<T> future, Function1<Throwable, Object> shouldRetry, int maxRetries, TimeUnit unit, int attempt) {
        block3: {
            try {
                T result = supplier.get();
                future.complete(result);
            }
            catch (Throwable e) {
                if (BoxesRunTime.unboxToBoolean(shouldRetry.apply(e)) && attempt < maxRetries) {
                    long backoffDelay = this.exponentialBackoff().backoff((long)attempt);
                    this.info((Function0<String> & Serializable)() -> "Failed to execute task, retrying attempt:" + attempt + " in " + backoffDelay + " ms", (Function0<Throwable> & Serializable)() -> e);
                    Runnable runnable = () -> this.executeWithRetry(supplier, future, shouldRetry, maxRetries, unit, attempt + 1);
                    this.executorService().schedule(runnable, backoffDelay, unit);
                    break block3;
                }
                this.error((Function0<String> & Serializable)() -> "Failed to execute task", (Function0<Throwable> & Serializable)() -> e);
                this.rmErrorCountSensor().record();
                future.completeExceptionally(e);
            }
        }
    }

    @Override
    public <T> AutoCloseable watch(Subscription<T> subscription, Watch<T> watch) {
        if (this.watcher() == null) {
            throw new IllegalStateException("Watcher is not configured, please configure 'confluent.regional.resource.manager.watch.endpoint' before using it.");
        }
        return this.watcher().watch(subscription, watch);
    }

    public static final /* synthetic */ boolean $anonfun$reconfigureMtls$1(TrustManager p) {
        return p instanceof X509TrustManager;
    }

    public RmRegionalMetadataClient(KafkaConfig brokerConfig, Metrics metrics) {
        this.kafka$server$RmRegionalMetadataClient$$brokerConfig = brokerConfig;
        this.metrics = metrics;
        Logging.$init$(this);
        this.apiClient = new ApiClient();
        this.clModelsApi = new ClusterlinkV1Api(this.apiClient());
        this.coreApi = new CoreV1Api(this.apiClient());
        this.exponentialBackoff = new ExponentialBackoff(250L, 2, 5000L, 0.2);
        this.sslFactory = new SslFactory(ConnectionMode.CLIENT);
        this.lkcLookupCache = new HashMap();
        this.listCallPageSize = 500;
        this.connectionCountMetricName = metrics.metricName("connection-count", RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$METRICS_GROUP(), "The number of active connections.", new String[]{"connection-type", "http"});
        this.rmCallCountMetricName = metrics.metricName("rm-call-count-total", RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$METRICS_GROUP(), "The total out of process calls made to ResourceManager.");
        this.rmCallCountRateMetricName = metrics.metricName("rm-call-count-rate", RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$METRICS_GROUP(), "The rate of out of process calls made to ResourceManager.");
        this.rmErrorCountMetricName = metrics.metricName("rm-error-count-total", RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$METRICS_GROUP(), "The total errors on calls made to ResourceManager.");
        this.rmErrorCountRateMetricName = metrics.metricName("rm-error-count-rate", RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$METRICS_GROUP(), "The rate of errors on calls made to ResourceManager.");
    }
}

