/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kafka.metrics.LinuxCpuMetricsCollector;
import kafka.metrics.LinuxCpuMetricsCollector$;
import kafka.metrics.LinuxDiskMetricsCollector;
import kafka.metrics.LinuxFileMetricsCollector;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.metrics.LinuxIoMetricsCollector;
import org.slf4j.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;

public final class Server$ {
    public static final Server$ MODULE$ = new Server$();
    private static final String MetricsPrefix = "kafka.server";
    private static final String ClusterIdLabel = "kafka.cluster.id";
    private static final String NodeIdLabel = "kafka.node.id";
    private static final String CellIdLabel = "kafka.cell.id";
    private static final String ProcessRoleLabel = "kafka.process.roles";

    public String MetricsPrefix() {
        return MetricsPrefix;
    }

    public String ClusterIdLabel() {
        return ClusterIdLabel;
    }

    public String NodeIdLabel() {
        return NodeIdLabel;
    }

    public String CellIdLabel() {
        return CellIdLabel;
    }

    public String ProcessRoleLabel() {
        return ProcessRoleLabel;
    }

    public Metrics initializeMetrics(KafkaConfig config, Time time, String clusterId) {
        KafkaMetricsContext metricsContext = this.createKafkaMetricsContext(config, clusterId);
        return this.buildMetrics(config, time, metricsContext);
    }

    public Tuple3<LinuxIoMetricsCollector, LinuxCpuMetricsCollector, Option<LinuxDiskMetricsCollector>> maybeRegisterLinuxMetrics(KafkaConfig config, Time time, Logger logger) {
        Option option;
        LinuxIoMetricsCollector linuxIoMetricsCollector = new LinuxIoMetricsCollector("/proc", time);
        linuxIoMetricsCollector.maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        LinuxFileMetricsCollector linuxFileMetricsCollector = new LinuxFileMetricsCollector("/proc", logger);
        linuxFileMetricsCollector.maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        LinuxCpuMetricsCollector linuxCPUMetricsCollector = new LinuxCpuMetricsCollector("/proc", time, logger, LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$4(), LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$5());
        linuxCPUMetricsCollector.maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        if (Predef$.MODULE$.Boolean2boolean(config.confluentConfig().confluentInternalMetricsEnable())) {
            LinuxDiskMetricsCollector linuxDiskMetricsCollector = new LinuxDiskMetricsCollector(config, "/proc", time, logger);
            linuxDiskMetricsCollector.maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
            option = new Some<LinuxDiskMetricsCollector>(linuxDiskMetricsCollector);
        } else {
            option = None$.MODULE$;
        }
        None$ linuxDiskMetricsCollectorOpt = option;
        return new Tuple3<LinuxIoMetricsCollector, LinuxCpuMetricsCollector, Option<LinuxDiskMetricsCollector>>(linuxIoMetricsCollector, linuxCPUMetricsCollector, linuxDiskMetricsCollectorOpt);
    }

    private Metrics buildMetrics(KafkaConfig config, Time time, KafkaMetricsContext metricsContext) {
        MetricConfig metricConfig = this.buildMetricsConfig(config);
        return new Metrics(metricConfig, new ArrayList(), time, true, (MetricsContext)metricsContext);
    }

    public MetricConfig buildMetricsConfig(KafkaConfig kafkaConfig) {
        return new MetricConfig().samples(Predef$.MODULE$.Integer2int(kafkaConfig.metricNumSamples())).recordLevel(Sensor.RecordingLevel.forName((String)kafkaConfig.metricRecordingLevel())).timeWindow(Predef$.MODULE$.Long2long(kafkaConfig.metricSampleWindowMs()), TimeUnit.MILLISECONDS);
    }

    public KafkaMetricsContext createKafkaMetricsContext(KafkaConfig config, String clusterId) {
        HashMap<String, Object> contextLabels = new HashMap<String, Object>();
        contextLabels.put(this.ClusterIdLabel(), clusterId);
        contextLabels.put(this.NodeIdLabel(), Integer.toString(config.nodeId()));
        Object object = config.cellsImplicitCreation() ? contextLabels.put(this.CellIdLabel(), Integer.toString(Cell.getImplicitBrokerCellId((int)config.brokerId(), (int)config.cellDefaultSize(), (int)Predef$.MODULE$.Integer2int(config.k2CellBaseBrokerIndex()), (int)1000, (int)0))) : BoxedUnit.UNIT;
        contextLabels.putAll(config.originalsWithPrefix("metrics.context."));
        contextLabels.put("resource.type", "kafka");
        contextLabels.put("resource.version", AppInfoParser.getVersion());
        contextLabels.put("resource.commit.id", AppInfoParser.getCommitId());
        if (config.processRoles().nonEmpty()) {
            String roles = ((IterableOnceOps)((IterableOnceOps)config.processRoles().map((Function1<ProcessRole, String> & Serializable)role -> role.toString())).toSeq().sorted(Ordering.String$.MODULE$)).mkString(",");
            v1 = contextLabels.put(this.ProcessRoleLabel(), roles);
        } else {
            v1 = BoxedUnit.UNIT;
        }
        return new KafkaMetricsContext(this.MetricsPrefix(), contextLabels);
    }

    private Server$() {
    }
}

