/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.ClusterLinkAutoCreateMirror$;
import kafka.server.link.ClusterLinkAutoMirroringTaskType$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidTopicTaskErrorCode$;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.PolicyViolationTaskErrorCode$;
import kafka.server.link.SourceCluster$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicExistsTaskErrorCode$;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\r%a\u0001B\u001f?\u0001\u0015C\u0001B\u0014\u0001\u0003\u0006\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005!\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003W\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\t\u0004!\u0011!Q\u0001\n}C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\nO\u0002\u0011\t\u0011)A\u0005QVD\u0011B\u001e\u0001\u0003\u0002\u0003\u0006Ia^>\t\u000bq\u0004A\u0011A?\t\u0013\u0005=\u0001\u00011A\u0005\n\u0005E\u0001\"CA\r\u0001\u0001\u0007I\u0011BA\u000e\u0011!\ti\u0003\u0001Q!\n\u0005M\u0001\"CA\u0018\u0001\t\u0007I\u0011BA\u0019\u0011!\tI\u0006\u0001Q\u0001\n\u0005M\u0002\"CA.\u0001\t\u0007I\u0011BA\u0019\u0011!\ti\u0006\u0001Q\u0001\n\u0005M\u0002\"CA0\u0001\u0001\u0007I\u0011BA1\u0011%\tI\u0007\u0001a\u0001\n\u0013\tY\u0007\u0003\u0005\u0002p\u0001\u0001\u000b\u0015BA2\u0011%\t\t\b\u0001a\u0001\n\u0013\t\u0019\bC\u0005\u0002|\u0001\u0001\r\u0011\"\u0003\u0002~!A\u0011\u0011\u0011\u0001!B\u0013\t)\bC\u0006\u0002\u0004\u0002\u0001\r\u00111A\u0005\n\u0005M\u0004bCAC\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000fC1\"a#\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002v!I\u0011Q\u0012\u0001A\u0002\u0013%\u0011q\u0012\u0005\n\u0003;\u0003\u0001\u0019!C\u0005\u0003?C\u0001\"a)\u0001A\u0003&\u0011\u0011\u0013\u0005\b\u0003[\u0003A\u0011KAX\u0011\u001d\t)\r\u0001C\u0005\u0003_Cq!a2\u0001\t\u0013\tI\rC\u0004\u0002V\u0002!I!a6\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"9!\u0011\u0004\u0001\u0005\n\tm\u0001b\u0002B\u0012\u0001\u0011%!Q\u0005\u0005\b\u0005[\u0001A\u0011\u0002B\u0018\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003D\u0001!IA!\u0012\t\u000f\t}\u0004\u0001\"\u0003\u0003\u0002\"9!1\u0013\u0001\u0005\n\tU\u0005b\u0002BL\u0001\u0011%!\u0011\u0014\u0005\t\u00057\u0003A\u0011\u0001 \u00022!A!Q\u0014\u0001\u0005\u0002y\n\t\u0004\u0003\u0005\u0003 \u0002!\tAPA:\u0011\u001d\u0011\t\u000b\u0001C)\u0005GCqA!,\u0001\t\u0003\u0012ykB\u0004\u00032zB\tAa-\u0007\rur\u0004\u0012\u0001B[\u0011\u0019a8\u0007\"\u0001\u0003>\"I!qX\u001aC\u0002\u0013\u0005!\u0011\u0019\u0005\t\u0005#\u001c\u0004\u0015!\u0003\u0003D\"I!1[\u001aC\u0002\u0013\u0005!Q\u001b\u0005\t\u0005G\u001c\u0004\u0015!\u0003\u0003X\"9!Q]\u001a\u0005\u0002\t\u001d\bb\u0002B\u007fg\u0011\u0005!q \u0005\n\u0007\u000b\u0019$\u0019!C\u0001\u0003CB\u0001ba\u00024A\u0003%\u00111\r\u0002\u001c\u00072,8\u000f^3s\u0019&t7.Q;u_\u000e\u0013X-\u0019;f\u001b&\u0014(o\u001c:\u000b\u0005}\u0002\u0015\u0001\u00027j].T!!\u0011\"\u0002\rM,'O^3s\u0015\u0005\u0019\u0015!B6bM.\f7\u0001A\n\u0003\u0001\u0019\u0003\"aR&\u000f\u0005!KU\"\u0001 \n\u0005)s\u0014\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u0002M\u001b\na\u0001+\u001a:j_\u0012L7\rV1tW*\u0011!JP\u0001\u000eG2LWM\u001c;NC:\fw-\u001a:\u0016\u0003A\u0003\"\u0001S)\n\u0005Is$\u0001H\"mkN$XM\u001d'j].$Um\u001d;DY&,g\u000e^'b]\u0006<WM]\u0001\u000fG2LWM\u001c;NC:\fw-\u001a:!\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014X#\u0001,\u0011\u0005!;\u0016B\u0001-?\u0005i\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0003AiW\r^1eCR\fW*\u00198bO\u0016\u0014\b%\u0001\u0005mS:\\G)\u0019;b!\tAE,\u0003\u0002^}\ty1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0006sK6|G/Z!e[&t\u0007C\u0001%a\u0013\t\tgHA\u000bDYV\u001cH/\u001a:MS:\\')\u0019;dQ\u0006#W.\u001b8\u0002\u00151|7-\u00197BI6Lg.A\u0004nKR\u0014\u0018nY:\u0011\u0005!+\u0017B\u00014?\u0005I\u0019E.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u0002\tQLW.\u001a\t\u0003SNl\u0011A\u001b\u0006\u0003W2\fQ!\u001e;jYNT!!\u001c8\u0002\r\r|W.\\8o\u0015\t\u0019uN\u0003\u0002qc\u00061\u0011\r]1dQ\u0016T\u0011A]\u0001\u0004_J<\u0017B\u0001;k\u0005\u0011!\u0016.\\3\n\u0005\u001d\\\u0015!B9v_R\f\u0007C\u0001=z\u001b\u0005\u0001\u0015B\u0001>A\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-\u0003\u0002w\u0017\u00061A(\u001b8jiz\"\u0002C`@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY!!\u0004\u0011\u0005!\u0003\u0001\"\u0002(\f\u0001\u0004\u0001\u0006\"\u0002+\f\u0001\u00041\u0006\"\u0002.\f\u0001\u0004Y\u0006\"\u00020\f\u0001\u0004y\u0006\"\u00022\f\u0001\u0004y\u0006\"B2\f\u0001\u0004!\u0007\"B4\f\u0001\u0004A\u0007\"\u0002<\f\u0001\u00049\u0018AB2p]\u001aLw-\u0006\u0002\u0002\u0014A\u0019\u0001*!\u0006\n\u0007\u0005]aHA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\u0011\ti\"!\u000b\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ!!a\t\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005\u001d\u0012\u0011\u0005\u0002\u0005+:LG\u000fC\u0005\u0002,5\t\t\u00111\u0001\u0002\u0014\u0005\u0019\u0001\u0010J\u0019\u0002\u000f\r|gNZ5hA\u0005aQ.\u001b:s_J$v\u000e]5dgV\u0011\u00111\u0007\t\u0007\u0003k\ty$a\u0011\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\tq!\\;uC\ndWM\u0003\u0003\u0002>\u0005\u0005\u0012AC2pY2,7\r^5p]&!\u0011\u0011IA\u001c\u0005\r\u0019V\r\u001e\t\u0005\u0003\u000b\n\u0019F\u0004\u0003\u0002H\u0005=\u0003\u0003BA%\u0003Ci!!a\u0013\u000b\u0007\u00055C)\u0001\u0004=e>|GOP\u0005\u0005\u0003#\n\t#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\n9F\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003#\n\t#A\u0007nSJ\u0014xN\u001d+pa&\u001c7\u000fI\u0001\u0016G>tg\r\\5di&tw\rR3tiR{\u0007/[2t\u0003Y\u0019wN\u001c4mS\u000e$\u0018N\\4EKN$Hk\u001c9jGN\u0004\u0013\u0001\u0005;bg.\u001cx*\u001e;ti\u0006tG-\u001b8h+\t\t\u0019\u0007\u0005\u0003\u0002 \u0005\u0015\u0014\u0002BA4\u0003C\u00111!\u00138u\u0003Q!\u0018m]6t\u001fV$8\u000f^1oI&twm\u0018\u0013fcR!\u0011QDA7\u0011%\tY\u0003FA\u0001\u0002\u0004\t\u0019'A\tuCN\\7oT;ugR\fg\u000eZ5oO\u0002\n1\"\u001b8ji&\fG.\u001b>fIV\u0011\u0011Q\u000f\t\u0005\u0003?\t9(\u0003\u0003\u0002z\u0005\u0005\"a\u0002\"p_2,\u0017M\\\u0001\u0010S:LG/[1mSj,Gm\u0018\u0013fcR!\u0011QDA@\u0011%\tYcFA\u0001\u0002\u0004\t)(\u0001\u0007j]&$\u0018.\u00197ju\u0016$\u0007%\u0001\rtQ>,H\u000e\u001a$jYR,'/T5se>\u0014Hk\u001c9jGN\fAd\u001d5pk2$g)\u001b7uKJl\u0015N\u001d:peR{\u0007/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005%\u0005\"CA\u00165\u0005\u0005\t\u0019AA;\u0003e\u0019\bn\\;mI\u001aKG\u000e^3s\u001b&\u0014(o\u001c:U_BL7m\u001d\u0011\u0002\u0011Q\f7o\u001b#fg\u000e,\"!!%\u0011\r\u0005}\u00111SAL\u0013\u0011\t)*!\t\u0003\r=\u0003H/[8o!\rA\u0015\u0011T\u0005\u0004\u00037s$a\u0004+bg.$Um]2sSB$\u0018n\u001c8\u0002\u0019Q\f7o\u001b#fg\u000e|F%Z9\u0015\t\u0005u\u0011\u0011\u0015\u0005\n\u0003Wi\u0012\u0011!a\u0001\u0003#\u000b\u0011\u0002^1tW\u0012+7o\u0019\u0011)\u0007y\t9\u000b\u0005\u0003\u0002 \u0005%\u0016\u0002BAV\u0003C\u0011\u0001B^8mCRLG.Z\u0001\u0004eVtGCAAY!\u0011\t\u0019,!1\u000f\u0007\u0005U\u0016J\u0004\u0003\u00028\u0006}f\u0002BA]\u0003{sA!!\u0013\u0002<&\t1)\u0003\u0002B\u0005&\u0011q\bQ\u0005\u0004\u0003\u0007l%A\u0003+bg.\u0014Vm];mi\u00069\u0012N\\5uS\u0006d\u0017N_3B]\u0012\fU\u000f^8NSJ\u0014xN]\u0001\u000bCV$x.T5se>\u0014H\u0003BAY\u0003\u0017Dq!!4\"\u0001\u0004\ty-A\u0006uCN\\7i\u001c8uKb$\b\u0003BAZ\u0003#L1!a5N\u0005-!\u0016m]6D_:$X\r\u001f;\u0002-!\fg\u000e\u001a7f\u0019&\u001cHoU8ve\u000e,Gk\u001c9jGN$b!!-\u0002Z\u0006m\u0007bBAgE\u0001\u0007\u0011q\u001a\u0005\b\u0003;\u0014\u0003\u0019AAp\u0003\u0019\u0011Xm];miB!\u0011\u0011]Av\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u001d\u0018!B1e[&t'bAAu]\u000691\r\\5f]R\u001c\u0018\u0002BAw\u0003G\u0014\u0001\u0003T5tiR{\u0007/[2t%\u0016\u001cX\u000f\u001c;\u00029!\fg\u000e\u001a7f\u0019&\u001cHoU8ve\u000e,W*\u001b:s_J$v\u000e]5dgRA\u0011\u0011WAz\u0003k\fi\u0010C\u0004\u0002N\u000e\u0002\r!a4\t\u000f\u0005]8\u00051\u0001\u0002z\u00061Ao\u001c9jGN\u0004b!!\u0012\u0002|\u0006\r\u0013\u0002BA!\u0003/Bq!a@$\u0001\u0004\u0011\t!A\tmSN$X*\u001b:s_J\u001ch)\u001e;ve\u0016\u0004bAa\u0001\u0003\u0006\t%Q\"\u00017\n\u0007\t\u001dANA\u0006LC\u001a\\\u0017MR;ukJ,\u0007C\u0002B\u0006\u0005+\t\u0019%\u0004\u0002\u0003\u000e)!!q\u0002B\t\u0003\u0011)H/\u001b7\u000b\u0005\tM\u0011\u0001\u00026bm\u0006LAAa\u0006\u0003\u000e\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0002)!\fg\u000e\u001a7f\r&dG/\u001a:fIR{\u0007/[2t)\u0019\t\tL!\b\u0003 !9\u0011Q\u001a\u0013A\u0002\u0005=\u0007b\u0002B\u0011I\u0001\u0007\u0011\u0011`\u0001\u000fM&dG/\u001a:fIR{\u0007/[2t\u0003QA\u0017M\u001c3mK2K7\u000f\u001e#fgR$v\u000e]5dgRA\u0011\u0011\u0017B\u0014\u0005S\u0011Y\u0003C\u0004\u0002N\u0016\u0002\r!a4\t\u000f\u0005uW\u00051\u0001\u0002`\"9!\u0011E\u0013A\u0002\u0005e\u0018\u0001\u00044jYR,'\u000fV8qS\u000e\u001cH\u0003BA}\u0005cAq!a>'\u0001\u0004\tI0\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000f\u0006\u0004\u00022\n]\"\u0011\b\u0005\b\u0003\u001b<\u0003\u0019AAh\u0011\u001d\t9p\na\u0001\u0003s\f\u0001D]3n_Z,7k\\;sG\u0016l\u0015N\u001d:peR{\u0007/[2t)\u0019\tIPa\u0010\u0003B!9\u0011q\u001f\u0015A\u0002\u0005e\bbBA\u0018Q\u0001\u0007\u0011\u0011`\u0001\u0018Q\u0006tG\r\\3CCR\u001c\u0007n\u0011:fCR,Gk\u001c9jGN$\u0002\"!-\u0003H\t%#\u0011\r\u0005\b\u0003\u001bL\u0003\u0019AAh\u0011\u001d\u0011Y%\u000ba\u0001\u0005\u001b\nQ\u0002^8qS\u000ed\u0015n\u001d;j]\u001e\u001c\b\u0003\u0003B\u0006\u0005\u001f\n\u0019Ea\u0015\n\t\tE#Q\u0002\u0002\u0004\u001b\u0006\u0004\bC\u0002B\u0002\u0005\u000b\u0011)\u0006\u0005\u0003\u0003X\tuSB\u0001B-\u0015\u0011\u0011YF!\u0005\u0002\t1\fgnZ\u0005\u0005\u0005?\u0012IF\u0001\u0003W_&$\u0007b\u0002B2S\u0001\u0007!QM\u0001\u0011e\u0016l\u0017-\u001b8j]\u001e\u0014\u0015\r^2iKN\u0004bAa\u001a\u0003r\t]d\u0002\u0002B5\u0005[rA!!\u0013\u0003l%\u0011\u00111E\u0005\u0005\u0005_\n\t#A\u0004qC\u000e\\\u0017mZ3\n\t\tM$Q\u000f\u0002\u0004'\u0016\f(\u0002\u0002B8\u0003C\u0001b!!\u0012\u0002|\ne\u0004\u0003BAq\u0005wJAA! \u0002d\nAa*Z<U_BL7-\u0001\u0010bI\u0012l\u0015N\u001d:pe\u0016$Gk\u001c9jG\u0006sG\rT8h/\u0006\u0014h.\u001b8hgR1!1\u0011BF\u0005\u001f\u0003bAa\u001a\u0003r\t\u0015\u0005c\u0001%\u0003\b&\u0019!\u0011\u0012 \u0003'Q\u000b7o[#se>\u00148i\u001c3f\u0003:$Wj]4\t\u000f\t5%\u00061\u0001\u0002D\u0005)Ao\u001c9jG\"9!\u0011\u0013\u0016A\u0002\tM\u0013A\u00024viV\u0014X-A\bbY2d\u0015N\\6fIR{\u0007/[2t)\t\tI0A\u0016sK\u000e|'\u000f\u001a$bS2,G\r\u0015:fM&DX\rZ!vi>l\u0015N\u001d:pe\u000e\u0013X-\u0019;f\u001b\u0016$(/[2t)\t\ti\"A\bhKRl\u0015N\u001d:peR{\u0007/[2t\u0003a9W\r^\"p]\u001ad\u0017n\u0019;j]\u001e$Um\u001d;U_BL7m]\u0001\u000fO\u0016$\u0018J\\5uS\u0006d\u0017N_3e\u00031ygnQ8na2,G/[8o)\u0011\tiB!*\t\u000f\u0005u\u0007\u00071\u0001\u0003(B\u0019qI!+\n\u0007\t-VJA\nD_6\u0004H.\u001a;fIR\u000b7o\u001b*fgVdG/A\buCN\\G)Z:de&\u0004H/[8o)\t\t\t*A\u000eDYV\u001cH/\u001a:MS:\\\u0017)\u001e;p\u0007J,\u0017\r^3NSJ\u0014xN\u001d\t\u0003\u0011N\u001a2a\rB\\!\u0011\tyB!/\n\t\tm\u0016\u0011\u0005\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\tM\u0016\u0001G1eI&$\u0018n\u001c8bY&sG/\u001a:oC2$v\u000e]5dgV\u0011!1\u0019\t\u0007\u0005\u000b\u0014YM!4\u000e\u0005\t\u001d'\u0002\u0002Be\u0003w\t\u0011\"[7nkR\f'\r\\3\n\t\u0005\u0005#q\u0019\t\u0005\u0005/\u0012y-\u0003\u0003\u0002V\te\u0013!G1eI&$\u0018n\u001c8bY&sG/\u001a:oC2$v\u000e]5dg\u0002\na$\u00193eSRLwN\\1m\u0013:$XM\u001d8bYR{\u0007/[2QCR$XM\u001d8\u0016\u0005\t]\u0007\u0003\u0002Bm\u0005?l!Aa7\u000b\t\tu'QB\u0001\u0006e\u0016<W\r_\u0005\u0005\u0005C\u0014YNA\u0004QCR$XM\u001d8\u0002?\u0005$G-\u001b;j_:\fG.\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007+\u0019;uKJt\u0007%\u0001\ndQ\u0016\u001c7.\u00138uKJt\u0017\r\u001c+pa&\u001cG\u0003CA;\u0005S\u00149Pa?\t\u000f\t-\u0018\b1\u0001\u0003n\u0006ya.Y7fgR{G*[:uS:<7\u000f\u0005\u0005\u00026\t=\u00181\tBy\u0013\u0011\u0011\t&a\u000e\u0011\t\u0005\u0005(1_\u0005\u0005\u0005k\f\u0019O\u0001\u0007U_BL7\rT5ti&tw\rC\u0004\u0003zf\u0002\r!a\u0019\u0002\u0013A\u0014XMZ5y\u0019\u0016t\u0007b\u0002BGs\u0001\u0007\u00111I\u0001\u000fG\",7m\u001b+pa&\u001cG+\u001f9f)\u0019\t)h!\u0001\u0004\u0004!9!1\u001e\u001eA\u0002\t5\bb\u0002BGu\u0001\u0007\u00111I\u0001\u0019\u0007J+\u0015\tV#`)>\u0003\u0016jQ*`\u0005\u0006#6\tS0T\u0013j+\u0015!G\"S\u000b\u0006#Vi\u0018+P!&\u001b5k\u0018\"B)\u000eCulU%[\u000b\u0002\u0002")
public class ClusterLinkAutoCreateMirror
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkMetrics metrics;
    private ClusterLinkConfig config;
    private final scala.collection.mutable.Set<String> mirrorTopics;
    private final scala.collection.mutable.Set<String> conflictingDestTopics;
    private int tasksOutstanding;
    private boolean initialized;
    private boolean shouldFilterMirrorTopics;
    private volatile Option<TaskDescription> taskDesc;

    public static int CREATE_TOPICS_BATCH_SIZE() {
        return ClusterLinkAutoCreateMirror$.MODULE$.CREATE_TOPICS_BATCH_SIZE();
    }

    public static boolean checkTopicType(scala.collection.mutable.Map<String, TopicListing> namesToListings, String topic) {
        return ClusterLinkAutoCreateMirror$.MODULE$.checkTopicType(namesToListings, topic);
    }

    public static boolean checkInternalTopic(scala.collection.mutable.Map<String, TopicListing> namesToListings, int prefixLen, String topic) {
        return ClusterLinkAutoCreateMirror$.MODULE$.checkInternalTopic(namesToListings, prefixLen, topic);
    }

    public static Pattern additionalInternalTopicPattern() {
        return ClusterLinkAutoCreateMirror$.MODULE$.additionalInternalTopicPattern();
    }

    public static scala.collection.immutable.Set<String> additionalInternalTopics() {
        return ClusterLinkAutoCreateMirror$.MODULE$.additionalInternalTopics();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private scala.collection.mutable.Set<String> mirrorTopics() {
        return this.mirrorTopics;
    }

    private scala.collection.mutable.Set<String> conflictingDestTopics() {
        return this.conflictingDestTopics;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean shouldFilterMirrorTopics() {
        return this.shouldFilterMirrorTopics;
    }

    private void shouldFilterMirrorTopics_$eq(boolean x$1) {
        this.shouldFilterMirrorTopics = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (!this.initialized()) {
            return this.initializeAndAutoMirror();
        }
        return this.autoMirror(new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty()));
    }

    private ClusterLinkScheduler.TaskResult initializeAndAutoMirror() {
        this.debug((Function0<String> & Serializable)() -> "Initializing auto-mirroring " + $this.linkData.linkId());
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty());
        if (this.config().clusterLinkPrefix().isEmpty() || this.config().clusterLinkPrefix().get().isEmpty()) {
            this.shouldFilterMirrorTopics_$eq(false);
            this.initialized_$eq(true);
            return this.autoMirror(taskContext);
        }
        KafkaFuture listMirrorsFuture = this.remoteAdmin.listMirrors().result();
        this.scheduleWhenComplete(listMirrorsFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> {
            Option<TaskErrorCodeAndMsg> errOpt;
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            Tuple2<Object, Option<TaskErrorCodeAndMsg>> tuple2 = SourceCluster$.MODULE$.canContainMirrorTopics($this.metrics, (KafkaFuture<Collection<String>>)listMirrorsFuture);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean shouldFilter = tuple2._1$mcZ$sp();
            Option<TaskErrorCodeAndMsg> errOpt2 = tuple2._2();
            Tuple2<Boolean, Option<TaskErrorCodeAndMsg>> tuple22 = new Tuple2<Boolean, Option<TaskErrorCodeAndMsg>>(BoxesRunTime.boxToBoolean(shouldFilter), errOpt2);
            boolean shouldFilter2 = tuple22._1$mcZ$sp();
            Option<TaskErrorCodeAndMsg> option = errOpt = tuple22._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
                return ClusterLinkScheduler$.MODULE$.completedTask(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$));
            }
            if (None$.MODULE$.equals(option)) {
                this.shouldFilterMirrorTopics_$eq(shouldFilter2);
                this.initialized_$eq(true);
                return this.autoMirror((ClusterLinkScheduler.TaskContext)tc);
            }
            throw new MatchError(option);
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult autoMirror(ClusterLinkScheduler.TaskContext taskContext) {
        this.mirrorTopics().clear();
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName()) && this.config().autoMirroringEnable()) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String> & Serializable)() -> "Number of outstanding tasks was " + this.tasksOutstanding() + " at the beginning of run. Resetting to 0 and continuing on.");
                this.tasksOutstanding_$eq(0);
            }
            if (this.config().topicFilters().isEmpty()) {
                String errMsg = ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp() + " is true but no topic filters are specified. No topics will be mirrored.";
                this.warn((Function0<String> & Serializable)() -> errMsg);
                TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(MisconfigurationTaskErrorCode$.MODULE$, errMsg);
                return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
            }
            this.trace((Function0<String> & Serializable)() -> "Attempting to list topics from source cluster");
            ListTopicsResult listTopicsResult = this.remoteAdmin.listTopics();
            this.scheduleWhenComplete(listTopicsResult.namesToListings(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleListSourceTopics((ClusterLinkScheduler.TaskContext)tc, listTopicsResult), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleListSourceTopics(ClusterLinkScheduler.TaskContext taskContext, ListTopicsResult result) {
        ClusterLinkScheduler.TaskResult taskResult;
        block8: {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            try {
                ObjectRef<scala.collection.immutable.Set> filteredTopics = ObjectRef.create((scala.collection.immutable.Set)this.filterTopics(CollectionConverters$.MODULE$.SetHasAsScala((Set)result.names().get()).asScala().toSet()).$minus$minus(this.allLinkedTopics()));
                scala.collection.mutable.Map namesToListings = CollectionConverters$.MODULE$.MapHasAsScala((Map)result.namesToListings().get()).asScala();
                int prefixLength = ((String)this.linkData.tenantPrefix().getOrElse((Function0<String> & Serializable)() -> "")).length() + ((String)this.config().clusterLinkPrefix().getOrElse((Function0<String> & Serializable)() -> "")).length();
                ((scala.collection.immutable.Set)filteredTopics.elem).foreach((Function1<String, Object> & Serializable)topicName -> {
                    ClusterLinkAutoCreateMirror.$anonfun$handleListSourceTopics$3(this, namesToListings, prefixLength, filteredTopics, topicName);
                    return BoxedUnit.UNIT;
                });
                if (!this.shouldFilterMirrorTopics()) {
                    taskResult = this.handleFilteredTopics(taskContext, (scala.collection.immutable.Set)filteredTopics.elem);
                    break block8;
                }
                KafkaFuture listMirrorsFuture = this.remoteAdmin.listMirrors().result();
                this.scheduleWhenComplete(listMirrorsFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleListSourceMirrorTopics((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Set)filteredTopics$1.elem, (KafkaFuture<Collection<String>>)listMirrorsFuture), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                taskResult = ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
            }
            catch (ExecutionException ex) {
                TaskErrorCodeAndMsg taskErrorCodeAndMsg;
                KafkaException kafkaException;
                this.metrics.autoMirrorListTopicsFromSourceFailedSensor().record();
                Throwable throwable = ex.getCause();
                if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                    String errMsg = "Unable to list topics on the source cluster due to authentication issues.";
                    this.warn((Function0<String> & Serializable)() -> errMsg);
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
                } else if (throwable instanceof AuthorizationException) {
                    String errMsg = "Unable to list topics on the source cluster. Please enable DESCRIBE ACLs on the source cluster to proceed.";
                    this.warn((Function0<String> & Serializable)() -> errMsg + " " + ex.getCause());
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
                } else {
                    String errMsg = "Unable to list topics on the source cluster due to unexpected execution exception. Topics will not be mirrored.";
                    this.warn((Function0<String> & Serializable)() -> errMsg + " " + ex);
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
                }
                TaskErrorCodeAndMsg errorCodeAndMsg = taskErrorCodeAndMsg;
                taskResult = ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)errorCodeAndMsg), Nil$.MODULE$)));
            }
            catch (Throwable ex) {
                String errMsg = "Unable to list topics on the source cluster due to unexpected throwable exception. Topics will not be mirrored.";
                this.warn((Function0<String> & Serializable)() -> errMsg + " " + ex);
                this.metrics.autoMirrorListTopicsFromSourceFailedSensor().record();
                taskResult = ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
            }
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult handleListSourceMirrorTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> topics, KafkaFuture<Collection<String>> listMirrorsFuture) {
        ClusterLinkScheduler.TaskResult taskResult;
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            scala.collection.immutable.Set<String> filteredTopics = this.removeSourceMirrorTopics(topics, CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)listMirrorsFuture.get()).asScala().toSet());
            taskResult = this.handleFilteredTopics(taskContext, filteredTopics);
        }
        catch (ExecutionException ex) {
            TaskErrorCodeAndMsg taskErrorCodeAndMsg;
            KafkaException kafkaException;
            this.metrics.autoMirrorListMirrorsFromSourceFailedSensor().record();
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = " Unable to list mirrors on the source cluster due to authentication issues.";
                this.warn((Function0<String> & Serializable)() -> errMsg);
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof AuthorizationException) {
                String errMsg = "Unable to list mirrors on the source cluster. Please enable Describe:Cluster ACLs on the source cluster to proceed.";
                this.warn((Function0<String> & Serializable)() -> errMsg + " " + ex.getCause());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
            } else {
                String errMsg = "Unable to list mirrors on the source cluster due to unexpected execution exception. Topics will not be mirrored.";
                this.warn((Function0<String> & Serializable)() -> errMsg + " " + ex);
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
            }
            TaskErrorCodeAndMsg errorCodeAndMsg = taskErrorCodeAndMsg;
            taskResult = ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)errorCodeAndMsg), Nil$.MODULE$)));
        }
        catch (Throwable ex) {
            String errMsg = "Unable to list mirrors on the source cluster due to unexpected throwable exception. Topics will not be mirrored.";
            this.warn((Function0<String> & Serializable)() -> errMsg + " " + ex);
            this.metrics.autoMirrorListMirrorsFromSourceFailedSensor().record();
            taskResult = ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult handleFilteredTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> filteredTopics) {
        block1: {
            this.trace((Function0<String> & Serializable)() -> "Will attempt to mirror following topics on destination cluster: " + filteredTopics);
            if (this.conflictingDestTopics().intersect(filteredTopics).nonEmpty()) {
                ListTopicsResult listTopicsResult = this.localAdmin.listTopics();
                this.scheduleWhenComplete(listTopicsResult.namesToListings(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleListDestTopics((ClusterLinkScheduler.TaskContext)tc, listTopicsResult, filteredTopics), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
            }
            if (!this.conflictingDestTopics().nonEmpty()) break block1;
            this.conflictingDestTopics().clear();
        }
        return this.createTopics(taskContext, filteredTopics);
    }

    private ClusterLinkScheduler.TaskResult handleListDestTopics(ClusterLinkScheduler.TaskContext taskContext, ListTopicsResult result, scala.collection.immutable.Set<String> filteredTopics) {
        ClusterLinkScheduler.TaskResult taskResult;
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            Set destTopics = (Set)result.names().get();
            if (this.conflictingDestTopics().nonEmpty()) {
                this.conflictingDestTopics().clear();
            }
            this.conflictingDestTopics().$plus$plus$eq((IterableOnce<String>)CollectionConverters$.MODULE$.SetHasAsScala(destTopics).asScala().intersect(filteredTopics));
            if (this.conflictingDestTopics().nonEmpty()) {
                this.debug((Function0<String> & Serializable)() -> "Found following conflicting topics on destination: " + this.conflictingDestTopics());
            }
            this.conflictingDestTopics().foreach((Function1<String, Object> & Serializable)topic -> {
                ClusterLinkAutoCreateMirror.$anonfun$handleListDestTopics$2(this, topic);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Set topicsToCreate = (scala.collection.immutable.Set)filteredTopics.$minus$minus(this.conflictingDestTopics());
            taskResult = this.createTopics(taskContext, topicsToCreate);
        }
        catch (Throwable ex) {
            String errMsg = "Unable to list topics on destination cluster to check for conflicting topics.";
            this.warn((Function0<String> & Serializable)() -> errMsg + " " + ex);
            this.metrics.autoMirrorListTopicsFromDestinationFailedSensor().record();
            ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
            taskResult = this.createTopics(newTaskContext, filteredTopics);
        }
        return taskResult;
    }

    private scala.collection.immutable.Set<String> filterTopics(scala.collection.immutable.Set<String> topics) {
        this.trace((Function0<String> & Serializable)() -> "Filtering source topics " + topics + " to match topic filters JSON");
        Tuple2<scala.collection.immutable.Set<String>, Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilterTopics(topics, this.config().topicFilters(), this.linkData.tenantPrefix(), this.config().clusterLinkPrefix());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Set<String> filtered = tuple2._1();
        Seq<ClusterLinkFilterInfo> unusedFilters = tuple2._2();
        Tuple2<scala.collection.immutable.Set<String>, Seq<ClusterLinkFilterInfo>> tuple22 = new Tuple2<scala.collection.immutable.Set<String>, Seq<ClusterLinkFilterInfo>>(filtered, unusedFilters);
        scala.collection.immutable.Set<String> filtered2 = tuple22._1();
        Seq<ClusterLinkFilterInfo> unusedFilters2 = tuple22._2();
        unusedFilters2.foreach((Function1<ClusterLinkFilterInfo, Object> & Serializable)unusedFilter -> {
            this.warn((Function0<String> & Serializable)() -> "The filter " + unusedFilter + " does not match any source topic. This filter may not be required or the topics it referred to may not have the correct DESCRIBE ACL for the cluster link principal on the source cluster.");
            return BoxedUnit.UNIT;
        });
        return filtered2;
    }

    private ClusterLinkScheduler.TaskResult createTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> topics) {
        int tenantPrefixLength;
        int clusterLinkPrefixLength = ((String)this.config().clusterLinkPrefix().getOrElse((Function0<String> & Serializable)() -> "")).length();
        scala.collection.immutable.Set newTopics = (scala.collection.immutable.Set)topics.map(arg_0 -> ClusterLinkAutoCreateMirror.$anonfun$createTopics$3(this, clusterLinkPrefixLength, tenantPrefixLength = ((String)this.linkData.tenantPrefix().getOrElse((Function0<String> & Serializable)() -> "")).length(), arg_0));
        Seq batchedTopics = newTopics.grouped(ClusterLinkAutoCreateMirror$.MODULE$.CREATE_TOPICS_BATCH_SIZE()).toSeq();
        if (batchedTopics.nonEmpty()) {
            scala.collection.immutable.Set firstBatch = (scala.collection.immutable.Set)batchedTopics.apply(false);
            Seq remainingBatches = (Seq)batchedTopics.drop(1);
            this.trace((Function0<String> & Serializable)() -> "Creating following topics on destination cluster: " + firstBatch);
            CreateTopicsResult result = this.localAdmin.createTopics(CollectionConverters$.MODULE$.SetHasAsJava(firstBatch).asJava());
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleBatchCreateTopics((ClusterLinkScheduler.TaskContext)tc, result.values(), remainingBatches), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private scala.collection.immutable.Set<String> removeSourceMirrorTopics(scala.collection.immutable.Set<String> topics, scala.collection.immutable.Set<String> mirrorTopics) {
        this.debug((Function0<String> & Serializable)() -> "Mirror topics at source " + mirrorTopics);
        scala.collection.immutable.Set filteredTopics = (scala.collection.immutable.Set)topics.filter((Function1<String, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(ClusterLinkAutoCreateMirror.$anonfun$removeSourceMirrorTopics$2(mirrorTopics, x$4)));
        scala.collection.immutable.Set filteredOutTopics = (scala.collection.immutable.Set)topics.$minus$minus(filteredTopics);
        this.debug((Function0<String> & Serializable)() -> "Filtering out " + filteredOutTopics + " because they are mirror topics at the source cluster");
        if (filteredOutTopics.nonEmpty()) {
            this.metrics.prefixedAutoMirrorTopicFilteredSensor().record((double)filteredOutTopics.size());
        } else {
            this.metrics.prefixedAutoMirrorTopicFilteredSensor().record(0.0);
        }
        return filteredTopics;
    }

    private ClusterLinkScheduler.TaskResult handleBatchCreateTopics(ClusterLinkScheduler.TaskContext taskContext, Map<String, KafkaFuture<Void>> topicListings, Seq<scala.collection.immutable.Set<NewTopic>> remainingBatches) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicListings).asScala().flatMap((Function1<Tuple2, Seq> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                return this.addMirroredTopicAndLogWarnings(topic, (KafkaFuture<Void>)future);
            }
            throw new MatchError(tuple2);
        });
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(errs));
        if (remainingBatches.isEmpty()) {
            return ClusterLinkScheduler$.MODULE$.completedTask(newTaskContext.errs());
        }
        scala.collection.immutable.Set nextBatch = (scala.collection.immutable.Set)remainingBatches.apply(false);
        Seq nextRemainingBatches = (Seq)remainingBatches.drop(1);
        this.trace((Function0<String> & Serializable)() -> "Creating following topics on destination cluster: " + nextBatch);
        CreateTopicsResult result = this.localAdmin.createTopics(CollectionConverters$.MODULE$.SetHasAsJava(nextBatch).asJava());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleBatchCreateTopics((ClusterLinkScheduler.TaskContext)tc, result.values(), nextRemainingBatches), newTaskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        return ClusterLinkScheduler$.MODULE$.inProgressTask(newTaskContext.errs());
    }

    private Seq<TaskErrorCodeAndMsg> addMirroredTopicAndLogWarnings(String topic, KafkaFuture<Void> future) {
        Option errOpt;
        Some<TaskErrorCodeAndMsg> some;
        try {
            future.get();
            this.mirrorTopics().$plus$eq(topic);
            this.metrics.autoMirrorCreateSensor().record();
            if (!this.config().clusterLinkPrefix().forall((Function1<String, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.isEmpty()))) {
                this.metrics.prefixedAutoMirrorCreateSensor().record();
            }
            some = None$.MODULE$;
        }
        catch (ExecutionException ex) {
            KafkaException kafkaException;
            Throwable throwable = ex.getCause();
            if (throwable instanceof TopicExistsException) {
                this.conflictingDestTopics().add(topic);
                String errMsg = "Topic " + topic + " already exists on destination cluster. Will not mirror source topic.";
                this.warn((Function0<String> & Serializable)() -> errMsg + ex.getCause());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                some = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(TopicExistsTaskErrorCode$.MODULE$, errMsg));
            } else if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = "Unable to create topic " + topic + " due to authentication issues.";
                this.warn((Function0<String> & Serializable)() -> errMsg);
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                some = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, errMsg));
            } else if (throwable instanceof AuthorizationException) {
                AuthorizationException authorizationException = (AuthorizationException)throwable;
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                String errMsg = "Unable to create topic " + topic + " due to authorization error. " + authorizationException.getMessage();
                this.warn((Function0<String> & Serializable)() -> errMsg);
                some = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg));
            } else if (throwable instanceof PolicyViolationException) {
                PolicyViolationException policyViolationException = (PolicyViolationException)throwable;
                String errMsg = "Unable to create topic " + topic + " on destination cluster.";
                this.warn((Function0<String> & Serializable)() -> errMsg + " " + policyViolationException);
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                some = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(PolicyViolationTaskErrorCode$.MODULE$, "Failed to create " + topic + " due to policy violation: " + policyViolationException.getMessage()));
            } else if (throwable instanceof InvalidTopicException) {
                InvalidTopicException invalidTopicException = (InvalidTopicException)throwable;
                String errMsg = "Unable to create topic " + topic + " on destination cluster.";
                this.warn((Function0<String> & Serializable)() -> errMsg + " " + invalidTopicException);
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                some = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InvalidTopicTaskErrorCode$.MODULE$, "Failed to create " + topic + " due to an invalid topic exception: " + invalidTopicException.getMessage()));
            } else {
                String errMsg = "Unable to create topic " + topic + " on destination cluster.";
                this.warn((Function0<String> & Serializable)() -> errMsg + " " + ex);
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                some = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
            }
        }
        catch (Throwable ex) {
            String errMsg = "Unable to create topic " + topic + " on destination cluster.";
            this.warn((Function0<String> & Serializable)() -> errMsg + " " + ex);
            this.metrics.autoMirrorCreateFailedSensor().record();
            this.recordFailedPrefixedAutoMirrorCreateMetrics();
            some = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
        }
        Option option = errOpt = some;
        if (option instanceof Some) {
            Option option2 = option;
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)option2).value();
            return new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$);
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private scala.collection.immutable.Set<String> allLinkedTopics() {
        return this.metadataManager().mirrorTopicStatesFromMetadataCache(this.linkData.linkId()).keySet().toSet();
    }

    private void recordFailedPrefixedAutoMirrorCreateMetrics() {
        if (!this.config().clusterLinkPrefix().forall((Function1<String, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.isEmpty()))) {
            this.metrics.prefixedAutoMirrorCreateFailedSensor().record();
            return;
        }
    }

    public scala.collection.mutable.Set<String> getMirrorTopics() {
        return this.mirrorTopics();
    }

    public scala.collection.mutable.Set<String> getConflictingDestTopics() {
        return this.conflictingDestTopics();
    }

    public boolean getInitialized() {
        return this.initialized();
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        None$ newTaskDesc = this.metadataManager().isLinkCoordinator(this.linkData.linkName()) ? (this.config().autoMirroringEnable() ? ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkAutoMirroringTaskType$.MODULE$, false, "run the auto create mirror topic task") : new Some<TaskDescription>(new TaskDescription(NotConfiguredTaskState$.MODULE$, (Seq)package$.MODULE$.Seq().empty()))) : None$.MODULE$;
        this.taskDesc_$eq(newTaskDesc);
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public static final /* synthetic */ void $anonfun$handleListSourceTopics$3(ClusterLinkAutoCreateMirror $this, scala.collection.mutable.Map namesToListings$1, int prefixLength$1, ObjectRef filteredTopics$1, String topicName) {
        if (ClusterLinkAutoCreateMirror$.MODULE$.checkInternalTopic(namesToListings$1, prefixLength$1, topicName)) {
            $this.debug((Function0<String> & Serializable)() -> "Internal or Confluent topic " + topicName + " will not be mirrored.");
            filteredTopics$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)filteredTopics$1.elem).$minus(topicName);
        }
        if (ClusterLinkAutoCreateMirror$.MODULE$.checkTopicType(namesToListings$1, topicName)) {
            $this.debug((Function0<String> & Serializable)() -> "Topic " + topicName + " is of type VIRTUAL or UNKNOWN and will not be mirrored.");
            filteredTopics$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)filteredTopics$1.elem).$minus(topicName);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleListDestTopics$2(ClusterLinkAutoCreateMirror $this, String topic) {
        $this.metrics.autoMirrorCreateFailedSensor().record();
        $this.recordFailedPrefixedAutoMirrorCreateMetrics();
    }

    public static final /* synthetic */ NewTopic $anonfun$createTopics$3(ClusterLinkAutoCreateMirror $this, int clusterLinkPrefixLength$1, int tenantPrefixLength$1, String topic) {
        String mirrorTopicName = clusterLinkPrefixLength$1 > 0 ? topic.substring(0, tenantPrefixLength$1) + topic.substring(tenantPrefixLength$1 + clusterLinkPrefixLength$1) : topic;
        return new NewTopic(topic, Optional.empty(), Optional.empty()).mirror(Optional.of(new NewMirrorTopic($this.linkData.linkName(), mirrorTopicName)));
    }

    public static final /* synthetic */ boolean $anonfun$removeSourceMirrorTopics$2(scala.collection.immutable.Set mirrorTopics$1, String x$4) {
        return !mirrorTopics$1.contains(x$4);
    }

    public ClusterLinkAutoCreateMirror(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkData linkData, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, ClusterLinkMetrics metrics, Time time, ClusterLinkRequestQuota quota) {
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.linkData = linkData;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkAutoCreateMirror", (int)Predef$.MODULE$.Long2long(clientManager.currentConfig().metadataMaxAgeMs()), time, quota);
        this.config = clientManager.currentConfig();
        this.mirrorTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.conflictingDestTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.logIdent_$eq("[" + this.getClass().getSimpleName() + "-" + linkData.linkName() + "] ");
        this.tasksOutstanding = 0;
        this.initialized = false;
        this.taskDesc = None$.MODULE$;
    }
}

