/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkClearMirrorStartOffsets$;
import kafka.server.link.ClusterLinkClearMirrorStartOffsetsTaskType$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.GroupClusterLinkFilterInfo;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MirrorTruncateMode;
import kafka.server.link.MirrorTruncateMode$Ignore$;
import kafka.server.link.MirrorTruncateMode$TruncateAtStart$;
import kafka.server.link.MirrorTruncateMode$TruncateFromEnd$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.OffsetAndEpoch;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rMd\u0001B!C\u0001%C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\tA\u0002\u0011\t\u0011)A\u0005C\"AA\r\u0001B\u0001B\u0003%Q\rC\u0005i\u0001\t\u0005\t\u0015!\u0003jm\"Iq\u000f\u0001B\u0001B\u0003%\u0001\u0010 \u0005\u000b{\u0002\u0011\t\u0011)A\u0005}\u0006\u0015\u0001bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\f\u00037\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0002C\u0006\u00028\u0001\u0001\r\u00111A\u0005\n\u0005e\u0002bCA#\u0001\u0001\u0007\t\u0011)Q\u0005\u0003?A1\"a\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002J!Y\u0011q\n\u0001A\u0002\u0003\u0007I\u0011BA)\u0011-\t)\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u0013\t\u0013\u0005]\u0003\u00011A\u0005\n\u0005e\u0003\"CA.\u0001\u0001\u0007I\u0011BA/\u0011\u001d\t\t\u0007\u0001Q!\nyD\u0011\"a\u0019\u0001\u0001\u0004%I!!\u001a\t\u0013\u00055\u0004\u00011A\u0005\n\u0005=\u0004\u0002CA:\u0001\u0001\u0006K!a\u001a\t\u0013\u0005U\u0004\u00011A\u0005\n\u0005\u0015\u0004\"CA<\u0001\u0001\u0007I\u0011BA=\u0011!\ti\b\u0001Q!\n\u0005\u001d\u0004\"CA@\u0001\u0001\u0007I\u0011BA3\u0011%\t\t\t\u0001a\u0001\n\u0013\t\u0019\t\u0003\u0005\u0002\b\u0002\u0001\u000b\u0015BA4\u0011%\tI\t\u0001a\u0001\n\u0013\t)\u0007C\u0005\u0002\f\u0002\u0001\r\u0011\"\u0003\u0002\u000e\"A\u0011\u0011\u0013\u0001!B\u0013\t9\u0007C\u0005\u0002\u0014\u0002\u0001\r\u0011\"\u0003\u0002\u0016\"I\u00111\u0015\u0001A\u0002\u0013%\u0011Q\u0015\u0005\t\u0003S\u0003\u0001\u0015)\u0003\u0002\u0018\"Y\u00111\u0017\u0001A\u0002\u0003\u0007I\u0011BA[\u0011-\ty\r\u0001a\u0001\u0002\u0004%I!!5\t\u0017\u0005U\u0007\u00011A\u0001B\u0003&\u0011q\u0017\u0005\f\u0003/\u0004\u0001\u0019!a\u0001\n\u0013\tI\u000eC\u0006\u0002n\u0002\u0001\r\u00111A\u0005\n\u0005=\bbCAz\u0001\u0001\u0007\t\u0011)Q\u0005\u00037D\u0001\"!>\u0001\t#\u0012\u0015q\u001f\u0005\b\u0005\u001b\u0001A\u0011\u0002B\b\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;AqAa\r\u0001\t\u0013\u0011)\u0004C\u0004\u0003X\u0001!IA!\u0017\t\u000f\tu\u0003\u0001\"\u0003\u0003`!9!q\u000f\u0001\u0005\n\te\u0004b\u0002B?\u0001\u0011%!q\u0010\u0005\b\u0005+\u0003A\u0011\u0002BL\u0011\u001d\u0011\t\u000b\u0001C\u0005\u0005GCqA!+\u0001\t\u0013\u0011Y\u000bC\u0004\u0003H\u0002!IA!3\t\u000f\tU\u0007\u0001\"\u0003\u0003X\"9!\u0011\u001d\u0001\u0005\n\t\r\bb\u0002Bw\u0001\u0011%!q\u001e\u0005\b\u0005g\u0004A\u0011\u0002B{\u0011\u001d\u0011Y\u0010\u0001C)\u0005{Dqa!\u0003\u0001\t\u0003\u001aY\u0001C\u0004\u0004\u000e\u0001!I!!\u001a\t\u000f\r=\u0001\u0001\"\u0003\u0004\u0012!911\u0004\u0001\u0005\n\ru\u0001\u0002CB\u001c\u0001\u0011\u0005!i!\u000f\t\u001d\r-\u0003\u0001%A\u0002\u0002\u0003%I!!\u0017\u0002\u0006\u001dI1Q\n\"\u0002\u0002#\u00051q\n\u0004\t\u0003\n\u000b\t\u0011#\u0001\u0004R!9\u0011\u0011\u0002 \u0005\u0002\re\u0003\"CB.}E\u0005I\u0011AB/\u0005\t\u001aE.^:uKJd\u0015N\\6DY\u0016\f'/T5se>\u00148\u000b^1si>3gm]3ug*\u00111\tR\u0001\u0005Y&t7N\u0003\u0002F\r\u000611/\u001a:wKJT\u0011aR\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\n\u0005\u0002L\u001f:\u0011A*T\u0007\u0002\u0005&\u0011aJQ\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\u0005A\u000b&\u0001\u0004)fe&|G-[2UCN\\'B\u0001(C\u0003\u0015!x\u000e]5d!\t!VL\u0004\u0002V7B\u0011a+W\u0007\u0002/*\u0011\u0001\fS\u0001\u0007yI|w\u000e\u001e \u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039f\u000bQb\u00197jK:$X*\u00198bO\u0016\u0014\bC\u0001'c\u0013\t\u0019'I\u0001\u000fDYV\u001cH/\u001a:MS:\\G)Z:u\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u00151|7-\u00197BI6Lg\u000e\u0005\u0002MM&\u0011qM\u0011\u0002\u0016\u00072,8\u000f^3s\u0019&t7NQ1uG\"\fE-\\5o\u0003\u0011!\u0018.\\3\u0011\u0005)$X\"A6\u000b\u00051l\u0017!B;uS2\u001c(B\u00018p\u0003\u0019\u0019w.\\7p]*\u0011q\t\u001d\u0006\u0003cJ\fa!\u00199bG\",'\"A:\u0002\u0007=\u0014x-\u0003\u0002vW\n!A+[7f\u0013\tAw*A\u0003rk>$\u0018\r\u0005\u0002zu6\tA)\u0003\u0002|\t\n92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0005\u0003o>\u000b!\"\u001b8uKJ4\u0018\r\\'t!\ry\u0018\u0011A\u0007\u00023&\u0019\u00111A-\u0003\u0007%sG/C\u0002\u0002\b=\u000b\u0011C]3tG\",G-\u001e7f\t\u0016d\u0017-_'t\u0003\u0019a\u0014N\\5u}Qq\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u0001C\u0001'\u0001\u0011\u0015\u0011v\u00011\u0001T\u0011\u0015\u0001w\u00011\u0001b\u0011\u0015!w\u00011\u0001f\u0011\u0015Aw\u00011\u0001j\u0011\u00159x\u00011\u0001y\u0011\u001dix\u0001%AA\u0002y\f1C]3nC&t\u0017N\\4QCJ$\u0018\u000e^5p]N,\"!a\b\u0011\r\u0005\u0005\u00121FA\u0018\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003SI\u0016AC2pY2,7\r^5p]&!\u0011QFA\u0012\u0005\r\u0019V\r\u001e\t\u0005\u0003c\t\u0019$D\u0001n\u0013\r\t)$\u001c\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003]\u0011X-\\1j]&tw\rU1si&$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002<\u0005\u0005\u0003cA@\u0002>%\u0019\u0011qH-\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0007J\u0011\u0011!a\u0001\u0003?\t1\u0001\u001f\u00132\u0003Q\u0011X-\\1j]&tw\rU1si&$\u0018n\u001c8tA\u0005i\u0011\r\u001c7QCJ$\u0018\u000e^5p]N,\"!a\u0013\u0011\u000bQ\u000bi%a\f\n\u0007\u00055r,A\tbY2\u0004\u0016M\u001d;ji&|gn]0%KF$B!a\u000f\u0002T!I\u00111\t\u0007\u0002\u0002\u0003\u0007\u00111J\u0001\u000fC2d\u0007+\u0019:uSRLwN\\:!\u0003}qW/\u001c*fiJLWm],iK:tu\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u0002}\u0006\u0019c.^7SKR\u0014\u0018.Z:XQ\u0016tgj\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\:`I\u0015\fH\u0003BA\u001e\u0003?B\u0001\"a\u0011\u0010\u0003\u0003\u0005\rA`\u0001!]Vl'+\u001a;sS\u0016\u001cx\u000b[3o\u001d>$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0003e_:,WCAA4!\ry\u0018\u0011N\u0005\u0004\u0003WJ&a\u0002\"p_2,\u0017M\\\u0001\tI>tWm\u0018\u0013fcR!\u00111HA9\u0011%\t\u0019EEA\u0001\u0002\u0004\t9'A\u0003e_:,\u0007%\u0001\tdY\u0016\f'o\u00144gg\u0016$8\u000fR8oK\u0006!2\r\\3be>3gm]3ug\u0012{g.Z0%KF$B!a\u000f\u0002|!I\u00111I\u000b\u0002\u0002\u0003\u0007\u0011qM\u0001\u0012G2,\u0017M](gMN,Go\u001d#p]\u0016\u0004\u0013aH2p]N,X.\u001a:He>,\bo\u00144gg\u0016$8\t\\1na&tw\rR8oK\u0006\u00193m\u001c8tk6,'o\u0012:pkB|eMZ:fi\u000ec\u0017-\u001c9j]\u001e$uN\\3`I\u0015\fH\u0003BA\u001e\u0003\u000bC\u0011\"a\u0011\u0019\u0003\u0003\u0005\r!a\u001a\u0002A\r|gn];nKJ<%o\\;q\u001f\u001a47/\u001a;DY\u0006l\u0007/\u001b8h\t>tW\rI\u0001\u0017SN\u0004VM\u001c3j]\u001e\u0014Vm\u001d;pe\u0016l\u0015N\u001d:pe\u0006Q\u0012n\u001d)f]\u0012Lgn\u001a*fgR|'/Z'jeJ|'o\u0018\u0013fcR!\u00111HAH\u0011%\t\u0019eGA\u0001\u0002\u0004\t9'A\fjgB+g\u000eZ5oOJ+7\u000f^8sK6K'O]8sA\u0005AA/Y:l\t\u0016\u001c8-\u0006\u0002\u0002\u0018B)q0!'\u0002\u001e&\u0019\u00111T-\u0003\r=\u0003H/[8o!\ra\u0015qT\u0005\u0004\u0003C\u0013%a\u0004+bg.$Um]2sSB$\u0018n\u001c8\u0002\u0019Q\f7o\u001b#fg\u000e|F%Z9\u0015\t\u0005m\u0012q\u0015\u0005\n\u0003\u0007r\u0012\u0011!a\u0001\u0003/\u000b\u0011\u0002^1tW\u0012+7o\u0019\u0011)\u0007}\ti\u000bE\u0002\u0000\u0003_K1!!-Z\u0005!1x\u000e\\1uS2,\u0017\u0001D4s_V\u0004h)\u001b7uKJ\u001cXCAA\\!\u0019\tI,a1\u0002J:!\u00111XA`\u001d\r1\u0016QX\u0005\u00025&\u0019\u0011\u0011Y-\u0002\u000fA\f7m[1hK&!\u0011QYAd\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0003L\u0006c\u0001'\u0002L&\u0019\u0011Q\u001a\"\u00035\u001d\u0013x.\u001e9DYV\u001cH/\u001a:MS:\\g)\u001b7uKJLeNZ8\u0002!\u001d\u0014x.\u001e9GS2$XM]:`I\u0015\fH\u0003BA\u001e\u0003'D\u0011\"a\u0011\"\u0003\u0003\u0005\r!a.\u0002\u001b\u001d\u0014x.\u001e9GS2$XM]:!\u0003y\u0001\u0018M\u001d;ji&|g\u000eT8h\u000b:$wJ\u001a4tKR\fe\u000eZ#q_\u000eD7/\u0006\u0002\u0002\\BA\u0011\u0011EAo\u0003_\t\t/\u0003\u0003\u0002`\u0006\r\"aA'baB!\u00111]Au\u001b\t\t)OC\u0002o\u0003OT!!R8\n\t\u0005-\u0018Q\u001d\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0003\t\u0002\u0018M\u001d;ji&|g\u000eT8h\u000b:$wJ\u001a4tKR\fe\u000eZ#q_\u000eD7o\u0018\u0013fcR!\u00111HAy\u0011%\t\u0019\u0005JA\u0001\u0002\u0004\tY.A\u0010qCJ$\u0018\u000e^5p]2{w-\u00128e\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2ig\u0002\n1A];o)\t\tI\u0010\u0005\u0003\u0002|\n%abAA\u007f\u001b:!\u0011q B\u0004\u001d\u0011\u0011\tA!\u0002\u000f\u0007Y\u0013\u0019!C\u0001H\u0013\t)e)\u0003\u0002D\t&\u0019!1B)\u0003\u0015Q\u000b7o\u001b*fgVdG/\u0001\u0006ue\u0006t7/\u001b;j_:$B!!?\u0003\u0012!9!1C\u0014A\u0002\tU\u0011a\u0003;bg.\u001cuN\u001c;fqR\u0004B!a?\u0003\u0018%\u0019!\u0011D)\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010^\u0001\u0012aJ|7-Z:t!\u0006\u0014H/\u001b;j_:\u001cHCBA}\u0005?\u0011\t\u0003C\u0004\u0003\u0014!\u0002\rA!\u0006\t\u000f\t\r\u0002\u00061\u0001\u0003&\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\r\t\u001d\"\u0011GA\u0018\u001b\t\u0011IC\u0003\u0003\u0003,\t5\u0012\u0001B;uS2T!Aa\f\u0002\t)\fg/Y\u0005\u0005\u0003[\u0011I#A\riC:$G.\u001a*fa2L7-Y*uCR,8OU3tk2$HCBA}\u0005o\u0011I\u0004C\u0004\u0003\u0014%\u0002\rA!\u0006\t\u000f\tm\u0012\u00061\u0001\u0003>\u0005\u0001\u0002/\u0019:uSRLwN\u001c*fgVdGo\u001d\t\t\u0005O\u0011y$a\f\u0003B%!\u0011q\u001cB\u0015!\u0019\t\tDa\u0011\u0003H%\u0019!QI7\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0005\u0005\u0013\u0012\u0019&\u0004\u0002\u0003L)!!Q\nB(\u0003\u0015\tG-\\5o\u0015\r\u0011\tf\\\u0001\bG2LWM\u001c;t\u0013\u0011\u0011)Fa\u0013\u0003\u001fA\u000b'\u000f^5uS>t'+Z:vYR\fQ\u0003\u001d:pG\u0016\u001c8oQ8na2,G/\u001a3U_BL7\r\u0006\u0003\u0002z\nm\u0003b\u0002B\nU\u0001\u0007!QC\u0001\u0019Q\u0006tG\r\\3BYR,'/T5se>\u00148OU3tk2$HCBA}\u0005C\u0012\u0019\u0007C\u0004\u0003\u0014-\u0002\rA!\u0006\t\u000f\t\u00154\u00061\u0001\u0003h\u0005aAo\u001c9jGJ+7/\u001e7ugB9!q\u0005B '\n%\u0004CBA\u0019\u0005\u0007\u0012Y\u0007\u0005\u0003\u0003n\tMTB\u0001B8\u0015\u0011\u0011\tH!\f\u0002\t1\fgnZ\u0005\u0005\u0005k\u0012yG\u0001\u0003W_&$\u0017A\u00037jgR<%o\\;qgR!\u0011\u0011 B>\u0011\u001d\u0011\u0019\u0002\fa\u0001\u0005+\t\u0001\u0003[1oI2,G*[:u\u000fJ|W\u000f]:\u0015\r\u0005e(\u0011\u0011BB\u0011\u001d\u0011\u0019\"\fa\u0001\u0005+AqA!\".\u0001\u0004\u00119)\u0001\u0004gkR,(/\u001a\t\u0007\u0003c\u0011\u0019E!#\u0011\r\t\u001d\"1\u0012BH\u0013\u0011\u0011iI!\u000b\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u0003J\tE\u0015\u0002\u0002BJ\u0005\u0017\u0012AcQ8ogVlWM]$s_V\u0004H*[:uS:<\u0017!\u00059s_\u000e,7o\u001d'jgR<%o\\;qgR1\u0011\u0011 BM\u00057CqAa\u0005/\u0001\u0004\u0011)\u0002C\u0004\u0003\u001e:\u0002\rAa(\u0002\r\u001d\u0014x.\u001e9t!\u0011!\u0016QJ*\u0002!1L7\u000f^$s_V\u0004xJ\u001a4tKR\u001cHCBA}\u0005K\u00139\u000bC\u0004\u0003\u0014=\u0002\rA!\u0006\t\u000f\tuu\u00061\u0001\u0003 \u00061\u0002.\u00198eY\u0016d\u0015n\u001d;He>,\bo\u00144gg\u0016$8\u000f\u0006\u0004\u0002z\n5&q\u0016\u0005\b\u0005'\u0001\u0004\u0019\u0001B\u000b\u0011\u001d\u0011\t\f\ra\u0001\u0005g\u000bqAZ;ukJ,7\u000f\u0005\u0004U\u0005k\u001b&qW\u0005\u0004\u0003?|\u0006CBA\u0019\u0005\u0007\u0012I\f\u0005\u0005\u0003(\t}\u0012q\u0006B^!\u0011\u0011iLa1\u000e\u0005\t}&\u0002\u0002Ba\u0005\u001f\n\u0001bY8ogVlWM]\u0005\u0005\u0005\u000b\u0014yLA\tPM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006\faCZ5mi\u0016\u0014H*[:u\u000fJ|W\u000f](gMN,Go\u001d\u000b\u0007\u0005\u0017\u0014iM!5\u0011\u000fQ\u0013),a\f\u0003<\"1!qZ\u0019A\u0002M\u000bQa\u001a:pkBDqAa52\u0001\u0004\u0011Y-A\u0004pM\u001a\u001cX\r^:\u0002#\u0005dG/\u001a:He>,\bo\u00144gg\u0016$8\u000f\u0006\u0004\u0002z\ne'1\u001c\u0005\b\u0005'\u0011\u0004\u0019\u0001B\u000b\u0011\u001d\u0011iN\ra\u0001\u0005?\fAb\u001a:pkB|eMZ:fiN\u0004b\u0001\u0016B['\n-\u0017a\u00065b]\u0012dW-\u00117uKJ<%o\\;q\u001f\u001a47/\u001a;t)\u0019\tIP!:\u0003h\"9!1C\u001aA\u0002\tU\u0001b\u0002Bug\u0001\u0007!1^\u0001\be\u0016\u001cX\u000f\u001c;t!\u0019!&QW*\u0003j\u0005\u00012\u000f^1si6K'O]8s)>\u0004\u0018n\u0019\u000b\u0005\u0003s\u0014\t\u0010C\u0004\u0003\u0014Q\u0002\rA!\u0006\u0002/!\fg\u000e\u001a7f'R\f'\u000f^'jeJ|'OU3tk2$HCBA}\u0005o\u0014I\u0010C\u0004\u0003\u0014U\u0002\rA!\u0006\t\u000f\t\u0015T\u00071\u0001\u0003h\u0005aqN\\\"p[BdW\r^5p]R!\u00111\bB\u0000\u0011\u001d\u0019\tA\u000ea\u0001\u0007\u0007\taA]3tk2$\bcA&\u0004\u0006%\u00191qA)\u0003'\r{W\u000e\u001d7fi\u0016$G+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u001fQ\f7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:$\"!a&\u0002+!\f7/T5se>\u00148\u000b^1si>3gm]3ug\u0006\u0011BO];oG\u0006$\u0018n\u001c8D_6\u0004H.\u001a;f)\u0019\t9ga\u0005\u0004\u0018!91QC\u001dA\u0002\u0005=\u0012A\u0001;q\u0011\u001d\u0019I\"\u000fa\u0001\u0005\u000f\nq\u0002]1si&$\u0018n\u001c8SKN,H\u000e^\u0001\u000e[\u0006$8\r\u001b*fa2L7-Y:\u0015\r\u0005\u001d4qDB\u0011\u0011\u001d\u0019IB\u000fa\u0001\u0005\u000fBqaa\t;\u0001\u0004\u0019)#A\u0005qe\u0016$\u0017nY1uKB9qpa\n\u0004,\u0005\u001d\u0014bAB\u00153\nIa)\u001e8di&|g.\r\t\u0005\u0007[\u0019\u0019$\u0004\u0002\u00040)\u00191\u0011G7\u0002\u000fI,\u0007\u000f\\5dC&!1QGB\u0018\u00055\u0011V\r\u001d7jG\u0006\u001cF/\u0019;vg\u0006\u0011R.\u001b:s_J$&/\u001e8dCR,Wj\u001c3f)\u0011\u0019Yd!\u0011\u0011\u00071\u001bi$C\u0002\u0004@\t\u0013!#T5se>\u0014HK];oG\u0006$X-T8eK\"911I\u001eA\u0002\r\u0015\u0013aC7jeJ|'o\u0015;bi\u0016\u00042\u0001TB$\u0013\r\u0019IE\u0011\u0002\u0016\u00072,8\u000f^3s\u0019&t7\u000eV8qS\u000e\u001cF/\u0019;f\u0003]\u0019X\u000f]3sII,7o\u00195fIVdW\rR3mCfl5/\u0001\u0012DYV\u001cH/\u001a:MS:\\7\t\\3be6K'O]8s'R\f'\u000f^(gMN,Go\u001d\t\u0003\u0019z\u001a2APB*!\ry8QK\u0005\u0004\u0007/J&AB!osJ+g\r\u0006\u0002\u0004P\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"aa\u0018+\u0007y\u001c\tg\u000b\u0002\u0004dA!1QMB8\u001b\t\u00199G\u0003\u0003\u0004j\r-\u0014!C;oG\",7m[3e\u0015\r\u0019i'W\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB9\u0007O\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ClusterLinkClearMirrorStartOffsets
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkBatchAdmin localAdmin;
    private scala.collection.mutable.Set<TopicPartition> remainingPartitions;
    private scala.collection.immutable.Set<TopicPartition> allPartitions;
    private int numRetriesWhenNoTopicPartitions;
    private boolean done;
    private boolean clearOffsetsDone;
    private boolean consumerGroupOffsetClampingDone;
    private boolean isPendingRestoreMirror;
    private volatile Option<TaskDescription> taskDesc;
    private Seq<GroupClusterLinkFilterInfo> groupFilters;
    private scala.collection.mutable.Map<TopicPartition, OffsetAndEpoch> partitionLogEndOffsetAndEpochs;

    public static int $lessinit$greater$default$6() {
        return ClusterLinkClearMirrorStartOffsets$.MODULE$.$lessinit$greater$default$6();
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private scala.collection.mutable.Set<TopicPartition> remainingPartitions() {
        return this.remainingPartitions;
    }

    private void remainingPartitions_$eq(scala.collection.mutable.Set<TopicPartition> x$1) {
        this.remainingPartitions = x$1;
    }

    private scala.collection.immutable.Set<TopicPartition> allPartitions() {
        return this.allPartitions;
    }

    private void allPartitions_$eq(scala.collection.immutable.Set<TopicPartition> x$1) {
        this.allPartitions = x$1;
    }

    private int numRetriesWhenNoTopicPartitions() {
        return this.numRetriesWhenNoTopicPartitions;
    }

    private void numRetriesWhenNoTopicPartitions_$eq(int x$1) {
        this.numRetriesWhenNoTopicPartitions = x$1;
    }

    private boolean done() {
        return this.done;
    }

    private void done_$eq(boolean x$1) {
        this.done = x$1;
    }

    private boolean clearOffsetsDone() {
        return this.clearOffsetsDone;
    }

    private void clearOffsetsDone_$eq(boolean x$1) {
        this.clearOffsetsDone = x$1;
    }

    private boolean consumerGroupOffsetClampingDone() {
        return this.consumerGroupOffsetClampingDone;
    }

    private void consumerGroupOffsetClampingDone_$eq(boolean x$1) {
        this.consumerGroupOffsetClampingDone = x$1;
    }

    private boolean isPendingRestoreMirror() {
        return this.isPendingRestoreMirror;
    }

    private void isPendingRestoreMirror_$eq(boolean x$1) {
        this.isPendingRestoreMirror = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    private Seq<GroupClusterLinkFilterInfo> groupFilters() {
        return this.groupFilters;
    }

    private void groupFilters_$eq(Seq<GroupClusterLinkFilterInfo> x$1) {
        this.groupFilters = x$1;
    }

    private scala.collection.mutable.Map<TopicPartition, OffsetAndEpoch> partitionLogEndOffsetAndEpochs() {
        return this.partitionLogEndOffsetAndEpochs;
    }

    private void partitionLogEndOffsetAndEpochs_$eq(scala.collection.mutable.Map<TopicPartition, OffsetAndEpoch> x$1) {
        this.partitionLogEndOffsetAndEpochs = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        Some some;
        Option mirrorState;
        Option option;
        if (this.remainingPartitions() == null) {
            this.debug((Function0<String> & Serializable)() -> "Initializing topic " + $this.topic);
            this.remainingPartitions_$eq((scala.collection.mutable.Set)Set$.MODULE$.empty());
            this.remainingPartitions().$plus$plus$eq(this.clientManager.metadataManager().topicPartitions(this.topic));
            this.allPartitions_$eq(this.remainingPartitions().toSet());
            if (this.remainingPartitions().isEmpty()) {
                if (this.numRetriesWhenNoTopicPartitions() < 30) {
                    this.debug((Function0<String> & Serializable)() -> "Can't find " + $this.topic + " from metadata cache, retries so far " + this.numRetriesWhenNoTopicPartitions());
                    this.numRetriesWhenNoTopicPartitions_$eq(this.numRetriesWhenNoTopicPartitions() + 1);
                    this.remainingPartitions_$eq(null);
                } else {
                    this.debug((Function0<String> & Serializable)() -> $this.topic + " can't be found from metadata cache. The topic might be deleted");
                    this.done_$eq(true);
                }
            }
        }
        this.isPendingRestoreMirror_$eq((option = (mirrorState = this.clientManager.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic))) instanceof Some && (some = (Some)option).value() instanceof ClusterLinkTopicState.PendingRestoreMirror);
        if (this.remainingPartitions() == null) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
        }
        if (!this.done() && (this.hasMirrorStartOffsets() || this.isPendingRestoreMirror()) && this.clientManager.metadataManager().isLinkCoordinator(this.clientManager.linkData().linkName())) {
            return this.transition(new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty()));
        }
        this.done_$eq(true);
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
    }

    private ClusterLinkScheduler.TaskResult transition(ClusterLinkScheduler.TaskContext taskContext) {
        if (!this.clearOffsetsDone()) {
            if (this.remainingPartitions().nonEmpty()) {
                return this.processPartitions(taskContext, CollectionConverters$.MODULE$.MutableSetHasAsJava(this.remainingPartitions()).asJava());
            }
            return this.processCompletedTopic(taskContext);
        }
        if (this.isPendingRestoreMirror()) {
            if (!this.consumerGroupOffsetClampingDone()) {
                return this.listGroups(taskContext);
            }
            return this.startMirrorTopic(taskContext);
        }
        this.done_$eq(true);
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult processPartitions(ClusterLinkScheduler.TaskContext taskContext, Set<TopicPartition> partitions) {
        ClusterLinkScheduler.TaskResult taskResult;
        this.debug((Function0<String> & Serializable)() -> "Processing partitions that require update: " + partitions);
        try {
            ReplicaStatusResult result = this.localAdmin.replicaStatus(partitions);
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleReplicaStatusResult((ClusterLinkScheduler.TaskContext)tc, result.partitionResults()), taskContext));
            taskResult = ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        catch (Exception e) {
            String errMsg = "Failed to retrieve replica status for " + partitions;
            this.warn((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            taskResult = ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult handleReplicaStatusResult(ClusterLinkScheduler.TaskContext taskContext, Map<TopicPartition, KafkaFuture<PartitionResult>> partitionResults) {
        ExcessiveLoggingHandler excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        IntRef nonRetriableErrors = IntRef.create(0);
        BooleanRef complete = BooleanRef.create(true);
        scala.collection.mutable.Map results = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(partitionResults).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option;
                TopicPartition tp = (TopicPartition)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    PartitionResult partitionResult = (PartitionResult)future.get();
                    results.update(tp, partitionResult);
                    if (this.truncationComplete(tp, partitionResult)) {
                        v0 = this.remainingPartitions().$minus$eq(tp);
                    } else {
                        complete$1.elem = false;
                        v0 = BoxedUnit.UNIT;
                    }
                    option = None$.MODULE$;
                }
                catch (RetriableException e) {
                    String errMsg = "Failed to get replica status for partition " + tp;
                    this.debug((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<RetriableException> & Serializable)() -> e);
                    option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                }
                catch (Exception e) {
                    String errMsg = "Failed to get replica status for partition " + tp;
                    excessiveLoggingHandler.handle(e, this, errMsg);
                    ++nonRetriableErrors$1.elem;
                    option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                }
                return option;
            }
            throw new MatchError(tuple2);
        });
        if (this.isPendingRestoreMirror()) {
            this.partitionLogEndOffsetAndEpochs_$eq((scala.collection.mutable.Map)results.flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition part = (TopicPartition)tuple2._1();
                    PartitionResult partResult = (PartitionResult)tuple2._2();
                    Buffer rsList = CollectionConverters$.MODULE$.ListHasAsScala(partResult.replicas()).asScala();
                    ReplicaStatus leader = (ReplicaStatus)((IterableOps)rsList.filter((Function1<ReplicaStatus, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.isLeader()))).head();
                    int leaderEpoch = partResult.leaderEpoch().orElse(-1);
                    Option<Object> mirrorInfo = Option$.MODULE$.apply(leader.mirrorInfo().orElse(null));
                    if (mirrorInfo.exists((Function1<Object, Object>)(Function1<ReplicaStatus.MirrorInfo, Object> & Serializable)info -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$handleReplicaStatusResult$6(info))) && ((IterableOnceOps)rsList.filter((Function1<ReplicaStatus, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.isInIsr()))).forall((Function1<ReplicaStatus, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$handleReplicaStatusResult$8(leader, x$7))) && leaderEpoch >= 0) {
                        return new Some<Tuple2<TopicPartition, OffsetAndEpoch>>(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(part), new OffsetAndEpoch(leader.logEndOffset(), leaderEpoch)));
                    }
                    return None$.MODULE$;
                }
                throw new MatchError(tuple2);
            }));
        }
        if (nonRetriableErrors.elem > 0) {
            this.warn((Function0<String> & Serializable)() -> "Failed to get replica status for " + nonRetriableErrors$1.elem + " partitions. Did not log the errors for " + excessiveLoggingHandler.ignoredWarnLogCount() + " of them to prevent excessive logging.");
        }
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(errs));
        if (this.isPendingRestoreMirror() && this.partitionLogEndOffsetAndEpochs().size() != results.size()) {
            this.info((Function0<String> & Serializable)() -> "Not all mirror partitions are in PendingRestore for topic '" + $this.topic + "', awaiting state change. Will retry in " + this.super$rescheduleDelayMs() + " ms");
            return ClusterLinkScheduler$.MODULE$.completedTask(newTaskContext.errs());
        }
        if (complete.elem && newTaskContext.errs().isEmpty()) {
            return this.processCompletedTopic(newTaskContext);
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(newTaskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult processCompletedTopic(ClusterLinkScheduler.TaskContext taskContext) {
        ClusterLinkScheduler.TaskResult taskResult;
        try {
            this.info((Function0<String> & Serializable)() -> "Cleared start offsets for mirror topic " + $this.topic);
            AlterMirrorsResult result = this.localAdmin.alterMirrors(Collections.singletonMap(this.topic, AlterMirrorOp.CLEAR_OFFSETS));
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleAlterMirrorsResult((ClusterLinkScheduler.TaskContext)tc, result.values()), taskContext));
            taskResult = ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        catch (Exception e) {
            String errMsg = "Failed to clear start offsets for mirror topic " + this.topic;
            this.warn((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            taskResult = ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), Nil$.MODULE$)));
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult handleAlterMirrorsResult(ClusterLinkScheduler.TaskContext taskContext, Map<String, KafkaFuture<Void>> topicResults) {
        ExcessiveLoggingHandler excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
        scala.collection.mutable.Set nonRetriableErrorTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicResults).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option;
                String topic = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    future.get();
                    this.clearOffsetsDone_$eq(true);
                    this.debug((Function0<String> & Serializable)() -> "Successfully cleared start offsets for mirror '" + topic + "'");
                    option = None$.MODULE$;
                }
                catch (RetriableException e) {
                    String errMsg = "Failed to clear start offsets for mirror topic " + topic;
                    this.debug((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<RetriableException> & Serializable)() -> e);
                    option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                }
                catch (Exception e) {
                    String errMsg = "Failed to clear start offsets for mirror topic " + topic;
                    excessiveLoggingHandler.handle(e, this, errMsg);
                    nonRetriableErrorTopics.$plus$eq(topic);
                    option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                }
                return option;
            }
            throw new MatchError(tuple2);
        });
        if (nonRetriableErrorTopics.nonEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Failed to clear start offsets for mirror topics " + nonRetriableErrorTopics + ". Did not log the errors for " + excessiveLoggingHandler.ignoredWarnLogCount() + " of them to prevent excessive logging.");
        }
        if (errs.nonEmpty()) {
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(errs));
        }
        return this.transition(taskContext);
    }

    private ClusterLinkScheduler.TaskResult listGroups(ClusterLinkScheduler.TaskContext taskContext) {
        this.debug((Function0<String> & Serializable)() -> "Listing consumer groups for consumer offset clamping for mirror topic " + $this.topic + " restoration");
        this.groupFilters_$eq(ClusterLinkUtils$.MODULE$.clusterLinkGroupFilters(this.clientManager.currentConfig().consumerGroupFilters(), this.clientManager.linkData().tenantPrefix(), None$.MODULE$, this.clientManager.currentConfig().linkMode()));
        if (this.groupFilters().isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "Found empty group filters, no consumer group offsets to sync for consumer offset clamping.");
            this.consumerGroupOffsetClampingDone_$eq(true);
            return this.transition(taskContext);
        }
        this.info((Function0<String> & Serializable)() -> "Syncing consumer group offsets for mirror topic " + $this.topic + " for consumer offset clamping");
        ListConsumerGroupsResult result = this.localAdmin.listConsumerGroups();
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleListGroups((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Collection<ConsumerGroupListing>>)result.all()), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleListGroups(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ConsumerGroupListing>> future) {
        Option errOpt;
        Tuple2 tuple2 = ClusterLinkClearMirrorStartOffsets.liftedTree1$1(future);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option resultOpt = (Option)tuple2._1();
        Option errOpt2 = (Option)tuple2._2();
        Tuple2<Option, Option> tuple22 = new Tuple2<Option, Option>(resultOpt, errOpt2);
        Option resultOpt2 = tuple22._1();
        Option option = errOpt = tuple22._2();
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)some.value();
            this.warn((Function0<String> & Serializable)() -> "Unable to process list consumer groups request for consumer offset clamping.");
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)err), Nil$.MODULE$)));
        }
        if (None$.MODULE$.equals(option)) {
            return this.processListGroups(taskContext, ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resultOpt2.get()).asScala().map((Function1<ConsumerGroupListing, String> & Serializable)x$9 -> x$9.groupId())).toSet());
        }
        throw new MatchError(option);
    }

    private ClusterLinkScheduler.TaskResult processListGroups(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> groups) {
        this.debug((Function0<String> & Serializable)() -> "Processing consumer groups for consumer offset clamping for mirror topic " + $this.topic + " restoration");
        scala.collection.immutable.Set matchedGroups = (scala.collection.immutable.Set)((IterableOps)ClusterLinkUtils$.MODULE$.doFilterGroups(groups, this.groupFilters())._1()).map((Function1<MatchedGroup, String> & Serializable)x$10 -> x$10.name());
        if (matchedGroups.isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "No consumer groups match the filters for consumer offset clamping. Starting the mirror now.");
            this.consumerGroupOffsetClampingDone_$eq(true);
            return this.transition(taskContext);
        }
        return this.listGroupOffsets(taskContext, matchedGroups);
    }

    private ClusterLinkScheduler.TaskResult listGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> groups) {
        this.debug((Function0<String> & Serializable)() -> "Listing consumer group offsets for consumer offset clamping for mirror topic " + $this.topic + " restoration");
        ListConsumerGroupOffsetsSpec spec = new ListConsumerGroupOffsetsSpec().topicPartitions(CollectionConverters$.MODULE$.SeqHasAsJava(this.allPartitions().toList()).asJava());
        ObjectRef<scala.collection.immutable.Map> futures = ObjectRef.create((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        groups.foreach((Function1<String, Object> & Serializable)group -> {
            ClusterLinkClearMirrorStartOffsets.$anonfun$listGroupOffsets$2(this, spec, futures, group);
            return BoxedUnit.UNIT;
        });
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.consumerGroupOffsetClampingDone_$eq(true);
            return this.transition(taskContext);
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleListGroupOffsets((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Map)futures$1.elem), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleListGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> futures) {
        HashMap unSyncedGroups = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Map groupOffsets = (scala.collection.immutable.Map)futures.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object object;
                String group = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    Map result = (Map)future.get();
                    object = this.filterListGroupOffsets(group, CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().toMap($less$colon$less$.MODULE$.refl()));
                }
                catch (ExecutionException e) {
                    this.debug((Function0<String> & Serializable)() -> "Encountered error when trying to handle list consumer offsets request for group " + group + ".", (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                    unSyncedGroups.put(group, ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg("Failed to list group offsets for " + group, true, e));
                    object = Predef$.MODULE$.Map().empty();
                }
                scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> res = object;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), res);
            }
            throw new MatchError(tuple2);
        }).filterNot((Function1<Tuple2, Object> & Serializable)x$11 -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$handleListGroupOffsets$4(x$11)));
        if (unSyncedGroups.nonEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Got errors when trying to sync the following consumer groups' offsets " + unSyncedGroups.keySet().mkString(",") + " when handling the list consumer group offset request. Will retry again in " + this.super$rescheduleDelayMs() + ".");
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(unSyncedGroups.values().toSeq()));
        }
        if (groupOffsets.isEmpty()) {
            this.consumerGroupOffsetClampingDone_$eq(true);
            return this.transition(taskContext);
        }
        return this.alterGroupOffsets(taskContext, groupOffsets);
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> filterListGroupOffsets(String group, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        return (scala.collection.immutable.Map)offsets.flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition partition = (TopicPartition)tuple2._1();
                OffsetAndMetadata offsetMeta = (OffsetAndMetadata)tuple2._2();
                Option option = this.partitionLogEndOffsetAndEpochs().get(partition).map((Function1<OffsetAndEpoch, Object> & Serializable)x$12 -> BoxesRunTime.boxToLong(x$12.offset()));
                if (option instanceof Some) {
                    Option option2;
                    Some some = (Some)option;
                    long logEndOffset = BoxesRunTime.unboxToLong(some.value());
                    if (offsetMeta == null) {
                        option2 = None$.MODULE$;
                    } else if (logEndOffset < offsetMeta.offset()) {
                        this.info((Function0<String> & Serializable)() -> "Rolling back offset for group '" + group + "' and topic '" + $this.topic + "' from '" + offsetMeta.offset() + " to '" + logEndOffset + "'");
                        option2 = new Some<Long>(BoxesRunTime.boxToLong(logEndOffset));
                    } else {
                        option2 = None$.MODULE$;
                    }
                    None$ offset = option2;
                    return offset.map((Function1<Object, Tuple2> & Serializable)off -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), new OffsetAndMetadata(BoxesRunTime.unboxToLong(off), offsetMeta.leaderEpoch(), offsetMeta.metadata())));
                }
                if (None$.MODULE$.equals(option)) {
                    this.error((Function0<String> & Serializable)() -> "Unexpected partition '" + partition + "', skipping");
                    return None$.MODULE$;
                }
                throw new MatchError(option);
            }
            throw new MatchError(tuple2);
        });
    }

    private ClusterLinkScheduler.TaskResult alterGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> groupOffsets) {
        this.debug((Function0<String> & Serializable)() -> "Altering consumer group offsets for consumer offset clamping for mirror topic " + $this.topic + " restoration");
        ObjectRef<scala.collection.immutable.Map> futures = ObjectRef.create((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        groupOffsets.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            ClusterLinkClearMirrorStartOffsets.$anonfun$alterGroupOffsets$2(this, futures, x0$1);
            return BoxedUnit.UNIT;
        });
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.consumerGroupOffsetClampingDone_$eq(true);
            return this.transition(taskContext);
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleAlterGroupOffsets((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Map)futures$2.elem), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleAlterGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, KafkaFuture<Void>> results) {
        HashMap unSyncedGroups = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        results.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option<TaskErrorCodeAndMsg> option;
                String group = (String)tuple2._1();
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    option = future.get();
                }
                catch (ExecutionException e) {
                    this.debug((Function0<String> & Serializable)() -> "Encountered error when trying to handle alter consumer offsets request for group " + group + ".", (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
                    option = unSyncedGroups.put(group, ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg("Failed to alter consumer offsets for group " + group, true, e));
                }
                return option;
            }
            throw new MatchError(tuple2);
        });
        if (unSyncedGroups.nonEmpty()) {
            this.warn((Function0<String> & Serializable)() -> "Got errors when trying to sync the following consumer groups' offsets " + unSyncedGroups.keySet().mkString(",") + " when handling the alter consumer group offset request. Will retry again in " + this.super$rescheduleDelayMs() + ".");
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(unSyncedGroups.values().toSeq()));
        }
        this.consumerGroupOffsetClampingDone_$eq(true);
        return this.transition(new ClusterLinkScheduler.TaskContext(taskContext.errs()));
    }

    private ClusterLinkScheduler.TaskResult startMirrorTopic(ClusterLinkScheduler.TaskContext taskContext) {
        Some some;
        this.info((Function0<String> & Serializable)() -> "Clamped necessary consumer group offsets for mirror topic " + $this.topic + ", restoring mirror topic");
        scala.collection.immutable.Set<TopicPartition> topicPartitions = this.clientManager.metadataManager().topicPartitions(this.topic);
        if (topicPartitions.size() != this.allPartitions().size()) {
            this.warn((Function0<String> & Serializable)() -> "Detected change in partitions while stopping mirror topic. Retrying consumer group offset clamping.");
            this.consumerGroupOffsetClampingDone_$eq(false);
            return this.transition(taskContext);
        }
        Option option = this.clientManager.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic);
        if (option instanceof Some && (some = (Some)option).value() instanceof ClusterLinkTopicState.PendingRestoreMirror) {
            this.info((Function0<String> & Serializable)() -> "Restoring mirror topic " + $this.topic);
            AlterMirrorsResult result = this.localAdmin.alterMirrors(Collections.singletonMap(this.topic, AlterMirrorOp.START_PENDING_RESTORE_MIRROR));
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.handleStartMirrorResult((ClusterLinkScheduler.TaskContext)tc, result.values()), taskContext));
            return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        this.warn((Function0<String> & Serializable)() -> "Mirror topic " + $this.topic + " is no longer in in PendingRestore state, shutting down task.");
        this.done_$eq(true);
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
    }

    private ClusterLinkScheduler.TaskResult handleStartMirrorResult(ClusterLinkScheduler.TaskContext taskContext, Map<String, KafkaFuture<Void>> topicResults) {
        Iterable errs;
        block0: {
            ExcessiveLoggingHandler excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
            scala.collection.mutable.Set nonRetriableErrorTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
            errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicResults).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Option option;
                    String topic = (String)tuple2._1();
                    KafkaFuture future = (KafkaFuture)tuple2._2();
                    try {
                        future.get();
                        this.done_$eq(true);
                        this.info((Function0<String> & Serializable)() -> "Successfully restored mirror topic '" + topic + "'");
                        option = None$.MODULE$;
                    }
                    catch (RetriableException e) {
                        String errMsg = "Failed to start mirror topic " + topic + " due to retriable exception.";
                        this.debug((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable>)(Function0<RetriableException> & Serializable)() -> e);
                        option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                    }
                    catch (Exception e) {
                        String errMsg = "Failed to start mirror topic " + topic + ".";
                        excessiveLoggingHandler.handle(e, this, errMsg);
                        nonRetriableErrorTopics.$plus$eq(topic);
                        option = new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                    }
                    return option;
                }
                throw new MatchError(tuple2);
            });
            if (!nonRetriableErrorTopics.nonEmpty()) break block0;
            this.warn((Function0<String> & Serializable)() -> "Failed to clear start offsets for mirror topics " + nonRetriableErrorTopics + ". Did not log the errors for " + excessiveLoggingHandler.ignoredWarnLogCount() + " of them to prevent excessive logging.");
        }
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)taskContext.errs().$plus$plus(errs));
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        if (this.clientManager.metadataManager().isLinkCoordinator(this.clientManager.linkData().linkName())) {
            this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager.metrics(), ClusterLinkClearMirrorStartOffsetsTaskType$.MODULE$, this.isPendingRestoreMirror(), "clear start offsets"));
        } else {
            this.taskDesc_$eq(None$.MODULE$);
        }
        if (this.done()) {
            this.debug((Function0<String> & Serializable)() -> "Clear start offsets task completed for topic '" + $this.topic + "'.'");
            this.shutdown();
            return;
        }
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasMirrorStartOffsets() {
        Option option = this.clientManager.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic);
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            if (!state.mirrorStartOffsets().exists(x$13 -> x$13 > 0L)) return false;
            MirrorTruncateMode mirrorTruncateMode = this.mirrorTruncateMode(state);
            MirrorTruncateMode$Ignore$ mirrorTruncateMode$Ignore$ = MirrorTruncateMode$Ignore$.MODULE$;
            if (mirrorTruncateMode == null) {
                if (mirrorTruncateMode$Ignore$ == null) return false;
                return true;
            } else if (mirrorTruncateMode.equals(mirrorTruncateMode$Ignore$)) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return false;
    }

    private boolean truncationComplete(TopicPartition tp, PartitionResult partitionResult) {
        return this.clientManager.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic}))).get(this.topic).filter((Function1<ClusterLinkTopicState, Object> & Serializable)state -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$truncationComplete$1(this, tp, state))).forall((Function1<ClusterLinkTopicState, Object> & Serializable)state -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$truncationComplete$2(this, tp, partitionResult, state)));
    }

    private boolean matchReplicas(PartitionResult partitionResult, Function1<ReplicaStatus, Object> predicate) {
        Buffer replicas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(partitionResult.replicas()).asScala().filter((Function1<ReplicaStatus, Object> & Serializable)x$16 -> BoxesRunTime.boxToBoolean(x$16.isIsrEligible()));
        return replicas.nonEmpty() && replicas.forall(predicate);
    }

    public MirrorTruncateMode mirrorTruncateMode(ClusterLinkTopicState mirrorState) {
        return mirrorState.state().mirrorTruncateMode();
    }

    public static final /* synthetic */ boolean $anonfun$handleReplicaStatusResult$6(ReplicaStatus.MirrorInfo info) {
        ReplicaStatus.MirrorInfo.State state = info.state();
        ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_RESTORE;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$handleReplicaStatusResult$8(ReplicaStatus leader$1, ReplicaStatus x$7) {
        return x$7.logEndOffset() == leader$1.logEndOffset();
    }

    private static final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture future$1) {
        Tuple2<None$, Some<TaskErrorCodeAndMsg>> tuple2;
        try {
            Collection result = (Collection)future$1.get();
            tuple2 = new Tuple2<Some<Collection>, None$>(new Some<Collection>(result), None$.MODULE$);
        }
        catch (ExecutionException e) {
            tuple2 = new Tuple2<None$, Some<TaskErrorCodeAndMsg>>(None$.MODULE$, new Some<TaskErrorCodeAndMsg>(ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg("Failed to list the consumer groups", true, e)));
        }
        return tuple2;
    }

    public static final /* synthetic */ void $anonfun$listGroupOffsets$2(ClusterLinkClearMirrorStartOffsets $this, ListConsumerGroupOffsetsSpec spec$1, ObjectRef futures$1, String group) {
        ListConsumerGroupOffsetsResult result = $this.localAdmin.listConsumerGroupOffsets(Collections.singletonMap(group, spec$1));
        futures$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)futures$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), result.partitionsToOffsetAndMetadata()));
    }

    public static final /* synthetic */ boolean $anonfun$handleListGroupOffsets$4(Tuple2 x$11) {
        return ((IterableOnceOps)x$11._2()).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$alterGroupOffsets$2(ClusterLinkClearMirrorStartOffsets $this, ObjectRef futures$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String group = (String)tuple2._1();
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)tuple2._2();
            AlterConsumerGroupOffsetsResult result = $this.localAdmin.alterConsumerGroupOffsets(group, CollectionConverters$.MODULE$.MapHasAsJava(offsets).asJava());
            futures$2.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)futures$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), result.all()));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$truncationComplete$1(ClusterLinkClearMirrorStartOffsets $this, TopicPartition tp$1, ClusterLinkTopicState state) {
        MirrorTruncateMode mirrorTruncateMode = $this.mirrorTruncateMode(state);
        MirrorTruncateMode$Ignore$ mirrorTruncateMode$Ignore$ = MirrorTruncateMode$Ignore$.MODULE$;
        return (mirrorTruncateMode == null ? mirrorTruncateMode$Ignore$ != null : !mirrorTruncateMode.equals(mirrorTruncateMode$Ignore$)) && state.mirrorStartOffsets().size() > tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$truncationComplete$3(long expectedOffset$1, ReplicaStatus x$14) {
        return x$14.logStartOffset() >= expectedOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncationComplete$4(long expectedOffset$1, ReplicaStatus x$15) {
        return x$15.logEndOffset() <= expectedOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncationComplete$2(ClusterLinkClearMirrorStartOffsets $this, TopicPartition tp$1, PartitionResult partitionResult$1, ClusterLinkTopicState state) {
        long expectedOffset = BoxesRunTime.unboxToLong(state.mirrorStartOffsets().apply(tp$1.partition()));
        MirrorTruncateMode mirrorTruncateMode = $this.mirrorTruncateMode(state);
        if (MirrorTruncateMode$Ignore$.MODULE$.equals(mirrorTruncateMode)) {
            return false;
        }
        if (MirrorTruncateMode$TruncateAtStart$.MODULE$.equals(mirrorTruncateMode)) {
            return $this.matchReplicas(partitionResult$1, (Function1<ReplicaStatus, Object> & Serializable)x$14 -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$truncationComplete$3(expectedOffset, x$14)));
        }
        if (MirrorTruncateMode$TruncateFromEnd$.MODULE$.equals(mirrorTruncateMode)) {
            return $this.matchReplicas(partitionResult$1, (Function1<ReplicaStatus, Object> & Serializable)x$15 -> BoxesRunTime.boxToBoolean(ClusterLinkClearMirrorStartOffsets.$anonfun$truncationComplete$4(expectedOffset, x$15)));
        }
        throw new MatchError(mirrorTruncateMode);
    }

    public ClusterLinkClearMirrorStartOffsets(String topic, ClusterLinkDestClientManager clientManager, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        this.topic = topic;
        this.clientManager = clientManager;
        this.localAdmin = localAdmin;
        super(clientManager.scheduler(), "ClusterLinkClearMirrorStartOffsets", intervalMs, time, quota);
        this.numRetriesWhenNoTopicPartitions = 0;
        this.done = false;
        this.clearOffsetsDone = false;
        this.consumerGroupOffsetClampingDone = false;
        this.isPendingRestoreMirror = false;
        this.taskDesc = None$.MODULE$;
    }
}

