/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kafka.server.CachedControllerId;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.link.BrokerAdminMetadataManager;
import kafka.server.link.ClusterLinkAdminRequestInterceptorFactory;
import kafka.server.link.ClusterLinkClientType;
import kafka.server.link.ClusterLinkClientType$LocalAdmin$;
import kafka.server.link.ClusterLinkClientType$LocalControllerAdmin$;
import kafka.server.link.ClusterLinkForwardingLocalAdmin;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkLocalAdmin$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.AdminRequestInterceptor;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.MetadataVersion;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;

public final class ClusterLinkLocalAdmin$
implements Logging {
    public static final ClusterLinkLocalAdmin$ MODULE$ = new ClusterLinkLocalAdmin$();
    private static final String MetricsGroupPrefix;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        MetricsGroupPrefix = "admin-client";
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkLocalAdmin$ clusterLinkLocalAdmin$ = this;
        synchronized (clusterLinkLocalAdmin$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String MetricsGroupPrefix() {
        return MetricsGroupPrefix;
    }

    public ClusterLinkLocalAdmin createLocalAdmin(KafkaConfig brokerConfig, Option<String> tenant, String adminId, AuthorizerServerInfo serverInfo, ClusterLinkMetadataManager linkMetadataManager, ClusterLinkManager clusterLinkManager, GroupCoordinator groupCoordinator, ClusterLinkScheduler scheduler, Option<Authorizer> authorizer, Metrics metrics, Time time, ListenerName interBrokerListenerName, Option<ControllerNodeProvider> kraftControllerNodeProvider, ConfluentAdmin interBrokerAdmin, Function0<MetadataVersion> metadataVersionSupplier) {
        ConfluentAdmin confluentAdmin;
        Option<ControllerNodeProvider> option = kraftControllerNodeProvider;
        if (option instanceof Some) {
            Some some = (Some)option;
            ControllerNodeProvider provider = (ControllerNodeProvider)some.value();
            confluentAdmin = this.createControllerAdmin(brokerConfig, tenant, adminId, serverInfo, linkMetadataManager, clusterLinkManager, groupCoordinator, scheduler, metrics, time, interBrokerListenerName, provider);
        } else if (None$.MODULE$.equals(option)) {
            confluentAdmin = interBrokerAdmin;
        } else {
            throw new MatchError(option);
        }
        ConfluentAdmin controllerAdmin = confluentAdmin;
        return new ClusterLinkLocalAdmin(brokerConfig, new Some<ClusterLinkMetadataManager>(linkMetadataManager), authorizer, interBrokerAdmin, controllerAdmin, metadataVersionSupplier);
    }

    public ClusterLinkLocalAdmin createForwardingLocalAdmin(KafkaConfig brokerConfig, AuthorizerServerInfo serverInfo, Option<Authorizer> authorizer, Function0<MetadataVersion> metadataVersionSupplier) {
        None$ linkName = None$.MODULE$;
        Map adminConfigs = ConfluentConfigs.clientConfigsForEndpoint((AbstractConfig)brokerConfig, (Endpoint)serverInfo.interBrokerEndpoint());
        adminConfigs.remove("metric.reporters");
        adminConfigs.put("enable.metrics.push", "false");
        String clientId = "cluster-link-" + linkName.getOrElse((Function0<String> & Serializable)() -> "") + "-" + ClusterLinkClientType$LocalAdmin$.MODULE$.name() + "-" + brokerConfig.brokerId();
        adminConfigs.put("client.id", clientId);
        ConfluentAdmin localAdmin = (ConfluentAdmin)Admin.create((Map)adminConfigs);
        return new ClusterLinkForwardingLocalAdmin(brokerConfig, authorizer, localAdmin, metadataVersionSupplier);
    }

    private String adminClientId(Option<String> linkName, KafkaConfig brokerConfig, String adminId, ClusterLinkClientType clientType) {
        Object clientIndex = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(adminId)) ? "-" + adminId : "";
        return "cluster-link-" + linkName.getOrElse((Function0<String> & Serializable)() -> "") + "-" + clientType.name() + (String)clientIndex + "-" + brokerConfig.brokerId();
    }

    public KafkaAdminClient createInterBrokerAdmin(Option<String> linkName, KafkaConfig brokerConfig, String adminId, AuthorizerServerInfo serverInfo, ClusterLinkMetadataManager linkMetadataManager, ClusterLinkManager clusterLinkManager, GroupCoordinator groupCoordinator, ClusterLinkScheduler scheduler, Metrics metrics, Time time, ListenerName interBrokerListenerName) {
        String clientId = this.adminClientId(linkName, brokerConfig, adminId, ClusterLinkClientType$LocalAdmin$.MODULE$);
        Map adminConfigs = ConfluentConfigs.clientConfigsForEndpoint((AbstractConfig)brokerConfig, (Endpoint)serverInfo.interBrokerEndpoint());
        adminConfigs.remove("metric.reporters");
        adminConfigs.put("client.id", clientId);
        ListenerName listenerName = new ListenerName((String)serverInfo.interBrokerEndpoint().listenerName().get());
        LogContext logContext = new LogContext("[AdminClient clientId=" + clientId + "] ");
        AdminClientConfig adminConfig = new AdminClientConfig(adminConfigs);
        MetadataCache metadataCache = linkMetadataManager.metadataCache();
        BrokerAdminMetadataManager adminMetadataManager = new BrokerAdminMetadataManager(logContext, adminConfig, metadataCache, listenerName){
            private final MetadataCache metadataCache$1;
            private final ListenerName listenerName$1;

            public Node controller() {
                return (Node)this.metadataCache$1.getControllerId().map((Function1<CachedControllerId, Node> & Serializable)controller -> this.nodeById(controller.id())).orNull($less$colon$less$.MODULE$.refl());
            }

            public Node nodeById(int nodeId) {
                return (Node)this.metadataCache$1.getAliveBrokerNode(nodeId, this.listenerName$1).orNull($less$colon$less$.MODULE$.refl());
            }
            {
                this.metadataCache$1 = metadataCache$1;
                this.listenerName$1 = listenerName$1;
                super(logContext$1, adminConfig$1, (Function0<List<Node>>)((Object)new Serializable(metadataCache$1, listenerName$1){
                    private static final long serialVersionUID = 0L;
                    private final MetadataCache metadataCache$1;
                    private final ListenerName listenerName$1;

                    public final List<Node> apply() {
                        return ClusterLinkLocalAdmin$.kafka$server$link$ClusterLinkLocalAdmin$$aliveNodes$1(this.metadataCache$1, this.listenerName$1);
                    }
                    {
                        this.metadataCache$1 = metadataCache$1;
                        this.listenerName$1 = listenerName$1;
                    }
                }));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$controller$1(kafka.server.link.ClusterLinkLocalAdmin$$anon$2 kafka.server.CachedControllerId )}, serializedLambda);
            }
        };
        ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder((AbstractConfig)adminConfig, (Time)time, (LogContext)logContext, null, null);
        return this.createAdmin(this.MetricsGroupPrefix(), adminConfig, adminMetadataManager, linkMetadataManager, clusterLinkManager, groupCoordinator, scheduler, channelBuilder, metrics, time, logContext, interBrokerListenerName, false, None$.MODULE$);
    }

    private ConfluentAdmin createControllerAdmin(KafkaConfig brokerConfig, Option<String> tenant, String adminId, AuthorizerServerInfo serverInfo, ClusterLinkMetadataManager linkMetadataManager, ClusterLinkManager clusterLinkManager, GroupCoordinator groupCoordinator, ClusterLinkScheduler scheduler, Metrics metrics, Time time, ListenerName interBrokerListenerName, ControllerNodeProvider kraftControllerNodeProvider) {
        String clientId = this.adminClientId(None$.MODULE$, brokerConfig, adminId, ClusterLinkClientType$LocalControllerAdmin$.MODULE$);
        Map adminConfigs = ConfluentConfigs.clientConfigsForEndpoint((AbstractConfig)brokerConfig, (Endpoint)serverInfo.interBrokerEndpoint());
        adminConfigs.remove("metric.reporters");
        adminConfigs.put("enable.metrics.push", "false");
        adminConfigs.put("client.id", clientId);
        LogContext logContext = new LogContext("[AdminClient clientId=" + clientId + "] ");
        AdminClientConfig adminConfig = new AdminClientConfig(adminConfigs);
        BrokerAdminMetadataManager adminMetadataManager = new BrokerAdminMetadataManager(logContext, adminConfig, kraftControllerNodeProvider){
            private final ControllerNodeProvider kraftControllerNodeProvider$1;

            public Node controller() {
                return (Node)this.kraftControllerNodeProvider$1.getControllerInfo().node().orNull($less$colon$less$.MODULE$.refl());
            }

            public Node nodeById(int nodeId) {
                return (Node)this.kraftControllerNodeProvider$1.getControllerInfo().node().filter((Function1<Node, Object> & Serializable)x$69 -> BoxesRunTime.boxToBoolean(anon.3.$anonfun$nodeById$1(nodeId, x$69))).orNull($less$colon$less$.MODULE$.refl());
            }

            public static final /* synthetic */ boolean $anonfun$nodeById$1(int nodeId$1, Node x$69) {
                return x$69.id() == nodeId$1;
            }
            {
                this.kraftControllerNodeProvider$1 = kraftControllerNodeProvider$1;
                super(logContext$2, adminConfig$2, (Function0<List<Node>>)((Object)new Serializable(kraftControllerNodeProvider$1){
                    private static final long serialVersionUID = 0L;
                    private final ControllerNodeProvider kraftControllerNodeProvider$1;

                    public final List<Node> apply() {
                        return ClusterLinkLocalAdmin$.kafka$server$link$ClusterLinkLocalAdmin$$aliveNodes$2(this.kraftControllerNodeProvider$1);
                    }
                    {
                        this.kraftControllerNodeProvider$1 = kraftControllerNodeProvider$1;
                    }
                }));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$nodeById$1$adapted(int org.apache.kafka.common.Node )}, serializedLambda);
            }
        };
        ControllerInformation controllerInfo = kraftControllerNodeProvider.getControllerInfo();
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerInfo.securityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)brokerConfig, (ListenerName)controllerInfo.listenerName(), (String)controllerInfo.saslMechanism(), (Time)time, (LogContext)logContext);
        return this.createAdmin(this.MetricsGroupPrefix(), adminConfig, adminMetadataManager, linkMetadataManager, clusterLinkManager, groupCoordinator, scheduler, channelBuilder, metrics, time, logContext, interBrokerListenerName, true, tenant);
    }

    private KafkaAdminClient createAdmin(String metricsGroupPrefix, AdminClientConfig adminConfig, BrokerAdminMetadataManager adminMetadataManager, ClusterLinkMetadataManager linkMetadataManager, ClusterLinkManager clusterLinkManager, GroupCoordinator groupCoordinator, ClusterLinkScheduler scheduler, ChannelBuilder channelBuilder, Metrics metrics, Time time, LogContext logContext, ListenerName interBrokerListenerName, boolean isKraftControllerAdmin, Option<String> tenant) {
        KafkaAdminClient kafkaAdminClient;
        String clientId = adminConfig.getString("client.id");
        Selector selector = null;
        ObjectRef<Object> networkClient = ObjectRef.create(null);
        try {
            selector = new Selector(-1, -1L, metrics, time, metricsGroupPrefix, Collections.singletonMap("client-id", clientId), false, channelBuilder, logContext);
            ApiVersions apiVersions = new ApiVersions();
            networkClient.elem = new NetworkClient((Selectable)selector, (MetadataUpdater)adminMetadataManager.updater(), clientId, 1, Predef$.MODULE$.Long2long(adminConfig.getLong("reconnect.backoff.ms")), Predef$.MODULE$.Long2long(adminConfig.getLong("reconnect.backoff.max.ms")), Predef$.MODULE$.Integer2int(adminConfig.getInt("send.buffer.bytes")), Predef$.MODULE$.Integer2int(adminConfig.getInt("receive.buffer.bytes")), (int)TimeUnit.HOURS.toMillis(1L), Predef$.MODULE$.Long2long(adminConfig.getLong("socket.connection.setup.timeout.ms")), Predef$.MODULE$.Long2long(adminConfig.getLong("socket.connection.setup.timeout.max.ms")), time, true, apiVersions, logContext, MetadataRecoveryStrategy.NONE);
            tenant.foreach((Function1<String, Object> & Serializable)requestTenant -> {
                ClusterLinkLocalAdmin$.$anonfun$createAdmin$1(networkClient, requestTenant);
                return BoxedUnit.UNIT;
            });
            ClusterLinkAdminRequestInterceptorFactory interceptorFactory = new ClusterLinkAdminRequestInterceptorFactory((NetworkClient)networkClient.elem, linkMetadataManager, clusterLinkManager, groupCoordinator, scheduler, adminConfig, logContext, apiVersions, interBrokerListenerName, isKraftControllerAdmin);
            kafkaAdminClient = (KafkaAdminClient)ConfluentAdminUtils.createConfluentAdmin((AdminClientConfig)adminConfig, (AdminMetadataManager)adminMetadataManager, (KafkaClient)((NetworkClient)networkClient.elem), (Time)time, (AdminRequestInterceptor.Factory)interceptorFactory);
        }
        catch (Throwable e) {
            this.warn((Function0<String> & Serializable)() -> "Failed to create cluster link admin client", (Function0<Throwable> & Serializable)() -> e);
            Utils.closeQuietly((AutoCloseable)((NetworkClient)networkClient.elem), (String)"NetworkClient");
            Utils.closeQuietly((AutoCloseable)selector, (String)"Selector");
            Utils.closeQuietly((AutoCloseable)channelBuilder, (String)"ChannelBuilder");
            throw e;
        }
        return kafkaAdminClient;
    }

    public static final List kafka$server$link$ClusterLinkLocalAdmin$$aliveNodes$1(MetadataCache metadataCache$1, ListenerName listenerName$1) {
        return metadataCache$1.getAliveBrokerNodes(listenerName$1).toList();
    }

    public static final List kafka$server$link$ClusterLinkLocalAdmin$$aliveNodes$2(ControllerNodeProvider kraftControllerNodeProvider$1) {
        return kraftControllerNodeProvider$1.getControllerInfo().node().toList();
    }

    public static final /* synthetic */ void $anonfun$createAdmin$1(ObjectRef networkClient$1, String requestTenant) {
        ((NetworkClient)networkClient$1.elem).enableClusterLinkInterceptor((ClientInterceptor)new ClusterLinkLocalAdmin.ControllerAdminTenantInterceptor(requestTenant));
    }

    private ClusterLinkLocalAdmin$() {
    }
}

