/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkControllerRequestCompletionHandler;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.KRaftImageMetadataCache;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterMirrorTopicsRequest;
import org.apache.kafka.common.requests.AlterMirrorTopicsResponse;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.ClusterLinkSwitchoverMetadata;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.apache.kafka.server.immutable.ImmutableMap;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t=g\u0001\u0002\u0016,\u0001IB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!I\u0001\t\u0001B\u0001B\u0003%\u0011i\u0012\u0005\n\u0011\u0002\u0011\t\u0011)A\u0005\u0013VC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\tK\u0002\u0011\t\u0011)A\u0005M\")A\u000e\u0001C\u0001[\")Q\u000f\u0001C!m\"9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0001bBA\r\u0001\u0011%\u00111\b\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\t\u0019\u0006\u0001C!\u0003+Bq!a\u0015\u0001\t\u0003\nI\u0006C\u0004\u0002T\u0001!\t%!\u0018\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u0011q\f\u0001\u0005B\u0005\u0015\u0004bBA0\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003S\u0002A\u0011IA6\u0011\u001d\ti\u0007\u0001C!\u0003_Bq!!\u001f\u0001\t\u0003\nY\bC\u0004\u0002\u0006\u0002!\t%a\"\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u00111\u0012\u0001\u0005\u0002\u0005e\u0005bBAP\u0001\u0011\u0005\u0013\u0011\u0015\u0005\b\u0003[\u0003A\u0011IAX\u0011\u001d\t\u0019\r\u0001C!\u0003\u000bDq!!3\u0001\t\u0003\nY\rC\u0004\u0002`\u0002!\t%!9\t\u000f\u0005=\b\u0001\"\u0011\u0002r\"9\u00111 \u0001\u0005B\u0005u\bb\u0002B\u0001\u0001\u0011\u0005#1\u0001\u0005\n\u0005G\u0001\u0011\u0013!C\u0001\u0005KA\u0011Ba\u000f\u0001#\u0003%\tA!\n\t\u0013\tu\u0002!%A\u0005\u0002\t}\u0002\"\u0003B\"\u0001E\u0005I\u0011\u0001B#\u0011\u001d\u0011I\u0005\u0001C!\u0005\u0017BqAa\u0014\u0001\t\u0013\u0011\t\u0006C\u0004\u0003p\u0001!IA!\u001d\t\u000f\t-\u0006\u0001\"\u0011\u0003.\"9!\u0011\u0019\u0001\u0005B\t\r\u0007\"\u0004Bc\u0001A\u0005\u0019\u0011!A\u0005\n\t\u001dwI\u0001\u0016DYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'oV5uQ.\u0013\u0016M\u001a;TkB\u0004xN\u001d;\u000b\u00051j\u0013\u0001\u00027j].T!AL\u0018\u0002\rM,'O^3s\u0015\u0005\u0001\u0014!B6bM.\f7\u0001A\n\u0003\u0001M\u0002\"\u0001N\u001b\u000e\u0003-J!AN\u0016\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0005eRT\"A\u0017\n\u0005mj#aC&bM.\f7i\u001c8gS\u001e\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005Qr\u0014BA ,\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\"AQ#\u000e\u0003\rS!\u0001R\u0017\u0002\u00115,G/\u00193bi\u0006L!AR\"\u0003/-\u0013\u0016M\u001a;J[\u0006<W-T3uC\u0012\fG/Y\"bG\",\u0017B\u0001!6\u0003a\u0019wN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\t\u0003\u0015Nk\u0011a\u0013\u0006\u0003\u00196\u000baaY8n[>t'B\u0001\u0018O\u0015\t\u0001tJ\u0003\u0002Q#\u00061\u0011\r]1dQ\u0016T\u0011AU\u0001\u0004_J<\u0017B\u0001+L\u0005yqu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/\u0003\u0002Ik\u0005\tBn\\2bY\u0006#W.\u001b8GC\u000e$xN]=\u0011\u0007a[V,D\u0001Z\u0015\u0005Q\u0016!B:dC2\f\u0017B\u0001/Z\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002_G6\tqL\u0003\u0002aC\u0006)\u0011\rZ7j]*\u0011!MT\u0001\bG2LWM\u001c;t\u0013\t!wLA\u0003BI6Lg.\u0001\u0006tKJ4XM]%oM>\u0004\"a\u001a6\u000e\u0003!T!!['\u0002\u0015\u0005,H\u000f[8sSj,'/\u0003\u0002lQ\n!\u0012)\u001e;i_JL'0\u001a:TKJ4XM]%oM>\fa\u0001P5oSRtDc\u00028paF\u00148\u000f\u001e\t\u0003i\u0001AQaN\u0004A\u0002aBQ\u0001P\u0004A\u0002uBQ\u0001Q\u0004A\u0002\u0005CQ\u0001S\u0004A\u0002%CQAV\u0004A\u0002]CQ!Z\u0004A\u0002\u0019\f1\"\\5se>\u0014Hk\u001c9jGR\u0011qo \t\u00041bT\u0018BA=Z\u0005\u0019y\u0005\u000f^5p]B\u001110`\u0007\u0002y*\u0011AIT\u0005\u0003}r\u00141\"T5se>\u0014Hk\u001c9jG\"9\u0011\u0011\u0001\u0005A\u0002\u0005\r\u0011!\u0002;pa&\u001c\u0007\u0003BA\u0003\u0003'qA!a\u0002\u0002\u0010A\u0019\u0011\u0011B-\u000e\u0005\u0005-!bAA\u0007c\u00051AH]8pizJ1!!\u0005Z\u0003\u0019\u0001&/\u001a3fM&!\u0011QCA\f\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011C-\u0002#5L'O]8s)>\u0004\u0018nY*uCR,7\u000f\u0006\u0003\u0002\u001e\u0005=\u0002\u0003CA\u0010\u0003K\t\u0019!!\u000b\u000e\u0005\u0005\u0005\"bAA\u00123\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0012\u0011\u0005\u0002\u0004\u001b\u0006\u0004\bc\u0001\u001b\u0002,%\u0019\u0011QF\u0016\u0003+\rcWo\u001d;fe2Kgn\u001b+pa&\u001c7\u000b^1uK\"9\u0011\u0011G\u0005A\u0002\u0005M\u0012!\u0003;pa&\u001c7o\u00149u!\u0011A\u00060!\u000e\u0011\r\u0005\u0015\u0011qGA\u0002\u0013\u0011\tI$a\u0006\u0003\u0007M+G\u000f\u0006\u0003\u0002\u001e\u0005u\u0002bBA \u0015\u0001\u0007\u0011\u0011I\u0001\u0007Y&t7.\u00133\u0011\t\u0005\r\u0013qI\u0007\u0003\u0003\u000bR!\u0001\u0014(\n\t\u0005%\u0013Q\t\u0002\u0005+VLG-\u0001\u0012nSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKN4%o\\7NKR\fG-\u0019;b'R|'/\u001a\u000b\u0005\u0003;\ty\u0005C\u0004\u0002R-\u0001\r!!\u000e\u0002\rQ|\u0007/[2t\u0003\tj\u0017N\u001d:peR{\u0007/[2Ti\u0006$Xm\u001d$s_6lU\r^1eCR\f7)Y2iKR!\u0011QDA,\u0011\u001d\ty\u0004\u0004a\u0001\u0003\u0003\"B!!\b\u0002\\!9\u0011\u0011K\u0007A\u0002\u0005UBCAA\u000f\u0003\u0019j\u0017N\u001d:peR{\u0007/[2Ti\u0006$Xm\u001d$s_6\u001cuN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u000b\u0005\u0003;\t\u0019\u0007C\u0004\u0002@=\u0001\r!!\u0011\u0015\t\u0005u\u0011q\r\u0005\b\u0003#\u0002\u0002\u0019AA\u001b\u0003U9W\r^!mYR{\u0007/[2t\u0013:\u001cE.^:uKJ$\"!!\u000e\u00025%\u001cHk\u001c9jGF+X-^3e+B4uN\u001d#fY\u0016$\u0018n\u001c8\u0015\t\u0005E\u0014q\u000f\t\u00041\u0006M\u0014bAA;3\n9!i\\8mK\u0006t\u0007bBA\u0001'\u0001\u0007\u00111A\u0001\u0018K:\u001cXO]3DYV\u001cH/\u001a:MS:\\W\t_5tiN$B!! \u0002\u0004B\u0019\u0001,a \n\u0007\u0005\u0005\u0015L\u0001\u0003V]&$\bbBA )\u0001\u0007\u0011\u0011I\u0001\u0012G2,8\u000f^3s\u0019&t7.\u0012=jgR\u001cH\u0003BA9\u0003\u0013Cq!a\u0010\u0016\u0001\u0004\t\t%\u0001\nhKR\u001cE.^:uKJd\u0015N\\6ECR\fG\u0003BAH\u0003/\u0003B\u0001\u0017=\u0002\u0012B\u0019A'a%\n\u0007\u0005U5FA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0011\u001d\tyD\u0006a\u0001\u0003\u0003\"B!a$\u0002\u001c\"9\u0011QT\fA\u0002\u0005\r\u0011\u0001\u00037j].t\u0015-\\3\u0002;\rdWo\u001d;fe2Kgn[*xSR\u001c\u0007n\u001c<fe6+G/\u00193bi\u0006$B!a)\u0002,B!\u0001\f_AS!\rY\u0018qU\u0005\u0004\u0003Sc(!H\"mkN$XM\u001d'j].\u001cv/\u001b;dQ>4XM]'fi\u0006$\u0017\r^1\t\u000f\u0005}\u0002\u00041\u0001\u0002B\u0005Ir-\u001a;DYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u0004&o\u001c9t)\u0011\t\t,!1\u0011\t\u0005M\u0016QX\u0007\u0003\u0003kSA!a.\u0002:\u0006!Q\u000f^5m\u0015\t\tY,\u0001\u0003kCZ\f\u0017\u0002BA`\u0003k\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\ty$\u0007a\u0001\u0003\u0003\nabZ3u)>\u0004\u0018nY\"p]\u001aLw\r\u0006\u0003\u00022\u0006\u001d\u0007bBA\u00015\u0001\u0007\u00111A\u0001\u001cC2$XM]\"mkN$XM\u001d'j].\u001cuN\u001c4jOjsu\u000eZ3\u0015\u0015\u0005u\u0014QZAh\u0003#\f)\u000eC\u0004\u0002@m\u0001\r!!\u0011\t\u000f\u0005u5\u00041\u0001\u0002\u0004!9\u00111[\u000eA\u0002\u0005E\u0016a\u00049feNL7\u000f^3oiB\u0013x\u000e]:\t\u000f\u0005]7\u00041\u0001\u0002Z\u0006QA.\u001b8l\u0007>tg-[4\u0011\u0007Q\nY.C\u0002\u0002^.\u0012\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003\u0001j\u0017-\u001f2f%\u0016,gn\u0019:zaR\u001cE.^:uKJd\u0015N\\6D_:4\u0017nZ:\u0015\t\u0005u\u00141\u001d\u0005\b\u0003Kd\u0002\u0019AAt\u0003E\u0019wN\u001c4jOR\u0013\u0018M\\:g_JlWM\u001d\t\b1\u0006%\u0018\u0011WAw\u0013\r\tY/\u0017\u0002\n\rVt7\r^5p]F\u0002B\u0001\u0017=\u00022\u000612M]3bi\u0016\u001cE.^:uKJd\u0015N\\6[\u001d>$W\r\u0006\u0004\u0002~\u0005M\u0018q\u001f\u0005\b\u0003kl\u0002\u0019AAI\u0003=\u0019G.^:uKJd\u0015N\\6ECR\f\u0007bBA};\u0001\u0007\u0011\u0011W\u0001\u0006aJ|\u0007o]\u0001\u0014g\u0016$8\t\\;ti\u0016\u0014H*\u001b8l5:{G-\u001a\u000b\u0005\u0003{\ny\u0010C\u0004\u0002vz\u0001\r!!%\u0002+\u0005dG/\u001a:NSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKR\u0001\u0012Q\u0010B\u0003\u0005\u000f\u0011yAa\u0005\u0003\u0018\tm!q\u0004\u0005\b\u0003\u0003y\u0002\u0019AA\u0002\u0011\u001d\u0011Ia\ba\u0001\u0005\u0017\tAb\u001d;bi\u0016,\u0006\u000fZ1uKJ\u0004r\u0001WAu\u0003S\u0011i\u0001\u0005\u0003Yq\u0006%\u0002b\u0002B\t?\u0001\u0007\u0011\u0011O\u0001\rm\u0006d\u0017\u000eZ1uK>sG.\u001f\u0005\n\u0005+y\u0002\u0013!a\u0001\u0003c\nqBZ1jY&3gj\u001c;NSJ\u0014xN\u001d\u0005\n\u00053y\u0002\u0013!a\u0001\u0003c\n\u0001$[:D_:4XM\u001d;U_B+g\u000eZ5oO6K'O]8s\u0011%\u0011ib\bI\u0001\u0002\u0004\t\u0019!A\bt_V\u00148-\u001a+pa&\u001cg*Y7f\u0011%\u0011\tc\bI\u0001\u0002\u0004\t\t%\u0001\u000bfqB,7\r^3e\u0019>\u001c\u0017\r\u001c+pa&\u001c\u0017\nZ\u0001 C2$XM]'jeJ|'\u000fV8qS\u000e\u001cF/\u0019;fI\u0011,g-Y;mi\u0012\"TC\u0001B\u0014U\u0011\t\tH!\u000b,\u0005\t-\u0002\u0003\u0002B\u0017\u0005oi!Aa\f\u000b\t\tE\"1G\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u000eZ\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005s\u0011yCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq$\u00197uKJl\u0015N\u001d:peR{\u0007/[2Ti\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00136\u0003}\tG\u000e^3s\u001b&\u0014(o\u001c:U_BL7m\u0015;bi\u0016$C-\u001a4bk2$HEN\u000b\u0003\u0005\u0003RC!a\u0001\u0003*\u0005y\u0012\r\u001c;fe6K'O]8s)>\u0004\u0018nY*uCR,G\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t\u001d#\u0006BA!\u0005S\ta\u0003Z3mKR,7\t\\;ti\u0016\u0014H*\u001b8l5:{G-\u001a\u000b\u0005\u0003{\u0012i\u0005C\u0004\u0002@\u0011\u0002\r!!\u0011\u0002!\u0005dG/\u001a:NSJ\u0014xN\u001d+pa&\u001cGC\u0003B*\u0005K\u00129Ga\u001b\u0003nA1\u00111\tB+\u00053JAAa\u0016\u0002F\tY1*\u00194lC\u001a+H/\u001e:f!\u0011\u0011YF!\u0019\u000e\u0005\tu#\u0002\u0002B0\u0003s\u000bA\u0001\\1oO&!!1\rB/\u0005\u00111v.\u001b3\t\u000f\u0005\u0005Q\u00051\u0001\u0002\u0004!9!\u0011N\u0013A\u0002\u0005%\u0012\u0001E7jeJ|'\u000fV8qS\u000e\u001cF/\u0019;f\u0011\u001d\u0011i\"\na\u0001\u0003\u0007AqA!\t&\u0001\u0004\t\t%A\u000etK:$\u0017\t\u001c;fe6K'O]8s)>\u0004\u0018n\u0019*fcV,7\u000f\u001e\u000b\u0007\u0003{\u0012\u0019Ha'\t\u000f\t=c\u00051\u0001\u0003vA!!q\u000fBK\u001d\u0011\u0011IHa$\u000f\t\tm$1\u0012\b\u0005\u0005{\u0012II\u0004\u0003\u0003\u0000\t\u001de\u0002\u0002BA\u0005\u000bsA!!\u0003\u0003\u0004&\t!+\u0003\u0002Q#&\u0011\u0001gT\u0005\u0003\u0019:KAA!$\u0002F\u00059Q.Z:tC\u001e,\u0017\u0002\u0002BI\u0005'\u000bA$\u00117uKJl\u0015N\u001d:peR{\u0007/[2t%\u0016\fX/Z:u\t\u0006$\u0018M\u0003\u0003\u0003\u000e\u0006\u0015\u0013\u0002\u0002BL\u00053\u0013\u0001#\u00117uKJl\u0015N\u001d:peR{\u0007/[2\u000b\t\tE%1\u0013\u0005\b\u0005;3\u0003\u0019\u0001BP\u0003\u0019\u0011Xm];miB1!\u0011\u0015BT\u00053j!Aa)\u000b\t\t\u0015\u0016QI\u0001\nS:$XM\u001d8bYNLAA!+\u0003$\ny1*\u00194lC\u001a+H/\u001e:f\u00136\u0004H.A\fhKR\fE\u000e\u001c'j].\u001chI]8n\u001b\u0016$\u0018\rZ1uCR\u0011!q\u0016\t\u0007\u0005c\u0013Y,!%\u000f\t\tM&q\u0017\b\u0005\u0003\u0013\u0011),C\u0001[\u0013\r\u0011I,W\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iLa0\u0003\u0007M+\u0017OC\u0002\u0003:f\u000b\u0001$[:MS:\\7i\\8sI&t\u0017\r^8s\u000b:\f'\r\\3e+\t\t\t(A\ntkB,'\u000fJ7fi\u0006$\u0017\r^1DC\u000eDW-\u0006\u0002\u0003JB\u0019\u0011Ha3\n\u0007\t5WFA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a")
public class ClusterLinkMetadataManagerWithKRaftSupport
extends ClusterLinkMetadataManager {
    private final Function0<Admin> localAdminFactory;

    private /* synthetic */ MetadataCache super$metadataCache() {
        return super.metadataCache();
    }

    @Override
    public Option<MirrorTopic> mirrorTopic(String topic) {
        return Option$.MODULE$.apply(((KRaftImageMetadataCache)super.metadataCache()).currentImage().topics().getTopic(topic)).flatMap((Function1<TopicImage, Option> & Serializable)x$1 -> OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(x$1.mirrorTopic())));
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Option<Set<String>> topicsOpt) {
        Set set;
        MetadataImage image = ((KRaftImageMetadataCache)super.metadataCache()).currentImage();
        Option<Set<String>> option = topicsOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Set topics = (Set)some.value();
            set = (Set)topics.map((Function1<String, Option> & Serializable)topic -> Option$.MODULE$.apply(image.topics().getTopic((String)topic)).flatMap((Function1<TopicImage, Option> & Serializable)x$2 -> OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(x$2.mirrorTopic()))));
        } else if (None$.MODULE$.equals(option)) {
            set = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(image.topics().topicsByName()).asScala().values().map((Function1<TopicImage, Option> & Serializable)x$3 -> OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(x$3.mirrorTopic())))).toSet();
        } else {
            throw new MatchError(option);
        }
        Set mirrorStates = set;
        return ((IterableOnceOps)((IterableOps)mirrorStates.filter((Function1<Option, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.isDefined()))).map((Function1<Option, Tuple2> & Serializable)stateOpt -> {
            MirrorTopic state = (MirrorTopic)stateOpt.get();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(state.topicName()), ClusterLinkTopicState$.MODULE$.apply(state));
        })).toMap($less$colon$less$.MODULE$.refl());
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Uuid linkId) {
        MetadataImage image = ((KRaftImageMetadataCache)super.metadataCache()).currentImage();
        ImmutableMap<Uuid, TopicImage> mirrorTopics = image.topics().topicsByLinkId(linkId);
        return ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(mirrorTopics).asScala().filter((Function1<Tuple2, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$mirrorTopicStates$6(x$5)))).map((Function1<Tuple2, Tuple2> & Serializable)entry -> {
            ClusterLinkTopicState state = ClusterLinkTopicState$.MODULE$.apply(((TopicImage)entry._2()).mirrorTopic().get());
            return new Tuple2<String, ClusterLinkTopicState>(((TopicImage)entry._2()).name(), state);
        }).toMap($less$colon$less$.MODULE$.refl());
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataStore(Set<String> topics) {
        return this.mirrorTopicStates(new Some<Set<String>>(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Set<String> topics) {
        return this.mirrorTopicStates(new Some<Set<String>>(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache() {
        return this.mirrorTopicStates(None$.MODULE$);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Set<String> topics) {
        return this.mirrorTopicStates(new Some<Set<String>>(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext() {
        return this.mirrorTopicStates(None$.MODULE$);
    }

    @Override
    public Set<String> getAllTopicsInCluster() {
        return CollectionConverters$.MODULE$.SetHasAsScala(((KRaftImageMetadataCache)super.metadataCache()).currentImage().topics().topicsByName().keySet()).asScala().toSet();
    }

    @Override
    public boolean isTopicQueuedUpForDeletion(String topic) {
        return false;
    }

    @Override
    public void ensureClusterLinkExists(Uuid linkId) {
        if (!this.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException("Cluster link with ID '" + linkId + "' does not exist.");
        }
    }

    @Override
    public boolean clusterLinkExists(Uuid linkId) {
        return ((KRaftImageMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById().containsKey(linkId);
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(Uuid linkId) {
        java.util.Map<Uuid, ClusterLink> clusterLinks = ((KRaftImageMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById();
        if (clusterLinks.containsKey(linkId)) {
            ClusterLink clusterLink = clusterLinks.get(linkId);
            return new Some<ClusterLinkData>(new ClusterLinkData(clusterLink.linkName(), linkId, new Some<String>(clusterLink.remoteClusterId()), OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(String linkName) {
        java.util.Map<String, ClusterLink> clusterLinks = ((KRaftImageMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksByName();
        if (clusterLinks.containsKey(linkName)) {
            ClusterLink clusterLink = clusterLinks.get(linkName);
            return new Some<ClusterLinkData>(new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), new Some<String>(clusterLink.remoteClusterId()), OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<ClusterLinkSwitchoverMetadata> clusterLinkSwitchoverMetadata(Uuid linkId) {
        java.util.Map<Uuid, ClusterLink> clusterLinks = ((KRaftImageMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById();
        if (clusterLinks.containsKey(linkId)) {
            ClusterLink clusterLink = clusterLinks.get(linkId);
            return OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(clusterLink.switchoverMetadata()));
        }
        return None$.MODULE$;
    }

    @Override
    public Properties getClusterLinkConfigProps(Uuid linkId) {
        this.ensureClusterLinkExists(linkId);
        return ((KRaftImageMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
    }

    @Override
    public Properties getTopicConfig(String topic) {
        return ((KRaftImageMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.TOPIC, topic));
    }

    @Override
    public void alterClusterLinkConfigZNode(Uuid linkId, String linkName, Properties persistentProps, ClusterLinkConfig linkConfig) {
        throw new IllegalStateException("Altering link configs in the ZNode is not supported in KRaft mode.");
    }

    @Override
    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        scala.collection.mutable.Map<Uuid, ClusterLink> clusterLinks = CollectionConverters$.MODULE$.MapHasAsScala(((KRaftImageMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala();
        HashMap alterConfigRequestMap = new HashMap(clusterLinks.size());
        clusterLinks.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Uuid linkId = (Uuid)tuple2._1();
                ClusterLink clusterLink = (ClusterLink)tuple2._2();
                ConfigResource configResourceLinkId = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString());
                Option newEncodedProps = (Option)configTransformer.apply(((KRaftImageMetadataCache)this.super$metadataCache()).config(configResourceLinkId));
                Option option = newEncodedProps;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Properties props = (Properties)some.value();
                    HashSet newConfigs = new HashSet();
                    CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1<Tuple2, Object> & Serializable)entry -> BoxesRunTime.boxToBoolean(newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                    ConfigResource configResourceLinkName = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, clusterLink.linkName());
                    return alterConfigRequestMap.put(configResourceLinkName, newConfigs);
                }
                if (None$.MODULE$.equals(option)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(option);
            }
            throw new MatchError(tuple2);
        });
        if (!alterConfigRequestMap.isEmpty()) {
            if (this.localAdmin() == null) {
                this.localAdmin_$eq(this.localAdminFactory.apply());
            }
            this.localAdmin().incrementalAlterConfigs(alterConfigRequestMap).all().get();
            return;
        }
    }

    @Override
    public void createClusterLinkZNode(ClusterLinkData clusterLinkData, Properties props) {
        throw new IllegalStateException("Creating a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void setClusterLinkZNode(ClusterLinkData clusterLinkData) {
        throw new IllegalStateException("Setting a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void alterMirrorTopicState(String topic, Function1<ClusterLinkTopicState, Option<ClusterLinkTopicState>> stateUpdater, boolean validateOnly, boolean failIfNotMirror, boolean isConvertToPendingMirror, String sourceTopicName, Uuid expectedLocalTopicId) {
        Option currentState = this.mirrorTopicStatesFromMetadataStore((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get(topic);
        if (currentState.isEmpty() && failIfNotMirror && !isConvertToPendingMirror) {
            throw new InvalidRequestException("Topic " + topic + " is not a mirror topic");
        }
        if (currentState.isEmpty() && isConvertToPendingMirror && !validateOnly) {
            this.applyState$1(null, stateUpdater, validateOnly, topic, sourceTopicName, expectedLocalTopicId);
        }
        currentState.foreach((Function1<ClusterLinkTopicState, Object> & Serializable)state -> {
            this.applyState$1(state, stateUpdater, validateOnly, topic, sourceTopicName, expectedLocalTopicId);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void deleteClusterLinkZNode(Uuid linkId) {
        throw new IllegalStateException("Deleting a cluster link ZNode is not supported in KRaft mode.");
    }

    private KafkaFuture<Void> alterMirrorTopic(String topic, ClusterLinkTopicState mirrorTopicState, String sourceTopicName, Uuid expectedLocalTopicId) {
        AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic = new AlterMirrorTopicsRequestData.AlterMirrorTopic().setTopic(topic);
        KafkaFutureImpl result = new KafkaFutureImpl();
        ClusterLinkTopicState clusterLinkTopicState = mirrorTopicState;
        if (clusterLinkTopicState instanceof ClusterLinkTopicState.Mirror) {
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.MIRROR.stateName());
        } else if (clusterLinkTopicState instanceof ClusterLinkTopicState.PausedMirror) {
            ClusterLinkTopicState.PausedMirror pausedMirror = (ClusterLinkTopicState.PausedMirror)clusterLinkTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setLinkLevelPause(pausedMirror.linkLevel()).setTopicLevelPause(pausedMirror.topicLevel()).setMirrorTopicError(pausedMirror.mirrorTopicError().code());
        } else if (clusterLinkTopicState instanceof ClusterLinkTopicState.FailedMirror) {
            ClusterLinkTopicState.FailedMirror failedMirror = (ClusterLinkTopicState.FailedMirror)clusterLinkTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(failedMirror.mirrorTopicError().code());
        } else if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
            ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)clusterLinkTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName()).setPromoted(pendingStoppedMirror.synchronize());
        } else if (clusterLinkTopicState instanceof ClusterLinkTopicState.StoppedMirror) {
            ClusterLinkTopicState.StoppedMirror stoppedMirror = (ClusterLinkTopicState.StoppedMirror)clusterLinkTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName()).setStoppedLogEndOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)stoppedMirror.logEndOffsets().map((Function1<Object, Long> & Serializable)x$1 -> BoxesRunTime.unboxToLong(x$1))).asJava()).setStoppedEpochs(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)stoppedMirror.stoppedEpochs().map((Function1<Object, Integer> & Serializable)x$1 -> BoxesRunTime.unboxToInt(x$1))).asJava());
        } else if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingMirror) {
            ClusterLinkTopicState.PendingMirror pendingMirror = (ClusterLinkTopicState.PendingMirror)clusterLinkTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_MIRROR.stateName()).setLinkId(pendingMirror.linkId()).setSourceTopicId(pendingMirror.sourceTopicId()).setSourceTopicName(sourceTopicName).setExpectedLocalTopicId(expectedLocalTopicId).setNextState(pendingMirror.nextState()).setStoppedSequenceNumber(pendingMirror.stoppedSequenceNumber());
        } else if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingSynchronizeMirror) {
            ClusterLinkTopicState.PendingSynchronizeMirror pendingSynchronizeMirror = (ClusterLinkTopicState.PendingSynchronizeMirror)clusterLinkTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_SYNCHRONIZE.stateName()).setNextState(pendingSynchronizeMirror.remoteMirrorNextState().name());
        } else if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingRepairMirror) {
            ClusterLinkTopicState.PendingRepairMirror pendingRepairMirror = (ClusterLinkTopicState.PendingRepairMirror)clusterLinkTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_REPAIR.stateName()).setMirrorTopicError(pendingRepairMirror.mirrorTopicError().code());
        } else {
            if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingRestoreMirror ? true : clusterLinkTopicState instanceof ClusterLinkTopicState.PendingSetupForRestoreMirror) {
                throw new InvalidRequestException("Unsupported operation on topic " + topic + " in state " + mirrorTopicState.state().name());
            }
            throw new MatchError(clusterLinkTopicState);
        }
        alterMirrorTopic.setMirrorStartOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)mirrorTopicState.mirrorStartOffsets().map((Function1<Object, Long> & Serializable)x -> ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopic$3(BoxesRunTime.unboxToLong(x)))).asJava());
        this.sendAlterMirrorTopicRequest(alterMirrorTopic, (KafkaFutureImpl<Void>)result);
        return result;
    }

    @Override
    public boolean alterMirrorTopicState$default$4() {
        return true;
    }

    @Override
    public boolean alterMirrorTopicState$default$5() {
        return false;
    }

    @Override
    public String alterMirrorTopicState$default$6() {
        return "";
    }

    @Override
    public Uuid alterMirrorTopicState$default$7() {
        return Uuid.ZERO_UUID;
    }

    private void sendAlterMirrorTopicRequest(AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic, KafkaFutureImpl<Void> result) {
        AlterMirrorTopicsRequest.Builder builder = new AlterMirrorTopicsRequest.Builder(alterMirrorTopic, false, this.requestTimeoutMs());
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, alterMirrorTopic, result){
            private final AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic$1;
            private final KafkaFutureImpl result$1;

            public void handleResponse(AbstractResponse response) {
                this.debug((Function0<String> & Serializable)() -> "Received response for alterMirrorTopicRequest");
                AlterMirrorTopicsResponse message = (AlterMirrorTopicsResponse)response;
                message.complete(Collections.singletonMap(this.alterMirrorTopic$1.topic(), this.result$1));
            }

            public void onFailure(Throwable ex) {
                this.debug((Function0<String> & Serializable)() -> "alterMirrorTopic request failed with exception", (Function0<Throwable> & Serializable)() -> ex);
                this.result$1.completeExceptionally(ex);
            }
            {
                this.alterMirrorTopic$1 = alterMirrorTopic$1;
                this.result$1 = result$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleResponse$1(), $anonfun$onFailure$1(), $anonfun$onFailure$2(java.lang.Throwable )}, serializedLambda);
            }
        };
        super.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)builder, requestHandler);
    }

    @Override
    public scala.collection.immutable.Seq<ClusterLinkData> getAllLinksFromMetadata() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(((KRaftImageMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala().values().map((Function1<ClusterLink, ClusterLinkData> & Serializable)clusterLink -> new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), new Some<String>(clusterLink.remoteClusterId()), OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(clusterLink.tenantPrefix())), false))).toSeq();
    }

    @Override
    public boolean isLinkCoordinatorEnabled() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$mirrorTopicStates$6(Tuple2 x$5) {
        return ((TopicImage)x$5._2()).mirrorTopic().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$alterMirrorTopicState$2(ClusterLinkTopicState x$6) {
        return x$6 != null;
    }

    private final void applyState$1(ClusterLinkTopicState state, Function1 stateUpdater$1, boolean validateOnly$1, String topic$1, String sourceTopicName$1, Uuid expectedLocalTopicId$1) {
        ((Option)stateUpdater$1.apply(state)).filter((Function1<ClusterLinkTopicState, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopicState$2(x$6))).foreach((Function1<ClusterLinkTopicState, Object> & Serializable)newState -> {
            if (!validateOnly$1) {
                Object object;
                try {
                    object = this.alterMirrorTopic(topic$1, (ClusterLinkTopicState)newState, sourceTopicName$1, expectedLocalTopicId$1).get();
                }
                catch (ExecutionException ex) {
                    throw ex.getCause();
                }
                catch (Throwable ex) {
                    throw ex;
                }
                return object;
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Long $anonfun$alterMirrorTopic$3(long x) {
        return BoxesRunTime.boxToLong(x);
    }

    public ClusterLinkMetadataManagerWithKRaftSupport(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, KRaftImageMetadataCache metadataCache, NodeToControllerChannelManager controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo) {
        this.localAdminFactory = localAdminFactory;
        super(brokerConfig, scheduler, metadataCache, controllerChannelManager, localAdminFactory, serverInfo);
    }
}

