/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.SocketServer;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkChannelContext;
import kafka.server.link.ClusterLinkClientType$OutboundConnectionAdmin$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.CoordinatorListener;
import kafka.server.link.LazyResource;
import kafka.server.link.RemoteNetworkClient;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.message.ReverseConnectionRequestData;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0015b\u0001\u0002*T\u0001iC\u0011\"\u001b\u0001\u0003\u0002\u0003\u0006IA[7\t\u00119\u0004!\u0011!Q\u0001\n=D!B\u001d\u0001\u0003\u0002\u0003\u0006Ia]A\u0001\u0011)\t\u0019\u0001\u0001B\u0001B\u0003%\u0011Q\u0001\u0005\u000b\u0003G\u0001!\u0011!Q\u0001\n\u0005\u0015\u0002BCA\u0016\u0001\t\u0005\t\u0015!\u0003\u0002.!Q\u00111\u0007\u0001\u0003\u0002\u0003\u0006I!!\u000e\t\u0015\u0005m\u0002A!A!\u0002\u0013\ti\u0004\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003\u0017B!\"a\u0015\u0001\u0005\u0003\u0005\u000b\u0011BA+\u0011)\t\u0019\u0007\u0001B\u0001B\u0003%\u0011Q\r\u0005\u000b\u0003W\u0002!\u0011!Q\u0001\n\u00055\u0004BCA;\u0001\t\u0005\t\u0015!\u0003\u0002x!Q\u0011q\u0011\u0001\u0003\u0002\u0003\u0006I!!#\t\u0015\u0005=\u0005A!A!\u0002\u0013\t\t\n\u0003\u0006\u0002\u0018\u0002\u0011\t\u0011)A\u0005\u00033Cq!a(\u0001\t\u0003\t\t\u000bC\u0005\u0002F\u0002\u0011\r\u0011\"\u0003\u0002H\"A\u0011\u0011\u001c\u0001!\u0002\u0013\tI\rC\u0005\u0002\\\u0002\u0011\r\u0011\"\u0003\u0002^\"A\u0011q \u0001!\u0002\u0013\ty\u000eC\u0005\u0003\u0002\u0001\u0011\r\u0011\"\u0003\u0002^\"A!1\u0001\u0001!\u0002\u0013\ty\u000eC\u0005\u0003\u0006\u0001\u0011\r\u0011\"\u0003\u0003\b!A!Q\u0003\u0001!\u0002\u0013\u0011I\u0001C\u0005\u0003\u0018\u0001\u0001\r\u0011\"\u0003\u0003\u001a!I!\u0011\u0005\u0001A\u0002\u0013%!1\u0005\u0005\t\u0005_\u0001\u0001\u0015)\u0003\u0003\u001c!I!\u0011\u0007\u0001C\u0002\u0013%!1\u0007\u0005\t\u0005s\u0001\u0001\u0015!\u0003\u00036!I!1\b\u0001C\u0002\u0013%!Q\b\u0005\t\u0005\u007f\u0001\u0001\u0015!\u0003\u0002p\"I!\u0011\t\u0001C\u0002\u0013%!Q\b\u0005\t\u0005\u0007\u0002\u0001\u0015!\u0003\u0002p\"I!Q\t\u0001C\u0002\u0013%!q\t\u0005\t\u0005\u001f\u0002\u0001\u0015!\u0003\u0003J!Q!\u0011\u000b\u0001C\u0002\u0013\u00051Ka\u0015\t\u0011\tu\u0003\u0001)A\u0005\u0005+B1Ba\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003b!Y!1\u000e\u0001A\u0002\u0003\u0007I\u0011\u0002B7\u0011-\u0011\t\b\u0001a\u0001\u0002\u0003\u0006KAa\u0019\t\u0017\tm\u0004\u00011AA\u0002\u0013%!Q\u0010\u0005\f\u0005\u000b\u0003\u0001\u0019!a\u0001\n\u0013\u00119\tC\u0006\u0003\f\u0002\u0001\r\u0011!Q!\n\t}\u0004b\u0003BH\u0001\u0001\u0007\t\u0019!C\u0005\u0005#C1Ba(\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\"\"Y!Q\u0015\u0001A\u0002\u0003\u0005\u000b\u0015\u0002BJ\u0011%\u0011I\u000b\u0001a\u0001\n\u0013\u0011Y\u000bC\u0005\u00036\u0002\u0001\r\u0011\"\u0003\u00038\"A!1\u0018\u0001!B\u0013\u0011i\u000bC\u0004\u0003@\u0002!\tE!1\t\u0011\t\r\u0007\u0001\"\u0011T\u0005\u000bDqA!6\u0001\t\u0003\u0012\t\rC\u0004\u0003X\u0002!\tE!7\t\u000f\tU\b\u0001\"\u0011\u0003x\"91\u0011\u0007\u0001\u0005B\rM\u0002bBB%\u0001\u0011%11\n\u0005\b\u0007S\u0002A\u0011BB6\u0011\u001d\u0019\t\t\u0001C\u0005\u0007\u0007Cqaa#\u0001\t\u0003\u001ai\tC\u0004\u0004\u001a\u0002!\tea'\t\u000f\r\u0005\u0006\u0001\"\u0011\u0003B\"911\u0015\u0001\u0005\n\t\u0005\u0007bBBS\u0001\u0011E#\u0011\u0019\u0005\b\u0007O\u0003A\u0011\u000bBa\u0011!\u0019I\u000b\u0001C\u0001'\u000e-\u0006\u0002CBW\u0001\u0011\u00051ka,\t\u000f\rE\u0006\u0001\"\u0003\u00044\"91\u0011\u0018\u0001\u0005\n\rm\u0006bBBb\u0001\u0011%!\u0011\u0019\u0005\b\u0007\u000b\u0004A\u0011\u0002B\r\u0011\u001d\u0019\u0019\r\u0001C\u0005\u0007\u000fDqaa3\u0001\t\u0013\u0011\t\rC\u0004\u0004N\u0002!IA!1\t\u000f\r=\u0007\u0001\"\u0003\u0003B\"91\u0011\u001b\u0001\u0005\n\rM\u0007bBBu\u0001\u0011E11\u001e\u0005\t\u0007c\u0004A\u0011A*\u0004t\"91Q \u0001\u0005B\tu\u0002bBB\u0000\u0001\u0011\u0005#Q\b\u0005\b\t\u0003\u0001A\u0011\tC\u0002\u0005\u0011\u001aE.^:uKJd\u0015N\\6PkR\u0014w.\u001e8e\u0007>tg.Z2uS>tW*\u00198bO\u0016\u0014(B\u0001+V\u0003\u0011a\u0017N\\6\u000b\u0005Y;\u0016AB:feZ,'OC\u0001Y\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A.`MB\u0011A,X\u0007\u0002'&\u0011al\u0015\u0002\u001d\u00072,8\u000f^3s\u0019&t7nQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s!\t\u00017M\u0004\u0002]C&\u0011!mU\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u00180\u0003\u0002eK\nIr*\u001e;c_VtGmQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0015\t\u00117\u000b\u0005\u0002]O&\u0011\u0001n\u0015\u0002\u0014\u0007>|'\u000fZ5oCR|'\u000fT5ti\u0016tWM]\u0001\tY&t7\u000eR1uCB\u0011Al[\u0005\u0003YN\u0013qb\u00117vgR,'\u000fT5oW\u0012\u000bG/Y\u0005\u0003Sv\u000bQ\"\u001b8ji&\fGnQ8oM&<\u0007C\u0001/q\u0013\t\t8KA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\f1\u0003\\8dC2dunZ5dC2\u001cE.^:uKJ\u0004\"\u0001^?\u000f\u0005U\\\bC\u0001<z\u001b\u00059(B\u0001=Z\u0003\u0019a$o\\8u})\t!0A\u0003tG\u0006d\u0017-\u0003\u0002}s\u00061\u0001K]3eK\u001aL!A`@\u0003\rM#(/\u001b8h\u0015\ta\u00180\u0003\u0002s;\u0006\t2\r\\5f]RLe\u000e^3sG\u0016\u0004Ho\u001c:\u0011\r\u0005\u001d\u0011\u0011BA\u0007\u001b\u0005I\u0018bAA\u0006s\n1q\n\u001d;j_:\u0004B!a\u0004\u0002 5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0004dY&,g\u000e^:\u000b\u0007a\u000b9B\u0003\u0003\u0002\u001a\u0005m\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u001e\u0005\u0019qN]4\n\t\u0005\u0005\u0012\u0011\u0003\u0002\u0012\u00072LWM\u001c;J]R,'oY3qi>\u0014\u0018aB7fiJL7m\u001d\t\u00049\u0006\u001d\u0012bAA\u0015'\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003]\u0019X\r\\3di>\u0014X*\u001a;sS\u000e\u001c(+Z4jgR\u0014\u0018\u0010E\u0002]\u0003_I1!!\rT\u0005\t\u001aE.^:uKJd\u0015N\\6TK2,7\r^8s\u001b\u0016$(/[2t%\u0016<\u0017n\u001d;ss\u0006yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000fE\u0002]\u0003oI1!!\u000fT\u0005i\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u00031\u0019xnY6fiN+'O^3s!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"/\u00069a.\u001a;x_J\\\u0017\u0002BA$\u0003\u0003\u0012AbU8dW\u0016$8+\u001a:wKJ\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004B!!\u0014\u0002P5\tQ+C\u0002\u0002RU\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006Q1/\u001a:wKJLeNZ8\u0011\t\u0005]\u0013qL\u0007\u0003\u00033RA!a\u0017\u0002^\u0005Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0007Y\u000b)\"\u0003\u0003\u0002b\u0005e#\u0001F!vi\"|'/\u001b>feN+'O^3s\u0013:4w.A\u0003rk>$\u0018\r\u0005\u0003\u0002N\u0005\u001d\u0014bAA5+\n92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0001\u001aG2,8\u000f^3s\u0019&t7n\u00115b]:,GnQ8oi\u0016DH\u000f\u0005\u0004\u0002\b\u0005%\u0011q\u000e\t\u00049\u0006E\u0014bAA:'\nI2\t\\;ti\u0016\u0014H*\u001b8l\u0007\"\fgN\\3m\u0007>tG/\u001a=u\u0003\u0011!\u0018.\\3\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005)Q\u000f^5mg*!\u0011\u0011QA\u000b\u0003\u0019\u0019w.\\7p]&!\u0011QQA>\u0005\u0011!\u0016.\\3\u00021\u0015t\u0017M\u00197f%\u00164XM]:f\u0007>tg.Z2uS>t7\u000f\u0005\u0003\u0002\b\u0005-\u0015bAAGs\n9!i\\8mK\u0006t\u0017!I5oiJ\fg.\u001a;D_:tWm\u0019;jm&$\u0018\u0010R3oS\u0016$7\t[3dW\u0016\u0014\bCBA\u0004\u0003'\u000bI)C\u0002\u0002\u0016f\u0014\u0011BR;oGRLwN\u001c\u0019\u0002\u001b1Lgn[*dQ\u0016$W\u000f\\3s!\ra\u00161T\u0005\u0004\u0003;\u001b&\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0001\u0004=S:LGO\u0010\u000b#\u0003G\u000b)+a*\u0002*\u0006-\u0016QVAX\u0003c\u000b\u0019,!.\u00028\u0006e\u00161XA_\u0003\u007f\u000b\t-a1\u0011\u0005q\u0003\u0001\"B5\u0012\u0001\u0004Q\u0007\"\u00028\u0012\u0001\u0004y\u0007\"\u0002:\u0012\u0001\u0004\u0019\bbBA\u0002#\u0001\u0007\u0011Q\u0001\u0005\b\u0003G\t\u0002\u0019AA\u0013\u0011\u001d\tY#\u0005a\u0001\u0003[Aq!a\r\u0012\u0001\u0004\t)\u0004C\u0004\u0002<E\u0001\r!!\u0010\t\u000f\u0005%\u0013\u00031\u0001\u0002L!9\u00111K\tA\u0002\u0005U\u0003bBA2#\u0001\u0007\u0011Q\r\u0005\b\u0003W\n\u0002\u0019AA7\u0011\u001d\t)(\u0005a\u0001\u0003oBq!a\"\u0012\u0001\u0004\tI\tC\u0004\u0002\u0010F\u0001\r!!%\t\u000f\u0005]\u0015\u00031\u0001\u0002\u001a\u0006!2m\u001c8oK\u000e$\u0018n\u001c8Va\u0012\fG/\u001a'pG.,\"!!3\u0011\t\u0005-\u0017Q[\u0007\u0003\u0003\u001bTA!a4\u0002R\u0006!A.\u00198h\u0015\t\t\u0019.\u0001\u0003kCZ\f\u0017\u0002BAl\u0003\u001b\u0014aa\u00142kK\u000e$\u0018!F2p]:,7\r^5p]V\u0003H-\u0019;f\u0019>\u001c7\u000eI\u0001\u0016a\u0016\u00148/[:uK:$8i\u001c8oK\u000e$\u0018n\u001c8t+\t\ty\u000e\u0005\u0005\u0002b\u0006-\u0018q^A{\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u001d\u0018AC2p]\u000e,(O]3oi*!\u0011\u0011^Ai\u0003\u0011)H/\u001b7\n\t\u00055\u00181\u001d\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003BA\u0004\u0003cL1!a=z\u0005\rIe\u000e\u001e\t\u0005\u0003o\fY0\u0004\u0002\u0002z*!\u00111IA@\u0013\u0011\ti0!?\u0003\u001dI+g/\u001a:tK\u000eC\u0017M\u001c8fY\u00061\u0002/\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:\u001c\b%\u0001\rbGRLg/\u001a*fm\u0016\u00148/Z\"p]:,7\r^5p]N\f\u0011$Y2uSZ,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8tA\u0005\tCn\\2bYJ+g/\u001a:tK\u000e{gN\\3di&|g\u000eT5ti\u0016tWM]'baV\u0011!\u0011\u0002\t\u0007\u0005\u0017\u0011\tb]:\u000e\u0005\t5!b\u0001B\bs\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tM!Q\u0002\u0002\u0004\u001b\u0006\u0004\u0018A\t7pG\u0006d'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8MSN$XM\\3s\u001b\u0006\u0004\b%\u0001\u0006ok6\u0014V\r\u001e:jKN,\"Aa\u0007\u0011\t\u0005\u001d!QD\u0005\u0004\u0005?I(\u0001\u0002'p]\u001e\faB\\;n%\u0016$(/[3t?\u0012*\u0017\u000f\u0006\u0003\u0003&\t-\u0002\u0003BA\u0004\u0005OI1A!\u000bz\u0005\u0011)f.\u001b;\t\u0013\t52$!AA\u0002\tm\u0011a\u0001=%c\u0005Ya.^7SKR\u0014\u0018.Z:!\u0003\u0001\u0002XM]:jgR,g\u000e^\"p]:,7\r^5p]\n\u000b7m[8gM6\u000b\u00070T:\u0016\u0005\tU\u0002\u0003BAf\u0005oIAAa\b\u0002N\u0006\t\u0003/\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:\u0014\u0015mY6pM\u001al\u0015\r_'tA\u0005i\u0002/\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:\u0014\u0015mY6pM\u001al5/\u0006\u0002\u0002p\u0006q\u0002/\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:\u0014\u0015mY6pM\u001al5\u000fI\u0001\u0010e\u0016$(/_'vYRL\u0007\u000f\\5fe\u0006\u0001\"/\u001a;ss6+H\u000e^5qY&,'\u000fI\u0001\fe\u0016$(/\u001f&jiR,'/\u0006\u0002\u0003JA!\u0011q\u0001B&\u0013\r\u0011i%\u001f\u0002\u0007\t>,(\r\\3\u0002\u0019I,GO]=KSR$XM\u001d\u0011\u0002AA,'o]5ti\u0016tGoQ8o]\u0016\u001cG/[8o%\u0016$(/\u001f\"bG.|gMZ\u000b\u0003\u0005+\u0002b!a\u0002\u0002\n\t]\u0003\u0003BA=\u00053JAAa\u0017\u0002|\t\u0011R\t\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4g\u0003\u0005\u0002XM]:jgR,g\u000e^\"p]:,7\r^5p]J+GO]=CC\u000e\\wN\u001a4!\u0003Qa\u0017N\\6MSN$XM\\3s\u000b:$\u0007o\\5oiV\u0011!1\r\t\u0005\u0005K\u00129'\u0004\u0002\u0002\u0000%!!\u0011NA@\u0005!)e\u000e\u001a9pS:$\u0018\u0001\u00077j].d\u0015n\u001d;f]\u0016\u0014XI\u001c3q_&tGo\u0018\u0013fcR!!Q\u0005B8\u0011%\u0011i\u0003KA\u0001\u0002\u0004\u0011\u0019'A\u000bmS:\\G*[:uK:,'/\u00128ea>Lg\u000e\u001e\u0011)\u0007%\u0012)\b\u0005\u0003\u0002\b\t]\u0014b\u0001B=s\nAao\u001c7bi&dW-\u0001\tmS:\\G*[:uK:,'OT1nKV\u0011!q\u0010\t\u0005\u0003o\u0014\t)\u0003\u0003\u0003\u0004\u0006e(\u0001\u0004'jgR,g.\u001a:OC6,\u0017\u0001\u00067j].d\u0015n\u001d;f]\u0016\u0014h*Y7f?\u0012*\u0017\u000f\u0006\u0003\u0003&\t%\u0005\"\u0003B\u0017W\u0005\u0005\t\u0019\u0001B@\u0003Ea\u0017N\\6MSN$XM\\3s\u001d\u0006lW\r\t\u0015\u0004Y\tU\u0014A\u00037pG\u0006d\u0017\tZ7j]V\u0011!1\u0013\t\u0005\u0005+\u0013Y*\u0004\u0002\u0003\u0018*!!\u0011TA\t\u0003\u0015\tG-\\5o\u0013\u0011\u0011iJa&\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u0006qAn\\2bY\u0006#W.\u001b8`I\u0015\fH\u0003\u0002B\u0013\u0005GC\u0011B!\f/\u0003\u0003\u0005\rAa%\u0002\u00171|7-\u00197BI6Lg\u000e\t\u0015\u0004_\tU\u0014a\u0005:f[>$XMT3uo>\u00148n\u00117jK:$XC\u0001BW!\u0019\t9!!\u0003\u00030B\u0019AL!-\n\u0007\tM6KA\nSK6|G/\u001a(fi^|'o[\"mS\u0016tG/A\fsK6|G/\u001a(fi^|'o[\"mS\u0016tGo\u0018\u0013fcR!!Q\u0005B]\u0011%\u0011i#MA\u0001\u0002\u0004\u0011i+\u0001\u000bsK6|G/\u001a(fi^|'o[\"mS\u0016tG\u000f\t\u0015\u0004e\tU\u0014aB:uCJ$X\u000f\u001d\u000b\u0003\u0005K\t1B]3d_:4\u0017nZ;sKR1!Q\u0005Bd\u0005\u0017DaA!35\u0001\u0004y\u0017!\u00038fo\u000e{gNZ5h\u0011\u001d\u0011i\r\u000ea\u0001\u0005\u001f\f1\"\u001e9eCR,GmS3zgB)!1\u0002Big&!!1\u001bB\u0007\u0005\r\u0019V\r^\u0001\rG2|7/Z\"mS\u0016tGo]\u0001\u0012K:\f'\r\\3DYV\u001cH/\u001a:MS:\\GC\u0002B\u0013\u00057\u0014)\u000fC\u0004\u0003^Z\u0002\rAa8\u0002\u001b9,Go^8sW\u000ec\u0017.\u001a8u!\ra&\u0011]\u0005\u0004\u0005G\u001c&\u0001G\"mkN$XM\u001d'j].tU\r^<pe.\u001cE.[3oi\"9\u00111\u0007\u001cA\u0002\t\u001d\bCBA\u0004\u0003\u0013\u0011I\u000f\u0005\u0003\u0003l\nEXB\u0001Bw\u0015\u0011\u0011yOa&\u0002\u0013%tG/\u001a:oC2\u001c\u0018\u0002\u0002Bz\u0005[\u0014A#\u00113nS:lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018AG5oSRL\u0017\r^3SKZ,'o]3D_:tWm\u0019;j_:\u001cHC\u0002B}\u0007/\u00199\u0003\u0005\u0004\u0003|\u000e\u001511\u0002\b\u0005\u0005{\u001c\tAD\u0002w\u0005\u007fL\u0011A_\u0005\u0004\u0007\u0007I\u0018a\u00029bG.\fw-Z\u0005\u0005\u0007\u000f\u0019IAA\u0002TKFT1aa\u0001z!\u0019\t\to!\u0004\u0004\u0012%!1qBAr\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0005\u0003\u0017\u001c\u0019\"\u0003\u0003\u0004\u0016\u00055'\u0001\u0002,pS\u0012Dqa!\u00078\u0001\u0004\u0019Y\"A\rj]&$\u0018.\u0019;f\u0007>tg.Z2uS>t'+Z9vKN$\b\u0003BB\u000f\u0007Gi!aa\b\u000b\t\r\u0005\u0012qP\u0001\te\u0016\fX/Z:ug&!1QEB\u0010\u0005\u0005Je.\u001b;jCR,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t%\u0016\fX/Z:u\u0011\u001d\u0019Ic\u000ea\u0001\u0007W\taB]3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u0004\u001e\r5\u0012\u0002BB\u0018\u0007?\u0011aBU3rk\u0016\u001cHoQ8oi\u0016DH/A\np]J+g/\u001a:tK\u000e{gN\\3di&|g\u000e\u0006\u0004\u0003&\rU2q\b\u0005\b\u0007oA\u0004\u0019AB\u001d\u0003\u001d\u0019\u0007.\u00198oK2\u0004B!a>\u0004<%!1QHA}\u00051Y\u0015MZ6b\u0007\"\fgN\\3m\u0011\u001d\u0019\t\u0005\u000fa\u0001\u0007\u0007\n1B]3wKJ\u001cXMT8eKB!\u0011q_B#\u0013\u0011\u00199%!?\u0003\u0017I+g/\u001a:tK:{G-Z\u0001\u0012_:\u001cuN\u001c8fGRLwN\\\"m_N,GC\u0003B\u0013\u0007\u001b\u001aye!\u0019\u0004f!91qG\u001dA\u0002\re\u0002bBB)s\u0001\u000711K\u0001\ne\u0016\fX/Z:u\u0013\u0012\u0004ba!\u0016\u0004X\rmSBAAt\u0013\u0011\u0019I&a:\u0003\u0011=\u0003H/[8oC2\u0004B!a3\u0004^%!1qLAg\u0005\u001dIe\u000e^3hKJDqaa\u0019:\u0001\u0004\ty/\u0001\bsK6|G/\u001a\"s_.,'/\u00133\t\u000f\r\u001d\u0014\b1\u0001\u0002\n\u0006QR\u000f\u001d3bi\u0016lU\r^1eCR\f\u0017J\u001a)feNL7\u000f^3oi\u00061bm\u001c:xCJ$Gk\\*pkJ\u001cWM\u0011:pW\u0016\u00148\u000f\u0006\u0004\u0003&\r54Q\u0010\u0005\b\u0007_R\u0004\u0019AB9\u0003-\u0011X-];fgR$\u0015\r^1\u0011\t\rM4\u0011P\u0007\u0003\u0007kRAaa\u001e\u0002\u0000\u00059Q.Z:tC\u001e,\u0017\u0002BB>\u0007k\u0012Q%\u00138ji&\fG/\u001a*fm\u0016\u00148/Z\"p]:,7\r^5p]N\u0014V-];fgR$\u0015\r^1\t\u000f\r}$\b1\u0001\u0003z\u00069a-\u001e;ve\u0016\u001c\u0018\u0001G2sK\u0006$XMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8ogRA!QEBC\u0007\u000f\u001bI\tC\u0004\u0004pm\u0002\ra!\u001d\t\u000f\r%2\b1\u0001\u0004,!91qP\u001eA\u0002\te\u0018AG8o\u001d\u0016<(+Z7pi\u0016d\u0015N\\6D_>\u0014H-\u001b8bi>\u0014H\u0003\u0002B\u0013\u0007\u001fCqa!%=\u0001\u0004\u0019\u0019*A\u0006d_>\u0014H-\u001b8bi>\u0014\b\u0003\u0002B3\u0007+KAaa&\u0002\u0000\t!aj\u001c3f\u0003IygnQ8oiJ|G\u000e\\3s\u0007\"\fgnZ3\u0015\t\t\u00152Q\u0014\u0005\b\u0007?k\u0004\u0019AAE\u0003!I7/Q2uSZ,\u0017aI8o\u0019&t7.T3uC\u0012\fG/\u0019)beRLG/[8o\u0019\u0016\fG-\u001a:DQ\u0006tw-Z\u0001\u001e[\u0006L(-\u001a)s_\u000e,7o]\"p_J$\u0017N\\1u_J\u001c\u0005.\u00198hK\u0006Y2\r\\8tKJ+g/\u001a:tK\u000e{gN\\3di&|g.\u00113nS:\fAd\u0019:fCR,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8BI6Lg.A\tde\u0016\fG/\u001a*f[>$X-\u00113nS:$\"Aa,\u0002!\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\\!e[&tGC\u0001BJ\u0003I)\b\u000fZ1uK2Kgn\u001b'jgR,g.\u001a:\u0015\t\t\u00152Q\u0017\u0005\u0007\u0007o#\u0005\u0019A8\u0002\r\r|gNZ5h\u00031\u0011XM^3sg\u0006dG)\u0019;b+\t\u0019i\f\u0005\u0003\u0004t\r}\u0016\u0002BBa\u0007k\u0012ADU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o%\u0016\fX/Z:u\t\u0006$\u0018-A\u0010nCf\u0014Wm\u0011:fCR,\u0007+\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:\f!bZ3u%\u0016$(/_'t)\u0011\u0011)c!3\t\u000f\rE\u0005\n1\u0001\u0004\u0014\u0006)\"/Z9vKN$X*\u001a;bI\u0006$\u0018-\u00169eCR,\u0017AG2m_N,\u0007+\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:\u001c\u0018!H2m_N,\u0017i\u0019;jm\u0016\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\:\u0002!M|7m[3u\u0007\"\fgN\\3m\u0017\u0016LH\u0003BAx\u0007+Dqaa6M\u0001\u0004\u0019I.A\u0007t_\u000e\\W\r^\"iC:tW\r\u001c\t\u0005\u00077\u001c)/\u0004\u0002\u0004^*!1q\\Bq\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002BBr\u0003#\f1A\\5p\u0013\u0011\u00199o!8\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003M\u0019Gn\\:f%\u00164XM]:f\u0007\"\fgN\\3m)\u0011\tIi!<\t\u000f\r=X\n1\u0001\u0002v\u0006q!/\u001a<feN,7\t[1o]\u0016d\u0017AD7fi\u0006$\u0017\r^1UQJ,\u0017\rZ\u000b\u0003\u0007k\u0004b!a\u0002\u0002\n\r]\bc\u0001/\u0004z&\u001911`*\u00033\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1UQJ,\u0017\rZ\u0001\u001aa\u0016\u00148/[:uK:$8i\u001c8oK\u000e$\u0018n\u001c8D_VtG/\u0001\fsKZ,'o]3D_:tWm\u0019;j_:\u001cu.\u001e8u\u00035a\u0017M_=SKN|WO]2fgV\u0011AQ\u0001\t\u0007\u0005w\u001c)\u0001b\u00021\t\u0011%A1\u0003\t\u00069\u0012-AqB\u0005\u0004\t\u001b\u0019&\u0001\u0004'buf\u0014Vm]8ve\u000e,\u0007\u0003\u0002C\t\t'a\u0001\u0001B\u0006\u0005\u0016E\u000b\t\u0011!A\u0003\u0002\u0011]!aA0%cE!A\u0011\u0004C\u0010!\u0011\t9\u0001b\u0007\n\u0007\u0011u\u0011PA\u0004O_RD\u0017N\\4\u0011\t\u0005\u001dA\u0011E\u0005\u0004\tGI(aA!os\u0002")
public class ClusterLinkOutboundConnectionManager
extends ClusterLinkConnectionManager
implements ClusterLinkFactory.OutboundConnectionManager,
CoordinatorListener {
    private final ClusterLinkConfig initialConfig;
    private final Option<ClientInterceptor> clientInterceptor;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry;
    private final ClusterLinkMetadataManager metadataManager;
    private final SocketServer socketServer;
    private final KafkaConfig brokerConfig;
    private final AuthorizerServerInfo serverInfo;
    private final ClusterLinkRequestQuota quota;
    private final Option<ClusterLinkChannelContext> clusterLinkChannelContext;
    private final Time time;
    private final boolean enableReverseConnections;
    private final Function0<Object> intranetConnectivityDeniedChecker;
    private final ClusterLinkScheduler linkScheduler;
    private final Object connectionUpdateLock;
    private final ConcurrentHashMap<Object, ReverseChannel> persistentConnections;
    private final ConcurrentHashMap<Object, ReverseChannel> activeReverseConnections;
    private final Map<String, String> localReverseConnectionListenerMap;
    private long numRetries;
    private final Long persistentConnectionBackoffMaxMs;
    private final int persistentConnectionBackoffMs;
    private final int retryMultiplier;
    private final double retryJitter;
    private final Option<ExponentialBackoff> persistentConnectionRetryBackoff;
    private volatile Endpoint linkListenerEndpoint;
    private volatile ListenerName linkListenerName;
    private volatile ConfluentAdmin localAdmin;
    private volatile Option<RemoteNetworkClient> remoteNetworkClient;

    private Object connectionUpdateLock() {
        return this.connectionUpdateLock;
    }

    private ConcurrentHashMap<Object, ReverseChannel> persistentConnections() {
        return this.persistentConnections;
    }

    private ConcurrentHashMap<Object, ReverseChannel> activeReverseConnections() {
        return this.activeReverseConnections;
    }

    private Map<String, String> localReverseConnectionListenerMap() {
        return this.localReverseConnectionListenerMap;
    }

    private long numRetries() {
        return this.numRetries;
    }

    private void numRetries_$eq(long x$1) {
        this.numRetries = x$1;
    }

    private Long persistentConnectionBackoffMaxMs() {
        return this.persistentConnectionBackoffMaxMs;
    }

    private int persistentConnectionBackoffMs() {
        return this.persistentConnectionBackoffMs;
    }

    private int retryMultiplier() {
        return this.retryMultiplier;
    }

    private double retryJitter() {
        return this.retryJitter;
    }

    public Option<ExponentialBackoff> persistentConnectionRetryBackoff() {
        return this.persistentConnectionRetryBackoff;
    }

    private Endpoint linkListenerEndpoint() {
        return this.linkListenerEndpoint;
    }

    private void linkListenerEndpoint_$eq(Endpoint x$1) {
        this.linkListenerEndpoint = x$1;
    }

    private ListenerName linkListenerName() {
        return this.linkListenerName;
    }

    private void linkListenerName_$eq(ListenerName x$1) {
        this.linkListenerName = x$1;
    }

    private ConfluentAdmin localAdmin() {
        return this.localAdmin;
    }

    private void localAdmin_$eq(ConfluentAdmin x$1) {
        this.localAdmin = x$1;
    }

    private Option<RemoteNetworkClient> remoteNetworkClient() {
        return this.remoteNetworkClient;
    }

    private void remoteNetworkClient_$eq(Option<RemoteNetworkClient> x$1) {
        this.remoteNetworkClient = x$1;
    }

    @Override
    public void startup() {
        ConnectionMode connectionMode = this.initialConfig.connectionMode();
        ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
        if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Inbound$) : connectionMode$Inbound$ != null)) {
            throw new IllegalStateException("Outbound connection manager created in inbound connection mode");
        }
        super.startup();
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        if (updatedKeys.contains(ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
            this.updateLinkListener(this.currentConfig());
        }
        super.reconfigure(newConfig, updatedKeys);
        if (updatedKeys.exists((Function1<String, Object> & Serializable)configName -> BoxesRunTime.boxToBoolean(ClusterLinkConfig$.MODULE$.needsConnectionResetOnUpdate(configName)))) {
            this.closeActiveReverseConnections();
            return;
        }
    }

    @Override
    public void closeClients() {
        super.closeClients();
        this.closeActiveReverseConnections();
    }

    @Override
    public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
        KafkaClient kafkaClient = networkClient.networkClient();
        if (kafkaClient instanceof NetworkClient) {
            NetworkClient networkClient2 = (NetworkClient)kafkaClient;
            networkClient2.enableClusterLinkRequests(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull($less$colon$less$.MODULE$.refl()), null);
            return;
        }
    }

    public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
        List futures;
        block4: {
            this.debug((Function0<String> & Serializable)() -> "Initiate or forward reverse connection request: " + initiateConnectionRequest);
            this.ensureReverseConnectionsEnabled();
            InitiateReverseConnectionsRequestData connData = initiateConnectionRequest.data();
            futures = (List)package$.MODULE$.List().fill(connData.entries().size(), (Function0<CompletableFuture> & Serializable)() -> new CompletableFuture());
            try {
                String string = connData.sourceClusterId();
                String string2 = super.localLogicalCluster();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw new InvalidRequestException("Initiate reverse request for cluster " + connData.sourceClusterId() + " sent to wrong source cluster " + super.localLogicalCluster());
                }
                if (connData.forwardToBroker()) {
                    this.forwardToSourceBrokers(connData, futures);
                    break block4;
                }
                this.createReverseConnections(connData, requestContext, futures);
            }
            catch (Throwable e) {
                this.error((Function0<String> & Serializable)() -> "Failing reverse connection request", (Function0<Throwable> & Serializable)() -> e);
                futures.foreach((Function1<CompletableFuture, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.completeExceptionally(e)));
            }
        }
        return futures;
    }

    public void onReverseConnection(KafkaChannel channel2, ReverseNode reverseNode) {
        Optional requestId = reverseNode.requestId();
        int remoteBrokerId = reverseNode.remoteBrokerId();
        this.debug((Function0<String> & Serializable)() -> "Destination has successfully reversed channel " + channel2 + " with requestId " + requestId + " remoteBrokerId " + remoteBrokerId);
        this.ensureReverseConnectionsEnabled();
        if (!requestId.isPresent() && !this.isLinkCoordinator()) {
            String errorMessage = "Discarding persistent reverse connection since broker " + this.brokerConfig.brokerId() + " is no longer the link coordinator";
            this.debug((Function0<String> & Serializable)() -> errorMessage);
            throw new NotControllerException(errorMessage);
        }
        SocketChannel socketChannel = channel2.socketChannel();
        ReverseChannel reverseChannel = new ReverseChannel(channel2, reverseNode, channel -> this.onConnectionClose((KafkaChannel)channel, reverseNode.requestId(), reverseNode.remoteBrokerId(), true));
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.activeReverseConnections().put(BoxesRunTime.boxToInteger(this.socketChannelKey(socketChannel)), reverseChannel);
            if (!requestId.isPresent()) {
                if (Option$.MODULE$.apply(this.persistentConnections().get(BoxesRunTime.boxToInteger(remoteBrokerId))).exists((Function1<ReverseChannel, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(ClusterLinkOutboundConnectionManager.$anonfun$onReverseConnection$4(x$5)))) {
                    this.debug((Function0<String> & Serializable)() -> "Ignoring persistent connection because a connection already exists for " + remoteBrokerId);
                    throw new IllegalStateException("A persistent connection is available for " + remoteBrokerId);
                }
                this.persistentConnections().put(BoxesRunTime.boxToInteger(remoteBrokerId), reverseChannel);
                this.debug((Function0<String> & Serializable)() -> "Created persistent connection to " + remoteBrokerId + ", channel=" + channel2);
            }
        }
        this.metrics.reverseConnectionCreatedSensor().record();
        this.socketServer.reverseAndAdd(this.linkListenerName(), reverseChannel);
        this.info((Function0<String> & Serializable)() -> "Added reverse connection " + channel2 + " to source socket server, requestId=" + requestId);
    }

    private void onConnectionClose(KafkaChannel channel, Optional<Integer> requestId, int remoteBrokerId, boolean updateMetadataIfPersistent) {
        boolean bl;
        this.debug((Function0<String> & Serializable)() -> "Reverse channel " + channel + " has been disconnected");
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            boolean bl2;
            if (this.activeReverseConnections().remove(BoxesRunTime.boxToInteger(this.socketChannelKey(channel.socketChannel()))) != null) {
                this.metrics.reverseConnectionClosedSensor().record();
            }
            if (!requestId.isPresent() && this.persistentConnections().remove(BoxesRunTime.boxToInteger(remoteBrokerId)) != null) {
                this.info((Function0<String> & Serializable)() -> "Removed persistent connection for " + remoteBrokerId + " because channel " + channel.id() + " was closed");
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        boolean isPersistent = bl;
        if (updateMetadataIfPersistent && isPersistent) {
            this.requestMetadataUpdate();
            return;
        }
    }

    private void forwardToSourceBrokers(InitiateReverseConnectionsRequestData requestData, Seq<CompletableFuture<Void>> futures) {
        this.debug((Function0<String> & Serializable)() -> "Forward initiate reverse connection request from source link coordinator to source brokers: " + requestData);
        ConfluentAdmin admin = this.localAdmin();
        scala.collection.immutable.Map resultFutures = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().zip(futures)).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)tuple2._1();
                CompletableFuture future = (CompletableFuture)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(entry.initiateRequestId())), future);
            }
            throw new MatchError(tuple2);
        })).toMap($less$colon$less$.MODULE$.refl());
        CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().groupBy((Function1<InitiateReverseConnectionsRequestData.EntryData, Object> & Serializable)x$6 -> BoxesRunTime.boxToInteger(x$6.sourceBrokerId())).foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            ClusterLinkOutboundConnectionManager.$anonfun$forwardToSourceBrokers$4(this, requestData, admin, resultFutures, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private void createReverseConnections(InitiateReverseConnectionsRequestData requestData, RequestContext requestContext, Seq<CompletableFuture<Void>> futures) {
        NetworkClient networkClient = ((RemoteNetworkClient)this.remoteNetworkClient().getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new IllegalStateException("Remote client connection manager not available");
        })).networkClient();
        this.debug((Function0<String> & Serializable)() -> "Create reverse connections from source brokers to destination brokers: " + requestData);
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().zip(futures)).foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object object;
                InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)tuple2._1();
                CompletableFuture future = (CompletableFuture)tuple2._2();
                try {
                    if (entry.initiateRequestId() == -1 && Option$.MODULE$.apply(this.persistentConnections().get(BoxesRunTime.boxToInteger(entry.targetBrokerId()))).exists((Function1<ReverseChannel, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(ClusterLinkOutboundConnectionManager.$anonfun$createReverseConnections$4(x$7)))) {
                        object = BoxesRunTime.boxToBoolean(future.complete(null));
                    } else if (entry.sourceBrokerId() == $this.brokerConfig.brokerId() || entry.sourceBrokerId() == -1) {
                        this.info((Function0<String> & Serializable)() -> "Create reverse connection from source broker to destination broker: " + entry);
                        ReverseNode reverseNode = networkClient.reverseConnectionManager().createReversibleConnection(entry.initiateRequestId(), entry.targetBrokerId(), requestContext$1.listenerName, requestContext$1.principal, requestContext$1.principalSerde, requestContext$1.authenticationContext, $this.time.milliseconds());
                        object = reverseNode.future().whenComplete((x0$2, x1$1) -> {
                            Tuple2<Void, Throwable> tuple2 = new Tuple2<Void, Throwable>((Void)x0$2, (Throwable)x1$1);
                            if (tuple2 != null) {
                                Void v = tuple2._1();
                                Throwable e = tuple2._2();
                                if (e != null) {
                                    $this.metrics.outboundReverseConnectionFailedSensor().record();
                                    networkClient.requestClusterLinkMetadataUpdate();
                                    future.completeExceptionally(e);
                                    this.warn((Function0<String> & Serializable)() -> "Failed to reverse connection for " + reverseNode, (Function0<Throwable> & Serializable)() -> e);
                                    return;
                                }
                                future.complete(v);
                                this.debug((Function0<String> & Serializable)() -> "Completed connection reversal for " + reverseNode);
                                return;
                            }
                            throw new MatchError(tuple2);
                        });
                    } else {
                        object = BoxesRunTime.boxToBoolean(future.completeExceptionally(new InvalidRequestException("Incorrect source broker id, expected " + $this.brokerConfig.brokerId() + ", requested " + entry.sourceBrokerId())));
                    }
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    this.error((Function0<String> & Serializable)() -> "Failed to reverse connection for request " + requestData, (Function0<Throwable> & Serializable)() -> e);
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            throw new MatchError(tuple2);
        });
    }

    @Override
    public void onNewRemoteLinkCoordinator(Node coordinator) {
        this.debug((Function0<String> & Serializable)() -> "Process remote metadata: isLocalCoordinator=" + this.isLinkCoordinator() + " remoteCoordinator=" + coordinator);
        if (!this.enableReverseConnections) {
            return;
        }
        this.maybeCreatePersistentConnection();
        this.updateActiveLinkCount();
    }

    @Override
    public void onControllerChange(boolean isActive) {
        this.debug((Function0<String> & Serializable)() -> "Process local controller change, isActiveController=" + isActive);
        this.maybeProcessCoordinatorChange();
    }

    @Override
    public void onLinkMetadataPartitionLeaderChange() {
        this.debug((Function0<String> & Serializable)() -> "Process metadata partition leader change");
        this.maybeProcessCoordinatorChange();
    }

    private void maybeProcessCoordinatorChange() {
        block6: {
            Object object = this.stateChangeLock();
            synchronized (object) {
                block5: {
                    boolean isCoordinator = this.isLinkCoordinator();
                    this.debug((Function0<String> & Serializable)() -> "Process link coordinator change isLocalCoordinator=" + isCoordinator);
                    if (!this.enableReverseConnections) break block5;
                    if (!isCoordinator) {
                        this.closePersistentConnections();
                    } else {
                        this.maybeCreatePersistentConnection();
                    }
                    break block6;
                }
                return;
            }
        }
    }

    @Override
    public void closeReverseConnectionAdmin() {
        Option<RemoteNetworkClient> remoteClient = this.remoteNetworkClient();
        remoteClient.foreach((Function1<RemoteNetworkClient, Object> & Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        if (this.localAdmin() != null) {
            this.localAdmin().close(Duration.ZERO);
            return;
        }
    }

    @Override
    public void createReverseConnectionAdmin() {
        if (!this.enableReverseConnections) {
            return;
        }
        this.localAdmin_$eq(this.createLocalAdmin());
        this.remoteNetworkClient_$eq(new Some<RemoteNetworkClient>(this.createRemoteAdmin()));
        this.maybeCreatePersistentConnection();
    }

    public RemoteNetworkClient createRemoteAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        ClusterLinkMetadata metadata = new ClusterLinkMetadata(this.brokerConfig, super.linkData().linkName(), super.linkData().linkId(), config.linkMode(), Predef$.MODULE$.Long2long(config.metadataRefreshBackoffMs()), Predef$.MODULE$.Long2long(config.metadataMaxAgeMs()));
        java.util.List<String> bootstrapServersToConnect = config.bootstrapServersToConnect(this.intranetConnectivityDeniedChecker);
        this.debug((Function0<String> & Serializable)() -> "Bootstrap servers to connect are " + bootstrapServersToConnect);
        java.util.List addresses = ClientUtils.parseAndValidateAddresses(bootstrapServersToConnect, (ClientDnsLookup)config.dnsLookup());
        metadata.bootstrap(addresses);
        ClusterLinkMetadataThread metadataRefreshThread = new ClusterLinkMetadataThread(this.brokerConfig, config, None$.MODULE$, metadata, this.metrics.metrics(), this.selectorMetricsRegistry, ClusterLinkClientType$OutboundConnectionAdmin$.MODULE$, this.quota, this.clusterLinkChannelContext, this.time);
        metadataRefreshThread.addCoordinatorListener(this);
        metadataRefreshThread.start();
        NetworkClient networkClient = (NetworkClient)metadataRefreshThread.clusterLinkClient().networkClient();
        networkClient.enableClusterLinkReverseConnectionAdmin(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull($less$colon$less$.MODULE$.refl()), this.reversalData(), (ReverseNode.ReverseCallback)this);
        return new RemoteNetworkClient(networkClient, metadataRefreshThread);
    }

    public ConfluentAdmin createLocalAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        this.debug((Function0<String> & Serializable)() -> "Creating local admin for reverse connections from source cluster on listener " + this.linkListenerEndpoint());
        java.util.Map<String, Object> adminConfigs = config.localLinkClientConfigs(this.brokerConfig, this.linkListenerEndpoint(), super.linkData().tenantPrefix());
        adminConfigs.put("client.id", "cluster-link-" + super.linkData().linkName() + "-local-source-conn-admin-" + this.brokerConfig.brokerId());
        return (ConfluentAdmin)Admin.create(adminConfigs);
    }

    private void updateLinkListener(ClusterLinkConfig config) {
        this.linkListenerEndpoint_$eq(ClusterLinkUtils$.MODULE$.linkListenerEndpoint(super.linkData().tenantPrefix(), config, this.serverInfo, this.localReverseConnectionListenerMap()));
        this.linkListenerName_$eq(new ListenerName((String)this.linkListenerEndpoint().listenerName().orElseThrow(() -> new IllegalStateException("Listener name not set"))));
    }

    private ReverseConnectionRequestData reversalData() {
        Endpoint endpoint = this.linkListenerEndpoint();
        return new ReverseConnectionRequestData().setClusterLinkId(this.linkId()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new IllegalStateException("Remote cluster id not known");
        })).setSourceClusterId(super.localLogicalCluster()).setSourceBrokerId(this.brokerConfig.brokerId()).setSourceHost(endpoint.host()).setSourcePort(endpoint.port());
    }

    private void maybeCreatePersistentConnection() {
        if (this.isLinkCoordinator()) {
            this.remoteNetworkClient().foreach((Function1<RemoteNetworkClient, Object> & Serializable)client -> {
                ClusterLinkOutboundConnectionManager.$anonfun$maybeCreatePersistentConnection$1(this, client);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private long getRetryMs() {
        if (this.persistentConnectionRetryBackoff().isEmpty()) {
            return 0L;
        }
        long retryMs = this.persistentConnectionRetryBackoff().get().backoff(this.numRetries());
        this.numRetries_$eq(this.numRetries() + 1L);
        return retryMs;
    }

    private void maybeCreatePersistentConnection(Node coordinator) {
        if (!Option$.MODULE$.apply(this.persistentConnections().get(BoxesRunTime.boxToInteger(coordinator.id()))).exists((Function1<ReverseChannel, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(ClusterLinkOutboundConnectionManager.$anonfun$maybeCreatePersistentConnection$3(x$9)))) {
            this.info((Function0<String> & Serializable)() -> "Creating persistent connection to remote link coordinator " + coordinator);
            InitiateReverseConnectionsRequestData requestData = new InitiateReverseConnectionsRequestData().setClusterLinkId(new Uuid(super.linkData().linkId().getMostSignificantBits(), super.linkData().linkId().getLeastSignificantBits())).setForwardToBroker(false).setTimeoutMs(Predef$.MODULE$.Integer2int(this.currentConfig().reverseConnectionSetupTimeoutMs())).setSourceClusterId(super.localLogicalCluster()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0<Nothing$> & Serializable)() -> {
                throw new IllegalStateException("Remote cluster id not known");
            })).setEntries(Collections.singletonList(new InitiateReverseConnectionsRequestData.EntryData().setInitiateRequestId(-1).setSourceBrokerId(this.brokerConfig.brokerId()).setTargetBrokerId(coordinator.id())));
            CompletableFuture future = new CompletableFuture();
            this.forwardToSourceBrokers(requestData, new $colon$colon<Nothing$>((Nothing$)((Object)future), Nil$.MODULE$));
            future.whenComplete((x0$1, x1$1) -> {
                Tuple2<Void, Throwable> tuple2 = new Tuple2<Void, Throwable>((Void)x0$1, (Throwable)x1$1);
                if (tuple2 != null) {
                    Throwable e = tuple2._2();
                    if (e != null) {
                        long retryMs = this.getRetryMs();
                        this.warn((Function0<String> & Serializable)() -> "Failed to create persistent reverse connection, will retry after " + retryMs + " ms", (Function0<Throwable> & Serializable)() -> e);
                        if (retryMs <= 0L) {
                            this.requestMetadataUpdate();
                            return;
                        }
                        $this.linkScheduler.scheduleOnce("ClusterLinkOutboundConnectionManager", () -> this.requestMetadataUpdate(), retryMs);
                        return;
                    }
                    this.numRetries_$eq(0L);
                    this.info((Function0<String> & Serializable)() -> "Successfully created persistent connection to " + coordinator + "  for " + requestData);
                    return;
                }
                throw new MatchError(tuple2);
            });
            return;
        }
        this.debug((Function0<String> & Serializable)() -> "Not creating persistent connection, remoteController=" + coordinator + ", persistentConnections=" + this.persistentConnections());
    }

    private void requestMetadataUpdate() {
        if (this.isActive()) {
            try {
                this.remoteNetworkClient().foreach((Function1<RemoteNetworkClient, Object> & Serializable)x$10 -> BoxesRunTime.boxToInteger(ClusterLinkOutboundConnectionManager.$anonfun$requestMetadataUpdate$1(x$10)));
            }
            catch (Exception e) {
                this.error((Function0<String> & Serializable)() -> "Failed to request metadata refresh", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            }
            return;
        }
    }

    private void closePersistentConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String> & Serializable)() -> "Closing persistent connections");
            ((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.persistentConnections()).asScala().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ClusterLinkOutboundConnectionManager.$anonfun$closePersistentConnections$2(this, x0$1)))).foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
                ClusterLinkOutboundConnectionManager.$anonfun$closePersistentConnections$3(this, x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void closeActiveReverseConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String> & Serializable)() -> "Closing active reverse connections");
            ((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.activeReverseConnections()).asScala().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ClusterLinkOutboundConnectionManager.$anonfun$closeActiveReverseConnections$2(this, x0$1)))).foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
                ClusterLinkOutboundConnectionManager.$anonfun$closeActiveReverseConnections$3(this, x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private int socketChannelKey(SocketChannel socketChannel) {
        return System.identityHashCode(socketChannel);
    }

    public boolean closeReverseChannel(ReverseChannel reverseChannel) {
        if (!reverseChannel.maybeClose()) {
            SocketChannel socketChannel = reverseChannel.socketChannel();
            try {
                this.info((Function0<String> & Serializable)() -> "Runnable to close reverse channel '" + reverseChannel + "' not set. Channel may not have been added to SocketServer yet, closing socket channel.");
                reverseChannel.socketChannel().close();
            }
            catch (Exception e) {
                this.warn((Function0<String> & Serializable)() -> "Failed to close socket channel " + socketChannel, (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            }
            return true;
        }
        this.debug((Function0<String> & Serializable)() -> "Close initiated for reverse channel '" + reverseChannel + "', the channel will be closed by SocketServer.");
        return false;
    }

    public Option<ClusterLinkMetadataThread> metadataThread() {
        return this.remoteNetworkClient().map((Function1<RemoteNetworkClient, ClusterLinkMetadataThread> & Serializable)x$11 -> x$11.metadataRefreshThread());
    }

    @Override
    public int persistentConnectionCount() {
        return this.persistentConnections().size();
    }

    @Override
    public int reverseConnectionCount() {
        return this.activeReverseConnections().size();
    }

    public Seq<LazyResource<?>> lazyResources() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static final /* synthetic */ boolean $anonfun$onReverseConnection$4(ReverseChannel x$5) {
        return x$5.socketChannel().isConnected();
    }

    public static final /* synthetic */ boolean $anonfun$forwardToSourceBrokers$10(int brokerId$1, scala.collection.immutable.Map resultFutures$1, InitiateReverseConnectionsRequestData.EntryData entry) {
        NetworkException e = new NetworkException("Source broker with id " + brokerId$1 + " is not available");
        return ((CompletableFuture)resultFutures$1.apply(BoxesRunTime.boxToInteger(entry.initiateRequestId()))).completeExceptionally((Throwable)e);
    }

    public static final /* synthetic */ void $anonfun$forwardToSourceBrokers$4(ClusterLinkOutboundConnectionManager $this, InitiateReverseConnectionsRequestData requestData$1, ConfluentAdmin admin$1, scala.collection.immutable.Map resultFutures$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int brokerId = tuple2._1$mcI$sp();
            Buffer entries = (Buffer)tuple2._2();
            if (brokerId == -1 || $this.brokerConfig.brokerId() == brokerId || $this.metadataManager.isBrokerOnline(brokerId)) {
                InitiateReverseConnectionsRequestData brokerRequest = new InitiateReverseConnectionsRequestData().setClusterLinkId(requestData$1.clusterLinkId()).setSourceClusterId(requestData$1.sourceClusterId()).setTargetClusterId(requestData$1.targetClusterId()).setForwardToBroker(false).setEntries(CollectionConverters$.MODULE$.BufferHasAsJava(entries).asJava());
                java.util.Map requestFutures = ConfluentAdminUtils.initiateReverseConnections((ConfluentAdmin)admin$1, (InitiateReverseConnectionsRequestData)brokerRequest, (Integer)Predef$.MODULE$.int2Integer(brokerId));
                requestFutures.forEach((x0$3, x1$1) -> {
                    Tuple2<Integer, KafkaFutureImpl> tuple2 = new Tuple2<Integer, KafkaFutureImpl>((Integer)x0$3, (KafkaFutureImpl)x1$1);
                    if (tuple2 != null) {
                        Integer requestId = tuple2._1();
                        KafkaFutureImpl future = tuple2._2();
                        future.whenComplete((x0$4, x1$2) -> {
                            Tuple2<Void, Throwable> tuple2 = new Tuple2<Void, Throwable>((Void)x0$4, (Throwable)x1$2);
                            if (tuple2 != null) {
                                Void v = tuple2._1();
                                Throwable e = tuple2._2();
                                if (e != null) {
                                    ((CompletableFuture)resultFutures$1.apply(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(requestId)))).completeExceptionally(e);
                                    $this.metrics.outboundReverseConnectionFailedSensor().record();
                                    $this.warn((Function0<String> & Serializable)() -> "Connection reversal request to local broker failed for requestId=" + requestId, (Function0<Throwable> & Serializable)() -> e);
                                    return;
                                }
                                ((CompletableFuture)resultFutures$1.apply(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(requestId)))).complete(v);
                                $this.debug((Function0<String> & Serializable)() -> "Completed initiate reversal request for requestId=" + requestId);
                                return;
                            }
                            throw new MatchError(tuple2);
                        });
                        return;
                    }
                    throw new MatchError(tuple2);
                });
                return;
            }
            entries.foreach((Function1<InitiateReverseConnectionsRequestData.EntryData, Object> & Serializable)entry -> BoxesRunTime.boxToBoolean(ClusterLinkOutboundConnectionManager.$anonfun$forwardToSourceBrokers$10(brokerId, resultFutures$1, entry)));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$createReverseConnections$4(ReverseChannel x$7) {
        return x$7.socketChannel().isConnected();
    }

    public static final /* synthetic */ void $anonfun$maybeCreatePersistentConnection$1(ClusterLinkOutboundConnectionManager $this, RemoteNetworkClient client) {
        Option<Node> option = client.metadataRefreshThread().remoteLinkCoordinator();
        if (option instanceof Some) {
            Some some = (Some)option;
            Node coordinator = (Node)some.value();
            $this.maybeCreatePersistentConnection(coordinator);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.debug((Function0<String> & Serializable)() -> "Remote coordinator not known, request metadata");
            $this.requestMetadataUpdate();
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$maybeCreatePersistentConnection$3(ReverseChannel x$9) {
        return x$9.socketChannel().isConnected();
    }

    public static final /* synthetic */ int $anonfun$requestMetadataUpdate$1(RemoteNetworkClient x$10) {
        return x$10.metadataRefreshThread().clusterLinkMetadata().requestUpdate();
    }

    public static final /* synthetic */ boolean $anonfun$closePersistentConnections$2(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)tuple2._2();
            return $this.closeReverseChannel(reverseChannel);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$closePersistentConnections$3(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)tuple2._2();
            $this.onConnectionClose(reverseChannel.channel(), reverseChannel.reverseNode().requestId(), reverseChannel.reverseNode().remoteBrokerId(), false);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$closeActiveReverseConnections$2(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)tuple2._2();
            return $this.closeReverseChannel(reverseChannel);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$closeActiveReverseConnections$3(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)tuple2._2();
            $this.onConnectionClose(reverseChannel.channel(), reverseChannel.reverseNode().requestId(), reverseChannel.reverseNode().remoteBrokerId(), false);
            return;
        }
        throw new MatchError(tuple2);
    }

    public ClusterLinkOutboundConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, Option<ClientInterceptor> clientInterceptor, ClusterLinkMetrics metrics, ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry, ClusterLinkMetadataManager metadataManager, SocketServer socketServer, KafkaConfig brokerConfig, AuthorizerServerInfo serverInfo, ClusterLinkRequestQuota quota, Option<ClusterLinkChannelContext> clusterLinkChannelContext, Time time, boolean enableReverseConnections, Function0<Object> intranetConnectivityDeniedChecker, ClusterLinkScheduler linkScheduler) {
        block0: {
            this.initialConfig = initialConfig;
            this.clientInterceptor = clientInterceptor;
            this.metrics = metrics;
            this.selectorMetricsRegistry = selectorMetricsRegistry;
            this.metadataManager = metadataManager;
            this.socketServer = socketServer;
            this.brokerConfig = brokerConfig;
            this.serverInfo = serverInfo;
            this.quota = quota;
            this.clusterLinkChannelContext = clusterLinkChannelContext;
            this.time = time;
            this.enableReverseConnections = enableReverseConnections;
            this.intranetConnectivityDeniedChecker = intranetConnectivityDeniedChecker;
            this.linkScheduler = linkScheduler;
            super(linkData, initialConfig, localLogicalCluster, metadataManager, metrics, brokerConfig);
            CoordinatorListener.$init$(this);
            this.connectionUpdateLock = new Object();
            this.persistentConnections = new ConcurrentHashMap();
            this.activeReverseConnections = new ConcurrentHashMap();
            this.localReverseConnectionListenerMap = brokerConfig.clusterLinkLocalReverseConnectionListenerMap();
            this.numRetries = 0L;
            this.persistentConnectionBackoffMaxMs = brokerConfig.clusterLinkPersistentConnectionBackoffMaxMs();
            this.persistentConnectionBackoffMs = 50;
            this.retryMultiplier = 2;
            this.retryJitter = 0.2;
            this.persistentConnectionRetryBackoff = Predef$.MODULE$.Long2long(this.persistentConnectionBackoffMaxMs()) > 0L ? new Some<ExponentialBackoff>(new ExponentialBackoff((long)this.persistentConnectionBackoffMs(), this.retryMultiplier(), Predef$.MODULE$.Long2long(this.persistentConnectionBackoffMaxMs()), this.retryJitter())) : None$.MODULE$;
            this.remoteNetworkClient = None$.MODULE$;
            this.logIdent_$eq("[ClusterLinkOutboundConnectionManager-" + super.linkData().linkName() + "-broker-" + brokerConfig.brokerId() + "] ");
            if (!enableReverseConnections) break block0;
            this.updateLinkListener(initialConfig);
        }
    }
}

