/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkPauseMirrorTopicsTaskType$;
import kafka.server.link.ClusterLinkPauseMirrors$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001\u0002\u0010 \u0001\u0019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Aq\n\u0001B\u0001B\u0003%\u0001\u000bC\u0005X\u0001\t\u0005\t\u0015!\u0003Y7\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011%!\u0007A!A!\u0002\u0013)'\u000eC\u0005l\u0001\t\u0005\t\u0015!\u0003ma\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000f\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003w\u0011%I\bA!A!\u0002\u00131(\u0010\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003w\u0011\u0015i\b\u0001\"\u0001\u007f\u0011%\tI\u0002\u0001a\u0001\n\u0013\tY\u0002C\u0005\u0002*\u0001\u0001\r\u0011\"\u0003\u0002,!A\u0011q\u0007\u0001!B\u0013\ti\u0002C\u0004\u0002B\u0001!\t&a\u0011\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\!9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003g\u0003A\u0011BA[\u0011\u001d\tI\f\u0001C)\u0003wCq!a2\u0001\t\u0003\nImB\u0005\u0002L~\t\t\u0011#\u0001\u0002N\u001aAadHA\u0001\u0012\u0003\ty\r\u0003\u0004~3\u0011\u0005\u0011q\u001b\u0005\n\u00033L\u0012\u0013!C\u0001\u00037D\u0011\"!=\u001a#\u0003%\t!a7\t\u0013\u0005M\u0018$%A\u0005\u0002\u0005m'aF\"mkN$XM\u001d'j].\u0004\u0016-^:f\u001b&\u0014(o\u001c:t\u0015\t\u0001\u0013%\u0001\u0003mS:\\'B\u0001\u0012$\u0003\u0019\u0019XM\u001d<fe*\tA%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u00019s\u0006\u0005\u0002)Y9\u0011\u0011FK\u0007\u0002?%\u00111fH\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\u00055r#\u0001\u0004)fe&|G-[2UCN\\'BA\u0016 !\t\u00014'D\u00012\u0015\t\u00114%A\u0003vi&d7/\u0003\u00025c\t9Aj\\4hS:<\u0017A\u00027j].LE\r\u0005\u00028\u007f5\t\u0001H\u0003\u0002:u\u000511m\\7n_:T!\u0001J\u001e\u000b\u0005qj\u0014AB1qC\u000eDWMC\u0001?\u0003\ry'oZ\u0005\u0003\u0001b\u0012A!V;jI\u0006AA.\u001b8l\u001d\u0006lW\r\u0005\u0002D\u0019:\u0011AI\u0013\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u0016\na\u0001\u0010:p_Rt$\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C\u0015A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!a\u0013%\u0002\u00191Lgn[%t!\u0006,8/\u001a3\u0011\u0007E\u0013F+D\u0001I\u0013\t\u0019\u0006JA\u0005Gk:\u001cG/[8oaA\u0011\u0011+V\u0005\u0003-\"\u0013qAQ8pY\u0016\fg.A\u0005tG\",G-\u001e7feB\u0011\u0011&W\u0005\u00035~\u0011Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018BA,-\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014\bCA\u0015_\u0013\tyvD\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\u0006m_\u000e\fG.\u00113nS:\u0004\"!\u000b2\n\u0005\r|\"!F\"mkN$XM\u001d'j].\u0014\u0015\r^2i\u0003\u0012l\u0017N\\\u0001\u0005i&lW\r\u0005\u0002gQ6\tqM\u0003\u00023q%\u0011\u0011n\u001a\u0002\u0005)&lW-\u0003\u0002eY\u0005)\u0011/^8uCB\u0011QN\\\u0007\u0002C%\u0011q.\t\u0002\u0018\u00072,8\u000f^3s\u0019&t7NU3rk\u0016\u001cH/U;pi\u0006L!a\u001b\u0017\u0002\u000f5,GO]5dgB\u0011\u0011f]\u0005\u0003i~\u0011!c\u00117vgR,'\u000fT5oW6+GO]5dg\u0006)R.\u0019=U_BL7m\u001d)fe&#XM]1uS>t\u0007CA)x\u0013\tA\bJA\u0002J]R\f!\"\u001b8uKJ4\u0018\r\\'t\u0013\tYH&A\tsKN\u001c\u0007.\u001a3vY\u0016$U\r\\1z\u001bN\fAB]3uef$U\r\\1z\u001bN\fa\u0001P5oSRtD#G@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY!!\u0004\u0002\u0010\u0005E\u00111CA\u000b\u0003/\u0001\"!\u000b\u0001\t\u000bUj\u0001\u0019\u0001\u001c\t\u000b\u0005k\u0001\u0019\u0001\"\t\u000b=k\u0001\u0019\u0001)\t\u000b]k\u0001\u0019\u0001-\t\u000bqk\u0001\u0019A/\t\u000b\u0001l\u0001\u0019A1\t\u000b\u0011l\u0001\u0019A3\t\u000b-l\u0001\u0019\u00017\t\u000bEl\u0001\u0019\u0001:\t\u000fUl\u0001\u0013!a\u0001m\"9\u00110\u0004I\u0001\u0002\u00041\bb\u0002?\u000e!\u0003\u0005\rA^\u0001\ti\u0006\u001c8\u000eR3tGV\u0011\u0011Q\u0004\t\u0006#\u0006}\u00111E\u0005\u0004\u0003CA%AB(qi&|g\u000eE\u0002*\u0003KI1!a\n \u0005=!\u0016m]6EKN\u001c'/\u001b9uS>t\u0017\u0001\u0004;bg.$Um]2`I\u0015\fH\u0003BA\u0017\u0003g\u00012!UA\u0018\u0013\r\t\t\u0004\u0013\u0002\u0005+:LG\u000fC\u0005\u00026=\t\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010J\u0019\u0002\u0013Q\f7o\u001b#fg\u000e\u0004\u0003f\u0001\t\u0002<A\u0019\u0011+!\u0010\n\u0007\u0005}\u0002J\u0001\u0005w_2\fG/\u001b7f\u0003\r\u0011XO\u001c\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002V9\u0019\u0011\u0011\n\u0016\u000f\t\u0005-\u00131\u000b\b\u0005\u0003\u001b\n\tFD\u0002F\u0003\u001fJ\u0011\u0001J\u0005\u0003E\rJ!\u0001I\u0011\n\u0007\u0005]cF\u0001\u0006UCN\\'+Z:vYR\fQB]3t_24X\rV8qS\u000e\u001cH\u0003BA#\u0003;Ba!a\u0018\u0013\u0001\u0004!\u0016\u0001C5t!\u0006,8/\u001a3\u0002\u001bA\u0014xnY3tgR{\u0007/[2t)\u0019\t)%!\u001a\u0002h!1\u0011qL\nA\u0002QCq!!\u001b\u0014\u0001\u0004\tY'\u0001\u0004u_BL7m\u001d\t\u0006\u0003[\n9H\u0011\b\u0005\u0003_\n\u0019HD\u0002F\u0003cJ\u0011!S\u0005\u0004\u0003kB\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003s\nYHA\u0002TKFT1!!\u001eI\u0003U\u0001(o\\2fgN$v\u000e]5dg\u000e{W\u000e\u001d7fi\u0016$\u0002\"!\u0012\u0002\u0002\u0006-\u0015Q\u0012\u0005\b\u0003\u0007#\u0002\u0019AAC\u0003-!\u0018m]6D_:$X\r\u001f;\u0011\t\u0005\u001d\u0013qQ\u0005\u0004\u0003\u0013s#a\u0003+bg.\u001cuN\u001c;fqRDa!a\u0018\u0015\u0001\u0004!\u0006bBAH)\u0001\u0007\u0011\u0011S\u0001\be\u0016\u001cX\u000f\u001c;t!\u001d\t\u0019*!(C\u0003Ck!!!&\u000b\t\u0005]\u0015\u0011T\u0001\u0005kRLGN\u0003\u0002\u0002\u001c\u0006!!.\u0019<b\u0013\u0011\ty*!&\u0003\u00075\u000b\u0007\u000fE\u00038\u0003G\u000b9+C\u0002\u0002&b\u00121bS1gW\u00064U\u000f^;sKB!\u0011\u0011VAX\u001b\t\tYK\u0003\u0003\u0002.\u0006e\u0015\u0001\u00027b]\u001eLA!!-\u0002,\n!ak\\5e\u0003\u0019\t7\r^5p]R\u0019!)a.\t\r\u0005}S\u00031\u0001U\u00031ygnQ8na2,G/[8o)\u0011\ti#!0\t\u000f\u0005}f\u00031\u0001\u0002B\u00061!/Z:vYR\u00042\u0001KAb\u0013\r\t)M\f\u0002\u0014\u0007>l\u0007\u000f\\3uK\u0012$\u0016m]6SKN,H\u000e^\u0001\u0010i\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]R\u0011\u0011QD\u0001\u0018\u00072,8\u000f^3s\u0019&t7\u000eU1vg\u0016l\u0015N\u001d:peN\u0004\"!K\r\u0014\u0007e\t\t\u000eE\u0002R\u0003'L1!!6I\u0005\u0019\te.\u001f*fMR\u0011\u0011QZ\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00191+\t\tiNK\u0002w\u0003?\\#!!9\u0011\t\u0005\r\u0018Q^\u0007\u0003\u0003KTA!a:\u0002j\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003WD\u0015AC1o]>$\u0018\r^5p]&!\u0011q^As\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00192\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cI\u0002")
public class ClusterLinkPauseMirrors
extends ClusterLinkScheduler.PeriodicTask {
    private final Uuid linkId;
    private final String linkName;
    private final Function0<Object> linkIsPaused;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkMetrics metrics;
    private final int maxTopicsPerIteration;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$12() {
        return ClusterLinkPauseMirrors$.MODULE$.$lessinit$greater$default$12();
    }

    public static int $lessinit$greater$default$11() {
        return ClusterLinkPauseMirrors$.MODULE$.$lessinit$greater$default$11();
    }

    public static int $lessinit$greater$default$10() {
        return ClusterLinkPauseMirrors$.MODULE$.$lessinit$greater$default$10();
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (this.metadataManager.isLinkCoordinator(this.linkName)) {
            return this.resolveTopics(this.linkIsPaused.apply$mcZ$sp());
        }
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
    }

    private ClusterLinkScheduler.TaskResult resolveTopics(boolean isPaused) {
        Seq process = ((MapOps)this.metadataManager.mirrorTopicStatesFromMetadataCache(this.linkId).filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ClusterLinkPauseMirrors.$anonfun$resolveTopics$1(this, isPaused, x0$1)))).keys().toSeq();
        if (process.nonEmpty()) {
            Seq trimmed = process.size() > this.maxTopicsPerIteration ? (Seq)process.drop(process.size() - this.maxTopicsPerIteration) : process;
            return this.processTopics(isPaused, trimmed);
        }
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq)package$.MODULE$.Seq().empty());
    }

    private ClusterLinkScheduler.TaskResult processTopics(boolean isPaused, Seq<String> topics) {
        this.debug((Function0<String> & Serializable)() -> "Starting " + this.action(isPaused) + " mirror topics for topics '" + topics + "'");
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq)package$.MODULE$.Seq().empty());
        scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1<String, Tuple2> & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), isPaused ? AlterMirrorOp.PAUSE_LINK : AlterMirrorOp.RESUME_LINK))).toMap($less$colon$less$.MODULE$.refl());
        AlterMirrorsResult result = this.localAdmin.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava(ops).asJava());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult> & Serializable)tc -> this.processTopicsComplete((ClusterLinkScheduler.TaskContext)tc, isPaused, result.values()), taskContext));
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult processTopicsComplete(ClusterLinkScheduler.TaskContext taskContext, boolean isPaused, Map<String, KafkaFuture<Void>> results) {
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option;
                KafkaFuture future = (KafkaFuture)tuple2._2();
                try {
                    future.get();
                    option = None$.MODULE$;
                }
                catch (ExecutionException e) {
                    option = this.onError$1(e.getCause(), isPaused);
                }
                catch (Throwable e) {
                    option = this.onError$1(e, isPaused);
                }
                return option;
            }
            throw new MatchError(tuple2);
        });
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq)taskContext.errs().$plus$plus(errs));
        if (errs.isEmpty()) {
            if (isPaused == this.linkIsPaused.apply$mcZ$sp()) {
                return this.resolveTopics(isPaused);
            }
            return ClusterLinkScheduler$.MODULE$.completedTask(newTaskContext.errs());
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(newTaskContext.errs());
    }

    private String action(boolean isPaused) {
        if (isPaused) {
            return "pausing";
        }
        return "unpausing";
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String> & Serializable)() -> "Completed with task result " + result);
        if (this.metadataManager.isLinkCoordinator(this.linkName)) {
            this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkPauseMirrorTopicsTaskType$.MODULE$, false, "run the pause mirror topics task"));
            return;
        }
        this.taskDesc_$eq(None$.MODULE$);
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public static final /* synthetic */ boolean $anonfun$resolveTopics$1(ClusterLinkPauseMirrors $this, boolean isPaused$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            boolean bl;
            ClusterLinkTopicState state = (ClusterLinkTopicState)tuple2._2();
            Uuid uuid = state.linkId();
            Uuid uuid2 = $this.linkId;
            if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
                return false;
            }
            try {
                bl = isPaused$1 ? state.toPausedState(true).nonEmpty() : state.toUnpausedState(true).nonEmpty();
            }
            catch (Throwable throwable) {
                bl = false;
            }
            return bl;
        }
        throw new MatchError(tuple2);
    }

    private final Option onError$1(Throwable e, boolean isPaused$3) {
        String errMsg = "Encountered error while " + this.action(isPaused$3) + " mirror topics";
        this.warn((Function0<String> & Serializable)() -> errMsg, (Function0<Throwable> & Serializable)() -> e);
        return new Some<TaskErrorCodeAndMsg>(new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
    }

    public ClusterLinkPauseMirrors(Uuid linkId, String linkName, Function0<Object> linkIsPaused, ClusterLinkScheduler scheduler, ClusterLinkMetadataManager metadataManager, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota, ClusterLinkMetrics metrics, int maxTopicsPerIteration, int intervalMs, int retryDelayMs) {
        this.linkId = linkId;
        this.linkName = linkName;
        this.linkIsPaused = linkIsPaused;
        this.metadataManager = metadataManager;
        this.localAdmin = localAdmin;
        this.metrics = metrics;
        this.maxTopicsPerIteration = maxTopicsPerIteration;
        super(scheduler, "ClusterLinkPauseMirrors", intervalMs, time, quota);
        this.taskDesc = None$.MODULE$;
    }
}

