/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import kafka.server.KafkaConfig;
import kafka.server.RegionalMetadataClient;
import kafka.server.RegionalNetworkMetadata;
import kafka.server.link.ClusterLinkRegionalMetadata$;
import kafka.server.link.ClusterLinkRegionalMetadataNetworkOp;
import kafka.server.link.ClusterLinkScheduler;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.MetadataNotAvailableException;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Mv!B\u0011#\u0011\u0003Ic!B\u0016#\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%\tA\u000e\u0005\u0007\u007f\u0005\u0001\u000b\u0011B\u001c\t\u000f\u0001\u000b!\u0019!C\u0001m!1\u0011)\u0001Q\u0001\n]BqAQ\u0001C\u0002\u0013\u00051\t\u0003\u0004H\u0003\u0001\u0006I\u0001\u0012\u0005\b\u0011\u0006\u0011\r\u0011\"\u0001D\u0011\u0019I\u0015\u0001)A\u0005\t\u001a!1F\t\u0001K\u0011!\t6B!A!\u0002\u0013\u0011\u0006\u0002\u0003-\f\u0005\u0003\u0005\u000b\u0011B-\t\u0011u[!\u0011!Q\u0001\nyC\u0001\"\\\u0006\u0003\u0002\u0003\u0006IA\u001c\u0005\tc.\u0011\t\u0011)A\u0005e\"Aao\u0003B\u0001B\u0003%q\u000f\u0003\u00044\u0017\u0011\u0005\u0011\u0011\u0001\u0005\n\u0003#Y\u0001\u0019!C\u0005\u0003'A\u0011\"!\f\f\u0001\u0004%I!a\f\t\u0011\u0005m2\u0002)Q\u0005\u0003+A\u0011\"!\u0012\f\u0005\u0004%I!a\u0012\t\u0011\u0005M3\u0002)A\u0005\u0003\u0013B\u0001\"!\u0016\f\u0001\u0004%Ia\u0011\u0005\n\u0003/Z\u0001\u0019!C\u0005\u00033Bq!!\u0018\fA\u0003&A\tC\u0004\u0002`-!\t!!\u0019\t\u000f\u0005\r4\u0002\"\u0003\u0002b!9\u0011QM\u0006\u0005\n\u0005\u001d\u0004bBAC\u0017\u0011%\u0011\u0011\r\u0005\b\u0003\u000f[A\u0011BAE\u0011\u001d\t\tj\u0003C\u0001\u0003'\u000b1d\u00117vgR,'\u000fT5oWJ+w-[8oC2lU\r^1eCR\f'BA\u0012%\u0003\u0011a\u0017N\\6\u000b\u0005\u00152\u0013AB:feZ,'OC\u0001(\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AK\u0001\u000e\u0003\t\u00121d\u00117vgR,'\u000fT5oWJ+w-[8oC2lU\r^1eCR\f7CA\u0001.!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!K\u0001\u000fG>tg\r\\;f]R,eN^%e+\u00059\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0011a\u0017M\\4\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002\u001f\r|gN\u001a7vK:$XI\u001c<JI\u0002\nabY8oM2,XM\u001c;Pe\u001eLE-A\bd_:4G.^3oi>\u0013x-\u00133!\u0003)i\u0017N\u001c*fiJLXj]\u000b\u0002\tB\u0011a&R\u0005\u0003\r>\u00121!\u00138u\u0003-i\u0017N\u001c*fiJLXj\u001d\u0011\u0002\u00155\f\u0007PU3uefl5/A\u0006nCb\u0014V\r\u001e:z\u001bN\u00043cA\u0006.\u0017B\u0011AjT\u0007\u0002\u001b*\u0011aJJ\u0001\u0006kRLGn]\u0005\u0003!6\u0013q\u0001T8hO&tw-A\u000fdC:$&/\u00198tY\u0006$XMQ8piN$(/\u00199TkB\u0004H.[3s!\rq3+V\u0005\u0003)>\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u000592\u0016BA,0\u0005\u001d\u0011un\u001c7fC:\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"AW.\u000e\u0003\u0011J!\u0001\u0018\u0013\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0014[VdG/\u001b+f]\u0006tG/T3uC\u0012\fG/\u0019\t\u0004]}\u000b\u0017B\u000110\u0005\u0019y\u0005\u000f^5p]B\u0011!m[\u0007\u0002G*\u0011A-Z\u0001\f[VdG/\u001b;f]\u0006tGO\u0003\u0002&M*\u0011qe\u001a\u0006\u0003Q&\fa!\u00199bG\",'\"\u00016\u0002\u0007=\u0014x-\u0003\u0002mG\n\u0019R*\u001e7uSR+g.\u00198u\u001b\u0016$\u0018\rZ1uC\u0006I1o\u00195fIVdWM\u001d\t\u0003U=L!\u0001\u001d\u0012\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0003Y\u0011XmZ5p]\u0006dW*\u001a;bI\u0006$\u0018m\u00117jK:$\bc\u0001\u0018`gB\u0011!\f^\u0005\u0003k\u0012\u0012aCU3hS>t\u0017\r\\'fi\u0006$\u0017\r^1DY&,g\u000e^\u0001\u0012Y>\u001c\u0017\r\\!e[&tg)Y2u_JL\bc\u0001\u0018TqB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003{\u001a\fqa\u00197jK:$8/\u0003\u0002\u0000u\n)\u0011\tZ7j]Rq\u00111AA\u0003\u0003\u000f\tI!a\u0003\u0002\u000e\u0005=\u0001C\u0001\u0016\f\u0011\u0015\t&\u00031\u0001S\u0011\u0015A&\u00031\u0001Z\u0011\u0015i&\u00031\u0001_\u0011\u0015i'\u00031\u0001o\u0011\u0015\t(\u00031\u0001s\u0011\u00151(\u00031\u0001x\u0003-qW\r^<pe.$\u0016\u0010]3\u0016\u0005\u0005U\u0001\u0003BA\f\u0003Si!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0014'\u0006\u001cH.\u00138uKJt\u0017\r\\\"p]\u001aLwm\u001d\u0006\u0005\u0003?\t\t#A\u0007bkRDWM\u001c;jG\u0006$xN\u001d\u0006\u0005\u0003G\t)#\u0001\u0005tK\u000e,(/\u001b;z\u0015\r\t9CZ\u0001\u0007G>lWn\u001c8\n\t\u0005-\u0012\u0011\u0004\u0002\f\u001d\u0016$xo\u001c:l)f\u0004X-A\boKR<xN]6UsB,w\fJ3r)\u0011\t\t$a\u000e\u0011\u00079\n\u0019$C\u0002\u00026=\u0012A!\u00168ji\"I\u0011\u0011\b\u000b\u0002\u0002\u0003\u0007\u0011QC\u0001\u0004q\u0012\n\u0014\u0001\u00048fi^|'o\u001b+za\u0016\u0004\u0003fA\u000b\u0002@A\u0019a&!\u0011\n\u0007\u0005\rsF\u0001\u0005w_2\fG/\u001b7f\u0003\u001d\u0011\u0017mY6pM\u001a,\"!!\u0013\u0011\t\u0005-\u0013qJ\u0007\u0003\u0003\u001bR1ATA\u0013\u0013\u0011\t\t&!\u0014\u0003%\u0015C\bo\u001c8f]RL\u0017\r\u001c\"bG.|gMZ\u0001\tE\u0006\u001c7n\u001c4gA\u0005i!/\u001a;ss\u0006#H/Z7qiN\f\u0011C]3uef\fE\u000f^3naR\u001cx\fJ3r)\u0011\t\t$a\u0017\t\u0011\u0005e\u0012$!AA\u0002\u0011\u000baB]3uef\fE\u000f^3naR\u001c\b%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005E\u0012aE4fi2{7-\u00197OKR<xN]6UsB,\u0017AG:f]\u0012tU\r^<pe.lU\r^1eCR\f'+Z9vKN$HCBA\u0019\u0003S\n\t\tC\u0004\u0002lu\u0001\r!!\u001c\u0002\u001d=\u0014x-\u00198ju\u0006$\u0018n\u001c8JIB!\u0011qNA?\u001d\u0011\t\t(!\u001f\u0011\u0007\u0005Mt&\u0004\u0002\u0002v)\u0019\u0011q\u000f\u0015\u0002\rq\u0012xn\u001c;?\u0013\r\tYhL\u0001\u0007!J,G-\u001a4\n\u0007y\nyHC\u0002\u0002|=Bq!a!\u001e\u0001\u0004\ti'A\u0007f]ZL'o\u001c8nK:$\u0018\nZ\u0001\u0013a\u0016\u00148/[:u\u001d\u0016$xo\u001c:l)f\u0004X-\u0001\u0006hKR\u0014V\r\u001e:z\u001bN$\"!a#\u0011\u00079\ni)C\u0002\u0002\u0010>\u0012A\u0001T8oO\u0006)r-\u001a;DYV\u001cH/\u001a:OKR<xN]6UsB,WCAAK!\u0011\t9*!\u000b\u000f\t\u0005e\u0015\u0011\u0017\b\u0005\u00037\u000byK\u0004\u0003\u0002\u001e\u00065f\u0002BAP\u0003WsA!!)\u0002*:!\u00111UAT\u001d\u0011\t\u0019(!*\n\u0003)L!\u0001[5\n\u0005\u001d:\u0017bAA\u0014M&!\u00111EA\u0013\u0013\u0011\ty\"!\t\n\t\u0005m\u0011Q\u0004")
public class ClusterLinkRegionalMetadata
implements Logging {
    private final Function0<Object> canTranslateBootstrapSupplier;
    private final KafkaConfig brokerConfig;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private final ClusterLinkScheduler scheduler;
    private final Option<RegionalMetadataClient> regionalMetadataClient;
    private final Function0<Admin> localAdminFactory;
    private volatile SaslInternalConfigs.NetworkType networkType;
    private final ExponentialBackoff backoff;
    private int retryAttempts;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int maxRetryMs() {
        return ClusterLinkRegionalMetadata$.MODULE$.maxRetryMs();
    }

    public static int minRetryMs() {
        return ClusterLinkRegionalMetadata$.MODULE$.minRetryMs();
    }

    public static String confluentOrgId() {
        return ClusterLinkRegionalMetadata$.MODULE$.confluentOrgId();
    }

    public static String confluentEnvId() {
        return ClusterLinkRegionalMetadata$.MODULE$.confluentEnvId();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkRegionalMetadata clusterLinkRegionalMetadata = this;
        synchronized (clusterLinkRegionalMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private SaslInternalConfigs.NetworkType networkType() {
        return this.networkType;
    }

    private void networkType_$eq(SaslInternalConfigs.NetworkType x$1) {
        this.networkType = x$1;
    }

    private ExponentialBackoff backoff() {
        return this.backoff;
    }

    private int retryAttempts() {
        return this.retryAttempts;
    }

    private void retryAttempts_$eq(int x$1) {
        this.retryAttempts = x$1;
    }

    public void startup() {
        this.networkType_$eq(SaslInternalConfigs.NetworkType.fromString((String)this.brokerConfig.trafficNetworkType()));
        if (this.canTranslateBootstrapSupplier.apply$mcZ$sp() && this.regionalMetadataClient.isDefined() && this.multiTenantMetadata.isDefined()) {
            this.info((Function0<String> & Serializable)() -> "Set local network type to persisted value " + this.networkType() + ". Getting cluster link regional metadata");
            this.scheduler.scheduleOnce("ClusterLinkRegionalMetadata", () -> this.getLocalNetworkType());
            return;
        }
        this.info((Function0<String> & Serializable)() -> "Set local network type to persisted value " + this.networkType());
    }

    private void getLocalNetworkType() {
        block5: {
            try {
                if (!this.canTranslateBootstrapSupplier.apply$mcZ$sp()) break block5;
                if (!this.multiTenantMetadata.get().isUp()) {
                    throw new MetadataNotAvailableException("MultiTenantMetadata is not up");
                }
                LogicalClusterMetadata firstActiveUserLkcMetadata = this.multiTenantMetadata.get().firstActiveUserLkcMetadata();
                if (firstActiveUserLkcMetadata != null) {
                    this.sendNetworkMetadataRequest(firstActiveUserLkcMetadata.organizationId(), firstActiveUserLkcMetadata.environmentId());
                    break block5;
                }
                this.sendNetworkMetadataRequest(ClusterLinkRegionalMetadata$.MODULE$.confluentOrgId(), ClusterLinkRegionalMetadata$.MODULE$.confluentEnvId());
            }
            catch (Throwable e) {
                long retryMs = this.getRetryMs();
                this.error((Function0<String> & Serializable)() -> "Exception when getting local network type, will retry after " + retryMs + " ms", (Function0<Throwable> & Serializable)() -> e);
                if (this.scheduler.isStarted()) {
                    this.scheduler.scheduleOnce("ClusterLinkRegionalMetadata", () -> this.getLocalNetworkType(), retryMs);
                    break block5;
                }
                this.warn((Function0<String> & Serializable)() -> "Stop scheduling because scheduler is shutdown");
            }
        }
    }

    private void sendNetworkMetadataRequest(String organizationId, String environmentId) {
        ClusterLinkRegionalMetadataNetworkOp networkMetadataOperation = new ClusterLinkRegionalMetadataNetworkOp(organizationId, environmentId, this.brokerConfig.trafficNetworkId(), this.regionalMetadataClient.get());
        CompletableFuture<Option<RegionalNetworkMetadata>> networkMetadataFuture = networkMetadataOperation.execute();
        networkMetadataFuture.whenComplete((networkMetadata, ex) -> {
            if (ex != null) {
                long retryMs = this.getRetryMs();
                this.error((Function0<String> & Serializable)() -> "Failed to get local network type with organization " + organizationId + " environment " + environmentId + " and network " + $this.brokerConfig.trafficNetworkId() + ", will retry after " + retryMs + " ms", (Function0<Throwable> & Serializable)() -> ex);
                $this.scheduler.scheduleOnce("ClusterLinkRegionalMetadata", () -> this.getLocalNetworkType(), retryMs);
                return;
            }
            if (!networkMetadata.isDefined()) {
                long retryMs = this.getRetryMs();
                this.info((Function0<String> & Serializable)() -> "Local network type is unavailable with organization " + organizationId + " environment " + environmentId + " and network " + $this.brokerConfig.trafficNetworkId() + ", will retry after " + retryMs + " ms");
                $this.scheduler.scheduleOnce("ClusterLinkRegionalMetadata", () -> this.getLocalNetworkType(), retryMs);
                return;
            }
            SaslInternalConfigs.NetworkType rmNetworkType = ((RegionalNetworkMetadata)networkMetadata.get()).isPrivate() ? SaslInternalConfigs.NetworkType.PRIVATE : SaslInternalConfigs.NetworkType.PUBLIC;
            SaslInternalConfigs.NetworkType networkType = this.networkType();
            SaslInternalConfigs.NetworkType networkType2 = rmNetworkType;
            if (!(networkType != null ? !networkType.equals(networkType2) : networkType2 != null)) {
                this.info((Function0<String> & Serializable)() -> "Local network type from RM is " + this.networkType() + ", which is the same as persisted network type");
                return;
            }
            this.networkType_$eq(rmNetworkType);
            this.info((Function0<String> & Serializable)() -> "Local network type from RM is " + this.networkType().name());
            this.persistNetworkType();
        });
    }

    private void persistNetworkType() {
        Admin localAdmin = this.localAdminFactory.apply();
        if (localAdmin != null) {
            KafkaFuture alterConfigFuture = localAdmin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Arrays.asList((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("confluent.traffic.network.type", this.networkType().name()), AlterConfigOp.OpType.SET)}))).all();
            alterConfigFuture.whenComplete((x$1, err) -> {
                if (err != null) {
                    this.error((Function0<String> & Serializable)() -> "Failed to persist local network type " + this.networkType(), (Function0<Throwable> & Serializable)() -> err);
                    return;
                }
                this.info((Function0<String> & Serializable)() -> "Persisted local network type " + this.networkType());
            });
            return;
        }
    }

    private long getRetryMs() {
        long retryMs = this.backoff().backoff((long)this.retryAttempts());
        this.retryAttempts_$eq(this.retryAttempts() + 1);
        return retryMs;
    }

    public SaslInternalConfigs.NetworkType getClusterNetworkType() {
        return this.networkType();
    }

    public ClusterLinkRegionalMetadata(Function0<Object> canTranslateBootstrapSupplier, KafkaConfig brokerConfig, Option<MultiTenantMetadata> multiTenantMetadata, ClusterLinkScheduler scheduler, Option<RegionalMetadataClient> regionalMetadataClient, Function0<Admin> localAdminFactory) {
        this.canTranslateBootstrapSupplier = canTranslateBootstrapSupplier;
        this.brokerConfig = brokerConfig;
        this.multiTenantMetadata = multiTenantMetadata;
        this.scheduler = scheduler;
        this.regionalMetadataClient = regionalMetadataClient;
        this.localAdminFactory = localAdminFactory;
        Logging.$init$(this);
        this.logIdent_$eq("[ClusterLinkRegionalMetadata-broker-" + brokerConfig.brokerId() + "] ");
        this.networkType = SaslInternalConfigs.NetworkType.NOT_SET;
        this.backoff = new ExponentialBackoff((long)ClusterLinkRegionalMetadata$.MODULE$.minRetryMs(), 2, (long)ClusterLinkRegionalMetadata$.MODULE$.maxRetryMs(), 0.0);
        this.retryAttempts = 0;
    }
}

