/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import kafka.server.link.AclLimitExceededTaskErrorCode$;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkAutoMirroringTaskType$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAclsTaskType$;
import kafka.server.link.ClusterLinkSyncOffsetsTaskType$;
import kafka.server.link.ClusterLinkSyncTopicConfigsTaskType$;
import kafka.server.link.ConsumerGroupInUseTaskErrorCode$;
import kafka.server.link.InErrorTaskState$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidRequestErrorCode$;
import kafka.server.link.InvalidTopicTaskErrorCode$;
import kafka.server.link.LinkCoordinatorNotEnabledTaskErrorCode$;
import kafka.server.link.LinkFailedTaskState$;
import kafka.server.link.LinkNotFoundTaskErrorCode$;
import kafka.server.link.LinkPausedTaskState$;
import kafka.server.link.LinkUnavailableTaskState$;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NoErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.PolicyViolationTaskErrorCode$;
import kafka.server.link.RemoteLinkNotFoundTaskErrorCode$;
import kafka.server.link.RemoteMirrorNotFoundTaskErrorCode$;
import kafka.server.link.SecurityDisabledTaskErrorCode$;
import kafka.server.link.SuppressedErrorsErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TaskState;
import kafka.server.link.TaskType;
import kafka.server.link.TopicExistsTaskErrorCode$;
import kafka.server.link.UnknownTaskState$;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.RetriableException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class ClusterLinkTask$ {
    public static final ClusterLinkTask$ MODULE$ = new ClusterLinkTask$();

    public boolean isRetriableException(Throwable ex) {
        Throwable throwable = ex;
        if (throwable instanceof RetriableException) {
            return true;
        }
        if (throwable instanceof AuthorizationException) {
            return true;
        }
        if (throwable != null) {
            return false;
        }
        throw new MatchError((Object)throwable);
    }

    public Option<TaskDescription> handleResult(ClusterLinkScheduler.CompletedTaskResult result, ClusterLinkFactory.LinkMetrics metrics, TaskType taskType, boolean isMirrorStateTransition, String description) {
        if (result.errs().isEmpty() && result.ex().isEmpty()) {
            metrics.clusterLinkTaskActiveSensor(taskType, isMirrorStateTransition).record();
            return new Some<TaskDescription>(new TaskDescription(ActiveTaskState$.MODULE$, (Seq)package$.MODULE$.Seq().empty()));
        }
        Seq errs = (Seq)result.errs().$plus$plus((IterableOnce)result.ex().map((Function1<Throwable, Seq> & Serializable)x$1 -> new $colon$colon<Nothing$>((Nothing$)((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to " + description + " for an unknown reason.")), Nil$.MODULE$)).getOrElse((Function0<Seq> & Serializable)() -> (Seq)package$.MODULE$.Seq().empty()));
        errs.foreach((Function1<TaskErrorCodeAndMsg, Object> & Serializable)err -> {
            ClusterLinkTask$.$anonfun$handleResult$3(metrics, taskType, isMirrorStateTransition, err);
            return BoxedUnit.UNIT;
        });
        return new Some<TaskDescription>(new TaskDescription(InErrorTaskState$.MODULE$, errs));
    }

    public ClusterLinkTaskDescription.ClusterLinkTaskState toAdminClientState(TaskState state) {
        TaskState taskState = state;
        if (ActiveTaskState$.MODULE$.equals(taskState)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.ACTIVE;
        }
        if (InErrorTaskState$.MODULE$.equals(taskState)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.IN_ERROR;
        }
        if (NotConfiguredTaskState$.MODULE$.equals(taskState)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.NOT_CONFIGURED;
        }
        if (UnknownTaskState$.MODULE$.equals(taskState)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.UNKNOWN;
        }
        if (LinkFailedTaskState$.MODULE$.equals(taskState)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.LINK_FAILED;
        }
        if (LinkUnavailableTaskState$.MODULE$.equals(taskState)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.LINK_UNAVAILABLE;
        }
        if (LinkPausedTaskState$.MODULE$.equals(taskState)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.LINK_PAUSED;
        }
        throw new IllegalStateException("Unexpected state " + state.name());
    }

    public ClusterLinkTaskError toAdminClientError(TaskErrorCode errorCode, String errMsg) {
        ClusterLinkTaskError.ClusterLinkTaskErrorCode clusterLinkTaskErrorCode;
        TaskErrorCode taskErrorCode = errorCode;
        if (NoErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.NO_ERROR;
        } else if (InternalTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.INTERNAL_ERROR;
        } else if (AuthenticationTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.AUTHENTICATION_ERROR;
        } else if (BrokerAuthenticationTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.BROKER_AUTHENTICATION_ERROR;
        } else if (MisconfigurationTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.MISCONFIGURATION_ERROR;
        } else if (RemoteLinkNotFoundTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.REMOTE_LINK_NOT_FOUND_ERROR;
        } else if (RemoteMirrorNotFoundTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.REMOTE_MIRROR_NOT_FOUND_ERROR;
        } else if (LinkNotFoundTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.LINK_NOT_FOUND_ERROR;
        } else if (ConsumerGroupInUseTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.CONSUMER_GROUP_IN_USE_ERROR;
        } else if (AuthorizationTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.AUTHORIZATION_ERROR;
        } else if (BrokerAuthorizationTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.BROKER_AUTHORIZATION_ERROR;
        } else if (SecurityDisabledTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.SECURITY_DISABLED_ERROR;
        } else if (TopicExistsTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.TOPIC_EXISTS_ERROR;
        } else if (InvalidTopicTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.INVALID_TOPIC;
        } else if (PolicyViolationTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.POLICY_VIOLATION_ERROR;
        } else if (LinkCoordinatorNotEnabledTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.LINK_COORDINATOR_NOT_ENABLED_ERROR;
        } else if (AclLimitExceededTaskErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.ACL_LIMIT_EXCEEDED;
        } else if (UnknownTopicOrPartitionErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.UNKNOWN_TOPIC_OR_PARTITION_ERROR;
        } else if (InvalidRequestErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.INVALID_REQUEST_ERROR;
        } else if (SuppressedErrorsErrorCode$.MODULE$.equals(taskErrorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.SUPPRESSED_ERRORS;
        } else {
            throw new IllegalStateException("Unexpected error code " + errorCode.name());
        }
        ClusterLinkTaskError.ClusterLinkTaskErrorCode adminClientErrCode = clusterLinkTaskErrorCode;
        return new ClusterLinkTaskError(adminClientErrCode, errMsg);
    }

    public String toAdminClientTaskName(TaskType taskType) {
        TaskType taskType2 = taskType;
        if (ClusterLinkSyncOffsetsTaskType$.MODULE$.equals(taskType2)) {
            return "ConsumerOffsetSync";
        }
        if (ClusterLinkSyncAclsTaskType$.MODULE$.equals(taskType2)) {
            return "AclSync";
        }
        if (ClusterLinkAutoMirroringTaskType$.MODULE$.equals(taskType2)) {
            return "AutoCreateMirror";
        }
        if (ClusterLinkSyncTopicConfigsTaskType$.MODULE$.equals(taskType2)) {
            return "TopicConfigsSync";
        }
        throw new IllegalStateException("Unexpected task type " + taskType);
    }

    public static final /* synthetic */ void $anonfun$handleResult$3(ClusterLinkFactory.LinkMetrics metrics$1, TaskType taskType$1, boolean isMirrorStateTransition$1, TaskErrorCodeAndMsg err) {
        metrics$1.clusterLinkTaskInErrorSensor(taskType$1, isMirrorStateTransition$1, err.code()).record();
    }

    private ClusterLinkTask$() {
    }
}

