/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.UUID;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingMirror$;
import kafka.server.link.TopicLinkPendingRepairMirror$;
import kafka.server.link.TopicLinkPendingRestoreMirror$;
import kafka.server.link.TopicLinkPendingSetupForRestoreMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkPendingSynchronizeMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeBoolean$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.MirrorTopicSwitchoverMetadata;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.AbstractSeq;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkTopicState$ {
    public static final ClusterLinkTopicState$ MODULE$ = new ClusterLinkTopicState$();

    public String toJsonString(ClusterLinkTopicState state) {
        return Json$.MODULE$.encodeAsString(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(state.state().name()), CollectionConverters$.MODULE$.MapHasAsJava(state.toMap()).asJava())}))).asJava());
    }

    private MirrorTopicSwitchoverMetadata switchoverMetadataFromJson(JsonValue json) {
        JsonObject jsonObj = json.asJsonObject();
        int errorCode = BoxesRunTime.unboxToInt(jsonObj.get("error_code").map((Function1<JsonValue, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(ClusterLinkTopicState$.$anonfun$switchoverMetadataFromJson$1(x$2))).getOrElse(() -> 0));
        String errorMessage = (String)jsonObj.get("error_message").map((Function1<JsonValue, String> & Serializable)x$3 -> x$3.to(DecodeJson$DecodeString$.MODULE$)).getOrElse((Function0<String> & Serializable)() -> "");
        long messagesTruncated = BoxesRunTime.unboxToLong(jsonObj.get("messages_truncated").map((Function1<JsonValue, Object> & Serializable)x$4 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$switchoverMetadataFromJson$5(x$4))).getOrElse(() -> 0L));
        return new MirrorTopicSwitchoverMetadata((short)errorCode, errorMessage, messagesTruncated);
    }

    public ClusterLinkTopicState fromJsonString(String json2) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(json2);
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonValue jsonValue = (JsonValue)some.value();
            JsonObject jsonObj = jsonValue.asJsonObject();
            Object entries = ((List)TopicLinkState$.MODULE$.states().map((Function1<TopicLinkState, Tuple2> & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), jsonObj.get(key.name())))).filter((Function1<Tuple2, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(ClusterLinkTopicState$.$anonfun$fromJsonString$2(x$5)));
            if (((AbstractSeq)entries).size() != 1) {
                throw new IllegalStateException("Invalid cluster link topic state(s)");
            }
            Tuple2 tuple2 = (Tuple2)((AbstractIterable)entries).head();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicLinkState k = (TopicLinkState)tuple2._1();
            Option v = (Option)tuple2._2();
            Tuple2<TopicLinkState, JsonObject> tuple22 = new Tuple2<TopicLinkState, JsonObject>(k, ((JsonValue)v.get()).asJsonObject());
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            TopicLinkState key2 = tuple22._1();
            JsonObject jsonOpt = tuple22._2();
            Tuple2<TopicLinkState, JsonObject> tuple23 = new Tuple2<TopicLinkState, JsonObject>(key2, jsonOpt);
            TopicLinkState key3 = tuple23._1();
            JsonObject jsonOpt2 = tuple23._2();
            TopicLinkState topicLinkState = key3;
            if (TopicLinkMirror$.MODULE$.equals(topicLinkState)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt(jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong(jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Seq mirrorStartOffsets = (Seq)jsonOpt2.get("mirror_start_offsets").map((Function1<JsonValue, Seq> & Serializable)x$9 -> (Seq)x$9.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Seq$.MODULE$.iterableFactory()))).getOrElse((Function0<Seq> & Serializable)() -> (Seq)Seq$.MODULE$.empty());
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong(jsonOpt2.get("stopped_sequence_number").map((Function1<JsonValue, Object> & Serializable)x$10 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$fromJsonString$9(x$10))).getOrElse(() -> 0L));
                MirrorTopicSwitchoverMetadata switchoverMetadata = (MirrorTopicSwitchoverMetadata)jsonOpt2.get("switchover_metadata").map((Function1<JsonValue, MirrorTopicSwitchoverMetadata> & Serializable)json -> MODULE$.switchoverMetadataFromJson((JsonValue)json)).getOrElse((Function0<MirrorTopicSwitchoverMetadata> & Serializable)() -> MirrorTopicSwitchoverMetadata.empty());
                return new ClusterLinkTopicState.Mirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1(jsonOpt2), stoppedSequenceNumber, switchoverMetadata, timeMs, mirrorStartOffsets);
            }
            if (TopicLinkPausedMirror$.MODULE$.equals(topicLinkState)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt(jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong(jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                boolean linkLevel = BoxesRunTime.unboxToBoolean(jsonOpt2.apply("link_level").to(DecodeJson$DecodeBoolean$.MODULE$));
                boolean topicLevel = BoxesRunTime.unboxToBoolean(jsonOpt2.apply("topic_level").to(DecodeJson$DecodeBoolean$.MODULE$));
                boolean wasFailed = BoxesRunTime.unboxToBoolean(jsonOpt2.apply("was_failed").to(DecodeJson$DecodeBoolean$.MODULE$));
                TopicLinkState previousState = this.topicLinkState(jsonOpt2.get("previous_state").map((Function1<JsonValue, String> & Serializable)x$11 -> x$11.to(DecodeJson$DecodeString$.MODULE$)), wasFailed ? TopicLinkFailedMirror$.MODULE$ : TopicLinkMirror$.MODULE$);
                TopicLinkState pendingSynchronizeNextState = this.topicLinkState(jsonOpt2.get("pending_synchronize_next_state").map((Function1<JsonValue, String> & Serializable)x$12 -> x$12.to(DecodeJson$DecodeString$.MODULE$)), null);
                MirrorTopicError error = this.mirrorTopicError(jsonOpt2, wasFailed);
                Seq mirrorStartOffsets = (Seq)jsonOpt2.get("mirror_start_offsets").map((Function1<JsonValue, Seq> & Serializable)x$13 -> (Seq)x$13.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Seq$.MODULE$.iterableFactory()))).getOrElse((Function0<Seq> & Serializable)() -> (Seq)Seq$.MODULE$.empty());
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong(jsonOpt2.get("stopped_sequence_number").map((Function1<JsonValue, Object> & Serializable)x$14 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$fromJsonString$17(x$14))).getOrElse(() -> 0L));
                MirrorTopicSwitchoverMetadata switchoverMetadata = (MirrorTopicSwitchoverMetadata)jsonOpt2.get("switchover_metadata").map((Function1<JsonValue, MirrorTopicSwitchoverMetadata> & Serializable)json -> MODULE$.switchoverMetadataFromJson((JsonValue)json)).getOrElse((Function0<MirrorTopicSwitchoverMetadata> & Serializable)() -> MirrorTopicSwitchoverMetadata.empty());
                return new ClusterLinkTopicState.PausedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1(jsonOpt2), linkLevel, topicLevel, previousState, pendingSynchronizeNextState, error, stoppedSequenceNumber, switchoverMetadata, timeMs, mirrorStartOffsets);
            }
            if (TopicLinkFailedMirror$.MODULE$.equals(topicLinkState)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt(jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong(jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                MirrorTopicError error = this.mirrorTopicError(jsonOpt2, true);
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong(jsonOpt2.get("stopped_sequence_number").map((Function1<JsonValue, Object> & Serializable)x$15 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$fromJsonString$21(x$15))).getOrElse(() -> 0L));
                MirrorTopicSwitchoverMetadata switchoverMetadata = (MirrorTopicSwitchoverMetadata)jsonOpt2.get("switchover_metadata").map((Function1<JsonValue, MirrorTopicSwitchoverMetadata> & Serializable)json -> MODULE$.switchoverMetadataFromJson((JsonValue)json)).getOrElse((Function0<MirrorTopicSwitchoverMetadata> & Serializable)() -> MirrorTopicSwitchoverMetadata.empty());
                return new ClusterLinkTopicState.FailedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1(jsonOpt2), error, stoppedSequenceNumber, switchoverMetadata, timeMs);
            }
            if (TopicLinkPendingStoppedMirror$.MODULE$.equals(topicLinkState)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt(jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong(jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                boolean synchronize = BoxesRunTime.unboxToBoolean(jsonOpt2.apply("synchronize").to(DecodeJson$DecodeBoolean$.MODULE$));
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong(jsonOpt2.get("stopped_sequence_number").map((Function1<JsonValue, Object> & Serializable)x$16 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$fromJsonString$25(x$16))).getOrElse(() -> 0L));
                MirrorTopicSwitchoverMetadata switchoverMetadata = (MirrorTopicSwitchoverMetadata)jsonOpt2.get("switchover_metadata").map((Function1<JsonValue, MirrorTopicSwitchoverMetadata> & Serializable)json -> MODULE$.switchoverMetadataFromJson((JsonValue)json)).getOrElse((Function0<MirrorTopicSwitchoverMetadata> & Serializable)() -> MirrorTopicSwitchoverMetadata.empty());
                return new ClusterLinkTopicState.PendingStoppedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1(jsonOpt2), synchronize, stoppedSequenceNumber, switchoverMetadata, timeMs);
            }
            if (TopicLinkStoppedMirror$.MODULE$.equals(topicLinkState)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt(jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong(jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Seq logEndOffsets = (Seq)jsonOpt2.apply("log_end_offsets").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Seq$.MODULE$.iterableFactory()));
                Seq stoppedEpochs = (Seq)jsonOpt2.get("stopped_epochs").map((Function1<JsonValue, Seq> & Serializable)x$17 -> (Seq)x$17.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Seq$.MODULE$.iterableFactory()))).getOrElse((Function0<Seq> & Serializable)() -> (Seq)Seq$.MODULE$.empty());
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong(jsonOpt2.get("stopped_sequence_number").map((Function1<JsonValue, Object> & Serializable)x$18 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$fromJsonString$31(x$18))).getOrElse(() -> 0L));
                MirrorTopicSwitchoverMetadata switchoverMetadata = (MirrorTopicSwitchoverMetadata)jsonOpt2.get("switchover_metadata").map((Function1<JsonValue, MirrorTopicSwitchoverMetadata> & Serializable)json -> MODULE$.switchoverMetadataFromJson((JsonValue)json)).getOrElse((Function0<MirrorTopicSwitchoverMetadata> & Serializable)() -> MirrorTopicSwitchoverMetadata.empty());
                return new ClusterLinkTopicState.StoppedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1(jsonOpt2), logEndOffsets, stoppedEpochs, stoppedSequenceNumber, switchoverMetadata, timeMs);
            }
            if (TopicLinkPendingMirror$.MODULE$.equals(topicLinkState)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt(jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong(jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                String nextState = jsonOpt2.apply("next_state").to(DecodeJson$DecodeString$.MODULE$);
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong(jsonOpt2.get("stopped_sequence_number").map((Function1<JsonValue, Object> & Serializable)x$19 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$fromJsonString$35(x$19))).getOrElse(() -> 0L));
                MirrorTopicSwitchoverMetadata switchoverMetadata = (MirrorTopicSwitchoverMetadata)jsonOpt2.get("switchover_metadata").map((Function1<JsonValue, MirrorTopicSwitchoverMetadata> & Serializable)json -> MODULE$.switchoverMetadataFromJson((JsonValue)json)).getOrElse((Function0<MirrorTopicSwitchoverMetadata> & Serializable)() -> MirrorTopicSwitchoverMetadata.empty());
                return new ClusterLinkTopicState.PendingMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1(jsonOpt2), nextState, stoppedSequenceNumber, switchoverMetadata, timeMs);
            }
            if (TopicLinkPendingSynchronizeMirror$.MODULE$.equals(topicLinkState)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt(jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong(jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                TopicLinkState remoteMirrorNextState = this.topicLinkState(jsonOpt2.get("remote_mirror_next_state").map((Function1<JsonValue, String> & Serializable)x$20 -> x$20.to(DecodeJson$DecodeString$.MODULE$)), null);
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong(jsonOpt2.get("stopped_sequence_number").map((Function1<JsonValue, Object> & Serializable)x$21 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$fromJsonString$40(x$21))).getOrElse(() -> 0L));
                MirrorTopicSwitchoverMetadata switchoverMetadata = (MirrorTopicSwitchoverMetadata)jsonOpt2.get("switchover_metadata").map((Function1<JsonValue, MirrorTopicSwitchoverMetadata> & Serializable)json -> MODULE$.switchoverMetadataFromJson((JsonValue)json)).getOrElse((Function0<MirrorTopicSwitchoverMetadata> & Serializable)() -> MirrorTopicSwitchoverMetadata.empty());
                return new ClusterLinkTopicState.PendingSynchronizeMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1(jsonOpt2), remoteMirrorNextState, stoppedSequenceNumber, switchoverMetadata, timeMs);
            }
            if (TopicLinkPendingRepairMirror$.MODULE$.equals(topicLinkState)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt(jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong(jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                MirrorTopicError error = this.mirrorTopicError(jsonOpt2, true);
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong(jsonOpt2.get("stopped_sequence_number").map((Function1<JsonValue, Object> & Serializable)x$22 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$fromJsonString$44(x$22))).getOrElse(() -> 0L));
                MirrorTopicSwitchoverMetadata switchoverMetadata = (MirrorTopicSwitchoverMetadata)jsonOpt2.get("switchover_metadata").map((Function1<JsonValue, MirrorTopicSwitchoverMetadata> & Serializable)json -> MODULE$.switchoverMetadataFromJson((JsonValue)json)).getOrElse((Function0<MirrorTopicSwitchoverMetadata> & Serializable)() -> MirrorTopicSwitchoverMetadata.empty());
                return new ClusterLinkTopicState.PendingRepairMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1(jsonOpt2), error, stoppedSequenceNumber, switchoverMetadata, timeMs);
            }
            if (TopicLinkPendingSetupForRestoreMirror$.MODULE$.equals(topicLinkState)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt(jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong(jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Seq truncationOffsets = (Seq)jsonOpt2.apply("truncation_offsets").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Seq$.MODULE$.iterableFactory()));
                Seq truncationEpochs = (Seq)jsonOpt2.apply("truncation_epochs").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Seq$.MODULE$.iterableFactory()));
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong(jsonOpt2.get("stopped_sequence_number").map((Function1<JsonValue, Object> & Serializable)x$23 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$fromJsonString$48(x$23))).getOrElse(() -> 0L));
                MirrorTopicSwitchoverMetadata switchoverMetadata = (MirrorTopicSwitchoverMetadata)jsonOpt2.get("switchover_metadata").map((Function1<JsonValue, MirrorTopicSwitchoverMetadata> & Serializable)json -> MODULE$.switchoverMetadataFromJson((JsonValue)json)).getOrElse((Function0<MirrorTopicSwitchoverMetadata> & Serializable)() -> MirrorTopicSwitchoverMetadata.empty());
                return new ClusterLinkTopicState.PendingSetupForRestoreMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1(jsonOpt2), truncationEpochs, truncationOffsets, stoppedSequenceNumber, switchoverMetadata, timeMs);
            }
            if (TopicLinkPendingRestoreMirror$.MODULE$.equals(topicLinkState)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt(jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong(jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Seq mirrorStartOffsets = (Seq)jsonOpt2.apply("mirror_start_offsets").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Seq$.MODULE$.iterableFactory()));
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong(jsonOpt2.get("stopped_sequence_number").map((Function1<JsonValue, Object> & Serializable)x$24 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$fromJsonString$52(x$24))).getOrElse(() -> 0L));
                MirrorTopicSwitchoverMetadata switchoverMetadata = (MirrorTopicSwitchoverMetadata)jsonOpt2.get("switchover_metadata").map((Function1<JsonValue, MirrorTopicSwitchoverMetadata> & Serializable)json -> MODULE$.switchoverMetadataFromJson((JsonValue)json)).getOrElse((Function0<MirrorTopicSwitchoverMetadata> & Serializable)() -> MirrorTopicSwitchoverMetadata.empty());
                return new ClusterLinkTopicState.PendingRestoreMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1(jsonOpt2), mirrorStartOffsets, stoppedSequenceNumber, switchoverMetadata, timeMs);
            }
            ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt(jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
            long timeMs = BoxesRunTime.unboxToLong(jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
            String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
            UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
            long stoppedSequenceNumber = BoxesRunTime.unboxToLong(jsonOpt2.get("stopped_sequence_number").map((Function1<JsonValue, Object> & Serializable)x$25 -> BoxesRunTime.boxToLong(ClusterLinkTopicState$.$anonfun$fromJsonString$56(x$25))).getOrElse(() -> 0L));
            MirrorTopicSwitchoverMetadata switchoverMetadata = (MirrorTopicSwitchoverMetadata)jsonOpt2.get("switchover_metadata").map((Function1<JsonValue, MirrorTopicSwitchoverMetadata> & Serializable)json -> MODULE$.switchoverMetadataFromJson((JsonValue)json)).getOrElse((Function0<MirrorTopicSwitchoverMetadata> & Serializable)() -> MirrorTopicSwitchoverMetadata.empty());
            return new ClusterLinkTopicState.FailedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1(jsonOpt2), MirrorTopicError.UNSUPPORTED_MIRROR_STATE, stoppedSequenceNumber, switchoverMetadata, timeMs);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("Invalid topic state JSON: " + json2);
        }
        throw new MatchError(option);
    }

    public Option<Tuple2<String, String>> sourceTopicIdOption(Uuid sourceTopicId) {
        Uuid uuid = sourceTopicId;
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (!(uuid != null ? !uuid.equals(uuid2) : uuid2 != null)) {
            return None$.MODULE$;
        }
        return new Some<Tuple2<String, String>>(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("source_topic_id"), sourceTopicId.toString()));
    }

    public MirrorTopicError mirrorTopicError(JsonObject jsonOpt, boolean failed) {
        int persistedError = BoxesRunTime.unboxToInt(jsonOpt.get("mirror_topic_error").map((Function1<JsonValue, Object> & Serializable)x$26 -> BoxesRunTime.boxToInteger(ClusterLinkTopicState$.$anonfun$mirrorTopicError$1(x$26))).getOrElse(() -> MirrorTopicError.NOT_SET.code()));
        return MirrorTopicError.forCode((short)((short)persistedError), (boolean)failed);
    }

    public TopicLinkState topicLinkState(Option<String> persistedState, TopicLinkState defaultValue) {
        Option<String> option = persistedState;
        if (option instanceof Some) {
            TopicLinkState topicLinkState;
            Some some = (Some)option;
            String state = (String)some.value();
            try {
                topicLinkState = TopicLinkState$.MODULE$.fromString(state);
            }
            catch (Exception e) {
                topicLinkState = TopicLinkFailedMirror$.MODULE$;
            }
            return topicLinkState;
        }
        if (None$.MODULE$.equals(option)) {
            return defaultValue;
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasFailed(TopicLinkState state) {
        TopicLinkState topicLinkState = state;
        TopicLinkFailedMirror$ topicLinkFailedMirror$ = TopicLinkFailedMirror$.MODULE$;
        if (topicLinkState == null) {
            if (topicLinkFailedMirror$ == null) return true;
        } else if (topicLinkState.equals(topicLinkFailedMirror$)) return true;
        TopicLinkState topicLinkState2 = state;
        TopicLinkPendingRepairMirror$ topicLinkPendingRepairMirror$ = TopicLinkPendingRepairMirror$.MODULE$;
        if (topicLinkState2 != null) {
            if (!topicLinkState2.equals(topicLinkPendingRepairMirror$)) return false;
            return true;
        }
        if (topicLinkPendingRepairMirror$ == null) return true;
        return false;
    }

    public ClusterLinkTopicState apply(MirrorTopic mirrorTopic) {
        String linkName = mirrorTopic.linkName();
        MirrorTopic.State state = mirrorTopic.mirrorState();
        if (((Object)((Object)MirrorTopic.State.MIRROR)).equals((Object)state)) {
            Seq mirrorStartOffsets = mirrorTopic.mirrorStartOffsets() != null ? (Seq)CollectionConverters$.MODULE$.ListHasAsScala(mirrorTopic.mirrorStartOffsets()).asScala().map((Function1<Long, Object> & Serializable)x$27 -> BoxesRunTime.boxToLong(x$27)) : (Seq)Seq$.MODULE$.empty();
            return new ClusterLinkTopicState.Mirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), mirrorTopic.stoppedSequenceNumber(), mirrorTopic.switchoverMetadata(), mirrorTopic.timeMs(), mirrorStartOffsets);
        }
        if (((Object)((Object)MirrorTopic.State.PAUSED)).equals((Object)state)) {
            MirrorTopic.PausedMirrorTopic pausedMirror = (MirrorTopic.PausedMirrorTopic)mirrorTopic;
            Seq mirrorStartOffsets = pausedMirror.mirrorStartOffsets() != null ? (Seq)CollectionConverters$.MODULE$.ListHasAsScala(pausedMirror.mirrorStartOffsets()).asScala().map((Function1<Long, Object> & Serializable)x$28 -> BoxesRunTime.boxToLong(x$28)) : (Seq)Seq$.MODULE$.empty();
            TopicLinkState prevState = this.topicLinkState(new Some<String>(pausedMirror.prevToPausedState().stateName()), TopicLinkFailedMirror$.MODULE$);
            TopicLinkState pendingSynchronizeNextState = pausedMirror.pendingSynchronizeNextState() != null ? this.topicLinkState(new Some<String>(pausedMirror.pendingSynchronizeNextState().stateName()), null) : null;
            return new ClusterLinkTopicState.PausedMirror(linkName, mirrorTopic.linkId(), pausedMirror.sourceTopicId(), pausedMirror.linkLevel(), pausedMirror.topicLevel(), prevState, pendingSynchronizeNextState, MirrorTopicError.errorOrDefault((MirrorTopicError)pausedMirror.mirrorTopicError(), (boolean)this.hasFailed(prevState)), pausedMirror.stoppedSequenceNumber(), pausedMirror.switchoverMetadata(), pausedMirror.timeMs(), mirrorStartOffsets);
        }
        if (((Object)((Object)MirrorTopic.State.PENDING_STOPPED)).equals((Object)state)) {
            MirrorTopic.PendingStoppedMirrorTopic pendingStoppedMirror = (MirrorTopic.PendingStoppedMirrorTopic)mirrorTopic;
            return new ClusterLinkTopicState.PendingStoppedMirror(linkName, mirrorTopic.linkId(), pendingStoppedMirror.sourceTopicId(), pendingStoppedMirror.promoted(), pendingStoppedMirror.stoppedSequenceNumber(), pendingStoppedMirror.switchoverMetadata(), pendingStoppedMirror.timeMs());
        }
        if (((Object)((Object)MirrorTopic.State.STOPPED)).equals((Object)state)) {
            MirrorTopic.StoppedMirrorTopic stoppedMirror = (MirrorTopic.StoppedMirrorTopic)mirrorTopic;
            Seq stoppedLogEndOffsets = stoppedMirror.mirrorStoppedOffsets() != null ? CollectionConverters$.MODULE$.ListHasAsScala(stoppedMirror.mirrorStoppedOffsets()).asScala().toList().map((Function1<Long, Object> & Serializable)x$29 -> BoxesRunTime.boxToLong(Predef$.MODULE$.Long2long(x$29))) : (Seq)Seq$.MODULE$.empty();
            Seq stoppedEpochs = stoppedMirror.mirrorStoppedEpochs() != null ? (Seq)CollectionConverters$.MODULE$.ListHasAsScala(stoppedMirror.mirrorStoppedEpochs()).asScala().map((Function1<Integer, Object> & Serializable)x$30 -> BoxesRunTime.boxToInteger(x$30)) : (Seq)Seq$.MODULE$.empty();
            return new ClusterLinkTopicState.StoppedMirror(linkName, mirrorTopic.linkId(), stoppedMirror.sourceTopicId(), stoppedLogEndOffsets, stoppedEpochs, stoppedMirror.stoppedSequenceNumber(), stoppedMirror.switchoverMetadata(), stoppedMirror.timeMs());
        }
        if (((Object)((Object)MirrorTopic.State.FAILED)).equals((Object)state)) {
            return new ClusterLinkTopicState.FailedMirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), MirrorTopicError.errorOrDefault((MirrorTopicError)mirrorTopic.mirrorTopicError(), (boolean)true), mirrorTopic.stoppedSequenceNumber(), mirrorTopic.switchoverMetadata(), mirrorTopic.timeMs());
        }
        if (((Object)((Object)MirrorTopic.State.PENDING_MIRROR)).equals((Object)state)) {
            MirrorTopic.PendingMirrorTopic pendingMirror = (MirrorTopic.PendingMirrorTopic)mirrorTopic;
            return new ClusterLinkTopicState.PendingMirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), pendingMirror.nextState().stateName(), mirrorTopic.stoppedSequenceNumber(), mirrorTopic.switchoverMetadata(), mirrorTopic.timeMs());
        }
        if (((Object)((Object)MirrorTopic.State.PENDING_SYNCHRONIZE)).equals((Object)state)) {
            TopicLinkState remoteMirrorNextState;
            MirrorTopic.PendingSynchronizeMirrorTopic pendingSynchronizeMirror = (MirrorTopic.PendingSynchronizeMirrorTopic)mirrorTopic;
            if (pendingSynchronizeMirror.remoteMirrorNextState() == null) {
                throw new IllegalStateException("Null remote mirror next state found for PendingSynchronizeMirror");
            }
            TopicLinkState topicLinkState = remoteMirrorNextState = this.topicLinkState(Option$.MODULE$.apply(pendingSynchronizeMirror.remoteMirrorNextState().stateName()), TopicLinkFailedMirror$.MODULE$);
            TopicLinkMirror$ topicLinkMirror$ = TopicLinkMirror$.MODULE$;
            if (topicLinkState == null ? topicLinkMirror$ != null : !topicLinkState.equals(topicLinkMirror$)) {
                TopicLinkState topicLinkState2 = remoteMirrorNextState;
                TopicLinkPausedMirror$ topicLinkPausedMirror$ = TopicLinkPausedMirror$.MODULE$;
                if (topicLinkState2 == null ? topicLinkPausedMirror$ != null : !topicLinkState2.equals(topicLinkPausedMirror$)) {
                    throw new IllegalStateException("Found unsupported remote mirror next state for PendingSynchronizeMirror: " + remoteMirrorNextState);
                }
            }
            return new ClusterLinkTopicState.PendingSynchronizeMirror(linkName, mirrorTopic.linkId(), pendingSynchronizeMirror.sourceTopicId(), remoteMirrorNextState, pendingSynchronizeMirror.stoppedSequenceNumber(), pendingSynchronizeMirror.switchoverMetadata(), pendingSynchronizeMirror.timeMs());
        }
        if (((Object)((Object)MirrorTopic.State.PENDING_REPAIR)).equals((Object)state)) {
            return new ClusterLinkTopicState.PendingRepairMirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), MirrorTopicError.errorOrDefault((MirrorTopicError)mirrorTopic.mirrorTopicError(), (boolean)true), mirrorTopic.stoppedSequenceNumber(), mirrorTopic.switchoverMetadata(), mirrorTopic.timeMs());
        }
        if (((Object)((Object)MirrorTopic.State.PENDING_SETUP_FOR_RESTORE)).equals((Object)state)) {
            MirrorTopic.PendingSetupForRestoreMirrorTopic pendingSetupForRestoreMirror = (MirrorTopic.PendingSetupForRestoreMirrorTopic)mirrorTopic;
            if (pendingSetupForRestoreMirror.truncationOffsets() == null) {
                throw new IllegalStateException("Null truncation offsets found for PendingSetupForRestoreMirror");
            }
            if (pendingSetupForRestoreMirror.truncationEpochs() == null) {
                throw new IllegalStateException("Null truncation epochs found for PendingSetupForRestoreMirror");
            }
            return new ClusterLinkTopicState.PendingSetupForRestoreMirror(linkName, mirrorTopic.linkId(), pendingSetupForRestoreMirror.sourceTopicId(), (Seq)CollectionConverters$.MODULE$.ListHasAsScala(pendingSetupForRestoreMirror.truncationEpochs()).asScala().map((Function1<Integer, Object> & Serializable)x$31 -> BoxesRunTime.boxToInteger(x$31)), (Seq)CollectionConverters$.MODULE$.ListHasAsScala(pendingSetupForRestoreMirror.truncationOffsets()).asScala().map((Function1<Long, Object> & Serializable)x$32 -> BoxesRunTime.boxToLong(x$32)), pendingSetupForRestoreMirror.stoppedSequenceNumber(), pendingSetupForRestoreMirror.switchoverMetadata(), pendingSetupForRestoreMirror.timeMs());
        }
        if (((Object)((Object)MirrorTopic.State.PENDING_RESTORE)).equals((Object)state)) {
            MirrorTopic.PendingRestoreMirrorTopic pendingRestoreMirror = (MirrorTopic.PendingRestoreMirrorTopic)mirrorTopic;
            if (pendingRestoreMirror.mirrorStartOffsets() == null) {
                throw new IllegalStateException("Null mirror start offsets found for PendingRestoreMirror");
            }
            return new ClusterLinkTopicState.PendingRestoreMirror(linkName, mirrorTopic.linkId(), pendingRestoreMirror.sourceTopicId(), (Seq)CollectionConverters$.MODULE$.ListHasAsScala(pendingRestoreMirror.mirrorStartOffsets()).asScala().map((Function1<Long, Object> & Serializable)x$33 -> BoxesRunTime.boxToLong(x$33)), pendingRestoreMirror.stoppedSequenceNumber(), pendingRestoreMirror.switchoverMetadata(), pendingRestoreMirror.timeMs());
        }
        return new ClusterLinkTopicState.FailedMirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), MirrorTopicError.UNSUPPORTED_MIRROR_STATE, mirrorTopic.stoppedSequenceNumber(), mirrorTopic.switchoverMetadata(), mirrorTopic.timeMs());
    }

    public static final /* synthetic */ int $anonfun$switchoverMetadataFromJson$1(JsonValue x$2) {
        return BoxesRunTime.unboxToInt(x$2.to(DecodeJson$DecodeInt$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$switchoverMetadataFromJson$5(JsonValue x$4) {
        return BoxesRunTime.unboxToLong(x$4.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$fromJsonString$2(Tuple2 x$5) {
        return ((Option)x$5._2()).isDefined();
    }

    private static final void validateVersion$1(int expectedVersion, int actualVersion) {
        if (expectedVersion != actualVersion) {
            throw new IllegalStateException("Unexpected version '" + expectedVersion + "', actual version '" + actualVersion + "'");
        }
    }

    private static final Uuid sourceTopicId$1(JsonObject jsonOpt$1) {
        return (Uuid)jsonOpt$1.get("source_topic_id").map((Function1<JsonValue, String> & Serializable)x$7 -> x$7.to(DecodeJson$DecodeString$.MODULE$)).filter((Function1<String, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$8)))).map((Function1<String, Uuid> & Serializable)str -> Uuid.fromString((String)str)).getOrElse((Function0<Uuid> & Serializable)() -> Uuid.ZERO_UUID);
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$9(JsonValue x$10) {
        return BoxesRunTime.unboxToLong(x$10.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$17(JsonValue x$14) {
        return BoxesRunTime.unboxToLong(x$14.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$21(JsonValue x$15) {
        return BoxesRunTime.unboxToLong(x$15.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$25(JsonValue x$16) {
        return BoxesRunTime.unboxToLong(x$16.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$31(JsonValue x$18) {
        return BoxesRunTime.unboxToLong(x$18.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$35(JsonValue x$19) {
        return BoxesRunTime.unboxToLong(x$19.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$40(JsonValue x$21) {
        return BoxesRunTime.unboxToLong(x$21.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$44(JsonValue x$22) {
        return BoxesRunTime.unboxToLong(x$22.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$48(JsonValue x$23) {
        return BoxesRunTime.unboxToLong(x$23.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$52(JsonValue x$24) {
        return BoxesRunTime.unboxToLong(x$24.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$56(JsonValue x$25) {
        return BoxesRunTime.unboxToLong(x$25.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$mirrorTopicError$1(JsonValue x$26) {
        return BoxesRunTime.unboxToInt(x$26.to(DecodeJson$DecodeInt$.MODULE$));
    }

    private ClusterLinkTopicState$() {
    }
}

