/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.common.utils.ConfluentUtils;
import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.link.ClusterLinkUtils;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import kafka.server.KafkaConfig;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$Mirror$;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.GroupClusterLinkFilter;
import kafka.server.link.GroupClusterLinkFilterInfo;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicClusterLinkFilter;
import kafka.server.link.TopicFilterJson;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MirrorTopicSwitchoverMetadata;
import org.apache.kafka.metadata.TopicType;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkUtils$
implements Logging {
    public static final ClusterLinkUtils$ MODULE$ = new ClusterLinkUtils$();
    private static final Set<Object> ConfluentCloudInternalPorts;
    private static final int MaxCreateClusterLinksTimeoutMs;
    private static final String MirrorTopicCreationReadAccessErrMsg;
    private static final String MirrorTopicCreationAccessNotKnownErrMsg;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        ConfluentCloudInternalPorts = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9071, 9072, 9073, 9074, 9075, 9076, 9080, 8090}));
        MaxCreateClusterLinksTimeoutMs = 300000;
        MirrorTopicCreationReadAccessErrMsg = "Mirror topic creation requires READ access on the source topic.";
        MirrorTopicCreationAccessNotKnownErrMsg = "Mirror topic creation failed because access on the source topic is not known.";
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkUtils$ clusterLinkUtils$ = this;
        synchronized (clusterLinkUtils$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Set<Object> ConfluentCloudInternalPorts() {
        return ConfluentCloudInternalPorts;
    }

    private int MaxCreateClusterLinksTimeoutMs() {
        return MaxCreateClusterLinksTimeoutMs;
    }

    public String MirrorTopicCreationReadAccessErrMsg() {
        return MirrorTopicCreationReadAccessErrMsg;
    }

    public String MirrorTopicCreationAccessNotKnownErrMsg() {
        return MirrorTopicCreationAccessNotKnownErrMsg;
    }

    public void validateLinkName(String linkName) {
        ClusterLinkUtils.validateLinkNameOrThrow(linkName);
    }

    public Endpoint linkListenerEndpoint(Option<String> tenantPrefix, ClusterLinkConfig config, AuthorizerServerInfo serverInfo, Map<String, String> localReverseConnectionListenerMap) {
        String localListenerName = tenantPrefix.isEmpty() ? config.localListenerName() : this.mapRequestListenerToLocalAdminListener(config.localListenerName(), localReverseConnectionListenerMap);
        Endpoint linkListenerEndpoint = serverInfo.endpoints().stream().filter(x$1 -> {
            Optional optional = x$1.listenerName();
            Optional<String> optional2 = Optional.of(localListenerName);
            return !(optional != null ? !((Object)optional).equals(optional2) : optional2 != null);
        }).findFirst().orElseThrow(() -> new InvalidRequestException("Listener " + localListenerName + " not found"));
        return linkListenerEndpoint;
    }

    public String mapRequestListenerToLocalAdminListener(String requestListenerName, Map<String, String> localReverseConnectionListenerMap) {
        Option mappedListenerName = localReverseConnectionListenerMap.get(requestListenerName);
        Option option = mappedListenerName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String listenerName = (String)some.value();
            return listenerName;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("Failed to find mapped listener name for " + requestListenerName);
        }
        throw new MatchError(option);
    }

    public Option<InvalidRequestException> checkTimeoutMs(int timeoutMs) {
        if (timeoutMs > this.MaxCreateClusterLinksTimeoutMs()) {
            return new Some<InvalidRequestException>(new InvalidRequestException(String.format("Timeout of %d(ms) is above maximum allowed of %d(ms).", BoxesRunTime.boxToInteger(timeoutMs), BoxesRunTime.boxToInteger(this.MaxCreateClusterLinksTimeoutMs()))));
        }
        return None$.MODULE$;
    }

    public String logicalCluster(String tenantPrefix) {
        return tenantPrefix.substring(0, tenantPrefix.length() - 1);
    }

    public String environmentId(Option<String> tenant, Option<MultiTenantMetadata> multiTenantMetadata) {
        String string;
        Option<LogicalClusterMetadata> logicalClusterMetadata = this.lkcMetadata(tenant, multiTenantMetadata);
        Option<LogicalClusterMetadata> option = logicalClusterMetadata;
        if (option instanceof Some) {
            Some some = (Some)option;
            LogicalClusterMetadata lkcMetadata = (LogicalClusterMetadata)some.value();
            if (lkcMetadata == null) {
                this.debug((Function0<String> & Serializable)() -> "Lkc metadata is null");
                string = "";
            } else {
                string = lkcMetadata.environmentId();
            }
        } else if (None$.MODULE$.equals(option)) {
            this.debug((Function0<String> & Serializable)() -> "Lkc metadata is not available");
            string = "";
        } else {
            throw new MatchError(option);
        }
        String environmentId = string;
        return environmentId;
    }

    public Option<String> orgId(Option<String> tenant, Option<MultiTenantMetadata> multiTenantMetadata) {
        Option option;
        Option<LogicalClusterMetadata> logicalClusterMetadata = this.lkcMetadata(tenant, multiTenantMetadata);
        Option<LogicalClusterMetadata> option2 = logicalClusterMetadata;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            LogicalClusterMetadata lkcMetadata = (LogicalClusterMetadata)some.value();
            if (lkcMetadata == null) {
                this.debug((Function0<String> & Serializable)() -> "Lkc metadata is null");
                option = None$.MODULE$;
            } else {
                option = new Some<String>(lkcMetadata.organizationId());
            }
        } else if (None$.MODULE$.equals(option2)) {
            this.debug((Function0<String> & Serializable)() -> "Lkc metadata is not available");
            option = None$.MODULE$;
        } else {
            throw new MatchError(option2);
        }
        Option orgId = option;
        return orgId;
    }

    private Option<LogicalClusterMetadata> lkcMetadata(Option<String> tenant, Option<MultiTenantMetadata> multiTenantMetadata) {
        boolean ready = multiTenantMetadata.exists((Function1<MultiTenantMetadata, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.isUp()));
        this.debug((Function0<String> & Serializable)() -> "multiTenantMetadata is ready " + ready);
        if (ready) {
            return multiTenantMetadata.map((Function1<MultiTenantMetadata, LogicalClusterMetadata> & Serializable)x$3 -> x$3.metadata((String)tenant.getOrElse((Function0<String> & Serializable)() -> "")));
        }
        return None$.MODULE$;
    }

    public ClusterLinkUtils.ResolveCreateTopic resolveCreateTopic(CreateTopicsRequestData.CreatableTopic topic, Option<Uuid> linkId, Properties configs, boolean validateOnly, Option<ClusterLinkConfig> linkConfig, Option<CompletableFuture<ClusterLinkTopicInfo>> topicInfo, String tenantPrefix) {
        Option<String> mirrorTopic = Option$.MODULE$.apply(topic.mirrorTopic());
        Option<String> option = Option$.MODULE$.apply(topic.linkName());
        if (option instanceof Some) {
            Some some = (Some)option;
            String linkName = (String)some.value();
            this.validateLinkName(linkName);
            Option<String> option2 = mirrorTopic;
            if (option2 instanceof Some) {
                String unprefixedSourceTopicName;
                Some some2 = (Some)option2;
                String mt = (String)some2.value();
                String withoutTenantPrefixTopicName = topic.name().substring(tenantPrefix.length());
                Option clusterLinkPrefix = linkConfig.flatMap((Function1<ClusterLinkConfig, Option> & Serializable)x$4 -> x$4.clusterLinkPrefix());
                clusterLinkPrefix.foreach((Function1<String, Object> & Serializable)linkPrefix -> {
                    ClusterLinkUtils$.$anonfun$resolveCreateTopic$2(withoutTenantPrefixTopicName, linkPrefix);
                    return BoxedUnit.UNIT;
                });
                int clusterLinkPrefixLength = ((String)clusterLinkPrefix.getOrElse((Function0<String> & Serializable)() -> "")).length();
                String unprefixedTopicName = withoutTenantPrefixTopicName.substring(clusterLinkPrefixLength);
                String string = unprefixedSourceTopicName = mt.substring(tenantPrefix.length());
                String string2 = unprefixedTopicName;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    String expectedMirrorName = (String)clusterLinkPrefix.getOrElse((Function0<String> & Serializable)() -> "") + unprefixedSourceTopicName;
                    if (clusterLinkPrefix.isDefined()) {
                        throw new UnsupportedVersionException("Renaming the topic suffix, after the prefix, for mirroring not yet supported. Expected mirror name: " + expectedMirrorName);
                    }
                    throw new UnsupportedVersionException("Topic renaming for mirroring not yet supported. Expected mirror name: " + expectedMirrorName);
                }
            } else {
                if (None$.MODULE$.equals(option2)) {
                    throw new InvalidRequestException("Mirror topic not set.");
                }
                throw new MatchError(option2);
            }
            if (topic.numPartitions() != -1) {
                throw new InvalidRequestException("Cannot specify both mirror topic and number of partitions.");
            }
            if (!topic.assignments().isEmpty()) {
                throw new InvalidRequestException("Cannot specify both mirror topic and partition assignments.");
            }
            if (linkId.isEmpty()) {
                throw new ClusterLinkNotFoundException("Cluster link with name '" + topic.linkName() + "' does not exist.");
            }
            Option<ClusterLinkConfig> option3 = linkConfig;
            if (option3 instanceof Some) {
                Some some3 = (Some)option3;
                ClusterLinkConfig config = (ClusterLinkConfig)some3.value();
                MirrorTopicConfigSyncRules topicConfigSyncRules = config.topicConfigSyncRules();
                topicConfigSyncRules.validateMirrorPropsForTopicCreation(topic.name(), configs);
                Option<CompletableFuture<ClusterLinkTopicInfo>> option4 = topicInfo;
                if (option4 instanceof Some) {
                    ClusterLinkTopicInfo clusterLinkTopicInfo;
                    Some some4 = (Some)option4;
                    CompletableFuture ti = (CompletableFuture)some4.value();
                    try {
                        if (!ti.isDone()) {
                            throw new IllegalStateException("Mirror information must have been resolved.");
                        }
                        clusterLinkTopicInfo = (ClusterLinkTopicInfo)ti.get();
                    }
                    catch (ExecutionException e) {
                        throw e.getCause();
                    }
                    catch (TimeoutException e) {
                        this.error((Function0<String> & Serializable)() -> "Received timeout exception while fetching topic information over cluster link", (Function0<Throwable>)(Function0<TimeoutException> & Serializable)() -> e);
                        throw new TimeoutException("Timed out while fetching topic information over cluster link '" + linkName + "'.", (Throwable)e);
                    }
                    ClusterLinkTopicInfo info = clusterLinkTopicInfo;
                    if (info.description().authorizedOperations() == null) {
                        throw new TopicAuthorizationException(this.MirrorTopicCreationAccessNotKnownErrMsg());
                    }
                    if (!info.description().authorizedOperations().contains(AclOperation.READ)) {
                        throw new TopicAuthorizationException(this.MirrorTopicCreationReadAccessErrMsg());
                    }
                    ConfigEntry topicType = info.config().get("confluent.topic.type");
                    if (topicType != null && topicType.value().equals(TopicType.VIRTUAL.logConfigValue())) {
                        throw new InvalidConfigurationException("Cannot mirror topic '" + topic.name() + "' because it is a VIRTUAL topic.");
                    }
                    Properties newConfigs = new MirrorTopicConfigsDelegate(configs, info.config(), topicConfigSyncRules).initMirrorProps(topic.name());
                    String x$1 = linkName;
                    Uuid x$2 = linkId.get();
                    Uuid x$3 = info.description().topicId();
                    Seq<Object> x$42 = info.mirrorStartOffsets();
                    long x$5 = info.stoppedSequenceNumber();
                    MirrorTopicSwitchoverMetadata x$6 = MirrorTopicSwitchoverMetadata.empty();
                    long x$7 = ClusterLinkTopicState$Mirror$.MODULE$.apply$default$6();
                    return new ClusterLinkUtils.ResolveCreateTopic(newConfigs, new Some<ClusterLinkTopicState>(new ClusterLinkTopicState.Mirror(x$1, x$2, x$3, x$5, x$6, x$7, x$42)), info.description().partitions().size());
                }
                if (None$.MODULE$.equals(option4)) {
                    if (!validateOnly) {
                        throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
                    }
                    return new ClusterLinkUtils.ResolveCreateTopic(configs, None$.MODULE$, -1);
                }
                throw new MatchError(option4);
            }
            if (None$.MODULE$.equals(option3)) {
                throw new InvalidRequestException("Cannot create mirror topic, cluster link " + linkName + " is in a FAILED state");
            }
            throw new MatchError(option3);
        }
        if (None$.MODULE$.equals(option)) {
            if (mirrorTopic.nonEmpty()) {
                throw new InvalidRequestException("Cannot create mirror topic, cluster link name not specified.");
            }
            return new ClusterLinkUtils.ResolveCreateTopic(configs, None$.MODULE$, -1);
        }
        throw new MatchError(option);
    }

    public String resolveCreateTopic$default$7() {
        return "";
    }

    public void validateCreatePartitions(String topic, int numPartitions, boolean validateOnly, Option<CompletableFuture<Object>> partitions) {
        Option<CompletableFuture<Object>> option = partitions;
        if (option instanceof Some) {
            int n;
            Some some = (Some)option;
            CompletableFuture parts = (CompletableFuture)some.value();
            try {
                if (!parts.isDone()) {
                    throw new IllegalStateException("Mirror partitions must have been resolved.");
                }
                n = BoxesRunTime.unboxToInt(parts.get());
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            catch (TimeoutException timeoutException) {
                throw new TimeoutException("Timed out while fetching topic partitions over cluster link.");
            }
            int mirrorNumPartitions = n;
            if (mirrorNumPartitions < numPartitions) {
                throw new InvalidPartitionsException("Cannot set '" + numPartitions + "' partitions for topic '" + topic + "', exceeds linked topic's '" + mirrorNumPartitions + "' partitions.");
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (!validateOnly) {
                throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
            }
            return;
        }
        throw new MatchError(option);
    }

    public scala.collection.immutable.Seq<ClusterLinkFilterInfo> clusterLinkTopicFilters(Option<TopicFilterJson> filters, Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        return (scala.collection.immutable.Seq)((IterableOps)filters.map((Function1<TopicFilterJson, scala.collection.immutable.Seq> & Serializable)x$5 -> x$5.filters()).getOrElse((Function0<scala.collection.immutable.Seq> & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1<TopicClusterLinkFilter, ClusterLinkFilterInfo> & Serializable)filter -> MODULE$.clusterLinkFilter((ClusterLinkFilter)filter, MODULE$.tenantAndClusterLinkPrefix(tenantPrefix, clusterLinkPrefix)));
    }

    public scala.collection.immutable.Seq<GroupClusterLinkFilterInfo> clusterLinkGroupFilters(Option<GroupFilterJson> filters, Option<String> tenantPrefix, Option<String> clusterLinkPrefix, ClusterLinkConfig.LinkMode linkMode) {
        return (scala.collection.immutable.Seq)((IterableOps)filters.map((Function1<GroupFilterJson, scala.collection.immutable.Seq> & Serializable)x$6 -> x$6.filters()).getOrElse((Function0<scala.collection.immutable.Seq> & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1<GroupClusterLinkFilter, GroupClusterLinkFilterInfo> & Serializable)filter -> {
            ClusterLinkFilterInfo clFilter = MODULE$.clusterLinkFilter((ClusterLinkFilter)filter, MODULE$.tenantAndClusterLinkPrefix(tenantPrefix, clusterLinkPrefix));
            return new GroupClusterLinkFilterInfo(clFilter, filter.effectiveTopicTypes(linkMode));
        });
    }

    private String tenantAndClusterLinkPrefix(Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        return (String)tenantPrefix.getOrElse((Function0<String> & Serializable)() -> "") + clusterLinkPrefix.getOrElse((Function0<String> & Serializable)() -> "");
    }

    private ClusterLinkFilterInfo clusterLinkFilter(ClusterLinkFilter filter, String prefix) {
        PatternType patternType = SecurityUtils.patternType((String)filter.patternType());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(prefix))) {
            PatternType patternType2 = patternType;
            if (PatternType.LITERAL.equals(patternType2)) {
                String string = filter.name();
                String string2 = "*";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    PatternType patternType3 = patternType;
                    PatternType patternType4 = PatternType.LITERAL;
                    if (!(patternType3 != null ? !patternType3.equals(patternType4) : patternType4 != null)) {
                        return new ClusterLinkFilterInfo(prefix, PatternType.PREFIXED, filter.filterType(), filter);
                    }
                }
                return new ClusterLinkFilterInfo(prefix + filter.name(), patternType, filter.filterType(), filter);
            }
            if (PatternType.PREFIXED.equals(patternType2)) {
                return new ClusterLinkFilterInfo(prefix + filter.name(), patternType, filter.filterType(), filter);
            }
            throw new IllegalStateException("Unexpected pattern type " + filter.patternType());
        }
        return new ClusterLinkFilterInfo(filter.name(), patternType, filter.filterType(), filter);
    }

    public Properties restrictValidateTopicConfigPolicy(String topic, Properties props, Option<AlterConfigPolicy> policy) {
        Option<AlterConfigPolicy> option = policy;
        if (option instanceof Some) {
            Some some = (Some)option;
            AlterConfigPolicy pol = (AlterConfigPolicy)some.value();
            java.util.Map configs = Utils.propsToStringMap((Properties)props);
            AlterConfigPolicy alterConfigPolicy = pol;
            if (alterConfigPolicy instanceof ClusterLinkAlterConfigPolicy) {
                ClusterLinkAlterConfigPolicy clusterLinkAlterConfigPolicy = (ClusterLinkAlterConfigPolicy)alterConfigPolicy;
                java.util.Map<String, String> newConfigs = clusterLinkAlterConfigPolicy.clusterLinkRestrictTopicConfigs(configs);
                clusterLinkAlterConfigPolicy.clusterLinkValidateTopicConfigs(newConfigs);
                return Utils.mkProperties(newConfigs);
            }
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
            pol.validate(new AlterConfigPolicy.RequestMetadata(resource, configs));
            return props;
        }
        if (None$.MODULE$.equals(option)) {
            return props;
        }
        throw new MatchError(option);
    }

    public Tuple2<Option<Errors>, Option<Function1<String, Object>>> canHandleDescribeClusterLinksRequest(short version, KafkaConfig config, ClusterLinkFactory.AdminManager adminManager, Option<Set<String>> linkNames) {
        if (version <= 3) {
            return new Tuple2<Option<Errors>, Option<Function1<String, Object>>>(None$.MODULE$, new Some<Function1<String, Object> & Serializable>((Function1<String, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(ClusterLinkUtils$.$anonfun$canHandleDescribeClusterLinksRequest$1(x$7))));
        }
        Option<ClusterLinkMetadataManager> option = adminManager.clusterLinkManager().clusterLinkMetadataManager();
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterLinkMetadataManager mm = (ClusterLinkMetadataManager)some.value();
            if (mm.isLinkCoordinatorEnabled() && !mm.isLinkCoordinatorInitialized()) {
                return new Tuple2<Option<Errors>, Option<Function1<String, Object>>>(new Some<Errors>(Errors.COORDINATOR_LOAD_IN_PROGRESS), None$.MODULE$);
            }
            Option<Set<String>> option2 = linkNames;
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Set lns = (Set)some2.value();
                if (lns.forall((Function1<String, Object> & Serializable)name -> BoxesRunTime.boxToBoolean(mm.isLinkCoordinator(name)))) {
                    return new Tuple2<Option<Errors>, Option<Function1<String, Object>>>(None$.MODULE$, new Some<Function1<String, Object> & Serializable>((Function1<String, Object> & Serializable)linkName -> BoxesRunTime.boxToBoolean(mm.isLinkCoordinator(linkName))));
                }
                return new Tuple2<Option<Errors>, Option<Function1<String, Object>>>(new Some<Errors>(Errors.NOT_COORDINATOR), None$.MODULE$);
            }
            if (None$.MODULE$.equals(option2)) {
                return new Tuple2<Option<Errors>, Option<Function1<String, Object>>>(None$.MODULE$, new Some<Function1<String, Object> & Serializable>((Function1<String, Object> & Serializable)linkName -> BoxesRunTime.boxToBoolean(mm.isLinkCoordinator(linkName))));
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return new Tuple2<Option<Errors>, Option<Function1<String, Object>>>(new Some<Errors>(Errors.COORDINATOR_LOAD_IN_PROGRESS), None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public Option<Errors> canHandleDescribeMirrorsRequest(ClusterLinkFactory.AdminManager adminManager, Set<String> mirrorTopics) {
        Option<ClusterLinkMetadataManager> option = adminManager.clusterLinkManager().clusterLinkMetadataManager();
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterLinkMetadataManager mm = (ClusterLinkMetadataManager)some.value();
            if (mm.isLinkCoordinatorEnabled() && !mm.isLinkCoordinatorInitialized()) {
                return new Some<Errors>(Errors.COORDINATOR_LOAD_IN_PROGRESS);
            }
            if (mirrorTopics.forall((Function1<String, Object> & Serializable)topic -> BoxesRunTime.boxToBoolean(mm.isLinkCoordinatorForMirrorTopic(topic)))) {
                return None$.MODULE$;
            }
            return new Some<Errors>(Errors.NOT_COORDINATOR);
        }
        if (None$.MODULE$.equals(option)) {
            return new Some<Errors>(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        throw new MatchError(option);
    }

    public Option<Errors> canHandleReportClusterLinkStatusRequest(ClusterLinkFactory.AdminManager adminManager, Option<Set<String>> linkNames) {
        Option<ClusterLinkMetadataManager> option = adminManager.clusterLinkManager().clusterLinkMetadataManager();
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterLinkMetadataManager mm = (ClusterLinkMetadataManager)some.value();
            if (mm.isLinkCoordinatorEnabled() && !mm.isLinkCoordinatorInitialized()) {
                return new Some<Errors>(Errors.COORDINATOR_LOAD_IN_PROGRESS);
            }
            if (((IterableOnceOps)linkNames.get()).forall((Function1<String, Object> & Serializable)name -> BoxesRunTime.boxToBoolean(mm.isLinkCoordinator(name)))) {
                return None$.MODULE$;
            }
            return new Some<Errors>(Errors.NOT_COORDINATOR);
        }
        if (None$.MODULE$.equals(option)) {
            return new Some<Errors>(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        throw new MatchError(option);
    }

    public void validateMirrorTopicConfig(String topic, Set<String> configKeys, ClusterLinkFactory.LinkManager clusterLinkManager, boolean isIncremental) {
        clusterLinkManager.clusterLinkMetadataManager().foreach((Function1<ClusterLinkMetadataManager, Object> & Serializable)metadataManager -> {
            ClusterLinkUtils$.$anonfun$validateMirrorTopicConfig$1(topic, isIncremental, clusterLinkManager, configKeys, metadataManager);
            return BoxedUnit.UNIT;
        });
    }

    public Throwable taskExceptionCauseOrException(Throwable throwable) {
        KafkaException kafkaException;
        Throwable throwable2 = throwable;
        if (throwable2 instanceof ExecutionException ? true : throwable2 instanceof CompletionException) {
            return throwable2.getCause();
        }
        if (throwable2 instanceof ApiException) {
            ApiException apiException = (ApiException)throwable2;
            return apiException;
        }
        if (throwable2 instanceof KafkaException && (kafkaException = (KafkaException)throwable2).getCause() != null && kafkaException.getCause() instanceof ApiException) {
            return kafkaException.getCause();
        }
        return throwable;
    }

    /*
     * Unable to fully structure code
     */
    public ApiException apiException(Throwable throwable, String message) {
        e = this.taskExceptionCauseOrException(throwable);
        v0 = err = Errors.forException((Throwable)e);
        var8_5 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v0 == null ? var8_5 != null : v0.equals(var8_5) == false)) ** GOTO lbl-1000
        v1 = err.message();
        var9_6 = e.getMessage();
        if (!(v1 != null ? v1.equals(var9_6) == false : var9_6 != null)) lbl-1000:
        // 2 sources

        {
            v2 = null;
        } else {
            rootCause = e;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            v2 = rootCause == e ? e.getMessage() : e.getMessage() + ", root cause: " + rootCause;
        }
        errMessage = v2;
        apiError = ObjectRef.create(new ApiError(err, errMessage));
        v3 = ((ApiError)apiError.elem).error();
        var12_10 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v3 != null ? v3.equals(var12_10) == false : var12_10 != null)) {
            if (e instanceof AuthenticationException) {
                apiError.elem = new ApiError(Errors.INVALID_CONFIG, e.getMessage());
            } else if (e instanceof ConfigException) {
                apiError.elem = new ApiError(Errors.INVALID_CONFIG, e.getMessage());
            }
        }
        errorMessage = message + " due to error: " + ((ApiError)apiError.elem).messageWithFallback();
        v4 = ((ApiError)apiError.elem).error();
        var14_12 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v4 != null ? v4.equals(var14_12) == false : var14_12 != null)) {
            this.error((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$apiException$1(java.lang.String ), ()Ljava/lang/String;)((String)errorMessage), (Function0<Throwable> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$apiException$2(java.lang.Throwable ), ()Ljava/lang/Throwable;)((Throwable)e));
        } else {
            this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$apiException$3(java.lang.String ), ()Ljava/lang/String;)((String)errorMessage), (Function0<Throwable> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$apiException$4(java.lang.Throwable ), ()Ljava/lang/Throwable;)((Throwable)e));
        }
        var15_13 = ((ApiError)apiError.elem).exception();
        if (var15_13 instanceof InvalidClusterLinkException) {
            var16_14 = e;
            if (var16_14 instanceof InvalidClusterLinkException) {
                var17_15 = (InvalidClusterLinkException)var16_14;
                return new InvalidClusterLinkException(var17_15.clusterLinkError(), var17_15.linkErrorMessage(), errorMessage);
            }
            this.warn((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$apiException$5(scala.runtime.ObjectRef java.lang.Throwable ), ()Ljava/lang/String;)(apiError, (Throwable)e));
            return ((ApiError)apiError.elem).error().exception(errorMessage);
        }
        return ((ApiError)apiError.elem).error().exception(errorMessage);
    }

    public Tuple2<Set<String>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilterTopics(Set<String> toFilter, Option<TopicFilterJson> filterJsonObject, Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        scala.collection.immutable.Seq<ClusterLinkFilterInfo> filters = this.clusterLinkTopicFilters(filterJsonObject, tenantPrefix, clusterLinkPrefix);
        return this.doFilterTopics(toFilter, filters);
    }

    public Tuple2<Set<MatchedGroup>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilterGroups(Set<String> toFilter, Option<GroupFilterJson> filterJsonObject, Option<String> tenantPrefix, Option<String> clusterLinkPrefix, ClusterLinkConfig.LinkMode linkMode) {
        scala.collection.immutable.Seq<GroupClusterLinkFilterInfo> filters = this.clusterLinkGroupFilters(filterJsonObject, tenantPrefix, clusterLinkPrefix, linkMode);
        return this.doFilterGroups(toFilter, filters);
    }

    public Tuple2<Set<String>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilterTopics(Set<String> toFilter, scala.collection.immutable.Seq<ClusterLinkFilterInfo> filters) {
        Buffer usedFilters = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Set filtered = (Set)toFilter.filter((Function1<String, Object> & Serializable)item -> BoxesRunTime.boxToBoolean(ClusterLinkUtils$.$anonfun$doFilterTopics$1(filters, usedFilters, item)));
        return new Tuple2<Set<String>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>>(filtered, (scala.collection.immutable.Seq<ClusterLinkFilterInfo>)filters.diff(usedFilters));
    }

    public Tuple2<Set<MatchedGroup>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilterGroups(Set<String> groups, scala.collection.immutable.Seq<GroupClusterLinkFilterInfo> filters) {
        Buffer usedFilters = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Set filtered = (Set)groups.flatMap((Function1<String, Option> & Serializable)group -> {
            scala.collection.immutable.Seq matchedFilters = (scala.collection.immutable.Seq)filters.filter((Function1<GroupClusterLinkFilterInfo, Object> & Serializable)x$11 -> BoxesRunTime.boxToBoolean(ClusterLinkUtils$.$anonfun$doFilterGroups$2(group, x$11)));
            if (matchedFilters.isEmpty()) {
                return None$.MODULE$;
            }
            usedFilters.$plus$plus$eq((IterableOnce)matchedFilters.map((Function1<GroupClusterLinkFilterInfo, ClusterLinkFilterInfo> & Serializable)x$12 -> x$12.filterInfo()));
            scala.collection.immutable.Seq includeFilters = (scala.collection.immutable.Seq)matchedFilters.filter((Function1<GroupClusterLinkFilterInfo, Object> & Serializable)x$13 -> BoxesRunTime.boxToBoolean(ClusterLinkUtils$.$anonfun$doFilterGroups$4(x$13)));
            Set includeTopicTypes = ((IterableOnceOps)includeFilters.flatMap((Function1<GroupClusterLinkFilterInfo, scala.collection.immutable.Seq> & Serializable)x$14 -> x$14.topicTypes())).toSet();
            scala.collection.immutable.Seq excludeFilters = (scala.collection.immutable.Seq)matchedFilters.filter((Function1<GroupClusterLinkFilterInfo, Object> & Serializable)x$15 -> BoxesRunTime.boxToBoolean(ClusterLinkUtils$.$anonfun$doFilterGroups$6(x$15)));
            Set excludeTopicTypes = ((IterableOnceOps)excludeFilters.flatMap((Function1<GroupClusterLinkFilterInfo, scala.collection.immutable.Seq> & Serializable)x$16 -> x$16.topicTypes())).toSet();
            Set topicTypes = (Set)includeTopicTypes.diff(excludeTopicTypes);
            if (!topicTypes.isEmpty()) {
                return new Some<MatchedGroup>(new MatchedGroup((String)group, topicTypes));
            }
            return None$.MODULE$;
        });
        return new Tuple2<Set<MatchedGroup>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>>(filtered, (scala.collection.immutable.Seq<ClusterLinkFilterInfo>)((SeqOps)filters.map((Function1<GroupClusterLinkFilterInfo, ClusterLinkFilterInfo> & Serializable)x$17 -> x$17.filterInfo())).diff(usedFilters));
    }

    public ClusterLinkConfig.LinkMode doFilterGroups$default$5() {
        return ClusterLinkConfig.LinkMode.DESTINATION;
    }

    public boolean isInternalNetworkOrPort(InetSocketAddress socketAddress) {
        return this.ConfluentCloudInternalPorts().contains(BoxesRunTime.boxToInteger(socketAddress.getPort())) && (socketAddress.getAddress().isSiteLocalAddress() || socketAddress.getAddress().isLoopbackAddress());
    }

    public boolean isCCloudIntranetHost(java.util.Map<String, ?> brokerConfigs, String host) {
        return ConfluentUtils.hasCCloudIntranetHostPattern(brokerConfigs, host);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOutboundBootstrapCCloudHost(java.util.Map<String, ?> brokerConfigs, ConnectionMode connectionMode, List<String> bootstrapServers) {
        Option firstHost = ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(bootstrapServers).asScala().filter((Function1<String, Object> & Serializable)bootstrap -> BoxesRunTime.boxToBoolean(ClusterLinkUtils$.$anonfun$isOutboundBootstrapCCloudHost$1(bootstrap)))).map((Function1<String, String> & Serializable)bootstrap -> Utils.getHost((String)bootstrap))).headOption();
        Option option = firstHost;
        if (option instanceof Some) {
            Some some = (Some)option;
            String host = (String)some.value();
            ConnectionMode connectionMode2 = connectionMode;
            ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
            if (connectionMode2 == null) {
                if (connectionMode$Outbound$ != null) {
                    return false;
                }
            } else if (!connectionMode2.equals(connectionMode$Outbound$)) return false;
            if (host == null) return false;
            if (!ConfluentUtils.hasCCloudHostPattern(brokerConfigs, host)) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return false;
    }

    public boolean isRetriableFailure(Throwable cause) {
        Throwable throwable = cause;
        if (throwable instanceof RetriableException) {
            return true;
        }
        if (throwable instanceof ConfigException) {
            String namingMessage = cause.getMessage();
            if (namingMessage == null) {
                return false;
            }
            return namingMessage.startsWith("No resolvable bootstrap urls");
        }
        return false;
    }

    public OffsetSpec toOffsetSpec(long timestamp, OffsetSpec defaultSpec) {
        long l = timestamp;
        if (Long.MIN_VALUE == l) {
            return defaultSpec;
        }
        if (l >= 0L) {
            return OffsetSpec.forTimestamp((long)l);
        }
        if (-2L == l) {
            return OffsetSpec.earliest();
        }
        if (-1L == l) {
            return OffsetSpec.latest();
        }
        if (-3L == l) {
            throw new InvalidConfigurationException("Mirroring from max timestamp is not supported.");
        }
        throw new InvalidConfigurationException("Unsupported start offset spec for mirroring: " + timestamp + ".");
    }

    public boolean isAuthenticationException(KafkaException kafkaException) {
        return kafkaException instanceof AuthenticationException || kafkaException.getCause() != null && kafkaException.getCause() instanceof AuthenticationException;
    }

    public TaskErrorCodeAndMsg taskErrorCodeAndMsg(String errMsgPrefix, boolean localAdminUsed, ExecutionException ex) {
        KafkaException kafkaException;
        Throwable throwable = ex.getCause();
        if (throwable instanceof KafkaException && this.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
            TaskErrorCode errCode = localAdminUsed ? BrokerAuthenticationTaskErrorCode$.MODULE$ : AuthenticationTaskErrorCode$.MODULE$;
            return new TaskErrorCodeAndMsg(errCode, errMsgPrefix + " due to authentication issues.");
        }
        if (throwable instanceof AuthorizationException) {
            TaskErrorCode errCode = localAdminUsed ? BrokerAuthorizationTaskErrorCode$.MODULE$ : AuthorizationTaskErrorCode$.MODULE$;
            return new TaskErrorCodeAndMsg(errCode, errMsgPrefix + " due to authorization issues.");
        }
        return new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsgPrefix + " for an unknown reason.");
    }

    public static final /* synthetic */ void $anonfun$resolveCreateTopic$2(String withoutTenantPrefixTopicName$1, String linkPrefix) {
        if (!withoutTenantPrefixTopicName$1.startsWith(linkPrefix)) {
            throw new InvalidConfigurationException("Mirror topic name should start with cluster link prefix " + linkPrefix + ".");
        }
    }

    public static final /* synthetic */ boolean $anonfun$canHandleDescribeClusterLinksRequest$1(String x$7) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$validateMirrorTopicConfig$1(String topic$1, boolean isIncremental$1, ClusterLinkFactory.LinkManager clusterLinkManager$1, Set configKeys$1, ClusterLinkMetadataManager metadataManager) {
        if (metadataManager.hasTopic(topic$1)) {
            Option clusterLinkTopicState = metadataManager.mirrorTopicStatesFromMetadataStore((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).get(topic$1);
            if (clusterLinkTopicState.exists((Function1<ClusterLinkTopicState, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(x$8.mirrorIsEstablished()))) {
                if (!isIncremental$1) {
                    throw new InvalidRequestException("Non-incremental configuration updates for mirror topic '" + topic$1 + "' are disallowed");
                }
                Uuid linkId = ((ClusterLinkTopicState)clusterLinkTopicState.get()).linkId();
                Option<ClusterLinkConfig> linkConfig = clusterLinkManager$1.linkConfig(linkId);
                if (linkConfig.isEmpty()) {
                    throw new ClusterLinkNotFoundException("The cluster link with ID " + linkId + " does not exist, or is temporarily unavailable");
                }
                MirrorTopicConfigSyncRules topicConfigSyncRules = clusterLinkManager$1.linkConfig(linkId).get().topicConfigSyncRules();
                topicConfigSyncRules.validateMirrorPropsForTopicAlteration(topic$1, configKeys$1);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$apiException$1(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$2(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$apiException$3(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$4(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$apiException$5(ObjectRef apiError$1, Throwable e$2) {
        return ((ApiError)apiError$1.elem).exception() + " is an instance of ClusterLinkAvailabilityException but " + e$2 + " is not which should not happen.";
    }

    public static final /* synthetic */ boolean $anonfun$doFilterTopics$1(scala.collection.immutable.Seq filters$1, Buffer usedFilters$1, String item) {
        scala.collection.immutable.Seq matchedFilters = (scala.collection.immutable.Seq)filters$1.filter((Function1<ClusterLinkFilterInfo, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(x$9.matchesIncludeOrExclude(item)));
        if (matchedFilters.isEmpty()) {
            return false;
        }
        usedFilters$1.$plus$plus$eq(matchedFilters);
        return matchedFilters.forall((Function1<ClusterLinkFilterInfo, Object> & Serializable)x$10 -> BoxesRunTime.boxToBoolean(x$10.isInclude()));
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$2(String group$1, GroupClusterLinkFilterInfo x$11) {
        return x$11.filterInfo().matchesIncludeOrExclude(group$1);
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$4(GroupClusterLinkFilterInfo x$13) {
        return x$13.filterInfo().isInclude();
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$6(GroupClusterLinkFilterInfo x$15) {
        return !x$15.filterInfo().isInclude();
    }

    public static final /* synthetic */ boolean $anonfun$isOutboundBootstrapCCloudHost$1(String bootstrap) {
        return bootstrap != null && !bootstrap.isEmpty();
    }

    private ClusterLinkUtils$() {
    }
}

