/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import kafka.network.RequestChannel;
import kafka.server.ForwardingManager;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkDisabled$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.MirrorTopicRequestHelperKraft;
import kafka.server.link.MirrorTopicRequestHelperKraft$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\u000e\u001d\u0001\rB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\n{\u0001\u0011\t\u0011)A\u0005}!C\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"Aa\f\u0001B\u0001B\u0003%q\f\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003n\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u001dI\bA1A\u0005\niDaA \u0001!\u0002\u0013Y\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001fA\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u00037A1\"a\t\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002&!Y\u0011Q\f\u0001A\u0002\u0003\u0007I\u0011BA0\u0011-\t)\u0007\u0001a\u0001\u0002\u0003\u0006K!a\n\t\u000f\u0005\u001d\u0004\u0001\"\u0015\u0002j!9\u0011q\u000f\u0001\u0005R\u0005e\u0004bBA>\u0001\u0011E\u0013\u0011\u0010\u0005\b\u0003{\u0002A\u0011KA@\u0011\u001d\tY\t\u0001C)\u0003SBq!!$\u0001\t#\nI\bC\u0004\u0002\u0010\u0002!\t&!%\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\ni2I]3bi\u0016l\u0015N\u001d:peR{\u0007/[2t\u0011\u0016d\u0007/\u001a:Le\u00064GO\u0003\u0002\u001e=\u0005!A.\u001b8l\u0015\ty\u0002%\u0001\u0004tKJ4XM\u001d\u0006\u0002C\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001%!\r)c\u0005K\u0007\u00029%\u0011q\u0005\b\u0002\u001e\u001b&\u0014(o\u001c:U_BL7MU3rk\u0016\u001cH\u000fS3ma\u0016\u00148J]1giB\u0011\u0011fM\u0007\u0002U)\u00111\u0006L\u0001\b[\u0016\u001c8/Y4f\u0015\tic&\u0001\u0004d_6lwN\u001c\u0006\u0003C=R!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO&\u0011AG\u000b\u0002\u0019\u0007J,\u0017\r^3U_BL7m\u001d*fgB|gn]3ECR\f\u0017\u0001D1e[&tW*\u00198bO\u0016\u0014\bCA\u001c;\u001d\t)\u0003(\u0003\u0002:9\u0005\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\tYDH\u0001\u0007BI6Lg.T1oC\u001e,'O\u0003\u0002:9\u00059!/Z9vKN$\bCA F\u001d\t\u00015)D\u0001B\u0015\t\u0011\u0005%A\u0004oKR<xN]6\n\u0005\u0011\u000b\u0015A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0003\r\u001e\u0013qAU3rk\u0016\u001cHO\u0003\u0002E\u0003&\u0011QHJ\u0001\u0007M^$Wj\u001a:\u0011\u0005-cU\"\u0001\u0010\n\u00055s\"!\u0005$pe^\f'\u000fZ5oO6\u000bg.Y4fe\u0006)2/\u001a8e\r>\u0014x/\u0019:eK\u0012\u0014Vm\u001d9p]N,\u0007#\u0002)T}U[V\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001,Z\u001b\u00059&B\u0001--\u0003!\u0011X-];fgR\u001c\u0018B\u0001.X\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX\r\u0005\u0002Q9&\u0011Q,\u0015\u0002\u0005+:LG/A\niC:$G.Z#se>\u0014(+Z:q_:\u001cX\rE\u0003Q'z\u00027\f\u0005\u0002bS:\u0011!m\u001a\b\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\n\na\u0001\u0010:p_Rt\u0014\"\u0001*\n\u0005!\f\u0016a\u00029bG.\fw-Z\u0005\u0003U.\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005!\f\u0016!\n5b]\u0012dW-\u00138wC2LGMV3sg&|gn\u001d#ve&twMR8so\u0006\u0014H-\u001b8h!\u0011\u0001fNP.\n\u0005=\f&!\u0003$v]\u000e$\u0018n\u001c82\u0003\u0019a\u0014N\\5u}Q9!o\u001d;vm^D\bCA\u0013\u0001\u0011\u0015)t\u00011\u00017\u0011\u0015it\u00011\u0001?\u0011\u0015Iu\u00011\u0001K\u0011\u0015qu\u00011\u0001P\u0011\u0015qv\u00011\u0001`\u0011\u0015aw\u00011\u0001n\u0003M\u0019'/Z1uKR{\u0007/[2t%\u0016\fX/Z:u+\u0005Y\bC\u0001,}\u0013\tixKA\nDe\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cH/\u0001\u000bde\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fI\u0001\ni&lWm\\;u\u001bN,\"!a\u0001\u0011\u0007A\u000b)!C\u0002\u0002\bE\u00131!\u00138u\u0003)!\u0018.\\3pkRl5\u000fI\u0001\bm\u0016\u00148/[8o+\t\ty\u0001E\u0002Q\u0003#I1!a\u0005R\u0005\u0015\u0019\u0006n\u001c:u\u0003!1XM]:j_:\u0004\u0013\u0001\u0004<bY&$\u0017\r^3P]2LXCAA\u000e!\r\u0001\u0016QD\u0005\u0004\u0003?\t&a\u0002\"p_2,\u0017M\\\u0001\u000em\u0006d\u0017\u000eZ1uK>sG.\u001f\u0011\u0002\u001fM|WO]2f)>\u0004\u0018nY%oM>,\"!a\n\u0011\u0011\u0005%\u0012qFA\u001a\u0003\u0007j!!a\u000b\u000b\u0007\u00055\u0012+\u0001\u0006d_2dWm\u0019;j_:LA!!\r\u0002,\t\u0019Q*\u00199\u0011\t\u0005U\u0012Q\b\b\u0005\u0003o\tI\u0004\u0005\u0002d#&\u0019\u00111H)\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\rM#(/\u001b8h\u0015\r\tY$\u0015\t\u0007\u0003\u000b\n\u0019&a\u0016\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\ti%a\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003#\nAA[1wC&!\u0011QKA$\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0004K\u0005e\u0013bAA.9\t!2\t\\;ti\u0016\u0014H*\u001b8l)>\u0004\u0018nY%oM>\f1c]8ve\u000e,Gk\u001c9jG&sgm\\0%KF$2aWA1\u0011%\t\u0019'EA\u0001\u0002\u0004\t9#A\u0002yIE\n\u0001c]8ve\u000e,Gk\u001c9jG&sgm\u001c\u0011\u0002M\u0011|7I]3bi\u00164\u0016\r\\5eCR,wJ\u001c7z\u001b&\u0014(o\u001c:U_BL7MU3rk\u0016\u001cH\u000f\u0006\u0002\u0002lA)\u0001+!\u001c\u0002r%\u0019\u0011qN)\u0003\r=\u0003H/[8o!\r1\u00161O\u0005\u0004\u0003k:&aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u0002-\u0011|g+\u00197jI\u0006$X-T5se>\u0014Hk\u001c9jGN$\u0012aW\u0001\u001eI>4U\r^2i'>,(oY3U_BL7-\u00138g_Jl\u0017\r^5p]\u0006!Cm\u001c,bY&$\u0017\r^3NSJ\u0014xN\u001d+pa&\u001c7oV5uQN{WO]2f\u0013:4w\u000eF\u0002\\\u0003\u0003Cq!a!\u0017\u0001\u0004\t))\u0001\u0005dC2d'-Y2l!\u0011\u0001\u0016qQ.\n\u0007\u0005%\u0015KA\u0005Gk:\u001cG/[8oa\u0005IBm\\\"sK\u0006$XMR5oC2$v\u000e]5d%\u0016\fX/Z:u\u0003Y!wnU3oIJ+7\u000f]8og\u0016$vn\u00117jK:$\u0018a\f8p\u001b&\u0014(o\u001c:U_BL7m](s\u00032dW*\u001b:s_J$v\u000e]5dg\u001a\u000b\u0017\u000e\\3e-\u0006d\u0017\u000eZ1uS>tGCAA\u000e\u0003q1\u0018\r\\5eCR,7I]3bi\u0006\u0014G.Z'jeJ|'\u000fV8qS\u000e$\u0002\"a&\u0002\u001e\u0006\r\u0017q\u0019\t\u0004-\u0006e\u0015bAAN/\nA\u0011\t]5FeJ|'\u000fC\u0004\u0002 j\u0001\r!!)\u0002\u000bQ|\u0007/[2\u0011\t\u0005\r\u0016Q\u0018\b\u0005\u0003K\u000bIL\u0004\u0003\u0002(\u0006]f\u0002BAU\u0003ksA!a+\u00024:!\u0011QVAY\u001d\r\u0019\u0017qV\u0005\u0002e%\u0011\u0001'M\u0005\u0003C=J!!\f\u0018\n\u0005-b\u0013bAA^U\u000592I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0003\u007f\u000b\tM\u0001\bDe\u0016\fG/\u00192mKR{\u0007/[2\u000b\u0007\u0005m&\u0006C\u0004\u0002$i\u0001\r!!2\u0011\u000bA\u000bi'a\n\t\u000f\u0005]!\u00041\u0001\u0002\u001c\u0001")
public class CreateMirrorTopicsHelperKraft
extends MirrorTopicRequestHelperKraft<CreateTopicsResponseData> {
    private final ClusterLinkFactory.AdminManager adminManager;
    private final Function2<RequestChannel.Request, AbstractResponse, BoxedUnit> sendForwardedResponse;
    private final CreateTopicsRequest createTopicsRequest;
    private final int timeoutMs;
    private final short version;
    private final boolean validateOnly;
    private Map<String, CompletableFuture<ClusterLinkTopicInfo>> sourceTopicInfo;

    private CreateTopicsRequest createTopicsRequest() {
        return this.createTopicsRequest;
    }

    private int timeoutMs() {
        return this.timeoutMs;
    }

    private short version() {
        return this.version;
    }

    private boolean validateOnly() {
        return this.validateOnly;
    }

    private Map<String, CompletableFuture<ClusterLinkTopicInfo>> sourceTopicInfo() {
        return this.sourceTopicInfo;
    }

    private void sourceTopicInfo_$eq(Map<String, CompletableFuture<ClusterLinkTopicInfo>> x$1) {
        this.sourceTopicInfo = x$1;
    }

    @Override
    public Option<AbstractRequest> doCreateValidateOnlyMirrorTopicRequest() {
        CreateTopicsRequestData requestData = this.createTopicsRequest().data().duplicate();
        Iterator iterator = requestData.topics().iterator();
        while (iterator.hasNext()) {
            CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)iterator.next();
            if (creatableTopic.mirrorTopic() != null) continue;
            iterator.remove();
        }
        requestData.setValidateOnly(true);
        if (!requestData.topics().isEmpty()) {
            return new Some<CreateTopicsRequest>(new CreateTopicsRequest.Builder(requestData).build(this.version()));
        }
        return None$.MODULE$;
    }

    @Override
    public void doValidateMirrorTopics() {
        this.validateOnlyMirrorTopicResponseData().foreach((Function1<CreateTopicsResponseData, Object> & Serializable)x$9 -> {
            CreateMirrorTopicsHelperKraft.$anonfun$doValidateMirrorTopics$1(this, x$9);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void doFetchSourceTopicInformation() {
        this.validateOnlyMirrorTopicResponseData().foreach((Function1<CreateTopicsResponseData, Object> & Serializable)responseData -> {
            CreateMirrorTopicsHelperKraft.$anonfun$doFetchSourceTopicInformation$1(this, responseData);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void doValidateMirrorTopicsWithSourceInfo(Function0<BoxedUnit> callback) {
        this.adminManager.tryCompleteElseWatch(this.timeoutMs(), this.sourceTopicInfo().values().toSeq(), () -> {
            this.validateOnlyMirrorTopicResponseData().foreach((Function1<CreateTopicsResponseData, Object> & Serializable)x$12 -> {
                CreateMirrorTopicsHelperKraft.$anonfun$doValidateMirrorTopicsWithSourceInfo$2(this, x$12);
                return BoxedUnit.UNIT;
            });
            callback.apply$mcV$sp();
        });
    }

    @Override
    public Option<AbstractRequest> doCreateFinalTopicRequest() {
        Option option = this.validateOnlyMirrorTopicResponseData();
        if (option instanceof Some) {
            Some some = (Some)option;
            CreateTopicsResponseData responseData = (CreateTopicsResponseData)some.value();
            CreateTopicsRequestData requestData = this.createTopicsRequest().data().duplicate();
            Iterator iterator = requestData.topics().iterator();
            while (iterator.hasNext()) {
                CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)iterator.next();
                if (!Option$.MODULE$.apply(responseData.topics().find(creatableTopic.name())).exists((Function1<CreateTopicsResponseData.CreatableTopicResult, Object> & Serializable)x$13 -> BoxesRunTime.boxToBoolean(CreateMirrorTopicsHelperKraft.$anonfun$doCreateFinalTopicRequest$1(x$13)))) continue;
                iterator.remove();
            }
            if (!requestData.topics().isEmpty()) {
                return new Some<CreateTopicsRequest>(new CreateTopicsRequest.Builder(requestData).build(this.version()));
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            return new Some<CreateTopicsRequest>(this.createTopicsRequest());
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doSendResponseToClient() {
        Option option = this.finalResponseData();
        if (option instanceof Some) {
            Some some = (Some)option;
            CreateTopicsResponseData finalResponse = (CreateTopicsResponseData)some.value();
            Option option2 = this.validateOnlyMirrorTopicResponseData();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                CreateTopicsResponseData validateResponseData = (CreateTopicsResponseData)some2.value();
                validateResponseData.topics().forEach(topic -> {
                    if (topic.errorCode() != Errors.NONE.code()) {
                        finalResponse.topics().add((ImplicitLinkedHashCollection.Element)topic.duplicate());
                        return;
                    }
                });
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                this.debug((Function0<String> & Serializable)() -> "No mirror topics in the CreateTopics request " + this.createTopicsRequest());
            }
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            this.finalResponseFromController_$eq(this.validateOnlyMirrorTopicResponse());
        }
        Option<AbstractResponse> option3 = this.finalResponseFromController();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            AbstractResponse finalResponse = (AbstractResponse)some.value();
            this.sendForwardedResponse.apply(super.request(), finalResponse);
            return;
        }
        if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
        throw new IllegalStateException("Unable to process the request");
    }

    @Override
    public boolean noMirrorTopicsOrAllMirrorTopicsFailedValidation() {
        return this.validateOnlyMirrorTopicResponseData().forall((Function1<CreateTopicsResponseData, Object> & Serializable)x$14 -> BoxesRunTime.boxToBoolean(CreateMirrorTopicsHelperKraft.$anonfun$noMirrorTopicsOrAllMirrorTopicsFailedValidation$1(x$14)));
    }

    private ApiError validateCreatableMirrorTopic(CreateTopicsRequestData.CreatableTopic topic, Option<Map<String, CompletableFuture<ClusterLinkTopicInfo>>> sourceTopicInfo, boolean validateOnly) {
        ApiError apiError;
        try {
            MirrorTopicRequestHelperKraft$.MODULE$.transformCreatableTopic(this.adminManager.clusterLinkManager(), topic, sourceTopicInfo.flatMap((Function1<Map, Option> & Serializable)x$16 -> x$16.get(topic.name())), validateOnly, this.version());
            apiError = ApiError.NONE;
        }
        catch (ConfigException e) {
            this.debug((Function0<String> & Serializable)() -> "Error processing create topic request " + topic, (Function0<Throwable>)(Function0<ConfigException> & Serializable)() -> e);
            apiError = ApiError.fromThrowable((Throwable)new InvalidConfigurationException(e.getMessage(), e.getCause()));
        }
        catch (ApiException e) {
            this.info((Function0<String> & Serializable)() -> "Error processing create topic request " + topic, (Function0<Throwable>)(Function0<ApiException> & Serializable)() -> e);
            apiError = ApiError.fromThrowable((Throwable)e);
        }
        catch (Throwable e) {
            this.error((Function0<String> & Serializable)() -> "Error processing create topic request " + topic, (Function0<Throwable> & Serializable)() -> e);
            apiError = ApiError.fromThrowable((Throwable)e);
        }
        return apiError;
    }

    public static final /* synthetic */ void $anonfun$doValidateMirrorTopics$1(CreateMirrorTopicsHelperKraft $this, CreateTopicsResponseData x$9) {
        x$9.topics().forEach(topic -> {
            if (topic.errorCode() == Errors.NONE.code()) {
                if ($this.adminManager.clusterLinkingIsDisabled()) {
                    ApiError clDisabledApiError = ApiError.fromThrowable((Throwable)ClusterLinkDisabled$.MODULE$.exception(ClusterLinkDisabled$.MODULE$.exception$default$1()));
                    topic.setErrorCode(clDisabledApiError.error().code());
                    topic.setErrorMessage(clDisabledApiError.message());
                    return;
                }
                ApiError apiError = $this.validateCreatableMirrorTopic($this.createTopicsRequest().data().topics().find(topic.name()), None$.MODULE$, true);
                topic.setErrorCode(apiError.error().code());
                topic.setErrorMessage(apiError.message());
                return;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$doFetchSourceTopicInformation$2(CreateTopicsResponseData.CreatableTopicResult topic) {
        return topic.errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ void $anonfun$doFetchSourceTopicInformation$1(CreateMirrorTopicsHelperKraft $this, CreateTopicsResponseData responseData) {
        Iterable validatedMirrors = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(responseData.topics()).asScala().filter((Function1<CreateTopicsResponseData.CreatableTopicResult, Object> & Serializable)topic -> BoxesRunTime.boxToBoolean(CreateMirrorTopicsHelperKraft.$anonfun$doFetchSourceTopicInformation$2(topic)));
        scala.collection.immutable.Map<String, Option<Uuid>> validatedMirrorToLinkIdMap = ((IterableOnceOps)validatedMirrors.map((Function1<CreateTopicsResponseData.CreatableTopicResult, Tuple2> & Serializable)topicResult -> {
            CreateTopicsRequestData.CreatableTopic creatableTopic = $this.createTopicsRequest().data().topics().find(topicResult.name());
            Option linkId = Option$.MODULE$.apply(creatableTopic.linkName()).flatMap((Function1<String, Option> & Serializable)name -> $this.adminManager.clusterLinkManager().clusterLinkMetadataManager().flatMap((Function1<ClusterLinkMetadataManager, Option> & Serializable)x$10 -> x$10.getClusterLinkData((String)name)).map((Function1<ClusterLinkData, Uuid> & Serializable)x$11 -> x$11.linkId()));
            return new Tuple2(creatableTopic.name(), linkId);
        })).toMap($less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map<String, ApiError> validateMirrorsErrorInfo = ((IterableOnceOps)validatedMirrors.map((Function1<CreateTopicsResponseData.CreatableTopicResult, Tuple2> & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic.name()), new ApiError(topic.errorCode(), topic.errorMessage())))).toMap($less$colon$less$.MODULE$.refl());
        $this.sourceTopicInfo_$eq($this.adminManager.clusterLinkManager().fetchSourceTopicInfoForMirrors(validatedMirrorToLinkIdMap, validateMirrorsErrorInfo, (Function2<Set, ClusterLinkFactory.DestClientManager, Map> & Serializable)(topics, client) -> {
            scala.collection.immutable.Map<String, Object> topicsWithStartOffsetSpec = ((IterableOnceOps)topics.map((Function1<String, Tuple2> & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), BoxesRunTime.boxToLong($this.createTopicsRequest().data().topics().find(topic).mirrorStartOffsetSpec())))).toMap($less$colon$less$.MODULE$.refl());
            return client.fetchTopicInfos(topicsWithStartOffsetSpec, $this.timeoutMs());
        }));
    }

    public static final /* synthetic */ void $anonfun$doValidateMirrorTopicsWithSourceInfo$2(CreateMirrorTopicsHelperKraft $this, CreateTopicsResponseData x$12) {
        x$12.topics().forEach(topic -> {
            if (topic.errorCode() == Errors.NONE.code()) {
                ApiError apiError = $this.validateCreatableMirrorTopic($this.createTopicsRequest().data().topics().find(topic.name()), new Some<Map<String, CompletableFuture<ClusterLinkTopicInfo>>>($this.sourceTopicInfo()), $this.validateOnly());
                topic.setErrorCode(apiError.error().code());
                topic.setErrorMessage(apiError.message());
                return;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$doCreateFinalTopicRequest$1(CreateTopicsResponseData.CreatableTopicResult x$13) {
        return x$13.errorCode() != Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$noMirrorTopicsOrAllMirrorTopicsFailedValidation$2(CreateTopicsResponseData.CreatableTopicResult x$15) {
        return x$15.errorCode() != Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$noMirrorTopicsOrAllMirrorTopicsFailedValidation$1(CreateTopicsResponseData x$14) {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(x$14.topics()).asScala().forall((Function1<CreateTopicsResponseData.CreatableTopicResult, Object> & Serializable)x$15 -> BoxesRunTime.boxToBoolean(CreateMirrorTopicsHelperKraft.$anonfun$noMirrorTopicsOrAllMirrorTopicsFailedValidation$2(x$15)));
    }

    public CreateMirrorTopicsHelperKraft(ClusterLinkFactory.AdminManager adminManager, RequestChannel.Request request, ForwardingManager fwdMgr, Function2<RequestChannel.Request, AbstractResponse, BoxedUnit> sendForwardedResponse, Function2<RequestChannel.Request, Throwable, BoxedUnit> handleErrorResponse, Function1<RequestChannel.Request, BoxedUnit> handleInvalidVersionsDuringForwarding) {
        this.adminManager = adminManager;
        this.sendForwardedResponse = sendForwardedResponse;
        super(request, fwdMgr, handleErrorResponse, handleInvalidVersionsDuringForwarding);
        this.createTopicsRequest = (CreateTopicsRequest)super.request().body(ClassTag$.MODULE$.apply(CreateTopicsRequest.class));
        this.timeoutMs = this.createTopicsRequest().data().timeoutMs();
        this.version = this.createTopicsRequest().version();
        this.validateOnly = this.createTopicsRequest().data().validateOnly();
    }
}

