/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.image.publisher.GroupCoordinatorDeletedTopicsPublisher;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.MergedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.AclPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DelegationTokenPublisher;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.server.metadata.ScramPublisher;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupObjectLifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.share.ShareCoordinator;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.ScramDelta;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.ScramCredentialData;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u001dx!\u0002\u0017.\u0011\u0003!d!\u0002\u001c.\u0011\u00039\u0004\"\u0002#\u0002\t\u0003)\u0005\"\u0002$\u0002\t\u00039e\u0001\u0002\u001c.\u00015D\u0001\u0002 \u0003\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\t{\u0012\u0011\t\u0011)A\u0005}\"Q\u0011Q\u0001\u0003\u0003\u0002\u0003\u0006I!a\u0002\t\u0015\u00055AA!A!\u0002\u0013\ty\u0001\u0003\u0006\u0002\u001c\u0011\u0011\t\u0011)A\u0005\u0003;A!\"a\t\u0005\u0005\u0003\u0005\u000b\u0011BA\u0013\u0011)\t)\u0004\u0002B\u0001B\u0003%\u0011q\u0007\u0005\u000b\u0003\u000b\"!\u0011!Q\u0001\n\u0005\u001d\u0003BCA+\t\t\u0005\r\u0011\"\u0001\u0002X!Q\u0011q\f\u0003\u0003\u0002\u0004%\t!!\u0019\t\u0015\u00055DA!A!B\u0013\tI\u0006\u0003\u0006\u0002p\u0011\u0011\t\u0011)A\u0005\u0003cB!\"a\u001e\u0005\u0005\u0003\u0005\u000b\u0011BA=\u0011)\ty\b\u0002B\u0001B\u0003%\u0011\u0011\u0011\u0005\u000b\u0003\u000f#!\u0011!Q\u0001\n\u0005%\u0005BCAH\t\t\u0005\t\u0015!\u0003\u0002\u0012\"Q\u0011Q\u0014\u0003\u0003\u0002\u0003\u0006I!a(\t\u0015\u00055FA!A!\u0002\u0013\ty\n\u0003\u0006\u00020\u0012\u0011\t\u0011)A\u0005\u0003cC!\"!5\u0005\u0005\u0003\u0005\u000b\u0011BAj\u0011)\t\t\u000f\u0002B\u0001B\u0003%\u00111\u001d\u0005\u000b\u0003c$!\u0011!Q\u0001\n\u0005M\bB\u0003B\u0001\t\t\u0005\t\u0015!\u0003\u0003\u0004!Q!\u0011\u0003\u0003\u0003\u0002\u0003\u0006IAa\u0005\t\r\u0011#A\u0011\u0001B\u0015\u0011%\u0011I\u0006\u0002b\u0001\n\u0003\u0011Y\u0006\u0003\u0005\u0003d\u0011\u0001\u000b\u0011\u0002B/\u0011%\u0011)\u0007\u0002a\u0001\n\u0003\u00119\u0007C\u0005\u0003p\u0011\u0001\r\u0011\"\u0001\u0003r!A!Q\u000f\u0003!B\u0013\u0011I\u0007C\u0005\u0003x\u0011\u0011\r\u0011\"\u0001\u0003z!A!\u0011\u0013\u0003!\u0002\u0013\u0011Y\bC\u0004\u0003\u0014\u0012!\tE!&\t\u000f\t]E\u0001\"\u0011\u0003\u001a\"9!q\u0016\u0003\u0005\n\tE\u0006b\u0002Ba\t\u0011\u0005!1\u0019\u0005\b\u00057$A\u0011\u0002Bo\u0011\u001d\u0011\t\u000f\u0002C\u0005\u0005GDqA!:\u0005\t\u0003\u0012\u0019/A\fCe>\\WM]'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5fe*\u0011afL\u0001\t[\u0016$\u0018\rZ1uC*\u0011\u0001'M\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003I\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u00026\u00035\tQFA\fCe>\\WM]'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5feN\u0019\u0011\u0001\u000f \u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\r\u0005s\u0017PU3g!\ty$)D\u0001A\u0015\t\t\u0015'A\u0003vi&d7/\u0003\u0002D\u0001\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00015\u000359W\r\u001e+pa&\u001cG)\u001a7uCR!\u0001JV2i!\rI\u0014jS\u0005\u0003\u0015j\u0012aa\u00149uS>t\u0007C\u0001'U\u001b\u0005i%B\u0001(P\u0003\u0015IW.Y4f\u0015\t\u0011\u0004K\u0003\u0002R%\u00061\u0011\r]1dQ\u0016T\u0011aU\u0001\u0004_J<\u0017BA+N\u0005)!v\u000e]5d\t\u0016dG/\u0019\u0005\u0006/\u000e\u0001\r\u0001W\u0001\ni>\u0004\u0018n\u0019(b[\u0016\u0004\"!\u00171\u000f\u0005is\u0006CA.;\u001b\u0005a&BA/4\u0003\u0019a$o\\8u}%\u0011qLO\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`u!)Am\u0001a\u0001K\u0006Aa.Z<J[\u0006<W\r\u0005\u0002MM&\u0011q-\u0014\u0002\u000e\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\t\u000b%\u001c\u0001\u0019\u00016\u0002\u000b\u0011,G\u000e^1\u0011\u00051[\u0017B\u00017N\u00055iU\r^1eCR\fG)\u001a7uCN!AA\u001c<?!\tyG/D\u0001q\u0015\t\t(/\u0001\u0003mC:<'\"A:\u0002\t)\fg/Y\u0005\u0003kB\u0014aa\u00142kK\u000e$\bCA<{\u001b\u0005A(BA=N\u0003%\u0001XO\u00197jg\",'/\u0003\u0002|q\n\tR*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u0002\u0013\rdWo\u001d;fe&#\u0017\u0001B2p]\u001a\u00042a`A\u0001\u001b\u0005y\u0013bAA\u0002_\tY1*\u00194lC\u000e{gNZ5h\u00035iW\r^1eCR\f7)Y2iKB\u0019Q'!\u0003\n\u0007\u0005-QFA\fL%\u00064G/S7bO\u0016lU\r^1eCR\f7)Y2iK\u0006QAn\\4NC:\fw-\u001a:\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u00062\u0003\rawnZ\u0005\u0005\u00033\t\u0019B\u0001\u0006M_\u001el\u0015M\\1hKJ\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000fE\u0002\u0000\u0003?I1!!\t0\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f\u0001c\u001a:pkB\u001cun\u001c:eS:\fGo\u001c:\u0011\t\u0005\u001d\u0012\u0011G\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005)qM]8va*\u0019\u0011qF(\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0005\u0003g\tIC\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\u0006qA\u000f\u001f8D_>\u0014H-\u001b8bi>\u0014\b\u0003BA\u001d\u0003\u0003j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\fiJ\fgn]1di&|gNC\u0002\u00020EJA!a\u0011\u0002<\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0001\ttQ\u0006\u0014XmQ8pe\u0012Lg.\u0019;peB!\u0011(SA%!\u0011\tY%!\u0015\u000e\u0005\u00055#\u0002BA(\u0003[\tQa\u001d5be\u0016LA!a\u0015\u0002N\t\u00012\u000b[1sK\u000e{wN\u001d3j]\u0006$xN]\u0001\u0017Ift\u0017-\\5d\u0007>tg-[4Qk\nd\u0017n\u001d5feV\u0011\u0011\u0011\f\t\u0004k\u0005m\u0013bAA/[\t1B)\u001f8b[&\u001c7i\u001c8gS\u001e\u0004VO\u00197jg\",'/\u0001\u000ees:\fW.[2D_:4\u0017n\u001a)vE2L7\u000f[3s?\u0012*\u0017\u000f\u0006\u0003\u0002d\u0005%\u0004cA\u001d\u0002f%\u0019\u0011q\r\u001e\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003Wr\u0011\u0011!a\u0001\u00033\n1\u0001\u001f\u00132\u0003]!\u0017P\\1nS\u000e\u001cuN\u001c4jOB+(\r\\5tQ\u0016\u0014\b%A\u000ees:\fW.[2DY&,g\u000e^)v_R\f\u0007+\u001e2mSNDWM\u001d\t\u0004k\u0005M\u0014bAA;[\tYB)\u001f8b[&\u001c7\t\\5f]R\fVo\u001c;b!V\u0014G.[:iKJ\fab]2sC6\u0004VO\u00197jg\",'\u000fE\u00026\u0003wJ1!! .\u00059\u00196M]1n!V\u0014G.[:iKJ\f\u0001\u0004Z3mK\u001e\fG/[8o)>\\WM\u001c)vE2L7\u000f[3s!\r)\u00141Q\u0005\u0004\u0003\u000bk#\u0001\u0007#fY\u0016<\u0017\r^5p]R{7.\u001a8Qk\nd\u0017n\u001d5fe\u0006a\u0011m\u00197Qk\nd\u0017n\u001d5feB\u0019Q'a#\n\u0007\u00055UF\u0001\u0007BG2\u0004VO\u00197jg\",'/\u0001\nde\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\b\u0003BAJ\u00033k!!!&\u000b\u0007\u0005]u*\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\tY*!&\u0003%\r\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM]\u0001\u0012M\u0006$\u0018\r\u001c$bk2$\b*\u00198eY\u0016\u0014\b\u0003BAQ\u0003Sk!!a)\u000b\t\u0005\u0015\u0016qU\u0001\u0006M\u0006,H\u000e\u001e\u0006\u0003a=KA!a+\u0002$\naa)Y;mi\"\u000bg\u000e\u001a7fe\u0006qR.\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001b8h\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u0013G2,8\u000f^3s\u0019&t7.T1oC\u001e,'\u000f\u0005\u0003:\u0013\u0006M\u0006\u0003BA[\u0003\u0017tA!a.\u0002F:!\u0011\u0011XAa\u001d\u0011\tY,a0\u000f\u0007m\u000bi,C\u00013\u0013\t\u0001\u0014'C\u0002\u0002D>\nA\u0001\\5oW&!\u0011qYAe\u0003I\u0019E.^:uKJd\u0015N\\6GC\u000e$xN]=\u000b\u0007\u0005\rw&\u0003\u0003\u0002N\u0006='a\u0003'j].l\u0015M\\1hKJTA!a2\u0002J\u0006\tB/[3sK\u0012\u001cun\u001c:eS:\fGo\u001c:\u0011\teJ\u0015Q\u001b\t\u0005\u0003/\fi.\u0004\u0002\u0002Z*\u0019\u00111\\\u0019\u0002\tQLWM]\u0005\u0005\u0003?\fIN\u0001\u0011US\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014\u0018A\u000b2bG.,\bo\u00142kK\u000e$H*\u001b4fGf\u001cG.Z'b]\u0006<WM]\"p_J$\u0017N\\1u_J|\u0005\u000f\u001e\t\u0005s%\u000b)\u000f\u0005\u0003\u0002h\u00065XBAAu\u0015\u0011\tY/!7\u0002+\t\f7m[;q\u001f\nTWm\u0019;MS\u001a,7-_2mK&!\u0011q^Au\u0005\u001d\u0012\u0015mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016l\u0015M\\1hKJ\u001cun\u001c:eS:\fGo\u001c:\u0002?QLWM\u001d+pa&\u001c7K\\1qg\"|GoQ8pe\u0012Lg.\u0019;pe>\u0003H\u000f\u0005\u0003:\u0013\u0006U\b\u0003BA|\u0003{l!!!?\u000b\t\u0005m\u0018\u0011\\\u0001\tg:\f\u0007o\u001d5pi&!\u0011q`A}\u0005q!\u0016.\u001a:U_BL7m\u00158baNDw\u000e^\"p_J$\u0017N\\1u_J\f1#];pi\u0006\u001cun\u001c:eS:\fGo\u001c:PaR\u0004B!O%\u0003\u0006A!!q\u0001B\u0007\u001b\t\u0011IA\u0003\u0003\u0003\f\u0005}\u0012!B9v_R\f\u0017\u0002\u0002B\b\u0005\u0013\u0011\u0001#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:\u0002M\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014H)\u001a7fi\u0016$Gk\u001c9jGN\u0004VO\u00197jg\",'\u000f\u0005\u0003\u0003\u0016\t\u0015RB\u0001B\f\u0015\rI(\u0011\u0004\u0006\u0004\u001d\nm!b\u0001\u001a\u0003\u001e)!!q\u0004B\u0011\u0003%\u0019wN\u001c4mk\u0016tGO\u0003\u0002\u0003$\u0005\u0011\u0011n\\\u0005\u0005\u0005O\u00119B\u0001\u0014He>,\boQ8pe\u0012Lg.\u0019;pe\u0012+G.\u001a;fIR{\u0007/[2t!V\u0014G.[:iKJ$bFa\u000b\u0003.\t=\"\u0011\u0007B\u001a\u0005k\u00119D!\u000f\u0003<\tu\"q\bB!\u0005\u0007\u0012)Ea\u0012\u0003J\t-#Q\nB(\u0005#\u0012\u0019F!\u0016\u0003XA\u0011Q\u0007\u0002\u0005\u0006yv\u0001\r\u0001\u0017\u0005\u0006{v\u0001\rA \u0005\b\u0003\u000bi\u0002\u0019AA\u0004\u0011\u001d\ti!\ba\u0001\u0003\u001fAq!a\u0007\u001e\u0001\u0004\ti\u0002C\u0004\u0002$u\u0001\r!!\n\t\u000f\u0005UR\u00041\u0001\u00028!9\u0011QI\u000fA\u0002\u0005\u001d\u0003bBA+;\u0001\u0007\u0011\u0011\f\u0005\b\u0003_j\u0002\u0019AA9\u0011\u001d\t9(\ba\u0001\u0003sBq!a \u001e\u0001\u0004\t\t\tC\u0004\u0002\bv\u0001\r!!#\t\u000f\u0005=U\u00041\u0001\u0002\u0012\"9\u0011QT\u000fA\u0002\u0005}\u0005bBAW;\u0001\u0007\u0011q\u0014\u0005\b\u0003_k\u0002\u0019AAY\u0011\u001d\t\t.\ba\u0001\u0003'Dq!!9\u001e\u0001\u0004\t\u0019\u000fC\u0004\u0002rv\u0001\r!a=\t\u000f\t\u0005Q\u00041\u0001\u0003\u0004!9!\u0011C\u000fA\u0002\tM\u0011\u0001\u00032s_.,'/\u00133\u0016\u0005\tu\u0003cA\u001d\u0003`%\u0019!\u0011\r\u001e\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005iqLZ5sgR\u0004VO\u00197jg\",\"A!\u001b\u0011\u0007e\u0012Y'C\u0002\u0003ni\u0012qAQ8pY\u0016\fg.A\t`M&\u00148\u000f\u001e)vE2L7\u000f[0%KF$B!a\u0019\u0003t!I\u00111N\u0011\u0002\u0002\u0003\u0007!\u0011N\u0001\u000f?\u001aL'o\u001d;Qk\nd\u0017n\u001d5!\u0003I1\u0017N]:u!V\u0014G.[:i\rV$XO]3\u0016\u0005\tm\u0004C\u0002B?\u0005\u000f\u0013Y)\u0004\u0002\u0003\u0000)!!\u0011\u0011BB\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0005\u000b\u0013\u0018\u0001B;uS2LAA!#\u0003\u0000\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u0007=\u0014i)C\u0002\u0003\u0010B\u0014AAV8jI\u0006\u0019b-\u001b:tiB+(\r\\5tQ\u001a+H/\u001e:fA\u0005!a.Y7f)\u0005A\u0016\u0001E8o\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;f)!\t\u0019Ga'\u0003\u001e\n}\u0005\"B5'\u0001\u0004Q\u0007\"\u00023'\u0001\u0004)\u0007b\u0002BQM\u0001\u0007!1U\u0001\t[\u0006t\u0017NZ3tiB!!Q\u0015BV\u001b\t\u00119KC\u0002\u0003*6\u000ba\u0001\\8bI\u0016\u0014\u0018\u0002\u0002BW\u0005O\u0013a\u0002T8bI\u0016\u0014X*\u00198jM\u0016\u001cH/A\u0007u_>\u0003H/[8oC2Le\u000e\u001e\u000b\u0005\u0005g\u0013Y\f\u0005\u0003\u00036\n]VB\u0001BB\u0013\u0011\u0011ILa!\u0003\u0017=\u0003H/[8oC2Le\u000e\u001e\u0005\b\u0005{;\u0003\u0019\u0001B`\u0003\u0019y\u0007\u000f^5p]B!\u0011(\u0013B/\u0003E)\b\u000fZ1uK\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\r\u0003G\u0012)Ma2\u0003J\n-'Q\u001b\u0005\u0006\u001d\"\u0002\r!\u001a\u0005\u0006S\"\u0002\rA\u001b\u0005\u0006/\"\u0002\r\u0001\u0017\u0005\b\u0005\u001bD\u0003\u0019\u0001Bh\u0003!)G.Z2uS>t\u0007#C\u001d\u0003R\nu#QLA2\u0013\r\u0011\u0019N\u000f\u0002\n\rVt7\r^5p]JBqAa6)\u0001\u0004\u0011I.A\u0006sKNLwM\\1uS>t\u0007#C\u001d\u0003R\nu#qXA2\u0003IIg.\u001b;jC2L'0Z'b]\u0006<WM]:\u0015\t\u0005\r$q\u001c\u0005\u0006I&\u0002\r!Z\u0001!M&t\u0017n\u001d5J]&$\u0018.\u00197ju&twMU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0006\u0002\u0002d\u0005)1\r\\8tK\u0002")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig conf;
    private final KRaftImageMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final Option<ShareCoordinator> shareCoordinator;
    private DynamicConfigPublisher dynamicConfigPublisher;
    private final DynamicClientQuotaPublisher dynamicClientQuotaPublisher;
    private final ScramPublisher scramPublisher;
    private final DelegationTokenPublisher delegationTokenPublisher;
    private final AclPublisher aclPublisher;
    private final CredentialProvider credentialProvider;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final Option<ClusterLinkFactory.LinkManager> clusterLinkManager;
    private final Option<TierDeletedPartitionsCoordinator> tieredCoordinator;
    private final Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt;
    private final Option<TierTopicSnapshotCoordinator> tierTopicSnapshotCoordinatorOpt;
    private final Option<QuotaCoordinator> quotaCoordinatorOpt;
    private final GroupCoordinatorDeletedTopicsPublisher groupCoordinatorDeletedTopicsPublisher;
    private final int brokerId;
    private boolean _firstPublish;
    private final CompletableFuture<Void> firstPublishFuture;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void onControllerChange(LeaderAndEpoch newLeaderAndEpoch) {
        MetadataPublisher.super.onControllerChange(newLeaderAndEpoch);
    }

    private Logger logger$lzycompute() {
        BrokerMetadataPublisher brokerMetadataPublisher = this;
        synchronized (brokerMetadataPublisher) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DynamicConfigPublisher dynamicConfigPublisher() {
        return this.dynamicConfigPublisher;
    }

    public void dynamicConfigPublisher_$eq(DynamicConfigPublisher x$1) {
        this.dynamicConfigPublisher = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public CompletableFuture<Void> firstPublishFuture() {
        return this.firstPublishFuture;
    }

    @Override
    public String name() {
        return "BrokerMetadataPublisher";
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        String deltaName = this._firstPublish() ? "initial MetadataDelta up to " + highestOffsetAndEpoch.offset() : "MetadataDelta up to " + highestOffsetAndEpoch.offset();
        try {
            try {
                Serializable serializable;
                Serializable serializable2;
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String> & Serializable)() -> "Publishing delta " + delta + " with highest offset " + highestOffsetAndEpoch);
                }
                this.metadataCache.setImage(newImage);
                if (this._firstPublish()) {
                    this.info((Function0<String> & Serializable)() -> "Publishing initial metadata at offset " + highestOffsetAndEpoch + " with " + BrokerMetadataPublisher.metadataVersionLogMsg$1(newImage) + ".");
                    this.initializeManagers(newImage);
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String> & Serializable)() -> "Publishing metadata at offset " + highestOffsetAndEpoch + " with " + BrokerMetadataPublisher.metadataVersionLogMsg$1(newImage) + ".");
                }
                Option$.MODULE$.apply(delta.topicsDelta()).foreach((Function1<TopicsDelta, Object> & Serializable)topicsDelta -> {
                    Serializable serializable;
                    Serializable serializable2;
                    Serializable serializable3;
                    Serializable serializable4;
                    Serializable serializable5;
                    Serializable serializable6;
                    Serializable serializable7;
                    Serializable serializable8;
                    Serializable serializable9;
                    try {
                        $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                        serializable9 = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable9 = $this.metadataPublishingFaultHandler.handleFault("Error applying topics delta in " + deltaName, t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__consumer_offsets", (groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch) -> $this.groupCoordinator.onElection(groupMetadataPartitionIndex, groupMetadataPartitionLeaderEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionIndex, leaderEpochOpt) -> {
                            this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt(partitionIndex), this.toOptionalInt(leaderEpochOpt));
                            return BoxedUnit.UNIT;
                        });
                        serializable8 = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable8 = $this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with local changes in " + deltaName, t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__transaction_state", (txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                            this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt(txnTopicPartitionId), coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                        serializable7 = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable7 = $this.metadataPublishingFaultHandler.handleFault("Error updating txn coordinator with local changes in " + deltaName, t);
                    }
                    if ($this.shareCoordinator.isDefined()) {
                        try {
                            ShareCoordinator shareCoordinator = $this.shareCoordinator.get();
                            this.updateCoordinator(newImage, delta, "__share_group_state", (partitionIndex, partitionLeaderEpoch) -> shareCoordinator.onElection(partitionIndex, partitionLeaderEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionIndex, leaderEpochOpt) -> {
                                BrokerMetadataPublisher.$anonfun$onMetadataUpdate$10(this, BoxesRunTime.unboxToInt(partitionIndex), leaderEpochOpt);
                                return BoxedUnit.UNIT;
                            });
                            v3 = BoxedUnit.UNIT;
                        }
                        catch (Throwable t) {
                            v3 = $this.metadataPublishingFaultHandler.handleFault("Error updating share coordinator with local changes in " + deltaName, t);
                        }
                    } else {
                        v3 = BoxedUnit.UNIT;
                    }
                    try {
                        $this.tieredCoordinator.foreach((Function1<TierDeletedPartitionsCoordinator, Object> & Serializable)tieredCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (partitionId, x$1) -> tieredCoord.handleImmigration(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionId, x$2) -> {
                                tieredCoord.handleEmigration(BoxesRunTime.unboxToInt(partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                        serializable6 = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable6 = $this.metadataPublishingFaultHandler.handleFault("Error updating tiered storage coordinator with local changes in " + deltaName, t);
                    }
                    try {
                        $this.quotaCoordinatorOpt.foreach((Function1<QuotaCoordinator, Object> & Serializable)quotaCoordinator -> {
                            this.updateCoordinator(newImage, delta, "_confluent-quotas", (quotaTopicPartitionId, coordinatorEpoch) -> quotaCoordinator.onElection(quotaTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(quotaTopicPartitionId, coordinatorEpoch) -> {
                                quotaCoordinator.onResignation(BoxesRunTime.unboxToInt(quotaTopicPartitionId), coordinatorEpoch);
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                        serializable5 = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable5 = $this.metadataPublishingFaultHandler.handleFault("Error updating quota coordinator with local changes in " + deltaName, t);
                    }
                    try {
                        $this.backupObjectLifecycleManagerCoordinatorOpt.foreach((Function1<BackupObjectLifecycleManagerCoordinator, Object> & Serializable)backupObjectLifecycleManagerCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (partitionId, x$3) -> backupObjectLifecycleManagerCoord.onElection(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionId, x$4) -> {
                                backupObjectLifecycleManagerCoord.onResignation(BoxesRunTime.unboxToInt(partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                        serializable4 = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable4 = $this.metadataPublishingFaultHandler.handleFault("Error updating backup object lifecycle manager coordinator with local changes in " + deltaName, t);
                    }
                    try {
                        $this.tierTopicSnapshotCoordinatorOpt.foreach((Function1<TierTopicSnapshotCoordinator, Object> & Serializable)tierSnapshotCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (partitionId, x$5) -> tierSnapshotCoord.onElection(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionId, x$6) -> {
                                tierSnapshotCoord.onResignation(BoxesRunTime.unboxToInt(partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                        serializable3 = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable3 = $this.metadataPublishingFaultHandler.handleFault("Error updating tier topic snapshot coordinator with local changes in " + deltaName, t);
                    }
                    try {
                        $this.clusterLinkManager.foreach((Function1<ClusterLinkFactory.LinkManager, Object> & Serializable)manager -> {
                            this.updateCoordinator(newImage, delta, "_confluent-link-metadata", (partitionId, leaderEpoch) -> manager.onMetadataPartitionLeaderElection(partitionId, leaderEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2<Object, Option, Object> & Serializable)(partitionId, leaderEpoch) -> {
                                manager.onMetadataPartitionLeaderResignation(BoxesRunTime.unboxToInt(partitionId), leaderEpoch);
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                        serializable2 = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable2 = $this.metadataPublishingFaultHandler.handleFault("Error updating cluster link manager with local changes in " + deltaName, t);
                    }
                    try {
                        $this.groupCoordinatorDeletedTopicsPublisher.onMetadataUpdate(delta, newImage, manifest);
                        serializable = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        serializable = $this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with deleted KRaft partitions in " + deltaName, t);
                    }
                    return serializable;
                });
                this.dynamicConfigPublisher().onMetadataUpdate(delta, newImage);
                this.dynamicClientQuotaPublisher.onMetadataUpdate(delta, newImage);
                this.scramPublisher.onMetadataUpdate(delta, newImage);
                Option$.MODULE$.apply(delta.scramDelta()).foreach((Function1<ScramDelta, Object> & Serializable)scramDelta -> {
                    BrokerMetadataPublisher.$anonfun$onMetadataUpdate$26(this, scramDelta);
                    return BoxedUnit.UNIT;
                });
                this.delegationTokenPublisher.onMetadataUpdate(delta, newImage);
                this.aclPublisher.onMetadataUpdate(delta, newImage, manifest);
                try {
                    this.groupCoordinator.onNewMetadataImage(newImage, delta);
                    serializable2 = BoxedUnit.UNIT;
                }
                catch (Throwable t) {
                    serializable2 = this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with local changes in " + deltaName, t);
                }
                try {
                    this.shareCoordinator.foreach((Function1<ShareCoordinator, Object> & Serializable)coordinator -> {
                        coordinator.onNewMetadataImage(newImage, delta);
                        return BoxedUnit.UNIT;
                    });
                    serializable = BoxedUnit.UNIT;
                }
                catch (Throwable t) {
                    serializable = this.metadataPublishingFaultHandler.handleFault("Error updating share coordinator with local changes in " + deltaName, t);
                }
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager();
                }
            }
            catch (Throwable t) {
                this.metadataPublishingFaultHandler.handleFault("Uncaught exception while publishing broker metadata from " + deltaName, t);
            }
        }
        finally {
            this._firstPublish_$eq(false);
            this.firstPublishFuture().complete(null);
        }
    }

    private OptionalInt toOptionalInt(Option<Object> option) {
        Option<Object> option2 = option;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            int leaderEpoch = BoxesRunTime.unboxToInt(some.value());
            return OptionalInt.of(leaderEpoch);
        }
        if (None$.MODULE$.equals(option2)) {
            return OptionalInt.empty();
        }
        throw new MatchError(option2);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply(delta.topicsDelta()).foreach((Function1<TopicsDelta, Object> & Serializable)topicsDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$1(this, topicName, resignation, topicsDelta);
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1<TopicDelta, Object> & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$3(this, resignation, election, topicDelta);
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers(MetadataImage newImage) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Serializable serializable4;
        Serializable serializable5;
        Serializable serializable6;
        try {
            this.logManager.startup(this.metadataCache.getAllTopics(None$.MODULE$), (Function1<MergedLog, Object> & Serializable)log -> BoxesRunTime.boxToBoolean(LogManager$.MODULE$.isStrayKraftReplica(this.brokerId(), newImage.topics(), log)));
            this.logManager.recoverAbandonedFutureLogs(this.brokerId(), newImage.topics());
            Option$.MODULE$.apply(this.logManager.cleaner()).foreach((Function1<BrokerReconfigurable, Object> & Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$2(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
            serializable6 = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable6 = this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
            serializable5 = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable5 = this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.clusterLinkManager.foreach((Function1<ClusterLinkFactory.LinkManager, Object> & Serializable)x$7 -> {
                x$7.startup(x$7.startup$default$1());
                return BoxedUnit.UNIT;
            });
            serializable4 = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable4 = this.fatalFaultHandler.handleFault("Error starting ClusterLinkManager", t);
        }
        try {
            this.groupCoordinator.startup(() -> BoxesRunTime.unboxToInt($this.metadataCache.numPartitions("__consumer_offsets").getOrElse(() -> $this.conf.groupCoordinatorConfig().offsetsTopicPartitions())));
            serializable3 = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable3 = this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            this.txnCoordinator.startup(() -> BoxesRunTime.unboxToInt($this.metadataCache.numPartitions("__transaction_state").getOrElse(() -> $this.conf.transactionLogConfig().transactionTopicPartitions())), this.txnCoordinator.startup$default$2());
            serializable2 = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable2 = this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
        }
        try {
            this.quotaCoordinatorOpt.foreach((Function1<QuotaCoordinator, Object> & Serializable)x$8 -> {
                x$8.startup(() -> BoxesRunTime.unboxToInt($this.metadataCache.numPartitions("_confluent-quotas").getOrElse(() -> Predef$.MODULE$.Integer2int($this.conf.confluentConfig().quotasTopicPartitions()))));
                return BoxedUnit.UNIT;
            });
            serializable = BoxedUnit.UNIT;
        }
        catch (Throwable t) {
            serializable = this.fatalFaultHandler.handleFault("Error starting QuotaCoordinator", t);
        }
        if (this.conf.shareGroupConfig().isShareGroupEnabled() && this.shareCoordinator.isDefined()) {
            try {
                this.shareCoordinator.get().startup(() -> BoxesRunTime.unboxToInt($this.metadataCache.numPartitions("__share_group_state").getOrElse(() -> $this.conf.shareCoordinatorConfig().shareCoordinatorStateTopicNumPartitions())));
            }
            catch (Throwable t) {
                this.fatalFaultHandler.handleFault("Error starting Share coordinator", t);
            }
            return;
        }
    }

    private void finishInitializingReplicaManager() {
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
        }
    }

    @Override
    public void close() {
        this.firstPublishFuture().completeExceptionally(new TimeoutException());
    }

    private static final String metadataVersionLogMsg$1(MetadataImage newImage$1) {
        return "metadata.version " + newImage$1.features().metadataVersion();
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$10(BrokerMetadataPublisher $this, int partitionIndex, Option leaderEpochOpt) {
        $this.shareCoordinator.get().onResignation(partitionIndex, $this.toOptionalInt(leaderEpochOpt));
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$26(BrokerMetadataPublisher $this, ScramDelta scramDelta) {
        scramDelta.changes().forEach((x0$1, x1$1) -> {
            Tuple2<ScramMechanism, Map> tuple2 = new Tuple2<ScramMechanism, Map>((ScramMechanism)x0$1, (Map)x1$1);
            if (tuple2 != null) {
                ScramMechanism mechanism = tuple2._1();
                Map userChanges = tuple2._2();
                userChanges.forEach((x0$2, x1$2) -> {
                    Tuple2<String, Optional> tuple2 = new Tuple2<String, Optional>((String)x0$2, (Optional)x1$2);
                    if (tuple2 != null) {
                        String userName = tuple2._1();
                        Optional change = tuple2._2();
                        if (change.isPresent()) {
                            $this.credentialProvider.updateCredential(mechanism, userName, ((ScramCredentialData)change.get()).toCredential(mechanism));
                            return;
                        }
                        $this.credentialProvider.removeCredentials(mechanism, userName);
                        return;
                    }
                    throw new MatchError(tuple2);
                });
                return;
            }
            throw new MatchError(tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    resignation$1.apply(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int((Integer)entry.getKey())), None$.MODULE$);
                    return;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation$1.apply(BoxesRunTime.boxToInteger(topicPartition.partition()), None$.MODULE$));
        changes.electedLeaders().forEach((topicPartition, partitionInfo) -> election$1.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation$1.apply(BoxesRunTime.boxToInteger(topicPartition.partition()), new Some<Integer>(BoxesRunTime.boxToInteger(partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$2(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.conf.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(String clusterId, KafkaConfig conf, KRaftImageMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, Option<ShareCoordinator> shareCoordinator, DynamicConfigPublisher dynamicConfigPublisher, DynamicClientQuotaPublisher dynamicClientQuotaPublisher, ScramPublisher scramPublisher, DelegationTokenPublisher delegationTokenPublisher, AclPublisher aclPublisher, CredentialProvider credentialProvider, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler, Option<ClusterLinkFactory.LinkManager> clusterLinkManager, Option<TierDeletedPartitionsCoordinator> tieredCoordinator, Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt, Option<TierTopicSnapshotCoordinator> tierTopicSnapshotCoordinatorOpt, Option<QuotaCoordinator> quotaCoordinatorOpt, GroupCoordinatorDeletedTopicsPublisher groupCoordinatorDeletedTopicsPublisher) {
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.shareCoordinator = shareCoordinator;
        this.dynamicConfigPublisher = dynamicConfigPublisher;
        this.dynamicClientQuotaPublisher = dynamicClientQuotaPublisher;
        this.scramPublisher = scramPublisher;
        this.delegationTokenPublisher = delegationTokenPublisher;
        this.aclPublisher = aclPublisher;
        this.credentialProvider = credentialProvider;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        this.clusterLinkManager = clusterLinkManager;
        this.tieredCoordinator = tieredCoordinator;
        this.backupObjectLifecycleManagerCoordinatorOpt = backupObjectLifecycleManagerCoordinatorOpt;
        this.tierTopicSnapshotCoordinatorOpt = tierTopicSnapshotCoordinatorOpt;
        this.quotaCoordinatorOpt = quotaCoordinatorOpt;
        this.groupCoordinatorDeletedTopicsPublisher = groupCoordinatorDeletedTopicsPublisher;
        Logging.$init$(this);
        this.logIdent_$eq("[BrokerMetadataPublisher id=" + conf.nodeId() + "] ");
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
        this.firstPublishFuture = new CompletableFuture();
    }
}

