/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.OptionalDouble;
import kafka.network.ConnectionQuotas;
import kafka.network.FetchRequestInterceptor;
import kafka.network.ProduceRequestInterceptor;
import kafka.server.ClientQuotaManager;
import kafka.server.MetadataRequestMinimumThrottleConfig;
import kafka.server.QuotaFactory;
import kafka.server.metadata.ClientIdEntity;
import kafka.server.metadata.ClientQuotaMetadataManager$;
import kafka.server.metadata.DefaultClientIdEntity$;
import kafka.server.metadata.DefaultIpEntity$;
import kafka.server.metadata.DefaultTenantEntity$;
import kafka.server.metadata.DefaultUserDefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserEntity$;
import kafka.server.metadata.DefaultUserExplicitClientIdEntity;
import kafka.server.metadata.ExplicitUserDefaultClientIdEntity;
import kafka.server.metadata.ExplicitUserExplicitClientIdEntity;
import kafka.server.metadata.IpEntity;
import kafka.server.metadata.QuotaEntity;
import kafka.server.metadata.TenantEntity;
import kafka.server.metadata.UserEntity;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.image.ClientQuotaDelta;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.server.authorizer.AuthorizerConfig;
import org.apache.kafka.server.policy.CreateClusterLinkPolicy;
import org.apache.kafka.server.quota.ClientQuotaEntity;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001\u0002\u000f\u001e\u0001\u0011B\u0011\"\r\u0001\u0003\u0006\u0004%\t!\b\u001a\t\u0011\u0005\u0003!\u0011!Q\u0001\nMB\u0011B\u0011\u0001\u0003\u0006\u0004%\t!H\"\t\u0011)\u0003!\u0011!Q\u0001\n\u0011C\u0011b\u0013\u0001\u0003\u0006\u0004%\t!\b'\t\u0011q\u0003!\u0011!Q\u0001\n5C\u0011\"\u0018\u0001\u0003\u0006\u0004%\t!\b0\t\u0011\r\u0004!\u0011!Q\u0001\n}C\u0011\u0002\u001a\u0001\u0003\u0006\u0004%\t!H3\t\u0011A\u0004!\u0011!Q\u0001\n\u0019D\u0011\"\u001d\u0001\u0003\u0006\u0004%\t!\b:\t\u0011]\u0004!\u0011!Q\u0001\nMD\u0011\u0002\u001f\u0001\u0003\u0006\u0004%\t!H=\t\u0011y\u0004!\u0011!Q\u0001\niD!b \u0001\u0003\u0006\u0004%\t!HA\u0001\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111\u0001\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\u000b\u0001\t\u0013\t)\u0005\u0003\u0005\u0002f\u0001!\t!HA4\u0011\u001d\t)\b\u0001C\u0005\u0003oBq!a \u0001\t\u0013\t\tiB\u0004\u0002(vA\t!!+\u0007\rqi\u0002\u0012AAV\u0011\u001d\t\u0019\u0002\u0007C\u0001\u0003[Cq!a,\u0019\t\u0003\t\t\fC\u0005\u0002rb\t\n\u0011\"\u0001\u0002t\nQ2\t\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe*\u0011adH\u0001\t[\u0016$\u0018\rZ1uC*\u0011\u0001%I\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\t\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001K-\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\"\u0003\u0015)H/\u001b7t\u0013\t\u0001TFA\u0004M_\u001e<\u0017N\\4\u0002\u001bE,x\u000e^1NC:\fw-\u001a:t+\u0005\u0019\u0004C\u0001\u001b?\u001d\t)DH\u0004\u00027w9\u0011qGO\u0007\u0002q)\u0011\u0011hI\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!\u0001I\u0011\n\u0005uz\u0012\u0001D)v_R\fg)Y2u_JL\u0018BA A\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0011QhH\u0001\u000fcV|G/Y'b]\u0006<WM]:!\u0003A\u0019wN\u001c8fGRLwN\\)v_R\f7/F\u0001E!\t)\u0005*D\u0001G\u0015\t9\u0015%A\u0004oKR<xN]6\n\u0005%3%\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\u001baJ|G-^2feN#\u0018\r^3NC:\fw-\u001a:D_:4\u0017nZ\u000b\u0002\u001bB\u0011aJW\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0004Y><'B\u0001*T\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002U+\u000691\u000f^8sC\u001e,'B\u0001\u0012W\u0015\t9\u0006,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0006\u0019qN]4\n\u0005m{%A\u0007)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0017a\u00079s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0007%\u0001\u0013nKR\fG-\u0019;b%\u0016\fX/Z:u\u001b&t\u0017.\\;n)\"\u0014x\u000e\u001e;mK\u000e{gNZ5h+\u0005y\u0006C\u00011b\u001b\u0005y\u0012B\u00012 \u0005\u0011jU\r^1eCR\f'+Z9vKN$X*\u001b8j[VlG\u000b\u001b:piRdWmQ8oM&<\u0017!J7fi\u0006$\u0017\r^1SKF,Xm\u001d;NS:LW.^7UQJ|G\u000f\u001e7f\u0007>tg-[4!\u0003M\tW\u000f\u001e5pe&TXM]\"p]\u001aLwm\u00149u+\u00051\u0007c\u0001\u0014hS&\u0011\u0001n\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005)tW\"A6\u000b\u00051l\u0017AC1vi\"|'/\u001b>fe*\u0011\u0001%V\u0005\u0003_.\u0014\u0001#Q;uQ>\u0014\u0018N_3s\u0007>tg-[4\u0002)\u0005,H\u000f[8sSj,'oQ8oM&<w\n\u001d;!\u0003i1W\r^2i%\u0016\fX/Z:u\u0013:$XM]2faR|'o\u00149u+\u0005\u0019\bc\u0001\u0014hiB\u0011Q)^\u0005\u0003m\u001a\u0013qCR3uG\"\u0014V-];fgRLe\u000e^3sG\u0016\u0004Ho\u001c:\u00027\u0019,Go\u00195SKF,Xm\u001d;J]R,'oY3qi>\u0014x\n\u001d;!\u0003q\u0001(o\u001c3vG\u0016\u0014V-];fgRLe\u000e^3sG\u0016\u0004Ho\u001c:PaR,\u0012A\u001f\t\u0004M\u001d\\\bCA#}\u0013\tihIA\rQe>$WoY3SKF,Xm\u001d;J]R,'oY3qi>\u0014\u0018!\b9s_\u0012,8-\u001a*fcV,7\u000f^%oi\u0016\u00148-\u001a9u_J|\u0005\u000f\u001e\u0011\u00025\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7\u000eU8mS\u000eLx\n\u001d;\u0016\u0005\u0005\r\u0001\u0003\u0002\u0014h\u0003\u000b\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017i\u0017A\u00029pY&\u001c\u00170\u0003\u0003\u0002\u0010\u0005%!aF\"sK\u0006$Xm\u00117vgR,'\u000fT5oWB{G.[2z\u0003m\u0019'/Z1uK\u000ecWo\u001d;fe2Kgn\u001b)pY&\u001c\u0017p\u00149uA\u00051A(\u001b8jiz\"\"#a\u0006\u0002\u001c\u0005u\u0011qDA\u0011\u0003G\t)#a\n\u0002*A\u0019\u0011\u0011\u0004\u0001\u000e\u0003uAQ!M\tA\u0002MBQAQ\tA\u0002\u0011CQaS\tA\u00025CQ!X\tA\u0002}CQ\u0001Z\tA\u0002\u0019DQ!]\tA\u0002MDQ\u0001_\tA\u0002iD\u0001b`\t\u0011\u0002\u0003\u0007\u00111A\u0001\u0007kB$\u0017\r^3\u0015\t\u0005=\u0012Q\u0007\t\u0004M\u0005E\u0012bAA\u001aO\t!QK\\5u\u0011\u001d\t9D\u0005a\u0001\u0003s\t1\"];pi\u0006\u001cH)\u001a7uCB!\u00111HA!\u001b\t\tiDC\u0002\u0002@U\u000bQ![7bO\u0016LA!a\u0011\u0002>\t\t2\t\\5f]R\fVo\u001c;bg\u0012+G\u000e^1\u0015\r\u0005=\u0012qIA.\u0011\u001d\tIe\u0005a\u0001\u0003\u0017\na!\u001a8uSRL\b\u0003BA'\u0003/j!!a\u0014\u000b\t\u0005E\u00131K\u0001\u0006cV|G/\u0019\u0006\u0004\u0003+*\u0016AB2p[6|g.\u0003\u0003\u0002Z\u0005=#!E\"mS\u0016tG/U;pi\u0006,e\u000e^5us\"9\u0011QL\nA\u0002\u0005}\u0013AC9v_R\fG)\u001a7uCB!\u00111HA1\u0013\u0011\t\u0019'!\u0010\u0003!\rc\u0017.\u001a8u#V|G/\u0019#fYR\f\u0017!\u00045b]\u0012dW-\u00139Rk>$\u0018\r\u0006\u0004\u00020\u0005%\u00141\u000f\u0005\b\u0003W\"\u0002\u0019AA7\u0003!I\u0007/\u00128uSRL\b\u0003BA\r\u0003_J1!!\u001d\u001e\u0005-\tVo\u001c;b\u000b:$\u0018\u000e^=\t\u000f\u0005uC\u00031\u0001\u0002`\u0005\t\u0002.\u00198eY\u0016$VM\\1oiF+x\u000e^1\u0015\r\u0005=\u0012\u0011PA?\u0011\u001d\tY(\u0006a\u0001\u0003[\nA\u0002^3oC:$XI\u001c;jifDq!!\u0018\u0016\u0001\u0004\ty&A\u000eiC:$G.Z+tKJ\u001cE.[3oiF+x\u000e^1DQ\u0006tw-\u001a\u000b\t\u0003_\t\u0019)a\"\u0002\u001c\"9\u0011Q\u0011\fA\u0002\u00055\u0014aC9v_R\fWI\u001c;jifDq!!#\u0017\u0001\u0004\tY)A\u0002lKf\u0004B!!$\u0002\u0016:!\u0011qRAI!\t9t%C\u0002\u0002\u0014\u001e\na\u0001\u0015:fI\u00164\u0017\u0002BAL\u00033\u0013aa\u0015;sS:<'bAAJO!9\u0011Q\u0014\fA\u0002\u0005}\u0015\u0001\u00038foZ\u000bG.^3\u0011\t\u0019:\u0017\u0011\u0015\t\u0004M\u0005\r\u0016bAASO\t1Ai\\;cY\u0016\f!d\u00117jK:$\u0018+^8uC6+G/\u00193bi\u0006l\u0015M\\1hKJ\u00042!!\u0007\u0019'\tAR\u0005\u0006\u0002\u0002*\u0006YBO]1og\u001a,'\u000fV8DY&,g\u000e^)v_R\fWI\u001c;jif$B!a-\u0002pB9a%!.\u0002:\u0006%\u0017bAA\\O\t1A+\u001e9mKJ\u0002BAJ4\u0002<B!\u0011QXAb\u001d\r)\u0014qX\u0005\u0004\u0003\u0003|\u0012AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJLA!!2\u0002H\nq!)Y:f+N,'/\u00128uSRL(bAAa?A!aeZAf!\u0011\ti-!;\u000f\t\u0005=\u00171\u001d\b\u0005\u0003#\f\tO\u0004\u0003\u0002T\u0006}g\u0002BAk\u0003;tA!a6\u0002\\:\u0019q'!7\n\u0003eK!a\u0016-\n\u0005\t2\u0016B\u0001\u0011V\u0013\r\t\t&\\\u0005\u0005\u0003K\f9/A\tDY&,g\u000e^)v_R\fWI\u001c;jifT1!!\u0015n\u0013\u0011\tY/!<\u0003\u0019\r{gNZ5h\u000b:$\u0018\u000e^=\u000b\t\u0005\u0015\u0018q\u001d\u0005\b\u0003\u000bS\u0002\u0019AA7\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u0011\u0011Q\u001f\u0016\u0005\u0003\u0007\t9p\u000b\u0002\u0002zB!\u00111 B\u0003\u001b\t\tiP\u0003\u0003\u0002\u0000\n\u0005\u0011!C;oG\",7m[3e\u0015\r\u0011\u0019aJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0004\u0003{\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ClientQuotaMetadataManager
implements Logging {
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final ConnectionQuotas connectionQuotas;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig;
    private final Option<AuthorizerConfig> authorizerConfigOpt;
    private final Option<FetchRequestInterceptor> fetchRequestInterceptorOpt;
    private final Option<ProduceRequestInterceptor> produceRequestInterceptorOpt;
    private final Option<CreateClusterLinkPolicy> createClusterLinkPolicyOpt;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<CreateClusterLinkPolicy> $lessinit$greater$default$8() {
        return ClientQuotaMetadataManager$.MODULE$.$lessinit$greater$default$8();
    }

    public static Tuple2<Option<ClientQuotaManager.BaseUserEntity>, Option<ClientQuotaEntity.ConfigEntity>> transferToClientQuotaEntity(QuotaEntity quotaEntity) {
        return ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity(quotaEntity);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClientQuotaMetadataManager clientQuotaMetadataManager = this;
        synchronized (clientQuotaMetadataManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig() {
        return this.metadataRequestMinimumThrottleConfig;
    }

    public Option<AuthorizerConfig> authorizerConfigOpt() {
        return this.authorizerConfigOpt;
    }

    public Option<FetchRequestInterceptor> fetchRequestInterceptorOpt() {
        return this.fetchRequestInterceptorOpt;
    }

    public Option<ProduceRequestInterceptor> produceRequestInterceptorOpt() {
        return this.produceRequestInterceptorOpt;
    }

    public Option<CreateClusterLinkPolicy> createClusterLinkPolicyOpt() {
        return this.createClusterLinkPolicyOpt;
    }

    public void update(ClientQuotasDelta quotasDelta) {
        quotasDelta.changes().forEach((key, value) -> this.update((ClientQuotaEntity)key, (ClientQuotaDelta)value));
    }

    private void update(ClientQuotaEntity entity, ClientQuotaDelta quotaDelta) {
        if (entity.entries().containsKey("ip")) {
            Product product;
            Option option = Option$.MODULE$.apply(entity.entries().get("ip"));
            if (option instanceof Some) {
                Some some = (Some)option;
                String ip = (String)some.value();
                product = new IpEntity(ip);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultIpEntity$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            DefaultIpEntity$ ipEntity = product;
            this.handleIpQuota(ipEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("confluent-tenant")) {
            Product product;
            Option option = Option$.MODULE$.apply(entity.entries().get("confluent-tenant"));
            if (option instanceof Some) {
                Some some = (Some)option;
                String tenant = (String)some.value();
                product = new TenantEntity(tenant);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultTenantEntity$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            DefaultTenantEntity$ tenantEntity = product;
            this.handleTenantQuota(tenantEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("user") || entity.entries().containsKey("client-id")) {
            String userVal = (String)entity.entries().get("user");
            String clientIdVal = (String)entity.entries().get("client-id");
            Product userClientEntity = entity.entries().containsKey("user") && entity.entries().containsKey("client-id") ? (userVal == null && clientIdVal == null ? DefaultUserDefaultClientIdEntity$.MODULE$ : (userVal == null ? new DefaultUserExplicitClientIdEntity(clientIdVal) : (clientIdVal == null ? new ExplicitUserDefaultClientIdEntity(userVal) : new ExplicitUserExplicitClientIdEntity(userVal, clientIdVal)))) : (entity.entries().containsKey("user") ? (userVal == null ? DefaultUserEntity$.MODULE$ : new UserEntity(userVal)) : (clientIdVal == null ? DefaultClientIdEntity$.MODULE$ : new ClientIdEntity(clientIdVal)));
            quotaDelta.changes().forEach((key, value) -> this.handleUserClientQuotaChange((QuotaEntity)((Object)userClientEntity), (String)key, OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble((OptionalDouble)value))));
            return;
        }
        this.warn((Function0<String> & Serializable)() -> "Ignoring unsupported quota entity " + entity + ".");
    }

    public void handleIpQuota(QuotaEntity ipEntity, ClientQuotaDelta quotaDelta) {
        Option option;
        QuotaEntity quotaEntity = ipEntity;
        if (quotaEntity instanceof IpEntity) {
            IpEntity ipEntity2 = (IpEntity)quotaEntity;
            String ip = ipEntity2.ip();
            try {
                option = new Some<InetAddress>(InetAddress.getByName(ip));
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("Unable to resolve address " + ip);
            }
        } else if (DefaultIpEntity$.MODULE$.equals(quotaEntity)) {
            option = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle IP quota entities here");
        }
        None$ inetAddress = option;
        quotaDelta.changes().forEach((key, value) -> {
            String quotaName = key;
            OptionalDouble quotaValue = value;
            if (!quotaName.equals("connection_creation_rate")) {
                this.warn((Function0<String> & Serializable)() -> "Ignoring unexpected quota key " + quotaName + " for entity " + ipEntity);
                return;
            }
            try {
                this.connectionQuotas().updateIpConnectionRateQuota(inetAddress, OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)));
            }
            catch (Throwable t) {
                this.error((Function0<String> & Serializable)() -> "Failed to update IP quota " + ipEntity, (Function0<Throwable> & Serializable)() -> t);
            }
        });
    }

    private void handleTenantQuota(QuotaEntity tenantEntity, ClientQuotaDelta quotaDelta) {
        Option option;
        QuotaEntity quotaEntity = tenantEntity;
        if (quotaEntity instanceof TenantEntity) {
            TenantEntity tenantEntity2 = (TenantEntity)quotaEntity;
            String tenant = tenantEntity2.tenant();
            option = new Some<String>(tenant);
        } else if (DefaultTenantEntity$.MODULE$.equals(quotaEntity)) {
            option = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle tenant quota entities here");
        }
        Option tenantOpt = option;
        quotaDelta.changes().entrySet().forEach(e -> {
            String quotaName = (String)e.getKey();
            OptionalDouble quotaValue = (OptionalDouble)e.getValue();
            if (quotaName.equals("connection_creation_rate")) {
                try {
                    this.connectionQuotas().updateTenantConnectionRateQuota(tenantOpt, OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)));
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("producer_id_expiration_ms")) {
                try {
                    Optional<Integer> quotaValueIntOpt = OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map(x$1 -> (int)x$1).map((Function1<Object, Integer> & Serializable)x -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$5(BoxesRunTime.unboxToInt(x)))));
                    this.info((Function0<String> & Serializable)() -> "Setting tenant-level producer ID expiration for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt)) + " to " + quotaValueIntOpt);
                    this.producerStateManagerConfig().setProducerIdExpirationMs(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt)), quotaValueIntOpt);
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("metadata_request_minimum_throttle_ms")) {
                try {
                    Option<Object> quotaValueIntOpt = OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map(x$2 -> (int)x$2);
                    this.info((Function0<String> & Serializable)() -> "Setting tenant-level metadata request minimum throttle for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt)) + " to " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(quotaValueIntOpt)));
                    this.metadataRequestMinimumThrottleConfig().setMinimumThrottle(tenantOpt, quotaValueIntOpt);
                    this.debug((Function0<String> & Serializable)() -> String.valueOf(this.metadataRequestMinimumThrottleConfig()));
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("connection_creation_count")) {
                try {
                    this.connectionQuotas().updateTenantConnectionCountQuota(tenantOpt, OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map(x$3 -> (int)x$3).map(x -> Predef$.MODULE$.Integer2int(BoxesRunTime.boxToInteger(x))));
                    this.info((Function0<String> & Serializable)() -> "Setting tenant connection count quota " + OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt)) + " to " + quotaValue);
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("acl_count")) {
                try {
                    this.authorizerConfigOpt().foreach((Function1<AuthorizerConfig, Object> & Serializable)authorizerConfig -> {
                        ClientQuotaMetadataManager.$anonfun$handleTenantQuota$19(this, tenantOpt, quotaValue, authorizerConfig);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("source_link_count") || quotaName.equals("destination_link_count")) {
                try {
                    this.createClusterLinkPolicyOpt().foreach((Function1<CreateClusterLinkPolicy, Object> & Serializable)policy -> {
                        ClientQuotaMetadataManager.$anonfun$handleTenantQuota$25(this, quotaValue, quotaName, tenantOpt, policy);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("reject_all_fetches")) {
                try {
                    tenantOpt.foreach((Function1<String, Object> & Serializable)tenant -> {
                        ClientQuotaMetadataManager.$anonfun$handleTenantQuota$32(this, quotaValue, tenant);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            if (quotaName.equals("reject_all_produces")) {
                try {
                    tenantOpt.foreach((Function1<String, Object> & Serializable)tenant -> {
                        ClientQuotaMetadataManager.$anonfun$handleTenantQuota$38(this, quotaValue, tenant);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.error((Function0<String> & Serializable)() -> "Failed to update tenant quota " + tenantEntity, (Function0<Throwable> & Serializable)() -> t);
                }
                return;
            }
            this.warn((Function0<String> & Serializable)() -> "Ignoring unexpected quota key " + quotaName + " for entity " + tenantEntity);
        });
    }

    private void handleUserClientQuotaChange(QuotaEntity quotaEntity, String key, Option<Object> newValue) {
        ClientQuotaManager clientQuotaManager;
        block9: {
            String string = key;
            switch (string == null ? 0 : string.hashCode()) {
                case -1805480786: {
                    if (!"consumer_byte_rate".equals(string)) break;
                    clientQuotaManager = this.quotaManagers().fetch();
                    break block9;
                }
                case -965904822: {
                    if (!"request_percentage".equals(string)) break;
                    clientQuotaManager = this.quotaManagers().request();
                    break block9;
                }
                case -832502454: {
                    if (!"producer_byte_rate".equals(string)) break;
                    clientQuotaManager = this.quotaManagers().produce();
                    break block9;
                }
                case -748852909: {
                    if (!"controller_mutation_rate".equals(string)) break;
                    clientQuotaManager = this.quotaManagers().controllerMutation();
                    break block9;
                }
            }
            this.warn((Function0<String> & Serializable)() -> "Ignoring unexpected quota key " + key + " for entity " + quotaEntity);
            return;
        }
        ClientQuotaManager manager = clientQuotaManager;
        Tuple2<Option<ClientQuotaManager.BaseUserEntity>, Option<ClientQuotaEntity.ConfigEntity>> tuple2 = ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option<ClientQuotaManager.BaseUserEntity> userEntity = tuple2._1();
        Option<ClientQuotaEntity.ConfigEntity> clientEntity = tuple2._2();
        Tuple2<Option<ClientQuotaManager.BaseUserEntity>, Option<ClientQuotaEntity.ConfigEntity>> tuple22 = new Tuple2<Option<ClientQuotaManager.BaseUserEntity>, Option<ClientQuotaEntity.ConfigEntity>>(userEntity, clientEntity);
        Option<ClientQuotaManager.BaseUserEntity> userEntity2 = tuple22._1();
        Option<ClientQuotaEntity.ConfigEntity> clientEntity2 = tuple22._2();
        Option<Quota> quotaValue = newValue.map((Function1<Object, Quota> & Serializable)x$7 -> ClientQuotaMetadataManager.$anonfun$handleUserClientQuotaChange$2(BoxesRunTime.unboxToDouble(x$7)));
        try {
            manager.updateQuota(userEntity2, clientEntity2, quotaValue);
        }
        catch (Throwable t) {
            this.error((Function0<String> & Serializable)() -> "Failed to update user-client quota " + quotaEntity, (Function0<Throwable> & Serializable)() -> t);
        }
    }

    public static final /* synthetic */ Integer $anonfun$handleTenantQuota$5(int x) {
        return BoxesRunTime.boxToInteger(x);
    }

    public static final /* synthetic */ Integer $anonfun$handleTenantQuota$21(int x) {
        return BoxesRunTime.boxToInteger(x);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$19(ClientQuotaMetadataManager $this, Option tenantOpt$1, OptionalDouble quotaValue$1, AuthorizerConfig authorizerConfig) {
        authorizerConfig.setTenantMaxAcls(OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)), OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue$1)).map(x$4 -> (int)x$4).map((Function1<Object, Integer> & Serializable)x -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$21(BoxesRunTime.unboxToInt(x))))));
        $this.info((Function0<String> & Serializable)() -> "Setting tenant-level max acl count limit for tenant " + OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)) + " to " + quotaValue$1);
    }

    public static final /* synthetic */ Integer $anonfun$handleTenantQuota$27(int x) {
        return BoxesRunTime.boxToInteger(x);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$25(ClientQuotaMetadataManager $this, OptionalDouble quotaValue$1, String quotaName$2, Option tenantOpt$1, CreateClusterLinkPolicy policy) {
        Option maxLinks = OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue$1)).map(x$5 -> (int)x$5).map((Function1<Object, Integer> & Serializable)x -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$27(BoxesRunTime.unboxToInt(x)));
        if (quotaName$2.equals("source_link_count")) {
            policy.setTenantMaxSourceLinks(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(maxLinks)));
            $this.info((Function0<String> & Serializable)() -> "Setting tenant-level max source link count limit for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)) + " to " + quotaValue$1);
            return;
        }
        policy.setTenantMaxDestLinks(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(maxLinks)));
        $this.info((Function0<String> & Serializable)() -> "Setting tenant-level max destination link count limit for tenant " + OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(tenantOpt$1)) + " to " + quotaValue$1);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$33(ClientQuotaMetadataManager $this, OptionalDouble quotaValue$1, String tenant$1, FetchRequestInterceptor fetchRequestInterceptorOpt) {
        boolean quotaValueAsBool;
        boolean bl = quotaValue$1.isPresent() ? quotaValue$1.getAsDouble() == 1.0 : (quotaValueAsBool = false);
        if (quotaValueAsBool) {
            $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to intercept fetch requests from tenant " + tenant$1);
            fetchRequestInterceptorOpt.ignoreRequestsFromTenant(tenant$1);
            return;
        }
        $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to accept fetch requests from tenant " + tenant$1);
        fetchRequestInterceptorOpt.acceptRequestsFromTenant(tenant$1);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$32(ClientQuotaMetadataManager $this, OptionalDouble quotaValue$1, String tenant) {
        $this.fetchRequestInterceptorOpt().foreach((Function1<FetchRequestInterceptor, Object> & Serializable)fetchRequestInterceptorOpt -> {
            ClientQuotaMetadataManager.$anonfun$handleTenantQuota$33($this, quotaValue$1, tenant, fetchRequestInterceptorOpt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$39(ClientQuotaMetadataManager $this, OptionalDouble quotaValue$1, String tenant$2, ProduceRequestInterceptor produceRequestInterceptor) {
        boolean quotaValueAsBool;
        boolean bl = quotaValue$1.isPresent() ? quotaValue$1.getAsDouble() == 1.0 : (quotaValueAsBool = false);
        if (quotaValueAsBool) {
            $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to intercept produce requests from tenant " + tenant$2);
            produceRequestInterceptor.ignoreRequestsFromTenant(tenant$2);
            return;
        }
        $this.info((Function0<String> & Serializable)() -> "Setting tenant-level config to accept produce requests from tenant " + tenant$2);
        produceRequestInterceptor.acceptRequestsFromTenant(tenant$2);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$38(ClientQuotaMetadataManager $this, OptionalDouble quotaValue$1, String tenant) {
        $this.produceRequestInterceptorOpt().foreach((Function1<ProduceRequestInterceptor, Object> & Serializable)produceRequestInterceptor -> {
            ClientQuotaMetadataManager.$anonfun$handleTenantQuota$39($this, quotaValue$1, tenant, produceRequestInterceptor);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Quota $anonfun$handleUserClientQuotaChange$2(double x$7) {
        return new Quota(x$7, true);
    }

    public ClientQuotaMetadataManager(QuotaFactory.QuotaManagers quotaManagers, ConnectionQuotas connectionQuotas, ProducerStateManagerConfig producerStateManagerConfig, MetadataRequestMinimumThrottleConfig metadataRequestMinimumThrottleConfig, Option<AuthorizerConfig> authorizerConfigOpt, Option<FetchRequestInterceptor> fetchRequestInterceptorOpt, Option<ProduceRequestInterceptor> produceRequestInterceptorOpt, Option<CreateClusterLinkPolicy> createClusterLinkPolicyOpt) {
        this.quotaManagers = quotaManagers;
        this.connectionQuotas = connectionQuotas;
        this.producerStateManagerConfig = producerStateManagerConfig;
        this.metadataRequestMinimumThrottleConfig = metadataRequestMinimumThrottleConfig;
        this.authorizerConfigOpt = authorizerConfigOpt;
        this.fetchRequestInterceptorOpt = fetchRequestInterceptorOpt;
        this.produceRequestInterceptorOpt = produceRequestInterceptorOpt;
        this.createClusterLinkPolicyOpt = createClusterLinkPolicyOpt;
        Logging.$init$(this);
    }
}

