/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import kafka.server.CachedControllerId;
import kafka.server.KRaftCachedControllerId$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.immutable.ImmutableMap;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\u0011mc\u0001B A\u0001\u001dC\u0001\"\u0016\u0001\u0003\u0006\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0011)A\u0005/\"A1\f\u0001BC\u0002\u0013\u0005A\f\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003^\u0011\u0015!\b\u0001\"\u0001v\u0011\u001dI\b\u00011A\u0005\niD\u0011\"a\u0001\u0001\u0001\u0004%I!!\u0002\t\u000f\u0005E\u0001\u0001)Q\u0005w\"9\u00111\u0004\u0001\u0005\n\u0005u\u0001bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003?\u0002A\u0011BA1\u0011\u001d\t9\r\u0001C\u0005\u0003\u0013Dq!a=\u0001\t\u0013\t)\u0010C\u0004\u0003\n\u0001!IAa\u0003\t\u000f\tm\u0001\u0001\"\u0003\u0003\u001e!9!1\u0005\u0001\u0005\n\t\u0015\u0002b\u0002B\u001d\u0001\u0011\u0005#1\b\u0005\n\u0005?\u0002\u0011\u0013!C\u0001\u0005CB\u0011Ba\u001e\u0001#\u0003%\tA!\u0019\t\u000f\te\u0004\u0001\"\u0011\u0003|!9!1\u0011\u0001\u0005B\t\u0015\u0005b\u0002BT\u0001\u0011\u0005#\u0011\u0016\u0005\b\u0005k\u0003A\u0011\tB\\\u0011\u001d\u0011\t\r\u0001C!\u0005\u0007DqA!3\u0001\t\u0003\u0012Y\rC\u0004\u0003X\u0002!\tE!7\t\u000f\tu\u0007\u0001\"\u0001\u0003`\"9!1\u001d\u0001\u0005\u0002\t\u0015\bb\u0002Bu\u0001\u0011\u0005#1\u001e\u0005\b\u0005S\u0004A\u0011\u0002B\u0000\u0011\u001d\u0019\u0019\u0001\u0001C!\u0007\u000bAqaa\u0003\u0001\t\u0003\u001ai\u0001C\u0004\u0004\u0012\u0001!\tea\u0005\t\u000f\re\u0001\u0001\"\u0011\u0004\u001c!91q\u0004\u0001\u0005B\r\u0005\u0002bBB\u0019\u0001\u0011\u000511\u0007\u0005\b\u0007\u000b\u0002A\u0011AB$\u0011\u001d\u0019y\u0005\u0001C\u0001\u0007#Bqa!\u0016\u0001\t\u0003\u001a9\u0006C\u0004\u0004^\u0001!\tea\u0018\t\u000f\r\u0015\u0004\u0001\"\u0011\u0004h!911\u000e\u0001\u0005B\r5\u0004bBB9\u0001\u0011\u000531\u000f\u0005\b\u0007w\u0002A\u0011IB?\u0011\u001d\u00199\t\u0001C!\u0007\u0013Cqa!&\u0001\t\u0003\u001a9\nC\u0004\u0004\u001a\u0002!Iaa'\t\u000f\r}\u0005\u0001\"\u0001\u0004\"\"91Q\u0016\u0001\u0005B\r=\u0006bBB_\u0001\u0011\u00053q\u0018\u0005\b\u0007{\u0003A\u0011IBb\u0011\u001d\u00199\r\u0001C!\u0007\u0013Dqaa4\u0001\t\u0003\ti\u0006C\u0004\u0004R\u0002!\tea5\t\u000f\r%\b\u0001\"\u0011\u0004l\"91Q \u0001\u0005B\r}\bb\u0002C\b\u0001\u0011\u0005C\u0011\u0003\u0005\b\t3\u0001A\u0011\tC\u000e\u0011\u001d!\u0019\u0003\u0001C!\tKAq\u0001\"\u000b\u0001\t\u0003\"Y\u0003C\u0004\u0005B\u0001!\t\u0005b\u0011\t\u000f\u0011]\u0003\u0001\"\u0011\u0005Z\t\u00112JU1gi6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0015\t\t%)\u0001\u0005nKR\fG-\u0019;b\u0015\t\u0019E)\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001I\u001dJ\u0003\"!\u0013'\u000e\u0003)S\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u0013a!\u00118z%\u00164\u0007CA(Q\u001b\u0005\u0001\u0015BA)A\u0005]Y%+\u00194u\u00136\fw-Z'fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002P'&\u0011A\u000b\u0011\u0002\u0011\u0007>tg-[4SKB|7/\u001b;pef\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002/B\u0011\u0011\nW\u0005\u00033*\u00131!\u00138u\u0003%\u0011'o\\6fe&#\u0007%\u0001\u000ble\u00064GOV3sg&|gnU;qa2LWM]\u000b\u0002;B\u0019a,Z4\u000e\u0003}S!\u0001Y1\u0002\u0011\u0019,hn\u0019;j_:T!AY2\u0002\tU$\u0018\u000e\u001c\u0006\u0002I\u0006!!.\u0019<b\u0013\t1wL\u0001\u0005TkB\u0004H.[3s!\tA\u0017/D\u0001j\u0015\tQ7.\u0001\u0004d_6lwN\u001c\u0006\u0003\u00072T!!R7\u000b\u00059|\u0017AB1qC\u000eDWMC\u0001q\u0003\ry'oZ\u0005\u0003e&\u0014Ab\u0013*bMR4VM]:j_:\fQc\u001b:bMR4VM]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0004m^D\bCA(\u0001\u0011\u0015)V\u00011\u0001X\u0011\u0015YV\u00011\u0001^\u00035y6-\u001e:sK:$\u0018*\\1hKV\t1\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007fY\u0006)\u0011.\\1hK&\u0019\u0011\u0011A?\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0003Ey6-\u001e:sK:$\u0018*\\1hK~#S-\u001d\u000b\u0005\u0003\u000f\ti\u0001E\u0002J\u0003\u0013I1!a\u0003K\u0005\u0011)f.\u001b;\t\u0011\u0005=q!!AA\u0002m\f1\u0001\u001f\u00132\u00039y6-\u001e:sK:$\u0018*\\1hK\u0002B3\u0001CA\u000b!\rI\u0015qC\u0005\u0004\u00033Q%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u000215\f\u0017PY3GS2$XM]!mSZ,'+\u001a9mS\u000e\f7\u000f\u0006\u0006\u0002 \u0005M\u0012QGA \u0003#\u0002b!!\t\u0002$\u0005\u001dR\"A1\n\u0007\u0005\u0015\u0012M\u0001\u0003MSN$\b\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u000552-\u0001\u0003mC:<\u0017\u0002BA\u0019\u0003W\u0011q!\u00138uK\u001e,'\u000fC\u0003\u007f\u0013\u0001\u00071\u0010C\u0004\u00028%\u0001\r!!\u000f\u0002\u000f\t\u0014xn[3sgB!\u0011*a\u000fX\u0013\r\tiD\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003\u0003J\u0001\u0019AA\"\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\t)%!\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nqA\\3uo>\u00148N\u0003\u0002kY&!\u0011qJA$\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u001d\t\u0019&\u0003a\u0001\u0003+\n!DZ5mi\u0016\u0014XK\\1wC&d\u0017M\u00197f\u000b:$\u0007o\\5oiN\u00042!SA,\u0013\r\tIF\u0013\u0002\b\u0005>|G.Z1o\u00031\u0019WO\u001d:f]RLU.Y4f)\u0005Y\u0018\u0001F4fiB\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0007\u0002d\u0005\u001d\u0016\u0011VA_\u0003\u007f\u000b\u0019\rE\u0003J\u0003K\nI'C\u0002\u0002h)\u0013aa\u00149uS>t\u0007CBA6\u0003w\n\tI\u0004\u0003\u0002n\u0005]d\u0002BA8\u0003kj!!!\u001d\u000b\u0007\u0005Md)\u0001\u0004=e>|GOP\u0005\u0002\u0017&\u0019\u0011\u0011\u0010&\u0002\u000fA\f7m[1hK&!\u0011QPA@\u0005!IE/\u001a:bi>\u0014(bAA=\u0015B!\u00111QAQ\u001d\u0011\t))a'\u000f\t\u0005\u001d\u0015q\u0013\b\u0005\u0003\u0013\u000b)J\u0004\u0003\u0002\f\u0006Me\u0002BAG\u0003#sA!a\u001c\u0002\u0010&\t\u0001/\u0003\u0002o_&\u0011Q)\\\u0005\u0003U2LA!!'\u0002L\u00059Q.Z:tC\u001e,\u0017\u0002BAO\u0003?\u000bA#T3uC\u0012\fG/\u0019*fgB|gn]3ECR\f'\u0002BAM\u0003\u0017JA!a)\u0002&\nIR*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a)beRLG/[8o\u0015\u0011\ti*a(\t\u000by\\\u0001\u0019A>\t\u000f\u0005-6\u00021\u0001\u0002.\u0006IAo\u001c9jG:\u000bW.\u001a\t\u0005\u0003_\u000b9L\u0004\u0003\u00022\u0006M\u0006cAA8\u0015&\u0019\u0011Q\u0017&\u0002\rA\u0013X\rZ3g\u0013\u0011\tI,a/\u0003\rM#(/\u001b8h\u0015\r\t)L\u0013\u0005\b\u0003\u0003Z\u0001\u0019AA\"\u0011\u001d\t\tm\u0003a\u0001\u0003+\n\u0011$\u001a:s_J,f.\u0019<bS2\f'\r\\3F]\u0012\u0004x.\u001b8ug\"9\u0011QY\u0006A\u0002\u0005U\u0013!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u0019&\u001cH/\u001a8feN\fAfZ3u!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fgi\u001c:EKN\u001c'/\u001b2f)>\u0004\u0018n\u0019*fgB|gn]3\u0015\u0019\u0005-\u0017Q]At\u0003S\fY/a<\u0011\r%\u000bi-!5X\u0013\r\tyM\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b%\u000b)'a5\u0011\r\u0005-\u0014Q[Al\u0013\u0011\t)#a \u0011\t\u0005e\u0017q\u001c\b\u0005\u0003\u000b\u000bY.\u0003\u0003\u0002^\u0006}\u0015a\t#fg\u000e\u0014\u0018NY3U_BL7\rU1si&$\u0018n\u001c8t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003C\f\u0019O\u0001\u0015EKN\u001c'/\u001b2f)>\u0004\u0018n\u0019)beRLG/[8ogJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|gN\u0003\u0003\u0002^\u0006}\u0005\"\u0002@\r\u0001\u0004Y\bbBAV\u0019\u0001\u0007\u0011Q\u0016\u0005\b\u0003\u0003b\u0001\u0019AA\"\u0011\u0019\ti\u000f\u0004a\u0001/\u0006Q1\u000f^1si&sG-\u001a=\t\r\u0005EH\u00021\u0001X\u0003!i\u0017\r_\"pk:$\u0018AE4fi>3g\r\\5oKJ+\u0007\u000f\\5dCN$\u0002\"a\b\u0002x\u0006e(q\u0001\u0005\u0006}6\u0001\ra\u001f\u0005\b\u0003wl\u0001\u0019AA\u007f\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0002\u0000\n\rQB\u0001B\u0001\u0015\t\tE.\u0003\u0003\u0003\u0006\t\u0005!!\u0006)beRLG/[8o%\u0016<\u0017n\u001d;sCRLwN\u001c\u0005\b\u0003\u0003j\u0001\u0019AA\"\u0003AI7OU3qY&\u001c\u0017m\u00144gY&tW\r\u0006\u0005\u0002V\t5!q\u0002B\t\u0011\u001d\tYP\u0004a\u0001\u0003{Dq!!\u0011\u000f\u0001\u0004\t\u0019\u0005C\u0004\u0003\u00149\u0001\rA!\u0006\u0002\r\t\u0014xn[3s!\u0011\tyPa\u0006\n\t\te!\u0011\u0001\u0002\u0013\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|g.A\u000bjgJ+\u0007\u000f\\5dC&swJ\u001a4mS:,G)\u001b:\u0015\r\u0005U#q\u0004B\u0011\u0011\u001d\u0011\u0019b\u0004a\u0001\u0005+Aq!a?\u0010\u0001\u0004\ti0\u0001\thKR\fE.\u001b<f\u000b:$\u0007o\\5oiRA!q\u0005B\u0019\u0005g\u00119\u0004E\u0003J\u0003K\u0012I\u0003\u0005\u0003\u0003,\t5RBAA&\u0013\u0011\u0011y#a\u0013\u0003\t9{G-\u001a\u0005\u0006}B\u0001\ra\u001f\u0005\u0007\u0005k\u0001\u0002\u0019A,\u0002\u0005%$\u0007bBA!!\u0001\u0007\u00111I\u0001\u0011O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$\"B!\u0010\u0003P\te#1\fB/!\u0019\u0011yD!\u0012\u0003J5\u0011!\u0011\t\u0006\u0004\u0005\u0007R\u0015AC2pY2,7\r^5p]&!!q\tB!\u0005\r\u0019V-\u001d\t\u0005\u0003\u0007\u0013Y%\u0003\u0003\u0003N\u0005\u0015&!F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f)>\u0004\u0018n\u0019\u0005\b\u0005#\n\u0002\u0019\u0001B*\u0003\u0019!x\u000e]5dgB1!q\bB+\u0003[KAAa\u0016\u0003B\t\u00191+\u001a;\t\u000f\u0005\u0005\u0013\u00031\u0001\u0002D!I\u0011\u0011Y\t\u0011\u0002\u0003\u0007\u0011Q\u000b\u0005\n\u0003\u000b\f\u0002\u0013!a\u0001\u0003+\n!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM*\"Aa\u0019+\t\u0005U#QM\u0016\u0003\u0005O\u0002BA!\u001b\u0003t5\u0011!1\u000e\u0006\u0005\u0005[\u0012y'A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u000f&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003v\t-$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%i\u0005aq-\u001a;BY2$v\u000e]5dgR!!1\u000bB?\u0011\u001d\u0011y\b\u0006a\u0001\u0005\u0003\u000bq\u0002^3oC:$\bK]3gSb|\u0005\u000f\u001e\t\u0006\u0013\u0006\u0015\u0014QV\u0001)O\u0016$Hk\u001c9jG6+G/\u00193bi\u00064uN\u001d#fg\u000e\u0014\u0018NY3U_BL7MU3ta>t7/\u001a\u000b\r\u0005\u000f\u0013yIa%\u0003\u0016\n}%1\u0015\t\u0005\u0005\u0013\u0013Y)\u0004\u0002\u0002 &!!QRAP\u0005\r\"Um]2sS\n,Gk\u001c9jGB\u000b'\u000f^5uS>t7OU3ta>t7/\u001a#bi\u0006DqA!\u0015\u0016\u0001\u0004\u0011\t\n\u0005\u0004\u0002l\u0005m\u0014Q\u0016\u0005\b\u0003\u0003*\u0002\u0019AA\"\u0011\u001d\u00119*\u0006a\u0001\u00053\u000b\u0001\u0004^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u0015;beRLe\u000eZ3y!\u0019I%1TAW/&\u0019!Q\u0014&\u0003\u0013\u0019+hn\u0019;j_:\f\u0004B\u0002BQ+\u0001\u0007q+A\rnCbLW.^7Ok6\u0014WM](g!\u0006\u0014H/\u001b;j_:\u001c\bb\u0002BS+\u0001\u0007\u0011QK\u0001\u001bS\u001etwN]3U_BL7m],ji\",\u0005pY3qi&|gn]\u0001\u0013O\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003,\nM\u0006C\u0002B \u0005+\u0012i\u000b\u0005\u0003\u0003,\t=\u0016\u0002\u0002BY\u0003\u0017\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002,Z\u0001\r!!,\u0002\u0015\u001d,G\u000fV8qS\u000eLE\r\u0006\u0003\u0003:\n}\u0006\u0003\u0002B\u0016\u0005wKAA!0\u0002L\t!Q+^5e\u0011\u001d\tYk\u0006a\u0001\u0003[\u000bAbZ3u)>\u0004\u0018n\u0019(b[\u0016$BA!!\u0003F\"9!q\u0019\rA\u0002\te\u0016a\u0002;pa&\u001c\u0017\nZ\u0001\rO\u0016$Hk\u001c9jGRK\b/\u001a\u000b\u0005\u0005\u001b\u0014)\u000eE\u0003J\u0003K\u0012y\r\u0005\u0003\u0003,\tE\u0017\u0002\u0002Bj\u0003\u0017\u0012\u0011\u0002V8qS\u000e$\u0016\u0010]3\t\u000f\u0005-\u0016\u00041\u0001\u0002.\u0006q\u0001.Y:BY&4XM\u0011:pW\u0016\u0014H\u0003BA+\u00057DQ!\u0016\u000eA\u0002]\u000ba\"[:Ce>\\WM\u001d$f]\u000e,G\r\u0006\u0003\u0002V\t\u0005\b\"B+\u001c\u0001\u00049\u0016\u0001F5t\u0005J|7.\u001a:TQV$H/\u001b8h\t><h\u000e\u0006\u0003\u0002V\t\u001d\b\"B+\u001d\u0001\u00049\u0016aD4fi\u0006c\u0017N^3Ce>\\WM]:\u0015\u0005\t5\bCBA6\u0005_\u0014\u00190\u0003\u0003\u0003r\u0006}$\u0001C%uKJ\f'\r\\3\u0011\t\tU(1`\u0007\u0003\u0005oT1A!?m\u0003\u0015\tG-\\5o\u0013\u0011\u0011iPa>\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCR!!Q^B\u0001\u0011\u0015qh\u00041\u0001|\u0003I9W\r^!mSZ,'I]8lKJtu\u000eZ3\u0015\r\t\u001d2qAB\u0005\u0011\u0015)v\u00041\u0001X\u0011\u001d\t\te\ba\u0001\u0003\u0007\nqbZ3u\u0005J|7.\u001a:DK2d\u0017\n\u001a\u000b\u0004/\u000e=\u0001\"B+!\u0001\u00049\u0016aE4fi\u0006c\u0017N^3Ce>\\WM\u001d(pI\u0016\u001cH\u0003BB\u000b\u0007/\u0001bAa\u0010\u0003F\t%\u0002bBA!C\u0001\u0007\u00111I\u0001\u000fO\u0016$(I]8lKJtu\u000eZ3t)\u0011\u0019)b!\b\t\u000f\u0005\u0005#\u00051\u0001\u0002D\u0005yq-\u001a;MK\u0006$WM]!oI&\u001b(\u000f\u0006\u0004\u0004$\r-2Q\u0006\t\u0006\u0013\u0006\u00154Q\u0005\t\u0005\u0003\u007f\u001c9#\u0003\u0003\u0004*\t\u0005!\u0001\u0004'fC\u0012,'/\u00118e\u0013N\u0014\bbBAVG\u0001\u0007\u0011Q\u0016\u0005\u0007\u0007_\u0019\u0003\u0019A,\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\u0010O\u0016$Hk\u001c9jGN\u0014\u0015\u0010T5oWR!1QGB!!!\u0011yda\u000e\u0002.\u000em\u0012\u0002BB\u001d\u0005\u0003\u00121!T1q!\ra8QH\u0005\u0004\u0007\u007fi(A\u0003+pa&\u001c\u0017*\\1hK\"911\t\u0013A\u0002\te\u0016\u0001B;vS\u0012\f1dZ3u\u001b&\u0014(o\u001c:QCJ$\u0018\u000e^5p]N\u0014\u0015\u0010T3bI\u0016\u0014H\u0003BB%\u0007\u0017\u0002bAa\u0010\u0003F\t5\u0006BBB'K\u0001\u0007q+\u0001\u0005mK\u0006$WM]%e\u0003Y9W\r\u001e'j].t\u0015-\\3CsB\u000b'\u000f^5uS>tG\u0003\u0002BA\u0007'Bq!a?'\u0001\u0004\u0011i+A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u00073\u001aY\u0006\u0005\u0003J\u0003K:\u0006bBAVO\u0001\u0007\u0011QV\u0001\u0010i>\u0004\u0018n\u0019(b[\u0016\u001cHk\\%egR\u00111\u0011\r\t\t\u0003C\u0019\u0019'!,\u0003:&\u00191\u0011H1\u0002\u001fQ|\u0007/[2JIN$vNT1nKN$\"a!\u001b\u0011\u0011\u0005\u000521\rB]\u0003[\u000b1\u0002^8qS\u000eLE-\u00138g_R\u00111q\u000e\t\b\u0013\u000657\u0011MB5\u0003i9W\r\u001e)beRLG/[8o\u0019\u0016\fG-\u001a:F]\u0012\u0004x.\u001b8u)!\u00119c!\u001e\u0004x\re\u0004bBAVW\u0001\u0007\u0011Q\u0016\u0005\u0007\u0007_Y\u0003\u0019A,\t\u000f\u0005\u00053\u00061\u0001\u0002D\u0005ar-\u001a;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0016sG\r]8j]R\u001cHCBB@\u0007\u0003\u001b)\tE\u0004\u0003@\r]rK!\u000b\t\u000f\r\rE\u00061\u0001\u0003.\u0006\u0011A\u000f\u001d\u0005\b\u0003\u0003b\u0003\u0019AA\"\u0003=9W\r^\"p]R\u0014x\u000e\u001c7fe&#WCABF!\u0015I\u0015QMBG!\u0011\u0019yi!%\u000e\u0003\tK1aa%C\u0005I\u0019\u0015m\u00195fI\u000e{g\u000e\u001e:pY2,'/\u00133\u0002-\u001d,GOU1oI>l\u0017\t\\5wK\n\u0013xn[3s\u0013\u0012,\"a!\u0017\u0002)\u001d,GOU1oI>l\u0017\t\\5wK\n\u0013xn[3s)\u0011\u0019If!(\t\u000by|\u0003\u0019A>\u0002'\u001d,G/\u00117jm\u0016\u0014%o\\6fe\u0016\u0003xn\u00195\u0015\t\r\r61\u0016\t\u0006\u0013\u0006\u00154Q\u0015\t\u0004\u0013\u000e\u001d\u0016bABU\u0015\n!Aj\u001c8h\u0011\u0015)\u0006\u00071\u0001X\u0003I9W\r^\"mkN$XM]'fi\u0006$\u0017\r^1\u0015\r\rE6qWB^!\u0011\u0011Yca-\n\t\rU\u00161\n\u0002\b\u00072,8\u000f^3s\u0011\u001d\u0019I,\ra\u0001\u0003[\u000b\u0011b\u00197vgR,'/\u00133\t\u000f\u0005\u0005\u0013\u00071\u0001\u0002D\u0005A1m\u001c8uC&t7\u000f\u0006\u0003\u0002V\r\u0005\u0007bBAVe\u0001\u0007\u0011Q\u0016\u000b\u0005\u0003+\u001a)\rC\u0004\u0004\u0004N\u0002\rA!,\u0002\u0011M,G/S7bO\u0016$B!a\u0002\u0004L\"11Q\u001a\u001bA\u0002m\f\u0001B\\3x\u00136\fw-Z\u0001\tO\u0016$\u0018*\\1hK\u000611m\u001c8gS\u001e$Ba!6\u0004\\B!\u0011\u0011EBl\u0013\r\u0019I.\u0019\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBBom\u0001\u00071q\\\u0001\u000fG>tg-[4SKN|WO]2f!\u0011\u0019\to!:\u000e\u0005\r\r(\u0002BBi\u0003\u0017JAaa:\u0004d\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0017\u0001\u00063fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7\u000f\u0006\u0003\u0004n\u000eM\b\u0003\u0002BE\u0007_LAa!=\u0002 \n\u0001C)Z:de&\u0014Wm\u00117jK:$\u0018+^8uCN\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u001d\u0019)p\u000ea\u0001\u0007o\fqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0003\n\u000ee\u0018\u0002BB~\u0003?\u0013q\u0004R3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001c(+Z9vKN$H)\u0019;b\u0003a!Wm]2sS\n,7k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0005\t\u0003!9\u0001\u0005\u0003\u0003\n\u0012\r\u0011\u0002\u0002C\u0003\u0003?\u0013\u0001\u0006R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3ta>t7/\u001a#bi\u0006Dqa!>9\u0001\u0004!I\u0001\u0005\u0003\u0003\n\u0012-\u0011\u0002\u0002C\u0007\u0003?\u0013q\u0005R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fR1uC\u0006yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000e\u0006\u0002\u0005\u0014A\u0019\u0001\u000e\"\u0006\n\u0007\u0011]\u0011NA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003!1W-\u0019;ve\u0016\u001cHC\u0001C\u000f!\rAGqD\u0005\u0004\tCI'!\u0005$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:fg\u0006\u0001\u0012n\u001d\"s_.,'\u000fR3he\u0006$W\r\u001a\u000b\u0005\u0003+\"9\u0003C\u0003Vw\u0001\u0007q+A\rjg\n\u0013xn[3s\u0007>l\u0007o\u001c8f]R$Um\u001a:bI\u0016$GCBA+\t[!y\u0003C\u0003Vy\u0001\u0007q\u000bC\u0004\u00052q\u0002\r\u0001b\r\u0002\u0013\r|W\u000e]8oK:$\b\u0003\u0002C\u001b\t{i!\u0001b\u000e\u000b\t\teH\u0011\b\u0006\u0004\twa\u0017aB2mS\u0016tGo]\u0005\u0005\t\u007f!9DA\bCe>\\WM]\"p[B|g.\u001a8u\u0003Ai\u0017N\u001d:peR{\u0007/[2Ti\u0006$X\r\u0006\u0003\u0005F\u0011M\u0003#B%\u0002f\u0011\u001d\u0003\u0003\u0002C%\t\u001fj!\u0001b\u0013\u000b\u0007\u00115#)\u0001\u0003mS:\\\u0017\u0002\u0002C)\t\u0017\u0012Qc\u00117vgR,'\u000fT5oWR{\u0007/[2Ti\u0006$X\rC\u0004\u0005Vu\u0002\r!!,\u0002\u000bQ|\u0007/[2\u0002-1Lgn[\"p_J$\u0017N\\1u_J,e.\u00192mK\u0012,\"!!\u0016")
public class KRaftMetadataCache
implements KRaftImageMetadataCache {
    private final int brokerId;
    private final Supplier<KRaftVersion> kraftVersionSupplier;
    private volatile MetadataImage _currentImage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public Properties groupConfig(String groupName) {
        return ConfigRepository.groupConfig$(this, groupName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KRaftMetadataCache kRaftMetadataCache = this;
        synchronized (kRaftMetadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public int brokerId() {
        return this.brokerId;
    }

    public Supplier<KRaftVersion> kraftVersionSupplier() {
        return this.kraftVersionSupplier;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList(brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), brokerId -> Option$.MODULE$.apply(image.cluster().broker(brokerId)).foreach((Function1<BrokerRegistration, Object> & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean(res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    @Override
    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option<TopicImage> option = Option$.MODULE$.apply(image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topic = (TopicImage)some.value();
            if (((Object)BoxesRunTime.boxToByte(topic.topicType())).equals(BoxesRunTime.boxToByte(TopicType.VIRTUAL.id()))) {
                int n;
                Option option2 = this.getAliveBrokers().toSeq().headOption();
                if (None$.MODULE$.equals(option2)) {
                    n = -1;
                } else if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    BrokerMetadata broker = (BrokerMetadata)some2.value();
                    n = broker.id;
                } else {
                    throw new MatchError(option2);
                }
                int virtualTopicLeaderId = n;
                return Option$.MODULE$.apply(package$.MODULE$.Iterator().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetadataResponseData.MetadataResponsePartition[]{new MetadataResponseData.MetadataResponsePartition().setErrorCode(Errors.NONE.code()).setPartitionIndex(0).setLeaderId(virtualTopicLeaderId).setLeaderEpoch(-1).setReplicaNodes(Collections.emptyList()).setObservers(Collections.emptyList()).setIsrNodes(Collections.emptyList()).setOfflineReplicas(Collections.emptyList())})));
            }
            return new Some<Iterator<MetadataResponseData.MetadataResponsePartition>>(((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1<Map.Entry, MetadataResponseData.MetadataResponsePartition> & Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredObservers = this.maybeFilterAliveReplicas(image, partition.observers, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                Option<Node> option = maybeLeader;
                if (None$.MODULE$.equals(option)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger(partition.leader))) {
                        this.debug((Function0<String> & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": leader not available");
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String> & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": listener " + listenerName + " not found on leader " + partition$1.leader);
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (option instanceof Some) {
                    Errors errors;
                    Some some = (Some)option;
                    Node leader = (Node)some.value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String> & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": replica information not available for following brokers " + Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(filteredReplicas.contains(x$1)))).mkString(","));
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String> & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": in sync replica information not available for following brokers " + Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(filteredIsr.contains(x$1)))).mkString(","));
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(option);
            })).iterator());
        }
        throw new MatchError(option);
    }

    private Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> getPartitionMetadataForDescribeTopicResponse(MetadataImage image, String topicName, ListenerName listenerName, int startIndex, int maxCount) {
        Option<TopicImage> option = Option$.MODULE$.apply(image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return new Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object>(None$.MODULE$, BoxesRunTime.boxToInteger(-1));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topic = (TopicImage)some.value();
            ListBuffer result = new ListBuffer();
            java.util.Set<Integer> partitions = topic.partitions().keySet();
            int upperIndex = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(topic.partitions().size()), startIndex + maxCount);
            int nextIndex = upperIndex < partitions.size() ? upperIndex : -1;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startIndex), upperIndex).foreach((Function1<Object, Object> & Serializable)partitionId -> KRaftMetadataCache.$anonfun$getPartitionMetadataForDescribeTopicResponse$1(this, topic, image, listenerName, result, topicName, BoxesRunTime.unboxToInt(partitionId)));
            return new Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object>(new Some(result.toList()), BoxesRunTime.boxToInteger(nextIndex));
        }
        throw new MatchError(option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1<Object, Object> & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(this, image, offlineReplicas, partition, listenerName, BoxesRunTime.unboxToInt(brokerId)));
        return offlineReplicas;
    }

    private boolean isReplicaOffline(PartitionRegistration partition, ListenerName listenerName, BrokerRegistration broker) {
        return broker.fenced() || !broker.listeners().containsKey(listenerName.value()) || this.isReplicaInOfflineDir(broker, partition);
    }

    private boolean isReplicaInOfflineDir(BrokerRegistration broker, PartitionRegistration partition) {
        return !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply(image.cluster().broker(id)).flatMap((Function1<BrokerRegistration, Option> & Serializable)x$1 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1<String, Option> & Serializable)topic -> this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1<Iterator, MetadataResponseData.MetadataResponseTopic> & Serializable)partitionMetadata -> {
            TopicImage topicImage = image.topics().getTopic((String)topic);
            return new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply(topicImage.id()).getOrElse((Function0<Uuid> & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava()).setTopicType(topicImage.topicType());
        }));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Option<String> tenantPrefixOpt) {
        Option<String> option = tenantPrefixOpt;
        if (None$.MODULE$.equals(option)) {
            return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByName().keySet()).asScala();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String tenantName = (String)some.value();
            return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByTenant(tenantName)).asScala();
        }
        throw new MatchError(option);
    }

    @Override
    public DescribeTopicPartitionsResponseData getTopicMetadataForDescribeTopicResponse(Iterator<String> topics, ListenerName listenerName, Function1<String, Object> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        MetadataImage image = this._currentImage();
        IntRef remaining = IntRef.create(maximumNumberOfPartitions);
        DescribeTopicPartitionsResponseData result = new DescribeTopicPartitionsResponseData();
        Breaks$.MODULE$.breakable(() -> topics.foreach((Function1<String, Object> & Serializable)topicName -> {
            if (remaining$1.elem > 0) {
                Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> tuple2 = this.getPartitionMetadataForDescribeTopicResponse(image, (String)topicName, listenerName, BoxesRunTime.unboxToInt(topicPartitionStartIndex.apply((String)topicName)), remaining$1.elem);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>> partitionResponse = tuple2._1();
                int nextPartition = tuple2._2$mcI$sp();
                Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Integer> tuple22 = new Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Integer>(partitionResponse, BoxesRunTime.boxToInteger(nextPartition));
                Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>> partitionResponse2 = tuple22._1();
                int nextPartition2 = tuple22._2$mcI$sp();
                partitionResponse2.map((Function1<List, Object> & Serializable)partitions -> {
                    KRaftMetadataCache.$anonfun$getTopicMetadataForDescribeTopicResponse$3(topicName, image, result, nextPartition2, remaining, partitions);
                    return BoxedUnit.UNIT;
                });
                if (!ignoreTopicsWithExceptions && partitionResponse2.isEmpty()) {
                    Errors errors;
                    try {
                        Topic.validate((String)topicName);
                        errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                    }
                    catch (InvalidTopicException invalidTopicException) {
                        errors = Errors.INVALID_TOPIC_EXCEPTION;
                    }
                    Errors error = errors;
                    return BoxesRunTime.boxToBoolean(result.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(error.code()).setName(topicName).setTopicId(this.getTopicId((String)topicName)).setIsInternal(Topic.isInternal((String)topicName))));
                }
                return BoxedUnit.UNIT;
            }
            if (remaining$1.elem == 0) {
                result.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName).setPartitionIndex(0));
                throw Breaks$.MODULE$.break();
            }
            return BoxedUnit.UNIT;
        }));
        return result;
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option<TopicImage> option = Option$.MODULE$.apply(this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return (Set)Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topic = (TopicImage)some.value();
            return (Set)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().keySet()).asScala().map((Function1<Integer, TopicPartition> & Serializable)x$3 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int((Integer)x$3)));
        }
        throw new MatchError(option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsByName()).asScala().get(topicName).map((Function1<TopicImage, Uuid> & Serializable)x$4 -> x$4.id()).getOrElse((Function0<Uuid> & Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsById()).asScala().get(topicId).map((Function1<TopicImage, String> & Serializable)x$5 -> x$5.name());
    }

    @Override
    public Option<TopicType> getTopicType(String topicName) {
        Option<TopicImage> option = Option$.MODULE$.apply(this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return Option$.MODULE$.empty();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topic = (TopicImage)some.value();
            return Option$.MODULE$.apply(TopicType.forId((byte)topic.topicType()));
        }
        throw new MatchError(option);
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId))).count((Function1<BrokerRegistration, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$6))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId))).count((Function1<BrokerRegistration, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(x$7.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId))).count((Function1<BrokerRegistration, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(x$8.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filterNot((Function1<BrokerRegistration, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(x$9.fenced()))).map((Function1<BrokerRegistration, BrokerMetadata> & Serializable)b -> new BrokerMetadata(b.id(), b.rack()));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId)).filterNot((Function1<BrokerRegistration, Object> & Serializable)x$10 -> BoxesRunTime.boxToBoolean(x$10.fenced())).flatMap((Function1<BrokerRegistration, Option> & Serializable)x$11 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(x$11.node(listenerName.value()))));
    }

    @Override
    public int getBrokerCellId(int brokerId) {
        return this._currentImage().cells().getBrokerCellId(brokerId);
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().filterNot((Function1<BrokerRegistration, Object> & Serializable)x$12 -> BoxesRunTime.boxToBoolean(x$12.fenced()))).flatMap((Function1<BrokerRegistration, Option> & Serializable)x$13 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(x$13.node(listenerName.value()))))).toSeq();
    }

    public Seq<Node> getBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().flatMap((Function1<BrokerRegistration, Option> & Serializable)x$14 -> OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(x$14.node(listenerName.value()))))).toSeq();
    }

    @Override
    public Option<LeaderAndIsr> getLeaderAndIsr(String topicName, int partitionId) {
        return Option$.MODULE$.apply(this._currentImage().topics().getTopic(topicName)).flatMap((Function1<TopicImage, Option> & Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger(partitionId)))).flatMap((Function1<PartitionRegistration, Some> & Serializable)partition -> new Some<LeaderAndIsr>(new LeaderAndIsr(partition.leader, partition.leaderEpoch, Arrays.asList((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1<Object, Integer> & Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(i)), ClassTag$.MODULE$.apply(Integer.class))), partition.leaderRecoveryState, partition.partitionEpoch, Optional.empty())));
    }

    public Map<String, TopicImage> getTopicsByLink(Uuid uuid) {
        return CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsByLinkId(uuid)).asScala().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicImage image = (TopicImage)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(image.name()), image);
            }
            throw new MatchError(tuple2);
        }).toMap($less$colon$less$.MODULE$.refl());
    }

    public Seq<TopicPartition> getMirrorPartitionsByLeader(int leaderId) {
        return (Seq)CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsByLinkId()).asScala().toSeq().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ImmutableMap topicImageMap = (ImmutableMap)tuple2._2();
                return (IterableOnce)CollectionConverters$.MODULE$.MapHasAsScala(topicImageMap).asScala().toSeq().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Uuid topicId = (Uuid)tuple2._1();
                        TopicImage topicImage = (TopicImage)tuple2._2();
                        return (IterableOnce)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(topicImage.partitions()).asScala().filter((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToBoolean(KRaftMetadataCache.$anonfun$getMirrorPartitionsByLeader$3(leaderId, x0$3)))).filter((Function1<Tuple2, Object> & Serializable)x$15 -> BoxesRunTime.boxToBoolean(KRaftMetadataCache.$anonfun$getMirrorPartitionsByLeader$4(this, topicId, x$15)))).map((Function1<Tuple2, TopicPartition> & Serializable)x0$4 -> {
                            Tuple2 tuple2 = x0$4;
                            if (tuple2 != null) {
                                Integer partitionId = (Integer)tuple2._1();
                                return new TopicPartition(this.getTopicName(topicId).get(), Predef$.MODULE$.Integer2int(partitionId));
                            }
                            throw new MatchError(tuple2);
                        });
                    }
                    throw new MatchError(tuple2);
                });
            }
            throw new MatchError(tuple2);
        });
    }

    public Option<String> getLinkNameByPartition(TopicPartition partition) {
        Option option = CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsByName()).asScala().get(partition.topic());
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topicImage = (TopicImage)some.value();
            Option<MirrorTopic> option2 = OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(topicImage.mirrorTopic()));
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                MirrorTopic mirrorTopic = (MirrorTopic)some2.value();
                return new Some<String>(mirrorTopic.linkName());
            }
            if (None$.MODULE$.equals(option2)) {
                return Option$.MODULE$.empty();
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return Option$.MODULE$.empty();
        }
        throw new MatchError(option);
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply(this._currentImage().topics().getTopic(topicName)).map((Function1<TopicImage, Object> & Serializable)topic -> BoxesRunTime.boxToInteger(KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>>(image.topics().topicNameToIdView(), image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option<TopicImage> option = Option$.MODULE$.apply(image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topic = (TopicImage)some.value();
            Option<PartitionRegistration> option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger(partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                PartitionRegistration partition = (PartitionRegistration)some2.value();
                Option<BrokerRegistration> option3 = Option$.MODULE$.apply(image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some<Node>(Node.noNode());
                }
                if (option3 instanceof Some) {
                    Some some3 = (Some)option3;
                    BrokerRegistration broker = (BrokerRegistration)some3.value();
                    return new Some<Node>(broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError(option3);
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    @Override
    public Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap<Object, Node> result = new scala.collection.mutable.HashMap<Object, Node>();
        Option$.MODULE$.apply(image.topics().getTopic(tp.topic())).foreach((Function1<TopicImage, Object> & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(tp, image, listenerName, result, topic);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage()).map(KRaftCachedControllerId$.MODULE$);
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some<Object>(BoxesRunTime.boxToInteger(((BrokerMetadata)aliveBrokers.apply((int)ThreadLocalRandom.current().nextInt((int)aliveBrokers.size()))).id));
    }

    public Option<Object> getAliveBrokerEpoch(int brokerId) {
        return Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId)).filterNot((Function1<BrokerRegistration, Object> & Serializable)x$16 -> BoxesRunTime.boxToBoolean(x$16.fenced())).map((Function1<BrokerRegistration, Object> & Serializable)brokerRegistration -> BoxesRunTime.boxToLong(brokerRegistration.epoch()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(broker.node(listenerName.value()))).foreach((Function1<Node, Node> & Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().forEach((key, value) -> {
            Integer partitionId = key;
            PartitionRegistration partition = value;
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(partitionId), KRaftMetadataCache.node$1(partition.leader, nodes), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1<Object, Node> & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt(replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1<Object, Node> & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt(replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getOfflineReplicas(image, partition, listenerName)).asScala().map((Function1<Integer, Node> & Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int((Integer)replica), nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt(this.getRandomAliveBroker(image).getOrElse(() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey(topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option<TopicImage> option = Option$.MODULE$.apply(this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topic = (TopicImage)some.value();
            return topic.partitions().containsKey(BoxesRunTime.boxToInteger(tp.partition()));
        }
        throw new MatchError(option);
    }

    @Override
    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    public MetadataImage getImage() {
        return this._currentImage();
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    @Override
    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    @Override
    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersionOrThrow();
    }

    @Override
    public FinalizedFeatures features() {
        MetadataImage image = this._currentImage();
        HashMap<String, Short> finalizedFeatures = new HashMap<String, Short>(image.features().finalizedVersions());
        short kraftVersionLevel = this.kraftVersionSupplier().get().featureLevel();
        Serializable serializable = kraftVersionLevel > 0 ? finalizedFeatures.put("kraft.version", Predef$.MODULE$.short2Short(kraftVersionLevel)) : BoxedUnit.UNIT;
        return new FinalizedFeatures(image.features().metadataVersionOrThrow(), finalizedFeatures, image.highestOffsetAndEpoch().offset(), true);
    }

    @Override
    public boolean isBrokerDegraded(int brokerId) {
        return Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId)).exists((Function1<BrokerRegistration, Object> & Serializable)registration -> BoxesRunTime.boxToBoolean(KRaftMetadataCache.$anonfun$isBrokerDegraded$1(registration)));
    }

    @Override
    public boolean isBrokerComponentDegraded(int brokerId, BrokerComponent component) {
        return Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId)).exists((Function1<BrokerRegistration, Object> & Serializable)registration -> BoxesRunTime.boxToBoolean(KRaftMetadataCache.$anonfun$isBrokerComponentDegraded$1(component, registration)));
    }

    @Override
    public Option<ClusterLinkTopicState> mirrorTopicState(String topic) {
        MetadataImage image = this._currentImage();
        TopicImage topicImage = image.topics().getTopic(topic);
        if (topicImage == null) {
            return None$.MODULE$;
        }
        return OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(topicImage.mirrorTopic())).map((Function1<MirrorTopic, ClusterLinkTopicState> & Serializable)state -> ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)state));
    }

    @Override
    public boolean linkCoordinatorEnabled() {
        return true;
    }

    public static final /* synthetic */ Object $anonfun$getPartitionMetadataForDescribeTopicResponse$1(KRaftMetadataCache $this, TopicImage topic$1, MetadataImage image$3, ListenerName listenerName$3, ListBuffer result$1, String topicName$2, int partitionId) {
        PartitionRegistration partitionRegistration = topic$1.partitions().get(BoxesRunTime.boxToInteger(partitionId));
        if (partitionRegistration != null) {
            PartitionRegistration partitionRegistration2 = partitionRegistration;
            java.util.List<Integer> filteredReplicas = $this.maybeFilterAliveReplicas(image$3, partitionRegistration2.replicas, listenerName$3, false);
            java.util.List<Integer> filteredIsr = $this.maybeFilterAliveReplicas(image$3, partitionRegistration2.isr, listenerName$3, false);
            java.util.List<Integer> filteredObservers = $this.maybeFilterAliveReplicas(image$3, partitionRegistration2.observers, listenerName$3, false);
            java.util.List<Integer> offlineReplicas = $this.getOfflineReplicas(image$3, partitionRegistration2, listenerName$3);
            Option<Node> maybeLeader = $this.getAliveEndpoint(image$3, partitionRegistration2.leader, listenerName$3);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                return (ListBuffer)result$1.append(new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(-1).setLeaderEpoch(partitionRegistration2.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setObservers(filteredObservers).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList(partitionRegistration2.elr)).setLastKnownElr(Replicas.toList(partitionRegistration2.lastKnownElr)));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Node leader = (Node)some.value();
                return (ListBuffer)result$1.append(new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(leader.id()).setLeaderEpoch(partitionRegistration2.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setObservers(filteredObservers).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList(partitionRegistration2.elr)).setLastKnownElr(Replicas.toList(partitionRegistration2.lastKnownElr)));
            }
            throw new MatchError(option);
        }
        $this.warn((Function0<String> & Serializable)() -> "The partition " + partitionId + " does not exist for " + topicName$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(KRaftMetadataCache $this, MetadataImage image$4, ArrayList offlineReplicas$1, PartitionRegistration partition$2, ListenerName listenerName$4, int brokerId) {
        Option<BrokerRegistration> option = Option$.MODULE$.apply(image$4.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean(offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            BrokerRegistration broker = (BrokerRegistration)some.value();
            if ($this.isReplicaOffline(partition$2, listenerName$4, broker)) {
                return BoxesRunTime.boxToBoolean(offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadataForDescribeTopicResponse$3(String topicName$3, MetadataImage image$6, DescribeTopicPartitionsResponseData result$2, int nextPartition$1, IntRef remaining$1, List partitions) {
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic response = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicName$3).setTopicId((Uuid)Option$.MODULE$.apply(image$6.topics().getTopic(topicName$3).id()).getOrElse((Function0<Uuid> & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topicName$3)).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava(partitions).asJava());
        result$2.topics().add((ImplicitLinkedHashCollection.Element)response);
        if (nextPartition$1 != -1) {
            result$2.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName$3).setPartitionIndex(nextPartition$1));
            throw Breaks$.MODULE$.break();
        }
        remaining$1.elem -= partitions.size();
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$6) {
        return !x$6.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getMirrorPartitionsByLeader$3(int leaderId$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            PartitionRegistration description = (PartitionRegistration)tuple2._2();
            return description.leader == leaderId$1;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getMirrorPartitionsByLeader$4(KRaftMetadataCache $this, Uuid topicId$1, Tuple2 x$15) {
        return $this.getTopicName(topicId$1).isDefined();
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(TopicPartition tp$1, MetadataImage image$7, ListenerName listenerName$11, scala.collection.mutable.HashMap result$3, TopicImage topic) {
        Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger(tp$1.partition()))).foreach((Function1<PartitionRegistration, Object> & Serializable)partition -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), replicaId -> {
                BrokerRegistration broker = image$7.cluster().broker(replicaId);
                if (broker != null && !broker.fenced()) {
                    broker.node(listenerName$11.value()).ifPresent(node -> {
                        if (!node.isEmpty()) {
                            result$3.put(BoxesRunTime.boxToInteger(replicaId), node);
                            return;
                        }
                    });
                    return;
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger(id))).getOrElse((Function0<Node> & Serializable)() -> Node.noNode());
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerDegraded$1(BrokerRegistration registration) {
        return !registration.degradedComponents().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerComponentDegraded$1(BrokerComponent component$1, BrokerRegistration registration) {
        return registration.degradedComponents().stream().anyMatch(degradedComponent -> {
            BrokerComponent brokerComponent = degradedComponent.component();
            BrokerComponent brokerComponent2 = component$1;
            return !(brokerComponent != null ? !brokerComponent.equals(brokerComponent2) : brokerComponent2 != null);
        });
    }

    public KRaftMetadataCache(int brokerId, Supplier<KRaftVersion> kraftVersionSupplier) {
        this.brokerId = brokerId;
        this.kraftVersionSupplier = kraftVersionSupplier;
        Logging.$init$(this);
        ConfigRepository.$init$(this);
        this.logIdent_$eq("[MetadataCache brokerId=" + brokerId + "] ");
        this._currentImage = MetadataImage.EMPTY;
    }
}

