/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import kafka.cluster.Partition;
import kafka.server.ReplicaManager;
import kafka.server.share.SharePartition;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.fetch.ShareAcquiredRecords;
import org.apache.kafka.server.share.fetch.ShareFetch;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.FetchedTimestampAndOffset;
import org.apache.kafka.storage.internals.log.MaybeResolvedTimestampAndOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;

public class ShareFetchUtils {
    private static final Logger log = LoggerFactory.getLogger(ShareFetchUtils.class);

    static Map<TopicIdPartition, ShareFetchResponseData.PartitionData> processFetchResponse(ShareFetch shareFetch, Map<TopicIdPartition, FetchPartitionData> responseData, LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions, ReplicaManager replicaManager, BiConsumer<SharePartitionKey, Throwable> exceptionHandler) {
        HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> response = new HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        int acquiredRecordsCount = 0;
        for (Map.Entry<TopicIdPartition, FetchPartitionData> entry : responseData.entrySet()) {
            TopicIdPartition topicIdPartition = entry.getKey();
            FetchPartitionData fetchPartitionData = entry.getValue();
            SharePartition sharePartition = sharePartitions.get(topicIdPartition);
            ShareFetchResponseData.PartitionData partitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(topicIdPartition.partition());
            if (fetchPartitionData.error.code() != Errors.NONE.code()) {
                partitionData.setRecords(null).setErrorCode(fetchPartitionData.error.code()).setErrorMessage(fetchPartitionData.error.message()).setAcquiredRecords(Collections.emptyList());
                if (fetchPartitionData.error.code() == Errors.OFFSET_OUT_OF_RANGE.code()) {
                    try {
                        sharePartition.updateCacheAndOffsets(ShareFetchUtils.offsetForEarliestTimestamp(topicIdPartition, replicaManager, sharePartition.leaderEpoch()));
                    }
                    catch (Exception e) {
                        log.error("Error while fetching offset for earliest timestamp for topicIdPartition: {}", (Object)topicIdPartition, (Object)e);
                        shareFetch.addErroneous(topicIdPartition, e);
                        exceptionHandler.accept(new SharePartitionKey(shareFetch.groupId(), topicIdPartition), e);
                        continue;
                    }
                    partitionData.setErrorCode(Errors.NONE.code());
                    partitionData.setErrorMessage(Errors.NONE.message());
                }
            } else {
                ShareAcquiredRecords shareAcquiredRecords = sharePartition.acquire(shareFetch.memberId(), shareFetch.batchSize(), shareFetch.maxFetchRecords() - acquiredRecordsCount, fetchPartitionData);
                log.trace("Acquired records: {} for topicIdPartition: {}", (Object)shareAcquiredRecords, (Object)topicIdPartition);
                if (shareAcquiredRecords.acquiredRecords().isEmpty()) {
                    partitionData.setRecords(null).setAcquiredRecords(Collections.emptyList());
                } else {
                    partitionData.setRecords((BaseRecords)fetchPartitionData.records).setAcquiredRecords(shareAcquiredRecords.acquiredRecords());
                    acquiredRecordsCount += shareAcquiredRecords.count();
                }
            }
            response.put(topicIdPartition, partitionData);
        }
        return response;
    }

    static long offsetForEarliestTimestamp(TopicIdPartition topicIdPartition, ReplicaManager replicaManager, int leaderEpoch) {
        Option<MaybeResolvedTimestampAndOffset> timestampAndOffset = replicaManager.fetchOffsetForTimestamp(topicIdPartition.topicPartition(), -2L, Option.empty(), Option.apply(leaderEpoch), true);
        if (timestampAndOffset.isEmpty() || !(timestampAndOffset.get() instanceof FetchedTimestampAndOffset)) {
            throw new OffsetNotAvailableException("Offset for earliest timestamp not found for topic partition: " + String.valueOf(topicIdPartition));
        }
        return ((FetchedTimestampAndOffset)timestampAndOffset.get()).offset();
    }

    static long offsetForLatestTimestamp(TopicIdPartition topicIdPartition, ReplicaManager replicaManager, int leaderEpoch) {
        Option<MaybeResolvedTimestampAndOffset> timestampAndOffset = replicaManager.fetchOffsetForTimestamp(topicIdPartition.topicPartition(), -1L, new Some<IsolationLevel>(IsolationLevel.READ_UNCOMMITTED), Option.apply(leaderEpoch), true);
        if (timestampAndOffset.isEmpty() || !(timestampAndOffset.get() instanceof FetchedTimestampAndOffset)) {
            throw new OffsetNotAvailableException("Offset for latest timestamp not found for topic partition: " + String.valueOf(topicIdPartition));
        }
        return ((FetchedTimestampAndOffset)timestampAndOffset.get()).offset();
    }

    static long offsetForTimestamp(TopicIdPartition topicIdPartition, ReplicaManager replicaManager, long timestampToSearch, int leaderEpoch) {
        Option<MaybeResolvedTimestampAndOffset> timestampAndOffset = replicaManager.fetchOffsetForTimestamp(topicIdPartition.topicPartition(), timestampToSearch, new Some<IsolationLevel>(IsolationLevel.READ_UNCOMMITTED), Option.apply(leaderEpoch), true);
        if (timestampAndOffset.isEmpty()) {
            throw new OffsetNotAvailableException("Offset for timestamp " + timestampToSearch + " not found for topic partition: " + String.valueOf(topicIdPartition));
        }
        return ((FetchedTimestampAndOffset)timestampAndOffset.get()).offset();
    }

    static int leaderEpoch(ReplicaManager replicaManager, TopicPartition tp) {
        return ShareFetchUtils.partition(replicaManager, tp).getLeaderEpoch();
    }

    static Partition partition(ReplicaManager replicaManager, TopicPartition tp) {
        Partition partition = replicaManager.getPartitionOrException(tp);
        if (!partition.isLeader()) {
            log.debug("The broker is not the leader for topic partition: {}-{}", (Object)tp.topic(), (Object)tp.partition());
            throw new NotLeaderOrFollowerException();
        }
        return partition;
    }
}

