/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kafka.cluster.PartitionListener;
import kafka.server.ReplicaManager;
import kafka.server.share.DelayedShareFetch;
import kafka.server.share.ShareFetchUtils;
import kafka.server.share.SharePartition;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedStateEpochException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareRequestMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupConfigManager;
import org.apache.kafka.server.share.CachedSharePartition;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.acknowledge.ShareAcknowledgementBatch;
import org.apache.kafka.server.share.context.FinalContext;
import org.apache.kafka.server.share.context.ShareFetchContext;
import org.apache.kafka.server.share.context.ShareSessionContext;
import org.apache.kafka.server.share.fetch.DelayedShareFetchGroupKey;
import org.apache.kafka.server.share.fetch.DelayedShareFetchKey;
import org.apache.kafka.server.share.fetch.DelayedShareFetchPartitionKey;
import org.apache.kafka.server.share.fetch.PartitionRotateStrategy;
import org.apache.kafka.server.share.fetch.ShareFetch;
import org.apache.kafka.server.share.persister.Persister;
import org.apache.kafka.server.share.session.ShareSession;
import org.apache.kafka.server.share.session.ShareSessionCache;
import org.apache.kafka.server.share.session.ShareSessionKey;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.util.FutureUtils;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.SystemTimerReaper;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharePartitionManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SharePartitionManager.class);
    private final Map<SharePartitionKey, SharePartition> partitionCacheMap;
    private final ReplicaManager replicaManager;
    private final Time time;
    private final ShareSessionCache cache;
    private final GroupConfigManager groupConfigManager;
    private final int defaultRecordLockDurationMs;
    private final Timer timer;
    private final int maxInFlightMessages;
    private final int maxDeliveryCount;
    private final Persister persister;
    private final ShareGroupMetrics shareGroupMetrics;
    private final BrokerTopicStats brokerTopicStats;
    private final int maxFetchRecords;

    public SharePartitionManager(ReplicaManager replicaManager, Time time, ShareSessionCache cache, int defaultRecordLockDurationMs, int maxDeliveryCount, int maxInFlightMessages, int maxFetchRecords, Persister persister, GroupConfigManager groupConfigManager, Metrics metrics, BrokerTopicStats brokerTopicStats) {
        this(replicaManager, time, cache, new ConcurrentHashMap<SharePartitionKey, SharePartition>(), defaultRecordLockDurationMs, maxDeliveryCount, maxInFlightMessages, maxFetchRecords, persister, groupConfigManager, metrics, brokerTopicStats);
    }

    private SharePartitionManager(ReplicaManager replicaManager, Time time, ShareSessionCache cache, Map<SharePartitionKey, SharePartition> partitionCacheMap, int defaultRecordLockDurationMs, int maxDeliveryCount, int maxInFlightMessages, int maxFetchRecords, Persister persister, GroupConfigManager groupConfigManager, Metrics metrics, BrokerTopicStats brokerTopicStats) {
        this(replicaManager, time, cache, partitionCacheMap, defaultRecordLockDurationMs, new SystemTimerReaper("share-group-lock-timeout-reaper", new SystemTimer("share-group-lock-timeout")), maxDeliveryCount, maxInFlightMessages, maxFetchRecords, persister, groupConfigManager, metrics, brokerTopicStats);
    }

    SharePartitionManager(ReplicaManager replicaManager, Time time, ShareSessionCache cache, Map<SharePartitionKey, SharePartition> partitionCacheMap, int defaultRecordLockDurationMs, Timer timer, int maxDeliveryCount, int maxInFlightMessages, int maxFetchRecords, Persister persister, GroupConfigManager groupConfigManager, Metrics metrics, BrokerTopicStats brokerTopicStats) {
        this.replicaManager = replicaManager;
        this.time = time;
        this.cache = cache;
        this.partitionCacheMap = partitionCacheMap;
        this.defaultRecordLockDurationMs = defaultRecordLockDurationMs;
        this.timer = timer;
        this.maxDeliveryCount = maxDeliveryCount;
        this.maxInFlightMessages = maxInFlightMessages;
        this.persister = persister;
        this.groupConfigManager = groupConfigManager;
        this.shareGroupMetrics = new ShareGroupMetrics(Objects.requireNonNull(metrics), time);
        this.maxFetchRecords = maxFetchRecords;
        this.brokerTopicStats = brokerTopicStats;
    }

    public CompletableFuture<Map<TopicIdPartition, ShareFetchResponseData.PartitionData>> fetchMessages(String groupId, String memberId, FetchParams fetchParams, int sessionEpoch, int batchSize, LinkedHashMap<TopicIdPartition, Integer> partitionMaxBytes) {
        log.trace("Fetch request for topicIdPartitions: {} with groupId: {} fetch params: {}", new Object[]{partitionMaxBytes.keySet(), groupId, fetchParams});
        LinkedHashMap<TopicIdPartition, Integer> topicIdPartitions = PartitionRotateStrategy.type(PartitionRotateStrategy.StrategyType.ROUND_ROBIN).rotate(partitionMaxBytes, new PartitionRotateStrategy.PartitionRotateMetadata(sessionEpoch));
        CompletableFuture<Map<TopicIdPartition, ShareFetchResponseData.PartitionData>> future = new CompletableFuture<Map<TopicIdPartition, ShareFetchResponseData.PartitionData>>();
        this.processShareFetch(new ShareFetch(fetchParams, groupId, memberId, future, topicIdPartitions, batchSize, this.maxFetchRecords, this.brokerTopicStats));
        return future;
    }

    public CompletableFuture<Map<TopicIdPartition, ShareAcknowledgeResponseData.PartitionData>> acknowledge(String memberId, String groupId, Map<TopicIdPartition, List<ShareAcknowledgementBatch>> acknowledgeTopics) {
        log.trace("Acknowledge request for topicIdPartitions: {} with groupId: {}", acknowledgeTopics.keySet(), (Object)groupId);
        HashMap<TopicIdPartition, CompletableFuture<Throwable>> futures = new HashMap<TopicIdPartition, CompletableFuture<Throwable>>();
        HashSet topics = new HashSet();
        acknowledgeTopics.forEach((topicIdPartition, acknowledgePartitionBatches) -> {
            topics.add(topicIdPartition.topic());
            SharePartitionKey sharePartitionKey = this.sharePartitionKey(groupId, (TopicIdPartition)topicIdPartition);
            SharePartition sharePartition = this.partitionCacheMap.get(sharePartitionKey);
            if (sharePartition != null) {
                CompletableFuture future = new CompletableFuture();
                sharePartition.acknowledge(memberId, (List<ShareAcknowledgementBatch>)acknowledgePartitionBatches).whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        this.fencedSharePartitionHandler().accept(sharePartitionKey, (Throwable)throwable);
                        future.complete(throwable);
                        return;
                    }
                    acknowledgePartitionBatches.forEach(batch -> batch.acknowledgeTypes().forEach(this.shareGroupMetrics::recordAcknowledgement));
                    future.complete(null);
                });
                DelayedShareFetchGroupKey delayedShareFetchKey = new DelayedShareFetchGroupKey(groupId, topicIdPartition.topicId(), topicIdPartition.partition());
                this.replicaManager.completeDelayedShareFetchRequest(delayedShareFetchKey);
                futures.put((TopicIdPartition)topicIdPartition, future);
            } else {
                futures.put((TopicIdPartition)topicIdPartition, (CompletableFuture<Throwable>)CompletableFuture.completedFuture(Errors.UNKNOWN_TOPIC_OR_PARTITION.exception()));
            }
        });
        topics.forEach(topic -> {
            this.brokerTopicStats.allTopicsStats().totalShareAcknowledgementRequestRate().mark();
            this.brokerTopicStats.topicStats((String)topic).totalShareAcknowledgementRequestRate().mark();
        });
        return this.mapAcknowledgementFutures(futures, Optional.of(this.failedShareAcknowledgeMetricsHandler()));
    }

    public CompletableFuture<Map<TopicIdPartition, ShareAcknowledgeResponseData.PartitionData>> releaseSession(String groupId, String memberId) {
        log.trace("Release session request for groupId: {}, memberId: {}", (Object)groupId, (Object)memberId);
        Uuid memberIdUuid = Uuid.fromString((String)memberId);
        List<TopicIdPartition> topicIdPartitions = this.cachedTopicIdPartitionsInShareSession(groupId, memberIdUuid);
        ShareSessionKey key = this.shareSessionKey(groupId, memberIdUuid);
        if (this.cache.remove(key) == null) {
            log.error("Share session error for {}: no such share session found", (Object)key);
            return FutureUtils.failedFuture(Errors.SHARE_SESSION_NOT_FOUND.exception());
        }
        log.debug("Removed share session with key " + String.valueOf(key));
        if (topicIdPartitions.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        HashMap<TopicIdPartition, CompletableFuture<Throwable>> futuresMap = new HashMap<TopicIdPartition, CompletableFuture<Throwable>>();
        topicIdPartitions.forEach(topicIdPartition -> {
            SharePartitionKey sharePartitionKey = this.sharePartitionKey(groupId, (TopicIdPartition)topicIdPartition);
            SharePartition sharePartition = this.partitionCacheMap.get(sharePartitionKey);
            if (sharePartition == null) {
                log.error("No share partition found for groupId {} topicPartition {} while releasing acquired topic partitions", (Object)groupId, topicIdPartition);
                futuresMap.put((TopicIdPartition)topicIdPartition, (CompletableFuture<Throwable>)CompletableFuture.completedFuture(Errors.UNKNOWN_TOPIC_OR_PARTITION.exception()));
            } else {
                CompletableFuture future = new CompletableFuture();
                sharePartition.releaseAcquiredRecords(memberId).whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        this.fencedSharePartitionHandler().accept(sharePartitionKey, (Throwable)throwable);
                        future.complete(throwable);
                        return;
                    }
                    future.complete(null);
                });
                DelayedShareFetchGroupKey delayedShareFetchKey = new DelayedShareFetchGroupKey(groupId, topicIdPartition.topicId(), topicIdPartition.partition());
                this.replicaManager.completeDelayedShareFetchRequest(delayedShareFetchKey);
                futuresMap.put((TopicIdPartition)topicIdPartition, future);
            }
        });
        return this.mapAcknowledgementFutures(futuresMap, Optional.empty());
    }

    private CompletableFuture<Map<TopicIdPartition, ShareAcknowledgeResponseData.PartitionData>> mapAcknowledgementFutures(Map<TopicIdPartition, CompletableFuture<Throwable>> futuresMap, Optional<Consumer<Set<String>>> failedMetricsHandler) {
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futuresMap.values().toArray(new CompletableFuture[0]));
        return allFutures.thenApply(v -> {
            HashMap result = new HashMap();
            HashSet failedTopics = new HashSet();
            futuresMap.forEach((topicIdPartition, future) -> {
                ShareAcknowledgeResponseData.PartitionData partitionData = new ShareAcknowledgeResponseData.PartitionData().setPartitionIndex(topicIdPartition.partition());
                Throwable t = (Throwable)future.join();
                if (t != null) {
                    partitionData.setErrorCode(Errors.forException((Throwable)t).code()).setErrorMessage(t.getMessage());
                    failedTopics.add(topicIdPartition.topic());
                }
                result.put(topicIdPartition, partitionData);
            });
            failedMetricsHandler.ifPresent(handler -> handler.accept(failedTopics));
            return result;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFetchContext newContext(String groupId, Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> shareFetchData, List<TopicIdPartition> toForget, ShareRequestMetadata reqMetadata, Boolean isAcknowledgeDataPresent) {
        ShareFetchContext context;
        HashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData> shareFetchDataWithMaxBytes = new HashMap<TopicIdPartition, ShareFetchRequest.SharePartitionData>();
        shareFetchData.forEach((tp, sharePartitionData) -> {
            if (sharePartitionData.maxBytes > 0) {
                shareFetchDataWithMaxBytes.put((TopicIdPartition)tp, (ShareFetchRequest.SharePartitionData)sharePartitionData);
            }
        });
        if (reqMetadata.isFull()) {
            ShareSessionKey key = this.shareSessionKey(groupId, reqMetadata.memberId());
            if (reqMetadata.epoch() == -1) {
                if (!shareFetchDataWithMaxBytes.isEmpty()) {
                    throw Errors.INVALID_REQUEST.exception();
                }
                if (this.cache.get(key) == null) {
                    log.error("Share session error for {}: no such share session found", (Object)key);
                    throw Errors.SHARE_SESSION_NOT_FOUND.exception();
                }
                context = new FinalContext();
            } else {
                if (isAcknowledgeDataPresent.booleanValue()) {
                    log.error("Acknowledge data present in Initial Fetch Request for group {} member {}", (Object)groupId, (Object)reqMetadata.memberId());
                    throw Errors.INVALID_REQUEST.exception();
                }
                if (this.cache.remove(key) != null) {
                    log.debug("Removed share session with key {}", (Object)key);
                }
                ImplicitLinkedHashCollection cachedSharePartitions = new ImplicitLinkedHashCollection(shareFetchDataWithMaxBytes.size());
                shareFetchDataWithMaxBytes.forEach((topicIdPartition, reqData) -> cachedSharePartitions.mustAdd((ImplicitLinkedHashCollection.Element)new CachedSharePartition((TopicIdPartition)topicIdPartition, (ShareFetchRequest.SharePartitionData)reqData, false)));
                ShareSessionKey responseShareSessionKey = this.cache.maybeCreateSession(groupId, reqMetadata.memberId(), this.time.milliseconds(), (ImplicitLinkedHashCollection<CachedSharePartition>)cachedSharePartitions);
                if (responseShareSessionKey == null) {
                    log.error("Could not create a share session for group {} member {}", (Object)groupId, (Object)reqMetadata.memberId());
                    throw Errors.SHARE_SESSION_NOT_FOUND.exception();
                }
                context = new ShareSessionContext(reqMetadata, shareFetchDataWithMaxBytes);
                log.debug("Created a new ShareSessionContext with key {} isSubsequent {} returning {}. A new share session will be started.", new Object[]{responseShareSessionKey, false, SharePartitionManager.partitionsToLogString(shareFetchDataWithMaxBytes.keySet())});
            }
        } else {
            ShareSessionCache shareSessionCache = this.cache;
            synchronized (shareSessionCache) {
                ShareSessionKey key = this.shareSessionKey(groupId, reqMetadata.memberId());
                ShareSession shareSession = this.cache.get(key);
                if (shareSession == null) {
                    log.error("Share session error for {}: no such share session found", (Object)key);
                    throw Errors.SHARE_SESSION_NOT_FOUND.exception();
                }
                if (shareSession.epoch != reqMetadata.epoch()) {
                    log.debug("Share session error for {}: expected epoch {}, but got {} instead", new Object[]{key, shareSession.epoch, reqMetadata.epoch()});
                    throw Errors.INVALID_SHARE_SESSION_EPOCH.exception();
                }
                Map<ShareSession.ModifiedTopicIdPartitionType, List<TopicIdPartition>> modifiedTopicIdPartitions = shareSession.update(shareFetchDataWithMaxBytes, toForget);
                this.cache.touch(shareSession, this.time.milliseconds());
                shareSession.epoch = ShareRequestMetadata.nextEpoch((int)shareSession.epoch);
                log.debug("Created a new ShareSessionContext for session key {}, epoch {}: added {}, updated {}, removed {}", new Object[]{shareSession.key(), shareSession.epoch, SharePartitionManager.partitionsToLogString((Collection<TopicIdPartition>)modifiedTopicIdPartitions.get((Object)ShareSession.ModifiedTopicIdPartitionType.ADDED)), SharePartitionManager.partitionsToLogString((Collection<TopicIdPartition>)modifiedTopicIdPartitions.get((Object)ShareSession.ModifiedTopicIdPartitionType.UPDATED)), SharePartitionManager.partitionsToLogString((Collection<TopicIdPartition>)modifiedTopicIdPartitions.get((Object)ShareSession.ModifiedTopicIdPartitionType.REMOVED))});
                context = new ShareSessionContext(reqMetadata, shareSession);
            }
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeSessionUpdate(String groupId, ShareRequestMetadata reqMetadata) {
        if (reqMetadata.epoch() == 0) {
            throw Errors.INVALID_SHARE_SESSION_EPOCH.exception();
        }
        ShareSessionCache shareSessionCache = this.cache;
        synchronized (shareSessionCache) {
            ShareSessionKey key = this.shareSessionKey(groupId, reqMetadata.memberId());
            ShareSession shareSession = this.cache.get(key);
            if (shareSession == null) {
                log.debug("Share session error for {}: no such share session found", (Object)key);
                throw Errors.SHARE_SESSION_NOT_FOUND.exception();
            }
            if (reqMetadata.epoch() == -1) {
                return;
            }
            if (shareSession.epoch != reqMetadata.epoch()) {
                log.debug("Share session error for {}: expected epoch {}, but got {} instead", new Object[]{key, shareSession.epoch, reqMetadata.epoch()});
                throw Errors.INVALID_SHARE_SESSION_EPOCH.exception();
            }
            this.cache.touch(shareSession, this.time.milliseconds());
            shareSession.epoch = ShareRequestMetadata.nextEpoch((int)shareSession.epoch);
        }
    }

    List<TopicIdPartition> cachedTopicIdPartitionsInShareSession(String groupId, Uuid memberId) {
        ShareSessionKey key = this.shareSessionKey(groupId, memberId);
        ShareSession shareSession = this.cache.get(key);
        if (shareSession == null) {
            return Collections.emptyList();
        }
        ArrayList<TopicIdPartition> cachedTopicIdPartitions = new ArrayList<TopicIdPartition>();
        shareSession.partitionMap().forEach(cachedSharePartition -> cachedTopicIdPartitions.add(new TopicIdPartition(cachedSharePartition.topicId(), new TopicPartition(cachedSharePartition.topic(), cachedSharePartition.partition()))));
        return cachedTopicIdPartitions;
    }

    private void addDelayedShareFetch(DelayedShareFetch delayedShareFetch, List<DelayedShareFetchKey> keys) {
        this.replicaManager.addDelayedShareFetchRequest(delayedShareFetch, keys);
    }

    @Override
    public void close() throws Exception {
        this.timer.close();
    }

    private ShareSessionKey shareSessionKey(String groupId, Uuid memberId) {
        return new ShareSessionKey(groupId, memberId);
    }

    private static String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return ShareSession.partitionsToLogString(partitions, log.isTraceEnabled());
    }

    void processShareFetch(ShareFetch shareFetch) {
        if (shareFetch.partitionMaxBytes().isEmpty()) {
            shareFetch.maybeComplete(Collections.emptyMap());
            return;
        }
        ArrayList<DelayedShareFetchKey> delayedShareFetchWatchKeys = new ArrayList<DelayedShareFetchKey>();
        LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions = new LinkedHashMap<TopicIdPartition, SharePartition>();
        HashSet<String> topics = new HashSet<String>();
        for (TopicIdPartition topicIdPartition : shareFetch.partitionMaxBytes().keySet()) {
            SharePartition sharePartition;
            topics.add(topicIdPartition.topic());
            SharePartitionKey sharePartitionKey = this.sharePartitionKey(shareFetch.groupId(), topicIdPartition);
            try {
                sharePartition = this.getOrCreateSharePartition(sharePartitionKey);
            }
            catch (Exception e) {
                log.debug("Error processing share fetch request", (Throwable)e);
                shareFetch.addErroneous(topicIdPartition, e);
                continue;
            }
            DelayedShareFetchGroupKey delayedShareFetchKey = new DelayedShareFetchGroupKey(shareFetch.groupId(), topicIdPartition.topicId(), topicIdPartition.partition());
            delayedShareFetchWatchKeys.add(delayedShareFetchKey);
            delayedShareFetchWatchKeys.add(new DelayedShareFetchPartitionKey(topicIdPartition.topicId(), topicIdPartition.partition()));
            CompletableFuture<Void> initializationFuture = sharePartition.maybeInitialize();
            boolean initialized = initializationFuture.isDone();
            initializationFuture.whenComplete((result, throwable) -> {
                if (throwable != null) {
                    this.handleInitializationException(sharePartitionKey, shareFetch, (Throwable)throwable);
                }
                if (!initialized) {
                    this.replicaManager.completeDelayedShareFetchRequest(delayedShareFetchKey);
                }
            });
            sharePartitions.put(topicIdPartition, sharePartition);
        }
        topics.forEach(topic -> {
            this.brokerTopicStats.allTopicsStats().totalShareFetchRequestRate().mark();
            this.brokerTopicStats.topicStats((String)topic).totalShareFetchRequestRate().mark();
        });
        if (shareFetch.errorInAllPartitions()) {
            shareFetch.maybeComplete(Collections.emptyMap());
            return;
        }
        this.addDelayedShareFetch(new DelayedShareFetch(shareFetch, this.replicaManager, this.fencedSharePartitionHandler(), sharePartitions), delayedShareFetchWatchKeys);
    }

    private SharePartition getOrCreateSharePartition(SharePartitionKey sharePartitionKey) {
        return this.partitionCacheMap.computeIfAbsent(sharePartitionKey, k -> {
            long start = this.time.hiResClockMs();
            int leaderEpoch = ShareFetchUtils.leaderEpoch(this.replicaManager, sharePartitionKey.topicIdPartition().topicPartition());
            SharePartitionListener listener = new SharePartitionListener(sharePartitionKey, this.replicaManager, this.partitionCacheMap);
            this.replicaManager.maybeAddListener(sharePartitionKey.topicIdPartition().topicPartition(), listener);
            SharePartition partition = new SharePartition(sharePartitionKey.groupId(), sharePartitionKey.topicIdPartition(), leaderEpoch, this.maxInFlightMessages, this.maxDeliveryCount, this.defaultRecordLockDurationMs, this.timer, this.time, this.persister, this.replicaManager, this.groupConfigManager, listener);
            this.shareGroupMetrics.partitionLoadTime(start);
            return partition;
        });
    }

    private void handleInitializationException(SharePartitionKey sharePartitionKey, ShareFetch shareFetch, Throwable throwable) {
        if (throwable instanceof LeaderNotAvailableException) {
            log.debug("The share partition with key {} is not initialized yet", (Object)sharePartitionKey);
            return;
        }
        SharePartitionManager.removeSharePartitionFromCache(sharePartitionKey, this.partitionCacheMap, this.replicaManager);
        log.debug("Error initializing share partition with key {}", (Object)sharePartitionKey, (Object)throwable);
        shareFetch.addErroneous(sharePartitionKey.topicIdPartition(), throwable);
    }

    private BiConsumer<SharePartitionKey, Throwable> fencedSharePartitionHandler() {
        return (sharePartitionKey, throwable) -> {
            if (throwable instanceof NotLeaderOrFollowerException || throwable instanceof FencedStateEpochException || throwable instanceof GroupIdNotFoundException || throwable instanceof UnknownTopicOrPartitionException) {
                log.info("The share partition with key {} is fenced: {}", sharePartitionKey, (Object)throwable.getMessage());
                SharePartitionManager.removeSharePartitionFromCache(sharePartitionKey, this.partitionCacheMap, this.replicaManager);
            }
        };
    }

    private SharePartitionKey sharePartitionKey(String groupId, TopicIdPartition topicIdPartition) {
        return new SharePartitionKey(groupId, topicIdPartition);
    }

    private static void removeSharePartitionFromCache(SharePartitionKey sharePartitionKey, Map<SharePartitionKey, SharePartition> map, ReplicaManager replicaManager) {
        SharePartition sharePartition = map.remove(sharePartitionKey);
        if (sharePartition != null) {
            sharePartition.markFenced();
            replicaManager.removeListener(sharePartitionKey.topicIdPartition().topicPartition(), sharePartition.listener());
        }
    }

    private Consumer<Set<String>> failedShareAcknowledgeMetricsHandler() {
        return failedTopics -> failedTopics.forEach(topic -> {
            this.brokerTopicStats.allTopicsStats().failedShareAcknowledgementRequestRate().mark();
            this.brokerTopicStats.topicStats((String)topic).failedShareAcknowledgementRequestRate().mark();
        });
    }

    static class ShareGroupMetrics {
        public static final String METRICS_GROUP_NAME = "share-group-metrics";
        public static final String RECORD_ACK_SENSOR_PREFIX = "record-acknowledgement";
        public static final String RECORD_ACK_RATE = "record-acknowledgement-rate";
        public static final String RECORD_ACK_COUNT = "record-acknowledgement-count";
        public static final String ACK_TYPE = "ack-type";
        public static final String PARTITION_LOAD_TIME_SENSOR = "partition-load-time-sensor";
        public static final String PARTITION_LOAD_TIME_AVG = "partition-load-time-avg";
        public static final String PARTITION_LOAD_TIME_MAX = "partition-load-time-max";
        public static final Map<Byte, String> RECORD_ACKS_MAP = new HashMap<Byte, String>();
        private final Time time;
        private final Map<Byte, Sensor> recordAcksSensorMap = new HashMap<Byte, Sensor>();
        private final Sensor partitionLoadTimeSensor;

        public ShareGroupMetrics(Metrics metrics, Time time) {
            this.time = time;
            for (Map.Entry<Byte, String> entry : RECORD_ACKS_MAP.entrySet()) {
                this.recordAcksSensorMap.put(entry.getKey(), metrics.sensor(String.format("%s-%s-sensor", RECORD_ACK_SENSOR_PREFIX, entry.getValue())));
                this.recordAcksSensorMap.get(entry.getKey()).add((CompoundStat)new Meter(metrics.metricName(RECORD_ACK_RATE, METRICS_GROUP_NAME, "Rate of records acknowledged per acknowledgement type.", new String[]{ACK_TYPE, entry.getValue()}), metrics.metricName(RECORD_ACK_COUNT, METRICS_GROUP_NAME, "The number of records acknowledged per acknowledgement type.", new String[]{ACK_TYPE, entry.getValue()})));
            }
            this.partitionLoadTimeSensor = metrics.sensor(PARTITION_LOAD_TIME_SENSOR);
            this.partitionLoadTimeSensor.add(metrics.metricName(PARTITION_LOAD_TIME_AVG, METRICS_GROUP_NAME, "The average time in milliseconds to load the share partitions."), (MeasurableStat)new Avg());
            this.partitionLoadTimeSensor.add(metrics.metricName(PARTITION_LOAD_TIME_MAX, METRICS_GROUP_NAME, "The maximum time in milliseconds to load the share partitions."), (MeasurableStat)new Max());
        }

        void recordAcknowledgement(byte ackType) {
            if (this.recordAcksSensorMap.containsKey(ackType)) {
                this.recordAcksSensorMap.get(ackType).record();
            }
        }

        void partitionLoadTime(long start) {
            this.partitionLoadTimeSensor.record((double)(this.time.hiResClockMs() - start));
        }

        static {
            RECORD_ACKS_MAP.put((byte)1, AcknowledgeType.ACCEPT.toString());
            RECORD_ACKS_MAP.put((byte)2, AcknowledgeType.RELEASE.toString());
            RECORD_ACKS_MAP.put((byte)3, AcknowledgeType.REJECT.toString());
        }
    }

    static class SharePartitionListener
    implements PartitionListener {
        private final SharePartitionKey sharePartitionKey;
        private final ReplicaManager replicaManager;
        private final Map<SharePartitionKey, SharePartition> partitionCacheMap;

        SharePartitionListener(SharePartitionKey sharePartitionKey, ReplicaManager replicaManager, Map<SharePartitionKey, SharePartition> partitionCacheMap) {
            this.sharePartitionKey = sharePartitionKey;
            this.replicaManager = replicaManager;
            this.partitionCacheMap = partitionCacheMap;
        }

        @Override
        public void onFailed(TopicPartition topicPartition) {
            log.debug("The share partition failed listener is invoked for the topic-partition: {}, share-partition: {}", (Object)topicPartition, (Object)this.sharePartitionKey);
            this.onUpdate(topicPartition);
        }

        @Override
        public void onDeleted(TopicPartition topicPartition) {
            log.debug("The share partition delete listener is invoked for the topic-partition: {}, share-partition: {}", (Object)topicPartition, (Object)this.sharePartitionKey);
            this.onUpdate(topicPartition);
        }

        @Override
        public void onBecomingFollower(TopicPartition topicPartition) {
            log.debug("The share partition becoming follower listener is invoked for the topic-partition: {}, share-partition: {}", (Object)topicPartition, (Object)this.sharePartitionKey);
            this.onUpdate(topicPartition);
        }

        private void onUpdate(TopicPartition topicPartition) {
            if (!this.sharePartitionKey.topicIdPartition().topicPartition().equals((Object)topicPartition)) {
                log.error("The share partition listener is invoked for the wrong topic-partition: {}, share-partition: {}", (Object)topicPartition, (Object)this.sharePartitionKey);
                return;
            }
            SharePartitionManager.removeSharePartitionFromCache(this.sharePartitionKey, this.partitionCacheMap, this.replicaManager);
        }
    }
}

