/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.concurrent.ExecutionException;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;

public class S3TierObjectStoreUtils {
    public static void handleAwsSdkV2Exception(String logMessage, ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof TierObjectStoreRetriableException) {
            throw (TierObjectStoreRetriableException)((Object)cause);
        }
        if (cause instanceof TierObjectStoreFatalException) {
            throw (TierObjectStoreFatalException)cause;
        }
        if (cause instanceof E2EChecksumInvalidException) {
            throw (E2EChecksumInvalidException)cause;
        }
        throw new TierObjectStoreFatalException(logMessage, cause != null ? cause : e);
    }
}

