/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import kafka.server.KafkaConfig;
import kafka.tier.fetcher.objectcache.ObjectCacheConfig;

public class TierFetcherConfig {
    public final int numFetchThreads;
    public final int offsetCacheSize;
    public final int offsetCacheExpirationMs;
    public final int offsetCacheExpiryPeriodMs;
    public final long memoryPoolSizeBytes;
    public final boolean asyncFetchEnabled;
    public final int asyncOffsetForTimestampParallelism;
    public final ObjectCacheConfig objectCacheConfig;

    public TierFetcherConfig(KafkaConfig config) {
        this.numFetchThreads = config.confluentConfig().tierFetcherNumThreads();
        this.offsetCacheSize = config.confluentConfig().tierFetcherOffsetCacheSize();
        this.offsetCacheExpirationMs = config.confluentConfig().tierFetcherOffsetCacheExpirationMs();
        this.offsetCacheExpiryPeriodMs = config.confluentConfig().tierFetcherOffsetCacheExpiryPeriodMs();
        Long memoryPoolSize = config.confluentConfig().tierFetcherMemoryPoolSizeBytes();
        this.memoryPoolSizeBytes = memoryPoolSize;
        this.asyncFetchEnabled = config.confluentConfig().tierFetcherAsyncEnable();
        this.asyncOffsetForTimestampParallelism = config.confluentConfig().tierFetcherAsyncOffsetForTimestampParallelism();
        this.objectCacheConfig = new ObjectCacheConfig(config);
    }

    public TierFetcherConfig(int numFetchThreads, int offsetCacheSize, int offsetCacheExpirationMs, int offsetCacheExpiryPeriodMs, Long memoryPoolSizeBytes, boolean asyncFetchEnabled, int asyncOffsetForTimestampParallelism) {
        this.numFetchThreads = numFetchThreads;
        this.offsetCacheSize = offsetCacheSize;
        this.offsetCacheExpirationMs = offsetCacheExpirationMs;
        this.offsetCacheExpiryPeriodMs = offsetCacheExpiryPeriodMs;
        this.memoryPoolSizeBytes = memoryPoolSizeBytes;
        this.asyncFetchEnabled = asyncFetchEnabled;
        this.asyncOffsetForTimestampParallelism = asyncOffsetForTimestampParallelism;
        this.objectCacheConfig = ObjectCacheConfig.DEFAULT;
    }

    public TierFetcherConfig() {
        this.numFetchThreads = 4;
        this.offsetCacheSize = 200000;
        this.offsetCacheExpirationMs = 1800000;
        this.offsetCacheExpiryPeriodMs = 60000;
        this.memoryPoolSizeBytes = 0L;
        this.asyncFetchEnabled = false;
        this.asyncOffsetForTimestampParallelism = 1;
        this.objectCacheConfig = ObjectCacheConfig.DEFAULT;
    }
}

