/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import java.util.Objects;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.ObjectType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.Snapshots;

public class KRaftSnapshotObject
implements Comparable<KRaftSnapshotObject> {
    private static final String FILE_PATH_DELIMITER = "/";
    private static final String FILE_NAME_DELIMITER = "-";
    private static final String VERSION_CONSTANT = "_v";
    private static final int FILE_PATH_IDX_PREFIX = 0;
    private static final int FILE_PATH_IDX_TOPIC_ID = 1;
    private static final int FILE_PATH_IDX_PARTITION = 2;
    private static final int FILE_PATH_IDX_CLUSTER_ID = 3;
    private static final int FILE_PATH_IDX_NODE_ID = 4;
    private static final int FILE_PATH_IDX_FILE_NAME = 5;
    private static final int FILE_NAME_IDX_APPEND_TIMESTAMP_MS = 0;
    private static final int FILE_NAME_IDX_OFFSET = 1;
    private static final int FILE_NAME_IDX_EPOCH = 2;
    public static final int VERSION_V0 = 0;
    private final Uuid topicId;
    private final int partition;
    private final String clusterId;
    private final int nodeId;
    private final long appendTimeStampMs;
    private final OffsetAndEpoch snapshotId;

    public KRaftSnapshotObject(Uuid topicId, int partition, String clusterId, int nodeId, long appendTimeStampMs, OffsetAndEpoch snapshotId) {
        this.topicId = topicId;
        this.partition = partition;
        this.clusterId = clusterId;
        this.nodeId = nodeId;
        this.appendTimeStampMs = appendTimeStampMs;
        this.snapshotId = snapshotId;
    }

    public String encodePath(String keyPrefix, int version) {
        if (keyPrefix.contains(FILE_PATH_DELIMITER)) {
            throw new IllegalArgumentException("keyPrefix=" + keyPrefix + " contains an invalid character /");
        }
        String filePath = KRaftSnapshotObject.filePathPrefixByNode(keyPrefix, this.topicId, this.partition, this.clusterId, this.nodeId);
        String fileName = String.join((CharSequence)FILE_NAME_DELIMITER, Long.toString(this.appendTimeStampMs), Snapshots.filenameFromSnapshotId(this.snapshotId)) + KRaftSnapshotObject.filePathSuffix(version);
        return String.join((CharSequence)FILE_PATH_DELIMITER, filePath, fileName);
    }

    public static KRaftSnapshotObject decodePath(String keyPrefix, String filePath) {
        String expectedSuffix = KRaftSnapshotObject.filePathSuffix(0);
        if (!filePath.endsWith(expectedSuffix)) {
            throw new IllegalArgumentException("filePath=" + filePath + " should end with suffix=" + expectedSuffix);
        }
        int suffixIdx = filePath.lastIndexOf(expectedSuffix);
        String filePathWithoutSuffix = filePath.substring(0, suffixIdx);
        String[] pathTokens = filePathWithoutSuffix.split(FILE_PATH_DELIMITER);
        if (pathTokens.length != 6) {
            throw new IllegalArgumentException("filePath without suffix=" + filePathWithoutSuffix + " isn't formatted correctly. Split / has " + pathTokens.length + " instead of length 6");
        }
        String expectedPrefix = KRaftSnapshotObject.filePathPrefix(keyPrefix);
        if (!pathTokens[0].equals(expectedPrefix)) {
            throw new IllegalArgumentException("filePath=" + pathTokens[0] + " is not same as ." + expectedPrefix);
        }
        String[] fileNameTokens = pathTokens[5].split(FILE_NAME_DELIMITER);
        if (fileNameTokens.length != 3) {
            throw new IllegalArgumentException("fileName=" + pathTokens[5] + " isn't formatted correctly. Split on - has " + fileNameTokens.length + " instead of length 3");
        }
        return new KRaftSnapshotObject(Uuid.fromString((String)pathTokens[1]), Integer.parseInt(pathTokens[2]), pathTokens[3], Integer.parseInt(pathTokens[4]), Long.parseLong(fileNameTokens[0]), new OffsetAndEpoch(Long.parseLong(fileNameTokens[1]), Integer.parseInt(fileNameTokens[2])));
    }

    static String filePathPrefix(String keyPrefix) {
        return keyPrefix + TierObjectStore.DataTypePathPrefix.KRAFT_SNAPSHOT.prefix();
    }

    static String filePathPrefixByNode(String keyPrefix, Uuid topicId, int partition, String clusterId, int nodeId) {
        return String.join((CharSequence)FILE_PATH_DELIMITER, KRaftSnapshotObject.filePathPrefix(keyPrefix), topicId.toString(), Integer.toString(partition), clusterId, Integer.toString(nodeId));
    }

    private static String filePathSuffix(int version) {
        return VERSION_CONSTANT + version + "." + ObjectType.KRAFT_SNAPSHOT.suffix();
    }

    public String toString() {
        return "KRaftSnapshotObject(topicId=" + String.valueOf(this.topicId) + ", partition=" + this.partition + ", clusterId='" + this.clusterId + "', nodeId=" + this.nodeId + ", appendTimeStampMs=" + this.appendTimeStampMs + ", offsetAndEpoch=" + String.valueOf(this.snapshotId) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KRaftSnapshotObject that = (KRaftSnapshotObject)o;
        return this.partition == that.partition && Objects.equals(this.topicId, that.topicId) && Objects.equals(this.clusterId, that.clusterId) && this.nodeId == that.nodeId && this.appendTimeStampMs == that.appendTimeStampMs && Objects.equals(this.snapshotId, that.snapshotId);
    }

    public int hashCode() {
        return Objects.hash(this.topicId, this.partition, this.clusterId, this.nodeId, this.appendTimeStampMs, this.snapshotId);
    }

    @Override
    public int compareTo(KRaftSnapshotObject o) {
        int compare1 = this.topicId.compareTo(o.topicId);
        if (compare1 != 0) {
            return compare1;
        }
        int compare2 = Integer.compare(this.partition, o.partition);
        if (compare2 != 0) {
            return compare2;
        }
        int compare3 = this.clusterId.compareTo(o.clusterId);
        if (compare3 != 0) {
            return compare3;
        }
        int compare4 = Integer.compare(this.nodeId, o.nodeId);
        if (compare4 != 0) {
            return compare4;
        }
        int compare5 = Long.compare(this.appendTimeStampMs, o.appendTimeStampMs);
        if (compare5 != 0) {
            return compare5;
        }
        return this.snapshotId.compareTo(o.snapshotId);
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public int partition() {
        return this.partition;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int nodeId() {
        return this.nodeId;
    }

    public long appendTimeStampMs() {
        return this.appendTimeStampMs;
    }

    public OffsetAndEpoch snapshotId() {
        return this.snapshotId;
    }
}

