/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import io.confluent.kafka.storage.tier.serdes.TierPartitionStateHeader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.MultiChecksumTypeException;
import org.apache.kafka.common.errors.OtherChecksumTypeException;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumUtils {
    private static final Logger log = LoggerFactory.getLogger(ChecksumUtils.class);

    public static void maybeMigrateChecksumFormat(Algorithm checksumAlgorithm, short checksumSuperBlockLength, Path path) throws IOException {
        try {
            CheckedFileIO.verifyOnlyValidFileExists(checksumAlgorithm, path);
            log.debug("No migration performed for path: " + String.valueOf(path) + " as file already in " + checksumAlgorithm.suffix + " format");
        }
        catch (OtherChecksumTypeException e) {
            log.info("Other format file found for path: " + String.valueOf(path) + " " + e.getMessage());
            CheckedFileIO.migrateFile(ChecksumUtils.previousFormatPath(path), path, checksumSuperBlockLength);
        }
        catch (MultiChecksumTypeException e) {
            log.warn("Multiple format files found for path: " + String.valueOf(path) + " " + e.getMessage());
            Path oldPath = ChecksumUtils.previousFormatPath(path);
            if (ChecksumUtils.compareTierStateFiles(oldPath, path)) {
                log.warn("Deleting " + String.valueOf(oldPath) + " format file as it has an older tier epoch / offset than " + String.valueOf(path));
                FilesWrapper.delete((Path)oldPath);
            } else {
                log.warn("Deleting " + String.valueOf(path) + " format file as it has an older tier epoch / offset than " + String.valueOf(oldPath));
                FilesWrapper.delete((Path)path);
                CheckedFileIO.migrateFile(oldPath, path, checksumSuperBlockLength);
            }
        }
        catch (FileNotFoundException e) {
            log.debug("File not found during migration for path: " + String.valueOf(path) + " " + e.getMessage());
        }
    }

    public static Path previousFormatPath(Path path) {
        Path prvPath = CheckedFileIO.isValidPath(Algorithm.ADLER, path) ? CheckedFileIO.validPath(Algorithm.NO_CHECKSUM, path) : CheckedFileIO.validPath(Algorithm.ADLER, path);
        return prvPath;
    }

    public static void maybeRemovePreviousFormatPath(Path path) throws IOException {
        Path prvPath = ChecksumUtils.previousFormatPath(path);
        FilesWrapper.deleteIfExists((Path)prvPath);
    }

    static boolean compareTierStateFiles(Path oldPath, Path newPath) throws IOException {
        CheckedFileIO oldChannel = CheckedFileIO.open(oldPath, true, StandardOpenOption.READ);
        Optional<Header> oldHeaderOpt = FileTierPartitionState.readHeader(oldChannel);
        CheckedFileIO newChannel = CheckedFileIO.open(newPath, true, StandardOpenOption.READ);
        Optional<Header> newHeaderOpt = FileTierPartitionState.readHeader(newChannel);
        return ChecksumUtils.compareTierStateHeaders(oldHeaderOpt, newHeaderOpt);
    }

    public static boolean compareTierStateHeaders(Optional<Header> oldHeaderOpt, Optional<Header> newHeaderOpt) {
        if (oldHeaderOpt.isPresent() && newHeaderOpt.isPresent()) {
            Header oldHeader = oldHeaderOpt.get();
            Header newHeader = newHeaderOpt.get();
            if (oldHeader.tierEpoch() != newHeader.tierEpoch()) {
                return newHeader.tierEpoch() > oldHeader.tierEpoch();
            }
            if (oldHeader.endOffset() == newHeader.endOffset()) {
                return ChecksumUtils.compareOffsetAndEpoch(oldHeader.localMaterializedOffsetAndEpoch(), newHeader.localMaterializedOffsetAndEpoch(), oldHeader.topicId());
            }
            return newHeader.endOffset() > oldHeader.endOffset();
        }
        if (newHeaderOpt.isPresent()) {
            return true;
        }
        if (oldHeaderOpt.isPresent()) {
            return false;
        }
        throw new KafkaStorageException("Failed to compare tier files as both files do not have a valid header present");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyAlgorithm(ByteBuffer state, Algorithm algo) throws IOException {
        Path tmpPath = FilesWrapper.createTempFile((String)"tmp", (String)algo.suffix, (FileAttribute[])new FileAttribute[0]);
        FileChannel channel = FileChannel.open(tmpPath, StandardOpenOption.READ, StandardOpenOption.WRITE);
        Utils.writeFully((FileChannel)channel, (ByteBuffer)state);
        channel.close();
        try {
            boolean bl;
            block11: {
                CheckedFileIO cfIO = CheckedFileIO.open(tmpPath, StandardOpenOption.READ);
                try {
                    cfIO.validate();
                    FileTierPartitionState.readHeader(cfIO);
                    bl = true;
                    if (cfIO == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (cfIO != null) {
                            try {
                                cfIO.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.info("Target input FTPS failed to verify checksum algorithm: " + String.valueOf((Object)algo) + ". This maybe expected during materialization of version=0 TierPartitionForceRestore events ", (Throwable)e);
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                cfIO.close();
            }
            return bl;
        }
        finally {
            FilesWrapper.delete((Path)tmpPath);
        }
    }

    static Algorithm inferAlgorithm(ByteBuffer state) throws IOException {
        if (ChecksumUtils.verifyAlgorithm(state.duplicate(), Algorithm.ADLER)) {
            return Algorithm.ADLER;
        }
        if (ChecksumUtils.verifyAlgorithm(state.duplicate(), Algorithm.NO_CHECKSUM)) {
            return Algorithm.NO_CHECKSUM;
        }
        throw new KafkaStorageException("Failed to infer checksum algorithm for FTPS file");
    }

    public static Algorithm tierStateFileAlgorithm(Path path) {
        if (MergedLog.isTierStateFile(path.toFile())) {
            if (CheckedFileIO.isValidPath(Algorithm.ADLER, path)) {
                return Algorithm.ADLER;
            }
            if (CheckedFileIO.isValidPath(Algorithm.NO_CHECKSUM, path)) {
                return Algorithm.NO_CHECKSUM;
            }
        }
        throw new IllegalArgumentException("Incorrect file format for tier state file, provided file path: ${file.toPath}");
    }

    public static Optional<Header> readRemoteHeader(Algorithm checksumAlgorithm, InputStream stream) throws IOException {
        Optional<Short> headerSizeOpt;
        if (checksumAlgorithm == Algorithm.ADLER) {
            ChecksumUtils.readRemoteSuperBlock(stream);
        }
        if (!(headerSizeOpt = ChecksumUtils.readRemoteHeaderSize(stream)).isPresent()) {
            return Optional.empty();
        }
        short headerSize = headerSizeOpt.get();
        ByteBuffer headerBuf = ByteBuffer.allocate(headerSize);
        Utils.readFully((InputStream)stream, (ByteBuffer)headerBuf, (boolean)false);
        headerBuf.flip();
        if (headerBuf.limit() != headerSize) {
            return Optional.empty();
        }
        return Optional.of(new Header(TierPartitionStateHeader.getRootAsTierPartitionStateHeader(headerBuf)));
    }

    private static Optional<Short> readRemoteHeaderSize(InputStream stream) throws IOException {
        ByteBuffer headerPrefixBuf = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        Utils.readFully((InputStream)stream, (ByteBuffer)headerPrefixBuf, (boolean)false);
        headerPrefixBuf.flip();
        if (headerPrefixBuf.limit() == 2) {
            return Optional.of(headerPrefixBuf.getShort());
        }
        return Optional.empty();
    }

    private static void readRemoteSuperBlock(InputStream stream) throws IOException {
        ByteBuffer superBlockParams = ByteBuffer.allocate(4).order(CheckedFileIO.BYTE_ORDER);
        Utils.readFully((InputStream)stream, (ByteBuffer)superBlockParams, (boolean)false);
        if (superBlockParams.hasRemaining()) {
            throw new IOException("Unable to read Header params length buffer as it has more data remaining");
        }
        superBlockParams.flip();
        short superBlockLength = superBlockParams.getShort();
        ByteBuffer superBlockBufRemaining = ByteBuffer.allocate(superBlockLength - 4).order(CheckedFileIO.BYTE_ORDER);
        Utils.readFully((InputStream)stream, (ByteBuffer)superBlockBufRemaining, (boolean)false);
        superBlockBufRemaining.flip();
    }

    public static boolean compareOffsetAndEpoch(OffsetAndEpoch oldOffsetAndEpoch, OffsetAndEpoch newOffsetAndEpoch, UUID topicId) {
        if (oldOffsetAndEpoch.epoch().isPresent() && newOffsetAndEpoch.epoch().isPresent()) {
            int newEpoch;
            int oldEpoch = oldOffsetAndEpoch.epoch().get();
            if (oldEpoch != (newEpoch = newOffsetAndEpoch.epoch().get().intValue())) {
                if (oldEpoch > newEpoch && oldOffsetAndEpoch.offset() <= newOffsetAndEpoch.offset()) {
                    throw new KafkaStorageException(String.format("Discrepancy in FTPS materialized offset: %s when compared with %s for topic with ID: %s. New offsetAndEpoch has a smaller epoch, but a larger offset, which is unexpected.", newOffsetAndEpoch, oldOffsetAndEpoch, topicId.toString()));
                }
                if (oldEpoch < newEpoch && oldOffsetAndEpoch.offset() >= newOffsetAndEpoch.offset()) {
                    throw new KafkaStorageException(String.format("Discrepancy in FTPS materialized offset: %s when compared with %s for topic with ID: %s. New offsetAndEpoch has a larger epoch, but a smaller offset, which is unexpected.", newOffsetAndEpoch, oldOffsetAndEpoch, topicId.toString()));
                }
                return newEpoch > oldEpoch;
            }
            return newOffsetAndEpoch.offset() > oldOffsetAndEpoch.offset();
        }
        if (newOffsetAndEpoch.epoch().isPresent()) {
            return true;
        }
        if (oldOffsetAndEpoch.epoch().isPresent()) {
            return false;
        }
        throw new KafkaStorageException("Failed to compare OffsetAndEpoch objects as both objects do not have a valid epoch present");
    }
}

