/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import io.confluent.kafka.storage.tier.serdes.TierPartitionStateHeader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogSegment;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierCompactionCommitAndSwap;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierPartitionUnfence;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.domain.TierRecordType;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.TierMetadataFatalException;
import kafka.tier.exceptions.TierPartitionStateClosedException;
import kafka.tier.exceptions.TierPartitionStateCorruptedException;
import kafka.tier.exceptions.TierPartitionStateIllegalListenerException;
import kafka.tier.exceptions.TierSnapshotChecksumValidationFailedException;
import kafka.tier.state.ChecksumUtils;
import kafka.tier.state.CompactStats;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.FileTierPartitionStateUtils;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.state.TierUtils;
import kafka.utils.CoreUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.KafkaStorageMetadataCorruptionException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FollowerRestorePoint;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTierPartitionState
implements TierPartitionState,
AutoCloseable {
    static final byte CURRENT_VERSION = 11;
    private static final int ENTRY_LENGTH_SIZE = 2;
    public static final long FILE_OFFSET = 0L;
    static final long OLD_STATE_CLOSE_DELAY_MS = 3600000L;
    private static final Logger log = LoggerFactory.getLogger(FileTierPartitionState.class);
    private static final Set<TierObjectMetadata.State> FENCED_STATES = Collections.singleton(TierObjectMetadata.State.SEGMENT_FENCED);
    private static final Set<TierObjectMetadata.State> COMPACTED_STATES = Collections.singleton(TierObjectMetadata.State.SEGMENT_COMPACTED);
    private final TopicPartition topicPartition;
    private final byte version;
    private final Scheduler scheduler;
    private final boolean compactFeatureFlag;
    private final Time time;
    private final Object stateLock = new Object();
    private final Consumer<IOException> ioExceptionHandler;
    private volatile State state;
    private volatile TopicIdPartition topicIdPartition;
    private volatile boolean tieringEnabled;
    private volatile String basePath;
    private volatile File dir;
    private final Algorithm checksumAlgorithm;
    private final short checksumSuperBlockLength;
    public static final short SUPER_BLOCK_LENGTH_ADLER = 512;
    public static final short SUPER_BLOCK_LENGTH_NO_CHECKSUM = 0;
    public final TierPartitionStateCleanupConfig cleanupConfig;
    private volatile long nextCleanupTimestampMs;
    private final boolean tierPartitionStateSnapshotFeatureFlag;
    private final int brokerId;

    public FileTierPartitionState(File dir, LogDirFailureChannel logDirFailureChannel, TopicPartition topicPartition, boolean tieringEnabled, Scheduler scheduler, boolean checksumEnabled, boolean compactFeatureFlag, Time time, TierPartitionStateCleanupConfig cleanupConfig, boolean tierPartitionStateSnapshotFeatureFlag, int brokerId) throws IOException {
        this(dir, logDirFailureChannel, topicPartition, tieringEnabled, 11, scheduler, checksumEnabled, compactFeatureFlag, time, cleanupConfig, tierPartitionStateSnapshotFeatureFlag, brokerId);
    }

    FileTierPartitionState(File dir, LogDirFailureChannel logDirFailureChannel, TopicPartition topicPartition, boolean tieringEnabled, byte version, Scheduler scheduler, boolean checksumEnabled, boolean compactFeatureFlag, Time time, TierPartitionStateCleanupConfig cleanupConfig, boolean tierPartitionStateSnapshotFeatureFlag, int brokerId) throws IOException {
        this.topicPartition = topicPartition;
        this.dir = dir;
        this.ioExceptionHandler = e -> logDirFailureChannel.maybeAddOfflineLogDir(this.dir().getParent(), "IOException encountered in TierPartitionState at " + this.dir().getParent(), (IOException)e);
        this.basePath = MergedLog.tierStateFile(dir, 0L, "").getAbsolutePath();
        this.tieringEnabled = tieringEnabled;
        this.compactFeatureFlag = compactFeatureFlag;
        this.state = State.EMPTY;
        this.version = version;
        this.scheduler = scheduler;
        this.time = time;
        this.cleanupConfig = cleanupConfig;
        this.nextCleanupTimestampMs = time.milliseconds() + ThreadLocalRandom.current().nextLong(cleanupConfig.interval() / 2L, cleanupConfig.interval() + 1L);
        if (checksumEnabled) {
            this.checksumAlgorithm = Algorithm.ADLER;
            this.checksumSuperBlockLength = (short)512;
        } else {
            this.checksumAlgorithm = Algorithm.NO_CHECKSUM;
            this.checksumSuperBlockLength = 0;
        }
        this.tierPartitionStateSnapshotFeatureFlag = tierPartitionStateSnapshotFeatureFlag;
        this.brokerId = brokerId;
        this.maybeOpenChannel(false);
    }

    @Override
    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    public Optional<TopicIdPartition> topicIdPartition() {
        return Optional.ofNullable(this.topicIdPartition);
    }

    @Override
    public boolean setTopicId(UUID topicId) throws IOException {
        if (this.topicIdPartition != null) {
            if (!this.topicIdPartition.topicId().equals(topicId)) {
                throw new IllegalStateException("Illegal reassignment of topic id. Current: " + String.valueOf(this.topicIdPartition) + " Assigned: " + String.valueOf(topicId));
            }
            return false;
        }
        this.topicIdPartition = new TopicIdPartition(this.topicPartition.topic(), topicId, this.topicPartition.partition());
        log.info("Setting topicIdPartition {}", (Object)this.topicIdPartition);
        this.maybeOpenChannel(false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTieringEnabled() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.tieringEnabled && this.topicIdPartition != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTieringEnabled() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.tieringEnabled) {
                log.info("Setting tieringEnabled to true (earlier value: " + this.tieringEnabled + ")");
                this.tieringEnabled = true;
            }
            if (!this.status().isOpen()) {
                this.maybeOpenChannel(false);
                log.info((this.status().isOpen() ? "Successfully opened " : "Not able to open ") + "the channel");
                return this.status().isOpen();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTieringDisabled() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.tieringEnabled) {
                log.info("Setting tieringEnabled to false (earlier value: " + this.tieringEnabled + ")");
                this.tieringEnabled = false;
            }
        }
    }

    @Override
    public Optional<Long> startOffset() {
        return this.state.startOffset();
    }

    @Override
    public long endOffset() {
        return this.state.endOffset();
    }

    @Override
    public long dataEndOffset() {
        return this.state.dataEndOffset();
    }

    @Override
    public long compactDirtyStartOffset() {
        return this.state.compactDirtyStartOffset();
    }

    @Override
    public CompactStats lastCompactStats() {
        return this.state.lastCompactStats();
    }

    @Override
    public CompactStats accumulatedCompactStats() {
        return this.state.accumulatedCompactStats();
    }

    @Override
    public long committedEndOffset() {
        return this.state.committedEndOffset();
    }

    @Override
    public long totalSize() {
        return this.state.totalSize();
    }

    @Override
    public long stateFileSize() {
        return this.state.tierPartitionStateFileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.shouldTriggerCleanup()) {
                return this.cleanupAndFlush();
            }
            return this.state.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Path backupStateForRecovery() {
        Object object = this.stateLock;
        synchronized (object) {
            return FileTierPartitionState.copyFlushedFileForRecoveryUpload(this.topicIdPartition, this.basePath, this.checksumAlgorithm, this.status(), this.ioExceptionHandler);
        }
    }

    public boolean shouldTriggerCleanup() {
        if (!this.cleanupConfig.isEnabled()) {
            return false;
        }
        if (!this.state.dirty || !this.state.hasDeletedSegmentAfterPreviousCleanup) {
            return false;
        }
        if (this.status().isPendingDeletion() || !this.status().isOpenForWrite()) {
            return false;
        }
        return this.time.milliseconds() >= this.nextCleanupTimestampMs;
    }

    private boolean cleanupAndFlush() throws IOException {
        State newState;
        log.info("Start tier partition state cleanup for topicIdPartition={}", (Object)this.topicIdPartition);
        long startTimeMs = this.time.milliseconds();
        Path cleanupPath = FileTierPartitionState.cleanupPath(this.basePath, this.checksumAlgorithm);
        CheckedFileIO cleanupChannel = CheckedFileIO.openOrCreate(cleanupPath, this.checksumAlgorithm, this.checksumSuperBlockLength, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.READ, StandardOpenOption.WRITE);
        FileTierPartitionState.writeHeader(cleanupChannel, new Header(this.topicIdPartition.topicId(), this.version, this.state.currentEpoch, this.state.status, this.state.startOffset().orElse(-1L), this.state.endOffset, this.state.globalMaterializedOffsetAndEpoch, this.state.localMaterializedOffsetAndEpoch, this.state.errorOffsetAndEpoch, this.state.restoreOffsetAndEpoch, this.compactFeatureFlag, this.state.compactDirtyStartOffset, this.state.lastCompactStats, this.state.accumulatedCompactStats, this.state.includeStateChangeTimestamp, this.tierPartitionStateSnapshotFeatureFlag, this.state.lastSnapshotTimestampMs, this.state.lastSnapshotId));
        cleanupChannel.position(cleanupChannel.size());
        this.rewriteEntriesAndCleanup(this.state.channel, cleanupChannel, this.topicIdPartition, cleanupChannel.size(), this.compactFeatureFlag, this.cleanupConfig.isEnabled());
        log.info("Write state file to {} for cleanup, topicIdPartition={}", (Object)cleanupPath, (Object)this.topicIdPartition);
        long initEndOffsetForNewState = this.startOffset().orElse(0L) - 1L;
        try {
            newState = new State(this.topicPartition, this.basePath, this.version, cleanupChannel, this.ioExceptionHandler, this.checksumAlgorithm, this.checksumSuperBlockLength, this.compactFeatureFlag, this.cleanupConfig.isEnabled(), initEndOffsetForNewState, this.time, this.state.restoreOffsetAndEpoch, this.state.recoveryWorkflowCb, this.state.listeners, this.tierPartitionStateSnapshotFeatureFlag, this.brokerId);
        }
        catch (Exception e) {
            throw new IOException(String.format("Exception in initializing new TierMetadataState for %s during cleanup", this.topicIdPartition), e);
        }
        State oldState = this.state;
        this.safeStateSwap(this.state.localMaterializedOffsetAndEpoch, cleanupPath, newState, false);
        log.info("State swap complete after cleanup, topicIdPartition={}", (Object)this.topicIdPartition);
        oldState.setStatus(TierPartitionStatus.READ_ONLY);
        oldState.listeners.clear();
        this.scheduleDelayedClose(oldState, "FTPS cleanup event");
        long completeTimeMs = this.time.milliseconds();
        this.nextCleanupTimestampMs = completeTimeMs + this.cleanupConfig.interval();
        log.info("Finished tier partition state cleanup for topicIdPartition={}, with time elapsed {} ms", (Object)this.topicIdPartition, (Object)(completeTimeMs - startTimeMs));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateChecksum() throws IOException, ReflectiveOperationException {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.validate();
        }
    }

    public List<SegmentState> segmentsWithStatesNotEqualTo(Set<TierObjectMetadata.State> excludedStates) {
        return this.state.segmentsWithStatesNotEqualTo(excludedStates);
    }

    private static Path copyFlushedFileForRecoveryUpload(TopicIdPartition topicIdPartition, String basePath, Algorithm checksumAlgorithm, TierPartitionStatus status, Consumer<IOException> ioExceptionHandler) {
        try {
            Path recoveryUploadPath = FileTierPartitionState.recoveryUploadFilePath(basePath, checksumAlgorithm);
            log.debug("Copying tier partition state for {} to {}", (Object)topicIdPartition, (Object)recoveryUploadPath);
            return Files.copy(FileTierPartitionState.flushedFilePath(basePath, checksumAlgorithm), recoveryUploadPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioe) {
            ioExceptionHandler.accept(ioe);
            throw new KafkaStorageException("Failed to copy FTPS file for " + String.valueOf(topicIdPartition) + " for recovery upload. Current status: " + String.valueOf((Object)status), (Throwable)ioe);
        }
    }

    private static void backupMutableFileForDebugging(TopicIdPartition topicIdPartition, String basePath, Path dstPath, Algorithm checksumAlgorithm) throws IOException {
        Path srcPath = FileTierPartitionState.mutableFilePath(basePath, checksumAlgorithm);
        if (!FilesWrapper.exists((Path)srcPath, (LinkOption[])new LinkOption[0])) {
            return;
        }
        FilesWrapper.copy((Path)srcPath, (Path)FileTierPartitionState.tmpFilePath(basePath, checksumAlgorithm), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        Utils.atomicMoveWithFallback((Path)FileTierPartitionState.tmpFilePath(basePath, checksumAlgorithm), (Path)dstPath);
        log.info("Backed up mutable file from: {} to: {}, topicIdPartition={}", new Object[]{srcPath, dstPath, topicIdPartition});
    }

    @Override
    public int tierEpoch() {
        return this.state.currentEpoch();
    }

    @Override
    public File dir() {
        return this.dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.closeHandlersImpl();
            for (StateFileType type : StateFileType.values()) {
                FilesWrapper.deleteIfExists((Path)type.filePath(this.basePath, this.checksumAlgorithm));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDir(File dir) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.basePath = MergedLog.tierStateFile(dir, 0L, "").getAbsolutePath();
            this.dir = dir;
            this.state.updateBasePath(this.basePath);
            FileTierPartitionStateSnapshotObject.maybeCreateAndCleanupSnapshotsDir(this.basePath);
        }
    }

    private Algorithm inferSnapshotChecksumAlgorithm(AbstractTierMetadata metadata, ByteBuffer targetState) throws IOException {
        Algorithm sourceChecksumAlgorithm = Algorithm.NO_CHECKSUM;
        if (metadata instanceof TierPartitionForceRestore) {
            sourceChecksumAlgorithm = ((TierPartitionForceRestore)metadata).version() == 0 ? ChecksumUtils.inferAlgorithm(targetState) : ((TierPartitionForceRestore)metadata).checksumAlgorithm();
        } else if (metadata instanceof TierMetadataSnapshotUploadComplete) {
            sourceChecksumAlgorithm = ((TierMetadataSnapshotUploadComplete)metadata).version() == 1 ? ChecksumUtils.inferAlgorithm(targetState) : ((TierMetadataSnapshotUploadComplete)metadata).checksumAlgorithm();
        }
        log.info("Restoring TierPartitionState for {} from object storage due to event {} using source checksumAlgorithm {}", new Object[]{this.topicIdPartition, metadata, sourceChecksumAlgorithm});
        return sourceChecksumAlgorithm;
    }

    private CheckedFileIO openTargetChannelFromSerializedState(ByteBuffer sourceState, Path sourcePath, Path destinationPath, AbstractTierMetadata metadata) throws IOException {
        ChecksumUtils.maybeRemovePreviousFormatPath(sourcePath);
        FileChannel sourceChannel = FileChannel.open(sourcePath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.READ, StandardOpenOption.WRITE);
        Utils.writeFully((FileChannel)sourceChannel, (ByteBuffer)sourceState);
        sourceChannel.force(true);
        log.info("Persist source FTPS file from object store to {} with size {}", (Object)sourcePath, (Object)sourceChannel.size());
        sourceChannel.close();
        ChecksumUtils.maybeMigrateChecksumFormat(this.checksumAlgorithm, this.checksumSuperBlockLength, destinationPath);
        CheckedFileIO channel = CheckedFileIO.open(destinationPath, StandardOpenOption.READ, StandardOpenOption.WRITE);
        Optional<Header> initialHeaderOpt = FileTierPartitionState.readHeader(channel);
        if (!initialHeaderOpt.isPresent()) {
            throw new IllegalStateException(String.format("TierPartitionState being opened does not contain a valid header, aborting. Metadata %s with target status %s", metadata, sourceState));
        }
        return FileTierPartitionState.maybeMigrateStateFileFormat(this.topicPartition, this.basePath, this.version, destinationPath, channel, initialHeaderOpt.get(), this.checksumAlgorithm, this.checksumSuperBlockLength, this.compactFeatureFlag, this.cleanupConfig.isEnabled(), this.tierPartitionStateSnapshotFeatureFlag, this.time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TierPartitionState.RestoreResult forceRestoreState(TierPartitionForceRestore metadata, ByteBuffer targetState, TierPartitionStatus targetStatus, OffsetAndEpoch offsetAndEpoch) {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.state.status().hasError()) {
                log.warn(String.format("TierPartitionState %s was expected to be in an error status when restoring state via metadata %s with target status %s at offsetEpoch %s", new Object[]{this.state, metadata, targetStatus, offsetAndEpoch}));
                return TierPartitionState.RestoreResult.FAILED;
            }
            if (this.state.status() == TierPartitionStatus.ERROR && metadata.restoreLogStartOffset()) {
                log.warn(String.format("Cannot process metadata %s at offsetEpoch %s%n. FileTierPartitionState must be in FROZEN_LOG_START_OFFSET status if we need to process TierPartitionForceRestore event and recompute the log start offset", metadata, offsetAndEpoch));
                return TierPartitionState.RestoreResult.FAILED;
            }
            try {
                return this.forceRestoreStateUnhandled(metadata, targetState, targetStatus, offsetAndEpoch);
            }
            catch (Exception e) {
                String errorMsg = String.format("Failed to restore state via %s, currentEpoch=%d, tierTopicPartitionOffsetAndEpoch=%s, tierPartitionStatus=%s", new Object[]{metadata, this.state.currentEpoch, offsetAndEpoch, this.state.getStatus()});
                if (e instanceof IOException) {
                    IOException ioe = (IOException)e;
                    this.ioExceptionHandler.accept(ioe);
                    throw new KafkaStorageException(errorMsg, (Throwable)ioe);
                }
                log.error(errorMsg, (Throwable)e);
                return TierPartitionState.RestoreResult.FAILED;
            }
        }
    }

    private TierPartitionState.RestoreResult forceRestoreStateUnhandled(TierPartitionForceRestore metadata, ByteBuffer targetState, TierPartitionStatus targetStatus, OffsetAndEpoch offsetAndEpoch) throws Exception {
        if (FileTierPartitionState.allowedSourceOffset(offsetAndEpoch, this.state.localMaterializedOffsetAndEpoch) && FileTierPartitionState.allowedStateOffset(metadata.stateOffsetAndEpoch(), this.state.restoreOffsetAndEpoch)) {
            Path destinationRecoverPath;
            if (this.state.recoveryWorkflowCb == null && metadata.restoreLogStartOffset()) {
                throw new IllegalStateException(String.format("Cannot process metadata %s at offsetEpoch %s%n. TierPartitionState needs a recovery workflow callback to process a restore state event.", metadata, offsetAndEpoch));
            }
            Algorithm sourceChecksumAlgorithm = this.inferSnapshotChecksumAlgorithm(metadata, targetState);
            Path sourceRecoverPath = FileTierPartitionState.recoverPath(this.basePath, sourceChecksumAlgorithm);
            CheckedFileIO channel = this.openTargetChannelFromSerializedState(targetState, sourceRecoverPath, destinationRecoverPath = FileTierPartitionState.recoverPath(this.basePath, this.checksumAlgorithm), metadata);
            boolean isChecksumValid = channel.validate();
            if (!isChecksumValid) {
                channel.close();
                throw new TierSnapshotChecksumValidationFailedException("Checksum validation failed on newly downloaded FTPS file during state restoration", null);
            }
            log.info("Open recover file by CheckedFileIO with size {}", (Object)channel.size());
            State newState = State.createRestoredState(this.topicPartition, this.basePath, this.version, channel, this.ioExceptionHandler, offsetAndEpoch, targetStatus, this.state.recoveryWorkflowCb, this.checksumAlgorithm, this.checksumSuperBlockLength, this.compactFeatureFlag, this.cleanupConfig.isEnabled(), this.time, this.tierPartitionStateSnapshotFeatureFlag, this.brokerId);
            State oldState = this.state;
            this.safeStateSwap(offsetAndEpoch, destinationRecoverPath, newState, true);
            log.info("Restored TierPartitionState for {} from object storage due to event {}, old state: {} new state: {}", new Object[]{this.topicIdPartition, metadata, oldState, newState});
            if (metadata.restoreLogStartOffset()) {
                this.state.recoveryWorkflowCb.accept(TierPartitionState.RecoveryOperation.RECOMPUTE_MERGED_LOG_START_OFFSET);
            }
            oldState.setStatus(TierPartitionStatus.READ_ONLY);
            oldState.closeListeners(new TierPartitionStateClosedException("Old tier partition state for " + String.valueOf(this.topicIdPartition) + " has been closed due to force restore event."));
            this.scheduleDelayedClose(oldState, "fence restore event");
            this.state.maybeRemoveErrorFile();
            return TierPartitionState.RestoreResult.SUCCEEDED;
        }
        log.info("Ignoring state recovery {} at offset {} as last materialized offset is {} for {}", new Object[]{metadata, offsetAndEpoch, this.state.localMaterializedOffsetAndEpoch, this.topicIdPartition});
        return TierPartitionState.RestoreResult.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TierPartitionState.RestoreResult processSnapshotMaterializationEvent(TierMetadataSnapshotUploadComplete metadata, ByteBuffer targetState, OffsetAndEpoch offsetAndEpoch) {
        Object object = this.stateLock;
        synchronized (object) {
            try {
                Path destinationDownloadPath;
                if (!FileTierPartitionState.allowedSourceOffset(offsetAndEpoch, this.state.localMaterializedOffsetAndEpoch) || !FileTierPartitionState.allowedStateOffset(metadata.stateOffsetAndEpoch(), this.state.restoreOffsetAndEpoch)) {
                    log.info("Ignoring snapshot materialization {} at offset {} as last materialized offset is {} for {}", new Object[]{metadata, offsetAndEpoch, this.state.localMaterializedOffsetAndEpoch, this.topicIdPartition});
                    return TierPartitionState.RestoreResult.FAILED;
                }
                if (targetState == null) {
                    throw new TierMetadataFatalException("Found invalid snapshot during materialization, fencing the FTPS.");
                }
                Algorithm sourceChecksumAlgorithm = this.inferSnapshotChecksumAlgorithm(metadata, targetState);
                Path sourceDownloadPath = FileTierPartitionState.downloadPath(this.basePath, sourceChecksumAlgorithm);
                CheckedFileIO channel = this.openTargetChannelFromSerializedState(targetState, sourceDownloadPath, destinationDownloadPath = FileTierPartitionState.downloadPath(this.basePath, this.checksumAlgorithm), metadata);
                boolean isChecksumValid = channel.validate();
                if (!isChecksumValid) {
                    channel.close();
                    throw new TierSnapshotChecksumValidationFailedException("Checksum validation failed on newly downloaded FTPS file during snapshot materialization", null);
                }
                log.debug("Open downloaded FTPS snapshot by CheckedFileIO with size {}", (Object)channel.size());
                State newState = new State(this.topicPartition, this.basePath, this.version, channel, this.ioExceptionHandler, this.checksumAlgorithm, this.checksumSuperBlockLength, this.compactFeatureFlag, this.cleanupConfig.isEnabled(), -1L, this.time, this.tierPartitionStateSnapshotFeatureFlag, this.brokerId);
                if (newState.status != TierPartitionStatus.ONLINE) {
                    newState.close();
                    throw new IllegalStateException(String.format("Expect FTPS snapshot to have status ONLINE, but found %s", new Object[]{newState.status}));
                }
                newState.setStatus(TierPartitionStatus.CATCHUP);
                newState.dirty = true;
                State oldState = this.state;
                this.safeStateSwap(offsetAndEpoch, destinationDownloadPath, newState, false);
                oldState.setStatus(TierPartitionStatus.READ_ONLY);
                oldState.closeListeners(new TierPartitionStateClosedException("Old tier partition state for " + String.valueOf(this.topicIdPartition) + " has been closed due to snapshot materialization."));
                this.scheduleDelayedClose(oldState, "snapshot materialization event");
                return TierPartitionState.RestoreResult.SUCCEEDED;
            }
            catch (Exception e) {
                TierPartitionStatus previousStatus = this.state.status();
                boolean freezeMergedLogStartOffset = previousStatus == TierPartitionStatus.FROZEN_LOG_START_OFFSET;
                this.state.setErrorStatus(offsetAndEpoch, false, freezeMergedLogStartOffset);
                String logMsg = String.format("Failed to materialize state from snapshot %s, currentEpoch=%d, tierTopicPartitionOffsetAndEpoch=%s, previousTierPartitionStatus=%s, newTierPartitionStatus=%s.", new Object[]{metadata, this.state.currentEpoch, offsetAndEpoch, previousStatus, this.state.getStatus()});
                if (e instanceof NoSuchFileException || e instanceof FileNotFoundException) {
                    log.warn("{} This can be caused by partition deletion/reassignment during snapshot materialization.", (Object)logMsg, (Object)e);
                    return TierPartitionState.RestoreResult.FAILED;
                }
                if (e instanceof IOException) {
                    this.ioExceptionHandler.accept((IOException)e);
                    throw new KafkaStorageException(logMsg, (Throwable)e);
                }
                log.error(logMsg, (Throwable)e);
                return TierPartitionState.RestoreResult.FAILED;
            }
        }
    }

    @Override
    public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata event, Optional<ByteBuffer> targetStateOpt, TierPartitionStatus targetStatus, OffsetAndEpoch offsetAndEpoch) {
        TierPartitionState.RestoreResult result = TierPartitionState.RestoreResult.SUCCEEDED;
        if (event instanceof TierPartitionForceRestore) {
            result = this.forceRestoreState((TierPartitionForceRestore)event, targetStateOpt.get(), targetStatus, offsetAndEpoch);
        } else if (event instanceof TierPartitionUnfreezeLogStartOffset) {
            result = this.processUnfreezeLogStartOffset((TierPartitionUnfreezeLogStartOffset)event, targetStatus, offsetAndEpoch);
        } else if (event instanceof TierPartitionUnfence) {
            result = this.processUnfence((TierPartitionUnfence)event, targetStatus, offsetAndEpoch);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TierPartitionState.RestoreResult processUnfreezeLogStartOffset(TierPartitionUnfreezeLogStartOffset metadata, TierPartitionStatus restoreStatus, OffsetAndEpoch sourceOffsetAndEpoch) throws KafkaStorageException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state.status() != TierPartitionStatus.FROZEN_LOG_START_OFFSET) {
                log.warn(String.format("Cannot process metadata %s (at offsetEpoch %s). TierPartitionState was expected to be in FROZEN_LOG_START_OFFSET state to be able to process this event.", metadata, sourceOffsetAndEpoch));
                return TierPartitionState.RestoreResult.FAILED;
            }
            try {
                if (FileTierPartitionState.allowedSourceOffset(sourceOffsetAndEpoch, this.state.localMaterializedOffsetAndEpoch) && FileTierPartitionState.allowedStateOffset(metadata.stateOffsetAndEpoch(), this.state.restoreOffsetAndEpoch)) {
                    if (this.state.recoveryWorkflowCb == null) {
                        throw new IllegalStateException(String.format("Cannot process metadata %s at offsetEpoch %s%n. TierPartitionState needs a recovery workflow callback to process an unfreeze log start offset event.", metadata, sourceOffsetAndEpoch));
                    }
                } else {
                    log.warn(String.format("Cannot process recovery completion metadata event %s at offset %s. State materialized till %s. restoreOffsetAndEpoch %s", metadata, sourceOffsetAndEpoch, this.state.localMaterializedOffsetAndEpoch, this.state.restoreOffsetAndEpoch));
                    return TierPartitionState.RestoreResult.FAILED;
                }
                log.info("Marking end of data recovery by unfreezing log start offset for {} with materialization of event {} (at offsetEpoch {})", new Object[]{this.topicIdPartition, metadata, sourceOffsetAndEpoch});
                this.state.setStatus(restoreStatus);
                this.state.errorStatusReachedViaFenceEvent = false;
                this.state.localMaterializedOffsetAndEpoch = sourceOffsetAndEpoch;
                this.state.dirty = true;
                this.state.flush();
                this.state.recoveryWorkflowCb.accept(TierPartitionState.RecoveryOperation.UNFREEZE_MERGED_LOG_START_OFFSET);
            }
            catch (IOException ioe) {
                this.ioExceptionHandler.accept(ioe);
                throw new KafkaStorageException("Failed to apply " + String.valueOf(metadata) + " from tierTopicPartitionOffsetAndEpoch:" + String.valueOf(sourceOffsetAndEpoch) + " due to IO error. TierPartitionStatus=" + String.valueOf((Object)this.state.status), (Throwable)ioe);
            }
            catch (Exception e) {
                log.error(String.format("Cannot process metadata event %s at %s%n%s", metadata, sourceOffsetAndEpoch, e));
                return TierPartitionState.RestoreResult.FAILED;
            }
            return TierPartitionState.RestoreResult.SUCCEEDED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TierPartitionState.RestoreResult processUnfence(TierPartitionUnfence metadata, TierPartitionStatus restoreStatus, OffsetAndEpoch sourceOffsetAndEpoch) throws KafkaStorageException {
        Object object = this.stateLock;
        synchronized (object) {
            try {
                if (FileTierPartitionState.allowedSourceOffset(sourceOffsetAndEpoch, this.state.localMaterializedOffsetAndEpoch) && FileTierPartitionState.allowedStateOffset(metadata.stateOffsetAndEpoch(), this.state.restoreOffsetAndEpoch)) {
                    if (this.state.status() == restoreStatus) {
                        log.debug("Skipping processing for {} from offset {} as the current status is {}", new Object[]{metadata, sourceOffsetAndEpoch, restoreStatus});
                        return TierPartitionState.RestoreResult.SUCCEEDED;
                    }
                    if (this.state.status() != TierPartitionStatus.ERROR) {
                        log.warn("Cannot process metadata {} at offset {}. TierPartitionState was expected to be in ERROR state to be able to process this event, but found status {}.", new Object[]{metadata, sourceOffsetAndEpoch, this.state.status()});
                        return TierPartitionState.RestoreResult.FAILED;
                    }
                    this.state.errorOffsetAndEpoch = OffsetAndEpoch.EMPTY;
                    this.state.errorStatusReachedViaFenceEvent = false;
                    this.state.setStatus(restoreStatus);
                    this.state.localMaterializedOffsetAndEpoch = sourceOffsetAndEpoch;
                    this.state.dirty = true;
                    this.state.flush();
                    this.state.maybeRemoveErrorFile();
                    log.info("topicIdPartition={} unfenced by PartitionUnfence event={} at offset={}", new Object[]{this.topicIdPartition, metadata, sourceOffsetAndEpoch});
                    return TierPartitionState.RestoreResult.SUCCEEDED;
                }
                log.warn("Cannot process unfence metadata event {} at offset {}. State materialized till {}, restoreOffsetAndEpoch {}.", new Object[]{metadata, sourceOffsetAndEpoch, this.state.localMaterializedOffsetAndEpoch, this.state.restoreOffsetAndEpoch});
            }
            catch (Exception e) {
                boolean freezeMergedLogStartOffset = this.state.status() == TierPartitionStatus.FROZEN_LOG_START_OFFSET;
                this.state.setErrorStatus(sourceOffsetAndEpoch, false, freezeMergedLogStartOffset);
                String errorMsg = String.format("Failed to unfence via %s at offset %s, state materialized till %s, restoreOffsetAndEpoch=%s, tierPartitionStatus=%s", new Object[]{metadata, sourceOffsetAndEpoch, this.state.localMaterializedOffsetAndEpoch, this.state.restoreOffsetAndEpoch, this.state.getStatus()});
                if (e instanceof IOException) {
                    IOException ioe = (IOException)e;
                    this.ioExceptionHandler.accept(ioe);
                    throw new KafkaStorageException(errorMsg, (Throwable)ioe);
                }
                log.error(errorMsg, (Throwable)e);
            }
            return TierPartitionState.RestoreResult.FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeHandlers() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.closeHandlersImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ByteBuffer> getEncryptedDek(UUID objectId) {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.getEncryptedDek(objectId);
        }
    }

    @Override
    public TierPartitionStatus status() {
        return this.state.status();
    }

    @Override
    public long materializationLag() {
        MaterializationListener.ReplicationTargetObjectId targetObjectIdListener;
        MaterializationListener.ReplicationTargetOffset targetOffsetListener = (MaterializationListener.ReplicationTargetOffset)this.state.listeners.get(MaterializationListener.ReplicationTargetOffset.class);
        long targetOffsetProgress = 0L;
        long targetObjectIdProgress = 0L;
        if (targetOffsetListener != null) {
            targetOffsetProgress = targetOffsetListener.materializationProgress(Math.max(0L, this.state.endOffset));
        }
        if ((targetObjectIdListener = (MaterializationListener.ReplicationTargetObjectId)this.state.listeners.get(MaterializationListener.ReplicationTargetObjectId.class)) != null) {
            targetObjectIdProgress = targetObjectIdListener.materializationProgress(Math.max(0L, this.state.endOffset));
        }
        return Math.max(targetOffsetProgress, targetObjectIdProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginCatchup() {
        Object object = this.stateLock;
        synchronized (object) {
            this.state.beginCatchup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCatchUpComplete() {
        Object object = this.stateLock;
        synchronized (object) {
            this.state.onCatchUpComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginDiscover() {
        Object object = this.stateLock;
        synchronized (object) {
            this.state.beginDiscover();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDiscoverComplete() {
        Object object = this.stateLock;
        synchronized (object) {
            this.state.onDiscoverComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numSegments(long from, long to) {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.segmentOffsets(from, to).size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numSegments() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.segmentOffsets().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<TierLogSegment> materializeUptoOffset(long targetOffset) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.materializationListener(targetOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<TierLogSegment> materializeUptoObjectIdAndRestoreEpoch(long upperBoundEndOffset, UUID targetObjectId, int targetRestoreEpoch) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.materializationListener(upperBoundEndOffset, targetObjectId, targetRestoreEpoch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Optional<TierLogSegment>> materializeUptoLeaderEpoch(int targetEpoch) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.materializeUptoLeaderEpoch(targetEpoch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> trackMetadataInitialization(int targetLeaderEpoch) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.trackMetadataInitialization(targetLeaderEpoch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            try {
                this.state.flush();
            }
            finally {
                this.closeHandlersImpl();
                log.info("Tier partition state for {} closed.", (Object)this.topicIdPartition().map(TopicIdPartition::toString).orElse(this.topicPartition.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TierPartitionState.AppendResult append(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.appendMetadata(metadata, offsetAndEpoch);
        }
    }

    public void checkInvariants() {
        List objectIds = this.state.segments().stream().map(SegmentState::objectId).collect(Collectors.toList());
        HashSet uniqueIds = new HashSet(objectIds);
        if (objectIds.size() != uniqueIds.size()) {
            log.info("Duplicate segment found in log. Log segments: " + String.valueOf(this.state.logSegments));
            throw new IllegalStateException("Topic contains non unique segment when iterating");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TierPartitionState.AppendResult appendUnhandled(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.appendMetadataUnhandled(metadata, offsetAndEpoch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<TierLogSegment> segments() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.segments().stream().map(segment -> new TierLogSegment(this.topicIdPartition, (SegmentState)segment)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<TierLogSegment> segments(long from, long to) {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.segments(from, to).stream().map(segment -> new TierLogSegment(this.topicIdPartition, (SegmentState)segment)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SegmentState> segmentInMemoryMetadataRange(long from, long to) {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.fetchInMemoryMetadataRange(from, to);
        }
    }

    public CheckedFileIO checkedFileIO() {
        return this.state.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<SegmentState> previousMetadataBeforeOffset(long targetStartOffset) {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.previousMetadataBeforeOffset(targetStartOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FollowerRestorePoint followerRestorePoint(long localLogStartOffset) {
        int restoreEpoch;
        Optional<Supplier> optIter;
        Object object = this.stateLock;
        synchronized (object) {
            optIter = this.state.previousMetadataForFollowerRestorePoint(localLogStartOffset).map(this.state::metadataForInMemorySegmentMetadata);
            restoreEpoch = this.state.restoreOffsetAndEpoch.epoch().orElse(-1);
        }
        return new FollowerRestorePoint(localLogStartOffset, optIter.flatMap(Supplier::get).map(TierObjectMetadata::objectId), restoreEpoch);
    }

    @Override
    public Optional<TierLogSegment> metadata(long targetOffset) throws IOException {
        return this.state.metadata(targetOffset).map(state -> new TierLogSegment(this.topicIdPartition, (SegmentState)state));
    }

    @Override
    public OffsetAndEpoch lastLocalMaterializedSrcOffsetAndEpoch() {
        return this.state.localMaterializedOffsetAndEpoch;
    }

    @Override
    public long lastSnapshotTimestampMs() {
        return this.state.lastSnapshotTimestampMs;
    }

    @Override
    public UUID lastSnapshotId() {
        return this.state.lastSnapshotId;
    }

    @Override
    public UUID lastCommittedSnapshotId() {
        return this.state.lastCommittedSnapshotId;
    }

    OffsetAndEpoch lastFlushedSrcOffsetAndEpoch() {
        return this.state.globalMaterializedOffsetAndEpoch;
    }

    OffsetAndEpoch restoreOffsetAndEpoch() {
        return this.state.restoreOffsetAndEpoch;
    }

    OffsetAndEpoch lastFlushedErrorOffsetAndEpoch() {
        return this.state.errorOffsetAndEpoch;
    }

    public String flushedPath() {
        return FileTierPartitionState.flushedFilePath(this.basePath, this.checksumAlgorithm).toFile().getAbsolutePath();
    }

    @Override
    public Collection<TierLogSegment> fencedSegments() {
        return this.state.segmentsWithStatesEqualTo(FENCED_STATES).stream().map(seg -> new TierLogSegment(this.topicIdPartition, (SegmentState)seg)).collect(Collectors.toList());
    }

    @Override
    public Collection<TierLogSegment> compactedSegments() {
        return this.state.segmentsWithStatesEqualTo(COMPACTED_STATES).stream().map(seg -> new TierLogSegment(this.topicIdPartition, (SegmentState)seg)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.tieringEnabled) {
                return "FileTierPartitionState(topicIdPartition=" + String.valueOf(this.topicIdPartition) + ", state=" + String.valueOf(this.state) + ", checksumAlgorithm=" + String.valueOf((Object)this.checksumAlgorithm) + ")";
            }
            return "FileTierPartitionState(topicIdPartition=" + String.valueOf(this.topicIdPartition) + ", tieringEnabled=" + this.tieringEnabled + ")";
        }
    }

    public static Optional<Header> readHeader(CheckedFileIO channel) throws IOException {
        Optional<Short> headerSizeOpt = FileTierPartitionState.readHeaderSize(channel);
        if (!headerSizeOpt.isPresent()) {
            return Optional.empty();
        }
        short headerSize = headerSizeOpt.get();
        ByteBuffer headerBuf = ByteBuffer.allocate(headerSize);
        channel.read(headerBuf, 2L);
        headerBuf.flip();
        if (headerBuf.limit() != headerSize) {
            return Optional.empty();
        }
        return Optional.of(new Header(TierPartitionStateHeader.getRootAsTierPartitionStateHeader(headerBuf)));
    }

    public static Optional<FileTierPartitionIterator> iterator(TopicPartition topicPartition, CheckedFileIO channel) throws IOException {
        Optional<Header> headerOpt = FileTierPartitionState.readHeader(channel);
        if (!headerOpt.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(FileTierPartitionState.iterator(new TopicIdPartition(topicPartition.topic(), headerOpt.get().topicId(), topicPartition.partition()), channel, headerOpt.get().size()));
    }

    byte version() {
        return this.version;
    }

    String basePath() {
        return this.basePath;
    }

    public static FileTierPartitionIterator iterator(TopicIdPartition topicIdPartition, CheckedFileIO channel, long position) throws IOException {
        return new FileTierPartitionIterator(topicIdPartition, channel, position);
    }

    private void scheduleDelayedClose(State state, String reason) {
        this.scheduler.scheduleOnce("FileTierPartitionState_oldState_close", () -> {
            log.info("Closing an earlier tier partition state that was already replaced due to " + reason + " for partition: " + String.valueOf(this.topicIdPartition));
            try {
                state.close();
            }
            catch (IOException ioe) {
                this.ioExceptionHandler.accept(ioe);
            }
        }, 3600000L);
    }

    private void safeStateSwap(OffsetAndEpoch offsetAndEpoch, Path newStatePath, State newState, boolean keepDiscardedFile) throws IOException {
        boolean movedMutableFile = false;
        boolean movedNewStateFile = false;
        Path discardedFilePath = keepDiscardedFile ? FileTierPartitionState.discardedFilePathWithEpochAndOffset(this.basePath, offsetAndEpoch, this.checksumAlgorithm) : FileTierPartitionState.discardedFilePath(this.basePath, this.checksumAlgorithm);
        try {
            Utils.atomicMoveWithFallback((Path)FileTierPartitionState.mutableFilePath(this.basePath, this.checksumAlgorithm), (Path)discardedFilePath, (boolean)false);
            movedMutableFile = true;
            Utils.atomicMoveWithFallback((Path)newStatePath, (Path)FileTierPartitionState.mutableFilePath(this.basePath, this.checksumAlgorithm), (boolean)false);
            movedNewStateFile = true;
            newState.flush();
        }
        catch (Exception e) {
            if (movedNewStateFile) {
                Utils.atomicMoveWithFallback((Path)FileTierPartitionState.mutableFilePath(this.basePath, this.checksumAlgorithm), (Path)newStatePath, (boolean)false);
            }
            if (movedMutableFile) {
                Utils.atomicMoveWithFallback((Path)discardedFilePath, (Path)FileTierPartitionState.mutableFilePath(this.basePath, this.checksumAlgorithm), (boolean)false);
            }
            newState.close();
            throw e;
        }
        finally {
            Utils.flushDir((Path)FileTierPartitionState.mutableFilePath(this.basePath, this.checksumAlgorithm).toAbsolutePath().normalize().getParent());
            if (!keepDiscardedFile) {
                FilesWrapper.deleteIfExists((Path)discardedFilePath);
            }
        }
        this.state = newState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mayContainTieredData() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.topicIdPartition != null && this.state.status.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean maybeOpenChannelOnOffsetTieredException() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.state.status.isOpen()) {
                this.maybeOpenChannel(true);
                if (!this.state.status.isOpen()) {
                    throw new IllegalStateException("Could not open TierPartitionState channel. Current state is " + String.valueOf((Object)this.status()));
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeOpenChannel(boolean onOffsetTiered) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            Path flushedFilePath = FileTierPartitionState.flushedFilePath(this.basePath, this.checksumAlgorithm);
            ChecksumUtils.maybeMigrateChecksumFormat(this.checksumAlgorithm, this.checksumSuperBlockLength, flushedFilePath);
            if (this.tierPartitionStateSnapshotFeatureFlag) {
                FileTierPartitionStateSnapshotObject.maybeCreateAndCleanupSnapshotsDir(this.basePath);
            }
            if ((this.tieringEnabled || FilesWrapper.exists((Path)flushedFilePath, (LinkOption[])new LinkOption[0]) || onOffsetTiered) && !this.state.status.isOpen()) {
                CheckedFileIO channel;
                if (!FilesWrapper.exists((Path)flushedFilePath, (LinkOption[])new LinkOption[0])) {
                    CheckedFileIO.create(flushedFilePath, this.checksumAlgorithm, this.checksumSuperBlockLength);
                }
                Path mutableFilePath = FileTierPartitionState.mutableFilePath(this.basePath, this.checksumAlgorithm);
                ChecksumUtils.maybeRemovePreviousFormatPath(mutableFilePath);
                FilesWrapper.copy((Path)flushedFilePath, (Path)mutableFilePath, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                try {
                    channel = CheckedFileIO.openOrCreate(mutableFilePath, this.checksumAlgorithm, this.checksumSuperBlockLength, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
                    this.validateFTPSFileChecksum(channel);
                }
                catch (Exception e) {
                    IOException ioexp = new IOException("Exception in initializing TierMetadataState due to checksum failure for " + String.valueOf(this.topicPartition), e);
                    this.ioExceptionHandler.accept(ioexp);
                    throw new KafkaStorageMetadataCorruptionException((Throwable)ioexp);
                }
                try {
                    channel = this.getChannelMaybeReinitialize(channel, this.topicPartition, this.topicIdPartition, this.basePath, this.version, this.checksumAlgorithm, this.checksumSuperBlockLength, this.compactFeatureFlag, this.cleanupConfig.isEnabled(), this.tierPartitionStateSnapshotFeatureFlag);
                    if (channel == null) {
                        this.state = State.EMPTY;
                        return;
                    }
                    this.state = new State(this.topicPartition, this.basePath, this.version, channel, this.ioExceptionHandler, this.checksumAlgorithm, this.checksumSuperBlockLength, this.compactFeatureFlag, this.cleanupConfig.isEnabled(), -1L, this.time, this.tierPartitionStateSnapshotFeatureFlag, this.brokerId);
                    this.topicIdPartition = this.state.topicIdPartition;
                }
                catch (Exception e) {
                    try {
                        FileTierPartitionState.backupMutableFileForDebugging(this.topicIdPartition, this.basePath, FileTierPartitionState.errorFilePath(this.basePath, this.checksumAlgorithm), this.checksumAlgorithm);
                        this.closeHandlersImpl();
                    }
                    catch (Exception exceptionToIgnore) {
                        log.warn("Failed to backup / close tier partition state for {}", (Object)this.topicIdPartition, (Object)exceptionToIgnore);
                    }
                    IOException ioexp = new IOException("Exception in initializing TierMetadataState for " + String.valueOf(this.topicPartition), e);
                    this.ioExceptionHandler.accept(ioexp);
                    throw new KafkaStorageException((Throwable)ioexp);
                }
            }
        }
    }

    private void validateFTPSFileChecksum(CheckedFileIO channel) throws IOException {
        boolean isCurrentFtpsChecksumValid;
        try {
            isCurrentFtpsChecksumValid = channel.validate();
        }
        catch (Exception e) {
            log.error("Exception occured while validating checksum of local FTPS file upon broker restart for {}", (Object)this.topicPartition);
            throw new IOException("Exception occured while validating checksum of local FTPS file upon broker restart for " + String.valueOf(this.topicPartition), e);
        }
        if (!isCurrentFtpsChecksumValid) {
            log.error("Validating checksum of local FTPS file upon broker restart yields false for {}", (Object)this.topicPartition);
            throw new IOException("Validating checksum of local FTPS file upon broker restart yields false for " + String.valueOf(this.topicPartition));
        }
    }

    private void closeHandlersImpl() throws IOException {
        if (this.state.status != TierPartitionStatus.UNINITIALIZED) {
            try {
                this.state.close();
            }
            finally {
                this.state = State.EMPTY;
            }
        }
    }

    public static void writeHeader(CheckedFileIO channel, Header header) throws IOException {
        int remaining = header.payloadBuffer().remaining();
        short sizePrefix = (short)remaining;
        if (sizePrefix != remaining) {
            throw new IllegalStateException(String.format("Unexpected header size: %d", remaining));
        }
        ByteBuffer sizeBuf = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        sizeBuf.putShort(sizePrefix);
        sizeBuf.flip();
        channel.write(sizeBuf, 0L);
        channel.write(header.payloadBuffer(), 2L);
    }

    private static Optional<Short> readHeaderSize(CheckedFileIO channel) throws IOException {
        ByteBuffer headerPrefixBuf = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(headerPrefixBuf, 0L);
        headerPrefixBuf.flip();
        if (headerPrefixBuf.limit() == 2) {
            return Optional.of(headerPrefixBuf.getShort());
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CheckedFileIO getChannelMaybeReinitialize(CheckedFileIO channel, TopicPartition topicPartition, TopicIdPartition topicIdPartition, String basePath, byte version, Algorithm checksumAlgorithm, short checksumSuperBlockLength, boolean compactFeatureFlag, boolean cleanupFeatureFlag, boolean tierPartitionStateSnapshotFeatureFlag) throws IOException {
        Path mutableFilePath = FileTierPartitionState.mutableFilePath(basePath, checksumAlgorithm);
        try {
            Optional<Header> initialHeaderOpt = FileTierPartitionState.readHeader(channel);
            if (initialHeaderOpt.isPresent()) return FileTierPartitionState.maybeMigrateStateFileFormat(topicPartition, basePath, version, mutableFilePath, channel, initialHeaderOpt.get(), checksumAlgorithm, checksumSuperBlockLength, compactFeatureFlag, cleanupFeatureFlag, tierPartitionStateSnapshotFeatureFlag, this.time);
            if (topicIdPartition != null) {
                log.info("Writing new header to tier partition state for {}", (Object)topicIdPartition);
                channel.truncate(0L);
                FileTierPartitionState.writeHeader(channel, new Header(topicIdPartition.topicId(), version, -1, TierPartitionStatus.INIT, -1L, -1L, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, compactFeatureFlag, -1L, CompactStats.EMPTY, CompactStats.EMPTY, cleanupFeatureFlag, tierPartitionStateSnapshotFeatureFlag, -1L, Header.SNAPSHOT_ID_EMPTY));
                return channel;
            }
            channel.close();
            return null;
        }
        catch (IOException e) {
            channel.close();
            throw e;
        }
    }

    private static CheckedFileIO maybeMigrateStateFileFormat(TopicPartition topicPartition, String basePath, byte requiredVersion, Path destination, CheckedFileIO channel, Header existingHeader, Algorithm checksumAlgorithm, short checksumSuperBlockLength, boolean compactFeatureFlag, boolean cleanupFeatureFlag, boolean tierPartitionStateSnapshotFeatureFlag, Time time) throws IOException {
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), existingHeader.topicId(), topicPartition.partition());
        Header newHeader = new Header(topicIdPartition.topicId(), requiredVersion, existingHeader.tierEpoch(), existingHeader.status(), existingHeader.startOffset(), existingHeader.endOffset(), existingHeader.globalMaterializedOffsetAndEpoch(), existingHeader.localMaterializedOffsetAndEpoch(), existingHeader.errorOffsetAndEpoch(), existingHeader.restoreOffsetAndEpoch(), compactFeatureFlag, existingHeader.compactDirtyStartOffset(), existingHeader.lastCompactStats(), existingHeader.accumulatedCompactStats(), cleanupFeatureFlag || existingHeader.hasStateChangeTimestamp(), tierPartitionStateSnapshotFeatureFlag, existingHeader.lastSnapshotTimestampMs(), existingHeader.lastSnapshotId());
        boolean shouldMigrateHeader = existingHeader.version() != requiredVersion || newHeader.size() != existingHeader.size();
        boolean shouldMigrateEntries = FileTierPartitionState.shouldMigrateEntries(topicIdPartition, channel, existingHeader, compactFeatureFlag, cleanupFeatureFlag);
        if (shouldMigrateHeader || shouldMigrateEntries) {
            return FileTierPartitionState.migrateStateFileFormat(topicIdPartition, basePath, channel, checksumAlgorithm, checksumSuperBlockLength, newHeader, existingHeader.size(), destination, compactFeatureFlag, cleanupFeatureFlag, time);
        }
        return channel;
    }

    private static boolean shouldMigrateEntries(TopicIdPartition topicIdPartition, CheckedFileIO channel, Header existingHeader, boolean compactFeatureFlag, boolean cleanupFeatureFlag) throws IOException {
        boolean compactMigration;
        boolean cleanupMigration = cleanupFeatureFlag && !existingHeader.hasStateChangeTimestamp();
        boolean bl = compactMigration = compactFeatureFlag && !FileTierPartitionState.hasCompactFields(topicIdPartition, channel, existingHeader);
        if (cleanupMigration || compactMigration) {
            log.info("FTPS entries need to be migrated for {} because cleanupMigration={}, compactMigration={}", new Object[]{topicIdPartition.topicPartition(), cleanupMigration, compactMigration});
            return true;
        }
        return false;
    }

    private static boolean hasCompactFields(TopicIdPartition topicIdPartition, CheckedFileIO channel, Header header) throws IOException {
        FileTierPartitionIterator iter = FileTierPartitionState.iterator(topicIdPartition, channel, header.size());
        if (iter.hasNext()) {
            TierObjectMetadata firstEntry = (TierObjectMetadata)iter.next();
            return firstEntry.hasVirtualOffset() && firstEntry.hasStateBeforeDeletion();
        }
        return true;
    }

    private static CheckedFileIO migrateStateFileFormat(TopicIdPartition topicIdPartition, String basePath, CheckedFileIO channel, Algorithm checksumAlgorithm, short checksumSuperBlockLength, Header headerToWrite, long startPosition, Path destination, boolean compactFeatureFlag, boolean cleanupFeatureFlag, Time time) throws IOException {
        Path migrateFilePath = FileTierPartitionState.migrateFilePath(basePath, checksumAlgorithm);
        ChecksumUtils.maybeRemovePreviousFormatPath(migrateFilePath);
        try (CheckedFileIO migrateChannel = CheckedFileIO.openOrCreate(migrateFilePath, checksumAlgorithm, checksumSuperBlockLength, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            log.info("Migrating tier partition state file format for {}", (Object)topicIdPartition);
            FileTierPartitionState.writeHeader(migrateChannel, headerToWrite);
            migrateChannel.position(headerToWrite.size());
            FileTierPartitionState.rewriteEntries(channel, migrateChannel, topicIdPartition, startPosition, compactFeatureFlag, cleanupFeatureFlag, time);
        }
        Utils.atomicMoveWithFallback((Path)migrateFilePath, (Path)destination);
        channel.close();
        return CheckedFileIO.openOrCreate(destination, checksumAlgorithm, checksumSuperBlockLength, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    private void rewriteEntriesAndCleanup(CheckedFileIO channel, CheckedFileIO tmpChannel, TopicIdPartition topicIdPartition, long startPosition, boolean compactFeatureFlag, boolean cleanupFeatureFlag) throws IOException {
        long currentTimeMs = this.time.milliseconds();
        long maxDeleteTimestampForCleanup = currentTimeMs - this.cleanupConfig.entryRemovalDelay();
        long numSegmentsCleanedUp = 0L;
        try {
            FileTierPartitionIterator iterator = FileTierPartitionState.iterator(topicIdPartition, channel, startPosition);
            while (iterator.hasNext()) {
                TierObjectMetadata metadata = FileTierPartitionState.maybeMigrateFormat((TierObjectMetadata)iterator.next(), currentTimeMs, compactFeatureFlag, cleanupFeatureFlag);
                if (!metadata.isEligibleForCleanup(maxDeleteTimestampForCleanup, cleanupFeatureFlag)) {
                    State.appendWithSizePrefixStatic(metadata.payloadBuffer(), tmpChannel);
                    continue;
                }
                ++numSegmentsCleanedUp;
            }
            if (iterator.position() < channel.size()) {
                throw new TierPartitionStateCorruptedException("Could not read all bytes in file. position: " + iterator.position() + " size: " + channel.size() + " for partition " + String.valueOf(topicIdPartition));
            }
            log.info("{} segments removed by cleanup from tier partition state file for topicIdPartition {}, state file size changed from {} to {}", new Object[]{numSegmentsCleanedUp, topicIdPartition, channel.size(), tmpChannel.size()});
        }
        catch (Exception e) {
            throw new IOException(String.format("Exception in rewriting tier metadata entries for %s", topicIdPartition), e);
        }
    }

    private static void rewriteEntries(CheckedFileIO channel, CheckedFileIO tmpChannel, TopicIdPartition topicIdPartition, long startPosition, boolean compactFeatureFlag, boolean cleanupFeatureFlag, Time time) throws IOException {
        long currentTimeMs = time.milliseconds();
        try {
            FileTierPartitionIterator iterator = FileTierPartitionState.iterator(topicIdPartition, channel, startPosition);
            while (iterator.hasNext()) {
                TierObjectMetadata metadata = FileTierPartitionState.maybeMigrateFormat((TierObjectMetadata)iterator.next(), currentTimeMs, compactFeatureFlag, cleanupFeatureFlag);
                State.appendWithSizePrefixStatic(metadata.payloadBuffer(), tmpChannel);
            }
            if (iterator.position() < channel.size()) {
                throw new TierPartitionStateCorruptedException("Could not read all bytes in file. position: " + iterator.position() + " size: " + channel.size() + " for partition " + String.valueOf(topicIdPartition));
            }
            log.info("tier partition state file format migration complete for topicIdPartition {}, state file size changed from {} to {}", new Object[]{topicIdPartition, channel.size(), tmpChannel.size()});
        }
        catch (Exception e) {
            throw new IOException(String.format("Exception in rewriting tier metadata entries for %s", topicIdPartition), e);
        }
    }

    private static TierObjectMetadata maybeMigrateFormat(TierObjectMetadata metadata, long currentTimeMs, boolean compactFeatureFlag, boolean cleanupFeatureFlag) {
        boolean needBackfillCompactionFields;
        boolean needBackfillStateChangeTimestamp = cleanupFeatureFlag && metadata.stateChangeTimestamp() < 0L;
        boolean bl = needBackfillCompactionFields = compactFeatureFlag && (!metadata.hasVirtualOffset() || !metadata.hasStateBeforeDeletion());
        if (needBackfillStateChangeTimestamp || needBackfillCompactionFields) {
            return metadata.migrateFormat(currentTimeMs, compactFeatureFlag, cleanupFeatureFlag);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dirty() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.dirty;
        }
    }

    private static void validateEpoch(Optional<Integer> current, Optional<Integer> checked) {
        if (current.isPresent() && checked.isPresent() && checked.get() < current.get()) {
            throw new IllegalStateException("New epoch " + String.valueOf(checked) + " must dominate old epoch " + String.valueOf(current));
        }
    }

    private static boolean allowedStateOffset(OffsetAndEpoch stateOffsetAndEpoch, OffsetAndEpoch current) {
        if (stateOffsetAndEpoch.equals(OffsetAndEpoch.EMPTY)) {
            return true;
        }
        if (stateOffsetAndEpoch.offset() >= current.offset()) {
            FileTierPartitionState.validateEpoch(current.epoch(), stateOffsetAndEpoch.epoch());
            return true;
        }
        return false;
    }

    private static boolean allowedSourceOffset(OffsetAndEpoch toProcess, OffsetAndEpoch current) {
        if (toProcess.offset() > current.offset()) {
            FileTierPartitionState.validateEpoch(current.epoch(), toProcess.epoch());
            return true;
        }
        if (toProcess.epoch().isPresent() && current.epoch().isPresent() && toProcess.epoch().get() > current.epoch().get()) {
            throw new IllegalStateException("Incorrect epoch in " + String.valueOf(toProcess) + " with current epoch " + String.valueOf(current));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTieredPartitionRecoveryWorkflowCb(Consumer<TierPartitionState.RecoveryOperation> cb) {
        Object object = this.stateLock;
        synchronized (object) {
            this.state.recoveryWorkflowCb = cb;
            if (this.state.status() == TierPartitionStatus.FROZEN_LOG_START_OFFSET) {
                this.state.errorStatusReachedViaFenceEvent = true;
                this.state.recoveryWorkflowCb.accept(TierPartitionState.RecoveryOperation.FREEZE_MERGED_LOG_START_OFFSET);
            }
        }
    }

    public static Path flushedFilePath(String basePath, Algorithm checksumAlgorithm) {
        return StateFileType.FLUSHED.filePath(basePath, checksumAlgorithm);
    }

    public static Path mutableFilePath(String basePath, Algorithm checksumAlgorithm) {
        return StateFileType.MUTABLE.filePath(basePath, checksumAlgorithm);
    }

    public static Path recoverPath(String basePath, Algorithm checksumAlgorithm) {
        return StateFileType.RECOVER.filePath(basePath, checksumAlgorithm);
    }

    static Path discardedFilePath(String basePath, Algorithm checksumAlgorithm) {
        return StateFileType.DISCARDED.filePath(basePath, checksumAlgorithm);
    }

    static Path discardedFilePathWithEpochAndOffset(String basePath, OffsetAndEpoch restoreAt, Algorithm checksumAlgorithm) {
        return Paths.get(String.format("%s%s%s_epoch_%s_offset_%s", basePath, StateFileType.DISCARDED.suffix, checksumAlgorithm.suffix, restoreAt.epoch().orElse(-1), restoreAt.offset()), new String[0]);
    }

    static Path tmpFilePath(String basePath, Algorithm checksumAlgorithm) {
        return StateFileType.TEMPORARY.filePath(basePath, checksumAlgorithm);
    }

    static Path errorFilePath(String basePath, Algorithm checksumAlgorithm) {
        return StateFileType.ERROR.filePath(basePath, checksumAlgorithm);
    }

    private static Path cleanupPath(String basePath, Algorithm checksumAlgorithm) {
        return StateFileType.CLEANUP.filePath(basePath, checksumAlgorithm);
    }

    private static Path migrateFilePath(String basePath, Algorithm checksumAlgorithm) {
        return StateFileType.MIGRATE.filePath(basePath, checksumAlgorithm);
    }

    static Path snapshotFileName(String basePath, Algorithm checksumAlgorithm) {
        return StateFileType.SNAPSHOT.filePath(basePath, checksumAlgorithm);
    }

    static Path downloadPath(String basePath, Algorithm checksumAlgorithm) {
        return StateFileType.DOWNLOAD.filePath(basePath, checksumAlgorithm);
    }

    static Path recoveryUploadFilePath(String basePath, Algorithm checksumAlgorithm) {
        return StateFileType.RECOVERY_UPLOAD.filePath(basePath, checksumAlgorithm);
    }

    public boolean isErrorStatusReachedViaFenceEvent() {
        return this.state.errorStatusReachedViaFenceEvent;
    }

    public static class State {
        private static final State EMPTY = new State();
        private final boolean compactFeatureFlag;
        private final boolean cleanupFeatureFlag;
        private boolean includeStateChangeTimestamp;
        private final CheckedFileIO channel;
        private final ConcurrentNavigableMap<Long, SegmentState> logSegments = new ConcurrentSkipListMap<Long, SegmentState>();
        private final ConcurrentNavigableMap<UUID, SegmentState> allSegmentStates = new ConcurrentSkipListMap<UUID, SegmentState>();
        private final byte version;
        private final Consumer<IOException> ioExceptionHandler;
        private final Time time;
        private final ConcurrentHashMap<Class<? extends MaterializationListener>, MaterializationListener> listeners = new ConcurrentHashMap();
        private String basePath;
        private TopicIdPartition topicIdPartition = null;
        private volatile boolean dirty = false;
        private volatile SegmentState compactionUploadInProgress;
        private volatile SegmentState archiveUploadInProgress;
        private volatile SegmentState immediatelyPrecedingDeletedSegment;
        private volatile boolean hasDeletedSegmentAfterPreviousCleanup = false;
        private volatile long endOffset;
        private volatile long committedEndOffset = -1L;
        private volatile int currentEpoch = -1;
        private volatile long validSegmentsSize = 0L;
        private volatile TierPartitionStatus status = TierPartitionStatus.UNINITIALIZED;
        private volatile OffsetAndEpoch globalMaterializedOffsetAndEpoch = OffsetAndEpoch.EMPTY;
        private volatile OffsetAndEpoch localMaterializedOffsetAndEpoch = OffsetAndEpoch.EMPTY;
        private volatile OffsetAndEpoch errorOffsetAndEpoch = OffsetAndEpoch.EMPTY;
        private volatile OffsetAndEpoch restoreOffsetAndEpoch = OffsetAndEpoch.EMPTY;
        private volatile boolean errorStatusReachedViaFenceEvent = false;
        public Consumer<TierPartitionState.RecoveryOperation> recoveryWorkflowCb;
        private final Algorithm checksumAlgorithm;
        private final short checksumSuperBlockLength;
        private volatile long compactDirtyStartOffset = -1L;
        private volatile CompactStats lastCompactStats = CompactStats.EMPTY;
        private volatile CompactStats accumulatedCompactStats = CompactStats.EMPTY;
        private volatile long tierPartitionStateFileSize = 0L;
        private final boolean tierPartitionStateSnapshotFeatureFlag;
        private volatile long lastSnapshotTimestampMs = -1L;
        private volatile UUID lastSnapshotId = null;
        private volatile UUID lastCommittedSnapshotId = null;
        private final int brokerId;

        private State() {
            this.compactFeatureFlag = false;
            this.cleanupFeatureFlag = false;
            this.includeStateChangeTimestamp = false;
            this.channel = null;
            this.version = (byte)-1;
            this.basePath = null;
            this.ioExceptionHandler = e -> {
                throw new IllegalStateException("Illegal use of setLogDirOffline");
            };
            this.time = null;
            this.recoveryWorkflowCb = null;
            this.checksumAlgorithm = null;
            this.checksumSuperBlockLength = (short)-1;
            this.endOffset = -1L;
            this.tierPartitionStateSnapshotFeatureFlag = false;
            this.brokerId = -1;
        }

        State(TopicPartition topicPartition, String basePath, byte version, CheckedFileIO channel, Consumer<IOException> ioExceptionHandler, Algorithm checksumAlgorithm, short checksumSuperBlockLength, boolean compactFeatureFlag, boolean cleanupFeatureFlag, long initialEndOffset, Time time, boolean tierPartitionStateSnapshotFeatureFlag, int brokerId) throws IOException, TierPartitionStateCorruptedException {
            this.basePath = basePath;
            this.version = version;
            this.channel = channel;
            this.ioExceptionHandler = ioExceptionHandler;
            this.recoveryWorkflowCb = null;
            this.checksumAlgorithm = checksumAlgorithm;
            this.checksumSuperBlockLength = checksumSuperBlockLength;
            this.cleanupFeatureFlag = cleanupFeatureFlag;
            this.compactFeatureFlag = compactFeatureFlag;
            this.endOffset = initialEndOffset;
            this.time = time;
            this.tierPartitionStateSnapshotFeatureFlag = tierPartitionStateSnapshotFeatureFlag;
            this.brokerId = brokerId;
            this.scanAndInitialize(topicPartition, cleanupFeatureFlag);
            if (this.status == TierPartitionStatus.UNINITIALIZED) {
                throw new IllegalStateException("Illegal TierPartitionStatus: " + String.valueOf((Object)this.status));
            }
            this.maybeRemoveErrorFile();
            this.maybeRemoveStaleRecoveryUploadFile();
        }

        State(TopicPartition topicPartition, String basePath, byte version, CheckedFileIO channel, Consumer<IOException> ioExceptionHandler, Algorithm checksumAlgorithm, short checksumSuperBlockLength, boolean compactFeatureFlag, boolean cleanupFeatureFlag, long initialEndOffset, Time time, OffsetAndEpoch restoreOffsetAndEpoch, Consumer<TierPartitionState.RecoveryOperation> recoveryWorkflowCb, ConcurrentHashMap<Class<? extends MaterializationListener>, MaterializationListener> listeners, boolean tierPartitionStateSnapshotFeatureFlag, int brokerId) throws IOException, TierPartitionStateCorruptedException {
            this(topicPartition, basePath, version, channel, ioExceptionHandler, checksumAlgorithm, checksumSuperBlockLength, compactFeatureFlag, cleanupFeatureFlag, initialEndOffset, time, tierPartitionStateSnapshotFeatureFlag, brokerId);
            this.recoveryWorkflowCb = recoveryWorkflowCb;
            this.listeners.putAll(listeners);
            this.dirty = true;
        }

        private static State createRestoredState(TopicPartition topicPartition, String basePath, byte version, CheckedFileIO channel, Consumer<IOException> ioExceptionHandler, OffsetAndEpoch localMaterializedOffsetAndEpoch, TierPartitionStatus status, Consumer<TierPartitionState.RecoveryOperation> recoveryWorkflowCb, Algorithm checksumAlgorithm, short checksumSuperBlockLength, boolean compactFeatureFlag, boolean cleanupFeatureFlag, Time time, boolean tierPartitionStateSnapshotFeatureFlag, int brokerId) throws IOException {
            State imported = new State(topicPartition, basePath, version, channel, ioExceptionHandler, checksumAlgorithm, checksumSuperBlockLength, compactFeatureFlag, cleanupFeatureFlag, -1L, time, tierPartitionStateSnapshotFeatureFlag, brokerId);
            imported.localMaterializedOffsetAndEpoch = localMaterializedOffsetAndEpoch;
            imported.globalMaterializedOffsetAndEpoch = OffsetAndEpoch.EMPTY;
            imported.restoreOffsetAndEpoch = localMaterializedOffsetAndEpoch;
            imported.setStatus(status);
            imported.recoveryWorkflowCb = recoveryWorkflowCb;
            imported.dirty = true;
            return imported;
        }

        private void scanAndInitialize(TopicPartition topicPartition, boolean cleanupFeatureFlag) throws IOException, TierPartitionStateCorruptedException {
            log.debug("scan and truncate TierPartitionState {}", (Object)topicPartition);
            Header header = FileTierPartitionState.readHeader(this.channel).get();
            this.topicIdPartition = new TopicIdPartition(topicPartition.topic(), header.topicId(), topicPartition.partition());
            this.loadSegmentStates(topicPartition, header.startOffset(), header.size());
            if (header.endOffset() != -1L && this.endOffset != header.endOffset()) {
                if (this.numSegments() > 0) {
                    log.info("File header endOffset does not match the materialized endOffset. Setting state endOffset to be equal to header endOffset. Header endOffset: " + header.endOffset() + " materialized state endOffset: " + this.endOffset + " for partition " + String.valueOf(this.topicIdPartition));
                }
                this.endOffset = header.endOffset();
            }
            long channelSize = this.channel.size();
            this.channel.position(channelSize);
            this.tierPartitionStateFileSize = channelSize;
            this.committedEndOffset = this.endOffset;
            this.currentEpoch = header.tierEpoch();
            this.globalMaterializedOffsetAndEpoch = header.globalMaterializedOffsetAndEpoch();
            this.localMaterializedOffsetAndEpoch = header.localMaterializedOffsetAndEpoch();
            this.errorOffsetAndEpoch = header.errorOffsetAndEpoch();
            this.restoreOffsetAndEpoch = header.restoreOffsetAndEpoch();
            this.status = header.status();
            this.compactDirtyStartOffset = header.compactDirtyStartOffset();
            this.lastCompactStats = header.lastCompactStats();
            this.accumulatedCompactStats = header.accumulatedCompactStats();
            this.includeStateChangeTimestamp = cleanupFeatureFlag || header.hasStateChangeTimestamp();
            this.lastSnapshotTimestampMs = header.lastSnapshotTimestampMs();
            this.lastSnapshotId = header.lastSnapshotId();
            this.lastCommittedSnapshotId = header.lastSnapshotId();
            if (this.status() == TierPartitionStatus.FROZEN_LOG_START_OFFSET) {
                this.errorStatusReachedViaFenceEvent = true;
                if (this.recoveryWorkflowCb != null) {
                    this.recoveryWorkflowCb.accept(TierPartitionState.RecoveryOperation.FREEZE_MERGED_LOG_START_OFFSET);
                }
            }
            log.info("Opened tier partition state for {} in status {}. topicIdPartition: {} tierEpoch: {} endOffset: {}", new Object[]{topicPartition, this.status, this.topicIdPartition, this.currentEpoch, this.endOffset});
        }

        private void loadSegmentStates(TopicPartition topicPartition, long offsetLowerBound, long startPosition) throws IOException {
            try {
                ArrayList<TierObjectMetadataAndFilePosition> allMetadata = this.readTierObjectMetadataInOrderOfOffset(this.channel, startPosition);
                for (int index = 0; index < allMetadata.size(); ++index) {
                    TierObjectMetadataAndFilePosition metadataAndFilePosition = allMetadata.get(index);
                    TierObjectMetadata metadata = metadataAndFilePosition.metadata;
                    if (this.boundVirtualBaseOffsetOfSegment(metadata, offsetLowerBound)) {
                        this.updateMetadataInFile(metadata, metadataAndFilePosition.filePosition);
                    }
                    SegmentState segmentState = new SegmentState(metadata, metadataAndFilePosition.filePosition);
                    this.allSegmentStates.put(segmentState.objectId(), segmentState);
                    log.debug("{}: scan reloaded metadata {}", (Object)topicPartition, (Object)segmentState);
                    this.addSegmentState(segmentState);
                    if (segmentState.state() == TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE) {
                        if (segmentState.uploadType() == TierUploadType.Archive) {
                            this.setArchiveUploadInProgress(segmentState);
                        } else if (segmentState.uploadType() == TierUploadType.Compaction) {
                            this.setCompactionUploadInProgress(segmentState);
                        }
                    }
                    allMetadata.set(index, null);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TierPartitionStateCorruptedException("Received (non-IO) exception while trying to reload segment states from file channel. This is usually indicative of some sort of file-based corruption.", e);
            }
        }

        private ArrayList<TierObjectMetadataAndFilePosition> readTierObjectMetadataInOrderOfOffset(CheckedFileIO channel, long startPosition) throws IOException {
            long currentPosition = startPosition;
            FileTierPartitionIterator iterator = new FileTierPartitionIterator(this.topicIdPartition, channel, currentPosition, false);
            ArrayList<TierObjectMetadataAndFilePosition> allMetadata = new ArrayList<TierObjectMetadataAndFilePosition>();
            while (iterator.hasNext()) {
                TierObjectMetadata metadata = (TierObjectMetadata)iterator.next();
                TierObjectMetadataAndFilePosition metadataAndFilePosition = new TierObjectMetadataAndFilePosition(metadata, currentPosition);
                allMetadata.add(metadataAndFilePosition);
                currentPosition = iterator.position();
            }
            if (currentPosition < channel.size()) {
                throw new TierPartitionStateCorruptedException("Could not read all bytes in file. position: " + currentPosition + " size: " + channel.size() + " for partition " + String.valueOf(this.topicIdPartition));
            }
            allMetadata.sort(Comparator.comparingLong(m -> m.metadata.endOffset()));
            return allMetadata;
        }

        public void updateBasePath(String path) {
            this.basePath = path;
        }

        SegmentState updateAndGetState(long filePosition, TierObjectMetadata metadata) {
            SegmentState existing = (SegmentState)this.allSegmentStates.get(metadata.objectId());
            SegmentState nextState = existing != null ? existing.updateState(metadata.state()) : new SegmentState(metadata, filePosition);
            this.allSegmentStates.put(metadata.objectId(), nextState);
            return nextState;
        }

        SegmentState getState(UUID objectId) {
            return (SegmentState)this.allSegmentStates.get(objectId);
        }

        Optional<ByteBuffer> getEncryptedDek(UUID objectId) {
            SegmentState objectState = this.getState(objectId);
            if (objectState == null) {
                return Optional.empty();
            }
            long position = objectState.filePosition();
            TierObjectMetadata tierObjectMetadata = FileTierPartitionStateUtils.read(this.topicIdPartition, this.channel, position);
            return Optional.ofNullable(tierObjectMetadata.encryptedDek());
        }

        private TierPartitionStatus getStatus() {
            return this.status;
        }

        private void setStatus(TierPartitionStatus status) {
            if (this.status == TierPartitionStatus.UNINITIALIZED || status == TierPartitionStatus.UNINITIALIZED) {
                throw new IllegalStateException("Illegal transition " + String.valueOf((Object)this.status) + " to " + String.valueOf((Object)status));
            }
            if (this.status != status) {
                this.status = status;
                this.dirty = true;
                log.info("Status updated to {} for {}", (Object)status, (Object)this.topicIdPartition);
            }
        }

        private void setErrorStatus(OffsetAndEpoch offsetAndEpoch, boolean errorStatusReachedViaFenceEvent, boolean freezeMergedLogStartOffset) {
            this.errorOffsetAndEpoch = offsetAndEpoch;
            this.errorStatusReachedViaFenceEvent = errorStatusReachedViaFenceEvent;
            if (freezeMergedLogStartOffset) {
                this.setStatus(TierPartitionStatus.FROZEN_LOG_START_OFFSET);
                if (this.recoveryWorkflowCb != null) {
                    this.recoveryWorkflowCb.accept(TierPartitionState.RecoveryOperation.FREEZE_MERGED_LOG_START_OFFSET);
                }
            } else if (this.status == TierPartitionStatus.DISCOVER && !errorStatusReachedViaFenceEvent) {
                this.setStatus(TierPartitionStatus.DISCOVER_ERROR);
            } else {
                this.setStatus(TierPartitionStatus.ERROR);
            }
        }

        public void beginCatchup() {
            if (!this.status.isOpenForWrite()) {
                throw new IllegalStateException("Illegal state " + String.valueOf((Object)this.status) + " for tier partition basePath: " + this.basePath);
            }
            this.setStatus(TierPartitionStatus.CATCHUP);
        }

        public void onCatchUpComplete() {
            if (!this.status.isOpenForWrite()) {
                throw new IllegalStateException("Illegal state " + String.valueOf((Object)this.status) + " for tier partition basePath: " + this.basePath);
            }
            this.setStatus(TierPartitionStatus.ONLINE);
        }

        public void beginDiscover() {
            if (!this.status.isOpenForWrite()) {
                throw new IllegalStateException("Illegal state " + String.valueOf((Object)this.status) + " for tier partition basePath: " + this.basePath);
            }
            this.setStatus(TierPartitionStatus.DISCOVER);
        }

        public void onDiscoverComplete() {
            if (!this.status.hasError()) {
                this.setStatus(TierPartitionStatus.CATCHUP);
            } else if (this.status == TierPartitionStatus.DISCOVER_ERROR) {
                this.setStatus(TierPartitionStatus.ERROR);
            }
        }

        public Optional<Long> startOffset() {
            Map.Entry firstEntry = this.logSegments.firstEntry();
            if (firstEntry != null) {
                return Optional.of((Long)firstEntry.getKey());
            }
            return Optional.empty();
        }

        public Long endOffset() {
            return this.endOffset;
        }

        public Long dataEndOffset() {
            Map.Entry lastEntry = this.logSegments.lastEntry();
            if (lastEntry == null) {
                return -1L;
            }
            return ((SegmentState)lastEntry.getValue()).endOffset();
        }

        TierPartitionStatus status() {
            return this.status;
        }

        int currentEpoch() {
            return this.currentEpoch;
        }

        public int numSegments() {
            return this.logSegments.size();
        }

        long committedEndOffset() {
            return this.committedEndOffset;
        }

        long totalSize() {
            return this.validSegmentsSize;
        }

        public long compactDirtyStartOffset() {
            return this.compactDirtyStartOffset;
        }

        public CompactStats lastCompactStats() {
            return this.lastCompactStats;
        }

        public CompactStats accumulatedCompactStats() {
            return this.accumulatedCompactStats;
        }

        private NavigableSet<Long> segmentOffsets() {
            return this.logSegments.keySet();
        }

        public NavigableSet<Long> segmentOffsets(long from, long to) {
            return MergedLog$.MODULE$.logSegments(this.logSegments, from, to).keySet();
        }

        public Collection<SegmentState> segments() {
            return this.logSegments.values();
        }

        public Collection<SegmentState> segments(long from, long to) {
            if (from > this.endOffset) {
                return new ArrayList<SegmentState>();
            }
            return Optional.ofNullable(this.logSegments.floorKey(from)).map(floor -> this.logSegments.subMap(floor, (Object)to)).orElseGet(() -> this.logSegments.headMap((Object)to)).values();
        }

        public List<SegmentState> fetchInMemoryMetadataRange(long from, long to) {
            ArrayList<SegmentState> allMetadata = new ArrayList<SegmentState>();
            if (this.immediatelyPrecedingDeletedSegment != null && this.immediatelyPrecedingDeletedSegment.endOffset() >= from && this.immediatelyPrecedingDeletedSegment.baseOffset() <= to) {
                allMetadata.add(this.immediatelyPrecedingDeletedSegment);
            }
            allMetadata.addAll(this.segments(from, to));
            return allMetadata;
        }

        public Optional<SegmentState> previousMetadataBeforeOffset(long targetStartOffset) {
            if (targetStartOffset < 0L) {
                return Optional.empty();
            }
            ListIterator<SegmentState> li = this.segmentStateListIterator(0L, targetStartOffset);
            while (li.hasPrevious()) {
                SegmentState entry = li.previous();
                if (entry.endOffset() >= targetStartOffset) continue;
                return Optional.of(entry);
            }
            return Optional.empty();
        }

        private Optional<SegmentState> previousMetadataForFollowerRestorePoint(long targetStartOffset) {
            if (targetStartOffset < 0L) {
                return Optional.empty();
            }
            ListIterator<SegmentState> li = this.segmentStateListIterator(0L, targetStartOffset);
            while (li.hasPrevious()) {
                SegmentState entry = li.previous();
                if (entry.baseOffset() >= targetStartOffset) continue;
                return Optional.of(entry);
            }
            return Optional.empty();
        }

        private ListIterator<SegmentState> segmentStateListIterator(long startOffset, long endOffset) {
            List<SegmentState> allMetadata = this.fetchInMemoryMetadataRange(startOffset, endOffset);
            return allMetadata.listIterator(allMetadata.size());
        }

        void putValid(SegmentState state) {
            SegmentState previous = this.logSegments.put(state.baseOffset(), state);
            if (previous != null) {
                this.validSegmentsSize -= (long)previous.size();
            }
            this.validSegmentsSize += (long)state.size();
            this.endOffset = Math.max(this.endOffset, state.endOffset());
        }

        void removeValid(SegmentState segmentState) {
            SegmentState toRemove = (SegmentState)this.logSegments.get(segmentState.baseOffset());
            if (toRemove != null && toRemove.objectId().equals(segmentState.objectId())) {
                this.logSegments.remove(segmentState.baseOffset());
                this.validSegmentsSize -= (long)segmentState.size();
            }
        }

        private boolean boundVirtualBaseOffsetOfSegment(TierObjectMetadata metadata, long offsetLowerBound) {
            if (metadata.hasVirtualOffset()) {
                return false;
            }
            return metadata.boundOverlappingOffset(this.proposeVirtualBaseOffsetOfSegment(metadata, offsetLowerBound));
        }

        private long proposeVirtualBaseOffsetOfSegment(TierObjectMetadata metadata, long offsetLowerBound) {
            if (metadata.uploadType() == TierUploadType.Compaction) {
                return metadata.baseOffset();
            }
            if (metadata.endOffset() < offsetLowerBound) {
                return metadata.baseOffset();
            }
            return Math.max(offsetLowerBound, Math.max(metadata.baseOffset(), this.endOffset + 1L));
        }

        private TierPartitionState.AppendResult appendMetadataUnhandled(AbstractTierMetadata entry, OffsetAndEpoch offsetAndEpoch) throws IOException {
            if (this.status.hasError()) {
                log.debug("Skipping processing for {} from offset {} as the current status is failed", (Object)entry, (Object)offsetAndEpoch);
                return TierPartitionState.AppendResult.FAILED;
            }
            if (!this.status.isOpenForWrite()) {
                log.debug("Skipping processing for {} from offset {} as file is not open for write", (Object)entry, (Object)offsetAndEpoch);
                return TierPartitionState.AppendResult.NOT_TIERABLE;
            }
            if (!FileTierPartitionState.allowedSourceOffset(offsetAndEpoch, this.localMaterializedOffsetAndEpoch)) {
                log.debug("Ignoring message at offset {} as last materialized offset is {} for {}", new Object[]{offsetAndEpoch, this.localMaterializedOffsetAndEpoch, this.topicIdPartition});
                return TierPartitionState.AppendResult.FENCED;
            }
            if (!FileTierPartitionState.allowedStateOffset(entry.stateOffsetAndEpoch(), this.restoreOffsetAndEpoch)) {
                log.info("Ignoring message {} at offset {} as the provided restore offset is {} and current restore offset is {} for {}", new Object[]{entry, offsetAndEpoch, entry.stateOffsetAndEpoch(), this.restoreOffsetAndEpoch, this.topicIdPartition});
                return TierPartitionState.AppendResult.RESTORE_FENCED;
            }
            if (this.status.isPendingDeletion()) {
                log.debug("Ignoring message {} at offset {} as partition is marked for deletion", (Object)entry, (Object)offsetAndEpoch);
                return TierPartitionState.AppendResult.FENCED;
            }
            TierPartitionState.AppendResult result = this.appendMetadataImpl(entry, offsetAndEpoch);
            this.localMaterializedOffsetAndEpoch = offsetAndEpoch;
            log.debug("Processed append for {} with result {} consumed from offset {}", new Object[]{entry, result, offsetAndEpoch});
            return result;
        }

        private TierPartitionState.AppendResult appendMetadata(AbstractTierMetadata entry, OffsetAndEpoch offsetAndEpoch) throws KafkaStorageException {
            try {
                return this.appendMetadataUnhandled(entry, offsetAndEpoch);
            }
            catch (IOException ioe) {
                TierPartitionStatus previousStatus = this.getStatus();
                this.setErrorStatus(offsetAndEpoch, false, false);
                this.ioExceptionHandler.accept(ioe);
                throw new KafkaStorageException("Failed to apply " + String.valueOf(entry) + ", currentEpoch=" + this.currentEpoch + ", tierTopicPartitionOffsetAndEpoch=" + String.valueOf(offsetAndEpoch) + ", previousTierPartitionStatus=" + String.valueOf((Object)previousStatus) + ", newTierPartitionStatus=" + String.valueOf((Object)TierPartitionStatus.ERROR), (Throwable)ioe);
            }
            catch (Exception e) {
                TierPartitionStatus previousStatus = this.getStatus();
                this.setErrorStatus(offsetAndEpoch, false, false);
                String logMsg = String.format("Failed to apply %s, currentEpoch=%d, tierTopicPartitionOffsetAndEpoch=%s, previousTierPartitionStatus=%s, newTierPartitionStatus=%s", new Object[]{entry, this.currentEpoch, offsetAndEpoch, previousStatus, TierPartitionStatus.ERROR});
                if (previousStatus == TierPartitionStatus.ONLINE) {
                    log.error(logMsg, (Throwable)e);
                } else {
                    log.info(logMsg, (Throwable)e);
                }
                return TierPartitionState.AppendResult.FAILED;
            }
        }

        private TierPartitionState.AppendResult appendMetadataImpl(AbstractTierMetadata entry, OffsetAndEpoch offsetAndEpoch) throws IOException {
            TierPartitionState.AppendResult appendResult = switch (entry.type()) {
                case TierRecordType.InitLeader -> this.handleInitLeader((TierTopicInitLeader)entry);
                case TierRecordType.PartitionFence -> this.handlePartitionFence((TierPartitionFence)entry, offsetAndEpoch);
                case TierRecordType.SegmentUploadInitiate, TierRecordType.SegmentUploadComplete, TierRecordType.SegmentDeleteInitiate, TierRecordType.SegmentDeleteComplete -> this.maybeTransitionSegment((AbstractTierSegmentMetadata)entry);
                case TierRecordType.CompactionCommitAndSwap -> this.maybeCommitCompactionTransition((TierCompactionCommitAndSwap)entry);
                case TierRecordType.PartitionDeleteInitiate -> this.handlePartitionDeleteInitiate((TierPartitionDeleteInitiate)entry);
                case TierRecordType.PartitionDeleteComplete -> TierPartitionState.AppendResult.ACCEPTED;
                case TierRecordType.PartitionDeletePreInitiate -> this.handlePartitionDeletePreInitiate((TierPartitionDeletePreInitiate)entry);
                case TierRecordType.MetadataSnapshotUploadInitiate, TierRecordType.MetadataSnapshotUploadComplete -> this.maybeTransitionSnapshot(entry, offsetAndEpoch);
                default -> throw new IllegalStateException("Attempt to append unknown type " + String.valueOf((Object)entry.type()) + " to " + String.valueOf(this.topicIdPartition));
            };
            Iterator<Map.Entry<Class<? extends MaterializationListener>, MaterializationListener>> iter = this.listeners.entrySet().iterator();
            while (iter.hasNext()) {
                if (!this.tryCompleteListener(iter.next().getValue(), Optional.of(entry))) continue;
                iter.remove();
            }
            return appendResult;
        }

        private boolean tryCompleteListener(MaterializationListener listener, Optional<AbstractTierMetadata> entry) throws IOException {
            if (listener.mayComplete(this, entry)) {
                this.flush();
                return listener.complete(this);
            }
            return false;
        }

        private Supplier<Optional<TierObjectMetadata>> metadataForInMemorySegmentMetadata(SegmentState metadata) {
            try {
                FileTierPartitionIterator iter = FileTierPartitionState.iterator(this.topicIdPartition, this.channel, metadata.filePosition());
                return () -> {
                    if (iter.hasNext()) {
                        return Optional.of((TierObjectMetadata)iter.next());
                    }
                    return Optional.empty();
                };
            }
            catch (IOException e) {
                throw new KafkaStorageException((Throwable)e);
            }
        }

        private List<SegmentState> filterSegments(Predicate<SegmentState> fn) {
            return this.allSegmentStates.values().stream().filter(fn).collect(Collectors.toList());
        }

        private List<SegmentState> segmentsWithStatesEqualTo(Set<TierObjectMetadata.State> states) {
            return this.filterSegments(segmentState -> states.contains((Object)segmentState.state()));
        }

        private List<SegmentState> segmentsWithStatesNotEqualTo(Set<TierObjectMetadata.State> excludedStates) {
            return this.filterSegments(segmentState -> !excludedStates.contains((Object)segmentState.state()));
        }

        public String toString() {
            return "State(status=" + String.valueOf((Object)this.status) + ", startOffset=" + String.valueOf(this.startOffset()) + ", endOffset=" + this.endOffset() + ", dataEndOffset=" + this.dataEndOffset() + ", committedEndOffset=" + this.committedEndOffset() + ", numSegments=" + this.numSegments() + ", tierEpoch=" + this.currentEpoch + ", lastMaterializedOffset=" + String.valueOf(this.localMaterializedOffsetAndEpoch) + ", globalMaterializedOffset=" + String.valueOf(this.globalMaterializedOffsetAndEpoch) + ", errorOffsetAndEpoch=" + String.valueOf(this.errorOffsetAndEpoch) + ", restoreOffsetAndEpoch=" + String.valueOf(this.restoreOffsetAndEpoch) + ", checksumAlgorithm=" + String.valueOf((Object)this.checksumAlgorithm) + ", checksumSuperBlockLength=" + this.checksumSuperBlockLength + ", lastSnapshotTimestampMs=" + this.lastSnapshotTimestampMs + ", lastSnapshotId=" + String.valueOf(this.lastSnapshotId) + ", lastCommittedSnapshotId=" + String.valueOf(this.lastCommittedSnapshotId) + ")";
        }

        public Optional<SegmentState> metadata(long targetOffset) throws IOException {
            Collection<SegmentState> view = this.segments(targetOffset, Long.MAX_VALUE);
            for (SegmentState segment : view) {
                if (segment.endOffset() < targetOffset) continue;
                return Optional.of(segment);
            }
            return Optional.empty();
        }

        private TierPartitionState.AppendResult handlePartitionDeletePreInitiate(TierPartitionDeletePreInitiate partitionDeletePreInitiateEvent) {
            this.setStatus(TierPartitionStatus.PENDING_DELETION);
            log.info("topicIdPartition={} marked for deletion by PartitionDeletePreInitiate event={}", (Object)this.topicIdPartition, (Object)partitionDeletePreInitiateEvent);
            return TierPartitionState.AppendResult.ACCEPTED;
        }

        private TierPartitionState.AppendResult handlePartitionDeleteInitiate(TierPartitionDeleteInitiate partitionDeleteInitiateEvent) {
            this.setStatus(TierPartitionStatus.PENDING_DELETION);
            log.info("topicIdPartition={} marked for deletion by PartitionDeleteInitiate event={}", (Object)this.topicIdPartition, (Object)partitionDeleteInitiateEvent);
            return TierPartitionState.AppendResult.ACCEPTED;
        }

        private TierPartitionState.AppendResult handlePartitionFence(TierPartitionFence partitionFenceEvent, OffsetAndEpoch offsetAndEpoch) {
            if (partitionFenceEvent.freezeLogStartOffset() && this.recoveryWorkflowCb == null) {
                throw new IllegalStateException(String.format("Cannot process metadata %s at offsetEpoch %s%n.FileTierPartitionState needs a recovery workflow callback to process a partition fence event when log start offset needs to be frozen as well.", partitionFenceEvent, offsetAndEpoch));
            }
            this.setErrorStatus(offsetAndEpoch, true, partitionFenceEvent.freezeLogStartOffset());
            log.info("topicIdPartition={} fenced by PartitionFence event={} at offset={}", new Object[]{this.topicIdPartition, partitionFenceEvent, offsetAndEpoch});
            return TierPartitionState.AppendResult.FAILED;
        }

        private TierPartitionState.AppendResult handleInitLeader(TierTopicInitLeader initLeader) throws IOException {
            if (initLeader.tierEpoch() == this.currentEpoch) {
                return TierPartitionState.AppendResult.ACCEPTED;
            }
            if (initLeader.tierEpoch() > this.currentEpoch) {
                HashSet<TierObjectMetadata.State> statesToFence = new HashSet<TierObjectMetadata.State>(Arrays.asList(TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE, TierObjectMetadata.State.SEGMENT_DELETE_INITIATE));
                List<SegmentState> toFence = this.segmentsWithStatesEqualTo(statesToFence);
                for (SegmentState metadata : toFence) {
                    this.fenceSegment(metadata, initLeader.timestamp());
                }
                this.currentEpoch = initLeader.tierEpoch();
                this.dirty = true;
                return TierPartitionState.AppendResult.ACCEPTED;
            }
            return TierPartitionState.AppendResult.FENCED;
        }

        private boolean staleMetadataEpoch(AbstractTierMetadata metadata) {
            if (metadata.tierEpoch() > this.currentEpoch) {
                throw new IllegalStateException(String.format("Unexpected transition attempted for topicIdPartition=%s via metadata=%s at epoch=%s while currentEpoch=%s is lower", this.topicIdPartition, metadata, metadata.tierEpoch(), this.currentEpoch));
            }
            if (metadata.tierEpoch() < this.currentEpoch) {
                log.info("Fenced {} as currentEpoch={} ({})", new Object[]{metadata, this.currentEpoch, this.topicIdPartition});
                return true;
            }
            return false;
        }

        private TierPartitionState.AppendResult maybeTransitionSegment(AbstractTierSegmentMetadata metadata) throws IOException {
            if (this.staleMetadataEpoch(metadata)) {
                return TierPartitionState.AppendResult.FENCED;
            }
            SegmentState currentState = this.getState(metadata.objectId());
            if (currentState != null) {
                if (currentState.state().equals((Object)metadata.state())) {
                    log.debug("Accepting duplicate transition for {} ({})", (Object)metadata, (Object)this.topicIdPartition);
                    return TierPartitionState.AppendResult.ACCEPTED;
                }
                if (!currentState.state().canTransitionTo(metadata.state())) {
                    log.info("Fencing already processed transition for {} with currentState={} ({})", new Object[]{metadata, currentState, this.topicIdPartition});
                    return TierPartitionState.AppendResult.FENCED;
                }
            } else {
                if (metadata.state() == TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE) {
                    return TierPartitionState.AppendResult.ACCEPTED;
                }
                if (metadata.state() != TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE) {
                    throw new IllegalStateException("Cannot complete transition for non-existent segment " + String.valueOf(metadata) + " for " + String.valueOf(this.topicIdPartition));
                }
            }
            switch (metadata.type()) {
                case SegmentUploadInitiate: {
                    return this.handleUploadInitiate((TierSegmentUploadInitiate)metadata);
                }
                case SegmentUploadComplete: {
                    return this.handleUploadComplete((TierSegmentUploadComplete)metadata);
                }
                case SegmentDeleteInitiate: {
                    return this.handleDeleteInitiate((TierSegmentDeleteInitiate)metadata);
                }
                case SegmentDeleteComplete: {
                    return this.handleDeleteComplete((TierSegmentDeleteComplete)metadata);
                }
            }
            throw new IllegalStateException("Unexpected state " + String.valueOf((Object)metadata.state()) + " for " + String.valueOf(this.topicIdPartition));
        }

        private TierPartitionState.AppendResult maybeTransitionSnapshot(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) throws IOException {
            if (this.staleMetadataEpoch(metadata)) {
                return TierPartitionState.AppendResult.FENCED;
            }
            switch (metadata.type()) {
                case MetadataSnapshotUploadInitiate: {
                    return this.handleSnapshotUploadInitiate((TierMetadataSnapshotUploadInitiate)metadata, offsetAndEpoch);
                }
                case MetadataSnapshotUploadComplete: {
                    return this.handleSnapshotUploadComplete((TierMetadataSnapshotUploadComplete)metadata);
                }
            }
            throw new IllegalStateException("Unexpected state transition type: " + String.valueOf((Object)metadata.type()) + " for " + String.valueOf(this.topicIdPartition));
        }

        private TierPartitionState.AppendResult handleSnapshotUploadInitiate(TierMetadataSnapshotUploadInitiate snapshotInitiate, OffsetAndEpoch offsetAndEpoch) throws IOException {
            if (this.tierPartitionStateSnapshotFeatureFlag && this.brokerId == snapshotInitiate.brokerId()) {
                boolean isCurrentFtpsChecksumValid;
                if (this.status != TierPartitionStatus.ONLINE || this.currentEpoch != snapshotInitiate.tierEpoch()) {
                    return TierPartitionState.AppendResult.FAILED;
                }
                try {
                    isCurrentFtpsChecksumValid = this.validate();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error("Exception while validating tier metadata snapshot for " + String.valueOf(this.topicIdPartition), (Throwable)e);
                    return TierPartitionState.AppendResult.FAILED;
                }
                try {
                    if (isCurrentFtpsChecksumValid) {
                        this.takeMetadataSnapshot(snapshotInitiate.messageId());
                        log.debug("Tier metadata snapshot upload initiated for " + String.valueOf(this.topicIdPartition) + " after SnapshotUploadInitiate event={} at offset={}", (Object)snapshotInitiate, (Object)offsetAndEpoch);
                        return TierPartitionState.AppendResult.ACCEPTED;
                    }
                    throw new TierSnapshotChecksumValidationFailedException(String.format("Tier metadata checksum validation on live FTPS contents during snapshot upload for %s failed since validate() returned false.", this.topicIdPartition), null);
                }
                catch (NoSuchFileException nsfe) {
                    log.warn("Encountered NoSuchFileException while taking metadata snapshot for {}. This can be caused by partition deletion/reassignment during the snapshot materialization task.", (Object)this.topicIdPartition, (Object)nsfe);
                    return TierPartitionState.AppendResult.FAILED;
                }
            }
            return TierPartitionState.AppendResult.FENCED;
        }

        private TierPartitionState.AppendResult handleSnapshotUploadComplete(TierMetadataSnapshotUploadComplete snapshotComplete) {
            if (this.tierPartitionStateSnapshotFeatureFlag) {
                this.lastSnapshotTimestampMs = snapshotComplete.snapshotTimestampMs();
                this.lastSnapshotId = snapshotComplete.messageId();
                this.dirty = true;
                log.debug("Tier metadata snapshot upload complete for " + String.valueOf(this.topicIdPartition));
                return TierPartitionState.AppendResult.ACCEPTED;
            }
            return TierPartitionState.AppendResult.FENCED;
        }

        private void takeMetadataSnapshot(UUID snapshotId) throws IOException {
            long snapshotTimeMs = this.time.milliseconds();
            log.info("Started taking local FTPS snapshot for topicIdPartition={} snapshotId={} at snapshotTimeMs={}", new Object[]{this.topicIdPartition, snapshotId.toString(), snapshotTimeMs});
            FileTierPartitionState.writeHeader(this.channel, new Header(this.topicIdPartition.topicId(), this.version, this.currentEpoch, this.status, this.startOffset().orElse(-1L), this.endOffset, this.globalMaterializedOffsetAndEpoch, this.localMaterializedOffsetAndEpoch, this.errorOffsetAndEpoch, this.restoreOffsetAndEpoch, this.compactFeatureFlag, this.compactDirtyStartOffset, this.lastCompactStats, this.accumulatedCompactStats, this.includeStateChangeTimestamp, this.tierPartitionStateSnapshotFeatureFlag, this.lastSnapshotTimestampMs, this.lastSnapshotId));
            Path basePathInst = Paths.get(this.basePath, new String[0]);
            String baseName = basePathInst.getFileName().toString();
            FileTierPartitionStateSnapshotObject snapshotObject = new FileTierPartitionStateSnapshotObject(snapshotId, snapshotTimeMs, this.localMaterializedOffsetAndEpoch, this.currentEpoch, baseName, this.checksumAlgorithm);
            Path snapshotsDir = basePathInst.getParent().resolve("snapshots");
            Path snapshotPath = snapshotsDir.resolve(snapshotObject.encodeSnapshotName());
            CheckedFileIO snapshotIO = CheckedFileIO.openOrCreate(snapshotPath, this.checksumAlgorithm, this.checksumSuperBlockLength, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            snapshotIO.transferFrom(this.channel, 0L, this.channel.size());
            snapshotIO.close();
            log.info("Finished taking local FTPS snapshot for topicIdPartition={} snapshotId={} snapshotPath={}", new Object[]{this.topicIdPartition, snapshotId, snapshotPath});
        }

        private void trackPrecedingMetadata(SegmentState segmentState) {
            if (segmentState.baseOffset() < this.startOffset().orElse(Long.MAX_VALUE)) {
                this.immediatelyPrecedingDeletedSegment = segmentState;
            }
        }

        private SegmentState addSegmentMetadata(TierObjectMetadata metadata, long filePosition) {
            SegmentState segmentState = this.updateAndGetState(filePosition, metadata);
            this.addSegmentState(segmentState);
            return segmentState;
        }

        private void addSegmentState(SegmentState segmentState) {
            switch (segmentState.state()) {
                case SEGMENT_UPLOAD_INITIATE: {
                    break;
                }
                case SEGMENT_UPLOAD_COMPLETE: {
                    this.putValid(segmentState);
                    break;
                }
                case SEGMENT_DELETE_INITIATE: {
                    this.removeValid(segmentState);
                    this.trackPrecedingMetadata(segmentState);
                    break;
                }
                case SEGMENT_DELETE_COMPLETE: {
                    this.trackPrecedingMetadata(segmentState);
                    this.allSegmentStates.remove(segmentState.objectId());
                    this.hasDeletedSegmentAfterPreviousCleanup = true;
                    break;
                }
                case SEGMENT_FENCED: {
                    break;
                }
                case SEGMENT_COMPACTED: {
                    this.removeValid(segmentState);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown state " + String.valueOf(segmentState) + " for " + String.valueOf(this.topicIdPartition));
                }
            }
        }

        private void updateState(UUID objectId, TierObjectMetadata.State newState, long timestamp) throws IOException {
            SegmentState currentState = this.getState(objectId);
            if (currentState == null) {
                throw new IllegalStateException("No metadata found for " + CoreUtils.uuidToBase64(objectId) + " in " + String.valueOf(this.topicIdPartition));
            }
            if (!objectId.equals(currentState.objectId())) {
                throw new IllegalStateException("id mismatch. Expected: " + CoreUtils.uuidToBase64(objectId) + " Got: " + CoreUtils.uuidToBase64(currentState.objectId()) + " Partition: " + String.valueOf(this.topicIdPartition));
            }
            TierObjectMetadata metadata = TierUtils.updateSegmentState(this.topicIdPartition, currentState, newState, this.channel, timestamp);
            this.addSegmentMetadata(metadata, currentState.filePosition());
            this.dirty = true;
        }

        private void updateMetadataInFile(TierObjectMetadata newMetadata, long filePosition) throws IOException {
            this.channel.write(newMetadata.payloadBuffer(), filePosition + 2L);
            this.dirty = true;
        }

        private void fenceSegment(SegmentState segmentState, long timestamp) throws IOException {
            this.updateState(segmentState.objectId(), TierObjectMetadata.State.SEGMENT_FENCED, timestamp);
            if (this.archiveUploadInProgress != null && this.archiveUploadInProgress.objectId().equals(segmentState.objectId())) {
                this.archiveUploadInProgress = null;
            } else if (this.compactionUploadInProgress != null && this.compactionUploadInProgress.objectId().equals(segmentState.objectId())) {
                this.compactionUploadInProgress = null;
            }
        }

        private void markSegmentCompacted(UUID objectId, long timestamp) throws IOException {
            log.info("{}: marking compacted segment {} as compacted", (Object)this.topicIdPartition, (Object)CoreUtils.uuidToBase64(objectId));
            this.updateState(objectId, TierObjectMetadata.State.SEGMENT_COMPACTED, timestamp);
        }

        private TierPartitionState.AppendResult handleUploadInitiate(TierSegmentUploadInitiate uploadInitiate) throws IOException {
            if (uploadInitiate.uploadType() == TierUploadType.Archive) {
                return this.handleArchiveUploadInitiate(uploadInitiate);
            }
            if (uploadInitiate.uploadType() == TierUploadType.Compaction) {
                return this.handleCompactionUploadInitiate(uploadInitiate);
            }
            throw new IllegalArgumentException("Unknown upload type " + String.valueOf((Object)uploadInitiate.uploadType()) + " in metadata record " + String.valueOf(uploadInitiate));
        }

        private TierPartitionState.AppendResult handleArchiveUploadInitiate(TierSegmentUploadInitiate uploadInitiate) throws IOException {
            TierObjectMetadata metadata = new TierObjectMetadata(uploadInitiate, this.compactFeatureFlag, this.includeStateChangeTimestamp);
            this.boundVirtualBaseOffsetOfSegment(metadata, Long.MIN_VALUE);
            if (metadata.endOffset() > this.endOffset) {
                long messagePosition;
                this.maybeFenceArchiveUploadInProgress(uploadInitiate.timestamp());
                ByteBuffer metadataBuffer = metadata.payloadBuffer();
                this.tierPartitionStateFileSize = messagePosition = this.appendWithSizePrefix(metadataBuffer);
                SegmentState segmentState = this.addSegmentMetadata(metadata, messagePosition);
                this.setArchiveUploadInProgress(segmentState);
                this.dirty = true;
                return TierPartitionState.AppendResult.ACCEPTED;
            }
            log.info("Fencing uploadInitiate for {}. currentEndOffset={} currentEpoch={}. ({})", new Object[]{metadata, this.endOffset, this.currentEpoch, this.topicIdPartition});
            return TierPartitionState.AppendResult.FENCED;
        }

        private TierPartitionState.AppendResult handleCompactionUploadInitiate(TierSegmentUploadInitiate uploadInitiate) throws IOException {
            long messagePosition;
            TierObjectMetadata metadata = new TierObjectMetadata(uploadInitiate, this.compactFeatureFlag, this.includeStateChangeTimestamp);
            this.boundVirtualBaseOffsetOfSegment(metadata, Long.MIN_VALUE);
            if (metadata.endOffset() > this.endOffset) {
                throw new IllegalStateException("Compacted upload initiate " + String.valueOf(uploadInitiate) + " has a higher end offset than the overall state. This should be impossible.");
            }
            if (uploadInitiate.previousObjectId().isPresent()) {
                this.checkCompactionUploadInProgress(uploadInitiate.previousObjectId().get());
                this.compactionUploadInProgress = null;
            } else {
                this.maybeFenceCompactionUploadInProgress(uploadInitiate.timestamp());
            }
            ByteBuffer metadataBuffer = metadata.payloadBuffer();
            this.tierPartitionStateFileSize = messagePosition = this.appendWithSizePrefix(metadataBuffer);
            SegmentState segmentState = this.addSegmentMetadata(metadata, messagePosition);
            this.setCompactionUploadInProgress(segmentState);
            this.dirty = true;
            return TierPartitionState.AppendResult.ACCEPTED;
        }

        private TierPartitionState.AppendResult handleUploadComplete(TierSegmentUploadComplete uploadComplete) throws IOException {
            this.completeArchiveUploadInProgress(uploadComplete.objectId(), uploadComplete.timestamp());
            return TierPartitionState.AppendResult.ACCEPTED;
        }

        private void setArchiveUploadInProgress(SegmentState segmentState) {
            if (this.archiveUploadInProgress != null) {
                throw new IllegalStateException("Unexpected archive upload in progress " + String.valueOf(this.archiveUploadInProgress) + " when appending " + String.valueOf(segmentState) + " to " + String.valueOf(this.topicIdPartition));
            }
            this.archiveUploadInProgress = segmentState;
        }

        private void setCompactionUploadInProgress(SegmentState segmentState) {
            if (this.compactionUploadInProgress != null) {
                throw new IllegalStateException("Unexpected compaction upload in progress " + String.valueOf(this.compactionUploadInProgress) + " when appending " + String.valueOf(segmentState) + " to " + String.valueOf(this.topicIdPartition));
            }
            this.compactionUploadInProgress = segmentState;
        }

        private void checkArchiveUploadInProgress(UUID objectId) {
            if (this.archiveUploadInProgress == null) {
                throw new IllegalStateException("Expected to find archive upload in progress for object " + CoreUtils.uuidToBase64(objectId));
            }
            if (!this.archiveUploadInProgress.objectId().equals(objectId)) {
                throw new IllegalStateException("Expected " + CoreUtils.uuidToBase64(objectId) + " to be in-progress for archiving but got " + CoreUtils.uuidToBase64(this.archiveUploadInProgress.objectId()) + " for partition " + String.valueOf(this.topicIdPartition));
            }
        }

        private void checkCompactionUploadInProgress(UUID objectId) {
            if (this.compactionUploadInProgress == null) {
                throw new IllegalStateException("Expected to find compaction upload in progress for object " + CoreUtils.uuidToBase64(objectId));
            }
            if (!this.compactionUploadInProgress.objectId().equals(objectId)) {
                throw new IllegalStateException("Expected " + CoreUtils.uuidToBase64(objectId) + " to be in-progress for compaction but got " + CoreUtils.uuidToBase64(this.compactionUploadInProgress.objectId()) + " for partition " + String.valueOf(this.topicIdPartition));
            }
        }

        private void checkCompactionUploadInProgress(TierCompactionCommitAndSwap commitAndSwap) {
            int idx;
            if (this.compactionUploadInProgress == null) {
                throw new IllegalStateException("Expected to find compaction upload in progress for message " + commitAndSwap.messageIdAsBase64());
            }
            for (idx = 0; idx < commitAndSwap.destinationObjectIdsLength() && !commitAndSwap.destinationObjectIdsGet(idx).equals(this.compactionUploadInProgress.objectId()); ++idx) {
            }
            if (idx == commitAndSwap.destinationObjectIdsLength()) {
                throw new IllegalStateException("Object id of in-progress upload " + CoreUtils.uuidToBase64(this.compactionUploadInProgress.objectId()) + " doesn't match any destination object id in " + String.valueOf(commitAndSwap));
            }
        }

        private void maybeFenceArchiveUploadInProgress(long timestamp) throws IOException {
            if (this.archiveUploadInProgress != null) {
                this.updateState(this.archiveUploadInProgress.objectId(), TierObjectMetadata.State.SEGMENT_FENCED, timestamp);
                this.archiveUploadInProgress = null;
            }
        }

        private void maybeFenceCompactionUploadInProgress(long timestamp) throws IOException {
            if (this.compactionUploadInProgress != null) {
                this.updateState(this.compactionUploadInProgress.objectId(), TierObjectMetadata.State.SEGMENT_FENCED, timestamp);
                this.compactionUploadInProgress = null;
            }
        }

        private void completeArchiveUploadInProgress(UUID objectId, long timestamp) throws IOException {
            this.checkArchiveUploadInProgress(objectId);
            this.updateState(objectId, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, timestamp);
            this.archiveUploadInProgress = null;
        }

        private TierPartitionState.AppendResult maybeCommitCompactionTransition(TierCompactionCommitAndSwap commitAndSwap) throws IOException {
            int i;
            if (this.staleMetadataEpoch(commitAndSwap)) {
                return TierPartitionState.AppendResult.FENCED;
            }
            if (this.idempotentlyIgnoreCommitAndSwap(commitAndSwap)) {
                return TierPartitionState.AppendResult.ACCEPTED;
            }
            ArrayList<SegmentState> sourceSegments = this.getAndValidateSourceSegments(commitAndSwap);
            ArrayList<SegmentState> destinationSegments = this.getAndValidateDestinationSegments(commitAndSwap);
            this.checkCompactionSwapInvariants(sourceSegments, destinationSegments);
            if (commitAndSwap.destinationObjectIdsLength() == 0) {
                this.maybeFenceCompactionUploadInProgress(commitAndSwap.timestamp());
            } else {
                this.checkCompactionUploadInProgress(commitAndSwap);
            }
            for (i = 0; i < commitAndSwap.destinationObjectIdsLength(); ++i) {
                this.updateState(commitAndSwap.destinationObjectIdsGet(i), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, commitAndSwap.timestamp());
            }
            this.compactionUploadInProgress = null;
            for (i = 0; i < commitAndSwap.sourceObjectIdsLength(); ++i) {
                UUID objectId = commitAndSwap.sourceObjectIdsGet(i);
                this.markSegmentCompacted(objectId, commitAndSwap.timestamp());
            }
            this.compactDirtyStartOffset = Math.max(this.compactDirtyStartOffset, commitAndSwap.lastCleanOffset() + 1L);
            CompactStats compactStats = commitAndSwap.compactStats();
            if (!compactStats.equals(CompactStats.EMPTY)) {
                this.lastCompactStats = compactStats;
                this.accumulatedCompactStats = this.accumulatedCompactStats.accumulate(compactStats);
            }
            return TierPartitionState.AppendResult.ACCEPTED;
        }

        private boolean idempotentlyIgnoreCommitAndSwap(TierCompactionCommitAndSwap commitAndSwap) {
            if (commitAndSwap.destinationObjectIdsLength() == 0) {
                for (int i = 0; i < commitAndSwap.sourceObjectIdsLength(); ++i) {
                    UUID objectId = commitAndSwap.sourceObjectIdsGet(i);
                    SegmentState existing = (SegmentState)this.allSegmentStates.get(objectId);
                    if (existing == null || existing.state() == TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < commitAndSwap.destinationObjectIdsLength(); ++i) {
                UUID objectId = commitAndSwap.destinationObjectIdsGet(i);
                SegmentState segment = (SegmentState)this.allSegmentStates.get(objectId);
                if (segment != null && segment.state() == TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE) continue;
                return false;
            }
            return true;
        }

        private ArrayList<SegmentState> getAndValidateDestinationSegments(TierCompactionCommitAndSwap commitAndSwap) {
            ArrayList<SegmentState> destinationSegments = new ArrayList<SegmentState>(commitAndSwap.destinationObjectIdsLength());
            for (int i = 0; i < commitAndSwap.destinationObjectIdsLength(); ++i) {
                UUID objectId = commitAndSwap.destinationObjectIdsGet(i);
                SegmentState preSwap = (SegmentState)this.allSegmentStates.get(objectId);
                if (preSwap == null || preSwap.state() != TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE) {
                    throw new IllegalStateException("Expected segment with object id " + CoreUtils.uuidToBase64(objectId) + " to exist in complete state and be in log view for compaction to succeed. Current state: " + String.valueOf(preSwap) + ", metadata: " + String.valueOf(commitAndSwap));
                }
                destinationSegments.add(preSwap);
            }
            return destinationSegments;
        }

        private ArrayList<SegmentState> getAndValidateSourceSegments(TierCompactionCommitAndSwap commitAndSwap) {
            ArrayList<SegmentState> sourceSegments = new ArrayList<SegmentState>(commitAndSwap.sourceObjectIdsLength());
            for (int i = 0; i < commitAndSwap.sourceObjectIdsLength(); ++i) {
                UUID objectId = commitAndSwap.sourceObjectIdsGet(i);
                SegmentState compacted = (SegmentState)this.allSegmentStates.get(objectId);
                if (compacted == null || compacted.state() != TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE) {
                    throw new IllegalStateException("Expected segment with object id " + CoreUtils.uuidToBase64(objectId) + " to exist in complete state and be in log view for compaction to succeed. Current state: " + String.valueOf(compacted) + ", metadata: " + String.valueOf(commitAndSwap));
                }
                sourceSegments.add(compacted);
            }
            return sourceSegments;
        }

        private void checkCompactionSwapInvariants(ArrayList<SegmentState> sourceSegments, ArrayList<SegmentState> destinationSegments) {
            Set sourceSegmentsUuids;
            long sourceRangeEnd;
            if (sourceSegments.isEmpty()) {
                throw new IllegalStateException("There should be at least one source segment and one destination segment.");
            }
            if (destinationSegments.isEmpty()) {
                return;
            }
            long updatedRangeStart = destinationSegments.stream().map(SegmentState::baseOffset).min(Long::compare).get();
            long updatedRangeEnd = destinationSegments.stream().map(SegmentState::endOffset).max(Long::compare).get();
            long sourceRangeStart = sourceSegments.stream().map(SegmentState::baseOffset).min(Long::compare).get();
            Collection<SegmentState> contiguousSegments = this.segments(sourceRangeStart, (sourceRangeEnd = sourceSegments.stream().map(SegmentState::endOffset).max(Long::compare).get().longValue()) + 1L);
            Set contiguousSegmentUuids = contiguousSegments.stream().map(SegmentState::objectId).collect(Collectors.toSet());
            if (!contiguousSegmentUuids.equals(sourceSegmentsUuids = sourceSegments.stream().map(SegmentState::objectId).collect(Collectors.toSet()))) {
                throw new IllegalStateException("Source segments " + String.valueOf(sourceSegments) + " being replaced by compacted segments " + String.valueOf(destinationSegments) + " should be contiguous in tier state and present. Found: " + String.valueOf(contiguousSegments));
            }
            if (updatedRangeStart < sourceRangeStart) {
                throw new IllegalStateException(String.format("Destination segments must not have a smaller first offset than source. Source %s destination %s", sourceSegments, destinationSegments));
            }
            if (updatedRangeEnd > sourceRangeEnd) {
                throw new IllegalStateException(String.format("Destination segments must not have a larger last offset than source. Source %s destination %s", sourceSegments, destinationSegments));
            }
        }

        private TierPartitionState.AppendResult handleDeleteInitiate(TierSegmentDeleteInitiate deleteInitiate) throws IOException {
            SegmentState currentState = this.getState(deleteInitiate.objectId());
            if (currentState.state() == TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE) {
                if (!this.startOffset().isPresent()) {
                    throw new IllegalStateException("At least one segment must be present to delete " + String.valueOf(currentState) + " from " + String.valueOf(this));
                }
                if (currentState.baseOffset() != this.startOffset().get().longValue()) {
                    throw new IllegalStateException("Should be deleting first segment from tier state. Tried to delete " + String.valueOf(currentState) + " from " + String.valueOf(this));
                }
            }
            this.updateState(deleteInitiate.objectId(), TierObjectMetadata.State.SEGMENT_DELETE_INITIATE, deleteInitiate.timestamp());
            return TierPartitionState.AppendResult.ACCEPTED;
        }

        private TierPartitionState.AppendResult handleDeleteComplete(TierSegmentDeleteComplete deleteComplete) throws IOException {
            this.updateState(deleteComplete.objectId(), TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE, deleteComplete.timestamp());
            return TierPartitionState.AppendResult.ACCEPTED;
        }

        private void registerListener(MaterializationListener listener) throws IOException {
            Class<?> ty = listener.getClass();
            MaterializationListener old = this.listeners.remove(ty);
            if (old != null) {
                old.cancel(new IllegalStateException(String.format("%s listener already registered: ", ty.getName())));
            }
            if (!this.tryCompleteListener(listener, Optional.empty())) {
                this.listeners.put(ty, listener);
                log.info("Registered materialization listener {}", (Object)listener);
            }
        }

        public CompletableFuture<Optional<TierLogSegment>> materializeUptoLeaderEpoch(int targetEpoch) throws IOException {
            CompletableFuture<Optional<TierLogSegment>> promise = new CompletableFuture<Optional<TierLogSegment>>();
            MaterializationListener.LeaderEpoch listener = new MaterializationListener.LeaderEpoch(log, this.topicIdPartition, promise, targetEpoch);
            this.registerListener(listener);
            return promise;
        }

        public CompletableFuture<TierLogSegment> materializationListener(long targetOffset) throws IOException {
            CompletableFuture<TierLogSegment> promise = new CompletableFuture<TierLogSegment>();
            MaterializationListener.ReplicationTargetOffset listener = new MaterializationListener.ReplicationTargetOffset(log, this.topicIdPartition, promise, targetOffset);
            this.registerListener(listener);
            return promise;
        }

        public CompletableFuture<TierLogSegment> materializationListener(long upperBoundEndOffset, UUID targetObjectId, long targetRestoreEpoch) throws IOException {
            CompletableFuture<TierLogSegment> promise = new CompletableFuture<TierLogSegment>();
            MaterializationListener.ReplicationTargetObjectId listener = new MaterializationListener.ReplicationTargetObjectId(log, this.topicIdPartition, promise, targetObjectId, targetRestoreEpoch, upperBoundEndOffset);
            this.registerListener(listener);
            return promise;
        }

        public CompletableFuture<Boolean> trackMetadataInitialization(int targetLeaderEpoch) throws IllegalStateException, IOException {
            if (this.listeners.containsKey(MaterializationListener.Initialization.class)) {
                throw new IllegalStateException(String.format("%s listener already registered: ", MaterializationListener.Initialization.class.getName()));
            }
            CompletableFuture<Boolean> promise = new CompletableFuture<Boolean>();
            MaterializationListener.Initialization listener = new MaterializationListener.Initialization(log, this.topicIdPartition, promise, targetLeaderEpoch);
            this.registerListener(listener);
            return promise;
        }

        void closeListeners() {
            this.closeListeners(new TierPartitionStateIllegalListenerException("Tier partition state for " + String.valueOf(this.topicIdPartition) + " has been closed."));
        }

        void closeListeners(Exception exception) {
            for (MaterializationListener listener : this.listeners.values()) {
                listener.cancel(exception);
            }
            this.listeners.clear();
        }

        private void close() throws IOException {
            this.closeListeners();
            if (this.channel != null) {
                this.channel.close();
            }
        }

        private boolean validate() throws IOException, ReflectiveOperationException {
            if (this.status.isOpenForWrite() && this.channel != null) {
                if (!this.channel.validate()) {
                    log.error("FTPS checksum validation failed for topicIdPartition={}, {}", (Object)this.topicIdPartition, (Object)this.globalMaterializedOffsetAndEpoch);
                    return false;
                }
                return true;
            }
            log.warn("Checksum validation not performed on: " + String.valueOf(this.topicIdPartition) + " as it is not open for write(" + String.valueOf((Object)this.status) + ")");
            return true;
        }

        private boolean flush() throws IOException {
            if (!this.dirty) {
                return false;
            }
            if (this.status.hasError()) {
                this.flushErrorState();
                this.dirty = false;
                return true;
            }
            if (this.status.isOpenForWrite()) {
                this.flushWritableState();
                this.dirty = false;
                return true;
            }
            log.info("Ignored state flush due to status: " + String.valueOf((Object)this.status) + " for " + String.valueOf(this.topicIdPartition));
            return false;
        }

        private void flushWritableState() throws IOException {
            FileTierPartitionState.writeHeader(this.channel, new Header(this.topicIdPartition.topicId(), this.version, this.currentEpoch, this.status, this.startOffset().orElse(-1L), this.endOffset, this.globalMaterializedOffsetAndEpoch, this.localMaterializedOffsetAndEpoch, this.errorOffsetAndEpoch, this.restoreOffsetAndEpoch, this.compactFeatureFlag, this.compactDirtyStartOffset, this.lastCompactStats, this.accumulatedCompactStats, this.includeStateChangeTimestamp, this.tierPartitionStateSnapshotFeatureFlag, this.lastSnapshotTimestampMs, this.lastSnapshotId));
            this.channel.flush();
            FilesWrapper.copy((Path)FileTierPartitionState.mutableFilePath(this.basePath, this.checksumAlgorithm), (Path)FileTierPartitionState.tmpFilePath(this.basePath, this.checksumAlgorithm), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            Utils.atomicMoveWithFallback((Path)FileTierPartitionState.tmpFilePath(this.basePath, this.checksumAlgorithm), (Path)FileTierPartitionState.flushedFilePath(this.basePath, this.checksumAlgorithm));
            this.committedEndOffset = this.endOffset;
            this.lastCommittedSnapshotId = this.lastSnapshotId;
        }

        private void flushErrorState() throws IOException {
            if (this.errorStatusReachedViaFenceEvent) {
                this.flushWritableState();
            } else {
                this.flushHeaderWithErrorStatus(this.status);
                if (this.status != TierPartitionStatus.DISCOVER_ERROR) {
                    FileTierPartitionState.backupMutableFileForDebugging(this.topicIdPartition, this.basePath, FileTierPartitionState.errorFilePath(this.basePath, this.checksumAlgorithm), this.checksumAlgorithm);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushHeaderWithErrorStatus(TierPartitionStatus errorStatus) throws IOException {
            Path flushedFilePathHandle = FileTierPartitionState.flushedFilePath(this.basePath, this.checksumAlgorithm);
            Path tmpFilePathHandle = FileTierPartitionState.tmpFilePath(this.basePath, this.checksumAlgorithm);
            if (!FilesWrapper.exists((Path)flushedFilePathHandle, (LinkOption[])new LinkOption[0])) {
                log.warn("Flushed file absent, creating empty file for {}: {}", (Object)this.topicIdPartition, (Object)flushedFilePathHandle);
                CheckedFileIO.create(flushedFilePathHandle, this.checksumAlgorithm, this.checksumSuperBlockLength);
            }
            FilesWrapper.copy((Path)flushedFilePathHandle, (Path)tmpFilePathHandle, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            try (CheckedFileIO channel = CheckedFileIO.open(tmpFilePathHandle, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                Header newHeader;
                Optional<Header> existingHeaderOpt = FileTierPartitionState.readHeader(channel);
                if (existingHeaderOpt.isPresent()) {
                    Header existingHeader = existingHeaderOpt.get();
                    newHeader = new Header(existingHeader.topicId(), (byte)existingHeader.version(), existingHeader.tierEpoch(), errorStatus, existingHeader.startOffset(), existingHeader.endOffset(), existingHeader.globalMaterializedOffsetAndEpoch(), existingHeader.localMaterializedOffsetAndEpoch(), this.errorOffsetAndEpoch, existingHeader.restoreOffsetAndEpoch(), this.compactFeatureFlag, existingHeader.compactDirtyStartOffset(), existingHeader.lastCompactStats(), existingHeader.accumulatedCompactStats(), this.includeStateChangeTimestamp, this.tierPartitionStateSnapshotFeatureFlag, this.lastSnapshotTimestampMs, this.lastSnapshotId);
                    log.warn("Writing new header to tier partition state for {}: {}", (Object)this.topicIdPartition, (Object)newHeader);
                    channel = FileTierPartitionState.maybeMigrateStateFileFormat(this.topicIdPartition.topicPartition(), this.basePath, this.version, tmpFilePathHandle, channel, existingHeader, this.checksumAlgorithm, this.checksumSuperBlockLength, this.compactFeatureFlag, this.cleanupFeatureFlag, this.tierPartitionStateSnapshotFeatureFlag, this.time);
                } else {
                    newHeader = new Header(this.topicIdPartition.topicId(), this.version, -1, errorStatus, -1L, -1L, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, this.errorOffsetAndEpoch, OffsetAndEpoch.EMPTY, this.compactFeatureFlag, -1L, CompactStats.EMPTY, CompactStats.EMPTY, this.includeStateChangeTimestamp, this.tierPartitionStateSnapshotFeatureFlag, -1L, Header.SNAPSHOT_ID_EMPTY);
                    log.warn("Header not found! Writing new header to tier partition state for {}: {}", (Object)this.topicIdPartition, (Object)newHeader);
                    channel.truncate(0L);
                }
                FileTierPartitionState.writeHeader(channel, newHeader);
                channel.flush();
                Utils.atomicMoveWithFallback((Path)tmpFilePathHandle, (Path)flushedFilePathHandle);
                this.lastCommittedSnapshotId = this.lastSnapshotId;
            }
        }

        public void maybeRemoveStaleRecoveryUploadFile() throws IOException {
            Path recoveryUploadFile = FileTierPartitionState.recoveryUploadFilePath(this.basePath, this.checksumAlgorithm);
            if (FilesWrapper.deleteIfExists((Path)recoveryUploadFile)) {
                log.info("Removed stale recovery upload file for {} at path {}", (Object)this.topicIdPartition, (Object)recoveryUploadFile);
            }
        }

        public void maybeRemoveErrorFile() throws IOException {
            if (this.status == TierPartitionStatus.ERROR) {
                return;
            }
            Path errorFile = FileTierPartitionState.errorFilePath(this.basePath, this.checksumAlgorithm);
            if (FilesWrapper.deleteIfExists((Path)errorFile)) {
                log.info("Removed tier partition state error file for {} at path {}", (Object)this.topicIdPartition, (Object)errorFile);
            }
        }

        private long appendWithSizePrefix(ByteBuffer metadataBuffer) throws IOException {
            return State.appendWithSizePrefixStatic(metadataBuffer, this.channel);
        }

        public static long appendWithSizePrefixStatic(ByteBuffer metadataBuffer, CheckedFileIO channel) throws IOException {
            long messagePosition = channel.position();
            int remaining = metadataBuffer.remaining();
            short sizePrefix = (short)remaining;
            if (sizePrefix != remaining) {
                throw new IllegalStateException(String.format("Unexpected metadataBuffer size: %d", remaining));
            }
            ByteBuffer sizeBuf = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            sizeBuf.putShort(0, sizePrefix);
            channel.write(sizeBuf);
            channel.write(metadataBuffer);
            return messagePosition;
        }

        private static class TierObjectMetadataAndFilePosition {
            final TierObjectMetadata metadata;
            final long filePosition;

            TierObjectMetadataAndFilePosition(TierObjectMetadata metadata, long filePosition) {
                this.metadata = metadata;
                this.filePosition = filePosition;
            }
        }
    }

    static enum StateFileType {
        FLUSHED(""),
        MUTABLE(".mutable"),
        TEMPORARY(".tmp"),
        ERROR(".error"),
        DISCARDED(".discarded"),
        RECOVER(".recover"),
        CLEANUP(".cleanup"),
        SNAPSHOT(".snapshot"),
        DOWNLOAD(".download"),
        MIGRATE(".migrate"),
        RECOVERY_UPLOAD(".recovery-upload");

        final String suffix;

        private StateFileType(String suffix) {
            this.suffix = suffix;
        }

        public Path filePath(String basePath, Algorithm checksumAlgorithm) {
            return CheckedFileIO.validPath(checksumAlgorithm, Paths.get(basePath + this.suffix, new String[0]));
        }
    }

    public static interface MaterializationListener {
        public boolean mayComplete(State var1, Optional<AbstractTierMetadata> var2) throws IOException;

        public boolean complete(State var1) throws IOException;

        public void cancel(Exception var1);

        public static class Initialization
        implements MaterializationListener {
            private final Logger log;
            private final TopicIdPartition topicIdPartition;
            private final CompletableFuture<Boolean> promise;
            private final int leaderEpochToMaterialize;

            public Initialization(Logger log, TopicIdPartition topicIdPartition, CompletableFuture<Boolean> promise, int leaderEpochToMaterialize) {
                this.log = log;
                this.topicIdPartition = topicIdPartition;
                this.promise = promise;
                this.leaderEpochToMaterialize = leaderEpochToMaterialize;
            }

            @Override
            public boolean mayComplete(State unflushedState, Optional<AbstractTierMetadata> unflushedMessage) {
                if (unflushedState.status.isOpen()) {
                    return unflushedState.currentEpoch >= this.leaderEpochToMaterialize;
                }
                return true;
            }

            @Override
            public boolean complete(State flushedState) {
                if (flushedState.status.isOpen()) {
                    if (flushedState.currentEpoch >= this.leaderEpochToMaterialize) {
                        this.promise.complete(true);
                        this.log.info("Successfully completing tracking for metadata initialization of {} for epoch {} ", (Object)this.topicIdPartition, (Object)this.leaderEpochToMaterialize);
                        return true;
                    }
                    return false;
                }
                this.log.error("Tier partition state for " + String.valueOf(this.topicIdPartition) + " not open");
                this.promise.complete(false);
                return true;
            }

            @Override
            public void cancel(Exception e) {
                if (!this.promise.isDone()) {
                    this.log.info("Completing {} exceptionally", (Object)this, (Object)e);
                    this.promise.completeExceptionally(e);
                }
            }

            public String toString() {
                return "MaterializationListener.Initialization{topicIdPartition=" + String.valueOf(this.topicIdPartition) + ", leaderEpochToMaterialize=" + this.leaderEpochToMaterialize + "}";
            }
        }

        public static class ReplicationTargetObjectId
        implements MaterializationListener {
            private final Logger log;
            private final TopicIdPartition topicIdPartition;
            private final CompletableFuture<TierLogSegment> promise;
            private final UUID targetObjectId;
            private final long targetRestoreEpoch;
            private final long upperBoundEndOffset;

            public ReplicationTargetObjectId(Logger log, TopicIdPartition topicIdPartition, CompletableFuture<TierLogSegment> promise, UUID targetObjectId, long targetRestoreEpoch, long upperBoundEndOffset) {
                this.log = log;
                this.topicIdPartition = topicIdPartition;
                this.promise = promise;
                this.targetObjectId = targetObjectId;
                this.targetRestoreEpoch = targetRestoreEpoch;
                this.upperBoundEndOffset = upperBoundEndOffset;
            }

            @Override
            public boolean mayComplete(State unflushedState, Optional<AbstractTierMetadata> unflushedMessage) throws IOException {
                if (!unflushedState.status.isOpen()) {
                    return true;
                }
                if ((long)unflushedState.restoreOffsetAndEpoch.epoch().orElse(-1).intValue() < this.targetRestoreEpoch) {
                    return false;
                }
                boolean foundObjectId = this.findTierObjectMetadata(unflushedState).isPresent();
                return foundObjectId || unflushedState.endOffset > this.upperBoundEndOffset;
            }

            private Optional<SegmentState> findTierObjectMetadata(State state) {
                SegmentState candidate = state.getState(this.targetObjectId);
                if (candidate == null) {
                    return Optional.empty();
                }
                SegmentState validSegment = (SegmentState)state.logSegments.get(candidate.baseOffset());
                if (validSegment == null) {
                    return Optional.empty();
                }
                if (!validSegment.objectId().equals(this.targetObjectId) || !candidate.state().equals((Object)TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE)) {
                    return Optional.empty();
                }
                return Optional.of(candidate);
            }

            @Override
            public boolean complete(State flushedState) throws IOException {
                if (!flushedState.status.isOpen()) {
                    this.promise.completeExceptionally(new TierPartitionStateIllegalListenerException(String.format("Tier partition state for %s is not open.", this.topicIdPartition)));
                    return true;
                }
                if ((long)flushedState.restoreOffsetAndEpoch.epoch().orElse(-1).intValue() < this.targetRestoreEpoch) {
                    return false;
                }
                Optional<SegmentState> tierSegment = this.findTierObjectMetadata(flushedState);
                if (tierSegment.isPresent()) {
                    this.log.info("Completing {} successfully.", (Object)this);
                    this.promise.complete(new TierLogSegment(this.topicIdPartition, tierSegment.get()));
                    return true;
                }
                if (flushedState.endOffset > this.upperBoundEndOffset) {
                    this.promise.completeExceptionally(new TierPartitionStateIllegalListenerException(String.format("Tier partition state for %s the upperBoundEndOffset %d at endOffset %d. This suggests that the materialization target objectId %s at restoreEpoch %d was deleted", this.topicIdPartition, this.upperBoundEndOffset, flushedState.endOffset, CoreUtils.uuidToBase64(this.targetObjectId), this.targetRestoreEpoch)));
                    return true;
                }
                return false;
            }

            @Override
            public void cancel(Exception e) {
                if (!this.promise.isDone()) {
                    this.log.info("Completing {} exceptionally", (Object)this, (Object)e);
                    this.promise.completeExceptionally(e);
                }
            }

            public long materializationProgress(long endOffset) {
                return Math.max(this.upperBoundEndOffset - endOffset, 0L);
            }

            public String toString() {
                return "MaterializationListener.ReplicationTargetObjectId{targetObjectId=" + CoreUtils.uuidToBase64(this.targetObjectId) + ", targetRestoreEpoch=" + this.targetRestoreEpoch + ", upperBoundEndOffset=" + this.upperBoundEndOffset + ", topicIdPartition=" + String.valueOf(this.topicIdPartition) + "}";
            }
        }

        public static class ReplicationTargetOffset
        implements MaterializationListener {
            private final Logger log;
            private final TopicIdPartition topicIdPartition;
            private final CompletableFuture<TierLogSegment> promise;
            private final long targetEndOffset;

            public ReplicationTargetOffset(Logger log, TopicIdPartition topicIdPartition, CompletableFuture<TierLogSegment> promise, long targetEndOffset) {
                this.log = log;
                this.topicIdPartition = topicIdPartition;
                this.promise = promise;
                this.targetEndOffset = targetEndOffset;
            }

            @Override
            public boolean mayComplete(State unflushedState, Optional<AbstractTierMetadata> unflushedMessage) throws IOException {
                if (unflushedState.status.isOpen()) {
                    long uncommitedEndOffset = unflushedState.endOffset;
                    return uncommitedEndOffset >= this.targetEndOffset;
                }
                return true;
            }

            @Override
            public boolean complete(State flushedState) throws IOException {
                if (flushedState.status.isOpen()) {
                    Optional<Object> metadata = Optional.empty();
                    long endOffset = flushedState.endOffset;
                    if (endOffset != -1L && this.targetEndOffset <= endOffset) {
                        metadata = flushedState.metadata(this.targetEndOffset);
                    }
                    if (metadata.isPresent()) {
                        if (((SegmentState)metadata.get()).endOffset() < this.targetEndOffset) {
                            throw new IllegalStateException("Metadata lookup for offset " + this.targetEndOffset + " returned unexpected segment " + String.valueOf(metadata) + " for " + String.valueOf(this.topicIdPartition));
                        }
                        this.promise.complete(new TierLogSegment(this.topicIdPartition, (SegmentState)metadata.get()));
                        return true;
                    }
                    return false;
                }
                this.promise.completeExceptionally(new TierPartitionStateIllegalListenerException("Tier partition state for " + String.valueOf(this.topicIdPartition) + " is not open."));
                return true;
            }

            @Override
            public void cancel(Exception e) {
                if (!this.promise.isDone()) {
                    this.log.info("Completing {} exceptionally", (Object)this, (Object)e);
                    this.promise.completeExceptionally(e);
                }
            }

            public long materializationProgress(long endOffset) {
                return Math.max(this.targetEndOffset - endOffset, 0L);
            }

            public String toString() {
                return "MaterializationListener.ReplicationTargetOffset{targetOffset=" + this.targetEndOffset + ", topicIdPartition=" + String.valueOf(this.topicIdPartition) + "}";
            }
        }

        public static class LeaderEpoch
        implements MaterializationListener {
            private final Logger log;
            private final TopicIdPartition topicIdPartition;
            private final CompletableFuture<Optional<TierLogSegment>> promise;
            private final int leaderEpochToMaterialize;

            public LeaderEpoch(Logger log, TopicIdPartition topicIdPartition, CompletableFuture<Optional<TierLogSegment>> promise, int leaderEpochToMaterialize) {
                this.log = log;
                this.topicIdPartition = topicIdPartition;
                this.promise = promise;
                this.leaderEpochToMaterialize = leaderEpochToMaterialize;
            }

            @Override
            public boolean mayComplete(State unflushedState, Optional<AbstractTierMetadata> ignored) {
                if (unflushedState.status.isOpen()) {
                    return unflushedState.currentEpoch >= this.leaderEpochToMaterialize;
                }
                return true;
            }

            @Override
            public boolean complete(State flushedState) throws IOException {
                if (this.promise.isDone()) {
                    throw new IllegalStateException("promise can only be completed once");
                }
                if (flushedState.status.isOpen()) {
                    if (flushedState.currentEpoch >= this.leaderEpochToMaterialize) {
                        Optional<TierLogSegment> lastSegmentOpt = Optional.ofNullable(flushedState.logSegments.lastEntry()).map(kv -> new TierLogSegment(this.topicIdPartition, (SegmentState)kv.getValue()));
                        this.log.info("Completing {} successfully.", (Object)this);
                        this.promise.complete(lastSegmentOpt);
                        return true;
                    }
                    return false;
                }
                this.promise.completeExceptionally(new TierPartitionStateIllegalListenerException("Tier partition state for " + String.valueOf(this.topicIdPartition) + " is not open."));
                return true;
            }

            @Override
            public void cancel(Exception e) {
                if (!this.promise.isDone()) {
                    this.log.info("Completing {} exceptionally", (Object)this, (Object)e);
                    this.promise.completeExceptionally(e);
                }
            }

            public String toString() {
                return "MaterializationListener.LeaderEpoch(topicIdPartition: " + String.valueOf(this.topicIdPartition) + ", leaderEpochToMaterialize: " + this.leaderEpochToMaterialize + ")";
            }
        }
    }
}

