/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import io.confluent.kafka.storage.checksum.ChecksumProtectionForTopicChecker;
import io.confluent.kafka.storage.checksum.ChecksumStoreFile;
import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumStoreConfig;
import io.confluent.kafka.storage.tier.TierBackend;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.AzureBlockBlobTierObjectStore;
import kafka.tier.store.AzureBlockBlobTierObjectStoreConfig;
import kafka.tier.store.GcsTierObjectStore;
import kafka.tier.store.GcsTierObjectStoreConfig;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.S3TierObjectStore;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreMetricsEnabled;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.ThrottledSegmentUpload;
import kafka.tier.store.objects.TierSegmentUpload;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.tools.TierObjectStoreFactory;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.config.Defaults;
import org.apache.kafka.storage.internals.log.LogConfig;

public class TierObjectStoreUtils {
    public static final List<String> OBJECT_STORE_REQUIRED_PROPERTIES = Arrays.asList(KafkaConfig.TierMetadataNamespaceProp(), KafkaConfig.TierBackendProp(), KafkaConfig.TierS3RegionProp(), KafkaConfig.TierS3BucketProp(), KafkaConfig.TierS3PrefixProp(), KafkaConfig.TierS3AssumeRoleArnProp(), KafkaConfig.TierS3CredFilePathProp(), KafkaConfig.TierGcsRegionProp(), KafkaConfig.TierGcsBucketProp(), KafkaConfig.TierGcsPrefixProp(), KafkaConfig.TierGcsCredFilePathProp(), KafkaConfig.TierGcsWriteChunkSizeProp(), KafkaConfig.TierAzureBlockBlobContainerProp(), KafkaConfig.TierAzureBlockBlobCredFilePathProp(), KafkaConfig.TierAzureBlockBlobEndpointProp(), KafkaConfig.TierAzureBlockBlobPrefixProp(), KafkaConfig.TierAzureBlockBlobAutoAbortThresholdBytesProp());

    public static Optional<TierObjectStore> maybeCreateTierObjectStore(KafkaConfig config, String clusterId, Metrics metrics, Time time, Optional<E2EChecksumStore> checksumStoreOpt) {
        if (!config.confluentConfig().tierFeature().booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(switch (config.confluentConfig().tierBackend()) {
            case "S3" -> new TierObjectStoreMetricsEnabled(new S3TierObjectStore(new S3TierObjectStoreConfig(Optional.of(clusterId), config), checksumStoreOpt, time, metrics), metrics, time);
            case "GCS" -> new TierObjectStoreMetricsEnabled(new GcsTierObjectStore(time, metrics, new GcsTierObjectStoreConfig(Optional.of(clusterId), config), checksumStoreOpt), metrics, time);
            case "AzureBlockBlob" -> new TierObjectStoreMetricsEnabled(new AzureBlockBlobTierObjectStore(new AzureBlockBlobTierObjectStoreConfig(Optional.of(clusterId), config), time, metrics), metrics, time);
            case "mock" -> new MockInMemoryTierObjectStore(time, metrics, new MockInMemoryTierObjectStoreConfig(Optional.of(clusterId), config));
            default -> throw new ConfigException("Unknown TierObjectStore type");
        });
    }

    public static TierObjectStoreConfig generateBackendConfig(TierObjectStore.Backend backend, Properties props) {
        switch (backend) {
            case S3: {
                List<String> mandatoryProps = List.of(KafkaConfig.TierS3BucketProp(), KafkaConfig.TierS3RegionProp());
                TierObjectStoreUtils.verifyMandatoryProps(backend, props, mandatoryProps);
                String s3Bucket = props.getProperty(KafkaConfig.TierS3BucketProp());
                String s3Region = props.getProperty(KafkaConfig.TierS3RegionProp());
                return S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId(s3Bucket, s3Region, props.getProperty(KafkaConfig.TierS3CredFilePathProp()), props.getProperty(KafkaConfig.TierS3EndpointOverrideProp()), props.getProperty(KafkaConfig.TierS3SignerOverrideProp()), props.getProperty(KafkaConfig.TierS3SseAlgorithmProp(), "AES256"), props.getProperty(KafkaConfig.TierS3SseCustomerEncryptionKeyProp(), Defaults.TIER_S3_SSE_CUSTOMER_ENCRYPTION_KEY), Integer.parseInt(props.getOrDefault((Object)KafkaConfig.TierS3AutoAbortThresholdBytesProp(), (Object)500000).toString()), props.getProperty(KafkaConfig.TierS3PrefixProp(), ""), props.getProperty(KafkaConfig.TierS3AssumeRoleArnProp(), Defaults.TIER_S3_ASSUME_ROLE_ARN), Boolean.valueOf(props.getProperty(KafkaConfig.TierS3ForcePathStyleAccessProp(), Boolean.toString(false))), props.getProperty(KafkaConfig.TierS3UserAgentPrefix(), "APN/1.0 Confluent/1.0 TieredStorageS3/1.0"), props.getProperty(KafkaConfig.TierS3SslProtocolProp(), "TLSv1.3"), props.getProperty(KafkaConfig.TierS3SslEnabledProtocolsProp(), "TLSv1.2,TLSv1.3"), props.getProperty(KafkaConfig.TierS3SslTrustStoreLocationProp()), (Password)props.get(KafkaConfig.TierS3SslTrustStorePasswordProp()), props.getProperty(KafkaConfig.TierS3SslTrustStoreTypeProp()), props.getProperty(KafkaConfig.TierS3SslKeyStoreLocationProp()), (Password)props.get(KafkaConfig.TierS3SslKeyStorePasswordProp()), props.getProperty(KafkaConfig.TierS3SslKeyStoreTypeProp()), (Password)props.get(KafkaConfig.TierS3SslKeyPasswordProp()), props.getProperty(KafkaConfig.TierS3SslProviderProp()), props.getProperty(KafkaConfig.TierS3SecurityProvidersProp()), props.getProperty(KafkaConfig.TierS3StorageClassOverrideProp()), Boolean.valueOf(props.getProperty(KafkaConfig.TierS3Ipv6EnabledProp(), Boolean.toString(true))), Boolean.valueOf(props.getProperty(KafkaConfig.TenantAwareEncryptionKeyManagerEnableProp(), Boolean.toString(false))), (Duration)props.get(KafkaConfig.TenantAwareEncryptionKeyManagerKeyRotationIntervalMsProp()), Integer.parseInt(props.getProperty(KafkaConfig.TenantAwareEncryptionKeyManagerMaxTenantKeyCacheSizeProp(), Integer.toString(100))), Long.parseLong(props.getProperty(KafkaConfig.TenantAwareEncryptionKeyManagerTenantKeyCacheEvictionTimeSecProp(), Long.toString(Defaults.TENANT_AWARE_ENCRYPTION_KEY_MANAGER_TENANT_KEY_CACHE_EVICTION_TIME_SEC))));
            }
            case GCS: {
                List<String> mandatoryProps = List.of(KafkaConfig.TierGcsBucketProp(), KafkaConfig.TierGcsRegionProp());
                TierObjectStoreUtils.verifyMandatoryProps(backend, props, mandatoryProps);
                String gcsBucket = props.getProperty(KafkaConfig.TierGcsBucketProp());
                String gcsRegion = props.getProperty(KafkaConfig.TierGcsRegionProp());
                String gcsPrefix = props.getProperty(KafkaConfig.TierGcsPrefixProp(), "");
                return GcsTierObjectStoreConfig.createWithEmptyClusterIdBrokerId(gcsBucket, gcsPrefix, gcsRegion, Integer.parseInt(props.getOrDefault((Object)KafkaConfig.TierGcsWriteChunkSizeProp(), (Object)0).toString()), props.getProperty(KafkaConfig.TierGcsCredFilePathProp()), props.getProperty(KafkaConfig.TierGcsSseCustomerEncryptionKeyProp()), Duration.ofSeconds(30L));
            }
            case AzureBlockBlob: {
                List<String> mandatoryProps = List.of(KafkaConfig.TierAzureBlockBlobContainerProp());
                TierObjectStoreUtils.verifyMandatoryProps(backend, props, mandatoryProps);
                return AzureBlockBlobTierObjectStoreConfig.createWithEmptyClusterIdBrokerId(Optional.ofNullable(props.getProperty(KafkaConfig.TierAzureBlockBlobCredFilePathProp())), Optional.ofNullable(props.getProperty(KafkaConfig.TierAzureBlockBlobEndpointProp())), props.getProperty(KafkaConfig.TierAzureBlockBlobContainerProp()), props.getProperty(KafkaConfig.TierAzureBlockBlobPrefixProp(), ""), Integer.parseInt(props.getProperty(KafkaConfig.TierAzureBlockBlobAutoAbortThresholdBytesProp(), String.valueOf(500000))), Boolean.valueOf(props.getProperty(KafkaConfig.TenantAwareEncryptionKeyManagerEnableProp(), Boolean.toString(false))), (Duration)props.get(KafkaConfig.TenantAwareEncryptionKeyManagerKeyRotationIntervalMsProp()), Integer.parseInt(props.getProperty(KafkaConfig.TenantAwareEncryptionKeyManagerMaxTenantKeyCacheSizeProp(), Integer.toString(100))), Long.parseLong(props.getProperty(KafkaConfig.TenantAwareEncryptionKeyManagerTenantKeyCacheEvictionTimeSecProp(), Long.toString(Defaults.TENANT_AWARE_ENCRYPTION_KEY_MANAGER_TENANT_KEY_CACHE_EVICTION_TIME_SEC))));
            }
            case Mock: {
                String mockTierObjectStorePrefix = props.getProperty(KafkaConfig.TierS3PrefixProp(), "");
                return new MockInMemoryTierObjectStoreConfig(mockTierObjectStorePrefix);
            }
        }
        throw new UnsupportedOperationException("Unsupported backend for config generation: " + String.valueOf((Object)backend));
    }

    public static TierObjectStore objectStore(String objectStoreConfigFile) throws IOException {
        Properties props;
        try {
            props = Utils.loadProps((String)objectStoreConfigFile, OBJECT_STORE_REQUIRED_PROPERTIES);
        }
        catch (IOException e) {
            System.err.println("Exception while loading object store properties from file: " + objectStoreConfigFile);
            throw e;
        }
        return TierObjectStoreUtils.getObjectStore(props);
    }

    public static TierObjectStore getObjectStore(Properties props) {
        TierObjectStore.Backend backend = TierObjectStore.Backend.valueOf(props.getProperty(KafkaConfig.TierBackendProp()));
        TierObjectStoreConfig config = TierObjectStoreUtils.generateBackendConfig(backend, props);
        return TierObjectStoreFactory.getObjectStoreInstance(Time.SYSTEM, backend, config);
    }

    public static ByteBuffer timeHealthPayload() {
        return ByteBuffer.wrap(Long.toString(System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8));
    }

    private static void verifyMandatoryProps(TierObjectStore.Backend backend, Properties props, List<String> mandatoryProps) {
        List absentProps = mandatoryProps.stream().filter(key -> !props.containsKey(key)).collect(Collectors.toList());
        if (absentProps.size() > 0) {
            throw new IllegalArgumentException("Missing mandatory props for backend: " + String.valueOf((Object)backend) + ": " + String.valueOf(absentProps) + " mandatoryProps: " + String.valueOf(mandatoryProps));
        }
    }

    public static void postPutSegmentCleanup(E2EChecksumStore checksumStore, File segmentData, File offsetIndexData, File timestampIndexData) {
        TierObjectStoreUtils.postPutSegmentCleanup(checksumStore, segmentData, offsetIndexData, timestampIndexData, Optional.empty());
    }

    public static void postPutSegmentCleanup(E2EChecksumStore checksumStore, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotOpt) {
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.SEGMENT)) {
            checksumStore.store().remove(segmentData.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.OFFSET_INDEX)) {
            checksumStore.store().remove(offsetIndexData.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.TIMESTAMP_INDEX)) {
            checksumStore.store().remove(timestampIndexData.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.PRODUCER_STATE)) {
            producerStateSnapshotOpt.ifPresent(file -> checksumStore.store().remove(file.getAbsolutePath()));
        }
    }

    public static Optional<E2EChecksumStore> createChecksumStore(KafkaConfig config, Time time, Metrics metrics, TierPartitionStateFactory tierPartitionStateFactory) throws IOException {
        return TierObjectStoreUtils.createChecksumStore(config, time, metrics, tierPartitionStateFactory::mayEnableTiering);
    }

    public static Optional<E2EChecksumStore> createChecksumStore(KafkaConfig config, Time time, Metrics metrics) throws IOException {
        return TierObjectStoreUtils.createChecksumStore(config, time, metrics, (TopicPartition partition, LogConfig logConfig) -> false);
    }

    public static Optional<E2EChecksumStore> createChecksumStore(KafkaConfig config, Time time, Metrics metrics, ChecksumProtectionForTopicChecker checksumProtectionForTopicChecker) throws IOException {
        if ("AzureBlockBlob".equals(config.confluentConfig().tierBackend())) {
            return Optional.empty();
        }
        ChecksumStoreFile readerWriter = new ChecksumStoreFile((String)config.logDirs().headOption().get(), "checksum.store");
        if (!config.confluentConfig().e2eChecksumProtectionEnabled().booleanValue()) {
            readerWriter.deleteIfExists();
            return Optional.empty();
        }
        if (config.confluentConfig().e2eChecksumProtectionEnabled().booleanValue() && config.confluentConfig().tierFeature().booleanValue()) {
            E2EChecksumStore checksumStore = new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.toEnum(config.confluentConfig().tierBackend()), config.confluentConfig().e2eChecksumProtectionEnabledFiles(), config.confluentConfig().e2ChecksumProtectionStoreEntryTTLMs()), time, readerWriter, metrics, true, checksumProtectionForTopicChecker);
            return Optional.of(checksumStore);
        }
        return Optional.empty();
    }

    protected static String keyPath(String prefix, ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        if (objectType.equals((Object)ObjectType.SEGMENT_WITH_METADATA)) {
            Optional<FragmentLocation> segmentLocation = objectMetadata.toFragmentLocation(prefix, FragmentType.SEGMENT);
            if (!segmentLocation.isPresent() || !segmentLocation.get().objectPath().endsWith(ObjectType.SEGMENT_WITH_METADATA.suffix())) {
                throw new IllegalArgumentException("mismatched key path request for SEGMENT_WITH_METADATA ObjectType on ObjectStoreMetadata: " + String.valueOf(objectMetadata));
            }
            return segmentLocation.get().objectPath();
        }
        Optional locationOpt = objectType.getDesignatedFragmentType().flatMap(fragmentType -> objectMetadata.toFragmentLocation(prefix, (FragmentType)((Object)fragmentType)));
        if (!locationOpt.isPresent()) {
            throw new IllegalArgumentException("cannot get FragmentLocation of " + String.valueOf(objectMetadata) + " with ObjectType=" + objectType.name());
        }
        return ((FragmentLocation)locationOpt.get()).objectPath();
    }

    protected static Optional<File> getCurrentPutObjectFile(TierSegmentUpload<?> tierSegmentUpload, E2EChecksumProtectedObjectType currentPutObjectType) {
        if (currentPutObjectType == null) {
            return Optional.empty();
        }
        switch (currentPutObjectType) {
            case SEGMENT: {
                return Optional.of(tierSegmentUpload.segment());
            }
            case OFFSET_INDEX: {
                return Optional.of(tierSegmentUpload.offsetIdx());
            }
            case TIMESTAMP_INDEX: {
                return Optional.of(tierSegmentUpload.timestampIdx());
            }
            case PRODUCER_STATE: {
                if (tierSegmentUpload instanceof ThrottledSegmentUpload) {
                    return ((ThrottledSegmentUpload)tierSegmentUpload).producerStateSnapshotOpt();
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

