/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import io.confluent.kafka.multitenant.ByokMetadata;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.tier.S3TierObjectStoreUtils;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.tier.store.encryption.CleartextDataKey;
import kafka.tier.store.encryption.DataEncryptionKeyHolder;
import kafka.tier.store.encryption.EncryptedDataKey;
import kafka.tier.store.encryption.TenantAwareEncryptionKeyManager;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.util.KafkaScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.DependencyTimeoutException;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.KeyUnavailableException;
import software.amazon.awssdk.services.kms.model.KmsInternalException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public class AwsTenantAwareEncryptionManager<S3Client>
extends TenantAwareEncryptionKeyManager {
    private static final Logger log = LoggerFactory.getLogger(AwsTenantAwareEncryptionManager.class);
    private final S3Client s3Client;
    private final S3TierObjectStoreConfig config;
    private final AwsKmsClientSupplier kmsClientSupplier;

    public AwsTenantAwareEncryptionManager(S3Client s3Client, S3TierObjectStoreConfig config, KafkaScheduler kafkaScheduler, MultiTenantMetadata multiTenantMetadata, Time time, Metrics metrics) {
        this(s3Client, new DefaultAwsKmsClientSupplier(), config, kafkaScheduler, multiTenantMetadata, time, metrics);
    }

    public AwsTenantAwareEncryptionManager(S3Client s3Client, AwsKmsClientSupplier kmsClientSupplier, S3TierObjectStoreConfig config, KafkaScheduler kafkaScheduler, MultiTenantMetadata multiTenantMetadata, Time time, Metrics metrics) {
        super(multiTenantMetadata, config.tenantAwareEncryptionKeyManagerKeyRotationIntervalMs, config.tenantAwareEncryptionKeyManagerMaxTenantKeyCacheSize, config.tenantAwareEncryptionKeyManagerTenantKeyCacheEvictionTimeSec, time, metrics, kafkaScheduler);
        if (!this.isSupportedS3Client(s3Client)) {
            throw new TierObjectStoreFatalException(String.format("Expected either an instance of AmazonS3 client or S3AsyncClient to be supplied, but received %s.", s3Client.getClass()));
        }
        this.s3Client = s3Client;
        this.kmsClientSupplier = kmsClientSupplier;
        this.config = config;
    }

    private boolean isSupportedS3Client(S3Client s3Client) {
        return s3Client instanceof AmazonS3 || s3Client instanceof S3AsyncClient;
    }

    public S3TierObjectStoreConfig getConfig() {
        return this.config;
    }

    @Override
    protected String getDataEncryptionKeyAlgorithm() {
        return "AES";
    }

    @Override
    protected int getDataEncryptionKeySizeBytes() {
        return 256;
    }

    @Override
    public String getKeyManagementClientEncryptionAlgorithm() {
        return "AES256";
    }

    @Override
    public void close() {
        super.close();
        try {
            this.kmsClientSupplier.close();
        }
        catch (IOException e) {
            log.error("Received IOException while closing HTTP Client during shutdown of KmsClientSupplier.", (Throwable)e);
        }
    }

    private static String makeUnknownExceptionMessageForV2HeadRequest(String logicalClusterId, String path) {
        return String.format("[%s] Unknown exception when fetching well known path metadata from %s", logicalClusterId, path);
    }

    private Map<String, String> sendV1GetRequest(String logicalClusterId, String path) {
        Map<String, String> map;
        block13: {
            GetObjectRequest s3GetRequest = new GetObjectRequest(this.config.s3Bucket, path);
            S3Object s3Object = ((AmazonS3)this.s3Client).getObject(s3GetRequest);
            try {
                map = s3Object.getObjectMetadata().getUserMetadata();
                if (s3Object == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (s3Object != null) {
                        try {
                            s3Object.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                        if (cause instanceof AmazonS3Exception && "NoSuchKey".equals(((AmazonS3Exception)cause).getErrorCode())) {
                            log.info("[{}] Previously generated key not found at path {}", (Object)logicalClusterId, (Object)path);
                            return new HashMap<String, String>();
                        }
                        if (cause == cause.getCause()) break;
                    }
                    if (e instanceof AmazonClientException) {
                        if (this.metrics != null) {
                            this.metrics.recordFetchKeyRetriableError();
                        }
                        throw new TierObjectStoreRetriableException(String.format("[%s] Failed to fetch well known path metadata from %s", logicalClusterId, path), e);
                    }
                    if (this.metrics != null) {
                        this.metrics.recordFetchKeyFatalError();
                    }
                    throw new TierObjectStoreFatalException(AwsTenantAwareEncryptionManager.makeUnknownExceptionMessageForV2HeadRequest(logicalClusterId, path), e);
                }
            }
            s3Object.close();
        }
        return map;
    }

    private Map<String, String> sendV2HeadRequest(String logicalClusterId, String path) {
        CompletableFuture future = new CompletableFuture();
        HeadObjectRequest.Builder requestBuilder = HeadObjectRequest.builder().bucket(this.config.s3Bucket).key(path);
        ((S3AsyncClient)this.s3Client).headObject((HeadObjectRequest)requestBuilder.build()).handle((response, e) -> {
            if (e == null) {
                future.complete(response);
            } else if (e instanceof NoSuchKeyException) {
                future.completeExceptionally((Throwable)e);
            } else if (e instanceof RetryableException) {
                if (this.metrics != null) {
                    this.metrics.recordFetchKeyRetriableError();
                }
                future.completeExceptionally((Throwable)((Object)new TierObjectStoreRetriableException(String.format("[%s] Failed to fetch well known path metadata from %s", logicalClusterId, path), (Throwable)e)));
            } else {
                if (this.metrics != null) {
                    this.metrics.recordFetchKeyFatalError();
                }
                future.completeExceptionally(new TierObjectStoreFatalException(AwsTenantAwareEncryptionManager.makeUnknownExceptionMessageForV2HeadRequest(logicalClusterId, path), (Throwable)e));
            }
            return null;
        });
        try {
            HeadObjectResponse response2 = (HeadObjectResponse)future.get();
            return response2.metadata();
        }
        catch (InterruptedException | CancellationException e2) {
            throw new TierObjectStoreFatalException(AwsTenantAwareEncryptionManager.makeUnknownExceptionMessageForV2HeadRequest(logicalClusterId, path), e2.getCause() == null ? e2 : e2.getCause());
        }
        catch (ExecutionException e3) {
            if (e3.getCause() instanceof NoSuchKeyException) {
                log.info("[{}] Previously generated key not found at path {}", (Object)logicalClusterId, (Object)path);
                return new HashMap<String, String>();
            }
            S3TierObjectStoreUtils.handleAwsSdkV2Exception(AwsTenantAwareEncryptionManager.makeUnknownExceptionMessageForV2HeadRequest(logicalClusterId, path), e3);
            return null;
        }
    }

    @Override
    protected Map<String, String> fetchWellKnownPathMetadata(String logicalClusterId) {
        String path = AwsTenantAwareEncryptionManager.getLastActiveKeyPath(this.config.s3Prefix, logicalClusterId);
        log.info("[{}] Downloading previously generated key from path {}", (Object)logicalClusterId, (Object)path);
        if (this.s3Client instanceof AmazonS3) {
            return this.sendV1GetRequest(logicalClusterId, path);
        }
        return this.sendV2HeadRequest(logicalClusterId, path);
    }

    private void setSseAlgorithmV1(ObjectMetadata metadata) {
        if (this.config.s3SseAlgorithm != null) {
            metadata.setSSEAlgorithm(this.config.s3SseAlgorithm);
        }
    }

    private void setKmsParamsV1(PutObjectRequest request) {
        if (this.config.usesKms()) {
            request.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(this.config.s3SseCustomerEncryptionKey));
        }
    }

    private void setSseAlgorithmAndKmsParamsV2(PutObjectRequest.Builder requestBuilder) {
        if (this.config.usesKms()) {
            requestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS).ssekmsKeyId(this.config.s3SseCustomerEncryptionKey);
        }
        if (this.config.s3SseAlgorithm != null) {
            requestBuilder.serverSideEncryption(this.config.s3SseAlgorithm);
        }
    }

    private static String makeExceptionMessageForPutResponse(String logicalClusterId, String path) {
        return String.format("[%s] Unknown exception when writing metadata to well known path at %s", logicalClusterId, path);
    }

    private void sendV1PutRequest(String logicalClusterId, String path, Map<String, String> metadata) {
        ObjectMetadata s3Metadata = new ObjectMetadata();
        this.setSseAlgorithmV1(s3Metadata);
        s3Metadata.setUserMetadata(metadata);
        PutObjectRequest s3PutRequest = new PutObjectRequest(this.config.s3Bucket, path, (InputStream)new ByteBufferInputStream(ByteBuffer.wrap(new byte[0])), s3Metadata);
        this.setKmsParamsV1(s3PutRequest);
        try {
            ((AmazonS3)this.s3Client).putObject(s3PutRequest);
        }
        catch (Exception e) {
            if (e instanceof AmazonClientException) {
                if (this.metrics != null) {
                    this.metrics.recordWriteKeyRetriableError();
                }
                throw new TierObjectStoreRetriableException(String.format("[%s] Failed to write metadata to well known path at %s", logicalClusterId, path), e);
            }
            if (this.metrics != null) {
                this.metrics.recordWriteKeyFatalError();
            }
            throw new TierObjectStoreFatalException(AwsTenantAwareEncryptionManager.makeExceptionMessageForPutResponse(logicalClusterId, path), e);
        }
    }

    private void sendV2PutRequest(String logicalClusterId, String path, Map<String, String> metadata) {
        CompletableFuture future = new CompletableFuture();
        PutObjectRequest.Builder putRequestBuilder = software.amazon.awssdk.services.s3.model.PutObjectRequest.builder().bucket(this.config.s3Bucket).key(path).metadata(metadata);
        this.setSseAlgorithmAndKmsParamsV2(putRequestBuilder);
        ((S3AsyncClient)this.s3Client).putObject((software.amazon.awssdk.services.s3.model.PutObjectRequest)putRequestBuilder.build(), AsyncRequestBody.fromByteBuffer(ByteBuffer.wrap(new byte[0]))).handle((response, e) -> {
            if (e == null) {
                future.complete(response);
            } else if (e instanceof RetryableException) {
                if (this.metrics != null) {
                    this.metrics.recordWriteKeyRetriableError();
                }
                future.completeExceptionally((Throwable)((Object)new TierObjectStoreRetriableException(String.format("[%s] Failed to write well known path metadata at %s", logicalClusterId, path), (Throwable)e)));
            } else {
                if (this.metrics != null) {
                    this.metrics.recordWriteKeyFatalError();
                }
                future.completeExceptionally(new TierObjectStoreFatalException(AwsTenantAwareEncryptionManager.makeExceptionMessageForPutResponse(logicalClusterId, path), (Throwable)e));
            }
            return null;
        });
        try {
            future.get();
        }
        catch (InterruptedException | CancellationException e2) {
            throw new TierObjectStoreFatalException(AwsTenantAwareEncryptionManager.makeExceptionMessageForPutResponse(logicalClusterId, path), e2.getCause() == null ? e2 : e2.getCause());
        }
        catch (ExecutionException e3) {
            S3TierObjectStoreUtils.handleAwsSdkV2Exception(AwsTenantAwareEncryptionManager.makeExceptionMessageForPutResponse(logicalClusterId, path), e3);
        }
    }

    @Override
    protected void writeWellKnownPathMetadata(String logicalClusterId, Map<String, String> metadata) {
        String path = AwsTenantAwareEncryptionManager.getLastActiveKeyPath(this.config.s3Prefix, logicalClusterId);
        log.info("[{}] Uploading metadata for newly generated key to path {}", (Object)logicalClusterId, (Object)path);
        if (this.s3Client instanceof AmazonS3) {
            this.sendV1PutRequest(logicalClusterId, path, metadata);
        } else {
            this.sendV2PutRequest(logicalClusterId, path, metadata);
        }
    }

    private static boolean isRetryableKmsException(Exception e) {
        return e instanceof KeyUnavailableException || e instanceof DependencyTimeoutException || e instanceof KmsInternalException || e instanceof RetryableException;
    }

    @Override
    protected CleartextDataKey decryptKey(String logicalClusterId, EncryptedDataKey encryptedDataKey, ByokMetadata byokMetadata) {
        DecryptResponse decryptResponse;
        String keyArn = byokMetadata.keyArn();
        String roleArn = byokMetadata.roleArn();
        SdkBytes encryptedDataKeySdkBytes = SdkBytes.fromByteArray(encryptedDataKey.keyMaterial());
        DecryptRequest decryptRequest = (DecryptRequest)DecryptRequest.builder().keyId(keyArn).ciphertextBlob(encryptedDataKeySdkBytes).build();
        try (KmsClient kmsClient = this.kmsClientSupplier.get(logicalClusterId, roleArn, this.config.s3Region);){
            long decryptStart = this.time.hiResClockMs();
            decryptResponse = kmsClient.decrypt(decryptRequest);
            if (this.metrics != null) {
                this.metrics.recordDecryptCall(this.time.hiResClockMs() - decryptStart);
            }
        }
        catch (Exception e) {
            if (AwsTenantAwareEncryptionManager.isRetryableKmsException(e)) {
                if (this.metrics != null) {
                    this.metrics.recordDecryptRetriableError();
                }
                throw new TierObjectStoreRetriableException(String.format("[%s] Failed to decrypt key due to a retryable failure in decrypt call to AWS KMS.", logicalClusterId), e);
            }
            if (this.metrics != null) {
                this.metrics.recordDecryptFatalError();
            }
            throw new TierObjectStoreFatalException(String.format("[%s] Failed to decrypt key due to a non-retryable failure in decrypt call to AWS KMS.", logicalClusterId), e);
        }
        byte[] decryptedKeyBytes = decryptResponse.plaintext().asByteArray();
        return new CleartextDataKey(decryptedKeyBytes);
    }

    @Override
    protected DataEncryptionKeyHolder encryptKey(String logicalClusterId, CleartextDataKey dataKey, ByokMetadata byokMetadata) {
        EncryptResponse encryptResponse;
        String keyArn = byokMetadata.keyArn();
        String roleArn = byokMetadata.roleArn();
        EncryptRequest encryptRequest = (EncryptRequest)EncryptRequest.builder().keyId(keyArn).plaintext(SdkBytes.fromByteArray(dataKey.rawKeyMaterial())).build();
        try (KmsClient kmsClient = this.kmsClientSupplier.get(logicalClusterId, roleArn, this.config.s3Region);){
            long encryptStart = this.time.hiResClockMs();
            encryptResponse = kmsClient.encrypt(encryptRequest);
            if (this.metrics != null) {
                this.metrics.recordEncryptCall(this.time.hiResClockMs() - encryptStart);
            }
        }
        catch (Exception e) {
            if (AwsTenantAwareEncryptionManager.isRetryableKmsException(e)) {
                if (this.metrics != null) {
                    this.metrics.recordEncryptRetriableError();
                }
                throw new TierObjectStoreRetriableException(String.format("[%s] Failed to generate encrypted key due to a retryable failure in encrypt call to AWS KMS.", logicalClusterId), e);
            }
            if (this.metrics != null) {
                this.metrics.recordEncryptFatalError();
            }
            throw new TierObjectStoreFatalException(String.format("[%s] Failed to generate encrypted key due to a non-retryable failure in encrypt call to AWS KMS.", logicalClusterId), e);
        }
        SdkBytes encryptedKey = encryptResponse.ciphertextBlob();
        return new DataEncryptionKeyHolder(new EncryptedDataKey(encryptedKey.asByteArray()), dataKey, Optional.of(Instant.ofEpochMilli(this.getTime().milliseconds())));
    }

    public static class DefaultAwsKmsClientSupplier
    implements AwsKmsClientSupplier {
        private final SdkHttpClient httpClient = ApacheHttpClient.builder().maxConnections(10).build();

        @Override
        public KmsClient get(String logicalClusterId, String roleArn, String s3Region) {
            SdkAutoCloseable provider = DefaultCredentialsProvider.builder().build();
            StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().httpClient(this.httpClient)).credentialsProvider((AwsCredentialsProvider)((Object)provider))).build();
            provider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(String.format("%s-%s", logicalClusterId, UUID.randomUUID())).build()).build();
            return (KmsClient)((KmsClientBuilder)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().httpClient(this.httpClient)).region(Region.of(s3Region))).credentialsProvider((AwsCredentialsProvider)((Object)provider))).build();
        }

        @Override
        public void close() {
            this.httpClient.close();
        }
    }

    public static interface AwsKmsClientSupplier
    extends Closeable {
        public KmsClient get(String var1, String var2, String var3);
    }
}

