/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kafka.log.MergedLog;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;

public class TierStateRestoreSnapshotMetadata
implements ObjectStoreMetadata {
    public static final int VERSION_V0 = 0;
    public static final int VERSION_V1 = 1;
    private static final int CURRENT_KEY_PATH_VERSION = 1;
    private final TopicIdPartition topicIdPartition;
    private final long startOffset;
    private final long endOffset;
    private final String contentHash;
    private final Algorithm checksumAlgorithm;
    private final int version;

    public TierStateRestoreSnapshotMetadata(TopicIdPartition topicIdPartition, long startOffset, long endOffset, String contentHash, Algorithm checksumAlgorithm, int metadataVersion) {
        this.topicIdPartition = topicIdPartition;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.contentHash = contentHash;
        this.checksumAlgorithm = checksumAlgorithm;
        this.version = metadataVersion == 0 ? 0 : 1;
    }

    public TierStateRestoreSnapshotMetadata(TierPartitionForceRestore metadata) {
        this(metadata.topicIdPartition(), metadata.startOffset(), metadata.endOffset(), metadata.contentHash(), metadata.checksumAlgorithm(), metadata.version());
    }

    public TierStateRestoreSnapshotMetadata(TopicIdPartition topicIdPartition, long startOffset, long endOffset, String contentHash, Algorithm checksumAlgorithm) {
        this.topicIdPartition = topicIdPartition;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.contentHash = contentHash;
        this.checksumAlgorithm = checksumAlgorithm;
        this.version = 1;
    }

    public int version() {
        return this.version;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public Algorithm checksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("metadataVersion", Integer.toString(this.version));
        metadata.put("topic", this.topicIdPartition().topic());
        clusterIdOpt.ifPresent(clusterId -> metadata.put("clusterId", (String)clusterId));
        brokerIdOpt.ifPresent(brokerId -> metadata.put("brokerId", Integer.toString(brokerId)));
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.TIER_STATE_SNAPSHOT) {
            throw new UnsupportedOperationException(String.format("TierStateRestoreSnapshotMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        if (this.version == 0) {
            return keyPrefix + TierObjectStore.DataTypePathPrefix.TIER_STATE_RESTORE_SNAPSHOTS.prefix + "/" + this.topicIdPartition().topicIdAsBase64() + "/" + this.topicIdPartition().partition() + "/" + MergedLog.filenamePrefixFromOffset(this.startOffset) + "-" + MergedLog.filenamePrefixFromOffset(this.endOffset) + "_" + this.contentHash + "_v" + this.version + "." + objectType.suffix();
        }
        return keyPrefix + TierObjectStore.DataTypePathPrefix.TIER_STATE_RESTORE_SNAPSHOTS.prefix + "/" + this.topicIdPartition().topicIdAsBase64() + "/" + this.topicIdPartition().partition() + "/" + MergedLog.filenamePrefixFromOffset(this.startOffset) + "-" + MergedLog.filenamePrefixFromOffset(this.endOffset) + "-" + String.valueOf(FileTierPartitionState.recoverPath(MergedLog.tierStateFileName(0L, ""), this.checksumAlgorithm)) + "_" + this.contentHash + "_v" + this.version + "." + objectType.suffix();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierStateRestoreSnapshotMetadata that = (TierStateRestoreSnapshotMetadata)o;
        return this.topicIdPartition.equals(that.topicIdPartition) && this.startOffset == that.startOffset && this.endOffset == that.endOffset && this.contentHash.equals(that.contentHash) && this.version == that.version && this.checksumAlgorithm == that.checksumAlgorithm;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topicIdPartition, this.startOffset, this.endOffset, this.contentHash, this.version, this.checksumAlgorithm});
    }

    public String toString() {
        return "TierStateRestoreSnapshotMetadata(version=" + this.version + ", topic=" + String.valueOf(this.topicIdPartition) + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", contentHash=" + this.contentHash + ", checksumAlgorithm=" + String.valueOf((Object)this.checksumAlgorithm) + ")";
    }
}

