/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.store.S3VersionInformation;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.DurabilityAuditsOffsetMapMetadata;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.CoreUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public class DownloadTieredObject {
    private static final String LOG_DIR = "log.dir";
    private static final String LOG_DIR_DOC = "Fully qualified path for log directory where tier state file is located. For example, /mnt/data/data0/logs/lkc-pgngzy_tier_soak_large_topic-0";
    private static final String OBJECT_IDS = "objects";
    private static final String OBJECT_ID_DOC = "Comma separated Base64 encoded id of the objects to downloaded";
    private static final String VERSION_GET = "version";
    private static final String VERSION_GET_DOC = "whether to download versioned object";
    private static final String FRAGMENT_TYPE = "type";
    private static final String FRAGMENT_TYPE_DOC = "Fragment type of the fragment to download. It could be: SEGMENT, OFFSET_INDEX, TIMESTAMP_INDEX, TRANSACTION_INDEX, PRODUCER_STATE, EPOCH_STATE or DA_OFFSET_MAP";
    private static final String DEST_PATH = "dest";
    private static final String DEST_PATH_DOC = "Destination directory path where the files will be downloaded. For example, /tmp";
    private static final String DEFAULT_KAFKA_PROPS_FILE = "/mnt/config/kafka.properties";
    private static final List<String> OBJECT_STORE_REQUIRED_PROPERTIES = Arrays.asList(KafkaConfig.TierMetadataNamespaceProp(), KafkaConfig.TierBackendProp(), KafkaConfig.TierS3RegionProp(), KafkaConfig.TierS3BucketProp(), KafkaConfig.TierS3PrefixProp(), KafkaConfig.TierS3AssumeRoleArnProp(), KafkaConfig.TierS3CredFilePathProp(), KafkaConfig.TierGcsRegionProp(), KafkaConfig.TierGcsBucketProp(), KafkaConfig.TierGcsPrefixProp(), KafkaConfig.TierGcsCredFilePathProp(), KafkaConfig.TierGcsWriteChunkSizeProp(), KafkaConfig.TierAzureBlockBlobContainerProp(), KafkaConfig.TierAzureBlockBlobCredFilePathProp(), KafkaConfig.TierAzureBlockBlobEndpointProp(), KafkaConfig.TierAzureBlockBlobPrefixProp(), KafkaConfig.TierAzureBlockBlobAutoAbortThresholdBytesProp());

    public static void main(String[] args) throws Exception {
        System.out.println();
        System.out.println("!!! WARN !!!");
        System.out.println("!!! DO NOT copy downloaded objects out of cluster broker node. !!!");
        System.out.println("!!! DELETE the downloaded objects after investigation. !!!");
        System.out.println();
        System.out.println("Received cmdline args: " + Arrays.toString(args));
        ArgumentParser cliParser = DownloadTieredObject.createArgumentParser();
        Namespace res = cliParser.parseArgs(args);
        String logDir = res.getString(LOG_DIR).trim();
        String objectIdString = res.getString(OBJECT_IDS);
        String[] objectIds = DownloadTieredObject.splitCommaAndTrim(objectIdString);
        String strFragmentType = res.getString(FRAGMENT_TYPE);
        FragmentType fragmentType = FragmentType.valueOf(strFragmentType);
        String destPath = res.getString(DEST_PATH);
        Boolean version = res.getBoolean(VERSION_GET);
        String objectStoreConfigFile = res.getString("tier.config").trim();
        TierObjectStore objectStore = DownloadTieredObject.objectStore(objectStoreConfigFile);
        HashSet<UUID> objectIdSet = new HashSet<UUID>();
        for (String objectId : objectIds) {
            objectIdSet.add(CoreUtils.uuidFromBase64(objectId));
        }
        Map<UUID, ObjectStoreMetadata> offsetToObjectMetadata = DownloadTieredObject.getObjectMetadata(logDir, objectIdSet, fragmentType);
        for (UUID objectId : objectIdSet) {
            ObjectStoreMetadata objectMetadata = offsetToObjectMetadata.get(objectId);
            if (objectMetadata != null) {
                try {
                    DownloadTieredObject.downloadFragment(objectStore, objectMetadata, fragmentType, destPath, version);
                }
                catch (Exception e) {
                    System.err.println("Exception while downloading object " + String.valueOf(objectId));
                    e.printStackTrace();
                }
            } else {
                System.err.println("Couldn't find the object " + String.valueOf(objectId) + " in tierState file");
            }
            Thread.sleep(100L);
        }
    }

    static String[] splitCommaAndTrim(String str) {
        return (String[])Arrays.stream(str.split(",")).map(String::trim).toArray(String[]::new);
    }

    private static ArgumentParser createArgumentParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser(DownloadTieredObject.class.getName()).defaultHelp(true).description("Download a tiered object");
        parser.addArgument(RecoveryUtils.makeArgument(LOG_DIR)).dest(LOG_DIR).type(String.class).required(true).help(LOG_DIR_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(OBJECT_IDS)).dest(OBJECT_IDS).type(String.class).required(true).help(OBJECT_ID_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(VERSION_GET)).dest(VERSION_GET).type(Boolean.class).required(true).help(VERSION_GET_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(FRAGMENT_TYPE)).dest(FRAGMENT_TYPE).type(String.class).required(true).help(FRAGMENT_TYPE_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(DEST_PATH)).dest(DEST_PATH).type(String.class).required(true).help(DEST_PATH_DOC);
        parser.addArgument(RecoveryUtils.makeArgument("tier.config")).dest("tier.config").type(String.class).required(false).setDefault(DEFAULT_KAFKA_PROPS_FILE).help("The path to a configuration file containing the required properties");
        return parser;
    }

    private static TierObjectStore getObjectStore(Properties props) {
        TierObjectStore.Backend backend = TierObjectStore.Backend.valueOf(props.getProperty(KafkaConfig.TierBackendProp()));
        TierObjectStoreConfig config = TierObjectStoreUtils.generateBackendConfig(backend, props);
        return TierObjectStoreFactory.getObjectStoreInstance(Time.SYSTEM, backend, config);
    }

    private static TierObjectStore objectStore(String objectStoreConfigFile) throws IOException {
        Properties props;
        try {
            props = Utils.loadProps((String)objectStoreConfigFile, OBJECT_STORE_REQUIRED_PROPERTIES);
        }
        catch (IOException e) {
            System.err.println("Exception while loading object store properties from file: " + objectStoreConfigFile);
            throw e;
        }
        TierObjectStore objectStore = DownloadTieredObject.getObjectStore(props);
        System.out.println("Successfully created an instance to object store. Backend: " + objectStore.getBackend().getName());
        return objectStore;
    }

    private static Map<UUID, ObjectStoreMetadata> getObjectMetadata(String logDir, Set<UUID> objectIdSet, FragmentType fragmentType) throws IOException {
        HashMap<UUID, ObjectStoreMetadata> offsetToObjectMetadata = new HashMap<UUID, ObjectStoreMetadata>();
        File dir = new File(logDir);
        TopicPartition topicPartition = MergedLog.parseTopicPartitionName(dir);
        System.out.println("TopicPartition: " + String.valueOf(topicPartition));
        Optional<File> tierStateFileOpt = Arrays.stream(dir.listFiles()).filter(f -> f.isFile() && MergedLog.isTierStateFile(f)).findFirst();
        if (!tierStateFileOpt.isPresent()) {
            throw new IllegalArgumentException("No Tier state file found at the log directory: " + logDir);
        }
        File tierStateFile = tierStateFileOpt.get();
        try (CheckedFileIO fileChannel = CheckedFileIO.open(tierStateFile.toPath(), StandardOpenOption.READ);){
            Optional<Header> headerOpt = FileTierPartitionState.readHeader(fileChannel);
            if (!headerOpt.isPresent()) {
                throw new IllegalArgumentException("Empty header at the tier state file: " + tierStateFile.getAbsolutePath());
            }
            TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), headerOpt.get().topicId(), topicPartition.partition());
            if (fragmentType == FragmentType.DA_OFFSET_MAP) {
                for (UUID objectId : objectIdSet) {
                    offsetToObjectMetadata.put(objectId, new DurabilityAuditsOffsetMapMetadata(topicIdPartition, objectId));
                }
            } else {
                FileTierPartitionIterator iterator = FileTierPartitionState.iterator(topicIdPartition, fileChannel, headerOpt.get().size());
                while (iterator.hasNext()) {
                    TierObjectMetadata metadata = (TierObjectMetadata)iterator.next();
                    if (!objectIdSet.contains(metadata.objectId())) continue;
                    offsetToObjectMetadata.put(metadata.objectId(), new ObjectMetadata(metadata));
                }
            }
        }
        catch (IOException e) {
            System.err.println("IO Exception while reading tier state file: " + tierStateFile.getAbsolutePath());
            throw e;
        }
        return offsetToObjectMetadata;
    }

    private static void downloadFragment(TierObjectStore objectStore, ObjectStoreMetadata objectMetadata, FragmentType fragmentType, String destFilePath, Boolean versionGet) throws Exception {
        Path outFile;
        Path destinationPath;
        VersionInformation versionInformation = null;
        if (versionGet.booleanValue() && (versionInformation = DownloadTieredObject.getVersionForObject(objectStore, objectMetadata, fragmentType)) == null) {
            System.out.println("!!! WARN, No Versioned object found for " + String.valueOf(objectMetadata) + " !!!");
        }
        if (Files.exists(destinationPath = Paths.get(destFilePath, new String[0]), new LinkOption[0])) {
            if (Files.isRegularFile(destinationPath, new LinkOption[0])) {
                System.out.println("The specified path points to an existing file: " + String.valueOf(destinationPath));
                return;
            }
        } else {
            Files.createDirectories(destinationPath, new FileAttribute[0]);
        }
        if (fragmentType == FragmentType.DA_OFFSET_MAP) {
            metadata = (DurabilityAuditsOffsetMapMetadata)objectMetadata;
            identifier = ((DurabilityAuditsOffsetMapMetadata)metadata).objectIdAsBase64();
            outFile = destinationPath.resolve(identifier + "." + ObjectType.DA_OFFSET_MAP.suffix());
        } else {
            metadata = (ObjectMetadata)objectMetadata;
            identifier = ((ObjectMetadata)metadata).objectIdAsBase64();
            outFile = destinationPath.resolve(identifier + "." + ((ObjectMetadata)metadata).objectTypeForFragment(fragmentType).get().suffix());
        }
        try (TierObjectStoreResponse response = objectStore.getObjectStoreFragment(objectMetadata, fragmentType, null, null, versionInformation);){
            InputStream stream = response.getInputStream();
            Files.copy(stream, outFile, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Successfully copied the blob " + objectMetadata.toFragmentLocation(objectStore.keyPrefix(), fragmentType).get().objectPath() + " to " + String.valueOf(outFile));
        }
        catch (Exception ex) {
            System.err.println("Exception while downloading object " + objectMetadata.toFragmentLocation(objectStore.keyPrefix(), fragmentType).get().objectPath());
            throw ex;
        }
    }

    private static VersionInformation getVersionForObject(TierObjectStore objectStore, ObjectStoreMetadata objectMetadata, FragmentType fragmentType) {
        Map<String, List<VersionInformation>> allVersions = objectStore.listObject(objectMetadata.toFragmentLocation("", fragmentType).get().objectPath(), true);
        for (Map.Entry<String, List<VersionInformation>> mapEntry : allVersions.entrySet()) {
            for (VersionInformation entry : mapEntry.getValue()) {
                if (objectStore.getBackend() == TierObjectStore.Backend.S3) {
                    S3VersionInformation versionInfo = (S3VersionInformation)entry;
                    if (versionInfo.isDeleteMarker()) continue;
                    return versionInfo;
                }
                if (objectStore.getBackend() == TierObjectStore.Backend.Mock) {
                    if (entry.getVersionId().equals("delete-marker")) continue;
                    return entry;
                }
                return entry;
            }
        }
        return null;
    }
}

