/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import kafka.log.MergedLog;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.DurabilityAuditsOffsetMapMetadata;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.store.objects.metadata.TierPartitionStateSnapshotMetadata;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.CoreUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public class InspectTieredObjects {
    private static final String LOG_DIR = "log.dir";
    private static final String LOG_DIR_DOC = "Fully qualified path for log directory where tier state file is located";
    private static final String START_OFFSET = "start.offset";
    private static final String START_OFFSET_DOC = "Starting base offset for the range of tiered objects to be inspected";
    private static final String END_OFFSET = "end.offset";
    private static final String END_OFFSET_DOC = "End offset for the range of tiered objects to be inspected";
    private static final String LOGGING_LEVEL = "logging.level";
    private static final String LOGGING_LEVEL_DOC = "Logging level for the tool. Valid values: SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST, ALL";
    private static final String GET_OBJECT = "get";
    private static final String GET_OBJECT_DOC = "Indicates whether the said range of objects need to be downloaded (max 5)";
    private static final Integer MAX_OBJECTS_TO_GET = 5;
    private static UUID topicId;
    private static final String OUTPUT_ROOT_DIR = "/tmp";
    private static final String DEFAULT_KAFKA_PROPS_FILE = "/mnt/config/kafka.properties";
    private static TierObjectStore.Backend backend;
    private static final String PARTITION = "partition";
    private static final String PARTITION_DOC = "partition id within given topic for which we want to retrieve ftps file";
    private static final String TOPIC_ID = "topic.id";
    private static final String TOPIC_ID_DOC = "Topic id for which we want to retrieve ftps file";
    private static final Logger LOGGER;

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser(InspectTieredObjects.class.getName()).defaultHelp(true).description("Provides facilities to \n1. check the existence and / or to download tiered objects based on topic-partition \n2. Retrieve FTPS snapshot related files");
        Subparsers subParsers = parser.addSubparsers().dest("option").help("valid options: topic, ftps");
        Subparser topicParser = subParsers.addParser("topic").help("Retrieve topic related files like log segment and other index files");
        topicParser.addArgument(RecoveryUtils.makeArgument("tier.config")).dest("tier.config").type(String.class).required(false).setDefault(DEFAULT_KAFKA_PROPS_FILE).help("The path to a configuration file containing the required properties");
        topicParser.addArgument(RecoveryUtils.makeArgument(LOG_DIR)).dest(LOG_DIR).type(String.class).required(true).help(LOG_DIR_DOC);
        topicParser.addArgument(RecoveryUtils.makeArgument(START_OFFSET)).dest(START_OFFSET).type(String.class).required(true).help(START_OFFSET_DOC);
        topicParser.addArgument(RecoveryUtils.makeArgument(END_OFFSET)).dest(END_OFFSET).type(String.class).required(false).help(END_OFFSET_DOC);
        topicParser.addArgument(RecoveryUtils.makeArgument(GET_OBJECT)).dest(GET_OBJECT).type(Boolean.class).required(false).setDefault((Object)false).help(GET_OBJECT_DOC);
        topicParser.addArgument(RecoveryUtils.makeArgument(LOGGING_LEVEL)).dest(LOGGING_LEVEL).type(String.class).required(false).setDefault("INFO").help(LOGGING_LEVEL_DOC);
        Subparser ftpsParser = subParsers.addParser("ftps").help("Retrieve FTPS snapshot related files");
        ftpsParser.addArgument(RecoveryUtils.makeArgument("tier.config")).dest("tier.config").type(String.class).required(false).setDefault(DEFAULT_KAFKA_PROPS_FILE).help("The path to a configuration file containing the required properties");
        ftpsParser.addArgument(RecoveryUtils.makeArgument(TOPIC_ID)).dest(TOPIC_ID).type(String.class).required(true).setDefault((Object)false).help(TOPIC_ID_DOC);
        ftpsParser.addArgument(RecoveryUtils.makeArgument(PARTITION)).dest(PARTITION).type(String.class).required(true).setDefault((Object)false).help(PARTITION_DOC);
        ftpsParser.addArgument(RecoveryUtils.makeArgument(LOGGING_LEVEL)).dest(LOGGING_LEVEL).type(String.class).required(false).setDefault("INFO").help(LOGGING_LEVEL_DOC);
        return parser;
    }

    private static TierObjectStore getObjectStore(Time time, Properties props) {
        backend = TierObjectStore.Backend.valueOf(props.getProperty(KafkaConfig.TierBackendProp()));
        TierObjectStoreConfig config = TierObjectStoreUtils.generateBackendConfig(backend, props);
        return TierObjectStoreFactory.getObjectStoreInstance(time, backend, config);
    }

    private static List<FragmentType> segmentFragmentTypes(ObjectMetadata metadata) {
        ArrayList<FragmentType> fragmentTypes = new ArrayList<FragmentType>();
        fragmentTypes.add(FragmentType.SEGMENT);
        fragmentTypes.add(FragmentType.OFFSET_INDEX);
        fragmentTypes.add(FragmentType.TIMESTAMP_INDEX);
        if (metadata.hasAbortedTxns()) {
            fragmentTypes.add(FragmentType.TRANSACTION_INDEX);
        }
        if (metadata.hasProducerState()) {
            fragmentTypes.add(FragmentType.PRODUCER_STATE);
        }
        if (metadata.hasEpochState()) {
            fragmentTypes.add(FragmentType.EPOCH_STATE);
        }
        return fragmentTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<Long, ObjectMetadata> loadObjectMetadata(TopicPartition topicPartition, File tierStateFile, Long startOffset, Long endOffset) throws IOException {
        TreeMap<Long, ObjectMetadata> offsetToObjectMetadata = new TreeMap<Long, ObjectMetadata>();
        try (CheckedFileIO fileChannel = CheckedFileIO.open(tierStateFile.toPath(), StandardOpenOption.READ);){
            Optional<Header> headerOpt = FileTierPartitionState.readHeader(fileChannel);
            if (!headerOpt.isPresent()) {
                LOGGER.severe("Empty header at the tier state file");
                TreeMap<Long, ObjectMetadata> treeMap = offsetToObjectMetadata;
                return treeMap;
            }
            topicId = headerOpt.get().topicId();
            LOGGER.fine("====== Printing header ======\n" + String.valueOf(headerOpt.get()));
            Optional<FileTierPartitionIterator> iteratorOpt = FileTierPartitionState.iterator(topicPartition, fileChannel);
            if (!iteratorOpt.isPresent()) {
                LOGGER.warning("Empty tier state file");
                TreeMap<Long, ObjectMetadata> treeMap = offsetToObjectMetadata;
                return treeMap;
            }
            while (iteratorOpt.get().hasNext()) {
                TierObjectMetadata metadata = (TierObjectMetadata)iteratorOpt.get().next();
                if (metadata.baseOffset() < startOffset) continue;
                if (metadata.baseOffset() > endOffset) {
                    return offsetToObjectMetadata;
                }
                offsetToObjectMetadata.put(metadata.baseOffset(), new ObjectMetadata(metadata.topicIdPartition(), metadata.objectId(), metadata.tierEpoch(), metadata.baseOffset(), metadata.hasAbortedTxns(), metadata.hasProducerState(), metadata.hasEpochState(), OpaqueData.ZEROED, metadata.segmentAndMetadataLayout()));
            }
            return offsetToObjectMetadata;
        }
        catch (IOException e) {
            LOGGER.severe("IO Exception while reading tier state file");
            throw e;
        }
    }

    private static Map<Long, ObjectMetadata> objectMetadata(String logDir, Long startOffset, Long endOffset) throws IOException {
        Map<Long, ObjectMetadata> offsetToObjectMetadata;
        File dir = new File(logDir);
        TopicPartition topicPartition = MergedLog.parseTopicPartitionName(dir);
        LOGGER.info("====== TopicPartition " + String.valueOf(topicPartition) + " ======");
        Optional<File> tierStateFile = Arrays.stream(dir.listFiles()).filter(f -> f.isFile() && MergedLog.isTierStateFile(f)).findFirst();
        if (!tierStateFile.isPresent()) {
            throw new IllegalArgumentException("No Tier state file found at the log directory");
        }
        try {
            offsetToObjectMetadata = InspectTieredObjects.loadObjectMetadata(topicPartition, tierStateFile.get(), startOffset, endOffset);
            LOGGER.fine("====== Base Offset -> Key for the segment file ======");
            offsetToObjectMetadata.forEach((key, value) -> LOGGER.fine(key.toString() + " -> " + value.toFragmentLocation("", FragmentType.SEGMENT).get().objectPath()));
        }
        catch (IOException e) {
            LOGGER.severe("IO Exception while reading tier state file");
            throw e;
        }
        return offsetToObjectMetadata;
    }

    private static TierObjectStore objectStore(String objectStoreConfigFile) throws IOException {
        Properties props;
        Time time = Time.SYSTEM;
        try {
            ArrayList<String> allProps = new ArrayList<String>(TierObjectStoreUtils.OBJECT_STORE_REQUIRED_PROPERTIES);
            props = Utils.loadProps((String)objectStoreConfigFile, allProps);
        }
        catch (IOException e) {
            LOGGER.severe("Can not load object store properties from file: " + objectStoreConfigFile);
            throw e;
        }
        props.put(KafkaConfig.TierGcsPrefixProp(), "");
        LOGGER.fine("====== Loaded the following properties to access object store ======");
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOGGER.fine(String.valueOf(k) + " -> " + String.valueOf(v))));
        TierObjectStore objectStore = InspectTieredObjects.getObjectStore(time, props);
        LOGGER.info("Successfully created an instance to object store. Backend: " + objectStore.getBackend().getName());
        return objectStore;
    }

    private static void listSegments(TierObjectStore objectStore, Map<Long, ObjectMetadata> offsetToObjectMetadata) {
        LOGGER.info("====== Printing blobs contained in each of the objects from the input range ======");
        offsetToObjectMetadata.forEach((offset, objectMetadata) -> {
            ArrayList<FragmentType> fragmentTypes = new ArrayList<FragmentType>();
            if (objectMetadata.isCombinedObject(objectStore.keyPrefix())) {
                fragmentTypes.add(FragmentType.SEGMENT);
            } else {
                fragmentTypes.addAll(InspectTieredObjects.segmentFragmentTypes(objectMetadata));
            }
            fragmentTypes.add(FragmentType.DA_OFFSET_MAP);
            fragmentTypes.forEach(fragmentType -> {
                Optional<FragmentLocation> locationOpt;
                ObjectStoreMetadata metadata = objectMetadata;
                if (fragmentType.equals((Object)FragmentType.DA_OFFSET_MAP)) {
                    metadata = new DurabilityAuditsOffsetMapMetadata(objectMetadata.topicIdPartition(), objectMetadata.objectId());
                }
                if (!(locationOpt = metadata.toFragmentLocation(objectStore.keyPrefix(), (FragmentType)((Object)((Object)fragmentType)))).isPresent()) {
                    LOGGER.severe("could not get FragmentLocation for FragmentType " + String.valueOf(fragmentType) + " for " + String.valueOf(metadata));
                    return;
                }
                Map<String, List<VersionInformation>> allVersions = objectStore.listObject(locationOpt.get().objectPath(), true);
                allVersions.forEach((key, versions) -> {
                    LOGGER.info((String)key);
                    versions.forEach(v -> LOGGER.info("\t\t" + v.toString()));
                });
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Thread interrupted during sleep. Will exit", e);
                }
            });
        });
    }

    private static void getObjects(TierObjectStore objectStore, Map<Long, ObjectMetadata> offsetToObjectMetadata) {
        LOGGER.info("====== Get blobs from the first " + MAX_OBJECTS_TO_GET + " objects in the input range ======");
        Path outDir = Paths.get(OUTPUT_ROOT_DIR, CoreUtils.uuidToBase64(topicId));
        try {
            Files.createDirectory(outDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.severe("Could not create directory " + String.valueOf(outDir) + " " + String.valueOf(e));
            return;
        }
        offsetToObjectMetadata.entrySet().stream().limit(MAX_OBJECTS_TO_GET.intValue()).forEach(entry -> {
            List<FragmentType> fragmentTypes = InspectTieredObjects.segmentFragmentTypes((ObjectMetadata)entry.getValue());
            fragmentTypes.add(FragmentType.DA_OFFSET_MAP);
            fragmentTypes.forEach(fragmentType -> {
                ObjectStoreMetadata metadata = (ObjectStoreMetadata)entry.getValue();
                if (fragmentType.equals((Object)FragmentType.DA_OFFSET_MAP)) {
                    metadata = new DurabilityAuditsOffsetMapMetadata(((ObjectMetadata)entry.getValue()).topicIdPartition(), ((ObjectMetadata)entry.getValue()).objectId());
                }
                Optional<FragmentLocation> locationOpt = metadata.toFragmentLocation(objectStore.keyPrefix(), (FragmentType)((Object)((Object)fragmentType)));
                Optional<ObjectType> defaultObjectTypeOpt = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType);
                if (!locationOpt.isPresent()) {
                    LOGGER.severe("could not get FragmentLocation for FragmentType " + String.valueOf(fragmentType) + " for " + String.valueOf(metadata));
                    return;
                }
                if (!defaultObjectTypeOpt.isPresent()) {
                    LOGGER.severe("could not get default ObjectType for FragmentType " + String.valueOf(fragmentType));
                    return;
                }
                FragmentLocation location = locationOpt.get();
                LOGGER.fine("Get blob: " + location.objectPath() + ", startByteOffset=" + location.startByteOffset() + ", endByteOffsetExclusive=" + String.valueOf(location.endByteOffsetExclusive()));
                try (TierObjectStoreResponse response = objectStore.getObjectStoreFragment(metadata, (FragmentType)((Object)((Object)fragmentType)));){
                    InputStream stream = response.getInputStream();
                    String filename = Paths.get(location.objectPath(), new String[0]).getFileName().toString();
                    String baseOffset = filename.substring(0, filename.indexOf(95));
                    Object suffix = filename.substring(filename.lastIndexOf(46));
                    ObjectType tierObjectType = location.objectType();
                    if (location.objectType() == ObjectType.SEGMENT_WITH_METADATA) {
                        LOGGER.info("detected segment-with-metadata object in ObjectStore; renaming suffix to the FragmentType's extension");
                        suffix = "." + defaultObjectTypeOpt.get().suffix();
                        tierObjectType = defaultObjectTypeOpt.get();
                    }
                    if (tierObjectType == ObjectType.SEGMENT) {
                        LOGGER.info("Detected extension \".segment\"; renaming extension to \".log\"");
                        suffix = ".log";
                    }
                    String outFileName = baseOffset + (String)suffix;
                    Path outFile = Paths.get(outDir.toString(), outFileName);
                    LOGGER.fine("Write out to: " + String.valueOf(outFile));
                    Files.copy(stream, outFile, StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.info("Successfully copied the blob fragment to " + String.valueOf(outFile));
                }
                catch (TierObjectStoreRetriableException e) {
                    LOGGER.warning(String.format("Retriable exception while fetching %s. Exception: %s", new Object[]{location.objectPath(), e}));
                }
                catch (TierObjectStoreFatalException e) {
                    if (fragmentType != FragmentType.DA_OFFSET_MAP) {
                        LOGGER.severe(String.format("Fatal exception while fetching %s. Exception: %s", location.objectPath(), e));
                    }
                }
                catch (IOException e) {
                    LOGGER.warning(String.format("IOException while fetching %s. Exception: %s", location.objectPath(), e));
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Thread interrupted during sleep. Will exit", e);
                }
            });
        });
    }

    private static void setupLogger(String level) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter(){
            private static final String format = "[%1$-7s] %2$s %n";

            @Override
            public synchronized String format(LogRecord lr) {
                return String.format(format, lr.getLevel().getLocalizedName(), lr.getMessage());
            }
        });
        handler.setLevel(Level.parse(level));
        LOGGER.addHandler(handler);
        LOGGER.setUseParentHandlers(false);
        LOGGER.setLevel(Level.parse(level));
    }

    private static void run(Namespace args) throws IOException {
        switch (args.getString("option")) {
            case "topic": {
                String objectStoreConfigFile = args.getString("tier.config").trim();
                String logDir = args.getString(LOG_DIR).trim();
                Long startOffset = Long.parseLong(args.getString(START_OFFSET));
                String endOffsetStr = args.getString(END_OFFSET);
                if (endOffsetStr == null || endOffsetStr.isEmpty()) {
                    endOffsetStr = args.getString(START_OFFSET);
                }
                Long endOffset = Long.parseLong(endOffsetStr);
                boolean getObjects = args.getBoolean(GET_OBJECT);
                String loggingLevel = args.getString(LOGGING_LEVEL);
                InspectTieredObjects.setupLogger(loggingLevel);
                Map<Long, ObjectMetadata> offsetToObjectMetadata = InspectTieredObjects.objectMetadata(logDir, startOffset, endOffset);
                if (offsetToObjectMetadata.isEmpty()) {
                    LOGGER.warning("No tier metadata for the offset range");
                    return;
                }
                TierObjectStore objectStore = InspectTieredObjects.objectStore(objectStoreConfigFile);
                InspectTieredObjects.listSegments(objectStore, offsetToObjectMetadata);
                if (getObjects) {
                    InspectTieredObjects.getObjects(objectStore, offsetToObjectMetadata);
                }
                TierObjectStoreFactory.closeBackendInstance(backend);
                break;
            }
            case "ftps": {
                String objectStoreConfigFile = args.getString("tier.config").trim();
                String topicid = args.getString(TOPIC_ID);
                String partition = args.getString(PARTITION);
                String loggingLevel = args.getString(LOGGING_LEVEL);
                InspectTieredObjects.setupLogger(loggingLevel);
                TierObjectStore objectStore = InspectTieredObjects.objectStore(objectStoreConfigFile);
                UUID topicId = CoreUtils.uuidFromBase64(topicid);
                int partitionId = Integer.parseInt(partition);
                TopicIdPartition topicIdPartition = new TopicIdPartition("", topicId, partitionId);
                String snapshotPrefix = TierPartitionStateSnapshotMetadata.pathPrefix(objectStore.keyPrefix(), topicIdPartition);
                Map<String, List<VersionInformation>> allSnapshotPaths = objectStore.listObject(snapshotPrefix, false);
                LOGGER.info("====== Printing all snapshot files for given TopicPartition ======");
                allSnapshotPaths.forEach((key, versions) -> {
                    LOGGER.info((String)key);
                    versions.forEach(v -> LOGGER.info("\t\t" + v.toString()));
                });
                TierObjectStoreFactory.closeBackendInstance(backend);
                break;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        block2: {
            ArgumentParser parser = InspectTieredObjects.createArgParser();
            try {
                InspectTieredObjects.run(parser.parseArgs(args));
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                if (e instanceof HelpScreenException) break block2;
                throw e;
            }
        }
    }

    static {
        backend = null;
        LOGGER = Logger.getLogger("InspectTieredObjects");
    }
}

