/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreFunctionUtils;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.TierRecoveryUploadMetadata;
import kafka.tier.tools.PartitionUploadInfo;
import kafka.tier.tools.TierMetadataRecoveryUtils;
import kafka.tier.tools.TierRecoveryUploadMetadataJson;
import kafka.tier.tools.TierToolsUtils;
import kafka.tier.topic.recovery.SelectRemoteFileTierPartitionStateOutput;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFileTierPartitionStatePolicyUtils {
    private static final Logger log = LoggerFactory.getLogger(SelectFileTierPartitionStatePolicyUtils.class);

    private SelectFileTierPartitionStatePolicyUtils() {
    }

    public static Set<TopicIdPartition> getAffectedTopicPartitions(String reconciledDlvOutputPath, String nonReconciledDlvOutputPath, String targetTopicPartitionsFilePath) throws Exception {
        long nonNullCount = Stream.of(reconciledDlvOutputPath, nonReconciledDlvOutputPath, targetTopicPartitionsFilePath).filter(Objects::nonNull).count();
        if (nonNullCount != 1L) {
            throw new IllegalArgumentException("Expected exactly one of the input files to be non-null");
        }
        if (reconciledDlvOutputPath != null) {
            return TierMetadataRecoveryUtils.getAffectedTopicPartitionsFromReconciledDLVOutput(reconciledDlvOutputPath);
        }
        if (nonReconciledDlvOutputPath != null) {
            return TierMetadataRecoveryUtils.getAffectedTopicPartitionsFromNonReconciledDLVOutput(nonReconciledDlvOutputPath);
        }
        return TierMetadataRecoveryUtils.getAffectedTopicPartitionsFromTargetTopicPartitionsFile(targetTopicPartitionsFilePath);
    }

    public static void validateNumOfFTPSObjects(boolean skipReplicationFactorCheck, int replicationFactorOverride, List<PartitionUploadInfo> ftpsList) {
        int ftpsCount;
        if (!skipReplicationFactorCheck && (ftpsCount = ftpsList.size()) != replicationFactorOverride) {
            throw new RuntimeException(String.format("Replication factor: %d is not equal to number of FTPS objects uploaded: %d. List of FTPS object store paths: %s", replicationFactorOverride, ftpsCount, ftpsList.stream().map(uploadInfo -> uploadInfo.objectStorePath).collect(Collectors.toSet())));
        }
    }

    public static Map<TopicIdPartition, List<PartitionUploadInfo>> getRecoveryMetadata(TierObjectStore objectStore, String identifier, String adminConfigFile, String bootstrapServers) throws InterruptedException, ExecutionException, IOException {
        DescribeClusterResult describeClusterResult;
        try (AdminClient adminClient = TierToolsUtils.getAdminClient(adminConfigFile, bootstrapServers);){
            describeClusterResult = adminClient.describeCluster();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap<TopicIdPartition, List<PartitionUploadInfo>> recoveryMetadata = new HashMap<TopicIdPartition, List<PartitionUploadInfo>>();
        for (Node node : (Collection)describeClusterResult.nodes().get()) {
            TierRecoveryUploadMetadata uploadMetadata = new TierRecoveryUploadMetadata(identifier, node.id());
            TierObjectAttribute attribute = objectStore.objectExists(uploadMetadata, ObjectType.TIER_RECOVERY_METADATA_UPLOAD);
            if (attribute.exist) {
                try {
                    TierObjectStoreResponse response = TierObjectStoreFunctionUtils.getObjectStoreFragment(() -> false, objectStore, uploadMetadata, FragmentType.TIER_RECOVERY_METADATA_UPLOAD);
                    InputStream stream = response.getInputStream();
                    ObjectMapper objectMapper = new ObjectMapper();
                    TierRecoveryUploadMetadataJson metadata = objectMapper.readValue(stream, TierRecoveryUploadMetadataJson.class);
                    for (Map.Entry<String, PartitionUploadInfo> entry : metadata.partitions.entrySet()) {
                        TopicIdPartition topicIdPartition = TopicIdPartition.fromString(entry.getKey());
                        PartitionUploadInfo partitionUploadInfo = entry.getValue();
                        if (partitionUploadInfo.objectStorePath.trim().equals("null")) continue;
                        if (recoveryMetadata.containsKey(topicIdPartition)) {
                            ((List)recoveryMetadata.get(topicIdPartition)).add(partitionUploadInfo);
                            continue;
                        }
                        recoveryMetadata.put(topicIdPartition, new ArrayList<PartitionUploadInfo>(Collections.singletonList(partitionUploadInfo)));
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error("Received non-retriable exception when finding upload metadata for broker node ID: {}", (Object)node.id(), (Object)e);
                    throw e;
                }
            }
            log.warn("Failed to find upload metadata at path {} for broker node ID: {}", (Object)uploadMetadata, (Object)node.id());
        }
        return recoveryMetadata;
    }

    public static Path writeSelectRemoteFTPSOutputToFile(SelectRemoteFileTierPartitionStateOutput output, int numPartitions, List<TopicIdPartition> failedPartitions, String dir) throws IOException {
        String outputfileName = dir + "/selected-ftps-uri-" + new Random().nextInt(Integer.MAX_VALUE) + ".json";
        Path outputFile = Paths.get(outputfileName, new String[0]);
        SelectRemoteFileTierPartitionStateOutput.writeToFile(output, outputFile.toFile());
        log.info("Select FTPS process completed for {} partitions, failed for {}. Selected FTPS in {}", new Object[]{numPartitions - failedPartitions.size(), failedPartitions, outputFile.toAbsolutePath()});
        return outputFile;
    }
}

