/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.UnfreezeLogStartOffsetRawInputLocal;
import kafka.tier.tools.UnfreezeLogStartOffsetRawInputRemoteURI;
import kafka.tier.tools.common.RestoreRawOutputInfoLocal;
import kafka.tier.tools.common.RestoreRawOutputInfoRemoteURI;
import kafka.tier.topic.TierTopic;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierPartitionUnfreezeLogStartOffsetTrigger {
    public static final String UNFREEZE_LOG_START_OFFSET_INPUT = "restore.json";
    public static final String UNFREEZE_LOG_START_OFFSET_INPUT_DOC = "Json input file generated by kafka.tier.tools.TierPartitionStateRestoreTrigger tool. This file contains information about the TierPartitionForceRestore event injected by the TierPartitionStateRestoreTrigger tool and tier partition states' comparison data created earlier by the kafka.tier.tools.TierMetadataComparator tool.";
    public static final String UNFREEZE_LOG_START_OFFSET_OUTPUT = "output.json";
    public static final String UNFREEZE_LOG_START_OFFSET_OUTPUT_DOC = "Path to the output file where information about the TierPartitionUnfreezeLogStartOffset event will be saved.";
    public static final String INPUT_FILE_CONTAINS_REMOTE_URI = "remote.uri.supported";
    public static final String INPUT_FILE_CONTAINS_REMOTE_URI_DOC = "Boolean value indicating if Json input file generated by kafka.tier.tools.TierPartitionStateRestoreTrigger tool contains Remote URI info.";
    private static final Logger LOGGER = LoggerFactory.getLogger(TierPartitionUnfreezeLogStartOffsetTrigger.class);

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser(TierPartitionUnfreezeLogStartOffsetTrigger.class.getName()).defaultHelp(true).description("Provides a command to unfreeze the merged log start offset using a TierPartitionUnfreezeLogStartOffset event.");
        parser.addArgument(RecoveryUtils.makeArgument("tier.config")).dest("tier.config").type(String.class).required(true).help("The path to a configuration file containing the required properties");
        parser.addArgument(RecoveryUtils.makeArgument(UNFREEZE_LOG_START_OFFSET_INPUT)).dest(UNFREEZE_LOG_START_OFFSET_INPUT).type(String.class).required(true).help(UNFREEZE_LOG_START_OFFSET_INPUT_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(UNFREEZE_LOG_START_OFFSET_OUTPUT)).dest(UNFREEZE_LOG_START_OFFSET_OUTPUT).type(String.class).required(true).help(UNFREEZE_LOG_START_OFFSET_OUTPUT_DOC);
        parser.addArgument(RecoveryUtils.makeArgument(INPUT_FILE_CONTAINS_REMOTE_URI)).dest(INPUT_FILE_CONTAINS_REMOTE_URI).type(String.class).required(true).help(INPUT_FILE_CONTAINS_REMOTE_URI_DOC);
        return parser;
    }

    static TierPartitionUnfreezeLogStartOffset injectState(String tierTopicName, int numTierTopicPartitions, Producer<byte[], byte[]> producer, File file) throws Exception {
        TopicPartition topicPartition = MergedLog.parseTopicPartitionName(file.getParentFile());
        try (CheckedFileIO fileChannel = CheckedFileIO.open(file.toPath(), StandardOpenOption.READ);){
            System.out.printf("Attempting recovery for %s @ %s%n", topicPartition, file);
            Optional<Header> headerOpt = FileTierPartitionState.readHeader(fileChannel);
            if (!headerOpt.isPresent()) {
                throw new Exception("Header is not present for the TierPartitionState supplied");
            }
            Header header = headerOpt.get();
            if (header.status() != TierPartitionStatus.FROZEN_LOG_START_OFFSET) {
                throw new Exception(String.format("Header is not in the expected status: %s Header: %s", new Object[]{TierPartitionStatus.FROZEN_LOG_START_OFFSET, header.toString()}));
            }
            UUID messageUUID = UUID.randomUUID();
            TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), header.topicId(), topicPartition.partition());
            TierPartitionUnfreezeLogStartOffset unfreezeEvent = new TierPartitionUnfreezeLogStartOffset(topicIdPartition, messageUUID);
            RecordMetadata metadata = RecoveryUtils.injectTierTopicEvent(producer, unfreezeEvent, tierTopicName, numTierTopicPartitions);
            System.out.printf("Emitted tier topic recovery event: %s for %s%n", metadata, header);
            TierPartitionUnfreezeLogStartOffset tierPartitionUnfreezeLogStartOffset = unfreezeEvent;
            return tierPartitionUnfreezeLogStartOffset;
        }
    }

    private static void run(ArgumentParser parser, Namespace args) throws Exception {
        Properties props;
        UnfreezeLogStartOffsetRawInputLocal unfreezeLogStartOffsetRawInputLocal = new UnfreezeLogStartOffsetRawInputLocal();
        UnfreezeLogStartOffsetRawInputRemoteURI unfreezeLogStartOffsetRawInputRemoteURI = new UnfreezeLogStartOffsetRawInputRemoteURI();
        String propertiesConfFile = args.getString("tier.config").trim();
        try {
            ArrayList allProps = new ArrayList(ProducerConfig.configNames());
            props = Utils.loadProps((String)propertiesConfFile, allProps);
        }
        catch (IOException e) {
            throw new ArgumentParserException(String.format("Can not load properties from file: '%s'", propertiesConfFile), e, parser);
        }
        String bootstrapServers = props.getProperty("bootstrap.servers", "").trim();
        if (bootstrapServers.isEmpty()) {
            throw new ArgumentParserException(String.format("The provided properties conf file: '%s' can not contain empty or absent bootstrap servers as value for the property: '%s'", propertiesConfFile, "bootstrap.servers"), parser);
        }
        String tierTopicNamespace = props.getProperty(KafkaConfig.TierMetadataNamespaceProp(), "");
        String inputFilePath = args.getString(UNFREEZE_LOG_START_OFFSET_INPUT);
        String tierTopicName = TierTopic.topicName(tierTopicNamespace);
        String outputPath = args.getString(UNFREEZE_LOG_START_OFFSET_OUTPUT).trim();
        File outputFile = new File(outputPath);
        if (outputFile.exists() && !outputFile.delete()) {
            throw new IOException("Cannot overwrite existing file at " + outputPath);
        }
        if (!outputFile.createNewFile()) {
            throw new IOException("Could not create output file at path " + outputPath);
        }
        if (inputFilePath != null) {
            String inputFileContainsRemoteURI = args.getString(INPUT_FILE_CONTAINS_REMOTE_URI);
            Path inputJsonFile = Paths.get(inputFilePath, new String[0]);
            if (Objects.equals(inputFileContainsRemoteURI, "false")) {
                List<RestoreRawOutputInfoLocal> inputs = unfreezeLogStartOffsetRawInputLocal.getUnfreezeLogStartOffsetTriggerInput(inputJsonFile);
                unfreezeLogStartOffsetRawInputLocal.injectStateFromRawInput(props, tierTopicName, outputFile, inputs);
            } else if (Objects.equals(inputFileContainsRemoteURI, "true")) {
                List<RestoreRawOutputInfoRemoteURI> inputs = unfreezeLogStartOffsetRawInputRemoteURI.getUnfreezeLogStartOffsetTriggerInput(inputJsonFile);
                unfreezeLogStartOffsetRawInputRemoteURI.injectStateFromRawInput(props, tierTopicName, outputFile, inputs);
            } else {
                LOGGER.error("Please enter valid value for the parameter remote.uri.supported");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        block2: {
            ArgumentParser parser = TierPartitionUnfreezeLogStartOffsetTrigger.createArgParser();
            try {
                TierPartitionUnfreezeLogStartOffsetTrigger.run(parser, parser.parseArgs(args));
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                if (e instanceof HelpScreenException) break block2;
                throw e;
            }
        }
    }
}

