/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.state.FileTierPartitionStateUploadObject;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreFunctionUtils;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.TierOffsetsRecoveryUploadMetadata;
import kafka.tier.store.objects.metadata.TierRecoveryUploadMetadata;
import kafka.tier.tools.PartitionUploadInfo;
import kafka.tier.tools.TierPartitionStateUploadResult;
import kafka.tier.tools.TierPartitionStateUploadTask;
import kafka.tier.tools.TierPartitionStateUploadTaskFuture;
import kafka.tier.tools.TierRecoveryDataUploadJobStatus;
import kafka.tier.tools.TierRecoveryDataUploadResult;
import kafka.tier.tools.TierRecoveryUploadMetadataJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;

public class TierRecoveryDataUploadCoordinator {
    static final Integer CURRENT_METADATA_VERSION = 0;
    private static final Integer MIN_SUPPORTED_VERSION = 0;
    private static final Logger log = LoggerFactory.getLogger(TierRecoveryDataUploadCoordinator.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final KafkaConfig config;
    private final ReplicaManager replicaManager;
    private final TierObjectStore objectStore;
    private LinkedHashMap<UUID, TierRecoveryDataUploadResult> results = new LinkedHashMap<UUID, TierRecoveryDataUploadResult>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<UUID, TierRecoveryDataUploadResult> eldest) {
            return this.size() > 10;
        }
    };
    private List<TierPartitionStateUploadTaskFuture> futures = new ArrayList<TierPartitionStateUploadTaskFuture>();
    private ExecutorService executorService = null;
    private UUID currentJobId = null;

    public TierRecoveryDataUploadCoordinator(KafkaConfig config, ReplicaManager replicaManager, TierObjectStore objectStore) {
        this.config = config;
        this.replicaManager = replicaManager;
        this.objectStore = objectStore;
    }

    public synchronized UUID initiateTierRecoveryDataUpload(Set<TopicIdPartition> topicIdPartitions, String identifier, int numThreads) {
        if (numThreads < 1) {
            String errorMessage = "numThreads must be greater than 0";
            log.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        if (this.currentJobId == null) {
            this.currentJobId = UUID.randomUUID();
            this.results.put(this.currentJobId, new TierRecoveryDataUploadResult(identifier));
            this.executorService = Executors.newFixedThreadPool(numThreads);
            List<List<TopicIdPartition>> topicIdPartitionsByTask = this.splitTopicPartitionByTask(topicIdPartitions, numThreads);
            for (List<TopicIdPartition> topicIdPartitionsForTask : topicIdPartitionsByTask) {
                TierPartitionStateUploadTask task = new TierPartitionStateUploadTask(new HashSet<TopicIdPartition>(topicIdPartitionsForTask), this.objectStore, this.replicaManager.logManager(), identifier, this.config);
                Future<Map<TopicIdPartition, TierPartitionStateUploadResult>> future = this.executorService.submit(task);
                this.futures.add(new TierPartitionStateUploadTaskFuture(task, future));
            }
            this.results.get(this.currentJobId).setStatus(TierRecoveryDataUploadJobStatus.RUNNING);
            log.info("Initiated tier recovery data upload job with id: " + String.valueOf(this.currentJobId) + " for identifier: " + identifier);
            return this.currentJobId;
        }
        String errorMessage = "Upload tier recovery data upload job with id: " + String.valueOf(this.currentJobId) + " is already running";
        log.error(errorMessage);
        throw new IllegalStateException(errorMessage);
    }

    public synchronized TierRecoveryDataUploadResult getJobResult(UUID jobId) throws IOException {
        if (jobId.equals(this.currentJobId)) {
            this.maybeUpdateJobStatus();
            if (this.results.get(jobId).status() == TierRecoveryDataUploadJobStatus.COMPLETED) {
                this.cleanup();
            } else {
                log.info("Current job id: " + String.valueOf(jobId) + " is still running.");
            }
        } else if (this.results.containsKey(jobId)) {
            log.info("Retrieving result for old job id: " + String.valueOf(jobId));
        } else {
            log.error("Received unknown job id: " + String.valueOf(jobId));
            return TierRecoveryDataUploadResult.makeDummyJobResult();
        }
        return this.results.get(jobId);
    }

    public void shutdown() throws IOException {
        this.cleanup();
    }

    private synchronized void maybeUpdateJobStatus() {
        if (this.results.get(this.currentJobId).status() == TierRecoveryDataUploadJobStatus.COMPLETED || this.results.get(this.currentJobId).status() == TierRecoveryDataUploadJobStatus.DATA_UPLOAD_COMPLETED) {
            return;
        }
        boolean completed = true;
        for (TierPartitionStateUploadTaskFuture future : this.futures) {
            if (future.isDone()) continue;
            completed = false;
        }
        if (completed) {
            this.uploadTierOffsets();
            this.results.get(this.currentJobId).setStatus(TierRecoveryDataUploadJobStatus.DATA_UPLOAD_COMPLETED);
            log.info("FTPS file uploads and tier offsets uploads for job with id: " + String.valueOf(this.currentJobId) + " completed");
            this.updateCurrentJobResult();
            this.results.get(this.currentJobId).setStatus(TierRecoveryDataUploadJobStatus.COMPLETED);
        }
    }

    private void updateCurrentJobResult() {
        Map<TopicIdPartition, TierPartitionStateUploadResult> ftpsUploadRes = this.getFtpsUploadResult();
        HashMap<TopicIdPartition, String> failedPartitions = new HashMap<TopicIdPartition, String>();
        ftpsUploadRes.forEach((topicIdPartition, uploadResult) -> {
            if (uploadResult.hasException()) {
                failedPartitions.put((TopicIdPartition)topicIdPartition, uploadResult.exceptionType());
            }
        });
        this.results.get(this.currentJobId).setFailedPartitions(failedPartitions);
        this.uploadTierRecoveryUploadMetadata(ftpsUploadRes);
    }

    private Map<TopicIdPartition, TierPartitionStateUploadResult> getFtpsUploadResult() {
        HashMap<TopicIdPartition, TierPartitionStateUploadResult> result = new HashMap<TopicIdPartition, TierPartitionStateUploadResult>();
        for (TierPartitionStateUploadTaskFuture future : this.futures) {
            try {
                result.putAll(future.get());
            }
            catch (Exception e) {
                log.error("Received unexpected exception while retrieving upload task result", (Throwable)e);
            }
        }
        return result;
    }

    private void uploadTierRecoveryUploadMetadata(Map<TopicIdPartition, TierPartitionStateUploadResult> ftpsUploadRes) {
        TierRecoveryUploadMetadataJson oldUploadMetadata;
        TierRecoveryUploadMetadata objectMetadata;
        block14: {
            String currentJobIdentifier = this.results.get(this.currentJobId).identifier();
            objectMetadata = new TierRecoveryUploadMetadata(currentJobIdentifier, this.config.brokerId());
            oldUploadMetadata = null;
            try {
                String metadataPrefix = TierRecoveryUploadMetadata.pathPrefix("", currentJobIdentifier, this.config.brokerId());
                Map<String, List<VersionInformation>> objects = TierObjectStoreFunctionUtils.listObject(() -> false, this.objectStore, metadataPrefix, false);
                if (objects.size() > 1) {
                    throw new IllegalStateException(String.format("Found multiple tier recovery data upload metadata files for identifier: %s. Expected at most 1.", currentJobIdentifier));
                }
                if (objects.isEmpty()) break block14;
                TierObjectStoreResponse resp = TierObjectStoreFunctionUtils.getObjectStoreFragment(() -> false, this.objectStore, objectMetadata, FragmentType.TIER_RECOVERY_METADATA_UPLOAD);
                try (InputStream stream = resp.getInputStream();){
                    int length;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    while ((length = stream.read(buf)) != -1) {
                        outputStream.write(buf, 0, length);
                    }
                    oldUploadMetadata = this.objectMapper.readValue(outputStream.toString(), TierRecoveryUploadMetadataJson.class);
                    if (oldUploadMetadata.version < MIN_SUPPORTED_VERSION) {
                        log.error("Found tier recovery upload metadata with unsupported version: " + oldUploadMetadata.version + ". Creating new metadata file.");
                        oldUploadMetadata = null;
                    }
                }
            }
            catch (TierObjectStoreFatalException e) {
                log.info("Could not find existing tier recovery data upload metadata. Creating new metadata file");
            }
            catch (IOException | InterruptedException e) {
                log.error("Received exception while retrieving tier recovery data upload metadata. Creating new metadata file", (Throwable)e);
            }
        }
        HashMap partitionLeaderMap = new HashMap();
        this.replicaManager.leaderPartitionsIterator().foreach(partition -> {
            partitionLeaderMap.put(partition.topicPartition(), true);
            return null;
        });
        HashMap<String, PartitionUploadInfo> partitionUploadInfoMap = oldUploadMetadata != null ? oldUploadMetadata.partitions : new HashMap<String, PartitionUploadInfo>();
        ftpsUploadRes.forEach((topicIdPartition, uploadResult) -> partitionUploadInfoMap.put(topicIdPartition.toString(), new PartitionUploadInfo(String.valueOf(uploadResult.uploadPath()), partitionLeaderMap.getOrDefault(topicIdPartition.topicPartition(), false))));
        try {
            TierRecoveryUploadMetadataJson uploadMetadata = new TierRecoveryUploadMetadataJson(CURRENT_METADATA_VERSION, partitionUploadInfoMap);
            String uploadMetadataStr = this.objectMapper.writeValueAsString(uploadMetadata);
            ByteBuffer buffer = ByteBuffer.wrap(uploadMetadataStr.getBytes());
            TierObjectStoreFunctionUtils.putBuffer(() -> false, this.objectStore, objectMetadata, buffer, ObjectType.TIER_RECOVERY_METADATA_UPLOAD);
            this.results.get(this.currentJobId).setMetadataUploadSucceeded();
        }
        catch (IOException | InterruptedException | TierObjectStoreFatalException e) {
            log.error("Received exception while creating tier recovery data upload metadata", (Throwable)e);
            this.results.get(this.currentJobId).setMetadataUploadFailed(e);
        }
    }

    private void uploadTierOffsets() {
        Map<String, ByteBuffer> tierOffsets = this.replicaManager.logManager().readTierOffsets();
        boolean success = true;
        for (Map.Entry<String, ByteBuffer> tierOffsetsFile : tierOffsets.entrySet()) {
            String currentJobIdentifier = this.results.get(this.currentJobId).identifier();
            String logDir = tierOffsetsFile.getKey();
            ByteBuffer buffer = tierOffsetsFile.getValue();
            TierOffsetsRecoveryUploadMetadata tierOffsetsUploadMetadata = new TierOffsetsRecoveryUploadMetadata(logDir, currentJobIdentifier, this.config.brokerId());
            try {
                TierObjectStoreFunctionUtils.putBuffer(() -> false, this.objectStore, tierOffsetsUploadMetadata, buffer, ObjectType.TIER_OFFSETS_UPLOAD);
            }
            catch (IOException | InterruptedException | TierObjectStoreFatalException e) {
                log.error("Failed to upload tier recovery data offsets", (Throwable)e);
                this.results.get(this.currentJobId).setTierOffsetsUploadFailed(e);
                success = false;
            }
        }
        if (success) {
            this.results.get(this.currentJobId).setTierOffsetsUploadSucceeded();
        }
    }

    private List<List<TopicIdPartition>> splitTopicPartitionByTask(Set<TopicIdPartition> topicIdPartitions, int numTasks) {
        ArrayList<List<TopicIdPartition>> splitPartitions = new ArrayList<List<TopicIdPartition>>();
        int index = 0;
        for (TopicIdPartition topicIdPartition : topicIdPartitions) {
            if (splitPartitions.size() <= index) {
                splitPartitions.add(new ArrayList());
            }
            ((List)splitPartitions.get(index)).add(topicIdPartition);
            index = (index + 1) % numTasks;
        }
        return splitPartitions;
    }

    private synchronized void cleanup() throws IOException {
        this.currentJobId = null;
        if (this.executorService != null) {
            for (TierPartitionStateUploadTaskFuture future : this.futures) {
                while (!future.isDone()) {
                    future.cancel();
                }
            }
            this.executorService.shutdown();
        }
        this.executorService = null;
        this.futures.clear();
        boolean checksumEnabled = this.config.confluentConfig().tierChecksumFeatureEnabled();
        for (String logDir : JavaConverters.asJavaCollection(this.config.logDirs())) {
            FileTierPartitionStateUploadObject.cleanupRecoveryUploads(logDir, checksumEnabled);
        }
    }
}

