/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kafka.tier.topic.TierCatchupConsumer;
import kafka.tier.topic.TierTopicUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.slf4j.LoggerFactory;

class TierDiscoverConsumer
extends TierCatchupConsumer {
    volatile Map<TopicPartition, Long> tierTopicPartitionsAndEndOffsets;

    TierDiscoverConsumer(Supplier<Consumer<byte[], byte[]>> consumerSupplier, Supplier<Boolean> shouldStopRetryingConsumerCreation, Time time) {
        super(consumerSupplier, shouldStopRetryingConsumerCreation, time);
        this.log = LoggerFactory.getLogger(TierDiscoverConsumer.class);
    }

    void doStart(Set<TopicPartition> tierTopicPartitions, long consumeFromTimestamp) {
        if (!this.maybeStartConsumer(tierTopicPartitions, consumeFromTimestamp)) {
            throw new IllegalStateException(String.format("Unable to startup consumer with consume from timestamp: %d", consumeFromTimestamp));
        }
    }

    boolean tryComplete() {
        if (this.tierTopicPartitionsAndEndOffsets == null) {
            return false;
        }
        return super.tryComplete((tp, position) -> this.tierTopicPartitionsAndEndOffsets.get(tp) <= this.consumer.position(tp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        super.close();
        TierDiscoverConsumer tierDiscoverConsumer = this;
        synchronized (tierDiscoverConsumer) {
            this.tierTopicPartitionsAndEndOffsets = null;
        }
    }

    private boolean maybeStartConsumer(Set<TopicPartition> tierTopicPartitions, long consumeFromTimestamp) {
        if (!this.getConsumerAndAssignPartitions(tierTopicPartitions)) {
            return false;
        }
        Map tierTopicPartitionAndTimestamp = tierTopicPartitions.stream().distinct().collect(Collectors.toMap(Function.identity(), tp -> consumeFromTimestamp));
        this.log.info("Starting consumer from {} for {}", (Object)consumeFromTimestamp, tierTopicPartitions);
        this.consumer.offsetsForTimes(tierTopicPartitionAndTimestamp).forEach((tp, offsetAndTimestamp) -> this.consumer.seek(tp, offsetAndTimestamp == null ? 0L : offsetAndTimestamp.offset()));
        return true;
    }

    @Override
    boolean getConsumerAndAssignPartitions(Set<TopicPartition> partitions) {
        if (this.active() || partitions.isEmpty() || this.tierTopicPartitionsAndEndOffsets != null) {
            return false;
        }
        this.consumer = TierTopicUtils.getConsumerWithRetries(this.consumerSupplier, this.shouldStopRetryingConsumerCreation, this.time);
        this.consumer.assign(partitions);
        this.tierTopicPartitionsAndEndOffsets = this.consumer.endOffsets(partitions);
        return true;
    }
}

