/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic.recovery;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import java.util.Objects;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.topic.recovery.ReconciledTierTopicHeadDataLossReport;

public class ReconciledTierTopicPartitionInfo {
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();
    private final long maxLastMaterializedOffset;
    private final TopicIdPartition maxLastMaterializedUserPartition;
    private final int maxLastMaterializedReplicaId;
    private final OffsetAndEpoch minTierTopicEndOffsetAndEpoch;
    private final TopicIdPartition minTierTopicEndOffsetAndEpochUserPartition;
    private final int minTierTopicEndOffsetAndEpochReplicaId;

    public ReconciledTierTopicPartitionInfo(@JsonProperty(value="max_last_materialized_offset", required=true) long maxLastMaterializedOffset, @JsonProperty(value="max_last_materialized_user_partition", required=true) TopicIdPartition maxLastMaterializedUserPartition, @JsonProperty(value="max_last_materialized_replica_id", required=true) int maxLastMaterializedReplicaId, @JsonProperty(value="min_tier_topic_end_offset_and_epoch", required=true) OffsetAndEpoch minTierTopicEndOffsetAndEpoch, @JsonProperty(value="min_tier_topic_end_offset_and_epoch_user_partition", required=true) TopicIdPartition minTierTopicEndOffsetAndEpochUserPartition, @JsonProperty(value="min_tier_topic_end_offset_and_epoch_replica_id", required=true) int minTierTopicEndOffsetAndEpochReplicaId) {
        this.maxLastMaterializedOffset = maxLastMaterializedOffset;
        this.maxLastMaterializedUserPartition = maxLastMaterializedUserPartition;
        this.maxLastMaterializedReplicaId = maxLastMaterializedReplicaId;
        this.minTierTopicEndOffsetAndEpoch = minTierTopicEndOffsetAndEpoch;
        this.minTierTopicEndOffsetAndEpochUserPartition = minTierTopicEndOffsetAndEpochUserPartition;
        this.minTierTopicEndOffsetAndEpochReplicaId = minTierTopicEndOffsetAndEpochReplicaId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReconciledTierTopicPartitionInfo that = (ReconciledTierTopicPartitionInfo)o;
        return Objects.equals(this.maxLastMaterializedOffset, that.maxLastMaterializedOffset) && Objects.equals(this.maxLastMaterializedUserPartition, that.maxLastMaterializedUserPartition) && this.maxLastMaterializedReplicaId == that.maxLastMaterializedReplicaId && Objects.equals(this.minTierTopicEndOffsetAndEpoch, that.minTierTopicEndOffsetAndEpoch) && Objects.equals(this.minTierTopicEndOffsetAndEpochUserPartition, that.minTierTopicEndOffsetAndEpochUserPartition) && this.minTierTopicEndOffsetAndEpochReplicaId == that.minTierTopicEndOffsetAndEpochReplicaId;
    }

    public int hashCode() {
        return Objects.hash(this.maxLastMaterializedOffset, this.maxLastMaterializedUserPartition, this.maxLastMaterializedReplicaId, this.minTierTopicEndOffsetAndEpoch, this.minTierTopicEndOffsetAndEpochUserPartition, this.minTierTopicEndOffsetAndEpochReplicaId);
    }

    public String toString() {
        try {
            return "ReconciledTierTopicPartitionInfo: " + ReconciledTierTopicPartitionInfo.getJsonPrettyString(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonProperty(value="max_last_materialized_offset", required=true)
    public long maxLastMaterializedOffset() {
        return this.maxLastMaterializedOffset;
    }

    @JsonProperty(value="max_last_materialized_user_partition", required=true)
    public TopicIdPartition maxLastMaterializedUserPartition() {
        return this.maxLastMaterializedUserPartition;
    }

    @JsonProperty(value="max_last_materialized_replica_id", required=true)
    public int maxLastMaterializedReplicaId() {
        return this.maxLastMaterializedReplicaId;
    }

    @JsonProperty(value="min_tier_topic_end_offset_and_epoch", required=true)
    public OffsetAndEpoch minTierTopicEndOffsetAndEpoch() {
        return this.minTierTopicEndOffsetAndEpoch;
    }

    @JsonProperty(value="min_tier_topic_end_offset_and_epoch_user_partition", required=true)
    public TopicIdPartition minTierTopicEndOffsetAndEpochUserPartition() {
        return this.minTierTopicEndOffsetAndEpochUserPartition;
    }

    @JsonProperty(value="min_tier_topic_end_offset_and_epoch_replica_id", required=true)
    public int minTierTopicEndOffsetAndEpochReplicaId() {
        return this.minTierTopicEndOffsetAndEpochReplicaId;
    }

    public static String getJsonString(ReconciledTierTopicHeadDataLossReport report) throws JsonProcessingException {
        return JSON_SERDE.writeValueAsString(report);
    }

    public static String getJsonPrettyString(ReconciledTierTopicPartitionInfo info) throws JsonProcessingException {
        return JSON_SERDE.writerWithDefaultPrettyPrinter().writeValueAsString(info);
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(TopicIdPartition.class, new JsonSerializer<TopicIdPartition>(){

            @Override
            public void serialize(TopicIdPartition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(value.toString());
            }
        });
        module.addDeserializer(TopicIdPartition.class, new JsonDeserializer<TopicIdPartition>(){

            @Override
            public TopicIdPartition deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                return TopicIdPartition.fromString(p.getValueAsString());
            }
        });
        JSON_SERDE.registerModules(module, new Jdk8Module());
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

