/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.context;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Immutable
public final class QueryContext {
    private static final String DELIMITER = "/";
    private final ImmutableList<String> context;

    private QueryContext() {
        this(Collections.emptyList());
    }

    private QueryContext(List<String> context) {
        this.context = ImmutableList.copyOf((Collection)Objects.requireNonNull(context));
        for (String frame : context) {
            if (!frame.contains(DELIMITER)) continue;
            throw new IllegalArgumentException("Cannot use string with delimiter in context");
        }
    }

    @JsonCreator
    private QueryContext(String context) {
        this((List<String>)ImmutableList.copyOf((Object[])context.split(DELIMITER)));
    }

    @JsonIgnore
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="context is ImmutableList")
    public List<String> getContext() {
        return this.context;
    }

    @JsonValue
    public String formatContext() {
        return String.join((CharSequence)DELIMITER, this.context);
    }

    public String toString() {
        return this.formatContext();
    }

    private QueryContext push(String ... context) {
        return new QueryContext((List<String>)new ImmutableList.Builder().addAll(this.context).addAll(Arrays.asList(context)).build());
    }

    public boolean equals(Object o) {
        return o instanceof QueryContext && Objects.equals(this.context, ((QueryContext)o).context);
    }

    public int hashCode() {
        return Objects.hash(this.context);
    }

    public static class Stacker {
        final QueryContext queryContext;

        public Stacker() {
            this.queryContext = new QueryContext();
        }

        public static Stacker of(QueryContext queryContext) {
            return new Stacker(queryContext);
        }

        private Stacker(QueryContext queryContext) {
            this.queryContext = Objects.requireNonNull(queryContext);
        }

        public Stacker push(String ... context) {
            return new Stacker(this.queryContext.push(context));
        }

        public QueryContext getQueryContext() {
            return this.queryContext;
        }

        public boolean equals(Object o) {
            return o instanceof Stacker && Objects.equals(this.queryContext, ((Stacker)o).queryContext);
        }

        public int hashCode() {
            return Objects.hash(this.queryContext);
        }
    }
}

