/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LambdaFunctionCall
extends Expression {
    private final ImmutableList<String> arguments;
    private final Expression body;

    public LambdaFunctionCall(List<String> name, Expression body) {
        this(Optional.empty(), name, body);
    }

    public LambdaFunctionCall(Optional<NodeLocation> location, List<String> arguments, Expression body) {
        super(location);
        this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments"));
        if (arguments.size() == 0) {
            throw new IllegalArgumentException(String.format("Lambda expression must have at least 1 argument. => %s", body.toString()));
        }
        HashSet<String> set = new HashSet<String>(arguments);
        if (set.size() < arguments.size()) {
            throw new IllegalArgumentException(String.format("Lambda arguments have duplicates: %s", arguments.toString()));
        }
        this.body = Objects.requireNonNull(body, "body is null");
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="arguments is ImmutableList")
    public List<String> getArguments() {
        return this.arguments;
    }

    public Expression getBody() {
        return this.body;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLambdaExpression(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LambdaFunctionCall that = (LambdaFunctionCall)((Object)obj);
        return Objects.equals(this.arguments, that.arguments) && Objects.equals((Object)this.body, (Object)that.body);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.arguments, this.body});
    }
}

