/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class LambdaVariable
extends Expression {
    private final String lambdaCharacter;

    public LambdaVariable(String lambdaCharacter) {
        this(Optional.empty(), lambdaCharacter);
    }

    public LambdaVariable(Optional<NodeLocation> location, String lambdaCharacter) {
        super(location);
        this.lambdaCharacter = lambdaCharacter;
    }

    public String getLambdaCharacter() {
        return this.lambdaCharacter;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLambdaVariable(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LambdaVariable that = (LambdaVariable)((Object)o);
        return this.lambdaCharacter.equals(that.lambdaCharacter);
    }

    public int hashCode() {
        return Objects.hashCode(this.lambdaCharacter);
    }
}

