/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class LikePredicate
extends Expression {
    private final Expression value;
    private final Expression pattern;
    private final Optional<Character> escape;

    public LikePredicate(Expression value, Expression pattern, Optional<Character> escape) {
        this(Optional.empty(), value, pattern, escape);
    }

    public LikePredicate(Optional<NodeLocation> location, Expression value, Expression pattern, Optional<Character> escape) {
        super(location);
        this.value = Objects.requireNonNull(value, "value");
        this.pattern = Objects.requireNonNull(pattern, "pattern");
        this.escape = Objects.requireNonNull(escape, "escape");
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getPattern() {
        return this.pattern;
    }

    public Optional<Character> getEscape() {
        return this.escape;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLikePredicate(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LikePredicate that = (LikePredicate)((Object)o);
        return Objects.equals((Object)this.value, (Object)that.value) && Objects.equals((Object)this.pattern, (Object)that.pattern) && Objects.equals(this.escape, that.escape);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.pattern, this.escape});
    }
}

