/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.NodeLocation;
import java.sql.Time;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class TimeLiteral
extends Literal {
    private final long value;

    public TimeLiteral(Time value) {
        this(Optional.empty(), value);
    }

    public TimeLiteral(Optional<NodeLocation> location, Time value) {
        super(location);
        this.value = Objects.requireNonNull(value, "value").getTime();
    }

    @Override
    public Time getValue() {
        return new Time(this.value);
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitTimeLiteral(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TimeLiteral that = (TimeLiteral)((Object)o);
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }
}

