/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class Type
extends Expression {
    private final SqlType sqlType;

    public Type(SqlType sqlType) {
        this(Optional.empty(), sqlType);
    }

    public Type(Optional<NodeLocation> location, SqlType sqlType) {
        super(location);
        this.sqlType = Objects.requireNonNull(sqlType, "sqlType");
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitType(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Type type = (Type)((Object)o);
        return Objects.equals(this.sqlType, type.sqlType);
    }

    public int hashCode() {
        return Objects.hash(this.sqlType);
    }
}

