/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function.udtf;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.function.KsqlTableFunction;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.RecordProcessingError;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Immutable
public class TableFunctionApplier {
    private final KsqlTableFunction tableFunction;
    private final ImmutableList<CompiledExpression> parameterExtractors;
    private final String nullMsg;
    private final String exceptionMsg;

    public TableFunctionApplier(KsqlTableFunction tableFunction, List<CompiledExpression> parameterExtractors) {
        this.tableFunction = Objects.requireNonNull(tableFunction);
        this.parameterExtractors = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameterExtractors));
        this.nullMsg = "Table function " + tableFunction.name().text() + " returned null. This is invalid. Table functions should always return a valid list.";
        this.exceptionMsg = "Table function " + tableFunction.name().text() + " threw an exception";
    }

    List<?> apply(GenericRow row, ProcessingLogger processingLogger) {
        Object[] args = new Object[this.parameterExtractors.size()];
        for (int i = 0; i < this.parameterExtractors.size(); ++i) {
            args[i] = this.evalParam(row, processingLogger, i);
        }
        try {
            List result = this.tableFunction.apply(args);
            if (result == null) {
                processingLogger.error(RecordProcessingError.recordProcessingError(this.nullMsg, row));
                return ImmutableList.of();
            }
            return result;
        }
        catch (Exception e) {
            processingLogger.error(RecordProcessingError.recordProcessingError(this.exceptionMsg, (Throwable)e, row));
            return ImmutableList.of();
        }
    }

    private Object evalParam(GenericRow row, ProcessingLogger processingLogger, int idx) {
        return ((CompiledExpression)this.parameterExtractors.get(idx)).evaluate(row, null, processingLogger, () -> "Failed to evaluate table function parameter " + idx);
    }
}

