/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter;

import io.confluent.ksql.execution.codegen.helpers.CastEvaluator;
import io.confluent.ksql.execution.interpreter.terms.CastTerm;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.SqlBooleans;
import io.confluent.ksql.schema.ksql.SqlDoubles;
import io.confluent.ksql.schema.ksql.SqlTimeTypes;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class CastInterpreter {
    private CastInterpreter() {
    }

    public static CastTerm cast(Term term, SqlType from, SqlType to, KsqlConfig config) {
        return new CastTerm(term, to, CastInterpreter.castFunction(from, to, config));
    }

    private static CastTerm.CastFunction castFunction(SqlType from, SqlType to, KsqlConfig config) {
        SqlBaseType toBaseType = to.baseType();
        if (toBaseType == SqlBaseType.INTEGER) {
            return CastInterpreter.castToIntegerFunction(from);
        }
        if (toBaseType == SqlBaseType.BIGINT) {
            return CastInterpreter.castToLongFunction(from);
        }
        if (toBaseType == SqlBaseType.DOUBLE) {
            return CastInterpreter.castToDoubleFunction(from);
        }
        if (toBaseType == SqlBaseType.DECIMAL) {
            return CastInterpreter.castToBigDecimalFunction(from, to);
        }
        if (toBaseType == SqlBaseType.STRING) {
            return CastInterpreter.castToStringFunction(from, config);
        }
        if (toBaseType == SqlBaseType.BOOLEAN) {
            return CastInterpreter.castToBooleanFunction(from);
        }
        if (toBaseType == SqlBaseType.TIMESTAMP) {
            return CastInterpreter.castToTimestampFunction(from);
        }
        if (toBaseType == SqlBaseType.DATE) {
            return CastInterpreter.castToDateFunction(from);
        }
        if (toBaseType == SqlBaseType.TIME) {
            return CastInterpreter.castToTimeFunction(from);
        }
        if (toBaseType == SqlBaseType.ARRAY) {
            return CastInterpreter.castToArrayFunction(from, to, config);
        }
        if (toBaseType == SqlBaseType.MAP) {
            return CastInterpreter.castToMapFunction(from, to, config);
        }
        if (toBaseType == SqlBaseType.BYTES) {
            return CastInterpreter.castToBytesFunction(from);
        }
        throw new KsqlException("Unsupported cast from " + String.valueOf(from) + " to " + String.valueOf(to));
    }

    public static CastTerm.ComparableCastFunction<Integer> castToIntegerFunction(SqlType from) {
        switch (from.baseType()) {
            case STRING: {
                return object -> Integer.parseInt(((String)object).trim());
            }
            case DECIMAL: {
                return object -> ((BigDecimal)object).intValue();
            }
            case DOUBLE: {
                return object -> ((Double)object).intValue();
            }
            case INTEGER: {
                return object -> (Integer)object;
            }
            case BIGINT: {
                return object -> ((Long)object).intValue();
            }
        }
        throw new KsqlException(CastInterpreter.getErrorMessage(from, (SqlType)SqlTypes.INTEGER));
    }

    public static CastTerm.ComparableCastFunction<Double> castToDoubleFunction(SqlType from) {
        switch (from.baseType()) {
            case STRING: {
                return object -> SqlDoubles.parseDouble((String)((String)object).trim());
            }
            case DECIMAL: {
                return object -> ((BigDecimal)object).doubleValue();
            }
            case DOUBLE: {
                return object -> (Double)object;
            }
            case INTEGER: {
                return object -> ((Integer)object).doubleValue();
            }
            case BIGINT: {
                return object -> ((Long)object).doubleValue();
            }
        }
        throw new KsqlException(CastInterpreter.getErrorMessage(from, (SqlType)SqlTypes.DOUBLE));
    }

    public static CastTerm.ComparableCastFunction<Long> castToLongFunction(SqlType from) {
        switch (from.baseType()) {
            case STRING: {
                return object -> Long.parseLong(((String)object).trim());
            }
            case DECIMAL: {
                return object -> ((BigDecimal)object).longValue();
            }
            case DOUBLE: {
                return object -> ((Double)object).longValue();
            }
            case INTEGER: {
                return object -> ((Integer)object).longValue();
            }
            case BIGINT: {
                return object -> (Long)object;
            }
        }
        throw new KsqlException(CastInterpreter.getErrorMessage(from, (SqlType)SqlTypes.BIGINT));
    }

    public static CastTerm.CastFunction castToBigDecimalFunction(SqlType from, SqlType to) {
        SqlDecimal sqlDecimal = (SqlDecimal)to;
        switch (from.baseType()) {
            case INTEGER: {
                return object -> DecimalUtil.cast((Integer)((Integer)object), (int)sqlDecimal.getPrecision(), (int)sqlDecimal.getScale());
            }
            case BIGINT: {
                return object -> DecimalUtil.cast((Long)((Long)object), (int)sqlDecimal.getPrecision(), (int)sqlDecimal.getScale());
            }
            case DOUBLE: {
                return object -> DecimalUtil.cast((Double)((Double)object), (int)sqlDecimal.getPrecision(), (int)sqlDecimal.getScale());
            }
            case DECIMAL: {
                return object -> DecimalUtil.cast((BigDecimal)((BigDecimal)object), (int)sqlDecimal.getPrecision(), (int)sqlDecimal.getScale());
            }
            case STRING: {
                return object -> DecimalUtil.cast((String)((String)object), (int)sqlDecimal.getPrecision(), (int)sqlDecimal.getScale());
            }
        }
        throw new KsqlException(String.format("Unsupported cast between %s and %s", from, SqlBaseType.DECIMAL));
    }

    public static CastTerm.ComparableCastFunction<BigDecimal> castToBigDecimalFunction(SqlType from) {
        switch (from.baseType()) {
            case DECIMAL: {
                return object -> (BigDecimal)object;
            }
            case DOUBLE: {
                return object -> BigDecimal.valueOf((Double)object);
            }
            case INTEGER: {
                return object -> new BigDecimal((Integer)object);
            }
            case BIGINT: {
                return object -> new BigDecimal((Long)object);
            }
            case STRING: {
                return object -> new BigDecimal((String)object);
            }
        }
        throw new KsqlException(String.format("Unsupported cast between %s and %s", from, SqlBaseType.DECIMAL));
    }

    public static CastTerm.CastFunction castToStringFunction(SqlType from, KsqlConfig config) {
        if (from.baseType() == SqlBaseType.DECIMAL) {
            return object -> ((BigDecimal)object).toPlainString();
        }
        if (from.baseType() == SqlBaseType.TIMESTAMP) {
            return object -> SqlTimeTypes.formatTimestamp((Timestamp)((Timestamp)object));
        }
        if (from.baseType() == SqlBaseType.BYTES) {
            throw new KsqlException(CastInterpreter.getErrorMessage((SqlType)SqlTypes.BYTES, (SqlType)SqlTypes.STRING));
        }
        return object -> config.getBoolean("ksql.cast.strings.preserve.nulls") != false ? Objects.toString(object, null) : String.valueOf(object);
    }

    public static CastTerm.CastFunction castToBooleanFunction(SqlType from) {
        if (from.baseType() == SqlBaseType.STRING) {
            return object -> SqlBooleans.parseBoolean((String)((String)object).trim());
        }
        if (from.baseType() == SqlBaseType.BOOLEAN) {
            return object -> object;
        }
        throw new KsqlException("Unsupported cast to BOOLEAN: " + String.valueOf(from));
    }

    public static CastTerm.ComparableCastFunction<java.util.Date> castToTimestampFunction(SqlType from) {
        if (from.baseType() == SqlBaseType.STRING) {
            return object -> SqlTimeTypes.parseTimestamp((String)((String)object).trim());
        }
        if (from.baseType() == SqlBaseType.TIMESTAMP) {
            return object -> (Timestamp)object;
        }
        if (from.baseType() == SqlBaseType.DATE) {
            return object -> new Timestamp(((Date)object).getTime());
        }
        throw new KsqlException(CastInterpreter.getErrorMessage(from, (SqlType)SqlTypes.TIMESTAMP));
    }

    public static CastTerm.ComparableCastFunction<java.util.Date> castToTimeFunction(SqlType from) {
        if (from.baseType() == SqlBaseType.STRING) {
            return object -> SqlTimeTypes.parseTime((String)((String)object).trim());
        }
        if (from.baseType() == SqlBaseType.TIME) {
            return object -> (Time)object;
        }
        if (from.baseType() == SqlBaseType.TIMESTAMP) {
            return object -> SqlTimeTypes.timestampToTime((Timestamp)((Timestamp)object));
        }
        throw new KsqlException(CastInterpreter.getErrorMessage(from, (SqlType)SqlTypes.TIME));
    }

    public static CastTerm.ComparableCastFunction<java.util.Date> castToDateFunction(SqlType from) {
        if (from.baseType() == SqlBaseType.STRING) {
            return object -> SqlTimeTypes.parseDate((String)((String)object).trim());
        }
        if (from.baseType() == SqlBaseType.DATE) {
            return object -> (Date)object;
        }
        if (from.baseType() == SqlBaseType.TIMESTAMP) {
            return object -> SqlTimeTypes.timestampToDate((Timestamp)((Timestamp)object));
        }
        throw new KsqlException(CastInterpreter.getErrorMessage(from, (SqlType)SqlTypes.DATE));
    }

    public static CastTerm.ComparableCastFunction<ByteBuffer> castToBytesFunction(SqlType from) {
        if (from.baseType() == SqlBaseType.BYTES) {
            return object -> (ByteBuffer)object;
        }
        throw new KsqlException(CastInterpreter.getErrorMessage(from, (SqlType)SqlTypes.BYTES));
    }

    public static CastTerm.CastFunction castToArrayFunction(SqlType from, SqlType to, KsqlConfig config) {
        if (from.baseType() == SqlBaseType.ARRAY && to.baseType() == SqlBaseType.ARRAY) {
            SqlArray fromArray = (SqlArray)from;
            SqlArray toArray = (SqlArray)to;
            CastTerm.CastFunction itemCastFunction = CastInterpreter.castFunction(fromArray.getItemType(), toArray.getItemType(), config);
            return o -> CastEvaluator.castArray((List)o, itemCastFunction::cast);
        }
        throw new KsqlException(CastInterpreter.getErrorMessage(from, to));
    }

    public static CastTerm.CastFunction castToMapFunction(SqlType from, SqlType to, KsqlConfig config) {
        if (from.baseType() == SqlBaseType.MAP && to.baseType() == SqlBaseType.MAP) {
            SqlMap fromMap = (SqlMap)from;
            SqlMap toMap = (SqlMap)to;
            CastTerm.CastFunction keyCastFunction = CastInterpreter.castFunction(fromMap.getKeyType(), toMap.getKeyType(), config);
            CastTerm.CastFunction valueCastFunction = CastInterpreter.castFunction(fromMap.getValueType(), toMap.getValueType(), config);
            return o -> CastEvaluator.castMap((Map)o, keyCastFunction::cast, valueCastFunction::cast);
        }
        throw new KsqlException("Unsupported cast to " + String.valueOf(to) + ": " + String.valueOf(from));
    }

    private static String getErrorMessage(SqlType from, SqlType to) {
        return String.format("Unsupported cast from %s to %s", from, to);
    }
}

