/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import io.confluent.ksql.execution.expression.tree.LogicalBinaryExpression;
import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.KsqlException;

public final class LogicalBinaryTerms {
    private LogicalBinaryTerms() {
    }

    public static Term create(LogicalBinaryExpression.Type type, Term left, Term right) {
        switch (type) {
            case OR: {
                return new OrTerm(left, right);
            }
            case AND: {
                return new AndTerm(left, right);
            }
        }
        throw new KsqlException("Unknown type " + String.valueOf((Object)type));
    }

    public static class OrTerm
    implements Term {
        private final Term left;
        private final Term right;

        public OrTerm(Term left, Term right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return (Boolean)this.left.getValue(context) != false || (Boolean)this.right.getValue(context) != false;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.BOOLEAN;
        }
    }

    public static class AndTerm
    implements Term {
        private final Term left;
        private final Term right;

        public AndTerm(Term left, Term right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return (Boolean)this.left.getValue(context) != false && (Boolean)this.right.getValue(context) != false;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.BOOLEAN;
        }
    }
}

