/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.codegen.helpers.SearchedCaseFunction;
import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.Pair;
import java.util.List;
import java.util.Optional;

public class SearchedCaseTerm
implements Term {
    private final List<Pair<Term, Term>> operandResultTerms;
    private final Optional<Term> defaultValue;
    private final SqlType resultType;

    public SearchedCaseTerm(List<Pair<Term, Term>> operandResultTerms, Optional<Term> defaultValue, SqlType resultType) {
        this.operandResultTerms = ImmutableList.copyOf(operandResultTerms);
        this.defaultValue = defaultValue;
        this.resultType = resultType;
    }

    @Override
    public Object getValue(TermEvaluationContext context) {
        List lazyWhenClause = (List)this.operandResultTerms.stream().map(pair -> SearchedCaseFunction.whenClause(() -> (Boolean)((Term)pair.getLeft()).getValue(context), () -> ((Term)pair.getRight()).getValue(context))).collect(ImmutableList.toImmutableList());
        return SearchedCaseFunction.searchedCaseFunction(lazyWhenClause, () -> this.defaultValue.map(term -> term.getValue(context)).orElse(null));
    }

    @Override
    public SqlType getSqlType() {
        return this.resultType;
    }
}

