/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.materialization;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Immutable
public final class MaterializationInfo {
    private final String stateStoreName;
    private final LogicalSchema stateStoreSchema;
    private final ImmutableList<TransformInfo> transforms;
    private final LogicalSchema schema;

    public String stateStoreName() {
        return this.stateStoreName;
    }

    public LogicalSchema getStateStoreSchema() {
        return this.stateStoreSchema;
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="transforms is ImmutableList")
    public List<TransformInfo> getTransforms() {
        return this.transforms;
    }

    private MaterializationInfo(String stateStoreName, LogicalSchema stateStoreSchema, List<TransformInfo> transforms, LogicalSchema schema) {
        this.stateStoreName = Objects.requireNonNull(stateStoreName, "stateStoreName");
        this.stateStoreSchema = Objects.requireNonNull(stateStoreSchema, "stateStoreSchema");
        this.transforms = ImmutableList.copyOf((Collection)Objects.requireNonNull(transforms, "transforms"));
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    public static Builder builder(String stateStoreName, LogicalSchema stateStoreSchema) {
        return new Builder(stateStoreName, stateStoreSchema);
    }

    public static final class Builder {
        private final String stateStoreName;
        private final LogicalSchema stateStoreSchema;
        private final List<TransformInfo> transforms;
        private LogicalSchema schema;

        private Builder(String stateStoreName, LogicalSchema stateStoreSchema) {
            this.stateStoreName = Objects.requireNonNull(stateStoreName, "stateStoreName");
            this.stateStoreSchema = Objects.requireNonNull(stateStoreSchema, "stateStoreSchema");
            this.transforms = new LinkedList<TransformInfo>();
            this.schema = stateStoreSchema;
        }

        public Builder map(TransformFactory<KsqlTransformer<Object, GenericRow>> mapperFactory, LogicalSchema resultSchema, QueryContext queryContext) {
            this.transforms.add(new MapperInfo(mapperFactory, queryContext));
            this.schema = Objects.requireNonNull(resultSchema, "resultSchema");
            return this;
        }

        public Builder filter(TransformFactory<KsqlTransformer<Object, Optional<GenericRow>>> predicateFactory, QueryContext queryContext) {
            this.transforms.add(new PredicateInfo(predicateFactory, queryContext));
            return this;
        }

        public MaterializationInfo build() {
            return new MaterializationInfo(this.stateStoreName, this.stateStoreSchema, this.transforms, this.schema);
        }
    }

    public static class PredicateInfo
    implements TransformInfo {
        private final TransformFactory<KsqlTransformer<Object, Optional<GenericRow>>> predicate;
        private final QueryContext queryContext;

        PredicateInfo(TransformFactory<KsqlTransformer<Object, Optional<GenericRow>>> predicate, QueryContext queryContext) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            this.queryContext = Objects.requireNonNull(queryContext, "queryContext");
        }

        public KsqlTransformer<Object, Optional<GenericRow>> getPredicate(Function<QueryContext, ProcessingLogger> loggerFactory) {
            return this.predicate.apply(loggerFactory.apply(this.queryContext));
        }

        @Override
        public <R> R visit(TransformVisitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static class MapperInfo
    implements TransformInfo {
        private final TransformFactory<KsqlTransformer<Object, GenericRow>> mapperFactory;
        private final QueryContext queryContext;

        MapperInfo(TransformFactory<KsqlTransformer<Object, GenericRow>> mapperFactory, QueryContext queryContext) {
            this.mapperFactory = Objects.requireNonNull(mapperFactory, "mapperFactory");
            this.queryContext = Objects.requireNonNull(queryContext, "queryContext");
        }

        public KsqlTransformer<Object, GenericRow> getMapper(Function<QueryContext, ProcessingLogger> loggerFactory) {
            return this.mapperFactory.apply(loggerFactory.apply(this.queryContext));
        }

        @Override
        public <R> R visit(TransformVisitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static interface TransformFactory<T> {
        public T apply(ProcessingLogger var1);
    }

    public static interface TransformVisitor<R> {
        public R visit(MapperInfo var1);

        public R visit(PredicateInfo var1);
    }

    @EffectivelyImmutable
    public static interface TransformInfo {
        public <R> R visit(TransformVisitor<R> var1);
    }
}

