/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
public final class Formats {
    private final FormatInfo keyFormat;
    private final FormatInfo valueFormat;
    private final SerdeFeatures keyFeatures;
    private final SerdeFeatures valueFeatures;

    public static Formats of(FormatInfo keyFormat, FormatInfo valueFormat, SerdeFeatures keyFeatures, SerdeFeatures valFeatures) {
        return new Formats(keyFormat, valueFormat, keyFeatures, valFeatures);
    }

    public static Formats from(KsqlTopic topic) {
        return Formats.of(topic.getKeyFormat().getFormatInfo(), topic.getValueFormat().getFormatInfo(), topic.getKeyFormat().getFeatures(), topic.getValueFormat().getFeatures());
    }

    @JsonCreator
    static Formats from(@JsonProperty(value="keyFormat", required=true) FormatInfo keyFormat, @JsonProperty(value="valueFormat", required=true) FormatInfo valueFormat, @JsonProperty(value="keyFeatures") Optional<SerdeFeatures> keyFeatures, @JsonProperty(value="valueFeatures") Optional<SerdeFeatures> valueFeatures, @JsonProperty(value="options") Optional<Set<LegacyOption>> legacyOptions) {
        return Formats.of(keyFormat, valueFormat, keyFeatures.orElseGet(() -> SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0])), valueFeatures.orElseGet(() -> Formats.handleLegacy(legacyOptions)));
    }

    private Formats(FormatInfo keyFormat, FormatInfo valueFormat, SerdeFeatures keyFeatures, SerdeFeatures valueFeatures) {
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
        this.keyFeatures = Objects.requireNonNull(keyFeatures, "keyFeatures");
        this.valueFeatures = Objects.requireNonNull(valueFeatures, "valueFeatures");
    }

    public FormatInfo getKeyFormat() {
        return this.keyFormat;
    }

    public FormatInfo getValueFormat() {
        return this.valueFormat;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=SerdeFeatures.NOT_EMPTY.class)
    public SerdeFeatures getKeyFeatures() {
        return this.keyFeatures;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=SerdeFeatures.NOT_EMPTY.class)
    public SerdeFeatures getValueFeatures() {
        return this.valueFeatures;
    }

    @Deprecated
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Set<LegacyOption> getOptions() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Formats formats = (Formats)o;
        return Objects.equals(this.keyFormat, formats.keyFormat) && Objects.equals(this.valueFormat, formats.valueFormat) && Objects.equals(this.keyFeatures, formats.keyFeatures) && Objects.equals(this.valueFeatures, formats.valueFeatures);
    }

    public int hashCode() {
        return Objects.hash(this.keyFormat, this.valueFormat, this.keyFeatures, this.valueFeatures);
    }

    private static SerdeFeatures handleLegacy(Optional<Set<LegacyOption>> possibleLegacyOptions) {
        if (!possibleLegacyOptions.isPresent()) {
            return SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]);
        }
        Set<LegacyOption> legacyOptions = possibleLegacyOptions.get();
        if (legacyOptions.isEmpty()) {
            return SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]);
        }
        if (legacyOptions.size() != 1) {
            throw new IllegalArgumentException("Invalid legacy options: " + String.valueOf(legacyOptions));
        }
        return legacyOptions.iterator().next() == LegacyOption.WRAP_SINGLE_VALUES ? SerdeFeatures.of((SerdeFeature[])new SerdeFeature[]{SerdeFeature.WRAP_SINGLES}) : SerdeFeatures.of((SerdeFeature[])new SerdeFeature[]{SerdeFeature.UNWRAP_SINGLES});
    }

    private static enum LegacyOption {
        WRAP_SINGLE_VALUES,
        UNWRAP_SINGLE_VALUES;

    }
}

