/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.runtime;

import io.confluent.ksql.GenericRow;
import java.time.Duration;
import java.util.Optional;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.processor.StateStore;

public class MaterializedFactory {
    private <K, S extends StateStore> Materialized<K, GenericRow, S> create(Serde<K> keySerde, Serde<GenericRow> valSerde, Optional<String> name, Optional<Duration> retention) {
        Materialized materialized = name.isPresent() ? Materialized.as((String)name.get()).withKeySerde(keySerde).withValueSerde(valSerde) : Materialized.with(keySerde, valSerde);
        retention.ifPresent(arg_0 -> ((Materialized)materialized).withRetention(arg_0));
        return materialized;
    }

    public <K, S extends StateStore> Materialized<K, GenericRow, S> create(Serde<K> keySerde, Serde<GenericRow> valSerde, String name, Duration retention) {
        return this.create(keySerde, valSerde, Optional.of(name), Optional.of(retention));
    }

    public <K, S extends StateStore> Materialized<K, GenericRow, S> create(Serde<K> keySerde, Serde<GenericRow> valSerde, String name, Optional<Duration> retention) {
        return this.create(keySerde, valSerde, Optional.of(name), retention);
    }

    public <K, S extends StateStore> Materialized<K, GenericRow, S> create(Serde<K> keySerde, Serde<GenericRow> valSerde, String name) {
        return this.create(keySerde, valSerde, Optional.of(name), Optional.empty());
    }

    public <K, S extends StateStore> Materialized<K, GenericRow, S> create(Serde<K> keySerde, Serde<GenericRow> valSerde) {
        return this.create(keySerde, valSerde, Optional.empty(), Optional.empty());
    }
}

