/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.transform;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public class KsqlFlatTransformer<K, R>
implements KsqlTransformer<K, Iterable<R>> {
    private final KsqlTransformer<K, Optional<R>> delegate;

    public KsqlFlatTransformer(KsqlTransformer<K, Optional<R>> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public Iterable<R> transform(K readOnlyKey, GenericRow value) {
        Optional<R> result = this.delegate.transform(readOnlyKey, value);
        return result.map(Collections::singletonList).orElse(Collections.emptyList());
    }
}

