/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.confluent.ksql.execution.expression.tree.DereferenceExpression;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.ColumnAliasGenerator;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ColumnNames {
    private static final String AGGREGATE_COLUMN_PREFIX = "KSQL_AGG_VARIABLE_";
    private static final String GENERATED_ALIAS_PREFIX = "KSQL_COL";
    private static final String SYNTHESISED_COLUMN_PREFIX = "KSQL_SYNTH_";
    private static final String SYNTHETIC_JOIN_KEY_COLUMN_PRIFIX = "ROWKEY";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final Pattern NUMBERED_COLUMN_PATTERN = Pattern.compile("(?<name>.*?)?(?:_(?<number>\\d+))?");

    private ColumnNames() {
    }

    public static ColumnName aggregateColumn(int idx) {
        return ColumnName.of((String)(AGGREGATE_COLUMN_PREFIX + idx));
    }

    public static ColumnAliasGenerator columnAliasGenerator(Stream<LogicalSchema> sourceSchemas) {
        final Map<String, AliasGenerator> used = ColumnNames.buildAliasGenerators(sourceSchemas);
        return new ColumnAliasGenerator(){
            final StructFieldAliasGenerator generator;
            {
                this.generator = new StructFieldAliasGenerator(used);
            }

            @Override
            public ColumnName nextKsqlColAlias() {
                return ((AliasGenerator)used.get(ColumnNames.GENERATED_ALIAS_PREFIX)).next();
            }

            @Override
            public ColumnName uniqueAliasFor(Expression expression) {
                return expression instanceof DereferenceExpression ? this.generator.next((DereferenceExpression)expression) : this.nextKsqlColAlias();
            }
        };
    }

    public static ColumnName uniqueAliasFor(Expression e, LogicalSchema ... schemas) {
        if (schemas.length == 0) {
            throw new IllegalArgumentException("At least once schema should be provided");
        }
        return ColumnNames.columnAliasGenerator(Arrays.stream(schemas)).uniqueAliasFor(e);
    }

    public static ColumnName nextKsqlColAlias(LogicalSchema ... schemas) {
        if (schemas.length == 0) {
            throw new IllegalArgumentException("At least once schema should be provided");
        }
        return ColumnNames.columnAliasGenerator(Arrays.stream(schemas)).nextKsqlColAlias();
    }

    public static ColumnName synthesisedSchemaColumn(int idx) {
        return ColumnName.of((String)(SYNTHESISED_COLUMN_PREFIX + idx));
    }

    public static ColumnName generatedJoinColumnAlias(SourceName sourceName, ColumnName ref) {
        return ColumnName.of((String)(sourceName.text() + "_" + ref.text()));
    }

    public static ColumnName generateSyntheticJoinKey(Stream<LogicalSchema> schemas) {
        AliasGenerator generator = ColumnNames.buildAliasGenerators(schemas).getOrDefault(SYNTHETIC_JOIN_KEY_COLUMN_PRIFIX, new AliasGenerator(0, SYNTHETIC_JOIN_KEY_COLUMN_PRIFIX, (Set<Integer>)ImmutableSet.of()));
        return generator.next();
    }

    public static boolean maybeSyntheticJoinKey(ColumnName columnName) {
        return columnName.text().startsWith(SYNTHETIC_JOIN_KEY_COLUMN_PRIFIX);
    }

    public static boolean isAggregate(ColumnName name) {
        return name.text().startsWith(AGGREGATE_COLUMN_PREFIX);
    }

    private static Map<String, AliasGenerator> buildAliasGenerators(Stream<LogicalSchema> sourceSchema) {
        Map<String, Set> used = sourceSchema.map(LogicalSchema::columns).flatMap(Collection::stream).map(Column::name).map(Name::text).map(NUMBERED_COLUMN_PATTERN::matcher).collect(Collectors.toMap(ColumnNames::columnNameWithoutNumber, ColumnNames::extractNumber, Sets::union));
        Map<String, AliasGenerator> generators = used.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new AliasGenerator(0, (String)e.getKey(), (Set)e.getValue())));
        generators.computeIfAbsent(GENERATED_ALIAS_PREFIX, k -> new AliasGenerator(0, (String)k, (Set<Integer>)ImmutableSet.of()));
        return generators;
    }

    private static String columnNameWithoutNumber(Matcher matcher) {
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        return matcher.group(NAME);
    }

    private static Set<Integer> extractNumber(Matcher matcher) {
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        String number = matcher.group(NUMBER);
        return number == null ? ImmutableSet.of((Object)0) : ImmutableSet.of((Object)Integer.parseInt(number));
    }

    @VisibleForTesting
    static final class AliasGenerator {
        private final Set<Integer> used;
        private final String prefix;
        private final boolean dropZero;
        private int next;

        AliasGenerator(int initial, String prefix, Set<Integer> used) {
            this.used = ImmutableSet.copyOf(used);
            this.next = initial;
            this.prefix = Objects.requireNonNull(prefix, "prefix");
            this.dropZero = !prefix.equals(ColumnNames.GENERATED_ALIAS_PREFIX);
        }

        ColumnName next() {
            int idx = this.nextIndex();
            return idx == 0 && this.dropZero ? ColumnName.of((String)this.prefix) : ColumnName.of((String)(this.prefix + "_" + idx));
        }

        private int nextIndex() {
            int idx;
            do {
                ++this.next;
                if (idx >= 0) continue;
                throw new KsqlException("Wow, you've managed to use up all possible generated aliases. Impressive! Please provide explicit aliases to some of your columns");
            } while (this.used.contains(idx));
            return idx;
        }
    }

    private static final class StructFieldAliasGenerator {
        private final Map<String, AliasGenerator> usedFieldNames;

        StructFieldAliasGenerator(Map<String, AliasGenerator> used) {
            this.usedFieldNames = new HashMap<String, AliasGenerator>(used);
        }

        ColumnName next(DereferenceExpression e) {
            String key = ColumnNames.columnNameWithoutNumber(NUMBERED_COLUMN_PATTERN.matcher(e.getFieldName()));
            AliasGenerator generator = this.usedFieldNames.computeIfAbsent(key, k -> new AliasGenerator(0, (String)k, (Set<Integer>)ImmutableSet.of()));
            return generator.next();
        }
    }
}

